/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.ui;

import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.internal.macros.BuildMacroProvider;
import org.eclipse.cdt.managedbuilder.internal.macros.DefaultMacroContextInfo;
import org.eclipse.cdt.managedbuilder.internal.macros.IMacroContextInfo;
import org.eclipse.cdt.managedbuilder.internal.ui.MacrosBlock;
import org.eclipse.cdt.managedbuilder.internal.ui.ManagedBuilderUIMessages;
import org.eclipse.cdt.managedbuilder.ui.properties.BuildPropertyPage;
import org.eclipse.cdt.ui.dialogs.AbstractCOptionPage;
import org.eclipse.cdt.ui.dialogs.ICOptionContainer;
import org.eclipse.cdt.ui.dialogs.ICOptionPage;
import org.eclipse.cdt.ui.dialogs.TabFolderOptionBlock;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class MacrosSetBlock
extends AbstractCOptionPage {
    private static final String PREFIX = "MacrosSetBlock";
    private static final String LABEL = "MacrosSetBlock.label";
    private static final String MACROS_LABEL = "MacrosSetBlock.label.macros";
    private static final String MACROS_GROUP_LABEL = "MacrosSetBlock.label.macros.group";
    private static final String TAB = "MacrosSetBlock.label.tab";
    private static final String TAB_CONFIGURATION = "MacrosSetBlock.label.tab.configuration";
    private static final String TAB_PROJECT = "MacrosSetBlock.label.tab.project";
    private static final String TAB_WORKSPACE = "MacrosSetBlock.label.tab.workspace";
    private static final String TAB_ECLIPSE = "MacrosSetBlock.label.tab.eclipse";
    private MacrosTabFolder fMacroTabs;
    private MacrosBlock fMacroBlock;
    private ICOptionContainer fParentContainer;
    private UIMacroProvider fMacroProvider;

    public MacrosSetBlock(ICOptionContainer parent) {
        super(ManagedBuilderUIMessages.getResourceString(MACROS_LABEL));
        super.setContainer(parent);
        this.fParentContainer = parent;
        if (this.fParentContainer instanceof BuildPropertyPage) {
            this.fMacroTabs = new MacrosTabFolder();
        } else {
            this.fMacroBlock = new MacrosBlock(this.fParentContainer, ManagedBuilderUIMessages.getResourceString(TAB_WORKSPACE), true, false);
            this.fMacroBlock.displayParentMacros(true);
        }
    }

    public void performApply(IProgressMonitor monitor) throws CoreException {
        MacrosBlock[] tabs = this.getAllBlocks();
        if (tabs != null) {
            int i = 0;
            while (i < tabs.length) {
                tabs[i].performApply(monitor);
                ++i;
            }
        }
    }

    public void performDefaults() {
        MacrosBlock tab = this.getSelectedBlock();
        if (tab != null) {
            tab.performDefaults();
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.updateValues();
        }
        if (this.fMacroTabs != null) {
            this.fMacroTabs.setVisible(visible);
        }
        super.setVisible(visible);
    }

    public void createControl(Composite parent) {
        Control ctrl = null;
        if (this.fMacroTabs != null) {
            Group group = new Group(parent, 0);
            group.setFont(parent.getFont());
            group.setText(ManagedBuilderUIMessages.getResourceString(MACROS_GROUP_LABEL));
            group.setLayoutData((Object)new GridData(1808));
            GridLayout gl = new GridLayout();
            gl.marginHeight = 0;
            gl.marginWidth = 0;
            group.setLayout((Layout)gl);
            Control tabs = this.fMacroTabs.createContents((Composite)group);
            GridData gd = new GridData(1808);
            tabs.setLayoutData((Object)gd);
            ctrl = group;
        } else if (this.fMacroBlock != null) {
            this.fMacroBlock.createControl(parent);
            ctrl = this.fMacroBlock.getControl();
            ctrl.setLayoutData((Object)new GridData(1808));
        }
        this.setControl(ctrl);
    }

    public void updateValues() {
        MacrosBlock tab = this.getSelectedBlock();
        this.updateContexts();
        if (tab != null) {
            tab.updateValues();
        }
    }

    public boolean isConfigSelectionAllowed() {
        MacrosBlock block = this.getSelectedBlock();
        if (block != null) {
            return block.getContextData() instanceof IConfiguration;
        }
        return false;
    }

    public boolean isModified() {
        MacrosBlock[] tabs = this.getAllBlocks();
        int i = 0;
        while (i < tabs.length) {
            if (tabs[i].isModified()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setModified(boolean modified) {
        MacrosBlock[] tabs = this.getAllBlocks();
        int i = 0;
        while (i < tabs.length) {
            tabs[i].setModified(modified);
            ++i;
        }
    }

    protected MacrosBlock getSelectedBlock() {
        if (this.fMacroTabs != null) {
            return (MacrosBlock)this.fMacroTabs.getCurrentPage();
        }
        return this.fMacroBlock;
    }

    protected MacrosBlock[] getAllBlocks() {
        if (this.fMacroTabs != null) {
            return this.fMacroTabs.getTabs();
        }
        if (this.fMacroBlock != null) {
            return new MacrosBlock[]{this.fMacroBlock};
        }
        return new MacrosBlock[0];
    }

    protected void updateContexts() {
        if (this.fMacroTabs != null) {
            this.fMacroTabs.updateContexts();
        } else if (this.fMacroBlock != null) {
            this.fMacroBlock.setContext(5, ResourcesPlugin.getWorkspace());
        }
    }

    public BuildMacroProvider getBuildMacroProvider() {
        if (this.fMacroProvider == null) {
            this.updateContexts();
            this.fMacroProvider = new UIMacroProvider();
        }
        return this.fMacroProvider;
    }

    private class UIMacroContextInfo
    extends DefaultMacroContextInfo {
        public UIMacroContextInfo(int type, Object data) {
            super(type, data);
        }

        public IMacroContextInfo getNext() {
            IMacroContextInfo info = super.getNext();
            if (info != null) {
                MacrosBlock[] blocks = MacrosSetBlock.this.getAllBlocks();
                int i = 0;
                while (i < blocks.length) {
                    if (blocks[i].getContextType() == info.getContextType() && blocks[i].getContextData() == info.getContextData()) {
                        return blocks[i].getContextInfo();
                    }
                    ++i;
                }
                return new UIMacroContextInfo(info.getContextType(), info.getContextData());
            }
            return null;
        }
    }

    private class UIMacroProvider
    extends BuildMacroProvider {
        UIMacroProvider() {
        }

        public IMacroContextInfo getMacroContextInfo(int contextType, Object contextData) {
            MacrosBlock[] blocks = MacrosSetBlock.this.getAllBlocks();
            int i = 0;
            while (i < blocks.length) {
                if (blocks[i].getContextType() == contextType && blocks[i].getContextData() == contextData) {
                    return blocks[i].getContextInfo();
                }
                ++i;
            }
            return new UIMacroContextInfo(contextType, contextData);
        }
    }

    private class MacrosTabFolder
    extends TabFolderOptionBlock {
        private MacrosBlock[] fFolderTabs;

        public MacrosTabFolder() {
            super(MacrosSetBlock.this.fParentContainer, false);
        }

        public MacrosBlock[] getTabs() {
            return this.fFolderTabs;
        }

        protected void addTabs() {
            if (MacrosSetBlock.this.fParentContainer instanceof BuildPropertyPage) {
                this.fFolderTabs = new MacrosBlock[2];
                this.fFolderTabs[0] = new MacrosBlock(MacrosSetBlock.this.fParentContainer, ManagedBuilderUIMessages.getResourceString(MacrosSetBlock.TAB_CONFIGURATION), true, true);
                this.addTab((ICOptionPage)this.fFolderTabs[0]);
                this.fFolderTabs[1] = new MacrosBlock(MacrosSetBlock.this.fParentContainer, ManagedBuilderUIMessages.getResourceString(MacrosSetBlock.TAB_PROJECT), true, true);
                this.addTab((ICOptionPage)this.fFolderTabs[1]);
            }
        }

        public void updateContexts() {
            if (this.fFolderTabs == null) {
                return;
            }
            if (MacrosSetBlock.this.fParentContainer instanceof BuildPropertyPage) {
                BuildPropertyPage page = (BuildPropertyPage)MacrosSetBlock.this.fParentContainer;
                if (page.getSelectedConfiguration() != null) {
                    this.fFolderTabs[1].setContext(4, page.getSelectedConfiguration().getManagedProject());
                }
                this.fFolderTabs[0].setContext(3, page.getSelectedConfiguration());
                this.fFolderTabs[0].setParentContextInfo(this.fFolderTabs[1].getContextInfo());
            }
        }

        public void setCurrentPage(ICOptionPage page) {
            ((MacrosBlock)page).updateValues();
            super.setCurrentPage(page);
        }
    }
}

