/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.ui;

import org.eclipse.cdt.managedbuilder.core.IAdditionalInput;
import org.eclipse.cdt.managedbuilder.core.IInputType;
import org.eclipse.cdt.managedbuilder.core.IOutputType;
import org.eclipse.cdt.managedbuilder.core.IResourceConfiguration;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.ui.ManagedBuilderUIMessages;
import org.eclipse.cdt.managedbuilder.internal.ui.ManagedBuilderUIPlugin;
import org.eclipse.cdt.managedbuilder.ui.properties.ResourceBuildPropertyPage;
import org.eclipse.cdt.ui.dialogs.AbstractCOptionPage;
import org.eclipse.cdt.ui.dialogs.ICOptionContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ResourceCustomBuildStepBlock
extends AbstractCOptionPage {
    private static final String PREFIX = "ResourceCustomBuildStepBlock";
    private static final String TIP = "ResourceCustomBuildStepBlock.tip";
    private static final String LABEL = "ResourceCustomBuildStepBlock.label";
    private static final String SETTINGS_LABEL = "ResourceCustomBuildStepBlock.label.settings";
    private static final String RCBS_TOOL_GROUP = "ResourceCustomBuildStepBlock.label.tool.group";
    private static final String RCBS_APPLICABILITY = "ResourceCustomBuildStepBlock.label.applicability";
    private static final String RCBS_BEFORE = "ResourceCustomBuildStepBlock.label.applicability.rule.before";
    private static final String RCBS_AFTER = "ResourceCustomBuildStepBlock.label.applicability.rule.after";
    private static final String RCBS_OVERRIDE = "ResourceCustomBuildStepBlock.label.applicability.rule.override";
    private static final String RCBS_DISABLE = "ResourceCustomBuildStepBlock.label.applicability.rule.disable";
    private static final String INPUT_FILENAMES = "ResourceCustomBuildStepBlock.label.input.filenames";
    private static final String OUTPUT_FILENAMES = "ResourceCustomBuildStepBlock.label.output.filenames";
    private static final String COMMAND_CMD = "ResourceCustomBuildStepBlock.label.command.cmd";
    private static final String DESCRIPTION_DESC = "ResourceCustomBuildStepBlock.label.description.desc";
    private static final String APPLICABILITY_TIP = "ResourceCustomBuildStepBlock.tip.applicability";
    private static final String INPUTS_TIP = "ResourceCustomBuildStepBlock.tip.inputs";
    private static final String OUTPUTS_TIP = "ResourceCustomBuildStepBlock.tip.outputs";
    private static final String COMMAND_TIP = "ResourceCustomBuildStepBlock.tip.command";
    private static final String ANNOUNCEMENT_TIP = "ResourceCustomBuildStepBlock.tip.announcement";
    private static final String CONFIRM_DEFAULT_TITLE = "ResourceCustomBuildStepBlock.defaults.title";
    private static final String CONFIRM_DEFAULT_MESSAGE = "ResourceCustomBuildStepBlock.defaults.message";
    private static final String[] rcbsApplicabilityRules = new String[]{new String(ManagedBuilderUIMessages.getResourceString("ResourceCustomBuildStepBlock.label.applicability.rule.override")), new String(ManagedBuilderUIMessages.getResourceString("ResourceCustomBuildStepBlock.label.applicability.rule.disable"))};
    private static final String EMPTY_STRING = new String();
    private static final String rcbsToolId = new String("org.eclipse.cdt.managedbuilder.ui.rcbs");
    private static final String rcbsToolName = new String("Resource Custom Build Step");
    private static final String rcbsToolInputTypeId = new String("org.eclipse.cdt.managedbuilder.ui.rcbs.inputtype");
    private static final String rcbsToolInputTypeName = new String("Resource Custom Build Step Input Type");
    private static final String rcbsToolOutputTypeId = new String("org.eclipse.cdt.managedbuilder.ui.rcbs.outputtype");
    private static final String rcbsToolOutputTypeName = new String("Resource Custom Build Step Output Type");
    protected Combo rcbsApplicabilitySelector;
    protected Text buildInputs;
    protected Text buildOutputs;
    protected Text buildCommand;
    protected Text buildDescription;
    private ResourceBuildPropertyPage resParent;
    private String resBuildInputs;
    private String resBuildOutputs;
    private String resBuildAnnouncement;
    private String resBuildCommand;
    private boolean dirty = false;
    private ModifyListener widgetModified = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            ResourceCustomBuildStepBlock.this.setDirty(true);
        }
    };

    public ResourceCustomBuildStepBlock(ResourceBuildPropertyPage resParent) {
        super(ManagedBuilderUIMessages.getResourceString(SETTINGS_LABEL));
        super.setContainer((ICOptionContainer)resParent);
        this.resParent = resParent;
    }

    public void createControl(Composite resParent) {
        Composite comp = new Composite(resParent, 0);
        comp.setFont(resParent.getFont());
        comp.setLayout((Layout)new GridLayout(1, true));
        comp.setLayoutData((Object)new GridData(1808));
        this.setControl((Control)comp);
        Group rcbsToolGroup = new Group(comp, 0);
        rcbsToolGroup.setFont(resParent.getFont());
        rcbsToolGroup.setText(ManagedBuilderUIMessages.getResourceString(RCBS_TOOL_GROUP));
        rcbsToolGroup.setLayout((Layout)new GridLayout(1, false));
        rcbsToolGroup.setLayoutData((Object)new GridData(768));
        this.createRcbsApplicabilityControl(rcbsToolGroup);
        this.createBuildInputControl(rcbsToolGroup);
        this.createBuildOutputControl(rcbsToolGroup);
        this.createBuildCommandControl(rcbsToolGroup);
        this.createCommandDescriptionControl(rcbsToolGroup);
    }

    private void createRcbsApplicabilityControl(Group rcbsApplicabilityGroup) {
        Label applicabilityLabel = new Label((Composite)rcbsApplicabilityGroup, 16384);
        applicabilityLabel.setFont(rcbsApplicabilityGroup.getFont());
        applicabilityLabel.setText(ManagedBuilderUIMessages.getResourceString(RCBS_APPLICABILITY));
        applicabilityLabel.setToolTipText(ManagedBuilderUIMessages.getResourceString(APPLICABILITY_TIP));
        applicabilityLabel.setLayoutData((Object)new GridData(768));
        this.rcbsApplicabilitySelector = new Combo((Composite)rcbsApplicabilityGroup, 2060);
        this.rcbsApplicabilitySelector.setFont(rcbsApplicabilityGroup.getFont());
        this.rcbsApplicabilitySelector.setItems(rcbsApplicabilityRules);
        int idx = this.rcbsApplicabilitySelector.indexOf(ManagedBuilderUIMessages.getResourceString(RCBS_OVERRIDE));
        this.rcbsApplicabilitySelector.select(idx);
        GridData gd1 = new GridData(768);
        gd1.horizontalSpan = 1;
        gd1.widthHint = 200;
        this.rcbsApplicabilitySelector.setLayoutData((Object)gd1);
    }

    private void createBuildInputControl(Group inputGroup) {
        Label inputLabel = new Label((Composite)inputGroup, 16384);
        inputLabel.setFont(inputGroup.getFont());
        inputLabel.setText(ManagedBuilderUIMessages.getResourceString(INPUT_FILENAMES));
        inputLabel.setToolTipText(ManagedBuilderUIMessages.getResourceString(INPUTS_TIP));
        inputLabel.setLayoutData((Object)new GridData(768));
        this.buildInputs = new Text((Composite)inputGroup, 2052);
        this.buildInputs.setFont(inputGroup.getFont());
        GridData gd2 = new GridData(768);
        this.buildInputs.setLayoutData((Object)gd2);
        this.buildInputs.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                ResourceCustomBuildStepBlock.this.buildInputs = null;
            }
        });
        this.buildInputs.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = ManagedBuilderUIMessages.getResourceString(ResourceCustomBuildStepBlock.INPUT_FILENAMES);
            }
        });
        this.buildInputs.addModifyListener(this.widgetModified);
    }

    private void createBuildOutputControl(Group outputGroup) {
        Label outputLabel = new Label((Composite)outputGroup, 16384);
        outputLabel.setFont(outputGroup.getFont());
        outputLabel.setText(ManagedBuilderUIMessages.getResourceString(OUTPUT_FILENAMES));
        outputLabel.setToolTipText(ManagedBuilderUIMessages.getResourceString(OUTPUTS_TIP));
        outputLabel.setLayoutData((Object)new GridData(768));
        this.buildOutputs = new Text((Composite)outputGroup, 2052);
        this.buildOutputs.setFont(outputGroup.getFont());
        GridData gd3 = new GridData(768);
        this.buildOutputs.setLayoutData((Object)gd3);
        this.buildOutputs.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                ResourceCustomBuildStepBlock.this.buildOutputs = null;
            }
        });
        this.buildOutputs.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = ManagedBuilderUIMessages.getResourceString(ResourceCustomBuildStepBlock.OUTPUT_FILENAMES);
            }
        });
        this.buildOutputs.addModifyListener(this.widgetModified);
    }

    private void createBuildCommandControl(Group commandGroup) {
        Label commandLabel = new Label((Composite)commandGroup, 16384);
        commandLabel.setFont(commandGroup.getFont());
        commandLabel.setText(ManagedBuilderUIMessages.getResourceString(COMMAND_CMD));
        commandLabel.setToolTipText(ManagedBuilderUIMessages.getResourceString(COMMAND_TIP));
        commandLabel.setLayoutData((Object)new GridData(768));
        this.buildCommand = new Text((Composite)commandGroup, 2052);
        this.buildCommand.setFont(commandGroup.getFont());
        GridData gd4 = new GridData(768);
        this.buildCommand.setLayoutData((Object)gd4);
        this.buildCommand.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                ResourceCustomBuildStepBlock.this.buildCommand = null;
            }
        });
        this.buildCommand.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = ManagedBuilderUIMessages.getResourceString(ResourceCustomBuildStepBlock.COMMAND_CMD);
            }
        });
        this.buildCommand.addModifyListener(this.widgetModified);
    }

    private void createCommandDescriptionControl(Group descriptionGroup) {
        Label descriptionLabel = new Label((Composite)descriptionGroup, 16384);
        descriptionLabel.setFont(descriptionGroup.getFont());
        descriptionLabel.setText(ManagedBuilderUIMessages.getResourceString(DESCRIPTION_DESC));
        descriptionLabel.setToolTipText(ManagedBuilderUIMessages.getResourceString(ANNOUNCEMENT_TIP));
        descriptionLabel.setLayoutData((Object)new GridData(768));
        this.buildDescription = new Text((Composite)descriptionGroup, 2052);
        this.buildDescription.setFont(descriptionGroup.getFont());
        GridData gd5 = new GridData(768);
        this.buildDescription.setLayoutData((Object)gd5);
        this.buildDescription.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                ResourceCustomBuildStepBlock.this.buildDescription = null;
            }
        });
        this.buildDescription.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = ManagedBuilderUIMessages.getResourceString(ResourceCustomBuildStepBlock.DESCRIPTION_DESC);
            }
        });
        this.buildDescription.addModifyListener(this.widgetModified);
    }

    protected void initializeValues() {
        this.setValues();
    }

    public void updateValues() {
        this.setValues();
    }

    protected void setValues() {
        int idx;
        boolean foundRcbsTool = false;
        IResourceConfiguration resConfig = this.resParent.getCurrentResourceConfig();
        ITool[] tools = resConfig.getTools();
        int i = 0;
        while (i < tools.length) {
            ITool tool = tools[i];
            if (tool.getCustomBuildStep() && !tool.isExtensionElement()) {
                String[] buildInputsPaths = tool.getInputTypes()[0].getAdditionalInputs()[0].getPaths();
                this.resBuildInputs = "";
                int j = 0;
                while (j < buildInputsPaths.length) {
                    this.resBuildInputs = String.valueOf(this.resBuildInputs) + buildInputsPaths[j] + ";";
                    ++j;
                }
                int len = this.resBuildInputs.length();
                this.resBuildInputs = this.resBuildInputs.substring(0, len - 1);
                this.buildInputs.setText(this.resBuildInputs);
                String[] buildOutputsPaths = tool.getOutputTypes()[0].getOutputNames();
                this.resBuildOutputs = "";
                int j2 = 0;
                while (j2 < buildOutputsPaths.length) {
                    this.resBuildOutputs = String.valueOf(this.resBuildOutputs) + buildOutputsPaths[j2] + ";";
                    ++j2;
                }
                len = this.resBuildOutputs.length();
                this.resBuildOutputs = this.resBuildOutputs.substring(0, len - 1);
                this.buildOutputs.setText(this.resBuildOutputs);
                this.resBuildCommand = tool.getToolCommand();
                this.buildCommand.setText(this.resBuildCommand);
                this.resBuildAnnouncement = tool.getAnnouncement();
                this.buildDescription.setText(this.resBuildAnnouncement);
                foundRcbsTool = true;
                break;
            }
            ++i;
        }
        if (!foundRcbsTool) {
            this.buildInputs.setText("");
            this.buildOutputs.setText("");
            this.buildCommand.setText("");
            this.buildDescription.setText("");
        }
        switch (resConfig.getRcbsApplicability()) {
            case 1: {
                idx = this.rcbsApplicabilitySelector.indexOf(ManagedBuilderUIMessages.getResourceString(RCBS_OVERRIDE));
                break;
            }
            case 3: {
                idx = this.rcbsApplicabilitySelector.indexOf(ManagedBuilderUIMessages.getResourceString(RCBS_AFTER));
                break;
            }
            case 2: {
                idx = this.rcbsApplicabilitySelector.indexOf(ManagedBuilderUIMessages.getResourceString(RCBS_BEFORE));
                break;
            }
            case 4: {
                idx = this.rcbsApplicabilitySelector.indexOf(ManagedBuilderUIMessages.getResourceString(RCBS_DISABLE));
                break;
            }
            default: {
                idx = this.rcbsApplicabilitySelector.indexOf(ManagedBuilderUIMessages.getResourceString(RCBS_OVERRIDE));
            }
        }
        this.rcbsApplicabilitySelector.select(idx);
        this.setDirty(false);
    }

    public void removeValues(String id) {
    }

    public void performDefaults() {
        Shell shell = ManagedBuilderUIPlugin.getDefault().getShell();
        boolean shouldDefault = MessageDialog.openConfirm((Shell)shell, (String)ManagedBuilderUIMessages.getResourceString(CONFIRM_DEFAULT_TITLE), (String)ManagedBuilderUIMessages.getResourceString(CONFIRM_DEFAULT_MESSAGE));
        if (!shouldDefault) {
            return;
        }
        IResourceConfiguration resConfig = this.resParent.getCurrentResourceConfig();
        ITool[] tools = resConfig.getTools();
        int i = 0;
        while (i < tools.length) {
            ITool tool = tools[i];
            if (tool.getCustomBuildStep() && !tool.isExtensionElement()) {
                resConfig.removeTool(tool);
                break;
            }
            ++i;
        }
        if (resConfig.getRcbsApplicability() != 4) {
            resConfig.getParent().setRebuildState(true);
        }
        resConfig.setRcbsApplicability(4);
        this.setValues();
        this.setDirty(false);
    }

    public void performApply(IProgressMonitor monitor) throws CoreException {
        int idx;
        boolean foundRcbsTool = false;
        boolean rebuildNeeded = false;
        boolean rcbsStillDisabledSoNoRebuild = false;
        this.resBuildInputs = this.buildInputs.getText().trim();
        this.resBuildOutputs = this.buildOutputs.getText().trim();
        this.resBuildCommand = this.buildCommand.getText().trim();
        this.resBuildAnnouncement = this.buildDescription.getText().trim();
        IResourceConfiguration resConfig = this.resParent.getCurrentResourceConfig();
        ITool[] tools = resConfig.getTools();
        int i = 0;
        while (i < tools.length) {
            ITool tool = tools[i];
            if (tool.getCustomBuildStep() && !tool.isExtensionElement()) {
                tool.getInputTypes()[0].getAdditionalInputs()[0].setPaths(this.resBuildInputs);
                tool.getOutputTypes()[0].setOutputNames(this.resBuildOutputs);
                tool.setToolCommand(this.resBuildCommand);
                tool.setAnnouncement(this.resBuildAnnouncement);
                if (tool.isDirty()) {
                    rebuildNeeded = true;
                }
                foundRcbsTool = true;
                break;
            }
            ++i;
        }
        if (!foundRcbsTool) {
            ITool rcbsTool = resConfig.createTool(null, String.valueOf(rcbsToolId) + "." + ManagedBuildManager.getRandomNumber(), rcbsToolName, false);
            IInputType rcbsToolInputType = rcbsTool.createInputType(null, String.valueOf(rcbsToolInputTypeId) + "." + ManagedBuildManager.getRandomNumber(), rcbsToolInputTypeName, false);
            IAdditionalInput rcbsToolInputTypeAdditionalInput = rcbsToolInputType.createAdditionalInput(this.resBuildInputs);
            rcbsToolInputTypeAdditionalInput.setKind(3);
            IOutputType rcbsToolOutputType = rcbsTool.createOutputType(null, String.valueOf(rcbsToolOutputTypeId) + "." + ManagedBuildManager.getRandomNumber(), rcbsToolOutputTypeName, false);
            rcbsToolOutputType.setOutputNames(this.resBuildOutputs);
            rcbsTool.setCustomBuildStep(true);
            rcbsTool.setToolCommand(this.resBuildCommand);
            rcbsTool.setAnnouncement(this.resBuildAnnouncement);
            rebuildNeeded = true;
        }
        if ((idx = this.rcbsApplicabilitySelector.getSelectionIndex()) == this.rcbsApplicabilitySelector.indexOf(ManagedBuilderUIMessages.getResourceString(RCBS_AFTER))) {
            resConfig.setRcbsApplicability(3);
        } else if (idx == this.rcbsApplicabilitySelector.indexOf(ManagedBuilderUIMessages.getResourceString(RCBS_BEFORE))) {
            resConfig.setRcbsApplicability(2);
        } else if (idx == this.rcbsApplicabilitySelector.indexOf(ManagedBuilderUIMessages.getResourceString(RCBS_DISABLE))) {
            if (resConfig.getRcbsApplicability() == 4) {
                rcbsStillDisabledSoNoRebuild = true;
            }
            resConfig.setRcbsApplicability(4);
        } else {
            resConfig.setRcbsApplicability(1);
        }
        if (resConfig.isDirty()) {
            rebuildNeeded = true;
        }
        if (rebuildNeeded && !rcbsStillDisabledSoNoRebuild) {
            resConfig.getParent().setRebuildState(true);
        }
        this.setDirty(false);
    }

    public IPreferenceStore getPreferenceStore() {
        return null;
    }

    public void setDirty(boolean b) {
        this.dirty = b;
    }

    public boolean isDirty() {
        return this.dirty;
    }
}

