/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.properties;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.ListIterator;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.internal.ui.ManagedBuildOptionBlock;
import org.eclipse.cdt.managedbuilder.internal.ui.ManagedBuilderUIMessages;
import org.eclipse.cdt.managedbuilder.internal.ui.ManagedBuilderUIPlugin;
import org.eclipse.cdt.managedbuilder.ui.properties.ManageConfigDialog;
import org.eclipse.cdt.ui.dialogs.ICOptionContainer;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.help.WorkbenchHelp;

public class BuildPropertyPage
extends PropertyPage
implements IWorkbenchPropertyPage,
IPreferencePageContainer,
ICOptionContainer {
    private static final String PREFIX = "BuildPropertyPage";
    private static final String LABEL = "BuildPropertyPage.label";
    private static final String PLATFORM_LABEL = "BuildPropertyPage.label.Platform";
    private static final String CONFIG_LABEL = "BuildPropertyPage.label.Configuration";
    private static final String ALL_CONFS = "BuildPropertyPage.selection.configuration.all";
    private static final String ACTIVE_LABEL = "BuildPropertyPage.label.Active";
    private static final String SETTINGS_LABEL = "BuildPropertyPage.label.Settings";
    private static final String ADD_CONF = "BuildPropertyPage.label.AddConfButton";
    private static final String TIP = "BuildPropertyPage.tip";
    private static final String PLAT_TIP = "BuildPropertyPage.tip.platform";
    private static final String CONF_TIP = "BuildPropertyPage.tip.config";
    private static final String ADD_TIP = "BuildPropertyPage.tip.addconf";
    private static final String MANAGE_TITLE = "BuildPropertyPage.manage.title";
    private static final String ID_SEPARATOR = ".";
    private static final String MSG_CLOSEDPROJECT = "MngMakeProjectPropertyPage.closedproject";
    private static final String MSG_UNSUPPORTED_PROJ = "BuildPropertyPage.unsupported.proj";
    private static final String MSG_UNSUPPORTED_CONFIG = "BuildPropertyPage.unsupported.config";
    private static final String MSG_CONFIG_NOTSELECTED = "BuildPropertyPage.config.notselected";
    private Combo projectTypeSelector;
    private Combo configSelector;
    private Button manageConfigs;
    private IProjectType[] projectTypes;
    private IProjectType selectedProjectType;
    private IConfiguration[] configurations;
    private IConfiguration selectedConfiguration;
    private Point lastShellSize;
    protected ManagedBuildOptionBlock fOptionBlock;
    protected boolean displayedConfig = false;

    public void setContainer(IPreferencePageContainer preferencePageContainer) {
        super.setContainer(preferencePageContainer);
        if (this.fOptionBlock == null) {
            this.fOptionBlock = new ManagedBuildOptionBlock(this);
        }
    }

    public ManagedBuildOptionBlock getOptionBlock() {
        return this.fOptionBlock;
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        GridLayout compositeLayout = new GridLayout();
        compositeLayout.numColumns = 1;
        compositeLayout.marginHeight = 0;
        compositeLayout.marginWidth = 0;
        composite.setLayout((Layout)compositeLayout);
        IProject project = this.getProject();
        if (!project.isOpen()) {
            this.contentForClosedProject(composite);
        } else {
            this.contentForCProject(composite);
        }
        return composite;
    }

    private void contentForCProject(Composite parent) {
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)this.getProject());
        if (info.getVersion() == null) {
            Label invalidInfo = new Label(parent, 16384);
            invalidInfo.setFont(parent.getFont());
            invalidInfo.setText(ManagedBuilderUIMessages.getResourceString("BuildPropertyPage.error.version_low"));
            invalidInfo.setLayoutData((Object)new GridData(32, 4, true, true));
            this.noDefaultAndApplyButton();
            return;
        }
        this.projectTypes = ManagedBuildManager.getDefinedProjectTypes();
        IProjectType defaultProjectType = info.getManagedProject().getProjectType();
        Group configGroup = ControlFactory.createGroup((Composite)parent, (String)ManagedBuilderUIMessages.getResourceString(ACTIVE_LABEL), (int)1);
        GridData gd = new GridData(256);
        gd.grabExcessHorizontalSpace = true;
        configGroup.setLayoutData((Object)gd);
        FormLayout form = new FormLayout();
        form.marginHeight = 5;
        form.marginWidth = 5;
        configGroup.setLayout((Layout)form);
        Label platformLabel = ControlFactory.createLabel((Composite)configGroup, (String)ManagedBuilderUIMessages.getResourceString(PLATFORM_LABEL));
        this.projectTypeSelector = ControlFactory.createSelectCombo((Composite)configGroup, (String[])this.getPlatformNames(), (String)defaultProjectType.getName());
        this.projectTypeSelector.setEnabled(false);
        this.projectTypeSelector.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                BuildPropertyPage.this.handleProjectTypeSelection();
            }
        });
        this.projectTypeSelector.setToolTipText(ManagedBuilderUIMessages.getResourceString(PLAT_TIP));
        Label configLabel = ControlFactory.createLabel((Composite)configGroup, (String)ManagedBuilderUIMessages.getResourceString(CONFIG_LABEL));
        this.configSelector = new Combo((Composite)configGroup, 12);
        this.configSelector.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                BuildPropertyPage.this.handleConfigSelection();
            }
        });
        this.configSelector.setToolTipText(ManagedBuilderUIMessages.getResourceString(CONF_TIP));
        this.manageConfigs = ControlFactory.createPushButton((Composite)configGroup, (String)ManagedBuilderUIMessages.getResourceString(ADD_CONF));
        this.manageConfigs.setToolTipText(ManagedBuilderUIMessages.getResourceString(ADD_TIP));
        this.manageConfigs.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildPropertyPage.this.handleManageConfig();
            }
        });
        FormData fd = new FormData();
        fd.top = new FormAttachment((Control)this.projectTypeSelector, 0, 0x1000000);
        platformLabel.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment((Control)this.configSelector, 0, 0x1000000);
        configLabel.setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment((Control)this.configSelector, 0, 16384);
        fd.right = new FormAttachment(100, 0);
        this.projectTypeSelector.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment((Control)this.configSelector, 0, 0x1000000);
        fd.right = new FormAttachment(100, 0);
        this.manageConfigs.setLayoutData((Object)fd);
        Label longestLabel = platformLabel.getText().length() > configLabel.getText().length() ? platformLabel : configLabel;
        fd = new FormData();
        fd.left = new FormAttachment((Control)longestLabel, 5);
        fd.top = new FormAttachment(55, 0);
        fd.right = new FormAttachment((Control)this.manageConfigs, -5, 16384);
        this.configSelector.setLayoutData((Object)fd);
        Group tabGroup = ControlFactory.createGroup((Composite)parent, (String)ManagedBuilderUIMessages.getResourceString(SETTINGS_LABEL), (int)1);
        gd = new GridData(1808);
        tabGroup.setLayoutData((Object)gd);
        this.fOptionBlock.createContents((Composite)tabGroup, this.getElement());
        this.handleProjectTypeSelection();
        WorkbenchHelp.setHelp((Control)parent, (String)"org.eclipse.cdt.ui.man_prop_build");
    }

    private void contentForClosedProject(Composite parent) {
        Label label = new Label(parent, 16384);
        label.setText(ManagedBuilderUIMessages.getResourceString(MSG_CLOSEDPROJECT));
        label.setFont(parent.getFont());
        this.noDefaultAndApplyButton();
    }

    public boolean performOk() {
        if (!this.displayedConfig) {
            return true;
        }
        if (!this.applyOptionBlock()) {
            return false;
        }
        if (!this.applyDefaultConfiguration()) {
            return false;
        }
        return this.writeBuildInfo();
    }

    protected boolean applyOptionBlock() {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                BuildPropertyPage.this.fOptionBlock.performApply(monitor);
            }
        };
        WorkspaceModifyDelegatingOperation op = new WorkspaceModifyDelegatingOperation(runnable);
        try {
            new ProgressMonitorDialog(this.getShell()).run(false, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException e) {
            Throwable e1 = e.getTargetException();
            ManagedBuilderUIPlugin.errorDialog(this.getShell(), ManagedBuilderUIMessages.getResourceString("ManagedProjectPropertyPage.internalError"), e1.toString(), e1);
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    protected boolean applyDefaultConfiguration() {
        ManagedBuildManager.setDefaultConfiguration((IProject)this.getProject(), (IConfiguration)this.getSelectedConfiguration());
        return true;
    }

    protected boolean writeBuildInfo() {
        ManagedBuildManager.saveBuildInfo((IProject)this.getProject(), (boolean)false);
        IManagedBuildInfo bi = ManagedBuildManager.getBuildInfo((IResource)this.getProject());
        if (bi != null & bi instanceof ManagedBuildInfo) {
            ((ManagedBuildInfo)bi).initializePathEntries();
        }
        return true;
    }

    protected void performDefaults() {
        this.fOptionBlock.performDefaults();
        super.performDefaults();
    }

    private String[] getPlatformNames() {
        String[] names = new String[this.projectTypes.length];
        int index = 0;
        while (index < this.projectTypes.length) {
            names[index] = this.projectTypes[index].getName();
            ++index;
        }
        return names;
    }

    public IProjectType getSelectedProjectType() {
        return this.selectedProjectType;
    }

    private void populateConfigurations() {
        if (this.configSelector == null) {
            return;
        }
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)this.getProject());
        this.configurations = info.getManagedProject().getConfigurations();
        if (this.configurations.length == 0) {
            return;
        }
        this.configSelector.removeAll();
        this.configSelector.setItems(this.getConfigurationNamesAndDescriptions());
        this.configSelector.select(0);
        IConfiguration defaultConfig = info.getDefaultConfiguration();
        this.setSelectedConfiguration(defaultConfig);
    }

    private String[] getConfigurationNamesAndDescriptions() {
        String[] namesAndDescriptions = new String[this.configurations.length];
        int index = 0;
        while (index < this.configurations.length) {
            String description = this.configurations[index].getDescription();
            namesAndDescriptions[index] = description == null || description.equals("") ? this.configurations[index].getName() : String.valueOf(this.configurations[index].getName()) + "( " + description + " )";
            ++index;
        }
        return namesAndDescriptions;
    }

    public void setSelectedConfiguration(IConfiguration config) {
        String nameAndDescription = new String();
        nameAndDescription = config.getDescription() == null || config.getDescription().equals("") ? config.getName() : String.valueOf(config.getName()) + "( " + config.getDescription() + " )";
        this.configSelector.select(this.configSelector.indexOf(nameAndDescription));
        this.handleConfigSelection();
    }

    public void enableConfigSelection(boolean enable) {
        this.configSelector.setEnabled(enable);
    }

    public void enabledManageConfigs(boolean enable) {
        this.manageConfigs.setEnabled(false);
    }

    public IConfiguration getSelectedConfiguration() {
        return this.selectedConfiguration;
    }

    protected Point getLastShellSize() {
        Shell shell;
        if (this.lastShellSize == null && (shell = this.getShell()) != null) {
            this.lastShellSize = shell.getSize();
        }
        return this.lastShellSize;
    }

    public IPreferenceStore getPreferenceStore() {
        return this.fOptionBlock.getPreferenceStore();
    }

    public IPreferenceStore getToolSettingsPreferenceStore() {
        return this.fOptionBlock.getToolSettingsPreferenceStore();
    }

    public Preferences getPreferences() {
        return null;
    }

    public IProject getProject() {
        IAdaptable element = this.getElement();
        if (element != null && element instanceof IProject) {
            return (IProject)element;
        }
        return null;
    }

    public void updateContainer() {
        this.fOptionBlock.update();
        this.setValid(this.fOptionBlock.isValid());
        this.setErrorMessage(this.fOptionBlock.getErrorMessage());
    }

    public boolean isValid() {
        this.updateContainer();
        return super.isValid();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.fOptionBlock.setVisible(visible);
        if (visible) {
            this.fOptionBlock.updateValues();
            this.displayedConfig = true;
        }
    }

    public void updateButtons() {
    }

    public void updateMessage() {
    }

    public void updateTitle() {
    }

    private void handleConfigSelection() {
        if (this.configSelector.getItemCount() == 0) {
            return;
        }
        int selectionIndex = this.configSelector.getSelectionIndex();
        if (selectionIndex == -1) {
            return;
        }
        String configName = this.configSelector.getItem(selectionIndex);
        if (configName.equals(ManagedBuilderUIMessages.getResourceString(ALL_CONFS))) {
            return;
        }
        IConfiguration newConfig = this.configurations[selectionIndex];
        if (newConfig != this.selectedConfiguration) {
            Shell shell;
            boolean shouldApply;
            if (this.selectedConfiguration != null && this.fOptionBlock.isDirty() && (shouldApply = MessageDialog.openQuestion((Shell)(shell = ManagedBuilderUIPlugin.getDefault().getShell()), (String)ManagedBuilderUIMessages.getResourceString("BuildPropertyPage.changes.save.title"), (String)ManagedBuilderUIMessages.getFormattedString("BuildPropertyPage.changes.save.question", new String[]{this.selectedConfiguration.getName(), newConfig.getName()})))) {
                if (this.performOk()) {
                    this.fOptionBlock.setDirty(false);
                } else {
                    MessageDialog.openWarning((Shell)shell, (String)ManagedBuilderUIMessages.getResourceString("BuildPropertyPage.changes.save.title"), (String)ManagedBuilderUIMessages.getResourceString("BuildPropertyPage.changes.save.error"));
                }
            }
            this.selectedConfiguration = newConfig;
            ManagedBuildManager.setSelectedConfiguration((IProject)this.getProject(), (IConfiguration)this.selectedConfiguration);
            this.fOptionBlock.updateValues();
            this.doUpdateMessage();
        }
    }

    private void doUpdateMessage() {
        if (this.selectedProjectType != null && !this.selectedProjectType.isSupported()) {
            this.setMessage(ManagedBuilderUIMessages.getResourceString(MSG_UNSUPPORTED_PROJ), 2);
        } else if (this.selectedConfiguration != null) {
            if (this.selectedConfiguration.isSupported()) {
                this.setMessage(null, 0);
            } else {
                this.setMessage(ManagedBuilderUIMessages.getResourceString(MSG_UNSUPPORTED_CONFIG), 2);
            }
        } else {
            this.setMessage(ManagedBuilderUIMessages.getResourceString(MSG_CONFIG_NOTSELECTED), 2);
        }
        this.getContainer().updateMessage();
    }

    private void handleManageConfig() {
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)this.getProject());
        ManageConfigDialog manageDialog = new ManageConfigDialog(this.getShell(), ManagedBuilderUIMessages.getResourceString(MANAGE_TITLE), info.getManagedProject());
        if (manageDialog.open() == 0) {
            ArrayList deletedConfigs = manageDialog.getDeletedConfigIds();
            ListIterator iter = deletedConfigs.listIterator();
            while (iter.hasNext()) {
                String id = (String)iter.next();
                this.fOptionBlock.removeValues(id);
            }
            this.configurations = info.getManagedProject().getConfigurations();
            this.configSelector.removeAll();
            this.configSelector.setItems(this.getConfigurationNamesAndDescriptions());
            IConfiguration tmpSelectedConfiguration = manageDialog.getSelectedConfiguration();
            this.setSelectedConfiguration(tmpSelectedConfiguration);
        }
    }

    private void handleProjectTypeSelection() {
        if (this.projectTypeSelector.getItemCount() == 0) {
            this.manageConfigs.setEnabled(false);
            return;
        }
        this.manageConfigs.setEnabled(true);
        this.selectedProjectType = this.projectTypes[this.projectTypeSelector.getSelectionIndex()];
        ManagedBuildManager.setSelectedConfiguration((IProject)this.getProject(), (IConfiguration)this.selectedConfiguration);
        this.populateConfigurations();
    }
}

