/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IManagedConfigElement;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IResourceConfiguration;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.BuildObject;
import org.eclipse.cdt.managedbuilder.internal.core.Tool;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ResourceConfiguration
extends BuildObject
implements IResourceConfiguration {
    private static final String EMPTY_STRING = new String();
    private IConfiguration parent;
    private List toolList;
    private Map toolMap;
    private String resPath;
    private Boolean isExcluded;
    private Integer rcbsApplicability;
    private String toolsToInvoke;
    private boolean isExtensionResourceConfig = false;
    private boolean isDirty = false;
    private boolean resolved = true;

    public ResourceConfiguration(IConfiguration parent, IManagedConfigElement element, String managedBuildRevision) {
        this.parent = parent;
        this.isExtensionResourceConfig = true;
        this.resolved = false;
        this.setManagedBuildRevision(managedBuildRevision);
        this.loadFromManifest(element);
        ManagedBuildManager.addExtensionResourceConfiguration(this);
        IManagedConfigElement[] tools = element.getChildren("tool");
        int n = 0;
        while (n < tools.length) {
            Tool toolChild = new Tool((IBuildObject)this, tools[n], this.getManagedBuildRevision());
            this.toolList.add(toolChild);
            ++n;
        }
    }

    public ResourceConfiguration(IConfiguration parent, Element element, String managedBuildRevision) {
        this.parent = parent;
        this.isExtensionResourceConfig = false;
        this.setManagedBuildRevision(managedBuildRevision);
        this.loadFromProject(element);
        NodeList configElements = element.getChildNodes();
        int i = 0;
        while (i < configElements.getLength()) {
            Node configElement = configElements.item(i);
            if (configElement.getNodeName().equals("tool")) {
                Tool tool = new Tool((IBuildObject)this, (Element)configElement, this.getManagedBuildRevision());
                this.addTool(tool);
            }
            ++i;
        }
    }

    public ResourceConfiguration(IConfiguration parent, String id, String resourceName, String path) {
        this.parent = parent;
        this.setId(id);
        this.setName(resourceName);
        if (parent != null) {
            this.setManagedBuildRevision(parent.getManagedBuildRevision());
        }
        this.resPath = path;
        this.isDirty = false;
        this.isExcluded = new Boolean(false);
        this.toolsToInvoke = EMPTY_STRING;
        this.rcbsApplicability = new Integer(4);
    }

    public ResourceConfiguration(IConfiguration parent, ResourceConfiguration cloneConfig, String id) {
        this.setId(id);
        this.setName(cloneConfig.getName());
        this.parent = parent;
        this.isExtensionResourceConfig = false;
        this.setManagedBuildRevision(cloneConfig.getManagedBuildRevision());
        if (cloneConfig.resPath != null) {
            this.resPath = new String(cloneConfig.resPath);
        }
        if (cloneConfig.isExcluded != null) {
            this.isExcluded = new Boolean(cloneConfig.isExcluded);
        }
        if (cloneConfig.toolsToInvoke != null) {
            this.toolsToInvoke = new String(cloneConfig.toolsToInvoke);
        }
        if (cloneConfig.rcbsApplicability != null) {
            this.rcbsApplicability = new Integer(cloneConfig.rcbsApplicability);
        }
        if (cloneConfig.toolList != null) {
            ListIterator iter = cloneConfig.getToolList().listIterator();
            while (iter.hasNext()) {
                String subName;
                String tmpId;
                Tool toolChild = (Tool)iter.next();
                int nnn = ManagedBuildManager.getRandomNumber();
                if (toolChild.getSuperClass() != null) {
                    tmpId = toolChild.getSuperClass().getId();
                    subName = toolChild.getSuperClass().getName();
                } else {
                    tmpId = toolChild.getId();
                    subName = toolChild.getName();
                }
                String version = ManagedBuildManager.getVersionFromIdAndVersion(tmpId);
                String subId = version != null ? String.valueOf(ManagedBuildManager.getIdFromIdAndVersion(tmpId)) + "." + nnn + "_" + version : String.valueOf(tmpId) + "." + nnn;
                ITool toolSuperClass = null;
                ITool[] tools = parent.getTools();
                int i = 0;
                while (i < tools.length) {
                    ITool configTool = tools[i];
                    if (toolChild.getSuperClass() != null && configTool.getSuperClass() == toolChild.getSuperClass().getSuperClass()) {
                        toolSuperClass = configTool;
                        break;
                    }
                    ++i;
                }
                Tool newTool = new Tool((IBuildObject)this, toolSuperClass, subId, subName, toolChild);
                this.addTool(newTool);
            }
        }
        this.setDirty(true);
    }

    protected void loadFromManifest(IManagedConfigElement element) {
        ManagedBuildManager.putConfigElement(this, element);
        this.setId(element.getAttribute("id"));
        this.setName(element.getAttribute("name"));
        this.resPath = element.getAttribute("resourcePath");
        String excludeStr = element.getAttribute("exclude");
        if (excludeStr != null) {
            this.isExcluded = new Boolean("true".equals(excludeStr));
        }
        this.toolsToInvoke = element.getAttribute("toolsToInvoke");
        String rcbsApplicabilityStr = element.getAttribute("rcbsApplicability");
        if (rcbsApplicabilityStr == null || rcbsApplicabilityStr.equals("disable")) {
            this.rcbsApplicability = new Integer(4);
        } else if (rcbsApplicabilityStr.equals("before")) {
            this.rcbsApplicability = new Integer(2);
        } else if (rcbsApplicabilityStr.equals("after")) {
            this.rcbsApplicability = new Integer(3);
        } else if (rcbsApplicabilityStr.equals("override")) {
            this.rcbsApplicability = new Integer(1);
        }
    }

    protected void loadFromProject(Element element) {
        String excludeStr;
        this.setId(element.getAttribute("id"));
        if (element.hasAttribute("name")) {
            this.setName(element.getAttribute("name"));
        }
        if (element.hasAttribute("exclude") && (excludeStr = element.getAttribute("exclude")) != null) {
            this.isExcluded = new Boolean("true".equals(excludeStr));
        }
        if (element.hasAttribute("resourcePath")) {
            this.resPath = element.getAttribute("resourcePath");
        }
        if (element.hasAttribute("toolsToInvoke")) {
            this.toolsToInvoke = element.getAttribute("toolsToInvoke");
        }
        if (element.hasAttribute("rcbsApplicability")) {
            String rcbsApplicabilityStr = element.getAttribute("rcbsApplicability");
            if (rcbsApplicabilityStr == null || rcbsApplicabilityStr.equals("disable")) {
                this.rcbsApplicability = new Integer(4);
            } else if (rcbsApplicabilityStr.equals("before")) {
                this.rcbsApplicability = new Integer(2);
            } else if (rcbsApplicabilityStr.equals("after")) {
                this.rcbsApplicability = new Integer(3);
            } else if (rcbsApplicabilityStr.equals("override")) {
                this.rcbsApplicability = new Integer(1);
            }
        }
    }

    public void serialize(Document doc, Element element) {
        element.setAttribute("id", this.id);
        if (this.name != null) {
            element.setAttribute("name", this.name);
        }
        if (this.isExcluded != null) {
            element.setAttribute("exclude", this.isExcluded.toString());
        }
        if (this.resPath != null) {
            element.setAttribute("resourcePath", this.resPath);
        }
        if (this.toolsToInvoke != null) {
            element.setAttribute("toolsToInvoke", this.toolsToInvoke);
        }
        if (this.rcbsApplicability != null) {
            String str;
            switch (this.getRcbsApplicability()) {
                case 2: {
                    str = "before";
                    break;
                }
                case 3: {
                    str = "after";
                    break;
                }
                case 1: {
                    str = "override";
                    break;
                }
                case 4: {
                    str = "disable";
                    break;
                }
                default: {
                    str = "disable";
                }
            }
            element.setAttribute("rcbsApplicability", str);
        }
        List toolElements = this.getToolList();
        ListIterator iter = toolElements.listIterator();
        while (iter.hasNext()) {
            Tool tool = (Tool)iter.next();
            Element toolElement = doc.createElement("tool");
            element.appendChild(toolElement);
            tool.serialize(doc, toolElement);
        }
        this.isDirty = false;
    }

    public IConfiguration getParent() {
        return this.parent;
    }

    public ITool[] getTools() {
        ITool[] tools = new ITool[this.getToolList().size()];
        ListIterator iter = this.getToolList().listIterator();
        int i = 0;
        while (iter.hasNext()) {
            Tool tool = (Tool)iter.next();
            tools[i++] = tool;
        }
        return tools;
    }

    public ITool getTool(String id) {
        Tool tool = (Tool)this.getToolMap().get(id);
        return tool;
    }

    private List getToolList() {
        if (this.toolList == null) {
            this.toolList = new ArrayList();
        }
        return this.toolList;
    }

    private Map getToolMap() {
        if (this.toolMap == null) {
            this.toolMap = new HashMap();
        }
        return this.toolMap;
    }

    public void addTool(Tool tool) {
        this.getToolList().add(tool);
        this.getToolMap().put(tool.getId(), tool);
    }

    public void removeTool(ITool tool) {
        this.getToolList().remove(tool);
        this.getToolMap().remove(tool);
    }

    public boolean isExcluded() {
        if (this.isExcluded != null) {
            return this.isExcluded;
        }
        return false;
    }

    public String getResourcePath() {
        String path = this.resPath;
        if (path == null) {
            return EMPTY_STRING;
        }
        return path;
    }

    public int getRcbsApplicability() {
        if (this.rcbsApplicability == null) {
            return 4;
        }
        return this.rcbsApplicability;
    }

    public ITool[] getToolsToInvoke() {
        ITool[] tools;
        String t_ToolsToInvoke = EMPTY_STRING;
        String rcbsToolId = EMPTY_STRING;
        int rcbsToolIdx = -1;
        ITool[] resConfigTools = this.getTools();
        if (resConfigTools.length == 0) {
            this.toolsToInvoke = EMPTY_STRING;
            ITool[] tools2 = new ITool[]{};
            return tools2;
        }
        int i = 0;
        while (i < resConfigTools.length) {
            if (resConfigTools[i].getCustomBuildStep() && !resConfigTools[i].isExtensionElement()) {
                rcbsToolId = resConfigTools[i].getId();
                rcbsToolIdx = i;
                break;
            }
            ++i;
        }
        if (!rcbsToolId.equals(EMPTY_STRING)) {
            switch (this.rcbsApplicability) {
                case 1: {
                    this.toolsToInvoke = rcbsToolId;
                    tools = new ITool[]{resConfigTools[rcbsToolIdx]};
                    break;
                }
                case 3: {
                    int j = 0;
                    tools = new ITool[resConfigTools.length];
                    i = 0;
                    while (i < resConfigTools.length) {
                        if (resConfigTools[i].getId() != rcbsToolId) {
                            t_ToolsToInvoke = String.valueOf(t_ToolsToInvoke) + resConfigTools[i].getId() + ";";
                            tools[j++] = resConfigTools[i];
                        }
                        ++i;
                    }
                    t_ToolsToInvoke = String.valueOf(t_ToolsToInvoke) + rcbsToolId;
                    tools[j++] = resConfigTools[rcbsToolIdx];
                    this.toolsToInvoke = t_ToolsToInvoke;
                    break;
                }
                case 2: {
                    int j = 0;
                    tools = new ITool[resConfigTools.length];
                    t_ToolsToInvoke = String.valueOf(rcbsToolId) + ";";
                    tools[j++] = resConfigTools[rcbsToolIdx];
                    i = 0;
                    while (i < resConfigTools.length) {
                        if (resConfigTools[i].getId() != rcbsToolId) {
                            t_ToolsToInvoke = String.valueOf(t_ToolsToInvoke) + resConfigTools[i].getId() + ";";
                            tools[j++] = resConfigTools[i];
                        }
                        ++i;
                    }
                    int len = t_ToolsToInvoke.length();
                    this.toolsToInvoke = t_ToolsToInvoke = t_ToolsToInvoke.substring(0, len - 1);
                    break;
                }
                case 4: {
                    if (resConfigTools.length == 1) {
                        tools = new ITool[]{};
                        this.toolsToInvoke = EMPTY_STRING;
                        break;
                    }
                    int j = 0;
                    tools = new ITool[resConfigTools.length - 1];
                    i = 0;
                    while (i < resConfigTools.length) {
                        if (resConfigTools[i].getId() != rcbsToolId) {
                            t_ToolsToInvoke = String.valueOf(t_ToolsToInvoke) + resConfigTools[i].getId() + ";";
                            tools[j++] = resConfigTools[i];
                        }
                        ++i;
                    }
                    int len = t_ToolsToInvoke.length();
                    this.toolsToInvoke = t_ToolsToInvoke = t_ToolsToInvoke.substring(0, len - 1);
                    break;
                }
                default: {
                    tools = new ITool[resConfigTools.length];
                    i = 0;
                    while (i < resConfigTools.length) {
                        t_ToolsToInvoke = String.valueOf(t_ToolsToInvoke) + resConfigTools[i].getId() + ";";
                        tools[i] = resConfigTools[i];
                        ++i;
                    }
                    int len = t_ToolsToInvoke.length();
                    this.toolsToInvoke = t_ToolsToInvoke = t_ToolsToInvoke.substring(0, len - 1);
                    break;
                }
            }
        } else {
            tools = new ITool[resConfigTools.length];
            i = 0;
            while (i < resConfigTools.length) {
                t_ToolsToInvoke = String.valueOf(t_ToolsToInvoke) + resConfigTools[i].getId() + ";";
                tools[i] = resConfigTools[i];
                ++i;
            }
            int len = t_ToolsToInvoke.length();
            this.toolsToInvoke = t_ToolsToInvoke = t_ToolsToInvoke.substring(0, len - 1);
        }
        return tools;
    }

    public void setRcbsApplicability(int newValue) {
        if (this.rcbsApplicability == null || this.rcbsApplicability != newValue) {
            this.rcbsApplicability = new Integer(newValue);
            this.isDirty = true;
        }
    }

    public void setExclude(boolean excluded) {
        if (this.isExcluded == null || excluded != this.isExcluded) {
            this.isExcluded = new Boolean(excluded);
            this.setDirty(true);
        }
    }

    public void setResourcePath(String path) {
        if (path == null) {
            return;
        }
        if (this.resPath == null || !path.equals(this.resPath)) {
            this.resPath = path;
            this.setDirty(true);
        }
    }

    public boolean isExtensionResourceConfiguration() {
        return this.isExtensionResourceConfig;
    }

    public boolean isDirty() {
        if (this.isExtensionResourceConfig) {
            return false;
        }
        if (this.isDirty) {
            return true;
        }
        ListIterator iter = this.getToolList().listIterator();
        while (iter.hasNext()) {
            Tool toolChild = (Tool)iter.next();
            if (!toolChild.isDirty()) continue;
            return true;
        }
        return this.isDirty;
    }

    public void setDirty(boolean isDirty) {
        this.isDirty = isDirty;
        if (!isDirty) {
            ListIterator iter = this.getToolList().listIterator();
            while (iter.hasNext()) {
                Tool toolChild = (Tool)iter.next();
                toolChild.setDirty(false);
            }
        }
    }

    public void resolveReferences() {
        if (!this.resolved) {
            this.resolved = true;
            ListIterator iter = this.getToolList().listIterator();
            while (iter.hasNext()) {
                Tool toolChild = (Tool)iter.next();
                toolChild.resolveReferences();
            }
        }
    }

    public ITool createTool(ITool superClass, String id, String name, boolean isExtensionElement) {
        Tool tool = new Tool(this, superClass, id, name, isExtensionElement);
        this.addTool(tool);
        this.setDirty(true);
        return tool;
    }

    public void reset() {
        ITool[] tools = this.getTools();
        ManagedBuildManager.performValueHandlerEvent(this, 2);
        int i = 0;
        while (i < tools.length) {
            ITool tool = tools[i];
            IOption[] opts = tool.getOptions();
            int j = 0;
            while (j < opts.length) {
                tool.removeOption(opts[j]);
                ++j;
            }
            ++i;
        }
        this.isExcluded = new Boolean(false);
    }

    public void setToolCommand(ITool tool, String command) {
        tool.setToolCommand(command);
    }

    private IBuildObject getHoldersParent(IOption option) {
        IHoldsOptions holder = option.getOptionHolder();
        if (holder instanceof ITool) {
            return ((ITool)holder).getParent();
        }
        if (holder instanceof IToolChain) {
            return ((IToolChain)holder).getParent();
        }
        return null;
    }

    public IOption setOption(IHoldsOptions holder, IOption option, boolean value) throws BuildException {
        IOption retOpt = option;
        if (option.getBooleanValue() != value) {
            if (this.getHoldersParent(option) != this) {
                IOption newSuperClass = option;
                if (!newSuperClass.isExtensionElement()) {
                    newSuperClass = newSuperClass.getSuperClass();
                }
                if (newSuperClass.isExtensionElement() && newSuperClass.overridesOnlyValue()) {
                    newSuperClass = newSuperClass.getSuperClass();
                }
                int nnn = ManagedBuildManager.getRandomNumber();
                String subId = String.valueOf(newSuperClass.getId()) + "." + nnn;
                retOpt = holder.createOption(newSuperClass, subId, null, false);
                retOpt.setValueType(option.getValueType());
                retOpt.setValue(value);
                this.setDirty(true);
            } else {
                option.setValue(value);
            }
            this.parent.setRebuildState(true);
        }
        return retOpt;
    }

    public IOption setOption(IHoldsOptions holder, IOption option, String value) throws BuildException {
        IOption retOpt = option;
        String oldValue = option.getStringValue();
        if (oldValue != null && !oldValue.equals(value)) {
            if (this.getHoldersParent(option) != this) {
                IOption newSuperClass = option;
                if (!newSuperClass.isExtensionElement()) {
                    newSuperClass = newSuperClass.getSuperClass();
                }
                if (newSuperClass.isExtensionElement() && newSuperClass.overridesOnlyValue()) {
                    newSuperClass = newSuperClass.getSuperClass();
                }
                int nnn = ManagedBuildManager.getRandomNumber();
                String subId = String.valueOf(newSuperClass.getId()) + "." + nnn;
                retOpt = holder.createOption(newSuperClass, subId, null, false);
                retOpt.setValueType(option.getValueType());
                retOpt.setValue(value);
                this.setDirty(true);
            } else {
                option.setValue(value);
            }
            this.parent.setRebuildState(true);
        }
        return retOpt;
    }

    public IOption setOption(IHoldsOptions holder, IOption option, String[] value) throws BuildException {
        Object[] oldValue;
        IOption retOpt = option;
        switch (option.getValueType()) {
            case 3: {
                oldValue = option.getStringListValue();
                break;
            }
            case 4: {
                oldValue = option.getIncludePaths();
                break;
            }
            case 5: {
                oldValue = option.getDefinedSymbols();
                break;
            }
            case 6: {
                oldValue = option.getLibraries();
                break;
            }
            case 7: {
                oldValue = option.getUserObjects();
                break;
            }
            default: {
                oldValue = new String[]{};
            }
        }
        if (!Arrays.equals(value, oldValue)) {
            if (this.getHoldersParent(option) != this) {
                IOption newSuperClass = option;
                if (!newSuperClass.isExtensionElement()) {
                    newSuperClass = newSuperClass.getSuperClass();
                }
                if (newSuperClass.isExtensionElement() && newSuperClass.overridesOnlyValue()) {
                    newSuperClass = newSuperClass.getSuperClass();
                }
                int nnn = ManagedBuildManager.getRandomNumber();
                String subId = String.valueOf(newSuperClass.getId()) + "." + nnn;
                retOpt = holder.createOption(newSuperClass, subId, null, false);
                retOpt.setValueType(option.getValueType());
                retOpt.setValue(value);
                this.setDirty(true);
            } else {
                option.setValue(value);
            }
            this.parent.setRebuildState(true);
        }
        return retOpt;
    }

    public IResource getOwner() {
        return this.getParent().getOwner();
    }

    public PluginVersionIdentifier getVersion() {
        if (this.version == null && this.getParent() != null) {
            return this.getParent().getVersion();
        }
        return this.version;
    }

    public void setVersion(PluginVersionIdentifier version) {
    }
}

