/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.util;

import java.util.HashSet;
import org.eclipse.cdt.internal.ui.editor.TranslationUnitAnnotationModelEvent;
import org.eclipse.cdt.internal.ui.util.IProblemChangedListener;
import org.eclipse.cdt.internal.ui.util.SWTUtil;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.source.AnnotationModelEvent;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelListener;
import org.eclipse.jface.text.source.IAnnotationModelListenerExtension;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.swt.widgets.Display;

public class ProblemMarkerManager
implements IResourceChangeListener,
IAnnotationModelListener,
IAnnotationModelListenerExtension {
    ListenerList fListeners = new ListenerList(5);

    public void resourceChanged(IResourceChangeEvent event) {
        HashSet changedElements = new HashSet();
        try {
            IResourceDelta delta = event.getDelta();
            if (delta != null) {
                delta.accept((IResourceDeltaVisitor)new ProjectErrorVisitor(changedElements));
            }
        }
        catch (CoreException e) {
            CUIPlugin.getDefault().log(e.getStatus());
        }
        if (!changedElements.isEmpty()) {
            IResource[] changes = changedElements.toArray(new IResource[changedElements.size()]);
            this.fireChanges(changes, true);
        }
    }

    public void modelChanged(IAnnotationModel model) {
    }

    public void modelChanged(AnnotationModelEvent event) {
        IResource res;
        TranslationUnitAnnotationModelEvent cuEvent;
        if (event instanceof TranslationUnitAnnotationModelEvent && (cuEvent = (TranslationUnitAnnotationModelEvent)event).includesProblemMarkerAnnotationChanges() && (res = cuEvent.getUnderlyingResource()) != null) {
            this.fireChanges(new IResource[]{res}, false);
        }
    }

    public void addListener(IProblemChangedListener listener) {
        if (this.fListeners.isEmpty()) {
            CUIPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
            CUIPlugin.getDefault().getDocumentProvider().addGlobalAnnotationModelListener(this);
        }
        this.fListeners.add((Object)listener);
    }

    public void removeListener(IProblemChangedListener listener) {
        this.fListeners.remove((Object)listener);
        if (this.fListeners.isEmpty()) {
            CUIPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
            CUIPlugin.getDefault().getDocumentProvider().removeGlobalAnnotationModelListener(this);
        }
    }

    private void fireChanges(final IResource[] changes, final boolean markerChanged) {
        Display display = SWTUtil.getStandardDisplay();
        if (display != null && !display.isDisposed()) {
            display.asyncExec(new Runnable(){

                public void run() {
                    Object[] listeners = ProblemMarkerManager.this.fListeners.getListeners();
                    int i = 0;
                    while (i < listeners.length) {
                        IProblemChangedListener curr = (IProblemChangedListener)listeners[i];
                        curr.problemsChanged(changes, markerChanged);
                        ++i;
                    }
                }
            });
        }
    }

    private static class ProjectErrorVisitor
    implements IResourceDeltaVisitor {
        private HashSet fChangedElements;

        public ProjectErrorVisitor(HashSet changedElements) {
            this.fChangedElements = changedElements;
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IProject project;
            IResource res = delta.getResource();
            if (res instanceof IProject && delta.getKind() == 4 && !(project = (IProject)res).isAccessible()) {
                return false;
            }
            this.checkInvalidate(delta, res);
            return true;
        }

        private void checkInvalidate(IResourceDelta delta, IResource resource) {
            int kind = delta.getKind();
            if (kind == 2 || kind == 1 || kind == 4 && this.isErrorDelta(delta)) {
                while (resource.getType() != 8 && this.fChangedElements.add(resource)) {
                    resource = resource.getParent();
                }
            }
        }

        private boolean isErrorDelta(IResourceDelta delta) {
            if ((delta.getFlags() & 0x20000) != 0) {
                IMarkerDelta[] markerDeltas = delta.getMarkerDeltas();
                int i = 0;
                while (i < markerDeltas.length) {
                    if (markerDeltas[i].isSubtypeOf("org.eclipse.core.resources.problemmarker")) {
                        int kind = markerDeltas[i].getKind();
                        if (kind == 1 || kind == 2) {
                            return true;
                        }
                        int severity = markerDeltas[i].getAttribute("severity", -1);
                        int newSeverity = markerDeltas[i].getMarker().getAttribute("severity", -1);
                        if (newSeverity != severity) {
                            return true;
                        }
                    }
                    ++i;
                }
            }
            return false;
        }
    }
}

