/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.properties;

import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IOptionCategory;
import org.eclipse.cdt.managedbuilder.core.IResourceConfiguration;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class ToolListContentProvider
implements ITreeContentProvider {
    public static final int FILE = 1;
    public static final int PROJECT = 4;
    private static Object[] EMPTY_ARRAY = new Object[0];
    private IConfiguration configRoot;
    private IResourceConfiguration resConfigRoot;
    private int elementType;

    public void dispose() {
    }

    public ToolListContentProvider(int elementType) {
        this.elementType = elementType;
    }

    private Object[] getToplevelContent(IConfiguration config) {
        IToolChain toolChain = config.getToolChain();
        IOptionCategory[] toolChainsCategories = toolChain.getChildCategories();
        ITool[] filteredTools = config.getFilteredTools();
        int len = toolChainsCategories.length + filteredTools.length;
        Object[] all = new Object[len];
        int i = 0;
        while (i < toolChainsCategories.length) {
            all[i] = toolChainsCategories[i];
            ++i;
        }
        while (i < len) {
            all[i] = filteredTools[i - toolChainsCategories.length];
            ++i;
        }
        return all;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IConfiguration) {
            IConfiguration config = (IConfiguration)parentElement;
            return this.getToplevelContent(config);
        }
        if (parentElement instanceof IResourceConfiguration) {
            IResourceConfiguration resConfig = (IResourceConfiguration)parentElement;
            return resConfig.getTools();
        }
        if (parentElement instanceof ITool) {
            ITool tool = (ITool)parentElement;
            return tool.getTopOptionCategory().getChildCategories();
        }
        if (parentElement instanceof IOptionCategory) {
            IOptionCategory cat = (IOptionCategory)parentElement;
            return cat.getChildCategories();
        }
        return EMPTY_ARRAY;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object getParent(Object element) {
        if (element instanceof IOptionCategory) {
            IOptionCategory cat = (IOptionCategory)element;
            IOptionCategory parent = cat.getOwner();
            if (parent == null) {
                if (this.elementType == 1) {
                    return this.resConfigRoot;
                }
                return this.configRoot;
            }
            return parent;
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (this.elementType == 1) {
            this.resConfigRoot = (IResourceConfiguration)newInput;
            this.configRoot = null;
        } else if (this.elementType == 4) {
            this.configRoot = (IConfiguration)newInput;
            this.resConfigRoot = null;
        }
    }
}

