/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser;

import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeLocation;

public abstract class ASTNode
implements IASTNode {
    private int length;
    private int offset;
    private static final IASTNodeLocation[] EMPTY_LOCATION_ARRAY = new IASTNodeLocation[0];
    private IASTNodeLocation[] locations = null;
    private IASTFileLocation fileLocation = null;

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public void setOffset(int offset) {
        this.offset = offset;
        this.locations = null;
    }

    public void setLength(int length) {
        this.length = length;
        this.locations = null;
    }

    public void setOffsetAndLength(int offset, int length) {
        this.offset = offset;
        this.length = length;
        this.locations = null;
    }

    public void setOffsetAndLength(ASTNode node) {
        this.setOffsetAndLength(node.getOffset(), node.getLength());
    }

    public IASTNodeLocation[] getNodeLocations() {
        if (this.locations != null) {
            return this.locations;
        }
        if (this.length == 0) {
            return EMPTY_LOCATION_ARRAY;
        }
        this.locations = this.getTranslationUnit().getLocationInfo(this.offset, this.length);
        return this.locations;
    }

    public String getRawSignature() {
        return this.getTranslationUnit().getUnpreprocessedSignature(this.getNodeLocations());
    }

    public String getContainingFilename() {
        return this.getTranslationUnit().getContainingFilename(this.offset);
    }

    public IASTFileLocation getFileLocation() {
        if (this.fileLocation != null) {
            return this.fileLocation;
        }
        this.fileLocation = this.getTranslationUnit().flattenLocationsToFile(this.getNodeLocations());
        return this.fileLocation;
    }
}

