/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index.ctagsindexer;

import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.CommandLauncher;
import org.eclipse.cdt.core.ConsoleOutputStream;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.ICExtensionReference;
import org.eclipse.cdt.core.IConsoleParser;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.cdt.internal.core.ConsoleOutputSniffer;
import org.eclipse.cdt.internal.core.index.ctagsindexer.CTagsConsoleParser;
import org.eclipse.cdt.internal.core.index.ctagsindexer.CTagsIndexer;
import org.eclipse.cdt.internal.core.index.domsourceindexer.AbstractIndexerRunner;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;

public class CTagsIndexerRunner
extends AbstractIndexerRunner {
    private CTagsIndexer indexer;
    String ctagsLocation;

    public CTagsIndexerRunner(IFile resource, CTagsIndexer indexer) {
        this.resourceFile = resource;
        this.indexer = indexer;
    }

    protected void indexFile(IFile file) throws IOException {
        Process p;
        ConsoleOutputStream cos;
        this.output.addIndexedFile(file.getFullPath().toString());
        String[] args = new String[]{"--excmd=number", "--format=2", "--sort=no", "--fields=aiKlmnsSz", "--c-types=cdefgmnpstuvx", "--c++-types=cdefgmnpstuvx", "--languages=c,c++", "-f", "-", this.resourceFile.getName()};
        IConsole console = CCorePlugin.getDefault().getConsole(null);
        console.start(this.resourceFile.getProject());
        try {
            cos = console.getOutputStream();
        }
        catch (CoreException coreException) {
            return;
        }
        CommandLauncher launcher = new CommandLauncher();
        try {
            this.resourceFile.getProject().deleteMarkers("org.eclipse.cdt.core.indexermarker", true, 0);
        }
        catch (CoreException coreException) {}
        long startTime = 0L;
        if (AbstractIndexerRunner.TIMING) {
            startTime = System.currentTimeMillis();
        }
        CTagsConsoleParser parser = new CTagsConsoleParser(this);
        IConsoleParser[] parsers = new IConsoleParser[]{parser};
        ConsoleOutputSniffer sniffer = new ConsoleOutputSniffer(parsers);
        OutputStream consoleOut = sniffer == null ? cos : sniffer.getOutputStream();
        OutputStream consoleErr = sniffer == null ? cos : sniffer.getErrorStream();
        IPath fileDirectory = this.resourceFile.getRawLocation().removeLastSegments(1);
        Path ctagsExecutable = new Path("ctags");
        if (!this.useDefaultCTags() && this.getCTagsLocation()) {
            ctagsExecutable = new Path(this.ctagsLocation);
        }
        if ((p = launcher.execute((IPath)ctagsExecutable, args, null, fileDirectory)) != null) {
            try {
                p.getOutputStream().close();
            }
            catch (IOException iOException) {}
            if (launcher.waitAndRead(consoleOut, consoleErr, (IProgressMonitor)new NullProgressMonitor()) != 0) {
                launcher.getErrorMessage();
            }
        } else {
            launcher.getErrorMessage();
            this.indexer.createProblemMarker(CCorePlugin.getResourceString("CTagsIndexMarker.CTagsMissing"), this.resourceFile.getProject());
        }
        consoleOut.close();
        consoleErr.close();
        cos.close();
        if (AbstractIndexerRunner.TIMING) {
            System.out.println("CTagsIndexer Total Time: " + (System.currentTimeMillis() - startTime));
            System.out.flush();
        }
    }

    private boolean useDefaultCTags() {
        try {
            ICDescriptor cdesc = CCorePlugin.getDefault().getCProjectDescription(this.indexer.getProject(), false);
            if (cdesc == null) {
                return true;
            }
            ICExtensionReference[] cext = cdesc.get("org.eclipse.cdt.core.CIndexer");
            if (cext.length > 0) {
                int i = 0;
                while (i < cext.length) {
                    String orig = cext[i].getExtensionData("ctagslocationtype");
                    if (orig != null) {
                        if (orig.equals("ctags_path_default")) {
                            return true;
                        }
                        if (orig.equals("ctags_path_specified")) {
                            return false;
                        }
                    }
                    ++i;
                }
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    private boolean getCTagsLocation() {
        try {
            ICDescriptor cdesc = CCorePlugin.getDefault().getCProjectDescription(this.indexer.getProject(), false);
            if (cdesc == null) {
                return false;
            }
            ICExtensionReference[] cext = cdesc.get("org.eclipse.cdt.core.CIndexer");
            if (cext.length > 0) {
                int i = 0;
                while (i < cext.length) {
                    String orig = cext[i].getExtensionData("ctagslocation");
                    if (orig != null) {
                        this.ctagsLocation = orig;
                        return true;
                    }
                    ++i;
                }
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    protected void addMarkers(IFile tempFile, IFile originator, Object problem, Object location) {
    }
}

