/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.sourcedependency;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.search.ICSearchConstants;
import org.eclipse.cdt.core.search.ICSearchScope;
import org.eclipse.cdt.core.search.SearchEngine;
import org.eclipse.cdt.internal.core.index.domsourceindexer.DOMSourceIndexer;
import org.eclipse.cdt.internal.core.search.PathCollector;
import org.eclipse.cdt.internal.core.search.PatternSearchJob;
import org.eclipse.cdt.internal.core.search.indexing.IndexManager;
import org.eclipse.cdt.internal.core.search.matching.CSearchPattern;
import org.eclipse.cdt.internal.core.search.processing.IIndexJob;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public class UpdateDependency
implements IIndexJob {
    PathCollector pathCollector;
    IFile resource = null;
    DOMSourceIndexer indexer;

    public UpdateDependency(IResource resource, DOMSourceIndexer indexer) {
        if (resource instanceof IFile) {
            this.resource = (IFile)resource;
        }
        this.indexer = indexer;
    }

    public boolean belongsTo(String jobFamily) {
        return false;
    }

    public void cancel() {
    }

    public boolean execute(IProgressMonitor progress) {
        if (this.resource == null) {
            return false;
        }
        IPath location = this.resource.getLocation();
        if (location == null) {
            return false;
        }
        PathCollector pathCollector = new PathCollector();
        ICSearchScope scope = SearchEngine.createWorkspaceScope();
        CSearchPattern pattern = CSearchPattern.createPattern(location.toOSString(), ICSearchConstants.INCLUDE, ICSearchConstants.REFERENCES, 0, true);
        IndexManager indexManager = CCorePlugin.getDefault().getCoreModel().getIndexManager();
        indexManager.performConcurrentJob(new PatternSearchJob(pattern, scope, pathCollector, indexManager), 3, null, this);
        String[] iPath = pathCollector.getPaths();
        if (iPath.length > 0) {
            int i = 0;
            while (i < iPath.length) {
                Path pathToReindex = new Path(iPath[i]);
                IWorkspaceRoot workRoot = this.resource.getWorkspace().getRoot();
                IFile fileToReindex = workRoot.getFile((IPath)pathToReindex);
                if (fileToReindex != null && fileToReindex.exists()) {
                    this.indexer.addSource(fileToReindex, fileToReindex.getProject().getFullPath());
                }
                ++i;
            }
        } else {
            this.indexer.addSource(this.resource, this.resource.getProject().getFullPath());
        }
        return false;
    }

    public boolean isReadyToRun() {
        return true;
    }
}

