/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.refactoring.tests;

import java.io.StringWriter;
import junit.framework.Assert;
import org.eclipse.cdt.core.tests.BaseTestFramework;
import org.eclipse.cdt.internal.core.dom.SavedCodeReaderFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusEntry;
import org.eclipse.ltk.core.refactoring.TextEditChangeGroup;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.search.internal.core.text.FileCharSequenceProvider;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public class RefactoringTests
extends BaseTestFramework {
    private int fBufferSize;

    public RefactoringTests() {
    }

    public RefactoringTests(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.fBufferSize = FileCharSequenceProvider.BUFFER_SIZE;
        FileCharSequenceProvider.BUFFER_SIZE = 4096;
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        SavedCodeReaderFactory.getInstance().getCodeReaderCache().flush();
        FileCharSequenceProvider.BUFFER_SIZE = this.fBufferSize;
    }

    protected void assertTotalChanges(int n, Change change) throws Exception {
        this.assertTotalChanges(n, 0, 0, change);
    }

    protected void assertTotalChanges(int n, int n2, int n3, Change change) throws Exception {
        int[] nArray = new int[3];
        if (change != null) {
            this.countChanges(change, nArray);
        }
        Assert.assertEquals((int)n, (int)nArray[0]);
        Assert.assertEquals((String)"potential changes: ", (int)n2, (int)nArray[1]);
        Assert.assertEquals((String)"comment changes: ", (int)n3, (int)nArray[2]);
    }

    private void countChanges(Change change, int[] nArray) {
        block3: {
            block2: {
                if (!(change instanceof CompositeChange)) break block2;
                Change[] changeArray = ((CompositeChange)change).getChildren();
                int n = 0;
                while (n < changeArray.length) {
                    this.countChanges(changeArray[n], nArray);
                    ++n;
                }
                break block3;
            }
            if (!(change instanceof TextFileChange)) break block3;
            TextFileChange textFileChange = (TextFileChange)change;
            TextEditChangeGroup[] textEditChangeGroupArray = textFileChange.getTextEditChangeGroups();
            int n = 0;
            while (n < textEditChangeGroupArray.length) {
                TextEditChangeGroup textEditChangeGroup = textEditChangeGroupArray[n];
                this.countChanges(textEditChangeGroup, nArray);
                ++n;
            }
        }
    }

    private void countChanges(TextEditChangeGroup textEditChangeGroup, int[] nArray) {
        String string = textEditChangeGroup.getName();
        if (string.indexOf("potential") != -1) {
            nArray[1] = nArray[1] + 1;
        } else if (string.indexOf("comment") != -1) {
            nArray[2] = nArray[2] + 1;
        } else {
            nArray[0] = nArray[0] + 1;
        }
    }

    protected void assertChange(Change change, IFile iFile, int n, int n2, String string) throws Exception {
        this.assertChange(change, iFile, n, n2, string, false);
    }

    protected void assertChange(Change change, IFile iFile, int n, int n2, String string, boolean bl) throws Exception {
        boolean bl2 = false;
        if (change != null && change instanceof CompositeChange) {
            bl2 = this.checkCompositeChange((CompositeChange)change, iFile, n, n2, string, bl);
        }
        if (!bl2) {
            Assert.fail((String)("Rename at offset " + n + " in \"" + iFile.getLocation() + "\" not found."));
            Assert.assertFalse((boolean)true);
        }
    }

    private boolean checkCompositeChange(CompositeChange compositeChange, IFile iFile, int n, int n2, String string, boolean bl) {
        boolean bl2 = false;
        Change[] changeArray = compositeChange.getChildren();
        int n3 = 0;
        while (n3 < changeArray.length) {
            TextFileChange textFileChange;
            if (changeArray[n3] instanceof CompositeChange) {
                bl2 = this.checkCompositeChange((CompositeChange)changeArray[n3], iFile, n, n2, string, bl);
            } else if (changeArray[n3] instanceof TextFileChange && (textFileChange = (TextFileChange)changeArray[n3]).getFile().toString().equals(iFile.toString())) {
                bl2 = this.checkTranslationUnitChange(textFileChange, n, n2, string, bl);
            }
            if (bl2) {
                return bl2;
            }
            ++n3;
        }
        return bl2;
    }

    private boolean checkTranslationUnitChange(TextFileChange textFileChange, int n, int n2, String string, boolean bl) {
        TextEditChangeGroup[] textEditChangeGroupArray = textFileChange.getTextEditChangeGroups();
        int n3 = 0;
        while (n3 < textEditChangeGroupArray.length) {
            TextEdit[] textEditArray;
            TextEditGroup textEditGroup = textEditChangeGroupArray[n3].getTextEditGroup();
            if (textEditGroup.getName().indexOf("potential") != -1 == bl && this.checkTextEdits(textEditArray = textEditGroup.getTextEdits(), n, n2, string)) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    private boolean checkTextEdit(TextEdit textEdit, int n, int n2, String string) {
        return textEdit instanceof MultiTextEdit ? this.checkTextEdits(((MultiTextEdit)textEdit).getChildren(), n, n2, string) : textEdit instanceof ReplaceEdit && this.checkReplaceEdit((ReplaceEdit)textEdit, n, n2, string);
    }

    private boolean checkTextEdits(TextEdit[] textEditArray, int n, int n2, String string) {
        int n3 = 0;
        while (n3 < textEditArray.length) {
            TextEdit textEdit = textEditArray[n3];
            if (this.checkTextEdit(textEdit, n, n2, string)) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    private boolean checkReplaceEdit(ReplaceEdit replaceEdit, int n, int n2, String string) {
        return replaceEdit.getOffset() == n && replaceEdit.getLength() == n2 && replaceEdit.getText().equals(string);
    }

    protected IFile createCppFwdDecls(String string) throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class class_fwd;         \n");
        stringWriter.write("struct struct_fwd;       \n");
        stringWriter.write("union union_fwd;         \n");
        stringWriter.write("int func_proto();        \n");
        stringWriter.write("int func_proto_ov();     \n");
        stringWriter.write("int func_proto_ov(int);  \n");
        stringWriter.write("int func_proto_ov(int*); \n");
        stringWriter.write("extern int extern_var;   \n");
        String string2 = stringWriter.toString();
        return this.importFile(string, string2);
    }

    protected IFile createCFwdDecls(String string) throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("struct struct_fwd;       \n");
        stringWriter.write("union union_fwd;         \n");
        stringWriter.write("int func_proto();        \n");
        stringWriter.write("extern int extern_var;   \n");
        String string2 = stringWriter.toString();
        return this.importFile(string, string2);
    }

    protected IFile createCppDefs(String string) throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class class_def {               \n");
        stringWriter.write("public:                         \n");
        stringWriter.write("   int member;                  \n");
        stringWriter.write("   static int static_member;    \n");
        stringWriter.write("   void method(int par);        \n");
        stringWriter.write("   void static_method(int par); \n");
        stringWriter.write("   int method_ov();             \n");
        stringWriter.write("   int method_ov(int);          \n");
        stringWriter.write("   int method_ov(int*);         \n");
        stringWriter.write("};                              \n");
        stringWriter.write("struct struct_def {        \n");
        stringWriter.write("   int st_member;          \n");
        stringWriter.write("};                         \n");
        stringWriter.write("union union_def {          \n");
        stringWriter.write("   int un_member;          \n");
        stringWriter.write("};                         \n");
        stringWriter.write("typedef int typedef_def;   \n");
        stringWriter.write("namespace namespace_def{}; \n");
        stringWriter.write("enum enum_def {            \n");
        stringWriter.write("   enum_item };            \n");
        stringWriter.write("int func_def() {}          \n");
        stringWriter.write("int func_def_ov() {}       \n");
        stringWriter.write("int func_def_ov(int){}     \n");
        stringWriter.write("int func_def_ov(int*){}    \n");
        stringWriter.write("int var_def;               \n");
        String string2 = stringWriter.toString();
        return this.importFile(string, string2);
    }

    protected IFile createCDefs(String string) throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("struct struct_def {        \n");
        stringWriter.write("   int st_member;          \n");
        stringWriter.write("};                         \n");
        stringWriter.write("union union_def {          \n");
        stringWriter.write("   int un_member;          \n");
        stringWriter.write("};                         \n");
        stringWriter.write("typedef int typedef_def;   \n");
        stringWriter.write("enum enum_def {            \n");
        stringWriter.write("   enum_item };            \n");
        stringWriter.write("int func_def() {}          \n");
        stringWriter.write("int var_def;               \n");
        String string2 = stringWriter.toString();
        return this.importFile(string, string2);
    }

    protected void assertRefactoringError(RefactoringStatus refactoringStatus, String string) {
        RefactoringStatusEntry refactoringStatusEntry = refactoringStatus.getEntryMatchingSeverity(3);
        Assert.assertNotNull((String)"Expected refactoring error!", (Object)refactoringStatusEntry);
        Assert.assertEquals((String)string, (String)refactoringStatusEntry.getMessage());
    }

    protected void assertRefactoringWarning(RefactoringStatus refactoringStatus, String string) {
        RefactoringStatusEntry refactoringStatusEntry = refactoringStatus.getEntryMatchingSeverity(2);
        Assert.assertNotNull((String)"Expected refactoring warning!", (Object)refactoringStatusEntry);
        Assert.assertEquals((String)string, (String)refactoringStatusEntry.getMessage());
    }

    protected void assertRefactoringOk(RefactoringStatus refactoringStatus) {
        Assert.assertTrue((String)("Expected refactoring status ok: " + refactoringStatus.getMessageMatchingSeverity(refactoringStatus.getSeverity())), (refactoringStatus.getSeverity() == 0 ? 1 : 0) != 0);
    }
}

