/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.refactoring.tests;

import java.io.StringWriter;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.cdt.core.tests.FailingTest;
import org.eclipse.cdt.refactoring.tests.RefactoringTests;
import org.eclipse.cdt.refactoring.tests.RenameTests;
import org.eclipse.core.resources.IFile;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class RenameMacroTests
extends RenameTests {
    static /* synthetic */ Class class$0;

    public RenameMacroTests(String string) {
        super(string);
    }

    public static Test suite() {
        return RenameMacroTests.suite(true);
    }

    public static Test suite(boolean bl) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.refactoring.tests.RenameMacroTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite testSuite = new TestSuite((Class)clazz);
        testSuite.addTest((Test)new FailingTest((Test)new RenameMacroTests("failingRenameMacroAsMacroArgument"), 94673));
        if (bl) {
            testSuite.addTest((Test)new RefactoringTests("cleanupProject"));
        }
        return testSuite;
    }

    public void testMacroRename() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("#define HALLO x   \n");
        stringWriter.write("class v1 {                \n");
        stringWriter.write(" int HALLO;                   \n");
        stringWriter.write("};                        \n");
        stringWriter.write("class HALLO {                \n");
        stringWriter.write(" int v;                   \n");
        stringWriter.write("};                        \n");
        stringWriter.write("class v3 {                \n");
        stringWriter.write(" int v;                   \n");
        stringWriter.write("};                        \n");
        stringWriter.write("class v4 {                \n");
        stringWriter.write(" int HALLO();          \n");
        stringWriter.write("};                        \n");
        stringWriter.write("int v4::HALLO(){}      \n");
        stringWriter.write("void f(int par1){         \n");
        stringWriter.write("  {                       \n");
        stringWriter.write("     int HALLO; v1::v++;    \n");
        stringWriter.write("  }                       \n");
        stringWriter.write("}                         \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("test.cpp", string);
        int n = string.indexOf("HALLO");
        int n2 = string.indexOf("HALLO", n + 1);
        Change change = this.getRefactorChanges(iFile, n, "WELT");
        this.assertTotalChanges(6, change);
        int n3 = n;
        this.assertChange(change, iFile, n3, 5, "WELT");
        n3 = string.indexOf("HALLO", n3 + 1);
        this.assertChange(change, iFile, n3, 5, "WELT");
        n3 = string.indexOf("HALLO", n3 + 1);
        this.assertChange(change, iFile, n3, 5, "WELT");
        n3 = string.indexOf("HALLO", n3 + 1);
        this.assertChange(change, iFile, n3, 5, "WELT");
        n3 = string.indexOf("HALLO", n3 + 1);
        this.assertChange(change, iFile, n3, 5, "WELT");
        n3 = string.indexOf("HALLO", n3 + 1);
        this.assertChange(change, iFile, n3, 5, "WELT");
        n3 = string.indexOf("HALLO", n3 + 1);
        change = this.getRefactorChanges(iFile, n2, "WELT");
        this.assertTotalChanges(6, change);
        n3 = n;
        this.assertChange(change, iFile, n3, 5, "WELT");
        n3 = string.indexOf("HALLO", n3 + 1);
        this.assertChange(change, iFile, n3, 5, "WELT");
        n3 = string.indexOf("HALLO", n3 + 1);
        this.assertChange(change, iFile, n3, 5, "WELT");
        n3 = string.indexOf("HALLO", n3 + 1);
        this.assertChange(change, iFile, n3, 5, "WELT");
        n3 = string.indexOf("HALLO", n3 + 1);
        this.assertChange(change, iFile, n3, 5, "WELT");
        n3 = string.indexOf("HALLO", n3 + 1);
        this.assertChange(change, iFile, n3, 5, "WELT");
        n3 = string.indexOf("HALLO", n3 + 1);
    }

    public void testMacroNameConflicts() throws Exception {
        this.createCppFwdDecls("cpp_fwd.hh");
        this.createCppDefs("cpp_def.hh");
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("#include \"cpp_fwd.hh\"   \n");
        stringWriter.write("#include \"cpp_def.hh\"   \n");
        stringWriter.write("#define MACRO 1           \n");
        stringWriter.write("int v1(); int v2(); int v3();  \n");
        stringWriter.write("static int s1();          \n");
        stringWriter.write("static int s2();          \n");
        stringWriter.write("void f(int par1){         \n");
        stringWriter.write("     int w1; v1();        \n");
        stringWriter.write("}                         \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("test.cpp", string);
        stringWriter = new StringWriter();
        stringWriter.write("static int static_other_file();     \n");
        this.importFile("other.cpp", stringWriter.toString());
        int n = string.indexOf("MACRO");
        RefactoringStatus refactoringStatus = this.checkConditions(iFile, n, "w1");
        this.assertRefactoringError(refactoringStatus, "'w1' will conflict with the name of a local variable.");
        refactoringStatus = this.checkConditions(iFile, string.indexOf("par1"), "MACRO");
        this.assertRefactoringError(refactoringStatus, "'MACRO' conflicts with the name of an existing macro!");
        refactoringStatus = this.checkConditions(iFile, n, "par1");
        this.assertRefactoringError(refactoringStatus, "'par1' will conflict with the name of a parameter.");
        refactoringStatus = this.checkConditions(iFile, n, "extern_var");
        this.assertRefactoringError(refactoringStatus, "'extern_var' will conflict with the name of a global variable.");
        refactoringStatus = this.checkConditions(iFile, n, "var_def");
        this.assertRefactoringError(refactoringStatus, "'var_def' will conflict with the name of a global variable.");
        refactoringStatus = this.checkConditions(iFile, n, "enum_item");
        this.assertRefactoringError(refactoringStatus, "'enum_item' will conflict with the name of an enumerator.");
    }

    public void testClassMacroClash() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class CC {int a;};         \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("test.cpp", string);
        stringWriter = new StringWriter();
        stringWriter.write("#define CC mm              \n");
        stringWriter.write("int CC;                   \n");
        String string2 = stringWriter.toString();
        IFile iFile2 = this.importFile("test2.cpp", string2);
        int n = string.indexOf("CC");
        Change change = this.getRefactorChanges(iFile, n, "CCC");
        this.assertTotalChanges(1, change);
        int n2 = string2.indexOf("CC");
        change = this.getRefactorChanges(iFile2, n2, "CCC");
        this.assertTotalChanges(2, change);
    }

    public void testIncludeGuard() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("#ifndef _guard            \n");
        stringWriter.write("#define _guard            \n");
        stringWriter.write(" int HALLO                \n");
        stringWriter.write("#endif /* _guard */       \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("test.cpp", string);
        int n = string.indexOf("_guard");
        int n2 = string.indexOf("_guard", n + 1);
        Change change = this.getRefactorChanges(iFile, n2, "WELT");
        this.assertTotalChanges(2, 0, 1, change);
        int n3 = n;
        this.assertChange(change, iFile, n3, 6, "WELT");
        n3 = string.indexOf("_guard", n3 + 1);
        this.assertChange(change, iFile, n3, 6, "WELT");
    }

    public void testMacroParameters() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("int var;                  \n");
        stringWriter.write("#define M1(var) var       \n");
        stringWriter.write("#define M2(var, x) (var+x)*var  \n");
        stringWriter.write("#define M3 var            \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("test.cpp", string);
        int n = string.indexOf("var");
        Change change = this.getRefactorChanges(iFile, n, "xxx");
        this.assertTotalChanges(1, 1, 0, change);
    }

    public void failingRenameMacroAsMacroArgument() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("#define M1(var) var       \n");
        stringWriter.write("#define M2 1              \n");
        stringWriter.write("int b= M2;                \n");
        stringWriter.write("int a= M1(M2);            \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("test.cpp", string);
        int n = string.indexOf("M2");
        Change change = this.getRefactorChanges(iFile, n, "xxx");
        this.assertTotalChanges(this.countOccurrences(string, "M2"), change);
    }
}

