/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.refactoring.tests;

import java.io.StringWriter;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.cdt.refactoring.tests.RefactoringTests;
import org.eclipse.cdt.refactoring.tests.RenameTests;
import org.eclipse.core.resources.IFile;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class RenameTemplatesTests
extends RenameTests {
    static /* synthetic */ Class class$0;

    public RenameTemplatesTests(String string) {
        super(string);
    }

    public static Test suite() {
        return RenameTemplatesTests.suite(true);
    }

    public static Test suite(boolean bl) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.refactoring.tests.RenameTemplatesTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite testSuite = new TestSuite((Class)clazz);
        if (bl) {
            testSuite.addTest((Test)new RefactoringTests("cleanupProject"));
        }
        return testSuite;
    }

    public void testClassTemplate() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("template <class Type>   \n");
        stringWriter.write("class Array {                \n");
        stringWriter.write("public:                   \n");
        stringWriter.write("   Array(unsigned sz) {}  \n");
        stringWriter.write("   ~Array(){}             \n");
        stringWriter.write("   Type& operator[] (unsigned idx); \n");
        stringWriter.write("};                        \n");
        stringWriter.write("template <class Type>     \n");
        stringWriter.write("inline Type& Array<Type>::operator[] (unsigned index) {\n");
        stringWriter.write("   return 1;              \n");
        stringWriter.write("};                        \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("test.cpp", string);
        int n = string.indexOf("Array");
        RefactoringStatus refactoringStatus = this.checkConditions(iFile, n, "WELT");
        this.assertRefactoringOk(refactoringStatus);
        Change change = this.getRefactorChanges(iFile, n, "WELT");
        this.assertTotalChanges(4, change);
    }
}

