/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.tests.IndexerView;

import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.index.IEntryResult;
import org.eclipse.cdt.ui.testplugin.CTestPlugin;
import org.eclipse.cdt.ui.tests.IndexerView.FilterIndexerViewDialog;
import org.eclipse.cdt.ui.tests.IndexerView.IndexerFilterManager;
import org.eclipse.cdt.ui.tests.IndexerView.IndexerNodeLeaf;
import org.eclipse.cdt.ui.tests.IndexerView.IndexerView;

public class IndexerNodeParent
extends IndexerNodeLeaf {
    public static final int PAGE_SIZE = 40;
    private int pageSize = 40;
    private static final IndexerNodeLeaf[] EMPTY_INDEXER_NODE_LEAVES = new IndexerNodeLeaf[0];
    private IndexerNodeLeaf[] children = EMPTY_INDEXER_NODE_LEAVES;
    private IndexerNodeLeaf[] childrenToDisplay = new IndexerNodeLeaf[40];
    private int lastBackwardDisplayed = 0;
    private int lastForwardDisplayed = 0;
    private boolean isForward = true;
    private boolean firstDisplay = true;
    private IndexerFilterManager filterManager = null;
    private IndexerView.ViewContentProvider view = null;
    private boolean sort = true;
    private boolean displayFullName = true;
    private boolean navigate = false;
    private int totalNumberOfFilesIndexed = 0;
    static /* synthetic */ Class class$0;

    public IndexerNodeParent(IEntryResult iEntryResult, String[] stringArray, IndexerView.ViewContentProvider viewContentProvider) {
        super(iEntryResult, stringArray);
        FilterIndexerViewDialog filterIndexerViewDialog = new FilterIndexerViewDialog(CTestPlugin.getStandardDisplay().getActiveShell(), this, viewContentProvider.getProjectName());
        filterIndexerViewDialog.readSettings(filterIndexerViewDialog.getDialogSettings());
        this.filterManager = filterIndexerViewDialog.createFilterManager();
        this.pageSize = filterIndexerViewDialog.getPageSize();
        this.view = viewContentProvider;
    }

    public IndexerNodeLeaf[] getChildren() {
        if (this.children.length == 0) {
            return EMPTY_INDEXER_NODE_LEAVES;
        }
        if (!this.navigate) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.ui.tests.IndexerView.IndexerNodeLeaf");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (IndexerNodeLeaf[])ArrayUtil.removeNulls((Class)clazz, (Object[])this.childrenToDisplay);
        }
        this.navigate = false;
        if (!this.firstDisplay && (!this.isForward && this.lastBackwardDisplayed == 0 || this.isForward && this.lastForwardDisplayed == this.children.length - 1)) {
            Class<?> clazz;
            if (this.isForward) {
                this.view.setDisplayForwards(false);
            } else {
                this.view.setDisplayBackwards(false);
            }
            if ((clazz = class$0) == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.ui.tests.IndexerView.IndexerNodeLeaf");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (IndexerNodeLeaf[])ArrayUtil.removeNulls((Class)clazz, (Object[])this.childrenToDisplay);
        }
        if (this.firstDisplay && this.children.length > 1) {
            if (this.sort) {
                IndexerNodeParent.quickSort(this.children, 0, this.children.length - 1, true);
            } else {
                IndexerNodeParent.quickSort(this.children, 0, this.children.length - 1, false);
            }
        }
        int n = 0;
        n = this.isForward ? (this.lastForwardDisplayed == 0 ? 0 : this.lastForwardDisplayed + 1) : (this.lastBackwardDisplayed == 0 ? 0 : this.lastBackwardDisplayed - 1);
        boolean bl = true;
        int n2 = 0;
        int n3 = n;
        int n4 = this.isForward ? 0 : this.pageSize - 1;
        IndexerNodeLeaf[] indexerNodeLeafArray = new IndexerNodeLeaf[this.pageSize];
        boolean bl2 = false;
        while (n2 < this.pageSize && n3 < this.children.length && n3 >= 0) {
            bl = this.filterManager.isFiltered(this.children[n3]);
            if (bl) {
                bl2 = true;
                indexerNodeLeafArray[n4] = this.children[n3];
                ++n2;
                if (this.isForward) {
                    this.lastForwardDisplayed = n3;
                } else if (n4 == this.pageSize - 1) {
                    this.lastForwardDisplayed = n3;
                }
                if (n4 == 0) {
                    this.lastBackwardDisplayed = n3;
                }
                if (this.isForward) {
                    if (n4 + 1 < indexerNodeLeafArray.length) {
                        ++n4;
                    }
                } else if (n4 - 1 >= 0) {
                    --n4;
                }
            }
            bl = true;
            if (this.isForward) {
                ++n3;
                continue;
            }
            --n3;
        }
        if (bl2) {
            this.childrenToDisplay = new IndexerNodeLeaf[this.pageSize];
            int n5 = 0;
            int n6 = 0;
            while (n5 < indexerNodeLeafArray.length) {
                if (indexerNodeLeafArray[n5] != null) {
                    this.childrenToDisplay[n5] = indexerNodeLeafArray[n5];
                    ++n6;
                }
                ++n5;
            }
            if (this.isForward) {
                if (this.firstDisplay) {
                    this.view.setDisplayForwards(true);
                } else {
                    this.view.setDisplayBackwards(true);
                }
            } else {
                this.view.setDisplayForwards(true);
            }
        } else if (this.isForward) {
            this.view.setDisplayForwards(false);
        } else {
            this.view.setDisplayBackwards(false);
        }
        this.firstDisplay = false;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.ui.tests.IndexerView.IndexerNodeLeaf");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IndexerNodeLeaf[])ArrayUtil.removeNulls((Class)clazz, (Object[])this.childrenToDisplay);
    }

    private static void quickSort(IndexerNodeLeaf[] indexerNodeLeafArray, int n, int n2, boolean bl) {
        int n3 = n;
        int n4 = n2;
        String string = null;
        string = bl ? indexerNodeLeafArray[(n + n2) / 2].getName().toUpperCase() : new String(indexerNodeLeafArray[(n + n2) / 2].getResult().getName()).toUpperCase();
        do {
            String string2 = null;
            String string3 = null;
            if (bl) {
                string2 = indexerNodeLeafArray[n].getName().toUpperCase();
                string3 = indexerNodeLeafArray[n2].getName().toUpperCase();
            } else {
                string2 = new String(indexerNodeLeafArray[n].getResult().getName()).toUpperCase();
                string3 = new String(indexerNodeLeafArray[n2].getResult().getName()).toUpperCase();
            }
            while (string2.compareTo(string) < 0) {
                ++n;
                string2 = bl ? indexerNodeLeafArray[n].getName().toUpperCase() : new String(indexerNodeLeafArray[n].getResult().getName()).toUpperCase();
            }
            while (string.compareTo(string3) < 0) {
                --n2;
                string3 = bl ? indexerNodeLeafArray[n2].getName().toUpperCase() : new String(indexerNodeLeafArray[n2].getResult().getName()).toUpperCase();
            }
            if (n > n2) continue;
            IndexerNodeLeaf indexerNodeLeaf = indexerNodeLeafArray[n];
            indexerNodeLeafArray[n] = indexerNodeLeafArray[n2];
            indexerNodeLeafArray[n2] = indexerNodeLeaf;
            ++n;
            --n2;
        } while (n <= n2);
        if (n3 < n2) {
            IndexerNodeParent.quickSort(indexerNodeLeafArray, n3, n2, bl);
        }
        if (n < n4) {
            IndexerNodeParent.quickSort(indexerNodeLeafArray, n, n4, bl);
        }
    }

    public void setChildren(IndexerNodeLeaf[] indexerNodeLeafArray) {
        this.children = indexerNodeLeafArray;
    }

    public boolean hasChildren() {
        return this.children != null && this.children.length > 0;
    }

    public int getFullLength() {
        return this.children.length;
    }

    public void setIsForward(boolean bl) {
        this.isForward = bl;
    }

    public void setFilterManager(boolean[] blArray, String string) {
        this.filterManager = new IndexerFilterManager(blArray, string);
    }

    public void reset() {
        this.navigate = true;
        this.lastBackwardDisplayed = 0;
        this.lastForwardDisplayed = 0;
        this.isForward = true;
        this.firstDisplay = true;
        this.childrenToDisplay = EMPTY_INDEXER_NODE_LEAVES;
    }

    public void setPageSize(int n) {
        this.pageSize = n;
    }

    public void setView(IndexerView.ViewContentProvider viewContentProvider) {
        this.view = viewContentProvider;
    }

    public int getFilteredCount() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.children.length) {
            if (this.filterManager.isFiltered(this.children[n2])) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public boolean isSort() {
        return this.sort;
    }

    public void setSort(boolean bl) {
        this.sort = bl;
    }

    public boolean isDisplayFullName() {
        return this.displayFullName;
    }

    public void setDisplayFullName(boolean bl) {
        this.displayFullName = bl;
    }

    public boolean isNavigate() {
        return this.navigate;
    }

    public void setNavigate(boolean bl) {
        this.navigate = bl;
    }

    public int getTotalNumberOfFilesIndexed() {
        return this.totalNumberOfFilesIndexed;
    }

    public void setTotalNumberOfFilesIndexed(int n) {
        this.totalNumberOfFilesIndexed = n;
    }
}

