/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.tests.IndexerView;

import java.io.IOException;
import org.eclipse.cdt.core.index.ICDTIndexer;
import org.eclipse.cdt.internal.core.index.IEntryResult;
import org.eclipse.cdt.internal.core.index.IIndex;
import org.eclipse.cdt.ui.testplugin.CTestPlugin;
import org.eclipse.cdt.ui.tests.IndexerView.FilterIndexerViewDialog;
import org.eclipse.cdt.ui.tests.IndexerView.IndexerNodeLeaf;
import org.eclipse.cdt.ui.tests.IndexerView.IndexerNodeParent;
import org.eclipse.cdt.ui.tests.IndexerView.IndexerQuery;
import org.eclipse.cdt.ui.tests.IndexerView.IndexerViewPluginImages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.properties.PropertySheet;

public class IndexerView
extends ViewPart {
    private static final int DEFAULT_INDEXER_SIZE = 1;
    private static final String SWITCH_FULL_NAMES = "Switch Full Names";
    private static final String SORT_RESULTS = "Sort Results";
    private static final String SEARCH_LOCATIONS = "Search Locations";
    private static final String _TOTAL_IENTRYRESULTS = " total IEntryResults\n";
    private static final String _FILTERED_IENTRY_RESULTS_ = " filtered IEntry Results\n";
    private static final String _TOTAL_INDEXEDFILES = " total files indexed";
    private static final String INDEXER_STATS = "Indexer Stats";
    private static final String DISPLAY_INDEX_STATS = "Display Index Stats";
    private static final String INDEXER_VIEW___ = "Indexer View - ";
    private static final String _INDEXER_MENU_MANAGER = "#Indexer_Menu_Manager";
    private static final String SET_FILTERS = "Set Filters";
    private static final String NEXT_PAGE = "Next Page";
    private static final String PREVIOUS_PAGE = "Previous Page";
    public static final String VIEW_ID = "org.eclipse.cdt.ui.tests.IndexerView";
    private static final String PROPERTIES_VIEW = "org.eclipse.ui.views.PropertySheet";
    protected static final String BLANK_STRING = "";
    static TableViewer viewer;
    protected Action searchLocationAction;
    protected Action previousPageAction;
    protected Action nextPageAction;
    protected Action singleClickAction;
    protected Action setFiltersAction;
    protected Action sortAction;
    protected Action displayFullNameAction;
    protected Action displayStatsAction;
    protected ICDTIndexer[] indexers = new ICDTIndexer[1];
    protected IProject project = null;
    protected static ViewContentProvider.StartInitializingIndexerView initializeIndexerViewJob;

    static {
        initializeIndexerViewJob = null;
    }

    public void createPartControl(Composite composite) {
        viewer = new TableViewer(composite, 770);
        viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        viewer.setInput((Object)this.getViewSite());
        this.makeActions();
        this.hookContextMenu();
        this.hookSingleClickAction();
        this.contributeToActionBars();
    }

    protected void enableButtons(boolean bl) {
        this.setFiltersAction.setEnabled(bl);
        this.setFiltersAction.setEnabled(bl);
        this.sortAction.setEnabled(bl);
        this.displayFullNameAction.setEnabled(bl);
    }

    private void makeActions() {
        this.searchLocationAction = new SearchLocationsAction();
        this.searchLocationAction.setText(SEARCH_LOCATIONS);
        this.searchLocationAction.setToolTipText(SEARCH_LOCATIONS);
        this.searchLocationAction.setImageDescriptor(IndexerViewPluginImages.DESC_SEARCH_LOCATION);
        this.previousPageAction = new Action(){

            public void run() {
                if (viewer.getContentProvider() instanceof ViewContentProvider) {
                    IndexerNodeParent indexerNodeParent = ((ViewContentProvider)viewer.getContentProvider()).getInvisibleRoot();
                    indexerNodeParent.setIsForward(false);
                    indexerNodeParent.setNavigate(true);
                }
                viewer.refresh();
                this.setEnabled(((ViewContentProvider)viewer.getContentProvider()).isDisplayBackwards());
                IndexerView.this.nextPageAction.setEnabled(((ViewContentProvider)viewer.getContentProvider()).isDisplayForwards());
            }
        };
        this.previousPageAction.setText(PREVIOUS_PAGE);
        this.previousPageAction.setToolTipText(PREVIOUS_PAGE);
        this.previousPageAction.setImageDescriptor(IndexerViewPluginImages.DESC_BACK);
        this.nextPageAction = new Action(){

            public void run() {
                if (viewer.getContentProvider() instanceof ViewContentProvider) {
                    IndexerNodeParent indexerNodeParent = ((ViewContentProvider)viewer.getContentProvider()).getInvisibleRoot();
                    indexerNodeParent.setIsForward(true);
                    indexerNodeParent.setNavigate(true);
                }
                viewer.refresh();
                IndexerView.this.previousPageAction.setEnabled(((ViewContentProvider)viewer.getContentProvider()).isDisplayBackwards());
                this.setEnabled(((ViewContentProvider)viewer.getContentProvider()).isDisplayForwards());
            }
        };
        this.nextPageAction.setText(NEXT_PAGE);
        this.nextPageAction.setToolTipText(NEXT_PAGE);
        this.nextPageAction.setImageDescriptor(IndexerViewPluginImages.DESC_NEXT);
        this.setFiltersAction = new Action(){

            public void run() {
                if (!(viewer.getContentProvider() instanceof ViewContentProvider)) {
                    return;
                }
                FilterIndexerViewDialog filterIndexerViewDialog = new FilterIndexerViewDialog(IndexerView.this.getSite().getShell(), ((ViewContentProvider)viewer.getContentProvider()).getInvisibleRoot(), IndexerView.this.project == null ? IndexerView.BLANK_STRING : IndexerView.this.project.getName());
                int n = filterIndexerViewDialog.open();
                if (n == 0) {
                    ((ViewContentProvider)viewer.getContentProvider()).getInvisibleRoot().reset();
                    viewer.refresh();
                }
            }
        };
        this.setFiltersAction.setText(SET_FILTERS);
        this.setFiltersAction.setToolTipText(SET_FILTERS);
        this.setFiltersAction.setImageDescriptor(IndexerViewPluginImages.DESC_FILTER_BUTTON);
        this.sortAction = new Action(){

            public void run() {
                if (viewer.getContentProvider() instanceof ViewContentProvider) {
                    IndexerView.this.enableButtons(false);
                    if (((ViewContentProvider)viewer.getContentProvider()).getInvisibleRoot().isSort()) {
                        ((ViewContentProvider)viewer.getContentProvider()).getInvisibleRoot().setSort(false);
                        ((ViewContentProvider)viewer.getContentProvider()).getInvisibleRoot().reset();
                        viewer.refresh();
                        this.setImageDescriptor(IndexerViewPluginImages.DESC_SORT);
                    } else {
                        ((ViewContentProvider)viewer.getContentProvider()).getInvisibleRoot().setSort(true);
                        ((ViewContentProvider)viewer.getContentProvider()).getInvisibleRoot().reset();
                        viewer.refresh();
                        this.setImageDescriptor(IndexerViewPluginImages.DESC_SORTED);
                    }
                    IndexerView.this.enableButtons(true);
                }
            }
        };
        this.sortAction.setText(SORT_RESULTS);
        this.sortAction.setToolTipText(SORT_RESULTS);
        this.sortAction.setImageDescriptor(IndexerViewPluginImages.DESC_SORTED);
        this.displayFullNameAction = new Action(){

            public void run() {
                if (viewer.getContentProvider() instanceof ViewContentProvider) {
                    if (((ViewContentProvider)viewer.getContentProvider()).getInvisibleRoot().isDisplayFullName()) {
                        ((ViewContentProvider)viewer.getContentProvider()).getInvisibleRoot().setDisplayFullName(false);
                        viewer.refresh();
                        this.setImageDescriptor(IndexerViewPluginImages.DESC_DISPLAY_FULL_NAME);
                    } else {
                        ((ViewContentProvider)viewer.getContentProvider()).getInvisibleRoot().setDisplayFullName(true);
                        viewer.refresh();
                        this.setImageDescriptor(IndexerViewPluginImages.DESC_FULL_NAME_DISPLAYED);
                    }
                }
            }
        };
        this.displayFullNameAction.setText(SWITCH_FULL_NAMES);
        this.displayFullNameAction.setToolTipText(SWITCH_FULL_NAMES);
        this.displayFullNameAction.setImageDescriptor(IndexerViewPluginImages.DESC_FULL_NAME_DISPLAYED);
        this.displayStatsAction = new Action(){

            public void run() {
                CTestPlugin.getStandardDisplay().asyncExec(new Runnable(this){
                    final /* synthetic */ 7 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        if (viewer.getContentProvider() instanceof ViewContentProvider) {
                            IndexerNodeParent indexerNodeParent = ((ViewContentProvider)viewer.getContentProvider()).getInvisibleRoot();
                            MessageDialog.openInformation((Shell)7.access$0(this.this$1).getSite().getShell(), (String)"Indexer Stats", (String)(String.valueOf(indexerNodeParent.getFilteredCount()) + " filtered IEntry Results\n" + indexerNodeParent.getFullLength() + " total IEntryResults\n" + indexerNodeParent.getTotalNumberOfFilesIndexed() + " total files indexed"));
                        }
                    }
                });
            }

            static /* synthetic */ IndexerView access$0(7 var0) {
                return var0.IndexerView.this;
            }
        };
        this.displayStatsAction.setText(DISPLAY_INDEX_STATS);
        this.displayStatsAction.setToolTipText(DISPLAY_INDEX_STATS);
        this.displayStatsAction.setImageDescriptor(IndexerViewPluginImages.DESC_STATS);
        this.singleClickAction = new IndexerHighlighterAction();
    }

    private void hookContextMenu() {
        MenuManager menuManager = new MenuManager(_INDEXER_MENU_MANAGER);
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            private void hideMenuItems(IMenuManager iMenuManager) {
            }

            public void menuAboutToShow(IMenuManager iMenuManager) {
                IndexerView.this.fillContextMenu(iMenuManager);
                this.hideMenuItems(iMenuManager);
            }
        });
        Menu menu = menuManager.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)viewer);
    }

    void fillContextMenu(IMenuManager iMenuManager) {
        iMenuManager.add((IAction)this.searchLocationAction);
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IContributionItem)new Separator("additions"));
    }

    private void hookSingleClickAction() {
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                IndexerView.this.singleClickAction.run();
            }
        });
    }

    private void contributeToActionBars() {
        IActionBars iActionBars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(iActionBars.getMenuManager());
        this.fillLocalToolBar(iActionBars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager iMenuManager) {
    }

    private void fillLocalToolBar(IToolBarManager iToolBarManager) {
        iToolBarManager.add((IAction)this.previousPageAction);
        iToolBarManager.add((IAction)this.nextPageAction);
        iToolBarManager.add((IContributionItem)new Separator());
        iToolBarManager.add((IAction)this.sortAction);
        iToolBarManager.add((IAction)this.displayFullNameAction);
        iToolBarManager.add((IAction)this.setFiltersAction);
        iToolBarManager.add((IContributionItem)new Separator());
        iToolBarManager.add((IAction)this.displayStatsAction);
        iToolBarManager.add((IContributionItem)new Separator());
    }

    public void setFocus() {
        IViewPart iViewPart = this.getSite().getPage().findView(PROPERTIES_VIEW);
        if (iViewPart instanceof PropertySheet) {
            ((PropertySheet)iViewPart).selectionChanged(this.getSite().getPart(), viewer.getSelection());
        }
    }

    public void appendIndexer(ICDTIndexer iCDTIndexer) {
        this.indexers[0] = iCDTIndexer;
    }

    public void clearIndexers() {
        this.indexers = new ICDTIndexer[1];
    }

    public void setContentProvider(ViewContentProvider viewContentProvider) {
        viewer.setContentProvider((IContentProvider)viewContentProvider);
    }

    public void setProject(IProject iProject) {
        this.setPartName(INDEXER_VIEW___ + iProject.getName());
        this.project = iProject;
    }

    public static ViewerFilter[] getViewerFilters() {
        return viewer.getFilters();
    }

    public String getProjectName() {
        if (this.project == null) {
            return BLANK_STRING;
        }
        return this.project.getName();
    }

    public static int getKey(int n, int n2, int n3) {
        switch (n3) {
            case 2: {
                switch (n) {
                    case 1: {
                        return 11;
                    }
                    case 2: {
                        return 3;
                    }
                    case 3: {
                        return 10;
                    }
                    case 4: {
                        return 8;
                    }
                    case 5: {
                        return -1;
                    }
                    case 6: {
                        return 4;
                    }
                    case 7: {
                        return 9;
                    }
                    case 8: {
                        return 20;
                    }
                    case 9: {
                        return 14;
                    }
                }
                break;
            }
            case 1: 
            case 3: {
                switch (n) {
                    case 1: {
                        switch (n2) {
                            case 1: {
                                return 13;
                            }
                            case 2: {
                                return 15;
                            }
                            case 3: {
                                return 17;
                            }
                            case 4: {
                                return 16;
                            }
                            case 5: {
                                return 12;
                            }
                            case 6: {
                                return 18;
                            }
                            case 7: {
                                return 19;
                            }
                        }
                    }
                    case 2: {
                        return 1;
                    }
                    case 3: {
                        return 7;
                    }
                    case 4: {
                        return 5;
                    }
                    case 5: {
                        return 0;
                    }
                    case 6: {
                        return 2;
                    }
                    case 7: {
                        return 6;
                    }
                    case 8: {
                        return -1;
                    }
                    case 9: {
                        return 14;
                    }
                }
            }
        }
        return 0;
    }

    public class ViewContentProvider
    implements IStructuredContentProvider,
    ITreeContentProvider {
        private static final String POPULATING_INDEXER_VIEW = "populating indexer view";
        protected IndexerNodeParent invisibleRoot;
        protected boolean displayForwards = false;
        protected boolean displayBackwards = false;

        public ViewContentProvider() {
            this(null, false, false);
        }

        public void setDisplayForwards(boolean bl) {
            this.displayForwards = bl;
        }

        public void setDisplayBackwards(boolean bl) {
            this.displayBackwards = bl;
        }

        public ViewContentProvider(IndexerNodeParent indexerNodeParent, boolean bl, boolean bl2) {
            if (indexerNodeParent == null) {
                this.invisibleRoot = new IndexerNodeParent(null, null, this);
                initializeIndexerViewJob = new StartInitializingIndexerView(new InitializeView(POPULATING_INDEXER_VIEW, viewer), true);
                initializeIndexerViewJob.schedule();
            } else {
                this.invisibleRoot = indexerNodeParent;
                initializeIndexerViewJob = new StartInitializingIndexerView(new InitializeView(POPULATING_INDEXER_VIEW, viewer), false);
                initializeIndexerViewJob.schedule();
            }
            this.invisibleRoot.reset();
            this.displayForwards = bl;
            this.displayBackwards = bl2;
        }

        public Object[] getElements(Object object) {
            if (object.equals(IndexerView.this.getViewSite())) {
                return this.getChildren(this.invisibleRoot);
            }
            return this.getChildren(object);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }

        public Object[] getChildren(Object object) {
            if (object instanceof IndexerNodeParent) {
                return ((IndexerNodeParent)object).getChildren();
            }
            return new Object[0];
        }

        public Object getParent(Object object) {
            if (object instanceof IndexerNodeLeaf) {
                return ((IndexerNodeLeaf)object).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object object) {
            if (object instanceof IndexerNodeParent) {
                return ((IndexerNodeParent)object).hasChildren();
            }
            return false;
        }

        public IndexerNodeParent getInvisibleRoot() {
            return this.invisibleRoot;
        }

        public boolean isDisplayForwards() {
            return this.displayForwards;
        }

        public boolean isDisplayBackwards() {
            return this.displayBackwards;
        }

        public String getProjectName() {
            if (IndexerView.this.project == null) {
                return IndexerView.BLANK_STRING;
            }
            return IndexerView.this.project.getName();
        }

        private class InitializeView
        extends Job {
            private static final String NULL_PROJECT_SELECTED = "A null project was selected.";
            private static final String ALL_NAME_SEARCH = "*";
            private static final String INDEXER_VIEW = "Indexer View";
            TableViewer theViewer = null;

            public InitializeView(String string, TableViewer tableViewer) {
                super(string);
                this.theViewer = tableViewer;
            }

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                int n = 0;
                while (n < ((ViewContentProvider)ViewContentProvider.this).IndexerView.this.indexers.length) {
                    if (((ViewContentProvider)ViewContentProvider.this).IndexerView.this.indexers[n] instanceof ICDTIndexer) {
                        if (((ViewContentProvider)ViewContentProvider.this).IndexerView.this.project == null) {
                            CTestPlugin.getStandardDisplay().asyncExec(new Runnable(this){
                                final /* synthetic */ InitializeView this$2;
                                {
                                    this.this$2 = initializeView;
                                }

                                public void run() {
                                    MessageDialog.openInformation((Shell)this.this$2.theViewer.getControl().getShell(), (String)"Indexer View", (String)"A null project was selected.");
                                }
                            });
                            return Status.CANCEL_STATUS;
                        }
                        IIndex iIndex = ((ViewContentProvider)ViewContentProvider.this).IndexerView.this.indexers[n].getIndex(((ViewContentProvider)ViewContentProvider.this).IndexerView.this.project.getFullPath(), true, true);
                        if (iIndex == null) {
                            return Status.CANCEL_STATUS;
                        }
                        try {
                            IEntryResult[] iEntryResultArray = iIndex.getEntries(0, 0, 0);
                            if (iEntryResultArray == null) {
                                return Status.CANCEL_STATUS;
                            }
                            String[] stringArray = iIndex.getDocumentList();
                            ViewContentProvider.this.invisibleRoot.setTotalNumberOfFilesIndexed(stringArray.length - 1);
                            int n2 = iEntryResultArray.length;
                            IndexerNodeLeaf[] indexerNodeLeafArray = new IndexerNodeLeaf[n2];
                            int n3 = 0;
                            while (n3 < n2) {
                                indexerNodeLeafArray[n3] = new IndexerNodeLeaf(iEntryResultArray[n3], stringArray);
                                indexerNodeLeafArray[n3].setParent(ViewContentProvider.this.invisibleRoot);
                                ++n3;
                            }
                            ViewContentProvider.this.invisibleRoot.setChildren(indexerNodeLeafArray);
                            ViewContentProvider.this.invisibleRoot.setIsForward(true);
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    }
                    ++n;
                }
                return Status.OK_STATUS;
            }
        }

        public class InitializeRunnable
        implements Runnable {
            TableViewer view = null;
            boolean updateView = true;

            public InitializeRunnable(TableViewer tableViewer, boolean bl) {
                this.view = tableViewer;
                this.updateView = bl;
            }

            public void run() {
                if (!this.updateView) {
                    return;
                }
                IndexerView.this.enableButtons(false);
                this.view.refresh();
                if (this.view.getTable().getItems().length > 0) {
                    TableItem[] tableItemArray = new TableItem[]{this.view.getTable().getItems()[0]};
                    this.view.getTable().setSelection(tableItemArray);
                }
                IndexerView.this.enableButtons(true);
                ((ViewContentProvider)ViewContentProvider.this).IndexerView.this.previousPageAction.setEnabled(ViewContentProvider.this.displayBackwards);
                ((ViewContentProvider)ViewContentProvider.this).IndexerView.this.nextPageAction.setEnabled(ViewContentProvider.this.displayForwards);
            }
        }

        private class StartInitializingIndexerView
        extends Job {
            private static final String INITIALIZE_INDEXER_VIEW = "initialize Indexer View";
            InitializeView job = null;
            boolean updateView = true;

            public StartInitializingIndexerView(InitializeView initializeView, boolean bl) {
                super(INITIALIZE_INDEXER_VIEW);
                this.job = initializeView;
                this.updateView = bl;
            }

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                this.job.schedule();
                try {
                    this.job.join();
                }
                catch (InterruptedException interruptedException) {
                    return Status.CANCEL_STATUS;
                }
                CTestPlugin.getStandardDisplay().asyncExec((Runnable)new InitializeRunnable(viewer, this.updateView));
                this.updateView = true;
                return this.job.getResult();
            }
        }
    }

    class ViewLabelProvider
    extends LabelProvider {
        ViewLabelProvider() {
        }

        public String getText(Object object) {
            if (object == null) {
                return IndexerView.BLANK_STRING;
            }
            return object.toString();
        }

        public Image getImage(Object object) {
            IEntryResult iEntryResult;
            int n;
            if (object instanceof IndexerNodeLeaf && (n = IndexerView.getKey((iEntryResult = ((IndexerNodeLeaf)object).getResult()).getMetaKind(), iEntryResult.getKind(), iEntryResult.getRefKind())) > -1) {
                return IndexerViewPluginImages.get(n);
            }
            return IndexerViewPluginImages.get("org.eclipse.cdt.testplugin.CTestPlugin.warning_icon.gif");
        }
    }

    private class IndexerHighlighterAction
    extends Action {
        IndexerHighlighterAction() {
        }

        public void run() {
            ISelection iSelection = viewer.getSelection();
            IViewPart iViewPart = IndexerView.this.getSite().getPage().findView(IndexerView.PROPERTIES_VIEW);
            if (iViewPart instanceof PropertySheet) {
                ((PropertySheet)iViewPart).selectionChanged(IndexerView.this.getSite().getPart(), iSelection);
            }
        }
    }

    private class SearchLocationsAction
    extends Action {
        private static final String LOCATIONS = "Locations";
        private static final String INDEX = "Index";

        SearchLocationsAction() {
        }

        protected void displayLocations(IndexerNodeLeaf indexerNodeLeaf, String string, String string2) {
            IndexerQuery indexerQuery = new IndexerQuery(indexerNodeLeaf, string, string2);
            NewSearchUI.activateSearchResultView();
            NewSearchUI.runQueryInBackground((ISearchQuery)indexerQuery);
        }

        public void run() {
            if (viewer.getSelection() instanceof IStructuredSelection && ((IStructuredSelection)viewer.getSelection()).getFirstElement() instanceof IndexerNodeLeaf) {
                this.displayLocations((IndexerNodeLeaf)((IStructuredSelection)viewer.getSelection()).getFirstElement(), INDEX, LOCATIONS);
            }
        }
    }
}

