/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.tests.regression;

import java.io.StringWriter;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.core.tests.BaseTestFramework;
import org.eclipse.cdt.core.tests.FailingTest;
import org.eclipse.cdt.internal.core.browser.cache.TypeCacheManager;
import org.eclipse.cdt.internal.ui.CHelpProviderManager;
import org.eclipse.cdt.internal.ui.text.CHelpBookDescriptor;
import org.eclipse.cdt.internal.ui.text.contentassist.CCompletionProcessor;
import org.eclipse.cdt.ui.text.ICCompletionProposal;
import org.eclipse.cdt.ui.text.ICHelpInvocationContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;

public class ContentAssistRegressionTests
extends BaseTestFramework {
    static boolean disabledHelpContributions = false;
    final int TIMEOUT = 100;

    public ContentAssistRegressionTests() {
    }

    public ContentAssistRegressionTests(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        super.setUp();
        TypeCacheManager typeCacheManager = TypeCacheManager.getInstance();
        typeCacheManager.setProcessTypeCacheEvents(false);
    }

    private void disableContributions() {
        final IProject iProject = BaseTestFramework.project;
        CHelpBookDescriptor[] cHelpBookDescriptorArray = CHelpProviderManager.getDefault().getCHelpBookDescriptors(new ICHelpInvocationContext(){

            public IProject getProject() {
                return iProject;
            }

            public ITranslationUnit getTranslationUnit() {
                return null;
            }
        });
        int n = 0;
        while (n < cHelpBookDescriptorArray.length) {
            if (cHelpBookDescriptorArray[n] != null) {
                cHelpBookDescriptorArray[n].enable(false);
            }
            ++n;
        }
    }

    protected ICompletionProposal[] getResults(IFile iFile, int n) throws Exception {
        if (!disabledHelpContributions) {
            this.disableContributions();
        }
        ITranslationUnit iTranslationUnit = (ITranslationUnit)CoreModel.getDefault().create(iFile);
        String string = iTranslationUnit.getBuffer().getContents();
        IWorkingCopy iWorkingCopy = null;
        try {
            iWorkingCopy = iTranslationUnit.getWorkingCopy();
        }
        catch (CModelException cModelException) {
            Assert.fail((String)"Failed to get working copy");
        }
        CCompletionProcessor cCompletionProcessor = new CCompletionProcessor(null);
        ICCompletionProposal[] iCCompletionProposalArray = cCompletionProcessor.evalProposals((IDocument)new Document(string), n, iWorkingCopy, null);
        Thread.sleep(100L);
        return iCCompletionProposalArray != null ? iCCompletionProposalArray : new ICompletionProposal[]{};
    }

    public static Test suite() {
        return ContentAssistRegressionTests.suite(true);
    }

    public static Test suite(boolean bl) {
        TestSuite testSuite = new TestSuite("ContentAssistRegressionTests");
        testSuite.addTest((Test)new ContentAssistRegressionTests("testMemberCompletion"));
        testSuite.addTest((Test)new ContentAssistRegressionTests("testUnqualifiedWithPrefix"));
        testSuite.addTest((Test)new ContentAssistRegressionTests("testQualifiedWithPrefix"));
        testSuite.addTest((Test)new FailingTest((Test)new ContentAssistRegressionTests("test76398"), 76398));
        testSuite.addTest((Test)new ContentAssistRegressionTests("testQualifiedNoPrefix"));
        testSuite.addTest((Test)new ContentAssistRegressionTests("testSourceExtensions"));
        testSuite.addTest((Test)new FailingTest((Test)new ContentAssistRegressionTests("test76480"), 76480));
        testSuite.addTest((Test)new ContentAssistRegressionTests("testField"));
        testSuite.addTest((Test)new ContentAssistRegressionTests("testFieldExpression"));
        testSuite.addTest((Test)new ContentAssistRegressionTests("testScope"));
        testSuite.addTest((Test)new ContentAssistRegressionTests("testClass"));
        testSuite.addTest((Test)new FailingTest((Test)new ContentAssistRegressionTests("test72723"), 72723));
        testSuite.addTest((Test)new FailingTest((Test)new ContentAssistRegressionTests("test72541"), 72541));
        testSuite.addTest((Test)new ContentAssistRegressionTests("testFunction"));
        testSuite.addTest((Test)new ContentAssistRegressionTests("testArgument"));
        testSuite.addTest((Test)new FailingTest((Test)new ContentAssistRegressionTests("test76805"), 76805));
        testSuite.addTest((Test)new ContentAssistRegressionTests("testCStyleCast"));
        testSuite.addTest((Test)new ContentAssistRegressionTests("testMethod"));
        testSuite.addTest((Test)new ContentAssistRegressionTests("testEnumerations"));
        testSuite.addTest((Test)new ContentAssistRegressionTests("testLongTokens"));
        testSuite.addTest((Test)new ContentAssistRegressionTests("testCastMultiLevel"));
        testSuite.addTest((Test)new ContentAssistRegressionTests("testHeaderExtensions"));
        testSuite.addTest((Test)new ContentAssistRegressionTests("testEmptyDocument"));
        testSuite.addTest((Test)new ContentAssistRegressionTests("testVariable"));
        testSuite.addTest((Test)new FailingTest((Test)new ContentAssistRegressionTests("test80510"), 80510));
        testSuite.addTest((Test)new ContentAssistRegressionTests("testSingleNameReference"));
        testSuite.addTest((Test)new ContentAssistRegressionTests("testNamespace"));
        testSuite.addTest((Test)new FailingTest((Test)new ContentAssistRegressionTests("testNamespaceAlias80612"), 80612));
        testSuite.addTest((Test)new ContentAssistRegressionTests("testMacro"));
        testSuite.addTest((Test)new ContentAssistRegressionTests("testConstructor"));
        testSuite.addTest((Test)new ContentAssistRegressionTests("testUnion"));
        testSuite.addTest((Test)new ContentAssistRegressionTests("testKeyword"));
        testSuite.addTest((Test)new ContentAssistRegressionTests("testBase"));
        testSuite.addTest((Test)new ContentAssistRegressionTests("testThis"));
        testSuite.addTest((Test)new ContentAssistRegressionTests("testClassScope"));
        testSuite.addTest((Test)new FailingTest((Test)new ContentAssistRegressionTests("testClassScope72564"), 72564));
        testSuite.addTest((Test)new ContentAssistRegressionTests("testMultiLevelQualifiers"));
        testSuite.addTest((Test)new ContentAssistRegressionTests("testCase"));
        testSuite.addTest((Test)new ContentAssistRegressionTests("testType"));
        testSuite.addTest((Test)new ContentAssistRegressionTests("testTryCatch"));
        testSuite.addTest((Test)new ContentAssistRegressionTests("testArrays"));
        testSuite.addTest((Test)new ContentAssistRegressionTests("testStruct"));
        if (bl) {
            testSuite.addTest((Test)new ContentAssistRegressionTests("cleanupProject"));
        }
        return testSuite;
    }

    public void removeFile(String string) throws Exception {
        IResource[] iResourceArray = BaseTestFramework.project.members();
        int n = 0;
        while (n < iResourceArray.length) {
            if (iResourceArray[n].getName().equals(string)) {
                iResourceArray[n].delete(false, (IProgressMonitor)BaseTestFramework.monitor);
            }
            ++n;
        }
    }

    public void testMemberCompletion() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class A {                 \n");
        stringWriter.write("   int var;               \n");
        stringWriter.write("   void f();              \n");
        stringWriter.write("};                        \n");
        stringWriter.write("void A::f(){              \n");
        stringWriter.write("   v[^]                   \n");
        stringWriter.write("}                         \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("testMemberCompletion.cpp", string);
        ICompletionProposal[] iCompletionProposalArray = this.getResults(iFile, string.indexOf("[^]"));
        Assert.assertEquals((int)4, (int)iCompletionProposalArray.length);
        Assert.assertEquals((String)"var : int", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((String)"virtual", (String)iCompletionProposalArray[1].getDisplayString());
        Assert.assertEquals((String)"void", (String)iCompletionProposalArray[2].getDisplayString());
        Assert.assertEquals((String)"volatile", (String)iCompletionProposalArray[3].getDisplayString());
    }

    public void testUnqualifiedWithPrefix() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("int zVar0;\t\t\t\n");
        stringWriter.write("class zClass { \t\t\n");
        stringWriter.write("public:  \t\t\t\t\n");
        stringWriter.write(" zClass();  \t\t\t\n");
        stringWriter.write(" int zField;  \t\t\n");
        stringWriter.write(" void zMethod(); \t\t\n");
        stringWriter.write("};                    \n");
        stringWriter.write("void zFunction0();   \t\n");
        String string = stringWriter.toString();
        this.importFile("testUnqualifiedWithPrefix.h", string);
        stringWriter = new StringWriter();
        stringWriter.write("#include \"testUnqualifiedWithPrefix.h\"\t\n");
        stringWriter.write("int zVar;\t\t\t\t\t\n");
        stringWriter.write("void zFunction(bool);\t\t\n");
        stringWriter.write("struct zStruct { int b;};\t\n");
        stringWriter.write("zClass c;//vp1\t\t\t\n");
        stringWriter.write("namespace test {\t\t\t\n");
        stringWriter.write(" zStruct s;//vp2\t\t\t\n");
        stringWriter.write(" const int zVar = zVar0 + zVar;//vp3\t\n");
        stringWriter.write("}\t\t\t\t\t\t\t\n");
        stringWriter.write("int main(int argc, char **argv) {\t\t\n");
        stringWriter.write(" zVar=0;//vp4\t\t\t\t\n");
        stringWriter.write(" using namespace test;\t\n");
        stringWriter.write(" zClass c2;//vp5\t\t\t\n");
        stringWriter.write(" ::zVar=0;//vp6\t\t\t\n");
        stringWriter.write(" test::zVar;//vp7\t\t\t\n");
        stringWriter.write(" return (0);\t\t\t\t\n");
        stringWriter.write("}\t\t\t\t\t\t\t\n");
        stringWriter.write("void zClass::zMethod(){\t\n");
        stringWriter.write("\tzField=0;//vp8\t\t\t\n");
        stringWriter.write("}\t\t\t\t\t\t\t\n");
        String string2 = stringWriter.toString();
        IFile iFile = this.importFile("testUnqualifiedWithPrefix.cpp", string2);
        ICompletionProposal[] iCompletionProposalArray = this.getResults(iFile, string2.indexOf("Class c;//vp1"));
        Assert.assertEquals((int)2, (int)iCompletionProposalArray.length);
        Assert.assertEquals((String)"zClass", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((String)"zStruct", (String)iCompletionProposalArray[1].getDisplayString());
        iCompletionProposalArray = this.getResults(iFile, string2.indexOf("Struct s;//vp2"));
        Assert.assertEquals((int)2, (int)iCompletionProposalArray.length);
        Assert.assertEquals((String)"zClass", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((String)"zStruct", (String)iCompletionProposalArray[1].getDisplayString());
        iCompletionProposalArray = this.getResults(iFile, string2.indexOf("Var0 + zVar;//vp3"));
        Assert.assertEquals((int)6, (int)iCompletionProposalArray.length);
        Assert.assertEquals((String)"zVar : int", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((String)"zVar0 : int", (String)iCompletionProposalArray[1].getDisplayString());
        Assert.assertEquals((String)"zFunction(bool) void", (String)iCompletionProposalArray[2].getDisplayString());
        Assert.assertEquals((String)"zFunction0() void", (String)iCompletionProposalArray[3].getDisplayString());
        Assert.assertEquals((String)"zClass", (String)iCompletionProposalArray[4].getDisplayString());
        Assert.assertEquals((String)"zStruct", (String)iCompletionProposalArray[5].getDisplayString());
        iCompletionProposalArray = this.getResults(iFile, string2.indexOf("Var=0;//vp4"));
        Assert.assertEquals((int)6, (int)iCompletionProposalArray.length);
        Assert.assertEquals((String)"zVar : int", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((String)"zVar0 : int", (String)iCompletionProposalArray[1].getDisplayString());
        Assert.assertEquals((String)"zFunction(bool) void", (String)iCompletionProposalArray[2].getDisplayString());
        Assert.assertEquals((String)"zFunction0() void", (String)iCompletionProposalArray[3].getDisplayString());
        Assert.assertEquals((String)"zClass", (String)iCompletionProposalArray[4].getDisplayString());
        Assert.assertEquals((String)"zStruct", (String)iCompletionProposalArray[5].getDisplayString());
        iCompletionProposalArray = this.getResults(iFile, string2.indexOf("Class c2;//vp5"));
        Assert.assertEquals((int)5, (int)iCompletionProposalArray.length);
        Assert.assertEquals((String)"zVar0 : int", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((String)"zFunction(bool) void", (String)iCompletionProposalArray[1].getDisplayString());
        Assert.assertEquals((String)"zFunction0() void", (String)iCompletionProposalArray[2].getDisplayString());
        Assert.assertEquals((String)"zClass", (String)iCompletionProposalArray[3].getDisplayString());
        Assert.assertEquals((String)"zStruct", (String)iCompletionProposalArray[4].getDisplayString());
        iCompletionProposalArray = this.getResults(iFile, string2.indexOf("Var=0;//vp6"));
        Assert.assertEquals((int)6, (int)iCompletionProposalArray.length);
        Assert.assertEquals((String)"zVar : int", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((String)"zVar0 : int", (String)iCompletionProposalArray[1].getDisplayString());
        iCompletionProposalArray = this.getResults(iFile, string2.indexOf("Var;//vp7"));
        Assert.assertEquals((int)1, (int)iCompletionProposalArray.length);
        Assert.assertEquals((String)"zVar : const int", (String)iCompletionProposalArray[0].getDisplayString());
        iCompletionProposalArray = this.getResults(iFile, string2.indexOf("Field=0;//vp8"));
        Assert.assertEquals((int)8, (int)iCompletionProposalArray.length);
        Assert.assertEquals((String)"zField : int", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((String)"zMethod() void", (String)iCompletionProposalArray[3].getDisplayString());
    }

    public void testQualifiedWithPrefix() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class zClass {\t\t\t\t\n");
        stringWriter.write(" public:\t\t\t\t\t\t\n");
        stringWriter.write("  zClass(){} \t\t\t\t\t\n");
        stringWriter.write("  static const int zField=1; \t\n");
        stringWriter.write("  void zMethod();\t\t\n");
        stringWriter.write("};                    \t\t\n");
        stringWriter.write("int zVar0;\t\t\t\t\t\n");
        stringWriter.write(" void zFunction0();\t\t\t\n");
        String string = stringWriter.toString();
        this.importFile("testQualifiedWithPrefix.h", string);
        stringWriter = new StringWriter();
        stringWriter.write("#include \"testQualifiedWithPrefix.h\"\t\t\t\n");
        stringWriter.write("zClass c;\t\t\t\t\t\t\n");
        stringWriter.write("int i = c.zField;//vp1-2res\t\n");
        stringWriter.write("namespace test {\t\t\t\t\n");
        stringWriter.write(" zClass c;\t\t\t\t\t\n");
        stringWriter.write(" int i=c.zField;//vp2-2res\t\n");
        stringWriter.write("}\t\t\t\t\t\t\t\t\n");
        stringWriter.write("int main(int argc, char **argv) {\t\t\n");
        stringWriter.write(" c.zField;//vp3-2res\t\n");
        stringWriter.write(" using namespace test;\t\t\n");
        stringWriter.write(" //c.z;//vpxxx defect 76398\t\n");
        stringWriter.write(" ::c.zMethod();//vp4-2res\t\t\n");
        stringWriter.write(" test::c.zField;//vp5-2res\t\n");
        stringWriter.write(" return (0);\t\t\t\t\t\n");
        stringWriter.write("}\t\t\t\t\t\t\t\t\n");
        stringWriter.write("void zClass::zMethod(){\t\t\n");
        stringWriter.write("\tzzClass zz;\t\t\t\t\t\n");
        stringWriter.write("  zz.zMethod();//vp6\t\t\t\n");
        stringWriter.write("}\t\t\t\t\t\t\t\t\n");
        String string2 = stringWriter.toString();
        IFile iFile = this.importFile("testQualifiedWithPrefix.cpp", string2);
        ICompletionProposal[] iCompletionProposalArray = this.getResults(iFile, string2.indexOf("Field;//vp1"));
        Assert.assertEquals((int)2, (int)iCompletionProposalArray.length);
        Assert.assertEquals((String)"zField : const int", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((String)"zMethod() void", (String)iCompletionProposalArray[1].getDisplayString());
        iCompletionProposalArray = this.getResults(iFile, string2.indexOf("Field;//vp2"));
        Assert.assertEquals((int)2, (int)iCompletionProposalArray.length);
        Assert.assertEquals((String)"zField : const int", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((String)"zMethod() void", (String)iCompletionProposalArray[1].getDisplayString());
        iCompletionProposalArray = this.getResults(iFile, string2.indexOf("Field;//vp3"));
        Assert.assertEquals((int)2, (int)iCompletionProposalArray.length);
        Assert.assertEquals((String)"zField : const int", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((String)"zMethod() void", (String)iCompletionProposalArray[1].getDisplayString());
        iCompletionProposalArray = this.getResults(iFile, string2.indexOf("Method();//vp4"));
        Assert.assertEquals((int)2, (int)iCompletionProposalArray.length);
        Assert.assertEquals((String)"zField : const int", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((String)"zMethod() void", (String)iCompletionProposalArray[1].getDisplayString());
        iCompletionProposalArray = this.getResults(iFile, string2.indexOf("Field;//vp5"));
        Assert.assertEquals((int)2, (int)iCompletionProposalArray.length);
        Assert.assertEquals((String)"zField : const int", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((String)"zMethod() void", (String)iCompletionProposalArray[1].getDisplayString());
        iCompletionProposalArray = this.getResults(iFile, string2.indexOf("Method();//vp6"));
        Assert.assertEquals((int)2, (int)iCompletionProposalArray.length);
        Assert.assertEquals((String)"zField : const int", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((String)"zMethod() void", (String)iCompletionProposalArray[1].getDisplayString());
    }

    public void test76398() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class zClass {\t\t\t\t\n");
        stringWriter.write(" public:\t\t\t\t\t\t\n");
        stringWriter.write("  zClass(){} \t\t\t\t\t\n");
        stringWriter.write("  static const int zField=1; \t\n");
        stringWriter.write("  void zMethod();\t\t\n");
        stringWriter.write("};                    \t\t\n");
        stringWriter.write("int zVar0;\t\t\t\t\t\n");
        stringWriter.write("void zFunction0();\t\t\t\n");
        stringWriter.write("zClass c;\t\t\t\t\t\t\n");
        stringWriter.write("namespace test {\t\t\t\t\n");
        stringWriter.write(" zClass c;\t\t\t\t\t\n");
        stringWriter.write("}\t\t\t\t\t\t\t\t\n");
        stringWriter.write("int main(int argc, char **argv) {\t\t\n");
        stringWriter.write(" c.zField;//vp3-function scope,2res\t\n");
        stringWriter.write(" using namespace test;\t\t\n");
        stringWriter.write(" c.z;//76398\t\n");
        stringWriter.write(" return (0);\t\t\t\t\t\n");
        stringWriter.write("}\t\t\t\t\t\t\t\t\n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("test76398.cpp", string);
        ICompletionProposal[] iCompletionProposalArray = this.getResults(iFile, string.indexOf(";//76398"));
        Assert.assertEquals((int)0, (int)iCompletionProposalArray.length);
    }

    public void testQualifiedNoPrefix() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class zClass {\t\t\t\t\t\n");
        stringWriter.write(" public:\t\t\t\t\t\t\n");
        stringWriter.write("  zClass(){} \t\t\t\t\t\n");
        stringWriter.write("  static const int zField=1; \t\n");
        stringWriter.write("  int zMethod(int i);\t\t\t\n");
        stringWriter.write("};                    \t\t\t\n");
        stringWriter.write("zClass c;\t\t\t\t\t\t\n");
        stringWriter.write("int i = c.zField;//vp1-2res\t\n");
        stringWriter.write("namespace test {\t\t\t\t\n");
        stringWriter.write(" zClass c;\t\t\t\t\t\t\n");
        stringWriter.write(" int i=c.zField;//vp2-2res\t\t\n");
        stringWriter.write("}\t\t\t\t\t\t\t\t\n");
        stringWriter.write("int main(int argc, char **argv) {\t\t\n");
        stringWriter.write(" c.zField;//vp3-2res\t\t\t\n");
        stringWriter.write(" using namespace test;\t\t\t\n");
        stringWriter.write(" ::c.zMethod(3);//vp4-2res\t\t\n");
        stringWriter.write(" test::c.zField;//vp5-2res\t\t\n");
        stringWriter.write(" return (0);\t\t\t\t\t\n");
        stringWriter.write("}\t\t\t\t\t\t\t\t\n");
        stringWriter.write("int zClass::zMethod(int i){\t\n");
        stringWriter.write("\tif (i==0) return (0);\t\t\n");
        stringWriter.write("\tzClass zz;\t\t\t\t\t\n");
        stringWriter.write("  return (zz.zMethod(i-1));//vp6\t\t\n");
        stringWriter.write("}\t\t\t\t\t\t\t\t\n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("testQualifiedNoPrefix.cpp", string);
        ICompletionProposal[] iCompletionProposalArray = this.getResults(iFile, string.indexOf("zField;//vp1"));
        Assert.assertEquals((int)2, (int)iCompletionProposalArray.length);
        Assert.assertEquals((String)"zField : const int", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((String)"zMethod(int) int", (String)iCompletionProposalArray[1].getDisplayString());
        iCompletionProposalArray = this.getResults(iFile, string.indexOf("zField;//vp2"));
        Assert.assertEquals((int)2, (int)iCompletionProposalArray.length);
        Assert.assertEquals((String)"zField : const int", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((String)"zMethod(int) int", (String)iCompletionProposalArray[1].getDisplayString());
        iCompletionProposalArray = this.getResults(iFile, string.indexOf("zField;//vp3"));
        Assert.assertEquals((int)2, (int)iCompletionProposalArray.length);
        Assert.assertEquals((String)"zField : const int", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((String)"zMethod(int) int", (String)iCompletionProposalArray[1].getDisplayString());
        iCompletionProposalArray = this.getResults(iFile, string.indexOf("zMethod(3);//vp4"));
        Assert.assertEquals((int)2, (int)iCompletionProposalArray.length);
        Assert.assertEquals((String)"zField : const int", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((String)"zMethod(int) int", (String)iCompletionProposalArray[1].getDisplayString());
        iCompletionProposalArray = this.getResults(iFile, string.indexOf("zField;//vp5"));
        Assert.assertEquals((int)2, (int)iCompletionProposalArray.length);
        Assert.assertEquals((String)"zField : const int", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((String)"zMethod(int) int", (String)iCompletionProposalArray[1].getDisplayString());
        iCompletionProposalArray = this.getResults(iFile, string.indexOf("zMethod(i-1));//vp6"));
        Assert.assertEquals((int)2, (int)iCompletionProposalArray.length);
        Assert.assertEquals((String)"zField : const int", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((String)"zMethod(int) int", (String)iCompletionProposalArray[1].getDisplayString());
    }

    public void testSourceExtensions() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("int zVar;\t\t\t\t\t\n");
        stringWriter.write("int zFunction(int);\t\t\n");
        stringWriter.write("struct zStruct {int b;};\t\n");
        stringWriter.write("struct zStruct a;//vp1-1res\t\t\t\n");
        stringWriter.write("int main(int argc, char **argv) {\t\t\n");
        stringWriter.write(" zVar=0;//vp2-3res\t\t\n");
        stringWriter.write(" return (0);\t\t\t\t\n");
        stringWriter.write("}\t\t\t\t\t\t\t\n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("testSourceExtensions.c", string);
        ICompletionProposal[] iCompletionProposalArray = this.getResults(iFile, string.indexOf("Struct a;//vp1"));
        Assert.assertEquals((int)1, (int)iCompletionProposalArray.length);
        Assert.assertEquals((String)"zStruct", (String)iCompletionProposalArray[0].getDisplayString());
        iCompletionProposalArray = this.getResults(iFile, string.indexOf("Var=0;//vp2"));
        Assert.assertEquals((int)3, (int)iCompletionProposalArray.length);
        Assert.assertEquals((String)"zVar : int", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((String)"zFunction(int) int", (String)iCompletionProposalArray[1].getDisplayString());
        Assert.assertEquals((String)"zStruct", (String)iCompletionProposalArray[2].getDisplayString());
        this.removeFile("testSourceExtensions.c");
        iFile = this.importFile("testSourceExtensions.C", string);
        iCompletionProposalArray = this.getResults(iFile, string.indexOf("Struct a;//vp1"));
        Assert.assertEquals((int)1, (int)iCompletionProposalArray.length);
        Assert.assertEquals((String)"zStruct", (String)iCompletionProposalArray[0].getDisplayString());
        iCompletionProposalArray = this.getResults(iFile, string.indexOf("Var=0;//vp2"));
        Assert.assertEquals((int)3, (int)iCompletionProposalArray.length);
        Assert.assertEquals((String)"zVar : int", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((String)"zFunction(int) int", (String)iCompletionProposalArray[1].getDisplayString());
        Assert.assertEquals((String)"zStruct", (String)iCompletionProposalArray[2].getDisplayString());
        this.removeFile("testSourceExtensions.C");
        iFile = this.importFile("testSourceExtensions.cxx", string);
        iCompletionProposalArray = this.getResults(iFile, string.indexOf("Struct a;//vp1"));
        Assert.assertEquals((int)1, (int)iCompletionProposalArray.length);
        Assert.assertEquals((String)"zStruct", (String)iCompletionProposalArray[0].getDisplayString());
        iCompletionProposalArray = this.getResults(iFile, string.indexOf("Var=0;//vp2"));
        Assert.assertEquals((int)3, (int)iCompletionProposalArray.length);
        Assert.assertEquals((String)"zVar : int", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((String)"zFunction(int) int", (String)iCompletionProposalArray[1].getDisplayString());
        Assert.assertEquals((String)"zStruct", (String)iCompletionProposalArray[2].getDisplayString());
        this.removeFile("testSourceExtensions.cxx");
        iFile = this.importFile("testSourceExtensions.cc", string);
        iCompletionProposalArray = this.getResults(iFile, string.indexOf("Struct a;//vp1"));
        Assert.assertEquals((int)1, (int)iCompletionProposalArray.length);
        Assert.assertEquals((String)"zStruct", (String)iCompletionProposalArray[0].getDisplayString());
        iCompletionProposalArray = this.getResults(iFile, string.indexOf("Var=0;//vp2"));
        Assert.assertEquals((int)3, (int)iCompletionProposalArray.length);
        Assert.assertEquals((String)"zVar : int", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((String)"zFunction(int) int", (String)iCompletionProposalArray[1].getDisplayString());
        Assert.assertEquals((String)"zStruct", (String)iCompletionProposalArray[2].getDisplayString());
    }

    public void test76480() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("int zVar;\t\t\t\t\t\n");
        stringWriter.write("int zFunction(int);\t\t\n");
        stringWriter.write("struct zStruct {int b;};\t\n");
        stringWriter.write("int main(int argc, char **argv) {\t\t\n");
        stringWriter.write(" ::zVar=0;//vp1-0res\t\t\n");
        stringWriter.write(" return (0);\t\t\t\t\n");
        stringWriter.write("}\t\t\t\t\t\t\t\n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("test76480.c", string);
        ICompletionProposal[] iCompletionProposalArray = this.getResults(iFile, string.indexOf("Var=0;//vp1"));
        Assert.assertEquals((int)0, (int)iCompletionProposalArray.length);
    }

    public void testField() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter = new StringWriter();
        stringWriter.write("struct simplestruct {\t\t\t\t\t\t\t\n");
        stringWriter.write(" \tunsigned field1: 2; // range 0-3\t\t\t\n");
        stringWriter.write(" \tunsigned int field2: 1; // range 0-1\t\t\n");
        stringWriter.write("};\t\t\t\t\t\t\t\t\t\t\t\n");
        stringWriter.write("typedef struct {\t\t\t\t\t\t\t\t\n");
        stringWriter.write(" \tstatic int const field2=5; \t\t\t\t\t\n");
        stringWriter.write("} structtype;\t\t\t\t\t\t\t\t\t\n");
        stringWriter.write("class A{\t\t\t\t\t\t\t\t\t\t\n");
        stringWriter.write("  public: struct {int aa;} a;\t\t\t\t\t\n");
        stringWriter.write("};\t\t\t\t\t\t\t\t\t\t\t\n");
        stringWriter.write("int main(int argc, char **argv) {\t\t   \t\t\n");
        stringWriter.write(" \tstruct simplestruct aStruct={3,0}, *pStruct;\n");
        stringWriter.write(" \taStruct.field1;//vp1\t\t\t\t\t\t\n");
        stringWriter.write("\tpStruct->field1;//vp2\t\t\t\t\t\t\n");
        stringWriter.write(" \tstructtype anotherStruct;\t\t\t\t\t\n");
        stringWriter.write("\tstructtype::field2;//vp3\t\t\t\t\t\n");
        stringWriter.write("\tclass A myClass;\t\t\t\t\t\t\t\n");
        stringWriter.write("\tint i = myClass.a.aa;//vp4\t\t\t\t\t\n");
        stringWriter.write("\treturn (0);\t\t\t\t\t\t\t\t\t\n");
        stringWriter.write("} \t\t\t\t\t\t\t\t\t\t\t\n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("testField.cpp", string);
        ICompletionProposal[] iCompletionProposalArray = this.getResults(iFile, string.indexOf("field1;//vp1"));
        Assert.assertEquals((int)2, (int)iCompletionProposalArray.length);
        Assert.assertEquals((String)"field1 : unsigned", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((String)"field2 : unsigned int", (String)iCompletionProposalArray[1].getDisplayString());
        iCompletionProposalArray = this.getResults(iFile, string.indexOf("field1;//vp2"));
        Assert.assertEquals((int)2, (int)iCompletionProposalArray.length);
        Assert.assertEquals((String)"field1 : unsigned", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((String)"field2 : unsigned int", (String)iCompletionProposalArray[1].getDisplayString());
        iCompletionProposalArray = this.getResults(iFile, string.indexOf("field2;//vp3"));
        Assert.assertEquals((int)1, (int)iCompletionProposalArray.length);
        Assert.assertEquals((String)"field2 : const int", (String)iCompletionProposalArray[0].getDisplayString());
        iCompletionProposalArray = this.getResults(iFile, string.indexOf("a.aa;//vp4"));
        Assert.assertEquals((int)1, (int)iCompletionProposalArray.length);
        Assert.assertEquals((String)"a : ", (String)iCompletionProposalArray[0].getDisplayString());
    }

    public void testFieldExpression() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("struct myStruct_c{\t\t\t\t\t\t\n");
        stringWriter.write("int m; struct {int m2;} n; \t\t\t\t\n");
        stringWriter.write("}ss1={1},ss2={2};\t\t\t\t\t\t\t\n");
        stringWriter.write("void f(){\t\t\t\t\t\t\t\t\t\n");
        stringWriter.write("int i=(ss1.m > ss2.m/*vp1*/ ? ss1.n/*vp2*/ : ss2.n/*vp3*/).m2/*vp4*/;\n");
        stringWriter.write("}\t\t\t\t\t\t\t\t\t\t\t\n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("testFieldExpression.cpp", string);
        ICompletionProposal[] iCompletionProposalArray = this.getResults(iFile, string.indexOf("m/*vp1*/"));
        Assert.assertEquals((String)"m : int", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((String)"n : ", (String)iCompletionProposalArray[1].getDisplayString());
        Assert.assertEquals((int)2, (int)iCompletionProposalArray.length);
        iCompletionProposalArray = this.getResults(iFile, string.indexOf("n/*vp2*/"));
        Assert.assertEquals((String)"m : int", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((String)"n : ", (String)iCompletionProposalArray[1].getDisplayString());
        Assert.assertEquals((int)2, (int)iCompletionProposalArray.length);
        iCompletionProposalArray = this.getResults(iFile, string.indexOf("n/*vp3*/"));
        Assert.assertEquals((String)"m : int", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((String)"n : ", (String)iCompletionProposalArray[1].getDisplayString());
        Assert.assertEquals((int)2, (int)iCompletionProposalArray.length);
        iCompletionProposalArray = this.getResults(iFile, string.indexOf("m2/*vp4*/"));
        Assert.assertEquals((String)"m2 : int", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((int)1, (int)iCompletionProposalArray.length);
    }

    public void testScope() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter = new StringWriter();
        stringWriter.write("namespace NN1 {\t\t\n");
        stringWriter.write("\tclass C1 {};\t\t\n");
        stringWriter.write("\tnamespace NN2 {\t\t\n");
        stringWriter.write("\t\tclass C2{};\t\t\n");
        stringWriter.write("\t\tclass NNA{};\t\n");
        stringWriter.write("\t\tnamespace NN3 {\t\n");
        stringWriter.write("\t\t\tclass NNA{};\n");
        stringWriter.write("\t\t\tclass C3{\t\n");
        stringWriter.write("\t\t\t public:\t\n");
        stringWriter.write("\t\t\t   class C4{};\n");
        stringWriter.write("\t\t\t};\t\t\t\n");
        stringWriter.write("\t\t}\t\t\t\t\n");
        stringWriter.write("\t}\t\t\t\t\t\n");
        stringWriter.write("}\t\t\t\t\t\t\n");
        String string = stringWriter.toString();
        this.importFile("testScope.h", string);
        stringWriter.write("#include \"testScope.h\"\t\t\t\t\t\n");
        stringWriter.write("int main(int argc, char **argv) {\t\t\n");
        stringWriter.write("\tNN1::NN2::NN3::C3::C4 c4;//vp1:C4\t\n");
        stringWriter.write("\tusing namespace NN1::NN2;\t\t\t\n");
        stringWriter.write("\tNN3::C3 c3; //vp2:NN1,NN3,NNA; vp3:C3,NNA\n");
        stringWriter.write("\tusing namespace NN3;\t\t\t\t\n");
        stringWriter.write("\tNN3::NNA a;//vp4:NN1,NN3(Ambiguous space)\n");
        stringWriter.write("}\t\t\t\t\t\t\t\t\t\t\n");
        String string2 = stringWriter.toString();
        IFile iFile = this.importFile("testScope.cpp", string2);
        ICompletionProposal[] iCompletionProposalArray = this.getResults(iFile, string2.indexOf("C4 c4;//vp1"));
        Assert.assertEquals((String)"C4", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((int)1, (int)iCompletionProposalArray.length);
        iCompletionProposalArray = this.getResults(iFile, string2.indexOf("3::C3 c3; //vp2"));
        Assert.assertEquals((String)"NNA", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((String)"NN1", (String)iCompletionProposalArray[1].getDisplayString());
        Assert.assertEquals((String)"NN3", (String)iCompletionProposalArray[2].getDisplayString());
        Assert.assertEquals((int)3, (int)iCompletionProposalArray.length);
        iCompletionProposalArray = this.getResults(iFile, string2.indexOf("C3 c3; //vp2:NN1,NN3,NNA; vp3"));
        Assert.assertEquals((String)"C3", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((String)"NNA", (String)iCompletionProposalArray[1].getDisplayString());
        Assert.assertEquals((int)2, (int)iCompletionProposalArray.length);
        iCompletionProposalArray = this.getResults(iFile, string2.indexOf("3::NNA a;//vp4"));
        Assert.assertEquals((String)"NN1", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((String)"NN3", (String)iCompletionProposalArray[1].getDisplayString());
        Assert.assertEquals((int)2, (int)iCompletionProposalArray.length);
    }

    public void testClass() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class Point{\t\t\t\t\t\t\t\n");
        stringWriter.write("public:\t\t\t\t\t\t\t\t\n");
        stringWriter.write(" Point(): xCoord(0){}\t\t\t\t\t\n");
        stringWriter.write(" Point(int x);\t\t\t\t\t\t\n");
        stringWriter.write(" Point(const Point &rhs);\t\t\t\t\n");
        stringWriter.write(" virtual ~Point(){}\t\t\t\t\t\n");
        stringWriter.write(" int getX() const {return xCoord;}\t\n");
        stringWriter.write("private:\t\t\t\t\t\t\t\t\n");
        stringWriter.write(" int xCoord;\t\t\t\t\t\t\t\n");
        stringWriter.write("};\t\t\t\t\t\t\t\t\t\n");
        String string = stringWriter.toString();
        this.importFile("testClass.h", string);
        stringWriter = new StringWriter();
        stringWriter.write("#include \"testClass.h\"\t\t\t\t\t\n");
        stringWriter.write("Point::Point(int x):xCoord(x){}\t\t\n");
        stringWriter.write("Point::Point(const Point &rhs){\t\t\n");
        stringWriter.write("\t xCoord = rhs.xCoord;\t\t\t\t\n");
        stringWriter.write("}\t\t\t\t\t\t\t\t\t\t\n");
        stringWriter.write("static const Point zero(0);\t\t\t\t\t\t\n");
        stringWriter.write("int main(int argc, char **argv) {\t\t\t\t\t\n");
        stringWriter.write("\t Point *p1 = new ::Point(0);//vp1 scoped class\t\n");
        stringWriter.write("\t Point &p2 = *(new Point(10));\t\t\t\t\t\n");
        stringWriter.write("\t Point one(1);\t\t\t\t\t\t\t\t\t\n");
        stringWriter.write("\t p1->getX();//vp2: arrow getX(), getY(), ~Point(), operator=) \t\n");
        stringWriter.write("\t p2.getX();//vp3: dot on dereferenced initialization\t\t\t\n");
        stringWriter.write("\t one.getX();//vp4: dot on simple initialization\t\t\t\t\t\n");
        stringWriter.write("\t *(p1) = ::zero;//vp5 scoped class instance\t\t\t\t\t\t\n");
        stringWriter.write("\t return (0);\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        stringWriter.write("}\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        String string2 = stringWriter.toString();
        IFile iFile = this.importFile("testClass.cpp", string2);
        ICompletionProposal[] iCompletionProposalArray = this.getResults(iFile, string2.indexOf("oint(0);//vp1"));
        Assert.assertEquals((String)"Point", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((int)1, (int)iCompletionProposalArray.length);
        iCompletionProposalArray = this.getResults(iFile, string2.indexOf("getX();//vp2"));
        Assert.assertEquals((String)"getX() int", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((String)"~Point()", (String)iCompletionProposalArray[1].getDisplayString());
        Assert.assertEquals((int)2, (int)iCompletionProposalArray.length);
        iCompletionProposalArray = this.getResults(iFile, string2.indexOf("getX();//vp3"));
        Assert.assertEquals((String)"getX() int", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((String)"~Point()", (String)iCompletionProposalArray[1].getDisplayString());
        Assert.assertEquals((int)2, (int)iCompletionProposalArray.length);
        iCompletionProposalArray = this.getResults(iFile, string2.indexOf("getX();//vp4"));
        Assert.assertEquals((String)"getX() int", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((String)"~Point()", (String)iCompletionProposalArray[1].getDisplayString());
        Assert.assertEquals((int)2, (int)iCompletionProposalArray.length);
        iCompletionProposalArray = this.getResults(iFile, string2.indexOf("ero;//vp5"));
        Assert.assertEquals((String)"zero : const Point", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((int)1, (int)iCompletionProposalArray.length);
    }

    public void test72723() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class Point{\t\t\t\t\t\t\t\n");
        stringWriter.write("public:\t\t\t\t\t\t\t\t\n");
        stringWriter.write(" Point(): xCoord(0){}\t\t\t\t\t\n");
        stringWriter.write(" Point(int x);\t\t\t\t\t\t\n");
        stringWriter.write(" Point(const Point &rhs);\t\t\t\t\n");
        stringWriter.write(" virtual ~Point(){}\t\t\t\t\t\n");
        stringWriter.write(" int getX() const {return xCoord;}\t\n");
        stringWriter.write(" Point& operator=(const Point &rhs);\t\n");
        stringWriter.write("private:\t\t\t\t\t\t\t\t\n");
        stringWriter.write(" int xCoord;\t\t\t\t\t\t\t\n");
        stringWriter.write("};\t\t\t\t\t\t\t\t\t\n");
        String string = stringWriter.toString();
        this.importFile("test72723.h", string);
        stringWriter = new StringWriter();
        stringWriter.write("#include \"test72723.h\"\t\t\t\t\n");
        stringWriter.write("Point::Point(int x):xCoord(x){}\t\t\n");
        stringWriter.write("Point::Point(const Point &rhs){\t\t\n");
        stringWriter.write("\t xCoord = rhs.xCoord;\t\t\t\t\n");
        stringWriter.write("}\t\t\t\t\t\t\t\t\t\t\n");
        stringWriter.write("Point& Point::operator=(const Point &rhs){\n");
        stringWriter.write("\t if (this == &rhs) return *this;\t\n");
        stringWriter.write("\t xCoord = rhs.xCoord;\t\t\t\t\n");
        stringWriter.write("\t return *this;\t\t\t\t\t\t\n");
        stringWriter.write("}\t\t\t\t\t\t\t\t\t\t\n");
        stringWriter.write("static const Point zero(0);\t\t\t\n");
        stringWriter.write("int main(int argc, char **argv) {\t\t\n");
        stringWriter.write("\t Point *p1 = new ::Point(0);\t\t\n");
        stringWriter.write("\t Point &p2 = *(new Point(10));\t\t\t\n");
        stringWriter.write("\t p1->operator=(zero);//vp1: arrow ref \t\n");
        stringWriter.write("\t p2.operator=(zero);//vp2: dot ref \t\t\n");
        stringWriter.write("\t return (0);\t\t\t\t\t\t\t\n");
        stringWriter.write("}\t\t\t\t\t\t\t\t\t\t\t\n");
        String string2 = stringWriter.toString();
        IFile iFile = this.importFile("test72723.cpp", string2);
        ICompletionProposal[] iCompletionProposalArray = this.getResults(iFile, string2.indexOf("perator=(zero);//vp3"));
        Assert.assertEquals((int)1, (int)iCompletionProposalArray.length);
        Assert.assertEquals((String)"operator=(const Point&) Point&", (String)iCompletionProposalArray[0].getDisplayString());
    }

    public void test72541() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class Point {public Point(); int X;};\t\t\n");
        stringWriter.write("const Point zero;\t\t\t\t\t\t\t\n");
        stringWriter.write("int main() {return zero.X;}//vp1 \t\t\t\n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("test72541.h", string);
        ICompletionProposal[] iCompletionProposalArray = this.getResults(iFile, string.indexOf("X;}//vp1"));
        Assert.assertEquals((int)1, (int)iCompletionProposalArray.length);
        Assert.assertEquals((String)"X : const int", (String)iCompletionProposalArray[0].getDisplayString());
    }

    public void testFunction() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("namespace nnnn {\t\t\t\t\n");
        stringWriter.write("\tnamespace nnn {\t\t\t\t\n");
        stringWriter.write("\t  void foo(){}\t\t\t\t\n");
        stringWriter.write("\t}\t\t\t\t\t\t\t\n");
        stringWriter.write("}\t\t\t\t\t\t\t\t\n");
        stringWriter.write("int main(int argc, char **argv) {\n");
        stringWriter.write("\tnamespace n=nnnn::nnn;\t\t\n");
        stringWriter.write("\tn::foo();//vp1\t\t\t\t\n");
        stringWriter.write("\tusing namespace nnnn;\t\t\n");
        stringWriter.write("\tnnn::foo();//vp2\t\t\t\n");
        stringWriter.write("  return (0);\t\t\t\t\t\n");
        stringWriter.write("}\t\t\t\t\t\t\t\t\n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("testFunction.cpp", string);
        ICompletionProposal[] iCompletionProposalArray = this.getResults(iFile, string.indexOf("foo();//vp1"));
        Assert.assertEquals((int)1, (int)iCompletionProposalArray.length);
        Assert.assertEquals((String)"foo() void", (String)iCompletionProposalArray[0].getDisplayString());
        iCompletionProposalArray = this.getResults(iFile, string.indexOf("oo();//vp2"));
        Assert.assertEquals((int)1, (int)iCompletionProposalArray.length);
        Assert.assertEquals((String)"foo() void", (String)iCompletionProposalArray[0].getDisplayString());
    }

    public void testArgument() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("typedef long int32_t;\t\t\t\n");
        stringWriter.write("#define INT32_C(x) x ## L\t\t\n");
        stringWriter.write("#define INT32_MAX (2147483647) \n");
        stringWriter.write("int foo(int32_t i){//vp1contributions include types in arg list\n");
        stringWriter.write("\treturn (i);\t\t\t\t\t\n");
        stringWriter.write("}\t\t\t\t\t\t\t\t\n");
        stringWriter.write("int z(int i){return (i);}\t\t\n");
        stringWriter.write("int main(int argc, char **argv) {\n");
        stringWriter.write("\tint32_t int32iii=2;\t\t\t\n");
        stringWriter.write("\tfoo(INT32_C(2));//vp2 macros\n");
        stringWriter.write("\tfoo(INT32_MAX);//vp3 defines\n");
        stringWriter.write("\tfoo(int32iii);//vp4 variable\n");
        stringWriter.write("\tfoo(z(5));//vp5 function arg\t\t\n");
        stringWriter.write("\treturn (0);\t\t\t\t\t\n");
        stringWriter.write("}\t\t\t\t\t\t\t\t\n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("testArgument.c", string);
        ICompletionProposal[] iCompletionProposalArray = this.getResults(iFile, string.indexOf("32_t i){//vp1"));
        Assert.assertEquals((int)2, (int)iCompletionProposalArray.length);
        Assert.assertEquals((String)"int32_t", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((String)"int", (String)iCompletionProposalArray[1].getDisplayString());
        iCompletionProposalArray = this.getResults(iFile, string.indexOf("(2));//vp2"));
        Assert.assertEquals((int)1, (int)iCompletionProposalArray.length);
        Assert.assertEquals((String)"INT32_C(x)", (String)iCompletionProposalArray[0].getDisplayString());
        iCompletionProposalArray = this.getResults(iFile, string.indexOf("AX);//vp3"));
        Assert.assertEquals((int)1, (int)iCompletionProposalArray.length);
        Assert.assertEquals((String)"INT32_MAX", (String)iCompletionProposalArray[0].getDisplayString());
        iCompletionProposalArray = this.getResults(iFile, string.indexOf("ii);//vp4"));
        Assert.assertEquals((int)1, (int)iCompletionProposalArray.length);
        Assert.assertEquals((String)"int32iii : int32_t", (String)iCompletionProposalArray[0].getDisplayString());
        iCompletionProposalArray = this.getResults(iFile, string.indexOf("(5));//vp5"));
        Assert.assertEquals((int)1, (int)iCompletionProposalArray.length);
        Assert.assertEquals((String)"z(int) int", (String)iCompletionProposalArray[0].getDisplayString());
    }

    public void test76805() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("typedef long int32_t;\t\t\t\n");
        stringWriter.write("#define INT32_MAX (2147483647) \n");
        stringWriter.write("int foo(int32_t i){\t\t\t\n");
        stringWriter.write("\treturn (i);\t\t\t\t\t\n");
        stringWriter.write("}\t\t\t\t\t\t\t\t\n");
        stringWriter.write("int main(int argc, char **argv) {\n");
        stringWriter.write("\tint32_t int32iii=2;\t\t\t\n");
        stringWriter.write("\tfoo(INT32_MAX);//vp1 macros, variables, not types\n");
        stringWriter.write("\treturn (0);\t\t\t\t\t\n");
        stringWriter.write("}\t\t\t\t\t\t\t\t\n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("test76805.c", string);
        ICompletionProposal[] iCompletionProposalArray = this.getResults(iFile, string.indexOf("32_MAX);//vp1"));
        Assert.assertEquals((String)"INT32_MAX", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((String)"int32iii : int32_t", (String)iCompletionProposalArray[1].getDisplayString());
        Assert.assertEquals((int)2, (int)iCompletionProposalArray.length);
    }

    public void testCStyleCast() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("typedef int ZINT;\t\t\t\n");
        stringWriter.write("typedef struct {\t\t\t\n");
        stringWriter.write("\tint foobar;\t\t\t\t\n");
        stringWriter.write("}foo_c;\t\t\t\t\t\n");
        stringWriter.write("typedef struct {} bar_c;\t\n");
        stringWriter.write("int main(int argc, char **argv) {\n");
        stringWriter.write("\tZINT i=(ZINT) 3.1;//vp1 narrowing cast\n");
        stringWriter.write("\tbar_c *bar;\t\t\t\t\n");
        stringWriter.write("\tfoo_c *foo;\t\t\t\t\n");
        stringWriter.write("\t((foo_c*) bar)->foobar;//vp2 complete on struct casted var\n");
        stringWriter.write("}\t\t\t\t\t\t\t\t\n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("testCStyleCast.c", string);
        ICompletionProposal[] iCompletionProposalArray = this.getResults(iFile, string.indexOf("INT) 3.1;//vp1"));
        Assert.assertEquals((String)"ZINT", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((int)1, (int)iCompletionProposalArray.length);
        iCompletionProposalArray = this.getResults(iFile, string.indexOf("foobar;//vp2"));
        Assert.assertEquals((String)"foobar : int", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((int)1, (int)iCompletionProposalArray.length);
        this.removeFile("testCStyleCase.c");
        stringWriter = new StringWriter();
        stringWriter.write("typedef int ZINT;\t\t\t\t\t\t\n");
        stringWriter.write("class foo_c{\t\t\t\t\t\t\t\t\n");
        stringWriter.write("\t\tpublic:\tvoid foobar(){}\t\t\t\t\n");
        stringWriter.write("};\t\t\t\t\t\t\t\t\t\t\n");
        stringWriter.write("class bar_c {};\t\t\t\t\t\t\t\n");
        stringWriter.write("int main(int argc, char **argv) {\t\t\t\n");
        stringWriter.write("\tbar_c *bar;\t\t\t\t\t\t\t\t\n");
        stringWriter.write("\tfoo_c *foo;\t\t\t\t\t\t\t\t\n");
        stringWriter.write("\t((foo_c*) bar)->foobar();//vp1 complete on class casted var\n");
        stringWriter.write("\t//cast away constness\t\t\t\t\t\n");
        stringWriter.write("\tZINT i=3;\t\t\t\t\t\t\t\t\n");
        stringWriter.write("\tconst int *pci = &i;\t\t\t\t\t\n");
        stringWriter.write("\tvoid * pv=(void*)pci;//vp2 override typecheck cast \n");
        stringWriter.write("\t(*(ZINT *)pv)=4;//vp3 dereferenced casted var\n");
        stringWriter.write("\t\t\treturn 0;\t\t\t\t\t\t\n");
        stringWriter.write("}\t\t\t\t\t\t\t\t\n");
        string = stringWriter.toString();
        iFile = this.importFile("testCStyleCast.cpp", string);
        iCompletionProposalArray = this.getResults(iFile, string.indexOf("foobar();//vp1"));
        Assert.assertEquals((String)"foobar() void", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((int)1, (int)iCompletionProposalArray.length);
        iCompletionProposalArray = this.getResults(iFile, string.indexOf("d*)pci;//vp2"));
        Assert.assertEquals((String)"void", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((int)1, (int)iCompletionProposalArray.length);
        iCompletionProposalArray = this.getResults(iFile, string.indexOf("INT *)pv)=4;//vp3"));
        Assert.assertEquals((String)"ZINT", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((int)1, (int)iCompletionProposalArray.length);
    }

    public void testMethod() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class Point{\t\t\t\t\t\n");
        stringWriter.write("\tpublic: Point(): x(5){}\t\t\n");
        stringWriter.write("\tPoint& compare(const Point &rhs) {\n");
        stringWriter.write("\t (this==&rhs);//vp1\t\t\t\n");
        stringWriter.write("\t return *this;//vp2\t\t\t\n");
        stringWriter.write("\t}\t\t\t\t\t\t\t\n");
        stringWriter.write("\tint x;\t\t\t\t\t\t\n");
        stringWriter.write("};\t\t\t\t\t\t\t\n");
        stringWriter.write("int main(int argc, char **argv) {\n");
        stringWriter.write("\tPoint *p1=new Point();\t\t\n");
        stringWriter.write("\tPoint &p2=*(new Point());\t\n");
        stringWriter.write("\tPoint **p3;\t\t\t\t\t\n");
        stringWriter.write("\t**p3=p2;//vp3 content assist doesn't filter out pointer types by design\n");
        stringWriter.write("\t(**p3).x;//vp4 correct dereference\n");
        stringWriter.write("\t(*p3).x;//vp5 too few stars - CA notices\n");
        stringWriter.write("\treturn 0;\t\t\t\t\t\n");
        stringWriter.write("}\t\t\t\t\t\t\t\t\n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("testMethod.c", string);
        ICompletionProposal[] iCompletionProposalArray = this.getResults(iFile, string.indexOf("hs);//vp1"));
        Assert.assertEquals((String)"rhs : const Point&", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((String)"register", (String)iCompletionProposalArray[1].getDisplayString());
        Assert.assertEquals((String)"reinterpret_cast", (String)iCompletionProposalArray[2].getDisplayString());
        Assert.assertEquals((String)"return", (String)iCompletionProposalArray[3].getDisplayString());
        Assert.assertEquals((int)4, (int)iCompletionProposalArray.length);
        iCompletionProposalArray = this.getResults(iFile, string.indexOf("s;//vp2"));
        Assert.assertEquals((String)"this", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((int)1, (int)iCompletionProposalArray.length);
        iCompletionProposalArray = this.getResults(iFile, string.indexOf("3=p2;//vp3"));
        Assert.assertEquals((String)"p1 : Point*", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((String)"p2 : Point&", (String)iCompletionProposalArray[1].getDisplayString());
        Assert.assertEquals((String)"p3 : Point**", (String)iCompletionProposalArray[2].getDisplayString());
        Assert.assertEquals((String)"Point", (String)iCompletionProposalArray[3].getDisplayString());
        Assert.assertEquals((int)4, (int)iCompletionProposalArray.length);
        iCompletionProposalArray = this.getResults(iFile, string.indexOf("x;//vp4"));
        Assert.assertEquals((String)"x : int", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((String)"compare(const Point&) Point&", (String)iCompletionProposalArray[1].getDisplayString());
        Assert.assertEquals((int)2, (int)iCompletionProposalArray.length);
        iCompletionProposalArray = this.getResults(iFile, string.indexOf("x;//vp5"));
        Assert.assertEquals((int)0, (int)iCompletionProposalArray.length);
    }

    public void testEnumerations() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("enum day {ztuesday, zthursday};\t\n");
        stringWriter.write("enum {zTGIF};\t\t\t\t\t\n");
        stringWriter.write("int i=ztuesday;//vp1 \t\t\t\t\n");
        stringWriter.write("class Bar {\t\t\t\t\t\n");
        stringWriter.write(" public:\t\t\t\t\t\t\n");
        stringWriter.write("\tenum R4 {R1} num;\t\t\t\n");
        stringWriter.write("\tenum {R2};\t\t\t\t\t\n");
        stringWriter.write("\tstatic enum {R3} Rnum2;\t\t\t\t\n");
        stringWriter.write("\tday nd;\t\t\t\t\t\t\n");
        stringWriter.write("};\t\t\t\t\t\t\t\n");
        stringWriter.write("void foo(){\t\t\t\t\t\n");
        stringWriter.write("\tday d;//vp2\t\t\t\t\t\t\n");
        stringWriter.write("\td=ztuesday;//vp3 \t\t\t\n");
        stringWriter.write("\tBar::R1;//vp4 \t\t\t\t\n");
        stringWriter.write("\tBar b; \t\t\t\t\t\n");
        stringWriter.write("\tb.R3;//vp5 \t\t\t\t\t\n");
        stringWriter.write("}\t\t\t\t\t\t\t\t\n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("testEnumerations.cpp", string);
        ICompletionProposal[] iCompletionProposalArray = this.getResults(iFile, string.indexOf("uesday;//vp1"));
        Assert.assertEquals((String)"zthursday", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((String)"ztuesday", (String)iCompletionProposalArray[1].getDisplayString());
        Assert.assertEquals((String)"zTGIF", (String)iCompletionProposalArray[2].getDisplayString());
        Assert.assertEquals((int)3, (int)iCompletionProposalArray.length);
        iCompletionProposalArray = this.getResults(iFile, string.indexOf("y d;//vp2"));
        Assert.assertEquals((String)"day", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((int)1, (int)iCompletionProposalArray.length);
        iCompletionProposalArray = this.getResults(iFile, string.indexOf("uesday;//vp3"));
        Assert.assertEquals((String)"zthursday", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((String)"ztuesday", (String)iCompletionProposalArray[1].getDisplayString());
        Assert.assertEquals((String)"zTGIF", (String)iCompletionProposalArray[2].getDisplayString());
        Assert.assertEquals((int)3, (int)iCompletionProposalArray.length);
        iCompletionProposalArray = this.getResults(iFile, string.indexOf("R1;//vp4"));
        Assert.assertEquals((String)"Rnum2 : ", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((String)"R1", (String)iCompletionProposalArray[1].getDisplayString());
        Assert.assertEquals((String)"R2", (String)iCompletionProposalArray[2].getDisplayString());
        Assert.assertEquals((String)"R3", (String)iCompletionProposalArray[3].getDisplayString());
        Assert.assertEquals((String)"R4", (String)iCompletionProposalArray[4].getDisplayString());
        Assert.assertEquals((int)5, (int)iCompletionProposalArray.length);
        iCompletionProposalArray = this.getResults(iFile, string.indexOf("3;//vp5"));
        Assert.assertEquals((int)4, (int)iCompletionProposalArray.length);
        Assert.assertEquals((String)"Rnum2 : ", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((String)"R1", (String)iCompletionProposalArray[1].getDisplayString());
        Assert.assertEquals((String)"R2", (String)iCompletionProposalArray[2].getDisplayString());
        Assert.assertEquals((String)"R3", (String)iCompletionProposalArray[3].getDisplayString());
    }

    public void testLongTokens() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("int i123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890;\n");
        stringWriter.write("typedef int t123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890;\n");
        stringWriter.write("class A {\n");
        stringWriter.write(" A(t123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890 a){\n");
        stringWriter.write("   i123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890=0;//vp1 \n");
        stringWriter.write("   t123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890 t=a;//vp2 \n");
        stringWriter.write("   a=i123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890;//vp3 \n");
        stringWriter.write(" }\n");
        stringWriter.write("};\n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("testLongTokens.cpp", string);
        ICompletionProposal[] iCompletionProposalArray = this.getResults(iFile, string.indexOf("3456789012345678901234567890123456789012345678901234567890123456789012345678901234567890=0;//vp1"));
        Assert.assertEquals((String)"i123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890 : int", (String)iCompletionProposalArray[0].getDisplayString());
        iCompletionProposalArray = this.getResults(iFile, string.indexOf(";//vp2"));
        Assert.assertEquals((String)"a : t123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890", (String)iCompletionProposalArray[0].getDisplayString());
        iCompletionProposalArray = this.getResults(iFile, string.indexOf("7890;//vp3"));
        Assert.assertEquals((String)"i123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890 : int", (String)iCompletionProposalArray[0].getDisplayString());
    }

    public void testCastMultiLevel() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class Gee{\t\t\t\t\t\t\n");
        stringWriter.write("\tpublic: struct {int g1;} g0;\t\n");
        stringWriter.write("};\t\t\t\t\t\t\t\t\n");
        stringWriter.write("class Foo {\t\t\t\t\t\t\n");
        stringWriter.write("\tpublic:\tGee *f0;\t\t\t\t\n");
        stringWriter.write("};\t\t\t\t\t\t\t\t\n");
        stringWriter.write("class C {\t\t\t\t\t\t\t\n");
        stringWriter.write("\tvoid coo(int i){\t\t\t\t\n");
        stringWriter.write("\t  switch (i) {\t\t\t\t\t\n");
        stringWriter.write("\t    (*((new Foo())->f0)).g0.g1;//vp1 \n");
        stringWriter.write("\t    Gee *g;\t\t\t\t\t\t\n");
        stringWriter.write("\t    ((Foo*)g)->f0;//vp2 \t\t\n");
        stringWriter.write("\t    (*(((Foo*)g)->f0)).g0.g1;//vp3,vp4 \n");
        stringWriter.write("\t  }\t\t\t\t\t\t\t\t\n");
        stringWriter.write("\t}\t\t\t\t\t\t\t\t\n");
        stringWriter.write("};\t\t\t\t\t\t\t\t\n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("testCastMultiLevel.cpp", string);
        ICompletionProposal[] iCompletionProposalArray = this.getResults(iFile, string.indexOf("g1;//vp1"));
        Assert.assertEquals((String)"g1 : int", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((int)1, (int)iCompletionProposalArray.length);
        iCompletionProposalArray = this.getResults(iFile, string.indexOf("f0;//vp2"));
        Assert.assertEquals((String)"f0 : Gee*", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((int)1, (int)iCompletionProposalArray.length);
        iCompletionProposalArray = this.getResults(iFile, string.indexOf("g0.g1;//vp3"));
        Assert.assertEquals((String)"g0 : ", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((int)1, (int)iCompletionProposalArray.length);
        iCompletionProposalArray = this.getResults(iFile, string.indexOf("g1;//vp3,vp4"));
        Assert.assertEquals((String)"g1 : int", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((int)1, (int)iCompletionProposalArray.length);
    }

    public void testHeaderExtensions() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class C1{\t\t\t\t\n");
        stringWriter.write("\tenum {C1a, C1b};\t\n");
        stringWriter.write("\tC1() {\t\t\t\t\n");
        stringWriter.write("\t\tC1;//vp1\t\t\n");
        stringWriter.write("\t}\t\t\t\t\t\n");
        stringWriter.write("};\t\t\t\t\t\n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("testHeaderExtensions.h", string);
        ICompletionProposal[] iCompletionProposalArray = this.getResults(iFile, string.indexOf("1;//vp1"));
        Assert.assertEquals((String)"C1", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((String)"C1a", (String)iCompletionProposalArray[1].getDisplayString());
        Assert.assertEquals((String)"C1b", (String)iCompletionProposalArray[2].getDisplayString());
        Assert.assertEquals((int)3, (int)iCompletionProposalArray.length);
        this.removeFile("testHeaderExtensions.h");
        stringWriter = new StringWriter();
        stringWriter.write("class C{\t\t\t\t\n");
        stringWriter.write("\tpublic: enum {C1, C3};\t\t\n");
        stringWriter.write("\tC() {\t\t\t\t\n");
        stringWriter.write("\t\tC1;\t\t\n");
        stringWriter.write("\t}\t\t\t\t\t\n");
        stringWriter.write("};\t\t\t\t\t\n");
        stringWriter.write("namespace N {\t\t\t\n");
        stringWriter.write("int i =C::C1;//vp2\t\t\t\n");
        stringWriter.write("}\t\t\t\t\t\t\n");
        string = stringWriter.toString();
        iFile = this.importFile("testHeaderExtensions.H", string);
        iCompletionProposalArray = this.getResults(iFile, string.indexOf("C1;//vp2"));
        Assert.assertEquals((String)"C()", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((String)"C1", (String)iCompletionProposalArray[1].getDisplayString());
        Assert.assertEquals((String)"C3", (String)iCompletionProposalArray[2].getDisplayString());
        Assert.assertEquals((int)3, (int)iCompletionProposalArray.length);
        this.removeFile("testHeaderExtensions.H");
        stringWriter = new StringWriter();
        stringWriter.write("class C{\t\t\t\t\n");
        stringWriter.write("\tenum {C1, C3};\t\t\n");
        stringWriter.write("\tC() {\t\t\t\t\n");
        stringWriter.write("\t\tC1;//vp3\t\t\n");
        stringWriter.write("\t}\t\t\t\t\t\n");
        stringWriter.write("};\t\t\t\t\t\n");
        string = stringWriter.toString();
        iFile = this.importFile("testHeaderExtensions.hxx", string);
        iCompletionProposalArray = this.getResults(iFile, string.indexOf("1;//vp3"));
        Assert.assertEquals((String)"C", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((String)"C1", (String)iCompletionProposalArray[1].getDisplayString());
        Assert.assertEquals((String)"C3", (String)iCompletionProposalArray[2].getDisplayString());
        Assert.assertEquals((int)3, (int)iCompletionProposalArray.length);
        this.removeFile("testHeaderExtensions.hxx");
        stringWriter = new StringWriter();
        stringWriter.write("class C{\t\t\t\t\n");
        stringWriter.write("\tpublic: enum {C1, C3};\t\t\n");
        stringWriter.write("\tC() {\t\t\t\t\n");
        stringWriter.write("\t\tC1;\t\t\n");
        stringWriter.write("\t}\t\t\t\t\t\n");
        stringWriter.write("};\t\t\t\t\t\n");
        stringWriter.write("namespace N {\t\t\t\n");
        stringWriter.write("int i =C::C1;//vp4\t\t\t\n");
        stringWriter.write("}\t\t\t\t\t\t\n");
        string = stringWriter.toString();
        iFile = this.importFile("testHeaderExtensions.hh", string);
        iCompletionProposalArray = this.getResults(iFile, string.indexOf("C1;//vp4"));
        Assert.assertEquals((String)"C()", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((String)"C1", (String)iCompletionProposalArray[1].getDisplayString());
        Assert.assertEquals((String)"C3", (String)iCompletionProposalArray[2].getDisplayString());
        Assert.assertEquals((int)3, (int)iCompletionProposalArray.length);
        this.removeFile("testHeaderExtensions.hh");
        stringWriter = new StringWriter();
        stringWriter.write("class C{\t\t\t\t\n");
        stringWriter.write("\tpublic: enum {C1, C3};\t\t\n");
        stringWriter.write("\tC() {\t\t\t\t\n");
        stringWriter.write("\t\tC1;\t\t\n");
        stringWriter.write("\t}\t\t\t\t\t\n");
        stringWriter.write("};\t\t\t\t\t\n");
        stringWriter.write("namespace N {\t\t\t\n");
        stringWriter.write("int i =C::C1;//vp5\t\t\t\n");
        stringWriter.write("}\t\t\t\t\t\t\n");
        string = stringWriter.toString();
        iFile = this.importFile("testHeaderExtensions.H", string);
        iCompletionProposalArray = this.getResults(iFile, string.indexOf("C1;//vp5"));
        Assert.assertEquals((String)"C()", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((String)"C1", (String)iCompletionProposalArray[1].getDisplayString());
        Assert.assertEquals((String)"C3", (String)iCompletionProposalArray[2].getDisplayString());
        Assert.assertEquals((int)3, (int)iCompletionProposalArray.length);
    }

    public void testEmptyDocument() throws Exception {
        String string = "\u0000";
        IFile iFile = this.importFile("testEmptyDocument.h", string);
        ICompletionProposal[] iCompletionProposalArray = this.getResults(iFile, 0);
        Assert.assertEquals((String)"asm", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((String)"auto", (String)iCompletionProposalArray[1].getDisplayString());
        Assert.assertEquals((String)"bool", (String)iCompletionProposalArray[2].getDisplayString());
        Assert.assertEquals((String)"wchar_t", (String)iCompletionProposalArray[iCompletionProposalArray.length - 1].getDisplayString());
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("s//vp2");
        string = stringWriter.toString();
        iFile = this.importFile("testEmptyDocument.cpp", string);
        iCompletionProposalArray = this.getResults(iFile, string.indexOf("//vp2"));
        Assert.assertEquals((String)"short", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((String)"signed", (String)iCompletionProposalArray[1].getDisplayString());
        Assert.assertEquals((String)"static", (String)iCompletionProposalArray[2].getDisplayString());
        Assert.assertEquals((String)"struct", (String)iCompletionProposalArray[3].getDisplayString());
        Assert.assertEquals((int)4, (int)iCompletionProposalArray.length);
    }

    public void testVariable() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("namespace N {\t\t\t\t\t\n");
        stringWriter.write("\tclass ClassT {};\t\t\t\n");
        stringWriter.write("\tstruct StructT {};\t\t\t\n");
        stringWriter.write("\ttypedef struct {} TypedefT;\t\n");
        stringWriter.write("\tunion UnionT {};\t\t\t\n");
        stringWriter.write("\tClassT var6;\t\t\t\t\n");
        stringWriter.write("\tClassT var7=var6/*vp6*/;\t\t\t\t\n");
        stringWriter.write("}\t\t\t\t\t\t\t\t\n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("testVariable.h", string);
        stringWriter = new StringWriter();
        stringWriter.write("#include \"testVariable.h\"\t\n");
        stringWriter.write("using namespace N;\t\t\t\n");
        stringWriter.write("ClassT var1(){}\t\t\t\t\n");
        stringWriter.write("int f(){\t\t\t\t\t\t\n");
        stringWriter.write("\tStructT var2;    \t\t\t\n");
        stringWriter.write("\tTypedefT var3;     \t\t\t\n");
        stringWriter.write("\tUnionT var4;\t\t\t\t\n");
        stringWriter.write("\tbool var5;\t \t\t\t\t\n");
        stringWriter.write("\tvar5/*vp1*/;\t \t\t\t\n");
        stringWriter.write("}\t\t\t\t\t\t\t\t\n");
        String string2 = stringWriter.toString();
        IFile iFile2 = this.importFile("testVariable.cpp", string2);
        ICompletionProposal[] iCompletionProposalArray = this.getResults(iFile2, string2.indexOf("5/*vp1*/"));
        Assert.assertEquals((String)"var2 : StructT", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((String)"var3 : TypedefT", (String)iCompletionProposalArray[1].getDisplayString());
        Assert.assertEquals((String)"var4 : UnionT", (String)iCompletionProposalArray[2].getDisplayString());
        Assert.assertEquals((String)"var5 : bool", (String)iCompletionProposalArray[3].getDisplayString());
        Assert.assertEquals((String)"var6 : ClassT", (String)iCompletionProposalArray[4].getDisplayString());
        Assert.assertEquals((String)"var7 : ClassT", (String)iCompletionProposalArray[5].getDisplayString());
        Assert.assertEquals((String)"var1() ClassT", (String)iCompletionProposalArray[6].getDisplayString());
        Assert.assertEquals((int)7, (int)iCompletionProposalArray.length);
        iCompletionProposalArray = this.getResults(iFile, string.indexOf("6/*vp6*/"));
        Assert.assertEquals((String)"var6 : ClassT", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((int)1, (int)iCompletionProposalArray.length);
    }

    public void test80510() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("int aaa;\t\t\t\t\t\t\t\n");
        stringWriter.write("class Class1{\t\t\t\t\t\t\n");
        stringWriter.write("\t\tClass1();\t\t\t\t\t\n");
        stringWriter.write("\tint abc;\t\t\t\t\t\t\n");
        stringWriter.write("};\t\t\t\t\t\t\t\t\n");
        stringWriter.write("Class1::Class1(): abc/*vp1*/(2){}\t\n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("test80510.cpp", string);
        ICompletionProposal[] iCompletionProposalArray = this.getResults(iFile, string.indexOf("bc/*vp1*/"));
        Assert.assertEquals((int)1, (int)iCompletionProposalArray.length);
        Assert.assertEquals((String)"abc : int", (String)iCompletionProposalArray[0].getDisplayString());
    }

    public void testSingleNameReference() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("int snrV;\t\t\t\t\t\t\t\n");
        stringWriter.write("int snrF(int x){}\t\t\t\t\t\n");
        stringWriter.write("class snrC{void g();int snrFd;};\t\n");
        stringWriter.write("struct snrS{};\t\t\t\t\t\n");
        stringWriter.write("enum snrE{snrER};\t\t\t\t\t\n");
        stringWriter.write("void foo() {\t\t\t\t\t\t\n");
        stringWriter.write("\tunion snrU{ snrU(int a) {};int i; char* j;};\n");
        stringWriter.write("\tsnrU sn(snrV);\t\t\t\t\t\n");
        stringWriter.write("\tsnrV/*vp1*/=snrF/*vp2*/(snrV);\t\n");
        stringWriter.write("}\t\t\t\t\t\t\t\t\t\n");
        stringWriter.write("void snrC::g(){\t\t\t\t\t\n");
        stringWriter.write("\tsnrFd/*vp3*/ c;\t\t\t\t\t\n");
        stringWriter.write("}\t\t\t\t\t\t\t\t\t\n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("testSingleNameReference.cpp", string);
        ICompletionProposal[] iCompletionProposalArray = this.getResults(iFile, string.indexOf("rV/*vp1*/"));
        Assert.assertEquals((String)"sn : snrU", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((String)"snrV : int", (String)iCompletionProposalArray[1].getDisplayString());
        Assert.assertEquals((String)"snrF(int) int", (String)iCompletionProposalArray[2].getDisplayString());
        Assert.assertEquals((String)"snrC", (String)iCompletionProposalArray[3].getDisplayString());
        Assert.assertEquals((String)"snrS", (String)iCompletionProposalArray[4].getDisplayString());
        Assert.assertEquals((String)"snrU", (String)iCompletionProposalArray[5].getDisplayString());
        Assert.assertEquals((String)"snrER", (String)iCompletionProposalArray[6].getDisplayString());
        Assert.assertEquals((String)"snrE", (String)iCompletionProposalArray[7].getDisplayString());
        Assert.assertEquals((int)8, (int)iCompletionProposalArray.length);
        iCompletionProposalArray = this.getResults(iFile, string.indexOf("rF/*vp2*/"));
        Assert.assertEquals((String)"sn : snrU", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((String)"snrV : int", (String)iCompletionProposalArray[1].getDisplayString());
        Assert.assertEquals((String)"snrF(int) int", (String)iCompletionProposalArray[2].getDisplayString());
        Assert.assertEquals((String)"snrC", (String)iCompletionProposalArray[3].getDisplayString());
        Assert.assertEquals((String)"snrS", (String)iCompletionProposalArray[4].getDisplayString());
        Assert.assertEquals((String)"snrU", (String)iCompletionProposalArray[5].getDisplayString());
        Assert.assertEquals((String)"snrER", (String)iCompletionProposalArray[6].getDisplayString());
        Assert.assertEquals((String)"snrE", (String)iCompletionProposalArray[7].getDisplayString());
        Assert.assertEquals((int)8, (int)iCompletionProposalArray.length);
        iCompletionProposalArray = this.getResults(iFile, string.indexOf("rFd/*vp3*/"));
        Assert.assertEquals((String)"snrFd : int", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((String)"snrV : int", (String)iCompletionProposalArray[1].getDisplayString());
        Assert.assertEquals((String)"snrF(int) int", (String)iCompletionProposalArray[2].getDisplayString());
        Assert.assertEquals((String)"snrC", (String)iCompletionProposalArray[3].getDisplayString());
        Assert.assertEquals((String)"snrS", (String)iCompletionProposalArray[4].getDisplayString());
        Assert.assertEquals((String)"snrER", (String)iCompletionProposalArray[5].getDisplayString());
        Assert.assertEquals((String)"snrE", (String)iCompletionProposalArray[6].getDisplayString());
        Assert.assertEquals((int)7, (int)iCompletionProposalArray.length);
    }

    public void testNamespace() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("namespace Foo{ \t\t\t\t\n");
        stringWriter.write("int x; \t\t\t\t\t\t\n");
        stringWriter.write(" namespace Baz {\t\t\t\t\n");
        stringWriter.write("   int i;   \t\t\t\t\t\n");
        stringWriter.write(" }\t\t\t\t\t\t\t\n");
        stringWriter.write(" using namespace Baz/*vp1*/;\t\n");
        stringWriter.write("}\t\t\t\t\t\t\t\n");
        stringWriter.write("void g() {\t\t\t\t\t\n");
        stringWriter.write("\t Foo::i/*vp2*/ = 1;\t\t\t\n");
        stringWriter.write("  int y=Foo::Baz::i;//vp3\t\n");
        stringWriter.write("}  \t\t\t\t        \t\n");
        stringWriter.write("namespace Bar = Foo/*vp4*/;\t\n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("testNamespace.cpp", string);
        ICompletionProposal[] iCompletionProposalArray = this.getResults(iFile, string.indexOf("az/*vp1*/"));
        Assert.assertEquals((String)"Baz", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((int)1, (int)iCompletionProposalArray.length);
        iCompletionProposalArray = this.getResults(iFile, string.indexOf("Baz/*vp1*/"));
        Assert.assertEquals((String)"Baz", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((String)"Foo", (String)iCompletionProposalArray[1].getDisplayString());
        Assert.assertEquals((int)2, (int)iCompletionProposalArray.length);
        iCompletionProposalArray = this.getResults(iFile, string.indexOf("oo::i/*vp2*/"));
        Assert.assertEquals((String)"Foo", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((int)1, (int)iCompletionProposalArray.length);
        iCompletionProposalArray = this.getResults(iFile, string.indexOf("az::i;//vp3"));
        Assert.assertEquals((String)"Baz", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((int)1, (int)iCompletionProposalArray.length);
        iCompletionProposalArray = this.getResults(iFile, string.indexOf("oo/*vp4*/"));
        Assert.assertEquals((String)"Foo", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((int)1, (int)iCompletionProposalArray.length);
    }

    public void testNamespaceAlias80612() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("namespace Foo{ \t\t\t\t\n");
        stringWriter.write("int x; \t\t\t\t\t\t\n");
        stringWriter.write("}\t\t\t\t\t\t\t\n");
        stringWriter.write("namespace Bar = Foo/*vp4*/;\t\n");
        stringWriter.write("Bar::x;\t\t\t\t\t\t\n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("testNamespaceAlias80612.cpp", string);
        ICompletionProposal[] iCompletionProposalArray = this.getResults(iFile, string.indexOf("ar::x"));
        Assert.assertEquals((int)1, (int)iCompletionProposalArray.length);
        Assert.assertEquals((String)"Bar", (String)iCompletionProposalArray[0].getDisplayString());
    }

    public void testMacro() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("#define INT32_C(x) x ## L\t\t\t\n");
        stringWriter.write("#define INT32_MAX (2147483647)\t\n");
        stringWriter.write("int main(int argc, char **argv) {\t\n");
        stringWriter.write("\tINT32_C(2);//vp1\t\t\t\t\n");
        stringWriter.write("\treturn (0);\t\t\t\t\t\t\n");
        stringWriter.write("}\t\t\t\t\t\t\t\t\t\n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("testMacro.c", string);
        ICompletionProposal[] iCompletionProposalArray = this.getResults(iFile, string.indexOf("32_C(2);//vp1"));
        Assert.assertEquals((String)"INT32_C(x)", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((String)"INT32_MAX", (String)iCompletionProposalArray[1].getDisplayString());
        Assert.assertEquals((int)2, (int)iCompletionProposalArray.length);
    }

    public void testConstructor() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("namespace Foo{ \t\t\t\n");
        stringWriter.write("class Base{\t\t\t\t\n");
        stringWriter.write("\tBase(int x){}\t\t\t\n");
        stringWriter.write("\t};\t\t\t\t\t\t\n");
        stringWriter.write("class Derived: Base{\t\n");
        stringWriter.write("\tDerived(): Base/*vp1*/(4){}\t\n");
        stringWriter.write("\t}; \t\t\t\t\t\t\n");
        stringWriter.write("}\t\t\t\t\t\t\n");
        stringWriter.write("void f(){\t\t\t\t\n");
        stringWriter.write("\tFoo::Derived& x = *(new Foo::Derived/*vp2*/())/;\t\n");
        stringWriter.write("}; \t\t\t\t\t\t\n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("testConstructor.cpp", string);
        ICompletionProposal[] iCompletionProposalArray = this.getResults(iFile, string.indexOf("ase/*vp1*/"));
        Assert.assertEquals((int)1, (int)iCompletionProposalArray.length);
        Assert.assertEquals((String)"Base", (String)iCompletionProposalArray[0].getDisplayString());
        iCompletionProposalArray = this.getResults(iFile, string.indexOf("erived/*vp2*/"));
        Assert.assertEquals((int)1, (int)iCompletionProposalArray.length);
        Assert.assertEquals((String)"Derived", (String)iCompletionProposalArray[0].getDisplayString());
    }

    public void testUnion() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("namespace Foo{ \t\t\t\t\n");
        stringWriter.write("union uni1{};\t\t\t\t\n");
        stringWriter.write("class c1{ \t\t\t\t\t\n");
        stringWriter.write("  public: union uni2{} s; \t\n");
        stringWriter.write("};\t\t\t\t          \t\n");
        stringWriter.write("namespace N{   \t\t        \n");
        stringWriter.write(" union uni3{};\t        \t\n");
        stringWriter.write(" class c2{ \t\t\t\t\t\n");
        stringWriter.write("   uni1/*vp1*/ s;\t\t\t\n");
        stringWriter.write("   uni3 ss;\t\t\t    \t\n");
        stringWriter.write("   c2() {\t\t\t    \t\n");
        stringWriter.write("     c1::uni2/*vp2*/ s;\t\t\n");
        stringWriter.write("     union uni3/*vp3*/ t;\t\n");
        stringWriter.write("   }\t\t\t\t          \t\n");
        stringWriter.write(" };\t\t\t\t          \t\n");
        stringWriter.write("}\t\t\t                \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("testUnion.cpp", string);
        ICompletionProposal[] iCompletionProposalArray = this.getResults(iFile, string.indexOf("1/*vp1*/"));
        Assert.assertEquals((int)3, (int)iCompletionProposalArray.length);
        Assert.assertEquals((String)"uni1", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((String)"uni3", (String)iCompletionProposalArray[1].getDisplayString());
        Assert.assertEquals((String)"union", (String)iCompletionProposalArray[2].getDisplayString());
        iCompletionProposalArray = this.getResults(iFile, string.indexOf("i2/*vp2*/"));
        Assert.assertEquals((int)1, (int)iCompletionProposalArray.length);
        Assert.assertEquals((String)"uni2", (String)iCompletionProposalArray[0].getDisplayString());
        iCompletionProposalArray = this.getResults(iFile, string.indexOf("i3/*vp3*/"));
        Assert.assertEquals((int)2, (int)iCompletionProposalArray.length);
        Assert.assertEquals((String)"uni1", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((String)"uni3", (String)iCompletionProposalArray[1].getDisplayString());
    }

    public void testKeyword() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class/*vp1*/ Foo{ \t\t\n");
        stringWriter.write("void f();\t\t\t\n");
        stringWriter.write("  public/*vp2*/: Foo(); \t\n");
        stringWriter.write("};\t\t\t\t        \n");
        stringWriter.write("void Foo::f() {\t\t\t\n");
        stringWriter.write("  void/*vp3*/* g; \t\t\n");
        stringWriter.write("}\t\t\t          \t\n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("testKeyword.cpp", string);
        ICompletionProposal[] iCompletionProposalArray = this.getResults(iFile, string.indexOf("lass/*vp1*/"));
        Assert.assertEquals((int)3, (int)iCompletionProposalArray.length);
        Assert.assertEquals((String)"char", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((String)"class", (String)iCompletionProposalArray[1].getDisplayString());
        Assert.assertEquals((String)"const", (String)iCompletionProposalArray[2].getDisplayString());
        iCompletionProposalArray = this.getResults(iFile, string.indexOf("lic/*vp2*/"));
        Assert.assertEquals((int)1, (int)iCompletionProposalArray.length);
        Assert.assertEquals((String)"public", (String)iCompletionProposalArray[0].getDisplayString());
        iCompletionProposalArray = this.getResults(iFile, string.indexOf("d/*vp3*/"));
        Assert.assertEquals((int)1, (int)iCompletionProposalArray.length);
        Assert.assertEquals((String)"void", (String)iCompletionProposalArray[0].getDisplayString());
    }

    public void testBase() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class Base{ \t\t\t\n");
        stringWriter.write(" Base();\t\t\t\t\n");
        stringWriter.write("  protected: int b();\n");
        stringWriter.write("};\t\t\t\t    \n");
        stringWriter.write("class Derived: Base{ \n");
        stringWriter.write(" Derived();\t\t\t\n");
        stringWriter.write("  void d() {\t\t\t\n");
        stringWriter.write("  b/*vp1*/{\t\t\t\n");
        stringWriter.write("};\t\t\t\t    \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("testBase.cpp", string);
        ICompletionProposal[] iCompletionProposalArray = this.getResults(iFile, string.indexOf("/*vp1*/"));
        Assert.assertEquals((int)4, (int)iCompletionProposalArray.length);
        Assert.assertEquals((String)"b() int", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((String)"Base", (String)iCompletionProposalArray[1].getDisplayString());
        Assert.assertEquals((String)"bool", (String)iCompletionProposalArray[2].getDisplayString());
        Assert.assertEquals((String)"break", (String)iCompletionProposalArray[3].getDisplayString());
    }

    public void testThis() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class X{ \t\t\t\t\t\t\t\t\n");
        stringWriter.write(" X& X::operator=(const X& rhs){\t\t\t\n");
        stringWriter.write("  if(this/*vp1*/==&rhs)return *this;\t\t\n");
        stringWriter.write("  (*this/*vp2*/).aVar=rhs.aVar;\t\t\t\n");
        stringWriter.write("\t this/*vp3*/->anotherVar=rhs.anotherVar;\n");
        stringWriter.write("  return *this;\t\t\t\t\t\t\t\n");
        stringWriter.write("  }\t\t\t\t    \t\t\t\t\t\n");
        stringWriter.write("\t int aVar, anotherVar; \t\t\t\t\t\n");
        stringWriter.write("};\t\t\t\t    \t\t\t\t\t\n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("testThis.cpp", string);
        ICompletionProposal[] iCompletionProposalArray = this.getResults(iFile, string.indexOf("s/*vp1*/"));
        Assert.assertEquals((int)1, (int)iCompletionProposalArray.length);
        Assert.assertEquals((String)"this", (String)iCompletionProposalArray[0].getDisplayString());
        iCompletionProposalArray = this.getResults(iFile, string.indexOf("s/*vp2*/"));
        Assert.assertEquals((int)1, (int)iCompletionProposalArray.length);
        Assert.assertEquals((String)"this", (String)iCompletionProposalArray[0].getDisplayString());
        iCompletionProposalArray = this.getResults(iFile, string.indexOf("s/*vp3*/"));
        Assert.assertEquals((int)1, (int)iCompletionProposalArray.length);
        Assert.assertEquals((String)"this", (String)iCompletionProposalArray[0].getDisplayString());
    }

    public void testClassScope() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class Foo{\t\t\t\t\t\n");
        stringWriter.write("\tpublic:\t\t\t\t\t\t\n");
        stringWriter.write("\t\tFoo(){}\t\t\t\t\t\n");
        stringWriter.write("\t\tint getThatVar();\t\t\n");
        stringWriter.write("\tprivate:\t\t\t\t\t\n");
        stringWriter.write("\t\tint thatVar;\t\t\t\n");
        stringWriter.write("\t};\t\t\t\t\t\t\t\n");
        String string = stringWriter.toString();
        this.importFile("testClassScope.h", string);
        stringWriter.write("\t#include \"testClassScope.h\"\t\t\n");
        stringWriter.write("\tint Foo::getThatVar/*vp1*/(){\t\t\n");
        stringWriter.write("\t\treturn thatVar/*vp2*/; \t\t\t\n");
        stringWriter.write("\t}\t\t\t\t\t\t\t\t\t\n");
        String string2 = stringWriter.toString();
        IFile iFile = this.importFile("testClassScope.cpp", string2);
        ICompletionProposal[] iCompletionProposalArray = this.getResults(iFile, string2.indexOf("Var/*vp1*/"));
        Assert.assertEquals((int)1, (int)iCompletionProposalArray.length);
        Assert.assertEquals((String)"getThatVar() int", (String)iCompletionProposalArray[0].getDisplayString());
        iCompletionProposalArray = this.getResults(iFile, string2.indexOf("Var/*vp2*/"));
        Assert.assertEquals((int)1, (int)iCompletionProposalArray.length);
        Assert.assertEquals((String)"thatVar : int", (String)iCompletionProposalArray[0].getDisplayString());
    }

    public void testClassScope72564() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class X{ \t\t\t\t\t\n");
        stringWriter.write("class ElStatico{\t\t\t\t\n");
        stringWriter.write("\tpublic:\t\t\t\t\t\t\n");
        stringWriter.write("\t\tElStatico(){}\t\t\t\n");
        stringWriter.write("\t\tvirtual ~ElStatico(){}\t\n");
        stringWriter.write("\tprivate:\t\t\t\t\t\n");
        stringWriter.write("\t\tstatic int aClsVar;\t\t\n");
        stringWriter.write("\t};\t\t\t\t\t\t\t\n");
        String string = stringWriter.toString();
        this.importFile("testClassScope72564.h", string);
        stringWriter.write("\t#include \"testClassScope72564.h\"\t\n");
        stringWriter.write("\tint ElStatico::aClsVar/*vp1*/ = 10;\t\n");
        String string2 = stringWriter.toString();
        IFile iFile = this.importFile("testClassScope72564.cpp", string2);
        ICompletionProposal[] iCompletionProposalArray = this.getResults(iFile, string2.indexOf("Var/*vp1*/"));
        Assert.assertEquals((int)1, (int)iCompletionProposalArray.length);
        Assert.assertEquals((String)"aClsVar", (String)iCompletionProposalArray[0].getDisplayString());
    }

    public void testMultiLevelQualifiers() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class A{ \t\t\t\t\t\n");
        stringWriter.write("public: class B{\t\t\t\t\n");
        stringWriter.write("public: class C{\t\t\t\t\n");
        stringWriter.write("public: class D{\t\t\t\t\n");
        stringWriter.write("public: class E{\t\t\t\t\n");
        stringWriter.write("public: class F{\t\t\t\t\n");
        stringWriter.write("public: class G{\t\t\t\t\n");
        stringWriter.write("public: class H{\t\t\t\t\n");
        stringWriter.write("public: class I{\t\t\t\t\n");
        stringWriter.write("public: class J{\t\t\t\t\n");
        stringWriter.write("public: class K{\t\t\t\t\n");
        stringWriter.write("public: class L{\t\t\t\t\n");
        stringWriter.write("public: class M{\t\t\t\t\n");
        stringWriter.write("}m;}l;}k;}j;}i;}h;}g;}f;}e;}d;}c;}b;};\t\n");
        stringWriter.write("\tA a;\t\t\t\t\t\t\t\t\t\n");
        stringWriter.write("\tvoid f(){\t\t\t\t\t\t\t\t\n");
        stringWriter.write("\t\ta.b.c.d.e.f.g.h.i.j.k.l.m/*vp1*/;\t\n");
        stringWriter.write("\t}\t\t\t\t\t\t\t\t\t\t\n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("testMultiLevelQualifiers.cpp", string);
        ICompletionProposal[] iCompletionProposalArray = this.getResults(iFile, string.indexOf("m/*vp1*/"));
        Assert.assertEquals((int)1, (int)iCompletionProposalArray.length);
        Assert.assertEquals((String)"m : M", (String)iCompletionProposalArray[0].getDisplayString());
    }

    public void testCase() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class Ananas{ \t\t\t\t\n");
        stringWriter.write("public: Ananas();\t\t\t\n");
        stringWriter.write("void ananas(int i);\t\t\t\n");
        stringWriter.write("int aNaNaS();\t\t\t\t\n");
        stringWriter.write("int ANAnas;\t\t\t\t\t\n");
        stringWriter.write("};\t\t\t\t\t\t\t\n");
        stringWriter.write("int ananaS;\t\t\t\t\t\n");
        stringWriter.write("void anaNAS(){\t\t\t\t\n");
        stringWriter.write("Ananas/*vp1*/ a;\t\t\t\t\n");
        stringWriter.write("a.aNaNaS/*vp2*/();\t\t\t\n");
        stringWriter.write("}\t\t\t\t\t\t\t\n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("testCase.cpp", string);
        ICompletionProposal[] iCompletionProposalArray = this.getResults(iFile, string.indexOf("nas/*vp1*/"));
        Assert.assertEquals((int)3, (int)iCompletionProposalArray.length);
        Assert.assertEquals((String)"Ananas", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((String)"ananaS : int", (String)iCompletionProposalArray[1].getDisplayString());
        Assert.assertEquals((String)"anaNAS() void", (String)iCompletionProposalArray[2].getDisplayString());
        iCompletionProposalArray = this.getResults(iFile, string.indexOf("NaS/*vp2*/"));
        Assert.assertEquals((int)3, (int)iCompletionProposalArray.length);
        Assert.assertEquals((String)"aNaNaS() int", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((String)"ANAnas : int", (String)iCompletionProposalArray[1].getDisplayString());
        Assert.assertEquals((String)"ananas(int) void", (String)iCompletionProposalArray[2].getDisplayString());
    }

    public void testType() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("namespace N {\t\t\t\t\n");
        stringWriter.write("\tclass ClassT {};\t\t\n");
        stringWriter.write("\tstruct StructT {};\t\t\n");
        stringWriter.write("\ttypedef struct {} TypedefT;\t\t\n");
        stringWriter.write("\tunion UnionT {};\t\t\n");
        stringWriter.write("}\t\t\t\t\t\t\t\n");
        String string = stringWriter.toString();
        this.importFile("testType.h", string);
        stringWriter = new StringWriter();
        stringWriter.write("#include \"testType.h\"\t\t\n");
        stringWriter.write("int main (int argc, char** argv){\t\n");
        stringWriter.write("\tusing namespace N;\t\t\n");
        stringWriter.write("\tClassT/*vp1*/ c;\t\t\n");
        stringWriter.write("\tStructT/*vp2*/ d;    \t\n");
        stringWriter.write("\tTypedefT/*vp3*/ e;     \t\n");
        stringWriter.write("\tUnionT/*vp4*/ f;\t\t\n");
        stringWriter.write("\tbool/*vp5*/ b;\t \t\t\n");
        stringWriter.write("}\t\t\t\t\t\t\t\n");
        String string2 = stringWriter.toString();
        IFile iFile = this.importFile("testType.cpp", string2);
        ICompletionProposal[] iCompletionProposalArray = this.getResults(iFile, string2.indexOf("T/*vp1*/"));
        Assert.assertEquals((String)"ClassT", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((int)1, (int)iCompletionProposalArray.length);
        iCompletionProposalArray = this.getResults(iFile, string2.indexOf("T/*vp2*/"));
        Assert.assertEquals((String)"StructT", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((int)1, (int)iCompletionProposalArray.length);
        iCompletionProposalArray = this.getResults(iFile, string2.indexOf("T/*vp3*/"));
        Assert.assertEquals((String)"TypedefT", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((int)1, (int)iCompletionProposalArray.length);
        iCompletionProposalArray = this.getResults(iFile, string2.indexOf("T/*vp4*/"));
        Assert.assertEquals((String)"UnionT", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((int)1, (int)iCompletionProposalArray.length);
        iCompletionProposalArray = this.getResults(iFile, string2.indexOf("l/*vp5*/"));
        Assert.assertEquals((String)"bool", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((int)1, (int)iCompletionProposalArray.length);
    }

    public void testTryCatch() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class MyException{\t\t\t\t\t\t\n");
        stringWriter.write("\tpublic:\t\t\t\t\t\t\t\t\t\n");
        stringWriter.write("\tMyException(const char *msg){}\t\t\t\n");
        stringWriter.write("\tconst char* getMsg(){return \"error\";}\t\n");
        stringWriter.write("};\t\t\t\t\t\t\t\t\t\t\n");
        stringWriter.write("void someFunction() {\t\t\t\t\t\t\n");
        stringWriter.write("\tthrow MyException(\"someFunction is in trouble\");\n");
        stringWriter.write("}\t\t\t\t\t\t\t\t\t\t\t\n");
        stringWriter.write("void k(){\t\t\t\t\t\t\t\t\t\n");
        stringWriter.write("\ttry {\t\t\t\t\t\t\t\t\t\n");
        stringWriter.write("\t\tsomeFunction/*vp1*/();\t\t\t\t\n");
        stringWriter.write("\t} catch (MyException &e) {\t\t\t\t\n");
        stringWriter.write("\t\te.getMsg/*vp2*/();\t\t\t\t\t\n");
        stringWriter.write("\t}\t\t\t\t\t\t\t\t\t\t\n");
        stringWriter.write("}\t\t\t\t\t\t\t\t\t\t\t\n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("testTryCatch.cpp", string);
        ICompletionProposal[] iCompletionProposalArray = this.getResults(iFile, string.indexOf("Function/*vp1*/"));
        Assert.assertEquals((String)"someFunction() void", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((int)1, (int)iCompletionProposalArray.length);
        iCompletionProposalArray = this.getResults(iFile, string.indexOf("Msg/*vp2*/"));
        Assert.assertEquals((String)"getMsg() const char*", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((int)1, (int)iCompletionProposalArray.length);
    }

    public void testArrays() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write(" \tclass A{\t\t\t\t\t\t\n");
        stringWriter.write("\t\tpublic: \t\t\t\t\t\n");
        stringWriter.write("\t\tA(){}\t\t\t\t\t\t\n");
        stringWriter.write("\t\tvoid aa();\t\t\t\t\t\n");
        stringWriter.write("\t\tint aaa;\t\t\t\t\t\n");
        stringWriter.write("\t\tstatic int bbb;\t\t\t\t\n");
        stringWriter.write("\t};\t\t\t\t\t\t\t\t\n");
        stringWriter.write("\tvoid fodo(){\t\t\t\t\t\n");
        stringWriter.write("\t\tA a_array[10];\t\t\t\t\n");
        stringWriter.write("\t\tA* b_array[10];\t\t\t\t\n");
        stringWriter.write("\t\tfor (int i=0; i<10;i++){\t\n");
        stringWriter.write("\t\t\ta_array[i].aaa/*vp1*/=3;\n");
        stringWriter.write("\t\t\tint x=b_array[i]->bbb/*vp2*/;\n");
        stringWriter.write("\t}\t\t\t\t\t\t\t\t\n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("testArrays.cpp", string);
        ICompletionProposal[] iCompletionProposalArray = this.getResults(iFile, string.indexOf("a/*vp1*/"));
        Assert.assertEquals((String)"aa() void", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((String)"aaa : int", (String)iCompletionProposalArray[1].getDisplayString());
        Assert.assertEquals((int)2, (int)iCompletionProposalArray.length);
        iCompletionProposalArray = this.getResults(iFile, string.indexOf("bbb/*vp2*/"));
        Assert.assertEquals((String)"aaa : int", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((String)"bbb : int", (String)iCompletionProposalArray[1].getDisplayString());
        Assert.assertEquals((String)"aa() void", (String)iCompletionProposalArray[2].getDisplayString());
        Assert.assertEquals((int)3, (int)iCompletionProposalArray.length);
    }

    public void testStruct() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("//aggregate struct (no constructor)\t\t\t\t\t\t\t\t\n");
        stringWriter.write("struct myStruct_c{int m;}ss1={1},ss2={2};\t\t\t\t\t\t\t\n");
        stringWriter.write("void foo() {\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        stringWriter.write(" \t\tmyStruct_c *ss3;\t\t\t\t\t\t\t\t\t\t\t\n");
        stringWriter.write(" \t\tss3->m=3;\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        stringWriter.write(" \t\tint i=(ss1.m/*vp1*/ > ss3->m/*vp2*/ ? ss1/*vp3*/ : ss2/*vp4*/).m;\n");
        stringWriter.write("\t\t//struct with constructor\t\t\t\t\t\t\t\t\t\n");
        stringWriter.write("\t\tsizeof(myStruct_c/*vp8*/);\t \t\t\t\t\t\t\t\t\n");
        stringWriter.write("\t\tstruct myStruct_cpp {\t\t\t\t\t\t\t\t\t\t\n");
        stringWriter.write("\t\t\tmyStruct_cpp(int x){z=x;}\t\t\t\t\t\t\t\t\n");
        stringWriter.write("\t\t\tint z;\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        stringWriter.write("\t\t};\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        stringWriter.write("\t\tmyStruct_cpp ss4(4), *ss5;\t\t\t\t\t\t\t\t\t\n");
        stringWriter.write("\t\tss5=new myStruct_cpp/*vp9*/(5);\t\t\t\t\t\t\t\t\t\n");
        stringWriter.write("\t\t3>ss4.z/*vp5*/ ? ss5->z/*vp6*/ : ss4.z/*vp7*/;\t\t\t\t\n");
        stringWriter.write("}\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("testStruct.cpp", string);
        ICompletionProposal[] iCompletionProposalArray = this.getResults(iFile, string.indexOf("1.m/*vp1*/"));
        Assert.assertEquals((String)"ss3 : myStruct_c*", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((String)"ss1 : myStruct_c", (String)iCompletionProposalArray[1].getDisplayString());
        Assert.assertEquals((String)"ss2 : myStruct_c", (String)iCompletionProposalArray[2].getDisplayString());
        Assert.assertEquals((int)3, (int)iCompletionProposalArray.length);
        iCompletionProposalArray = this.getResults(iFile, string.indexOf("3->m/*vp2*/"));
        Assert.assertEquals((String)"ss3 : myStruct_c*", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((String)"ss1 : myStruct_c", (String)iCompletionProposalArray[1].getDisplayString());
        Assert.assertEquals((String)"ss2 : myStruct_c", (String)iCompletionProposalArray[2].getDisplayString());
        Assert.assertEquals((int)3, (int)iCompletionProposalArray.length);
        iCompletionProposalArray = this.getResults(iFile, string.indexOf("1/*vp3*/"));
        Assert.assertEquals((String)"ss3 : myStruct_c*", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((String)"ss1 : myStruct_c", (String)iCompletionProposalArray[1].getDisplayString());
        Assert.assertEquals((String)"ss2 : myStruct_c", (String)iCompletionProposalArray[2].getDisplayString());
        Assert.assertEquals((int)3, (int)iCompletionProposalArray.length);
        iCompletionProposalArray = this.getResults(iFile, string.indexOf("2/*vp4*/"));
        Assert.assertEquals((String)"ss3 : myStruct_c*", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((String)"ss1 : myStruct_c", (String)iCompletionProposalArray[1].getDisplayString());
        Assert.assertEquals((String)"ss2 : myStruct_c", (String)iCompletionProposalArray[2].getDisplayString());
        Assert.assertEquals((int)3, (int)iCompletionProposalArray.length);
        iCompletionProposalArray = this.getResults(iFile, string.indexOf("4.z/*vp5*/"));
        Assert.assertEquals((String)"ss3 : myStruct_c*", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((String)"ss4 : myStruct_cpp", (String)iCompletionProposalArray[1].getDisplayString());
        Assert.assertEquals((String)"ss5 : myStruct_cpp*", (String)iCompletionProposalArray[2].getDisplayString());
        Assert.assertEquals((String)"ss1 : myStruct_c", (String)iCompletionProposalArray[3].getDisplayString());
        Assert.assertEquals((String)"ss2 : myStruct_c", (String)iCompletionProposalArray[4].getDisplayString());
        Assert.assertEquals((int)5, (int)iCompletionProposalArray.length);
        iCompletionProposalArray = this.getResults(iFile, string.indexOf("5->z/*vp6*/"));
        Assert.assertEquals((String)"ss3 : myStruct_c*", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((String)"ss4 : myStruct_cpp", (String)iCompletionProposalArray[1].getDisplayString());
        Assert.assertEquals((String)"ss5 : myStruct_cpp*", (String)iCompletionProposalArray[2].getDisplayString());
        Assert.assertEquals((String)"ss1 : myStruct_c", (String)iCompletionProposalArray[3].getDisplayString());
        Assert.assertEquals((String)"ss2 : myStruct_c", (String)iCompletionProposalArray[4].getDisplayString());
        Assert.assertEquals((int)5, (int)iCompletionProposalArray.length);
        iCompletionProposalArray = this.getResults(iFile, string.indexOf("4.z/*vp7*/"));
        Assert.assertEquals((String)"ss3 : myStruct_c*", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((String)"ss4 : myStruct_cpp", (String)iCompletionProposalArray[1].getDisplayString());
        Assert.assertEquals((String)"ss5 : myStruct_cpp*", (String)iCompletionProposalArray[2].getDisplayString());
        Assert.assertEquals((String)"ss1 : myStruct_c", (String)iCompletionProposalArray[3].getDisplayString());
        Assert.assertEquals((String)"ss2 : myStruct_c", (String)iCompletionProposalArray[4].getDisplayString());
        Assert.assertEquals((int)5, (int)iCompletionProposalArray.length);
        iCompletionProposalArray = this.getResults(iFile, string.indexOf("Struct_c/*vp8*/"));
        Assert.assertEquals((String)"myStruct_c", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((int)1, (int)iCompletionProposalArray.length);
        iCompletionProposalArray = this.getResults(iFile, string.indexOf("Struct_cpp/*vp9*/"));
        Assert.assertEquals((String)"myStruct_c", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((String)"myStruct_cpp", (String)iCompletionProposalArray[1].getDisplayString());
        Assert.assertEquals((int)2, (int)iCompletionProposalArray.length);
    }

    public void testCodeTemplate() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("int main(int argc, char **argv) {\t\n");
        stringWriter.write("\tint max=10;\t\t\t\t\t\t\n");
        stringWriter.write("\tbool condition=false;\t\t\t\n");
        stringWriter.write("\tint key=1;\t\t\t\t\t\t\n");
        stringWriter.write("\tconst int value=1;\t\t\t\t\n");
        stringWriter.write("\tfor/*vp1*/ (int var = 0; var < max; ++var) {\n");
        stringWriter.write("\t\t\t\t\t\t\t\t\t\n");
        stringWriter.write("\t}\t\t\t\t\t\t\t\t\n");
        stringWriter.write("\tdo/*vp2*/ {\t\t\t\t\t\t\n");
        stringWriter.write("\t\t\t\t\t\t\t\t\t\n");
        stringWriter.write("\t} while (condition);\t\t\t\n");
        stringWriter.write("\tswitch/*vp3*/ (key) {\t\t\t\n");
        stringWriter.write("\t \tcase value:\t\t\t\t\t\n");
        stringWriter.write("\t \t\t\t\t\t\t\t\t\n");
        stringWriter.write("\t  \tbreak;\t\t\t\t\t\t\n");
        stringWriter.write("\t \tdefault:\t\t\t\t\t\n");
        stringWriter.write("\t  \tbreak;\t\t\t\t\t\t\n");
        stringWriter.write("\t}\t\t\t\t\t\t\t\t\n");
        stringWriter.write("}\t\t\t\t\t\t\t\t\t\n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("testCodeTemplate.cpp", string);
        ICompletionProposal[] iCompletionProposalArray = this.getResults(iFile, string.indexOf("/*vp1*/"));
        Assert.assertEquals((int)3, (int)iCompletionProposalArray.length);
        Assert.assertEquals((String)"for", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((String)"for - for loop", (String)iCompletionProposalArray[1].getDisplayString());
        Assert.assertEquals((String)"for - for loop with temporary variable", (String)iCompletionProposalArray[2].getDisplayString());
        Assert.assertEquals((int)3, (int)iCompletionProposalArray.length);
        iCompletionProposalArray = this.getResults(iFile, string.indexOf("/*vp2*/"));
        Assert.assertEquals((String)"do", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((String)"double", (String)iCompletionProposalArray[1].getDisplayString());
        Assert.assertEquals((String)"do - do while statement", (String)iCompletionProposalArray[2].getDisplayString());
        Assert.assertEquals((int)2, (int)iCompletionProposalArray.length);
        iCompletionProposalArray = this.getResults(iFile, string.indexOf("ch/*vp3*/"));
        Assert.assertEquals((String)"switch", (String)iCompletionProposalArray[0].getDisplayString());
        Assert.assertEquals((String)"switch - switch case statement", (String)iCompletionProposalArray[1].getDisplayString());
    }
}

