/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.tests.text.contentassist;

import java.io.FileInputStream;
import java.io.InputStream;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.core.parser.ast.IASTCompletionNode;
import org.eclipse.cdt.core.parser.ast.IASTNode;
import org.eclipse.cdt.core.parser.ast.IASTScope;
import org.eclipse.cdt.core.testplugin.CProjectHelper;
import org.eclipse.cdt.internal.core.browser.cache.TypeCacheManager;
import org.eclipse.cdt.internal.ui.text.contentassist.CCompletionProcessor;
import org.eclipse.cdt.ui.testplugin.CTestPlugin;
import org.eclipse.cdt.ui.text.ICCompletionProposal;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;

public abstract class CompletionProposalsBaseTest
extends TestCase {
    protected static final String EMPTY_STRING = "";
    private final String projectName = "TestProject1";
    private final String projectType = "bin";
    private ICProject fCProject;
    private IFile fCFile;
    private IFile fHeaderFile;
    private NullProgressMonitor monitor;
    private ITranslationUnit tu = null;
    private String buffer = "";
    private Document document = null;

    public CompletionProposalsBaseTest(String string) {
        super(string);
    }

    protected abstract String getFileName();

    protected abstract String getFileFullPath();

    protected abstract String getHeaderFileName();

    protected abstract String getHeaderFileFullPath();

    protected abstract int getCompletionPosition();

    protected abstract String getExpectedScopeClassName();

    protected abstract String getExpectedContextClassName();

    protected abstract String getExpectedPrefix();

    protected abstract IASTCompletionNode.CompletionKind getExpectedKind();

    protected abstract String[] getExpectedResultsValues();

    protected String getFunctionOrConstructorName() {
        return EMPTY_STRING;
    }

    protected void setUp() throws Exception {
        Object object;
        this.monitor = new NullProgressMonitor();
        this.fCProject = CProjectHelper.createCProject((String)"TestProject1", (String)"bin");
        this.fHeaderFile = this.fCProject.getProject().getFile(this.getHeaderFileName());
        String string = this.getFileName();
        this.fCFile = this.fCProject.getProject().getFile(string);
        if (!this.fCFile.exists() && !this.fHeaderFile.exists()) {
            try {
                object = new FileInputStream(CTestPlugin.getDefault().getFileInPlugin((IPath)new Path(this.getHeaderFileFullPath())));
                this.fHeaderFile.create((InputStream)object, false, (IProgressMonitor)this.monitor);
                FileInputStream fileInputStream = new FileInputStream(CTestPlugin.getDefault().getFileInPlugin((IPath)new Path(this.getFileFullPath())));
                this.fCFile.create((InputStream)fileInputStream, false, (IProgressMonitor)this.monitor);
            }
            catch (CoreException coreException) {
                coreException.printStackTrace();
            }
        }
        if (!this.fCProject.getProject().hasNature("org.eclipse.cdt.core.ccnature")) {
            CompletionProposalsBaseTest.addNatureToProject(this.fCProject.getProject(), "org.eclipse.cdt.core.ccnature", null);
        }
        object = TypeCacheManager.getInstance();
        object.setProcessTypeCacheEvents(false);
    }

    private static void addNatureToProject(IProject iProject, String string, IProgressMonitor iProgressMonitor) throws CoreException {
        IProjectDescription iProjectDescription = iProject.getDescription();
        String[] stringArray = iProjectDescription.getNatureIds();
        String[] stringArray2 = new String[stringArray.length + 1];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        stringArray2[stringArray.length] = string;
        iProjectDescription.setNatureIds(stringArray2);
        iProject.setDescription(iProjectDescription, iProgressMonitor);
    }

    protected void tearDown() {
        CProjectHelper.delete((ICProject)this.fCProject);
    }

    public void testCompletionProposals() {
        try {
            ITranslationUnit iTranslationUnit = (ITranslationUnit)CoreModel.getDefault().create(this.fCFile);
            this.buffer = iTranslationUnit.getBuffer().getContents();
            this.document = new Document(this.buffer);
            int n = this.getCompletionPosition();
            CCompletionProcessor cCompletionProcessor = new CCompletionProcessor(null);
            IWorkingCopy iWorkingCopy = null;
            try {
                iWorkingCopy = iTranslationUnit.getWorkingCopy();
            }
            catch (CModelException cModelException) {
                Assert.fail((String)"Failed to get working copy");
            }
            ICCompletionProposal[] iCCompletionProposalArray = cCompletionProcessor.evalProposals((IDocument)this.document, n, iWorkingCopy, null);
            Assert.assertTrue((iCCompletionProposalArray != null ? 1 : 0) != 0);
            IASTCompletionNode iASTCompletionNode = cCompletionProcessor.getCurrentCompletionNode();
            Assert.assertNotNull((Object)iASTCompletionNode);
            IASTScope iASTScope = iASTCompletionNode.getCompletionScope();
            Assert.assertNotNull((Object)iASTScope);
            Assert.assertTrue((boolean)iASTScope.getClass().getName().endsWith(this.getExpectedScopeClassName()));
            IASTNode iASTNode = iASTCompletionNode.getCompletionContext();
            if (iASTNode == null) {
                Assert.assertTrue((boolean)this.getExpectedContextClassName().equals("null"));
            } else {
                Assert.assertTrue((boolean)iASTNode.getClass().getName().endsWith(this.getExpectedContextClassName()));
            }
            IASTCompletionNode.CompletionKind completionKind = iASTCompletionNode.getCompletionKind();
            Assert.assertTrue((completionKind == this.getExpectedKind() ? 1 : 0) != 0);
            String string = iASTCompletionNode.getCompletionPrefix();
            Assert.assertEquals((String)string, (String)this.getExpectedPrefix());
            Assert.assertEquals((String)iASTCompletionNode.getFunctionName(), (String)this.getFunctionOrConstructorName());
            String[] stringArray = this.getExpectedResultsValues();
            Assert.assertTrue((iCCompletionProposalArray.length >= stringArray.length ? 1 : 0) != 0);
            int n2 = 0;
            while (n2 < stringArray.length) {
                boolean bl = false;
                int n3 = 0;
                while (n3 < iCCompletionProposalArray.length) {
                    ICCompletionProposal iCCompletionProposal = iCCompletionProposalArray[n3];
                    String string2 = iCCompletionProposal.getDisplayString();
                    if (stringArray[n2].equals(string2)) {
                        bl = true;
                        break;
                    }
                    ++n3;
                }
                Assert.assertTrue((String)("Lookup failed for " + stringArray[n2]), (boolean)bl);
                ++n2;
            }
        }
        catch (CModelException cModelException) {}
    }

    public String getBuffer() {
        return this.buffer;
    }

    public Document getDocument() {
        return this.document;
    }

    public ITranslationUnit getTranslationUnit() {
        return this.tu;
    }
}

