/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.core.tests;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDIFunctionLocation;
import org.eclipse.cdt.debug.core.cdi.ICDISession;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.testplugin.CDebugHelper;
import org.eclipse.cdt.debug.testplugin.CProjectHelper;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;

public class DebugTests
extends TestCase {
    IWorkspace workspace = ResourcesPlugin.getWorkspace();
    IWorkspaceRoot root = this.workspace.getRoot();
    ICProject testProject;
    NullProgressMonitor monitor = new NullProgressMonitor();
    ICDISession session;
    static /* synthetic */ Class class$0;

    public DebugTests(String string) {
        super(string);
        if (this.workspace == null) {
            Assert.fail((String)"Workspace was not setup");
        }
        if (this.root == null) {
            Assert.fail((String)"Workspace root was not setup");
        }
    }

    protected void setUp() throws CoreException, InvocationTargetException, IOException {
        ResourcesPlugin.getWorkspace().getDescription().setAutoBuilding(false);
        Path path = new Path("resources/debugTest.zip");
        this.testProject = CProjectHelper.createCProjectWithImport("filetest", (IPath)path);
        if (this.testProject == null) {
            Assert.fail((String)"Unable to create project");
        }
        this.testProject.getProject().build(6, null);
    }

    protected void tearDown() throws CoreException, CDIException {
        if (this.session != null) {
            this.session.terminate();
            this.session = null;
        }
        CProjectHelper.delete(this.testProject);
    }

    public static TestSuite suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.debug.core.tests.DebugTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)DebugTests.suite());
    }

    public void testDebug() throws CoreException, MIException, IOException, CDIException {
        this.session = CDebugHelper.createSession("main", this.testProject);
        Assert.assertNotNull((Object)this.session);
        ICDITarget[] iCDITargetArray = this.session.getTargets();
        Assert.assertNotNull((Object)iCDITargetArray);
        Assert.assertTrue((iCDITargetArray.length > 0 ? 1 : 0) != 0);
        ICDITarget iCDITarget = iCDITargetArray[0];
        Assert.assertNotNull((Object)iCDITarget);
        ICDIFunctionLocation iCDIFunctionLocation = iCDITarget.createFunctionLocation(null, "func1");
        Assert.assertNotNull((Object)iCDIFunctionLocation);
        iCDITarget.setFunctionBreakpoint(0, iCDIFunctionLocation, null, false);
        iCDITarget.resume();
        this.session.terminate();
        this.session = null;
    }
}

