/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.testplugin;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.zip.ZipFile;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.ICDescriptorOperation;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.IArchive;
import org.eclipse.cdt.core.model.IArchiveContainer;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.IBinaryContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.debug.testplugin.CTestPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;
import org.eclipse.ui.wizards.datatransfer.ZipFileStructureProvider;

public class CProjectHelper {
    public static ICProject createCProjectWithImport(String string, IPath iPath) throws CoreException, InvocationTargetException, IOException {
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject iProject = iWorkspaceRoot.getProject(string);
        if (!iProject.exists()) {
            iProject.create(null);
        } else {
            iProject.refreshLocal(2, null);
        }
        if (!iProject.isOpen()) {
            iProject.open(null);
        }
        File file = CTestPlugin.getDefault().getFileInPlugin(iPath);
        CProjectHelper.importFilesFromZip(new ZipFile(file), iProject.getFullPath(), null);
        if (!iProject.hasNature("org.eclipse.cdt.core.cnature")) {
            CProjectHelper.addNatureToProject(iProject, "org.eclipse.cdt.core.cnature", null);
        }
        ICProject iCProject = CCorePlugin.getDefault().getCoreModel().create(iProject);
        ICDescriptorOperation iCDescriptorOperation = new ICDescriptorOperation(){

            public void execute(ICDescriptor iCDescriptor, IProgressMonitor iProgressMonitor) throws CoreException {
                iCDescriptor.remove("org.eclipse.cdt.core.BinaryParser");
                String string = System.getProperty("os.name");
                boolean bl = string.toLowerCase().indexOf("windows") != -1;
                iCDescriptor.create("org.eclipse.cdt.core.BinaryParser", bl ? "org.eclipse.cdt.core.PE" : "org.eclipse.cdt.core.ELF");
            }
        };
        CCorePlugin.getDefault().getCDescriptorManager().runDescriptorOperation(iProject, iCDescriptorOperation, null);
        return iCProject;
    }

    public static ICProject createCProject(String string) throws CoreException {
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject iProject = iWorkspaceRoot.getProject(string);
        if (!iProject.exists()) {
            iProject.create(null);
        } else {
            iProject.refreshLocal(2, null);
        }
        if (!iProject.isOpen()) {
            iProject.open(null);
        }
        if (!iProject.hasNature("org.eclipse.cdt.core.cnature")) {
            CProjectHelper.addNatureToProject(iProject, "org.eclipse.cdt.core.cnature", null);
        }
        ICProject iCProject = CCorePlugin.getDefault().getCoreModel().create(iProject);
        return iCProject;
    }

    public static void delete(ICProject iCProject) throws CoreException {
        iCProject.getProject().delete(true, true, null);
    }

    public static IArchive findArchive(ICProject iCProject, String string) throws CModelException {
        IArchiveContainer iArchiveContainer = iCProject.getArchiveContainer();
        IArchive[] iArchiveArray = iArchiveContainer.getArchives();
        if (iArchiveArray.length < 1) {
            return null;
        }
        int n = 0;
        while (n < iArchiveArray.length) {
            if (iArchiveArray[n].getElementName().equals(string)) {
                return iArchiveArray[n];
            }
            ++n;
        }
        return null;
    }

    public static IBinary findBinary(ICProject iCProject, String string) throws CModelException {
        IBinaryContainer iBinaryContainer = iCProject.getBinaryContainer();
        IBinary[] iBinaryArray = iBinaryContainer.getBinaries();
        if (iBinaryArray.length < 1) {
            return null;
        }
        int n = 0;
        while (n < iBinaryArray.length) {
            if (iBinaryArray[n].getElementName().equals(string)) {
                return iBinaryArray[n];
            }
            ++n;
        }
        return null;
    }

    public static IBinary findObject(ICProject iCProject, String string) throws CModelException {
        ICElement[] iCElementArray = iCProject.getChildren();
        if (iCElementArray.length < 1) {
            return null;
        }
        int n = 0;
        while (n < iCElementArray.length) {
            if (iCElementArray[n].getElementName().equals(string) && iCElementArray[n] instanceof IBinary) {
                return (IBinary)iCElementArray[n];
            }
            ++n;
        }
        return null;
    }

    public static ITranslationUnit findTranslationUnit(ICProject iCProject, String string) throws CModelException {
        ICElement[] iCElementArray = iCProject.getChildren();
        if (iCElementArray.length < 1) {
            return null;
        }
        int n = 0;
        while (n < iCElementArray.length) {
            if (iCElementArray[n].getElementName().equals(string) && iCElementArray[n] instanceof ITranslationUnit) {
                return (ITranslationUnit)iCElementArray[n];
            }
            ++n;
        }
        return null;
    }

    public static ICElement findElement(ICProject iCProject, String string) throws CModelException {
        ICElement[] iCElementArray = iCProject.getChildren();
        if (iCElementArray.length < 1) {
            return null;
        }
        int n = 0;
        while (n < iCElementArray.length) {
            if (iCElementArray[n].getElementName().equals(string)) {
                return iCElementArray[n];
            }
            ++n;
        }
        return null;
    }

    private static void addNatureToProject(IProject iProject, String string, IProgressMonitor iProgressMonitor) throws CoreException {
        IProjectDescription iProjectDescription = iProject.getDescription();
        String[] stringArray = iProjectDescription.getNatureIds();
        String[] stringArray2 = new String[stringArray.length + 1];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        stringArray2[stringArray.length] = string;
        iProjectDescription.setNatureIds(stringArray2);
        iProject.setDescription(iProjectDescription, iProgressMonitor);
    }

    private static void importFilesFromZip(ZipFile zipFile, IPath iPath, IProgressMonitor iProgressMonitor) throws InvocationTargetException {
        ZipFileStructureProvider zipFileStructureProvider = new ZipFileStructureProvider(zipFile);
        try {
            ImportOperation importOperation = new ImportOperation(iPath, (Object)zipFileStructureProvider.getRoot(), (IImportStructureProvider)zipFileStructureProvider, (IOverwriteQuery)new ImportOverwriteQuery());
            importOperation.run(iProgressMonitor);
        }
        catch (InterruptedException interruptedException) {}
    }

    private static class ImportOverwriteQuery
    implements IOverwriteQuery {
        ImportOverwriteQuery() {
        }

        public String queryOverwrite(String string) {
            return "ALL";
        }
    }
}

