/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.indexer.tests;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.security.MessageDigest;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.ICDescriptorOperation;
import org.eclipse.cdt.core.index.IIndexChangeListener;
import org.eclipse.cdt.core.index.IIndexDelta;
import org.eclipse.cdt.core.index.IndexChangeEvent;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.testplugin.CProjectHelper;
import org.eclipse.cdt.core.testplugin.CTestPlugin;
import org.eclipse.cdt.core.tests.FailingTest;
import org.eclipse.cdt.internal.core.index.IEntryResult;
import org.eclipse.cdt.internal.core.index.IIndex;
import org.eclipse.cdt.internal.core.index.IQueryResult;
import org.eclipse.cdt.internal.core.index.domsourceindexer.DOMSourceIndexer;
import org.eclipse.cdt.internal.core.index.domsourceindexer.DOMSourceIndexerRunner;
import org.eclipse.cdt.internal.core.search.indexing.IndexManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;

public class DOMSourceIndexerTests
extends TestCase
implements IIndexChangeListener {
    IFile file;
    IProject testProject;
    NullProgressMonitor monitor;
    IndexManager indexManager;
    DOMSourceIndexer sourceIndexer;
    boolean fileIndexed;
    static final String sourceIndexerID = "org.eclipse.cdt.core.originalsourceindexer";
    public static final int TIMEOUT = 50;
    static /* synthetic */ Class class$0;

    public DOMSourceIndexerTests(String string) {
        super(string);
    }

    public void resetIndexState() {
        this.fileIndexed = false;
    }

    public void resetIndexer(final String string) {
        if (this.testProject != null) {
            ICDescriptorOperation iCDescriptorOperation = new ICDescriptorOperation(){

                public void execute(ICDescriptor iCDescriptor, IProgressMonitor iProgressMonitor) throws CoreException {
                    iCDescriptor.remove("org.eclipse.cdt.core.CIndexer");
                    iCDescriptor.create("org.eclipse.cdt.core.CIndexer", string);
                }
            };
            try {
                CCorePlugin.getDefault().getCDescriptorManager().runDescriptorOperation(this.testProject, iCDescriptorOperation, (IProgressMonitor)new NullProgressMonitor());
                CCorePlugin.getDefault().getCoreModel().getIndexManager().indexerChangeNotification(this.testProject);
            }
            catch (CoreException coreException) {}
        }
    }

    public void waitForIndex(int n) throws Exception {
        int n2 = 0;
        while (!this.fileIndexed && n2 < n * 1000) {
            Thread.sleep(50L);
            n2 += 50;
        }
    }

    public static void main(String[] stringArray) {
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.monitor = new NullProgressMonitor();
        this.testProject = this.createProject("IndexerTestProject");
        IPath iPath = CCorePlugin.getDefault().getStateLocation();
        File file = new File(iPath.append("3915980774.index").toOSString());
        if (file.exists()) {
            file.delete();
        }
        if (this.testProject == null) {
            Assert.fail((String)"Unable to create project");
        }
        this.resetIndexer("org.eclipse.cdt.core.domsourceindexer");
        DOMSourceIndexerRunner.setSkipScannerInfoTest((boolean)true);
        this.indexManager = CCorePlugin.getDefault().getCoreModel().getIndexManager();
        this.sourceIndexer = (DOMSourceIndexer)this.indexManager.getIndexerForProject(this.testProject);
        this.sourceIndexer.addIndexChangeListener((IIndexChangeListener)this);
    }

    protected void tearDown() {
        try {
            super.tearDown();
            this.sourceIndexer.removeIndexChangeListener((IIndexChangeListener)this);
        }
        catch (Exception exception) {}
        if (this.testProject.exists()) {
            try {
                System.gc();
                System.runFinalization();
                this.testProject.delete(true, (IProgressMonitor)this.monitor);
            }
            catch (CoreException coreException) {
                Assert.fail((String)this.getMessage(coreException.getStatus()));
            }
        }
    }

    private String getMessage(IStatus iStatus) {
        StringBuffer stringBuffer = new StringBuffer("[");
        stringBuffer.append(iStatus.getMessage());
        if (iStatus.isMultiStatus()) {
            IStatus[] iStatusArray = iStatus.getChildren();
            int n = 0;
            while (n < iStatusArray.length) {
                stringBuffer.append(this.getMessage(iStatusArray[n]));
                ++n;
            }
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.core.indexer.tests.DOMSourceIndexerTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite testSuite = new TestSuite(clazz.getName());
        testSuite.addTest((Test)new DOMSourceIndexerTests("testAddNewFileToIndex"));
        testSuite.addTest((Test)new DOMSourceIndexerTests("testForwardDeclarations"));
        testSuite.addTest((Test)new DOMSourceIndexerTests("testIndexAll"));
        testSuite.addTest((Test)new FailingTest((Test)new DOMSourceIndexerTests("testIndexContents")));
        testSuite.addTest((Test)new DOMSourceIndexerTests("testMacros"));
        testSuite.addTest((Test)new FailingTest((Test)new DOMSourceIndexerTests("testRefs")));
        testSuite.addTest((Test)new DOMSourceIndexerTests("testExactDeclarations"));
        testSuite.addTest((Test)new FailingTest((Test)new DOMSourceIndexerTests("testRemoveFileFromIndex")));
        testSuite.addTest((Test)new DOMSourceIndexerTests("testRemoveProjectFromIndex"));
        testSuite.addTest((Test)new DOMSourceIndexerTests("testIndexShutdown"));
        return testSuite;
    }

    private IProject createProject(String string) throws CoreException {
        ICProject iCProject = CProjectHelper.createCCProject(string, "bin");
        return iCProject.getProject();
    }

    private IFile importFile(String string, String string2) throws Exception {
        this.resetIndexState();
        this.file = this.testProject.getProject().getFile(string);
        this.monitor = new NullProgressMonitor();
        if (!this.file.exists()) {
            this.file.create((InputStream)new FileInputStream(CTestPlugin.getDefault().getFileInPlugin((IPath)new Path(string2))), false, (IProgressMonitor)this.monitor);
        }
        this.waitForIndex(20);
        return this.file;
    }

    public void testIndexAll() throws Exception {
        this.importFile("mail.cpp", "resources/indexer/mail.cpp");
        IIndex iIndex = this.sourceIndexer.getIndex(this.testProject.getFullPath(), true, true);
        Assert.assertTrue((String)"Index exists for project", (iIndex != null ? 1 : 0) != 0);
        IQueryResult[] iQueryResultArray = iIndex.getPrefix(1, 0, 3);
        IEntryResult[] iEntryResultArray = iIndex.getEntries(1, 0, 3);
        IEntryResult[] iEntryResultArray2 = iIndex.getEntries(1, 0, 1);
        Assert.assertTrue((String)"Query Results exist", (iQueryResultArray != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Entry Results exist", (iEntryResultArray != null ? 1 : 0) != 0);
        String[] stringArray = new String[]{"IndexedFile(1: /IndexerTestProject/mail.cpp)"};
        String[] stringArray2 = new String[]{"EntryResult: word=typeDefn/C/Mail, refs={ 1 }, offsets={ [ 294] }", "EntryResult: word=typeDefn/C/Unknown, refs={ 1 }, offsets={ [ 2738] }", "EntryResult: word=typeDefn/C/container, refs={ 1 }, offsets={ [ 21084] }", "EntryResult: word=typeDefn/C/first_class, refs={ 1 }, offsets={ [ 2506] }", "EntryResult: word=typeDefn/C/postcard, refs={ 1 }, offsets={ [ 2298] }"};
        String[] stringArray3 = new String[]{"EntryResult: word=typeDecl/D/Mail, refs={ 1 }, offsets={ [ 294] }", "EntryResult: word=typeDecl/D/first_class, refs={ 1 }, offsets={ [ 2506] }", "EntryResult: word=typeDecl/D/postcard, refs={ 1 }, offsets={ [ 2298] }"};
        String[] stringArray4 = new String[]{"Mail", "Unknown", "container", "first_class", "postcard"};
        int[] nArray = new int[]{1};
        int[] nArray2 = new int[]{1, 1, 1, 1, 1};
        int[] nArray3 = new int[]{3};
        if (iQueryResultArray.length != stringArray.length) {
            Assert.fail((String)"Query Result length different from model");
        }
        if (iEntryResultArray.length != stringArray2.length) {
            Assert.fail((String)"Entry Result length different from model");
        }
        if (iEntryResultArray2.length != stringArray3.length) {
            Assert.fail((String)"Entry Result length different from model");
        }
        int n = 0;
        while (n < iQueryResultArray.length) {
            Assert.assertEquals((String)stringArray[n], (String)iQueryResultArray[n].toString());
            ++n;
        }
        n = 0;
        while (n < iEntryResultArray.length) {
            Assert.assertEquals((String)stringArray4[n], (String)iEntryResultArray[n].getName());
            Assert.assertEquals((int)nArray[0], (int)iEntryResultArray[n].getMetaKind());
            Assert.assertEquals((int)nArray2[n], (int)iEntryResultArray[n].getKind());
            Assert.assertEquals((int)nArray3[0], (int)iEntryResultArray[n].getRefKind());
            ++n;
        }
    }

    public void testAddNewFileToIndex() throws Exception {
        this.importFile("mail.cpp", "resources/indexer/mail.cpp");
        IPath iPath = this.testProject.getFullPath();
        IIndex iIndex = this.sourceIndexer.getIndex(iPath, true, true);
        Assert.assertTrue((String)"Index exists for project", (iIndex != null ? 1 : 0) != 0);
        this.importFile("DocumentManager.h", "resources/indexer/DocumentManager.h");
        this.importFile("DocumentManager.cpp", "resources/indexer/DocumentManager.cpp");
        iIndex = this.sourceIndexer.getIndex(iPath, true, true);
        String string = "CDocumentManager";
        String[] stringArray = new String[]{"CDocumentManager"};
        int[] nArray = new int[]{1};
        int[] nArray2 = new int[]{1};
        int[] nArray3 = new int[]{3};
        IEntryResult[] iEntryResultArray = iIndex.getEntries(1, 1, 3, string);
        iIndex.getEntries(1, 0, 3);
        Assert.assertTrue((String)"Entry Result exists", (iEntryResultArray != null ? 1 : 0) != 0);
        if (iEntryResultArray.length != stringArray.length) {
            Assert.fail((String)"Entry Result length different from model");
        }
        int n = 0;
        while (n < iEntryResultArray.length) {
            Assert.assertEquals((String)stringArray[n], (String)iEntryResultArray[n].getName());
            Assert.assertEquals((int)nArray[n], (int)iEntryResultArray[n].getMetaKind());
            Assert.assertEquals((int)nArray2[n], (int)iEntryResultArray[n].getKind());
            Assert.assertEquals((int)nArray3[n], (int)iEntryResultArray[n].getRefKind());
            ++n;
        }
    }

    public void testRemoveProjectFromIndex() throws Exception {
        this.importFile("mail.cpp", "resources/indexer/mail.cpp");
        IPath iPath = this.testProject.getFullPath();
        IIndex iIndex = this.sourceIndexer.getIndex(iPath, true, true);
        Assert.assertTrue((String)"Index exists for project", (iIndex != null ? 1 : 0) != 0);
        this.safeDelete(this.testProject);
        iIndex = this.sourceIndexer.getIndex(iPath, true, true);
        Assert.assertTrue((String)"Index deleted", (iIndex == null ? 1 : 0) != 0);
    }

    private void safeDelete(IProject iProject) throws InterruptedException, CoreException {
        System.gc();
        System.runFinalization();
        try {
            iProject.delete(true, (IProgressMonitor)this.monitor);
        }
        catch (CoreException coreException) {
            Thread.sleep(5000L);
            iProject.delete(true, (IProgressMonitor)this.monitor);
        }
    }

    public void testRemoveFileFromIndex() throws Exception {
        this.importFile("mail.cpp", "resources/indexer/mail.cpp");
        IPath iPath = this.testProject.getFullPath();
        IIndex iIndex = this.sourceIndexer.getIndex(iPath, true, true);
        Assert.assertTrue((String)"Index exists for project", (iIndex != null ? 1 : 0) != 0);
        this.importFile("DocumentManager.h", "resources/indexer/DocumentManager.h");
        this.importFile("DocumentManager.cpp", "resources/indexer/DocumentManager.cpp");
        iIndex = this.sourceIndexer.getIndex(iPath, true, true);
        IEntryResult[] iEntryResultArray = iIndex.getEntries(1, 0, 3);
        iIndex.getEntries(1, 0, 1);
        Assert.assertTrue((String)"Entry result found for typdeDefn/", (iEntryResultArray != null ? 1 : 0) != 0);
        String[] stringArray = new String[]{"EntryResult: word=typeDecl/C/CDocumentManager, refs={ 2 }, offsets={ [ 2127] }", "EntryResult: word=typeDecl/C/Mail, refs={ 3 }, offsets={ [ 294] }", "EntryResult: word=typeDecl/C/Unknown, refs={ 3 }, offsets={ [ 2738] }", "EntryResult: word=typeDecl/C/container, refs={ 3 }, offsets={ [ 21084] }", "EntryResult: word=typeDecl/C/first_class, refs={ 3 }, offsets={ [ 2506] }", "EntryResult: word=typeDecl/C/postcard, refs={ 3 }, offsets={ [ 2298] }", "EntryResult: word=typeDecl/D/Mail, refs={ 3 }, offsets={ [ 294] }", "EntryResult: word=typeDecl/D/first_class, refs={ 3 }, offsets={ [ 2506] }", "EntryResult: word=typeDecl/D/postcard, refs={ 3 }, offsets={ [ 2298] }", "EntryResult: word=typeDecl/V/PO_Box, refs={ 3 }, offsets={ [ 21371] }", "EntryResult: word=typeDecl/V/index, refs={ 3 }, offsets={ [ 21303, 21846] }", "EntryResult: word=typeDecl/V/mail, refs={ 3 }, offsets={ [ 21336, 21912] }", "EntryResult: word=typeDecl/V/size, refs={ 3 }, offsets={ [ 21927] }", "EntryResult: word=typeDecl/V/temp, refs={ 3 }, offsets={ [ 21964] }", "EntryResult: word=typeDecl/V/x, refs={ 3 }, offsets={ [ 21201, 21526] }"};
        String[] stringArray2 = new String[]{"CDocumentManager", "Mail", "Unknown", "container", "first_class", "postcard", "PO_Box", "size", "temp", "x"};
        int[] nArray = new int[]{1};
        int[] nArray2 = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 9, 9};
        int[] nArray3 = new int[]{3};
        if (iEntryResultArray.length != stringArray2.length) {
            Assert.fail((String)"Entry Result length different from model");
        }
        int n = 0;
        while (n < iEntryResultArray.length) {
            Assert.assertEquals((String)stringArray2[n], (String)iEntryResultArray[n].getName());
            Assert.assertEquals((int)nArray[0], (int)iEntryResultArray[n].getMetaKind());
            Assert.assertEquals((int)nArray2[n], (int)iEntryResultArray[n].getKind());
            Assert.assertEquals((int)nArray3[0], (int)iEntryResultArray[n].getRefKind());
            ++n;
        }
        IResource iResource = this.testProject.findMember("mail.cpp");
        System.gc();
        System.runFinalization();
        this.resetIndexState();
        iResource.delete(true, (IProgressMonitor)this.monitor);
        this.waitForIndex(10);
        iIndex = this.sourceIndexer.getIndex(iPath, true, true);
        iEntryResultArray = iIndex.getEntries(1, 0, 3);
        Assert.assertTrue((String)"Entry exists", (iEntryResultArray != null ? 1 : 0) != 0);
        (new String[1])[0] = "EntryResult: word=typeDecl/C/CDocumentManager, refs={ 2 }, offsets={ [ 2127] }";
        String[] stringArray3 = new String[]{"CDocumentManager"};
        int[] nArray4 = new int[]{1};
        int[] nArray5 = new int[]{1};
        int[] nArray6 = new int[]{3};
        if (iEntryResultArray.length != stringArray3.length) {
            Assert.fail((String)"Entry Result length different from model");
        }
        int n2 = 0;
        while (n2 < iEntryResultArray.length) {
            Assert.assertEquals((String)stringArray3[n2], (String)iEntryResultArray[n2].getName());
            Assert.assertEquals((int)nArray4[0], (int)iEntryResultArray[n2].getMetaKind());
            Assert.assertEquals((int)nArray5[0], (int)iEntryResultArray[n2].getKind());
            Assert.assertEquals((int)nArray6[0], (int)iEntryResultArray[n2].getRefKind());
            ++n2;
        }
    }

    public void testIndexContents() throws Exception {
        this.importFile("extramail.cpp", "resources/indexer/extramail.cpp");
        IPath iPath = this.testProject.getFullPath();
        IIndex iIndex = this.sourceIndexer.getIndex(iPath, true, true);
        Assert.assertTrue((String)"Index exists for project", (iIndex != null ? 1 : 0) != 0);
        IEntryResult[] iEntryResultArray = iIndex.getEntries(1, 0, 2);
        Assert.assertTrue((String)"Type Ref Results exist", (iEntryResultArray != null ? 1 : 0) != 0);
        String[] stringArray = new String[]{"Mail/Y/X/Z", "first_class/Y/X/Z", "postcard/Y/X/Z", "test/Y/X/Z", "int32", "index", "mail"};
        String[] stringArray2 = new String[]{"Mail/Y/X/Z", "Unknown/Y/X/Z", "container/Y/X/Z", "first_class/Y/X/Z", "postcard/Y/X/Z", "PO_Box", "size", "temp", "x", "x/Z"};
        int[] nArray = new int[]{1};
        int[] nArray2 = new int[]{1, 1, 1, 1, 1, 9, 9, 9, 9, 9};
        int[] nArray3 = new int[]{6, 6, 6, 4, 5, 9, 9};
        IEntryResult[] iEntryResultArray2 = iIndex.getEntries(1, 0, 1);
        IEntryResult[] iEntryResultArray3 = iIndex.getEntries(1, 0, 3);
        Assert.assertTrue((String)"Type Decl Results exist", (iEntryResultArray2 != null ? 1 : 0) != 0);
        if (iEntryResultArray3.length != stringArray2.length) {
            Assert.fail((String)"Entry Result length different from model for typeDefn");
        }
        int n = 0;
        while (n < iEntryResultArray2.length) {
            Assert.assertEquals((String)stringArray2[n], (String)iEntryResultArray3[n].getName());
            Assert.assertEquals((int)nArray[0], (int)iEntryResultArray3[n].getMetaKind());
            Assert.assertEquals((int)nArray2[n], (int)iEntryResultArray3[n].getKind());
            Assert.assertEquals((int)3, (int)iEntryResultArray3[n].getRefKind());
            ++n;
        }
        String[] stringArray3 = new String[]{"int32"};
        int[] nArray4 = new int[]{1};
        int[] nArray5 = new int[]{5};
        int[] nArray6 = new int[]{1};
        IEntryResult[] iEntryResultArray4 = iIndex.getEntries(1, 5, 1);
        Assert.assertTrue((String)"Type Def Results exist", (iEntryResultArray4 != null ? 1 : 0) != 0);
        if (iEntryResultArray4.length != stringArray3.length) {
            Assert.fail((String)"Entry Result length different from model for typeDef");
        }
        int n2 = 0;
        while (n2 < iEntryResultArray4.length) {
            Assert.assertEquals((String)stringArray3[n2], (String)iEntryResultArray4[n2].getName());
            Assert.assertEquals((int)nArray4[n2], (int)iEntryResultArray4[n2].getMetaKind());
            Assert.assertEquals((int)nArray5[n2], (int)iEntryResultArray4[n2].getKind());
            Assert.assertEquals((int)nArray6[n2], (int)iEntryResultArray4[n2].getRefKind());
            ++n2;
        }
        String[] stringArray4 = new String[]{"X/Z", "Y/X/Z", "Z"};
        int[] nArray7 = new int[]{6};
        int[] nArray8 = new int[]{3};
        IEntryResult[] iEntryResultArray5 = iIndex.getEntries(6, 0, 3);
        Assert.assertTrue((String)"Namespace Results exist", (iEntryResultArray5 != null ? 1 : 0) != 0);
        if (iEntryResultArray5.length != stringArray4.length) {
            Assert.fail((String)"Entry Result length different from model for namespace");
        }
        int n3 = 0;
        while (n3 < iEntryResultArray5.length) {
            Assert.assertEquals((String)stringArray4[n3], (String)iEntryResultArray5[n3].getName());
            Assert.assertEquals((int)nArray7[0], (int)iEntryResultArray5[n3].getMetaKind());
            Assert.assertEquals((int)nArray8[0], (int)iEntryResultArray5[n3].getRefKind());
            ++n3;
        }
        String[] stringArray5 = new String[]{"array/container/Y/X/Z", "index/container/Y/X/Z", "postage/Mail/Y/X/Z", "sz/container/Y/X/Z", "type/Mail/Y/X/Z"};
        int[] nArray9 = new int[]{4};
        int[] nArray10 = new int[]{3};
        IEntryResult[] iEntryResultArray6 = iIndex.getEntries(4, 0, 3);
        Assert.assertTrue((String)"Field Results exist", (iEntryResultArray6 != null ? 1 : 0) != 0);
        if (iEntryResultArray6.length != stringArray5.length) {
            Assert.fail((String)"Entry Result length different from model for fieldDecl");
        }
        int n4 = 0;
        while (n4 < iEntryResultArray6.length) {
            Assert.assertEquals((String)stringArray5[n4], (String)iEntryResultArray6[n4].getName());
            Assert.assertEquals((int)nArray9[0], (int)iEntryResultArray6[n4].getMetaKind());
            Assert.assertEquals((int)nArray10[0], (int)iEntryResultArray6[n4].getRefKind());
            ++n4;
        }
        String[] stringArray6 = new String[]{"bye/Y/X/Z", "cool/Y/X/Z", "hi/Y/X/Z", "why/Y/X/Z"};
        int[] nArray11 = new int[]{7};
        int[] nArray12 = new int[]{1};
        IEntryResult[] iEntryResultArray7 = iIndex.getEntries(7, 0, 1);
        Assert.assertTrue((String)"Enumerator Results exist", (iEntryResultArray7 != null ? 1 : 0) != 0);
        if (iEntryResultArray7.length != stringArray6.length) {
            Assert.fail((String)"Entry Result length different from model for enumtorDecl");
        }
        int n5 = 0;
        while (n5 < iEntryResultArray7.length) {
            Assert.assertEquals((String)stringArray6[n5], (String)iEntryResultArray7[n5].getName());
            Assert.assertEquals((int)nArray11[0], (int)iEntryResultArray7[n5].getMetaKind());
            Assert.assertEquals((int)nArray12[0], (int)iEntryResultArray7[n5].getRefKind());
            ++n5;
        }
        String[] stringArray7 = new String[]{"doSomething"};
        int[] nArray13 = new int[]{2};
        int[] nArray14 = new int[]{1};
        IEntryResult[] iEntryResultArray8 = iIndex.getEntries(2, 0, 1);
        if (iEntryResultArray8.length != stringArray7.length) {
            Assert.fail((String)"Entry Result length different from model for functionDecl");
        }
        int n6 = 0;
        while (n6 < iEntryResultArray8.length) {
            Assert.assertEquals((String)stringArray7[n6], (String)iEntryResultArray8[n6].getName());
            Assert.assertEquals((int)nArray13[0], (int)iEntryResultArray8[n6].getMetaKind());
            Assert.assertEquals((int)nArray14[0], (int)iEntryResultArray8[n6].getRefKind());
            ++n6;
        }
        String[] stringArray8 = new String[]{"Mail/Mail/Y/X/Z", "Unknown/Unknown/Y/X/Z", "container/container/Y/X/Z", "first_class/first_class/Y/X/Z", "print/Unknown/Y/X/Z", "print/first_class/Y/X/Z", "print/postcard/Y/X/Z", "size/container/Y/X/Z", "~container/container/Y/X/Z"};
        (new int[1])[0] = 3;
        (new int[1])[0] = 3;
        String[] stringArray9 = new String[]{"operator =/container/Y/X/Z", "operator []/container/Y/X/Z", "print/Mail/Y/X/Z"};
        int[] nArray15 = new int[]{3};
        int[] nArray16 = new int[]{1};
        IEntryResult[] iEntryResultArray9 = iIndex.getEntries(3, 0, 1);
        Assert.assertTrue((String)"Entry exists", (iEntryResultArray9 != null ? 1 : 0) != 0);
        if (iEntryResultArray9.length != stringArray9.length) {
            Assert.fail((String)"Entry Result length different from model for functionDecl");
        }
        int n7 = 0;
        while (n7 < iEntryResultArray9.length) {
            Assert.assertEquals((String)stringArray9[n7], (String)iEntryResultArray9[n7].getName());
            Assert.assertEquals((int)nArray15[0], (int)iEntryResultArray9[n7].getMetaKind());
            Assert.assertEquals((int)nArray16[0], (int)iEntryResultArray9[n7].getRefKind());
            ++n7;
        }
    }

    public void testRefs() throws Exception {
        this.importFile("reftest.cpp", "resources/indexer/reftest.cpp");
        IPath iPath = this.testProject.getFullPath();
        IIndex iIndex = this.sourceIndexer.getIndex(iPath, true, true);
        Assert.assertTrue((String)"Index exists for project", (iIndex != null ? 1 : 0) != 0);
        String[] stringArray = new String[]{"C/B/A", "ForwardA/A", "e1/B/A", "x/B/A"};
        int[] nArray = new int[]{1};
        int[] nArray2 = new int[]{1, 1, 4, 9};
        int[] nArray3 = new int[]{2};
        IEntryResult[] iEntryResultArray = iIndex.getEntries(1, 0, 2);
        Assert.assertTrue((String)"Entry exists", (iEntryResultArray != null ? 1 : 0) != 0);
        if (iEntryResultArray.length != stringArray.length) {
            Assert.fail((String)"Entry Result length different from model for typeRef");
        }
        int n = 0;
        while (n < iEntryResultArray.length) {
            Assert.assertEquals((String)stringArray[n], (String)iEntryResultArray[n].getName());
            Assert.assertEquals((int)nArray[0], (int)iEntryResultArray[n].getMetaKind());
            Assert.assertEquals((int)nArray2[n], (int)iEntryResultArray[n].getKind());
            Assert.assertEquals((int)nArray3[0], (int)iEntryResultArray[n].getRefKind());
            ++n;
        }
        String[] stringArray2 = new String[]{"something/A"};
        int[] nArray4 = new int[]{2};
        int[] nArray5 = new int[]{2};
        IEntryResult[] iEntryResultArray2 = iIndex.getEntries(2, 0, 2);
        Assert.assertTrue((String)"Entry exists", (iEntryResultArray2 != null ? 1 : 0) != 0);
        if (iEntryResultArray2.length != stringArray2.length) {
            Assert.fail((String)"Entry Result length different from model for funcRef");
        }
        int n2 = 0;
        while (n2 < iEntryResultArray2.length) {
            Assert.assertEquals((String)stringArray2[n2], (String)iEntryResultArray2[n2].getName());
            Assert.assertEquals((int)nArray4[0], (int)iEntryResultArray2[n2].getMetaKind());
            Assert.assertEquals((int)nArray5[0], (int)iEntryResultArray2[n2].getRefKind());
            ++n2;
        }
        String[] stringArray3 = new String[]{"EntryResult: word=namespaceRef/A, refs={ 1 }, offsets={ [ 2228, 2241, 2257, 2273, 2292, 2313, 2334] }", "EntryResult: word=namespaceRef/B/A, refs={ 1 }, offsets={ [ 2231, 2244, 2260, 2276, 2295, 2337] }"};
        String[] stringArray4 = new String[]{"A", "B/A"};
        int[] nArray6 = new int[]{6};
        int[] nArray7 = new int[]{2};
        IEntryResult[] iEntryResultArray3 = iIndex.getEntries(6, 0, 2);
        Assert.assertTrue((String)"Entry exists", (iEntryResultArray3 != null ? 1 : 0) != 0);
        if (iEntryResultArray3.length != stringArray4.length) {
            Assert.fail((String)"Entry Result length different from model for namespaceRef");
        }
        int n3 = 0;
        while (n3 < iEntryResultArray3.length) {
            Assert.assertEquals((String)stringArray4[n3], (String)iEntryResultArray3[n3].getName());
            Assert.assertEquals((int)nArray6[0], (int)iEntryResultArray3[n3].getMetaKind());
            Assert.assertEquals((int)nArray7[0], (int)iEntryResultArray3[n3].getRefKind());
            ++n3;
        }
        String[] stringArray5 = new String[]{"y/C/B/A"};
        int[] nArray8 = new int[]{4};
        int[] nArray9 = new int[]{2};
        IEntryResult[] iEntryResultArray4 = iIndex.getEntries(4, 0, 2);
        Assert.assertTrue((String)"Entry exists", (iEntryResultArray4 != null ? 1 : 0) != 0);
        if (iEntryResultArray4.length != stringArray5.length) {
            Assert.fail((String)"Entry Result length different from model for fieldRef");
        }
        int n4 = 0;
        while (n4 < iEntryResultArray4.length) {
            Assert.assertEquals((String)stringArray5[n4], (String)iEntryResultArray4[n4].getName());
            Assert.assertEquals((int)nArray8[0], (int)iEntryResultArray4[n4].getMetaKind());
            Assert.assertEquals((int)nArray9[0], (int)iEntryResultArray4[n4].getRefKind());
            ++n4;
        }
        String[] stringArray6 = new String[]{"bar/C/B/A"};
        int[] nArray10 = new int[]{3};
        int[] nArray11 = new int[]{2};
        IEntryResult[] iEntryResultArray5 = iIndex.getEntries(3, 0, 2);
        Assert.assertTrue((String)"Entry exists", (iEntryResultArray5 != null ? 1 : 0) != 0);
        if (iEntryResultArray5.length != stringArray6.length) {
            Assert.fail((String)"Entry Result length different from model for methodRef");
        }
        int n5 = 0;
        while (n5 < iEntryResultArray5.length) {
            Assert.assertEquals((String)stringArray6[n5], (String)iEntryResultArray5[n5].getName());
            Assert.assertEquals((int)nArray10[0], (int)iEntryResultArray5[n5].getMetaKind());
            Assert.assertEquals((int)nArray11[0], (int)iEntryResultArray5[n5].getRefKind());
            ++n5;
        }
    }

    public void testExactDeclarations() throws Exception {
        this.importFile("a.h", "resources/dependency/a.h");
        IPath iPath = this.testProject.getFullPath();
        IIndex iIndex = this.sourceIndexer.getIndex(iPath, true, true);
        Assert.assertTrue((String)"Index exists for project", (iIndex != null ? 1 : 0) != 0);
        this.importFile("DepTest3.h", "resources/dependency/DepTest3.h");
        this.importFile("DepTest3.cpp", "resources/dependency/DepTest3.cpp");
        IEntryResult[] iEntryResultArray = iIndex.getEntries(1, 1, 3);
        IQueryResult[] iQueryResultArray = iIndex.getPrefix(1, 1, 3);
        Assert.assertTrue((String)"Expected 2 files indexed", (iQueryResultArray.length == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Checking DepTest3.h location", (boolean)iQueryResultArray[0].getPath().equals("/IndexerTestProject/DepTest3.h"));
        Assert.assertTrue((String)"Checking a.h location", (boolean)iQueryResultArray[1].getPath().equals("/IndexerTestProject/a.h"));
        Assert.assertTrue((String)"Expect 2 class declaration entries", (iEntryResultArray.length == 2 ? 1 : 0) != 0);
        int[] nArray = new int[]{2};
        int[] nArray2 = iEntryResultArray[0].getFileReferences();
        Assert.assertTrue((String)"Check DepTest3 File Refs number", (nArray2.length == 1 ? 1 : 0) != 0);
        int n = 0;
        while (n < nArray2.length) {
            Assert.assertTrue((String)"Verify DepTest3 File Ref", (nArray2[n] == nArray[n] ? 1 : 0) != 0);
            ++n;
        }
        int[] nArray3 = new int[]{3};
        nArray2 = iEntryResultArray[1].getFileReferences();
        Assert.assertTrue((String)"Check a.h File Refs number", (nArray2.length == 1 ? 1 : 0) != 0);
        int n2 = 0;
        while (n2 < nArray2.length) {
            Assert.assertTrue((String)"Verify a.h File Ref", (nArray2[n2] == nArray3[n2] ? 1 : 0) != 0);
            ++n2;
        }
    }

    public void testMD5() throws Exception {
        this.importFile("extramail.cpp", "resources/indexer/extramail.cpp");
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        String string = this.testProject.getFile("extramail.cpp").getLocation().toOSString();
        System.currentTimeMillis();
        FileInputStream fileInputStream = new FileInputStream(string);
        FileChannel fileChannel = fileInputStream.getChannel();
        ByteBuffer byteBuffer = ByteBuffer.allocate((int)fileChannel.size());
        fileChannel.read(byteBuffer);
        byteBuffer.rewind();
        messageDigest.update(byteBuffer.array());
        messageDigest.digest();
    }

    public void testMacros() throws Exception {
        this.importFile("extramail.cpp", "resources/indexer/extramail.cpp");
        IPath iPath = this.testProject.getFullPath();
        IIndex iIndex = this.sourceIndexer.getIndex(iPath, true, true);
        Assert.assertTrue((String)"Index exists for project", (iIndex != null ? 1 : 0) != 0);
        IEntryResult[] iEntryResultArray = iIndex.getEntries(5, 0, 1);
        Assert.assertTrue((String)"Entry exists", (iEntryResultArray != null ? 1 : 0) != 0);
        String[] stringArray = new String[]{"CASE", "MAX", "PRINT"};
        int[] nArray = new int[]{5};
        int[] nArray2 = new int[]{1};
        if (iEntryResultArray.length != stringArray.length) {
            Assert.fail((String)"Entry Result length different from model for macros");
        }
        int n = 0;
        while (n < iEntryResultArray.length) {
            Assert.assertEquals((String)stringArray[n], (String)iEntryResultArray[n].getName());
            Assert.assertEquals((int)nArray[0], (int)iEntryResultArray[n].getMetaKind());
            Assert.assertEquals((int)nArray2[0], (int)iEntryResultArray[n].getRefKind());
            ++n;
        }
    }

    public void testIndexShutdown() throws Exception {
        this.importFile("reftest.cpp", "resources/indexer/reftest.cpp");
        IPath iPath = this.testProject.getFullPath();
        IIndex iIndex = this.sourceIndexer.getIndex(iPath, true, true);
        Assert.assertTrue((String)"Index exists for project", (iIndex != null ? 1 : 0) != 0);
        String string = CCorePlugin.getDefault().getStateLocation().append("badIndex.index").toOSString();
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(string);
            fileWriter.flush();
            fileWriter.close();
        }
        catch (IOException iOException) {}
        File file = new File(CCorePlugin.getDefault().getStateLocation().toOSString());
        this.indexManager.shutdown();
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            int n = 0;
            int n2 = fileArray.length;
            while (n < n2) {
                if (fileArray[n].getName().equals("badIndex.index")) {
                    Assert.fail((String)"Shutdown did not delete .index file");
                }
                ++n;
            }
        }
    }

    public void testForwardDeclarations() throws Exception {
        this.importFile("reftest.cpp", "resources/indexer/reftest.cpp");
        IPath iPath = this.testProject.getFullPath();
        IIndex iIndex = this.sourceIndexer.getIndex(iPath, true, true);
        Assert.assertTrue((String)"Index exists for project", (iIndex != null ? 1 : 0) != 0);
        IEntryResult[] iEntryResultArray = iIndex.getEntries(1, 1, 1, "ForwardA/A");
        Assert.assertTrue((String)"Entry exists", (iEntryResultArray != null ? 1 : 0) != 0);
        String[] stringArray = new String[]{"EntryResult: word=typeDecl/G/ForwardA/A, refs={ 1 }, offsets={ [ 225] }"};
        String[] stringArray2 = new String[]{"ForwardA/A"};
        int[] nArray = new int[]{1};
        int[] nArray2 = new int[]{1};
        int[] nArray3 = new int[]{1};
        if (iEntryResultArray.length != stringArray.length) {
            Assert.fail((String)"Entry Result length different from model for forward declarations");
        }
        int n = 0;
        while (n < iEntryResultArray.length) {
            Assert.assertEquals((String)stringArray2[n], (String)iEntryResultArray[n].getName());
            Assert.assertEquals((int)nArray[n], (int)iEntryResultArray[n].getMetaKind());
            Assert.assertEquals((int)nArray2[n], (int)iEntryResultArray[n].getKind());
            Assert.assertEquals((int)nArray3[n], (int)iEntryResultArray[n].getRefKind());
            ++n;
        }
        IEntryResult[] iEntryResultArray2 = iIndex.getEntries(1, 1, 2, "ForwardA/A");
        Assert.assertTrue((String)"Entry exists", (iEntryResultArray2 != null ? 1 : 0) != 0);
        String[] stringArray3 = new String[]{"EntryResult: word=typeRef/G/ForwardA/A, refs={ 1 }, offsets={ [ 237] }"};
        String[] stringArray4 = new String[]{"ForwardA/A"};
        int[] nArray4 = new int[]{1};
        int[] nArray5 = new int[]{1};
        int[] nArray6 = new int[]{2};
        if (iEntryResultArray2.length != stringArray3.length) {
            Assert.fail((String)"Entry Result length different from model for forward declarations refs");
        }
        int n2 = 0;
        while (n2 < iEntryResultArray2.length) {
            Assert.assertEquals((String)stringArray4[n2], (String)iEntryResultArray2[n2].getName());
            Assert.assertEquals((int)nArray4[n2], (int)iEntryResultArray2[n2].getMetaKind());
            Assert.assertEquals((int)nArray5[n2], (int)iEntryResultArray2[n2].getKind());
            Assert.assertEquals((int)nArray6[n2], (int)iEntryResultArray2[n2].getRefKind());
            ++n2;
        }
    }

    public void indexChanged(IndexChangeEvent indexChangeEvent) {
        IIndexDelta iIndexDelta = indexChangeEvent.getDelta();
        if (iIndexDelta.getDeltaType() == IIndexDelta.MERGE_DELTA) {
            this.fileIndexed = true;
        }
    }
}

