/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.internal.errorparsers.tests;

import java.io.StringBufferInputStream;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.cdt.core.internal.errorparsers.tests.GenericErrorParserTests;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;

public class GCCErrorParserTests
extends GenericErrorParserTests {
    public static final String GCC_ERROR_PARSER_ID = "org.eclipse.cdt.core.GCCErrorParser";
    public static final String[] GCC_ERROR_STREAM1 = new String[]{"qcc -c -I/qnx630/target/qnx6/usr/include -I/qnx630/target/qnx6/usr/include/photon -V3.3.1,gcc_ntox86 -w5 -O2   -I. ../abmain.c abmain.o", "In file included from ../globals.h:9,", "                 from ../abmain.c:36:", "../_combolist.h:34:24: warning: no newline at end of file"};
    public static final int GCC_ERROR_STREAM1_WARNINGS = 1;
    public static final int GCC_ERROR_STREAM1_ERRORS = 0;
    public static final String[] GCC_ERROR_STREAM1_FILENAMES = new String[]{"_combolist.h"};
    public static final String[] GCC_ERROR_STREAM2 = new String[]{"C:/QNX630/workspace/System/inc/RPNEvaluator.hpp:234: warning: `", "\t   RPNEvaluator<NumericType>::OperandConstant' is implicitly a typename", "C:/QNX630/workspace/System/inc/RPNEvaluator.hpp:234: warning: implicit typename", "\t   is deprecated, please see the documentation for details"};
    public static final int GCC_ERROR_STREAM2_WARNINGS = 2;
    public static final int GCC_ERROR_STREAM2_ERRORS = 0;
    public static final String[] GCC_ERROR_STREAM2_FILENAMES = new String[]{"RPNEvaluator.hpp"};
    public static final String[] GCC_ERROR_STREAM2_DESCRIPTIONS = new String[]{"please see the documentation"};
    public static final String[] GCC_ERROR_STREAM3 = new String[]{"C:/QNX630/workspace/System/inc/RPNEvaluator.hpp:370: error: ISO C++ says that `", "   char& String::operator[](unsigned int)' and `operator[]' are ambiguous even ", "   though the worst conversion for the former is better than the worst ", "   conversion for the latter"};
    public static final int GCC_ERROR_STREAM3_WARNINGS = 0;
    public static final int GCC_ERROR_STREAM3_ERRORS = 1;
    public static final String[] GCC_ERROR_STREAM3_FILENAMES = new String[]{"RPNEvaluator.hpp"};
    public static final String[] GCC_ERROR_STREAM3_DESCRIPTIONS = new String[]{"ISO C++", "are ambiguous", "worst conversion", "conversion for the latter"};
    public static final String[] GCC_ERROR_STREAM4 = new String[]{"C:/QNX630/workspace/System/inc/RPNEvaluator.hpp: In member function `", "   NumericType RPNEvaluator<NumericType>::evaluate(const char*) [with ", "   NumericType = int8]':", "C:/QNX630/workspace/System/src/CommonScriptClasses.cpp:609:   instantiated from here", "C:/QNX630/workspace/System/inc/RPNEvaluator.hpp:370: error: ISO C++ says that `", "   char& String::operator[](unsigned int)' and `operator[]' are ambiguous even ", "   though the worst conversion for the former is better than the worst ", "   conversion for the latter"};
    public static final int GCC_ERROR_STREAM4_WARNINGS = 0;
    public static final int GCC_ERROR_STREAM4_ERRORS = 1;
    public static final String[] GCC_ERROR_STREAM4_FILENAMES = new String[]{"RPNEvaluator.hpp"};
    public static final String[] GCC_ERROR_STREAM4_DESCRIPTIONS = new String[]{"ISO C++", "are ambiguous", "worst conversion for", "conversion for the latter"};
    static /* synthetic */ Class class$0;

    public GCCErrorParserTests(String string) {
        super(string);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.core.internal.errorparsers.tests.GCCErrorParserTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite testSuite = new TestSuite((Class)clazz);
        return testSuite;
    }

    public void testMultipleIncludesError() {
        this.runParserTest(GCC_ERROR_STREAM1, 0, 1, GCC_ERROR_STREAM1_FILENAMES, null);
    }

    public void testMultiLineDescriptionError() {
        this.runParserTest(GCC_ERROR_STREAM2, 0, 2, GCC_ERROR_STREAM2_FILENAMES, GCC_ERROR_STREAM2_DESCRIPTIONS);
    }

    public void testLongMultiLineDescriptionError() {
        this.runParserTest(GCC_ERROR_STREAM3, 1, 0, GCC_ERROR_STREAM3_FILENAMES, GCC_ERROR_STREAM3_DESCRIPTIONS);
    }

    public void testMultiFileMultiLineSingleError() {
        this.runParserTest(GCC_ERROR_STREAM4, 1, 0, GCC_ERROR_STREAM4_FILENAMES, GCC_ERROR_STREAM4_DESCRIPTIONS);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void runParserTest(String[] stringArray, int n, int n2, String[] stringArray2, String[] stringArray3) {
        String[] stringArray4 = new String[]{GCC_ERROR_PARSER_ID};
        GenericErrorParserTests.CountingMarkerGenerator countingMarkerGenerator = new GenericErrorParserTests.CountingMarkerGenerator(this);
        IProject iProject = this.getTempProject();
        Assert.assertNotNull((Object)iProject);
        GenericErrorParserTests.ImaginaryFilesErrorParserManager imaginaryFilesErrorParserManager = new GenericErrorParserTests.ImaginaryFilesErrorParserManager(this, iProject, countingMarkerGenerator, stringArray4);
        String string = this.makeStringFromArray(stringArray, "\n");
        StringBufferInputStream stringBufferInputStream = new StringBufferInputStream(string);
        Assert.assertNotNull((Object)stringBufferInputStream);
        try {
            try {
                this.transferInputStreamToOutputStream(stringBufferInputStream, imaginaryFilesErrorParserManager.getOutputStream(), 1024);
            }
            catch (Exception exception) {
                Assert.assertTrue((boolean)false);
            }
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            try {
                imaginaryFilesErrorParserManager.close();
                throw throwable;
            }
            catch (Exception exception) {}
            throw throwable;
        }
        {
            Object var12_15 = null;
        }
        try {}
        catch (Exception exception) {}
        imaginaryFilesErrorParserManager.close();
        imaginaryFilesErrorParserManager.reportProblems();
        Assert.assertEquals((int)n, (int)countingMarkerGenerator.numErrors);
        Assert.assertEquals((int)n2, (int)countingMarkerGenerator.numWarnings);
        Assert.assertEquals((int)stringArray2.length, (int)countingMarkerGenerator.uniqFiles.size());
        int n3 = 0;
        while (true) {
            if (n3 >= stringArray2.length) break;
            IPath iPath = ((IFile)countingMarkerGenerator.uniqFiles.get(n3)).getLocation();
            Assert.assertEquals((String)stringArray2[n3], (String)iPath.lastSegment());
            ++n3;
        }
        if (stringArray3 == null) return;
        Assert.assertNotNull((Object)countingMarkerGenerator.lastDescription);
        n3 = 0;
        while (n3 < stringArray3.length) {
            Assert.assertTrue((boolean)countingMarkerGenerator.lastDescription.matches(stringArray3[n3]));
            ++n3;
        }
        return;
    }
}

