/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.tests;

import java.io.StringWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import junit.framework.Assert;
import org.eclipse.cdt.core.parser.KeywordSetKey;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ast.IASTClassSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTCodeScope;
import org.eclipse.cdt.core.parser.ast.IASTCompletionNode;
import org.eclipse.cdt.core.parser.ast.IASTDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTExpression;
import org.eclipse.cdt.core.parser.ast.IASTField;
import org.eclipse.cdt.core.parser.ast.IASTFunction;
import org.eclipse.cdt.core.parser.ast.IASTMethod;
import org.eclipse.cdt.core.parser.ast.IASTNamespaceDefinition;
import org.eclipse.cdt.core.parser.ast.IASTNode;
import org.eclipse.cdt.core.parser.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTTypedefDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTVariable;
import org.eclipse.cdt.core.parser.tests.CompleteParseBaseTest;
import org.eclipse.cdt.core.parser.tests.CompletionParseBaseTest;
import org.eclipse.cdt.internal.core.parser.token.KeywordSets;

public class CompletionParseTest
extends CompletionParseBaseTest {
    public CompletionParseTest(String string) {
        super(string);
    }

    public void testBaseCase_SimpleDeclaration() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class ABC ");
        stringWriter.write("{int x;}; ");
        stringWriter.write("AB\n\n");
        IASTCompletionNode iASTCompletionNode = null;
        Iterator iterator = null;
        iASTCompletionNode = this.parse(stringWriter.toString(), 21);
        Assert.assertNotNull((Object)iASTCompletionNode);
        Assert.assertNotNull((Object)iASTCompletionNode.getCompletionPrefix());
        Assert.assertEquals((Object)iASTCompletionNode.getCompletionScope(), (Object)((CompleteParseBaseTest.Scope)this.callback.getCompilationUnit()).getScope());
        Assert.assertEquals((String)iASTCompletionNode.getCompletionPrefix(), (String)"A");
        Assert.assertEquals((Object)iASTCompletionNode.getCompletionKind(), (Object)IASTCompletionNode.CompletionKind.VARIABLE_TYPE);
        iterator = iASTCompletionNode.getKeywords();
        Assert.assertFalse((boolean)iterator.hasNext());
        iASTCompletionNode = this.parse(stringWriter.toString(), 12);
        Assert.assertNotNull((Object)iASTCompletionNode);
        Assert.assertNotNull((Object)iASTCompletionNode.getCompletionPrefix());
        Assert.assertTrue((boolean)(iASTCompletionNode.getCompletionScope() instanceof IASTClassSpecifier));
        Assert.assertEquals((String)iASTCompletionNode.getCompletionPrefix(), (String)"i");
        Assert.assertEquals((Object)iASTCompletionNode.getCompletionKind(), (Object)IASTCompletionNode.CompletionKind.FIELD_TYPE);
        iterator = iASTCompletionNode.getKeywords();
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((String)((String)iterator.next()), (String)"inline");
        Assert.assertEquals((String)((String)iterator.next()), (String)"int");
        Assert.assertFalse((boolean)iterator.hasNext());
        iASTCompletionNode = this.parse(stringWriter.toString(), 22);
        Assert.assertNotNull((Object)iASTCompletionNode);
        Assert.assertNotNull((Object)iASTCompletionNode.getCompletionPrefix());
        Assert.assertEquals((Object)iASTCompletionNode.getCompletionScope(), (Object)((CompleteParseBaseTest.Scope)this.callback.getCompilationUnit()).getScope());
        Assert.assertEquals((String)iASTCompletionNode.getCompletionPrefix(), (String)"AB");
        Assert.assertEquals((Object)iASTCompletionNode.getCompletionKind(), (Object)IASTCompletionNode.CompletionKind.VARIABLE_TYPE);
        iterator = iASTCompletionNode.getKeywords();
        Assert.assertFalse((boolean)iterator.hasNext());
        iASTCompletionNode = this.parse(stringWriter.toString(), 6);
        Assert.assertNotNull((Object)iASTCompletionNode);
        Assert.assertNotNull((Object)iASTCompletionNode.getCompletionPrefix());
        Assert.assertEquals((Object)iASTCompletionNode.getCompletionScope(), (Object)((CompleteParseBaseTest.Scope)this.callback.getCompilationUnit()).getScope());
        Assert.assertEquals((String)iASTCompletionNode.getCompletionPrefix(), (String)"");
        Assert.assertEquals((Object)iASTCompletionNode.getCompletionKind(), (Object)IASTCompletionNode.CompletionKind.CLASS_REFERENCE);
        iterator = iASTCompletionNode.getKeywords();
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    public void testCompletionLookup_Unqualified() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("int aVar; ");
        stringWriter.write("void foo( ) { ");
        stringWriter.write("   int anotherVar; ");
        stringWriter.write("   a ");
        stringWriter.write("} ");
        String string = stringWriter.toString();
        int n = 0;
        while (n < 2) {
            int n2 = n == 0 ? string.indexOf(" a ") + 2 : string.indexOf(" a ") + 1;
            IASTCompletionNode iASTCompletionNode = this.parse(string, n2);
            Assert.assertNotNull((Object)iASTCompletionNode);
            String string2 = iASTCompletionNode.getCompletionPrefix();
            Assert.assertNotNull((Object)string2);
            Assert.assertTrue((boolean)(iASTCompletionNode.getCompletionScope() instanceof IASTFunction));
            Assert.assertEquals((String)string2, (String)(n == 0 ? "a" : ""));
            Assert.assertEquals((Object)iASTCompletionNode.getCompletionKind(), (Object)IASTCompletionNode.CompletionKind.SINGLE_NAME_REFERENCE);
            IASTNode.LookupKind[] lookupKindArray = new IASTNode.LookupKind[]{IASTNode.LookupKind.ALL};
            IASTNode.ILookupResult iLookupResult = iASTCompletionNode.getCompletionScope().lookup(string2, lookupKindArray, iASTCompletionNode.getCompletionContext(), null);
            Assert.assertEquals((String)iLookupResult.getPrefix(), (String)string2);
            Iterator iterator = iLookupResult.getNodes();
            IASTVariable iASTVariable = (IASTVariable)iterator.next();
            IASTVariable iASTVariable2 = (IASTVariable)iterator.next();
            if (n != 0) {
                IASTFunction iASTFunction = (IASTFunction)iterator.next();
                Assert.assertEquals((String)iASTFunction.getName(), (String)"foo");
            }
            Assert.assertFalse((boolean)iterator.hasNext());
            Assert.assertEquals((String)iASTVariable.getName(), (String)"anotherVar");
            Assert.assertEquals((String)iASTVariable2.getName(), (String)"aVar");
            ++n;
        }
    }

    public void testCompletionLookup_Qualified() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("int aVar; ");
        stringWriter.write("struct D{ ");
        stringWriter.write("   int aField; ");
        stringWriter.write("   void aMethod(); ");
        stringWriter.write("}; ");
        stringWriter.write("void foo(){");
        stringWriter.write("   D d; ");
        stringWriter.write("   d.a ");
        stringWriter.write("}\n");
        String string = stringWriter.toString();
        int n = string.indexOf("d.a");
        IASTCompletionNode iASTCompletionNode = this.parse(string, n + 3);
        Assert.assertNotNull((Object)iASTCompletionNode);
        String string2 = iASTCompletionNode.getCompletionPrefix();
        Assert.assertNotNull((Object)string2);
        Assert.assertEquals((String)string2, (String)"a");
        Assert.assertTrue((boolean)(iASTCompletionNode.getCompletionScope() instanceof IASTFunction));
        Assert.assertEquals((Object)iASTCompletionNode.getCompletionKind(), (Object)IASTCompletionNode.CompletionKind.MEMBER_REFERENCE);
        Assert.assertNotNull((Object)iASTCompletionNode.getCompletionContext());
        Assert.assertTrue((boolean)(iASTCompletionNode.getCompletionContext() instanceof IASTVariable));
        IASTNode.LookupKind[] lookupKindArray = new IASTNode.LookupKind[]{IASTNode.LookupKind.ALL};
        IASTNode.ILookupResult iLookupResult = iASTCompletionNode.getCompletionScope().lookup(string2, lookupKindArray, iASTCompletionNode.getCompletionContext(), null);
        Assert.assertEquals((String)iLookupResult.getPrefix(), (String)string2);
        Iterator iterator = iLookupResult.getNodes();
        IASTField iASTField = (IASTField)iterator.next();
        IASTMethod iASTMethod = (IASTMethod)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((String)iASTMethod.getName(), (String)"aMethod");
        Assert.assertEquals((String)iASTField.getName(), (String)"aField");
    }

    public void testMemberCompletion_Arrow() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class A {");
        stringWriter.write("   public:   void aPublicBaseMethod();");
        stringWriter.write("   private:  void aPrivateBaseMethod();");
        stringWriter.write("};");
        stringWriter.write("class B : public A {");
        stringWriter.write("   public:   void aMethod();");
        stringWriter.write("};");
        stringWriter.write("void foo(){");
        stringWriter.write("   B * b = new B();");
        stringWriter.write("   b-> \n");
        String string = stringWriter.toString();
        int n = string.indexOf("b->");
        IASTCompletionNode iASTCompletionNode = this.parse(string, n + 3);
        Assert.assertNotNull((Object)iASTCompletionNode);
        Assert.assertEquals((String)iASTCompletionNode.getCompletionPrefix(), (String)"");
        Assert.assertEquals((Object)iASTCompletionNode.getCompletionKind(), (Object)IASTCompletionNode.CompletionKind.MEMBER_REFERENCE);
        Assert.assertTrue((boolean)(iASTCompletionNode.getCompletionScope() instanceof IASTFunction));
        Assert.assertEquals((String)((IASTFunction)iASTCompletionNode.getCompletionScope()).getName(), (String)"foo");
        Assert.assertTrue((boolean)(iASTCompletionNode.getCompletionContext() instanceof IASTVariable));
        Assert.assertEquals((String)((IASTVariable)iASTCompletionNode.getCompletionContext()).getName(), (String)"b");
    }

    public void testMemberCompletion_Dot() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class A {");
        stringWriter.write("   public:   void aPublicBaseMethod();");
        stringWriter.write("   private:  void aPrivateBaseMethod();");
        stringWriter.write("};");
        stringWriter.write("class B : public A {");
        stringWriter.write("   public:   void aMethod();");
        stringWriter.write("};");
        stringWriter.write("void foo(){");
        stringWriter.write("   B b;");
        stringWriter.write("   b. \n");
        String string = stringWriter.toString();
        int n = string.indexOf("b.");
        IASTCompletionNode iASTCompletionNode = this.parse(string, n + 2);
        Assert.assertNotNull((Object)iASTCompletionNode);
        Assert.assertEquals((String)iASTCompletionNode.getCompletionPrefix(), (String)"");
        Assert.assertEquals((Object)iASTCompletionNode.getCompletionKind(), (Object)IASTCompletionNode.CompletionKind.MEMBER_REFERENCE);
        Assert.assertTrue((boolean)(iASTCompletionNode.getCompletionScope() instanceof IASTFunction));
        Assert.assertEquals((String)((IASTFunction)iASTCompletionNode.getCompletionScope()).getName(), (String)"foo");
        Assert.assertTrue((boolean)(iASTCompletionNode.getCompletionContext() instanceof IASTVariable));
        Assert.assertEquals((String)((IASTVariable)iASTCompletionNode.getCompletionContext()).getName(), (String)"b");
    }

    public void testCompletionLookup_Pointer() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class A {");
        stringWriter.write("   public:   void aPublicBaseMethod();");
        stringWriter.write("   private:  void aPrivateBaseMethod();");
        stringWriter.write("};");
        stringWriter.write("class B : public A {");
        stringWriter.write("   public:   void aMethod();");
        stringWriter.write("};");
        stringWriter.write("void foo(){");
        stringWriter.write("   B * b = new B();");
        stringWriter.write("   b->a \n");
        int n = 0;
        while (n < 2) {
            String string = stringWriter.toString();
            int n2 = n == 0 ? string.indexOf("b->a") + 4 : string.indexOf("b->") + 3;
            IASTCompletionNode iASTCompletionNode = this.parse(string, n2);
            Assert.assertNotNull((Object)iASTCompletionNode);
            String string2 = iASTCompletionNode.getCompletionPrefix();
            Assert.assertEquals((String)string2, (String)(n == 0 ? "a" : ""));
            Assert.assertTrue((boolean)(iASTCompletionNode.getCompletionScope() instanceof IASTFunction));
            Assert.assertEquals((Object)iASTCompletionNode.getCompletionKind(), (Object)IASTCompletionNode.CompletionKind.MEMBER_REFERENCE);
            Assert.assertNotNull((Object)iASTCompletionNode.getCompletionContext());
            Assert.assertTrue((boolean)(iASTCompletionNode.getCompletionContext() instanceof IASTVariable));
            IASTNode.LookupKind[] lookupKindArray = new IASTNode.LookupKind[]{IASTNode.LookupKind.METHODS};
            IASTNode.ILookupResult iLookupResult = iASTCompletionNode.getCompletionScope().lookup(string2, lookupKindArray, iASTCompletionNode.getCompletionContext(), null);
            Assert.assertEquals((String)iLookupResult.getPrefix(), (String)string2);
            Iterator iterator = iLookupResult.getNodes();
            IASTMethod iASTMethod = (IASTMethod)iterator.next();
            IASTMethod iASTMethod2 = (IASTMethod)iterator.next();
            Assert.assertFalse((boolean)iterator.hasNext());
            Assert.assertEquals((String)iASTMethod.getName(), (String)"aMethod");
            Assert.assertEquals((String)iASTMethod2.getName(), (String)"aPublicBaseMethod");
            ++n;
        }
    }

    public void testCompletionLookup_FriendClass_1() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class A {");
        stringWriter.write("   private:  void aPrivateMethod();");
        stringWriter.write("   friend class C;");
        stringWriter.write("};");
        stringWriter.write("class C {");
        stringWriter.write("   void foo();");
        stringWriter.write("};");
        stringWriter.write("void C::foo(){");
        stringWriter.write("   A a;");
        stringWriter.write("   a.a \n");
        String string = stringWriter.toString();
        int n = string.indexOf("a.a");
        IASTCompletionNode iASTCompletionNode = this.parse(string, n + 3);
        Assert.assertNotNull((Object)iASTCompletionNode);
        String string2 = iASTCompletionNode.getCompletionPrefix();
        Assert.assertEquals((String)string2, (String)"a");
        Assert.assertTrue((boolean)(iASTCompletionNode.getCompletionScope() instanceof IASTFunction));
        Assert.assertEquals((Object)iASTCompletionNode.getCompletionKind(), (Object)IASTCompletionNode.CompletionKind.MEMBER_REFERENCE);
        Assert.assertNotNull((Object)iASTCompletionNode.getCompletionContext());
        Assert.assertTrue((boolean)(iASTCompletionNode.getCompletionContext() instanceof IASTVariable));
        IASTNode.ILookupResult iLookupResult = iASTCompletionNode.getCompletionScope().lookup(string2, new IASTNode.LookupKind[]{IASTNode.LookupKind.METHODS}, iASTCompletionNode.getCompletionContext(), null);
        Assert.assertEquals((String)iLookupResult.getPrefix(), (String)string2);
        Iterator iterator = iLookupResult.getNodes();
        Assert.assertTrue((boolean)iterator.hasNext());
        IASTMethod iASTMethod = (IASTMethod)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((String)iASTMethod.getName(), (String)"aPrivateMethod");
    }

    public void testCompletionLookup_FriendClass_2() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class C {");
        stringWriter.write("   void foo();");
        stringWriter.write("};");
        stringWriter.write("class A {");
        stringWriter.write("   private:  void aPrivateMethod();");
        stringWriter.write("   friend class C;");
        stringWriter.write("};");
        stringWriter.write("void C::foo(){");
        stringWriter.write("   A a;");
        stringWriter.write("   a.a \n");
        String string = stringWriter.toString();
        int n = string.indexOf("a.a");
        IASTCompletionNode iASTCompletionNode = this.parse(string, n + 3);
        Assert.assertNotNull((Object)iASTCompletionNode);
        String string2 = iASTCompletionNode.getCompletionPrefix();
        Assert.assertEquals((String)string2, (String)"a");
        Assert.assertTrue((boolean)(iASTCompletionNode.getCompletionScope() instanceof IASTFunction));
        Assert.assertEquals((Object)iASTCompletionNode.getCompletionKind(), (Object)IASTCompletionNode.CompletionKind.MEMBER_REFERENCE);
        Assert.assertNotNull((Object)iASTCompletionNode.getCompletionContext());
        Assert.assertTrue((boolean)(iASTCompletionNode.getCompletionContext() instanceof IASTVariable));
        IASTNode.ILookupResult iLookupResult = iASTCompletionNode.getCompletionScope().lookup(string2, new IASTNode.LookupKind[]{IASTNode.LookupKind.METHODS}, iASTCompletionNode.getCompletionContext(), null);
        Assert.assertEquals((String)iLookupResult.getPrefix(), (String)string2);
        Iterator iterator = iLookupResult.getNodes();
        Assert.assertTrue((boolean)iterator.hasNext());
        IASTMethod iASTMethod = (IASTMethod)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((String)iASTMethod.getName(), (String)"aPrivateMethod");
    }

    public void testCompletionLookup_ParametersAsLocalVariables() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("int foo( int aParameter ){");
        stringWriter.write("   int aLocal;");
        stringWriter.write("   if( aLocal != 0 ){");
        stringWriter.write("      int aBlockLocal;");
        stringWriter.write("      a \n");
        String string = stringWriter.toString();
        int n = string.indexOf(" a ");
        IASTCompletionNode iASTCompletionNode = this.parse(string, n + 2);
        Assert.assertNotNull((Object)iASTCompletionNode);
        String string2 = iASTCompletionNode.getCompletionPrefix();
        Assert.assertEquals((String)string2, (String)"a");
        Assert.assertTrue((boolean)(iASTCompletionNode.getCompletionScope() instanceof IASTCodeScope));
        Assert.assertEquals((Object)iASTCompletionNode.getCompletionKind(), (Object)IASTCompletionNode.CompletionKind.SINGLE_NAME_REFERENCE);
        Assert.assertNull((Object)iASTCompletionNode.getCompletionContext());
        IASTNode.ILookupResult iLookupResult = iASTCompletionNode.getCompletionScope().lookup(string2, new IASTNode.LookupKind[]{IASTNode.LookupKind.LOCAL_VARIABLES}, iASTCompletionNode.getCompletionContext(), null);
        Assert.assertEquals((String)iLookupResult.getPrefix(), (String)string2);
        Iterator iterator = iLookupResult.getNodes();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTVariable iASTVariable2 = (IASTVariable)iterator.next();
        IASTParameterDeclaration iASTParameterDeclaration = (IASTParameterDeclaration)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((String)iASTVariable.getName(), (String)"aBlockLocal");
        Assert.assertEquals((String)iASTVariable2.getName(), (String)"aLocal");
        Assert.assertEquals((String)iASTParameterDeclaration.getName(), (String)"aParameter");
    }

    public void testCompletionLookup_LookupKindTHIS() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("int aGlobalVar;");
        stringWriter.write("namespace NS { ");
        stringWriter.write("   int aNamespaceFunction(){}");
        stringWriter.write("   class Base { ");
        stringWriter.write("      protected: int aBaseField;");
        stringWriter.write("   };");
        stringWriter.write("   class Derived : public Base {");
        stringWriter.write("      int aMethod();");
        stringWriter.write("   };");
        stringWriter.write("}");
        stringWriter.write("int NS::Derived::aMethod(){");
        stringWriter.write("   int aLocal;");
        stringWriter.write("   a  ");
        String string = stringWriter.toString();
        int n = string.indexOf(" a ");
        IASTCompletionNode iASTCompletionNode = this.parse(string, n + 2);
        Assert.assertNotNull((Object)iASTCompletionNode);
        Assert.assertEquals((String)iASTCompletionNode.getCompletionPrefix(), (String)"a");
        Assert.assertTrue((boolean)(iASTCompletionNode.getCompletionScope() instanceof IASTMethod));
        IASTNode.ILookupResult iLookupResult = iASTCompletionNode.getCompletionScope().lookup(iASTCompletionNode.getCompletionPrefix(), new IASTNode.LookupKind[]{IASTNode.LookupKind.THIS}, iASTCompletionNode.getCompletionContext(), null);
        Assert.assertEquals((int)iLookupResult.getResultsSize(), (int)2);
        Iterator iterator = iLookupResult.getNodes();
        IASTMethod iASTMethod = (IASTMethod)iterator.next();
        IASTField iASTField = (IASTField)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((String)iASTMethod.getName(), (String)"aMethod");
        Assert.assertEquals((String)iASTField.getName(), (String)"aBaseField");
        iLookupResult = iASTCompletionNode.getCompletionScope().lookup(iASTCompletionNode.getCompletionPrefix(), new IASTNode.LookupKind[]{IASTNode.LookupKind.THIS, IASTNode.LookupKind.METHODS}, iASTCompletionNode.getCompletionContext(), null);
        Assert.assertEquals((int)iLookupResult.getResultsSize(), (int)1);
        iterator = iLookupResult.getNodes();
        iASTMethod = (IASTMethod)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((String)iASTMethod.getName(), (String)"aMethod");
    }

    public void testCompletionInConstructor() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class SimpleTest{");
        ((Writer)stringWriter).write("\tpublic:");
        ((Writer)stringWriter).write("SimpleTest();");
        ((Writer)stringWriter).write("~SimpleTest();");
        ((Writer)stringWriter).write("int a, b, c, aa, bb, cc, abc;");
        ((Writer)stringWriter).write("};");
        ((Writer)stringWriter).write("SimpleTest::~SimpleTest()");
        ((Writer)stringWriter).write("{}");
        ((Writer)stringWriter).write("SimpleTest::SimpleTest()");
        ((Writer)stringWriter).write("{");
        ((Writer)stringWriter).write("/**/a");
        ((Writer)stringWriter).write("}");
        IASTCompletionNode iASTCompletionNode = this.parse(((Object)stringWriter).toString(), ((Object)stringWriter).toString().indexOf("/**/a") + 5);
        Assert.assertNotNull((Object)iASTCompletionNode);
        Assert.assertEquals((String)iASTCompletionNode.getCompletionPrefix(), (String)"a");
        Assert.assertTrue((boolean)(iASTCompletionNode.getCompletionScope() instanceof IASTMethod));
        IASTMethod iASTMethod = (IASTMethod)iASTCompletionNode.getCompletionScope();
        Assert.assertEquals((String)iASTMethod.getName(), (String)"SimpleTest");
        Assert.assertTrue((boolean)iASTMethod.isConstructor());
        Assert.assertEquals((Object)iASTCompletionNode.getCompletionKind(), (Object)IASTCompletionNode.CompletionKind.SINGLE_NAME_REFERENCE);
        Assert.assertNull((Object)iASTCompletionNode.getCompletionContext());
        IASTNode.LookupKind[] lookupKindArray = new IASTNode.LookupKind[]{IASTNode.LookupKind.FIELDS};
        IASTNode.ILookupResult iLookupResult = iASTMethod.lookup("a", lookupKindArray, null, null);
        Assert.assertEquals((int)iLookupResult.getResultsSize(), (int)3);
    }

    public void testCompletionInDestructor() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class SimpleTest{");
        ((Writer)stringWriter).write("\tpublic:");
        ((Writer)stringWriter).write("SimpleTest();");
        ((Writer)stringWriter).write("~SimpleTest();");
        ((Writer)stringWriter).write("int a, b, c, aa, bb, cc, abc;");
        ((Writer)stringWriter).write("};");
        ((Writer)stringWriter).write("SimpleTest::SimpleTest()");
        ((Writer)stringWriter).write("{}");
        ((Writer)stringWriter).write("SimpleTest::~SimpleTest()");
        ((Writer)stringWriter).write("{");
        ((Writer)stringWriter).write("/**/a");
        ((Writer)stringWriter).write("}");
        IASTCompletionNode iASTCompletionNode = this.parse(((Object)stringWriter).toString(), ((Object)stringWriter).toString().indexOf("/**/a") + 5);
        Assert.assertNotNull((Object)iASTCompletionNode);
        Assert.assertEquals((String)iASTCompletionNode.getCompletionPrefix(), (String)"a");
        Assert.assertTrue((boolean)(iASTCompletionNode.getCompletionScope() instanceof IASTMethod));
        IASTMethod iASTMethod = (IASTMethod)iASTCompletionNode.getCompletionScope();
        Assert.assertEquals((String)iASTMethod.getName(), (String)"~SimpleTest");
        Assert.assertTrue((boolean)iASTMethod.isDestructor());
        Assert.assertEquals((Object)iASTCompletionNode.getCompletionKind(), (Object)IASTCompletionNode.CompletionKind.SINGLE_NAME_REFERENCE);
        Assert.assertNull((Object)iASTCompletionNode.getCompletionContext());
        IASTNode.LookupKind[] lookupKindArray = new IASTNode.LookupKind[]{IASTNode.LookupKind.FIELDS};
        IASTNode.ILookupResult iLookupResult = iASTMethod.lookup("a", lookupKindArray, null, null);
        Assert.assertEquals((int)iLookupResult.getResultsSize(), (int)3);
    }

    public void testBug48307_FriendFunction_1() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class A{ public : void foo(); }; ");
        stringWriter.write("class B{ ");
        stringWriter.write("   private : int aPrivate;");
        stringWriter.write("   friend void A::foo(); ");
        stringWriter.write("};");
        stringWriter.write("void A::foo(){");
        stringWriter.write("   B b;");
        stringWriter.write("   b.aP");
        String string = stringWriter.toString();
        int n = string.indexOf("b.aP");
        IASTCompletionNode iASTCompletionNode = this.parse(string, n + 4);
        IASTNode.ILookupResult iLookupResult = iASTCompletionNode.getCompletionScope().lookup(iASTCompletionNode.getCompletionPrefix(), new IASTNode.LookupKind[]{IASTNode.LookupKind.ALL}, iASTCompletionNode.getCompletionContext(), null);
        Assert.assertNotNull((Object)iLookupResult);
        Assert.assertEquals((int)iLookupResult.getResultsSize(), (int)1);
        IASTField iASTField = (IASTField)iLookupResult.getNodes().next();
        Assert.assertEquals((String)iASTField.getName(), (String)"aPrivate");
    }

    public void testBug48307_FriendFunction_2() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("void global();");
        stringWriter.write("class B{ ");
        stringWriter.write("   private : int aPrivate;");
        stringWriter.write("   friend void global(); ");
        stringWriter.write("};");
        stringWriter.write("void global(){");
        stringWriter.write("   B b;");
        stringWriter.write("   b.aP");
        String string = stringWriter.toString();
        int n = string.indexOf("b.aP");
        IASTCompletionNode iASTCompletionNode = this.parse(string, n + 4);
        IASTNode.ILookupResult iLookupResult = iASTCompletionNode.getCompletionScope().lookup(iASTCompletionNode.getCompletionPrefix(), new IASTNode.LookupKind[]{IASTNode.LookupKind.ALL}, iASTCompletionNode.getCompletionContext(), null);
        Assert.assertNotNull((Object)iLookupResult);
        Assert.assertEquals((int)iLookupResult.getResultsSize(), (int)1);
        IASTField iASTField = (IASTField)iLookupResult.getNodes().next();
        Assert.assertEquals((String)iASTField.getName(), (String)"aPrivate");
    }

    public void testBug51260() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write(" class A { public: void a(); }; ");
        stringWriter.write(" class B : public virtual A { public: void b(); };");
        stringWriter.write(" class C : public virtual A { public: void c(); };");
        stringWriter.write(" class D : public B, C { public: void d(); };");
        stringWriter.write(" void A::a(){} ");
        stringWriter.write(" void B::b(){} ");
        stringWriter.write(" void C::c(){} ");
        stringWriter.write(" void D::d(){ SP }");
        String string = stringWriter.toString();
        int n = string.indexOf("SP");
        IASTCompletionNode iASTCompletionNode = this.parse(string, n);
        IASTNode.ILookupResult iLookupResult = iASTCompletionNode.getCompletionScope().lookup(iASTCompletionNode.getCompletionPrefix(), new IASTNode.LookupKind[]{IASTNode.LookupKind.THIS}, iASTCompletionNode.getCompletionContext(), null);
        Assert.assertTrue((boolean)(iASTCompletionNode.getCompletionScope() instanceof IASTMethod));
        Assert.assertEquals((String)((IASTMethod)iASTCompletionNode.getCompletionScope()).getName(), (String)"d");
        Assert.assertEquals((int)iLookupResult.getResultsSize(), (int)4);
        Iterator iterator = iLookupResult.getNodes();
        IASTMethod iASTMethod = (IASTMethod)iterator.next();
        IASTMethod iASTMethod2 = (IASTMethod)iterator.next();
        IASTMethod iASTMethod3 = (IASTMethod)iterator.next();
        IASTMethod iASTMethod4 = (IASTMethod)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((String)iASTMethod3.getName(), (String)"a");
        Assert.assertEquals((String)iASTMethod2.getName(), (String)"b");
        Assert.assertEquals((String)iASTMethod4.getName(), (String)"c");
        Assert.assertEquals((String)iASTMethod.getName(), (String)"d");
    }

    public void testBug52948() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("typedef int Int; ");
        stringWriter.write("InSP");
        String string = stringWriter.toString();
        int n = string.indexOf("SP");
        IASTCompletionNode iASTCompletionNode = this.parse(string, n);
        IASTNode.ILookupResult iLookupResult = iASTCompletionNode.getCompletionScope().lookup(iASTCompletionNode.getCompletionPrefix(), new IASTNode.LookupKind[]{IASTNode.LookupKind.TYPEDEFS}, iASTCompletionNode.getCompletionContext(), null);
        Assert.assertEquals((int)iLookupResult.getResultsSize(), (int)1);
        Iterator iterator = iLookupResult.getNodes();
        IASTTypedefDeclaration iASTTypedefDeclaration = (IASTTypedefDeclaration)iterator.next();
        Assert.assertEquals((String)iASTTypedefDeclaration.getName(), (String)"Int");
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    public void testCompletionInFunctionBodyFullyQualified() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("int aInteger = 5;\n");
        stringWriter.write("namespace NMS { \n");
        stringWriter.write(" int foo() { \n");
        stringWriter.write("::A ");
        stringWriter.write("}\n}\n");
        String string = stringWriter.toString();
        int n = 0;
        while (n < 2) {
            String string2 = n == 0 ? "::" : "::A";
            IASTCompletionNode iASTCompletionNode = this.parse(string, string.indexOf(string2) + string2.length());
            this.validateCompletionNode(iASTCompletionNode, n == 0 ? "" : "A", IASTCompletionNode.CompletionKind.SINGLE_NAME_REFERENCE, (IASTNode)this.getCompilationUnit(), false);
            IASTNode.ILookupResult iLookupResult = iASTCompletionNode.getCompletionScope().lookup(iASTCompletionNode.getCompletionPrefix(), new IASTNode.LookupKind[]{IASTNode.LookupKind.ALL}, iASTCompletionNode.getCompletionContext(), null);
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add("aInteger");
            if (n == 0) {
                hashSet.add("NMS");
                hashSet.add("__builtin_va_list ");
                hashSet.add("__builtin_expect");
                hashSet.add("__builtin_prefetch");
                hashSet.add("__builtin_huge_val");
                hashSet.add("__builtin_huge_valf");
                hashSet.add("__builtin_huge_vall");
                hashSet.add("__builtin_inf");
                hashSet.add("__builtin_inff");
                hashSet.add("__builtin_infl");
                hashSet.add("__builtin_nan");
                hashSet.add("__builtin_nanf");
                hashSet.add("__builtin_nanl");
                hashSet.add("__builtin_nans");
                hashSet.add("__builtin_nansf");
                hashSet.add("__builtin_nansl");
                hashSet.add("__builtin_ffs");
                hashSet.add("__builtin_clz");
                hashSet.add("__builtin_ctz");
                hashSet.add("__builtin_popcount");
                hashSet.add("__builtin_parity");
                hashSet.add("__builtin_ffsl");
                hashSet.add("__builtin_clzl");
                hashSet.add("__builtin_ctzl");
                hashSet.add("__builtin_popcountl");
                hashSet.add("__builtin_parityl");
                hashSet.add("__builtin_ffsll");
                hashSet.add("__builtin_clzll");
                hashSet.add("__builtin_ctzll");
                hashSet.add("__builtin_popcountll");
                hashSet.add("__builtin_parityll");
                hashSet.add("__builtin_types_compatible_p");
            }
            this.validateLookupResult(iLookupResult, hashSet);
            ++n;
        }
    }

    public void testCompletionInFunctionBodyQualifiedName() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("namespace ABC {\n");
        stringWriter.write("  struct DEF { int x; }; \n");
        stringWriter.write("  struct GHI { float y;};\n");
        stringWriter.write("}\n");
        stringWriter.write("int main() { ABC::D }\n");
        String string = stringWriter.toString();
        int n = 0;
        while (n < 2) {
            IASTDeclaration iASTDeclaration;
            String string2 = n == 0 ? "::" : "::D";
            IASTCompletionNode iASTCompletionNode = this.parse(string, string.indexOf(string2) + string2.length());
            IASTNamespaceDefinition iASTNamespaceDefinition = null;
            Iterator iterator = this.callback.getCompilationUnit().getDeclarations();
            while (iterator.hasNext()) {
                iASTDeclaration = (IASTDeclaration)iterator.next();
                if (!(iASTDeclaration instanceof IASTNamespaceDefinition) || !((IASTNamespaceDefinition)iASTDeclaration).getName().equals("ABC")) continue;
                iASTNamespaceDefinition = (IASTNamespaceDefinition)iASTDeclaration;
                break;
            }
            Assert.assertNotNull(iASTNamespaceDefinition);
            this.validateCompletionNode(iASTCompletionNode, n == 0 ? "" : "D", IASTCompletionNode.CompletionKind.SINGLE_NAME_REFERENCE, (IASTNode)iASTNamespaceDefinition, false);
            iASTDeclaration = iASTCompletionNode.getCompletionScope().lookup(iASTCompletionNode.getCompletionPrefix(), new IASTNode.LookupKind[]{IASTNode.LookupKind.ALL}, iASTCompletionNode.getCompletionContext(), null);
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add("DEF");
            if (n == 0) {
                hashSet.add("GHI");
            }
            this.validateLookupResult((IASTNode.ILookupResult)iASTDeclaration, hashSet);
            ++n;
        }
    }

    public void testCompletionWithTemplateInstanceAsParent() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("template < class T > class A { public : int a_member; }; ");
        stringWriter.write("template < class T > class B : public A< T > { public : int b_member; }; ");
        stringWriter.write("void f() { ");
        stringWriter.write("   B< int > b; ");
        stringWriter.write("   b.SP ");
        String string = stringWriter.toString();
        IASTCompletionNode iASTCompletionNode = this.parse(string, string.indexOf("SP"));
        IASTNode.ILookupResult iLookupResult = iASTCompletionNode.getCompletionScope().lookup("", new IASTNode.LookupKind[]{IASTNode.LookupKind.ALL}, iASTCompletionNode.getCompletionContext(), null);
        Assert.assertEquals((int)iLookupResult.getResultsSize(), (int)2);
        Iterator iterator = iLookupResult.getNodes();
        Assert.assertTrue((boolean)(iterator.next() instanceof IASTField));
        Assert.assertTrue((boolean)(iterator.next() instanceof IASTField));
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    public void testBug58178() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#define GL_T 0x2001\n");
        ((Writer)stringWriter).write("#define GL_TRUE 0x1\n");
        ((Writer)stringWriter).write("typedef unsigned char   GLboolean;\n");
        ((Writer)stringWriter).write("static GLboolean should_rotate = GL_T");
        String string = ((Object)stringWriter).toString();
        IASTCompletionNode iASTCompletionNode = this.parse(string, string.indexOf("= GL_T") + "= GL_T".length());
        Assert.assertEquals((String)iASTCompletionNode.getCompletionPrefix(), (String)"GL_T");
    }

    public void testBug52253() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class CMyClass {public:\n void doorBell(){ return; }};");
        ((Writer)stringWriter).write("int\tmain(int argc, char **argv) {CMyClass mc; mc.do }");
        String string = ((Object)stringWriter).toString();
        IASTCompletionNode iASTCompletionNode = this.parse(string, string.indexOf("mc.do") + "mc.do".length());
        Assert.assertEquals((String)iASTCompletionNode.getCompletionPrefix(), (String)"do");
        Assert.assertEquals((Object)iASTCompletionNode.getCompletionKind(), (Object)IASTCompletionNode.CompletionKind.MEMBER_REFERENCE);
        IASTNode.ILookupResult iLookupResult = iASTCompletionNode.getCompletionScope().lookup(iASTCompletionNode.getCompletionPrefix(), new IASTNode.LookupKind[]{IASTNode.LookupKind.ALL}, iASTCompletionNode.getCompletionContext(), null);
        Assert.assertEquals((int)iLookupResult.getResultsSize(), (int)1);
        Iterator iterator = iLookupResult.getNodes();
        IASTMethod iASTMethod = (IASTMethod)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((String)iASTMethod.getName(), (String)"doorBell");
    }

    public void testBug58492() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("struct Cube {                       ");
        ((Writer)stringWriter).write("   int nLen;                        ");
        ((Writer)stringWriter).write("   int nWidth;                      ");
        ((Writer)stringWriter).write("   int nHeight;                     ");
        ((Writer)stringWriter).write("};                                  ");
        ((Writer)stringWriter).write("int volume( struct Cube * pCube ) { ");
        ((Writer)stringWriter).write("   pCube->SP                        ");
        String string = ((Object)stringWriter).toString();
        IASTCompletionNode iASTCompletionNode = this.parse(string, string.indexOf("SP"), ParserLanguage.C);
        IASTNode.ILookupResult iLookupResult = iASTCompletionNode.getCompletionScope().lookup(iASTCompletionNode.getCompletionPrefix(), new IASTNode.LookupKind[]{IASTNode.LookupKind.ALL}, iASTCompletionNode.getCompletionContext(), null);
        Assert.assertEquals((int)iLookupResult.getResultsSize(), (int)3);
        Iterator iterator = iLookupResult.getNodes();
        Assert.assertTrue((boolean)(iterator.next() instanceof IASTField));
        Assert.assertTrue((boolean)(iterator.next() instanceof IASTField));
        Assert.assertTrue((boolean)(iterator.next() instanceof IASTField));
    }

    public void testCompletionOnExpression() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class ABC { public: void voidMethod(); };\n");
        ((Writer)stringWriter).write("ABC * someFunction(void) { return new ABC(); }\n");
        ((Writer)stringWriter).write("void testFunction( void ) { someFunction()->V  }\n");
        String string = ((Object)stringWriter).toString();
        int n = 0;
        while (n < 2) {
            int n2 = string.indexOf("V");
            if (n == 1) {
                ++n2;
            }
            IASTCompletionNode iASTCompletionNode = this.parse(string, n2);
            Assert.assertEquals((String)iASTCompletionNode.getCompletionPrefix(), (String)(n == 0 ? "" : "V"));
            Assert.assertEquals((Object)iASTCompletionNode.getCompletionKind(), (Object)IASTCompletionNode.CompletionKind.MEMBER_REFERENCE);
            Assert.assertTrue((boolean)(iASTCompletionNode.getCompletionContext() instanceof IASTExpression));
            ++n;
        }
    }

    public void testCompletionInTypeDef() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("struct A {  int name;  };  \n");
        stringWriter.write("typedef struct A * PA;     \n");
        stringWriter.write("int main() {               \n");
        stringWriter.write("   PA a;                   \n");
        stringWriter.write("   a->SP                   \n");
        stringWriter.write("}                          \n");
        String string = stringWriter.toString();
        int n = string.indexOf("SP");
        IASTCompletionNode iASTCompletionNode = this.parse(string, n);
        IASTNode.ILookupResult iLookupResult = iASTCompletionNode.getCompletionScope().lookup(iASTCompletionNode.getCompletionPrefix(), new IASTNode.LookupKind[]{IASTNode.LookupKind.ALL}, iASTCompletionNode.getCompletionContext(), null);
        Assert.assertEquals((int)iLookupResult.getResultsSize(), (int)1);
        Iterator iterator = iLookupResult.getNodes();
        IASTField iASTField = (IASTField)iterator.next();
        Assert.assertEquals((String)iASTField.getName(), (String)"name");
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    public void testBug59134() throws Exception {
        String string = "int main(){ siz }";
        IASTCompletionNode iASTCompletionNode = this.parse(string, string.indexOf("siz"));
        Assert.assertNotNull((Object)iASTCompletionNode);
        Iterator iterator = iASTCompletionNode.getKeywords();
        boolean bl = false;
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!string2.equals("sizeof")) continue;
            bl = true;
        }
        Assert.assertTrue((boolean)bl);
    }

    public void testBug59893() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("struct A {  \t                 \n");
        stringWriter.write("   void f1() const volatile;\t \n");
        stringWriter.write("   void f2() const;  \t\t \n");
        stringWriter.write("   void f3() volatile;        \n");
        stringWriter.write("   void f4();                 \n");
        stringWriter.write("};                            \n");
        stringWriter.write("void main( const A& a1 )      \n");
        stringWriter.write("{                             \n");
        stringWriter.write("   const volatile A * a2;     \n");
        stringWriter.write("   const A * a3;              \n");
        stringWriter.write("   volatile A * a4;           \n");
        stringWriter.write("   A * a5;                    \n");
        String string = stringWriter.toString();
        IASTCompletionNode iASTCompletionNode = this.parse(String.valueOf(string) + "a1. ", string.length() + 3);
        Assert.assertNotNull((Object)iASTCompletionNode);
        IASTNode.ILookupResult iLookupResult = iASTCompletionNode.getCompletionScope().lookup(iASTCompletionNode.getCompletionPrefix(), new IASTNode.LookupKind[]{IASTNode.LookupKind.ALL}, iASTCompletionNode.getCompletionContext(), null);
        Assert.assertEquals((int)iLookupResult.getResultsSize(), (int)2);
        iASTCompletionNode = this.parse(String.valueOf(string) + "a2-> ", string.length() + 4);
        Assert.assertNotNull((Object)iASTCompletionNode);
        iLookupResult = iASTCompletionNode.getCompletionScope().lookup(iASTCompletionNode.getCompletionPrefix(), new IASTNode.LookupKind[]{IASTNode.LookupKind.ALL}, iASTCompletionNode.getCompletionContext(), null);
        Assert.assertEquals((int)iLookupResult.getResultsSize(), (int)1);
        iASTCompletionNode = this.parse(String.valueOf(string) + "a3-> ", string.length() + 4);
        Assert.assertNotNull((Object)iASTCompletionNode);
        iLookupResult = iASTCompletionNode.getCompletionScope().lookup(iASTCompletionNode.getCompletionPrefix(), new IASTNode.LookupKind[]{IASTNode.LookupKind.ALL}, iASTCompletionNode.getCompletionContext(), null);
        Assert.assertEquals((int)iLookupResult.getResultsSize(), (int)2);
        iASTCompletionNode = this.parse(String.valueOf(string) + "a4-> ", string.length() + 4);
        Assert.assertNotNull((Object)iASTCompletionNode);
        iLookupResult = iASTCompletionNode.getCompletionScope().lookup(iASTCompletionNode.getCompletionPrefix(), new IASTNode.LookupKind[]{IASTNode.LookupKind.ALL}, iASTCompletionNode.getCompletionContext(), null);
        Assert.assertEquals((int)iLookupResult.getResultsSize(), (int)2);
        iASTCompletionNode = this.parse(String.valueOf(string) + "a5-> ", string.length() + 4);
        Assert.assertNotNull((Object)iASTCompletionNode);
        iLookupResult = iASTCompletionNode.getCompletionScope().lookup(iASTCompletionNode.getCompletionPrefix(), new IASTNode.LookupKind[]{IASTNode.LookupKind.ALL}, iASTCompletionNode.getCompletionContext(), null);
        Assert.assertEquals((int)iLookupResult.getResultsSize(), (int)4);
    }

    public void testBug59893_Expression() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("struct A {  \t                 \n");
        stringWriter.write("   void f2() const;  \t\t \n");
        stringWriter.write("   void f4();                 \n");
        stringWriter.write("};                            \n");
        stringWriter.write("const A * foo(){}             \n");
        stringWriter.write("void main( )                  \n");
        stringWriter.write("{                             \n");
        stringWriter.write("   foo()->SP                  \n");
        String string = stringWriter.toString();
        int n = string.indexOf("SP");
        IASTCompletionNode iASTCompletionNode = this.parse(string, n);
        IASTNode.ILookupResult iLookupResult = iASTCompletionNode.getCompletionScope().lookup(iASTCompletionNode.getCompletionPrefix(), new IASTNode.LookupKind[]{IASTNode.LookupKind.ALL}, iASTCompletionNode.getCompletionContext(), null);
        Assert.assertEquals((int)iLookupResult.getResultsSize(), (int)1);
    }

    public void testParameterListFunctionReference() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("int foo( int firstParam, int secondParam );\n");
        ((Writer)stringWriter).write("void main() { \n");
        ((Writer)stringWriter).write("  int abc;\n");
        ((Writer)stringWriter).write("  int x;\n");
        ((Writer)stringWriter).write("  foo( x,a");
        String string = ((Object)stringWriter).toString();
        int n = 0;
        while (n < 2) {
            int n2 = string.indexOf("x,a") + 2;
            if (n == 1) {
                ++n2;
            }
            IASTCompletionNode iASTCompletionNode = this.parse(string, n2);
            this.validateCompletionNode(iASTCompletionNode, n == 0 ? "" : "a", IASTCompletionNode.CompletionKind.FUNCTION_REFERENCE, null, true);
            Assert.assertNotNull((Object)iASTCompletionNode.getFunctionParameters());
            IASTNode.ILookupResult iLookupResult = iASTCompletionNode.getCompletionScope().lookup(iASTCompletionNode.getCompletionPrefix(), new IASTNode.LookupKind[]{IASTNode.LookupKind.LOCAL_VARIABLES}, iASTCompletionNode.getCompletionContext(), null);
            Assert.assertNotNull((Object)iLookupResult);
            Assert.assertEquals((int)iLookupResult.getResultsSize(), (int)(n == 0 ? 2 : 1));
            ++n;
        }
    }

    public void testParameterListConstructorReference() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class A { \n");
        ((Writer)stringWriter).write("public:\n");
        ((Writer)stringWriter).write("  A( int first, int second );\n");
        ((Writer)stringWriter).write("};\n");
        ((Writer)stringWriter).write("void main() { \n");
        ((Writer)stringWriter).write("  int four, x;");
        ((Writer)stringWriter).write("  A * a = new A( x,f ");
        String string = ((Object)stringWriter).toString();
        int n = 0;
        while (n < 2) {
            int n2 = string.indexOf("x,f") + 2;
            if (n == 1) {
                ++n2;
            }
            IASTCompletionNode iASTCompletionNode = this.parse(string, n2);
            this.validateCompletionNode(iASTCompletionNode, n == 0 ? "" : "f", IASTCompletionNode.CompletionKind.CONSTRUCTOR_REFERENCE, null, true);
            Assert.assertNotNull((Object)iASTCompletionNode.getFunctionParameters());
            IASTNode.ILookupResult iLookupResult = iASTCompletionNode.getCompletionScope().lookup(iASTCompletionNode.getCompletionPrefix(), new IASTNode.LookupKind[]{IASTNode.LookupKind.LOCAL_VARIABLES}, iASTCompletionNode.getCompletionContext(), null);
            Assert.assertNotNull((Object)iLookupResult);
            Assert.assertEquals((int)iLookupResult.getResultsSize(), (int)(n == 0 ? 2 : 1));
            ++n;
        }
    }

    public void testConstructors() throws Exception {
        String string = "class Foo{ public: Foo(); };  Foo::SP ";
        IASTCompletionNode iASTCompletionNode = this.parse(string, string.indexOf("SP"));
        IASTNode.ILookupResult iLookupResult = iASTCompletionNode.getCompletionScope().lookup(iASTCompletionNode.getCompletionPrefix(), new IASTNode.LookupKind[]{IASTNode.LookupKind.CONSTRUCTORS}, iASTCompletionNode.getCompletionContext(), null);
        Assert.assertEquals((int)iLookupResult.getResultsSize(), (int)1);
        IASTMethod iASTMethod = (IASTMethod)iLookupResult.getNodes().next();
        Assert.assertEquals((String)iASTMethod.getName(), (String)"Foo");
    }

    public void testBug50807() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("void foo();");
        ((Writer)stringWriter).write("void foo( int );");
        ((Writer)stringWriter).write("void foo( int, char );");
        ((Writer)stringWriter).write("void foo( int, int, int );");
        ((Writer)stringWriter).write("void bar(){ ");
        String string = String.valueOf(((Object)stringWriter).toString()) + "foo( SP";
        IASTCompletionNode iASTCompletionNode = this.parse(string, string.indexOf("SP"));
        Assert.assertEquals((String)iASTCompletionNode.getCompletionPrefix(), (String)"");
        Assert.assertEquals((String)iASTCompletionNode.getFunctionName(), (String)"foo");
        IASTNode.ILookupResult iLookupResult = iASTCompletionNode.getCompletionScope().lookup(iASTCompletionNode.getFunctionName(), new IASTNode.LookupKind[]{IASTNode.LookupKind.FUNCTIONS}, iASTCompletionNode.getCompletionContext(), null);
        Assert.assertEquals((int)iLookupResult.getResultsSize(), (int)4);
        string = String.valueOf(((Object)stringWriter).toString()) + "foo( 1, SP";
        iASTCompletionNode = this.parse(string, string.indexOf("SP"));
        Assert.assertEquals((String)iASTCompletionNode.getCompletionPrefix(), (String)"");
        Assert.assertEquals((String)iASTCompletionNode.getFunctionName(), (String)"foo");
        iLookupResult = iASTCompletionNode.getCompletionScope().lookup(iASTCompletionNode.getFunctionName(), new IASTNode.LookupKind[]{IASTNode.LookupKind.FUNCTIONS}, iASTCompletionNode.getCompletionContext(), iASTCompletionNode.getFunctionParameters());
        Assert.assertEquals((int)iLookupResult.getResultsSize(), (int)2);
    }

    public void testBug60298() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class ABC { public: ABC(); int myInt(); };\n");
        ((Writer)stringWriter).write("int ABC::");
        String string = ((Object)stringWriter).toString();
        IASTCompletionNode iASTCompletionNode = this.parse(string, string.indexOf("::") + 2);
        Assert.assertEquals((Object)iASTCompletionNode.getCompletionKind(), (Object)IASTCompletionNode.CompletionKind.SINGLE_NAME_REFERENCE);
    }

    public void testBug62344() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write(" namespace Foo{  class bar{}; }     ");
        ((Writer)stringWriter).write(" void main() {                      ");
        ((Writer)stringWriter).write("    Foo::bar * foobar = new Foo::SP ");
        String string = ((Object)stringWriter).toString();
        IASTCompletionNode iASTCompletionNode = this.parse(string, string.indexOf("SP"));
        Assert.assertEquals((Object)iASTCompletionNode.getCompletionKind(), (Object)IASTCompletionNode.CompletionKind.NEW_TYPE_REFERENCE);
    }

    public void testBug62339() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("struct Cube { int nLength; int nWidth; int nHeight; };\n");
        ((Writer)stringWriter).write("int main(int argc, char **argv) { struct Cube * pCube;\n");
        ((Writer)stringWriter).write("  pCube = (str");
        String string = ((Object)stringWriter).toString();
        IASTCompletionNode iASTCompletionNode = this.parse(string, string.indexOf("(str") + 4);
        Assert.assertNotNull((Object)iASTCompletionNode);
        boolean bl = false;
        Iterator iterator = iASTCompletionNode.getKeywords();
        while (iterator.hasNext()) {
            if (!((String)iterator.next()).equals("struct")) continue;
            bl = true;
        }
        Assert.assertTrue((boolean)bl);
    }

    public void testBug62721() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("int f() {\n");
        ((Writer)stringWriter).write("short blah;\n");
        ((Writer)stringWriter).write("int x = sizeof(bl");
        String string = ((Object)stringWriter).toString();
        IASTCompletionNode iASTCompletionNode = this.parse(string, string.indexOf("of(bl") + 3);
        Assert.assertNotNull((Object)iASTCompletionNode);
        Assert.assertEquals((Object)iASTCompletionNode.getCompletionKind(), (Object)IASTCompletionNode.CompletionKind.SINGLE_NAME_REFERENCE);
        Assert.assertNull((Object)iASTCompletionNode.getCompletionContext());
        IASTNode.LookupKind[] lookupKindArray = new IASTNode.LookupKind[]{IASTNode.LookupKind.LOCAL_VARIABLES};
        IASTNode.ILookupResult iLookupResult = iASTCompletionNode.getCompletionScope().lookup(iASTCompletionNode.getCompletionPrefix(), lookupKindArray, null, null);
        Assert.assertEquals((int)iLookupResult.getResultsSize(), (int)1);
        IASTNode iASTNode = (IASTNode)iLookupResult.getNodes().next();
        Assert.assertTrue((boolean)(iASTNode instanceof IASTVariable));
        Assert.assertEquals((String)((IASTVariable)iASTNode).getName(), (String)"blah");
    }

    public void testBug62725() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("int f() {\n");
        ((Writer)stringWriter).write(" int biSizeImage = 5;\n");
        ((Writer)stringWriter).write("for (int i = 0; i < bi ");
        String string = ((Object)stringWriter).toString();
        IASTCompletionNode iASTCompletionNode = this.parse(string, string.indexOf("< bi") + 4);
        Assert.assertNotNull((Object)iASTCompletionNode);
        Assert.assertEquals((String)iASTCompletionNode.getCompletionPrefix(), (String)"bi");
        Assert.assertNull((Object)iASTCompletionNode.getCompletionContext());
        Assert.assertTrue((boolean)(iASTCompletionNode.getCompletionScope() instanceof IASTFunction));
        Assert.assertTrue((boolean)((IASTFunction)iASTCompletionNode.getCompletionScope()).getName().equals("f"));
        Assert.assertEquals((Object)iASTCompletionNode.getCompletionKind(), (Object)IASTCompletionNode.CompletionKind.SINGLE_NAME_REFERENCE);
    }

    public void testBug62728() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("struct Temp { char * t; };");
        ((Writer)stringWriter).write("int f(Temp * t) {\n");
        ((Writer)stringWriter).write("t->t[5] = t-> ");
        String string = ((Object)stringWriter).toString();
        IASTCompletionNode iASTCompletionNode = this.parse(string, string.indexOf("= t->") + 5);
        Assert.assertNotNull((Object)iASTCompletionNode);
        Assert.assertEquals((Object)iASTCompletionNode.getCompletionKind(), (Object)IASTCompletionNode.CompletionKind.MEMBER_REFERENCE);
        Assert.assertTrue((boolean)(iASTCompletionNode.getCompletionScope() instanceof IASTFunction));
        Assert.assertTrue((boolean)((IASTFunction)iASTCompletionNode.getCompletionScope()).getName().equals("f"));
        Assert.assertNotNull((Object)iASTCompletionNode.getCompletionContext());
    }

    public void testBug64271() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("typedef int DWORD;\n");
        ((Writer)stringWriter).write("typedef char BYTE;\n");
        ((Writer)stringWriter).write("#define MAKEFOURCC(ch0, ch1, ch2, ch3)                              \\\n");
        ((Writer)stringWriter).write("((DWORD)(BYTE)(ch0) | ((DWORD)(BYTE)(ch1) << 8) |       \\\n");
        ((Writer)stringWriter).write("((DWORD)(BYTE)(ch2) << 16) | ((DWORD)(BYTE)(ch3) << 24 ))\n");
        ((Writer)stringWriter).write("enum e {\n");
        ((Writer)stringWriter).write("blah1 = 5,\n");
        ((Writer)stringWriter).write("blah2 = MAKEFOURCC('a', 'b', 'c', 'd'),\n");
        ((Writer)stringWriter).write("blah3\n");
        ((Writer)stringWriter).write("};\n");
        ((Writer)stringWriter).write("e mye = bl\n");
        String string = ((Object)stringWriter).toString();
        IASTCompletionNode iASTCompletionNode = this.parse(string, string.indexOf("= bl") + 4);
        Assert.assertNotNull((Object)iASTCompletionNode);
        Assert.assertEquals((Object)iASTCompletionNode.getCompletionKind(), (Object)IASTCompletionNode.CompletionKind.SINGLE_NAME_REFERENCE);
        Assert.assertEquals((String)iASTCompletionNode.getCompletionPrefix(), (String)"bl");
        Assert.assertNull((Object)iASTCompletionNode.getCompletionContext());
        Assert.assertFalse((boolean)iASTCompletionNode.getKeywords().hasNext());
        IASTNode.LookupKind[] lookupKindArray = new IASTNode.LookupKind[]{IASTNode.LookupKind.ENUMERATORS};
        IASTNode.ILookupResult iLookupResult = iASTCompletionNode.getCompletionScope().lookup(iASTCompletionNode.getCompletionPrefix(), lookupKindArray, null, null);
        Assert.assertNotNull((Object)iLookupResult);
        Assert.assertEquals((int)iLookupResult.getResultsSize(), (int)3);
    }

    public void testBug52988() throws Exception {
        int n = 0;
        while (n < 2) {
            ParserLanguage parserLanguage = n == 0 ? ParserLanguage.C : ParserLanguage.CPP;
            String string = "void foo() { ";
            Set set = KeywordSets.getKeywords((KeywordSetKey)KeywordSetKey.STATEMENT, (ParserLanguage)parserLanguage);
            this.validateAllKeywordsAndPrefixes(string, set, parserLanguage);
            ++n;
        }
    }

    private void validateAllKeywordsAndPrefixes(String string, Set set, ParserLanguage parserLanguage) throws Exception {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            int n = 0;
            while (n < string2.length()) {
                String string3 = string2.subSequence(0, n).toString();
                String string4 = String.valueOf(string) + string3;
                IASTCompletionNode iASTCompletionNode = this.parse(string4, string4.length() - 1, parserLanguage);
                Assert.assertNotNull((Object)iASTCompletionNode);
                Assert.assertTrue((String)("Failure on keyword=" + string2 + " prefix=" + string3), (boolean)this.setContainsKeyword(iASTCompletionNode.getKeywords(), string2));
                ++n;
            }
        }
    }

    private boolean setContainsKeyword(Iterator iterator, String string) {
        while (iterator.hasNext()) {
            if (!iterator.next().equals(string)) continue;
            return true;
        }
        return false;
    }

    public void testBug66543() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("struct packet { int a; int b; };\n");
        ((Writer)stringWriter).write("struct packet buffer[5];\n");
        ((Writer)stringWriter).write("int main(int argc, char **argv) {\n");
        ((Writer)stringWriter).write(" buffer[2].");
        String string = ((Object)stringWriter).toString();
        IASTCompletionNode iASTCompletionNode = this.parse(string, string.indexOf("[2].") + 4);
        Assert.assertNotNull((Object)iASTCompletionNode);
        Assert.assertNotNull((Object)iASTCompletionNode.getCompletionContext());
        IASTNode.LookupKind[] lookupKindArray = new IASTNode.LookupKind[]{IASTNode.LookupKind.FIELDS};
        IASTNode.ILookupResult iLookupResult = iASTCompletionNode.getCompletionScope().lookup(iASTCompletionNode.getCompletionPrefix(), lookupKindArray, iASTCompletionNode.getCompletionContext(), iASTCompletionNode.getFunctionParameters());
        Assert.assertNotNull((Object)iLookupResult);
        Assert.assertEquals((int)iLookupResult.getResultsSize(), (int)2);
    }

    public void testBug69439() throws Exception {
        String string = "float f = 123.";
        IASTCompletionNode iASTCompletionNode = this.parse(string, string.indexOf(".") + 1);
        Assert.assertNotNull((Object)iASTCompletionNode);
        Assert.assertEquals((Object)iASTCompletionNode.getCompletionKind(), (Object)IASTCompletionNode.CompletionKind.NO_SUCH_KIND);
    }
}

