/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.tests;

import java.util.ArrayList;
import java.util.Iterator;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.internal.core.parser.pst.IContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IDeferredTemplateInstance;
import org.eclipse.cdt.internal.core.parser.pst.IDerivableContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IParameterizedSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISpecializedSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;
import org.eclipse.cdt.internal.core.parser.pst.ITemplateFactory;
import org.eclipse.cdt.internal.core.parser.pst.ITemplateSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ITypeInfo;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTable;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTableException;
import org.eclipse.cdt.internal.core.parser.pst.TypeInfoProvider;

public class ParserSymbolTableTemplateTests
extends TestCase {
    public ParserSymbolTable table = null;
    public TypeInfoProvider provider = null;

    public ParserSymbolTableTemplateTests(String string) {
        super(string);
    }

    public ParserSymbolTable newTable() {
        return this.newTable(ParserLanguage.CPP);
    }

    public ParserSymbolTable newTable(ParserLanguage parserLanguage) {
        this.table = new ParserSymbolTable(parserLanguage, ParserMode.COMPLETE_PARSE);
        this.provider = this.table.getTypeInfoProvider();
        return this.table;
    }

    public void testTemplateParameterAsParent() throws Exception {
        this.newTable();
        ITemplateSymbol iTemplateSymbol = this.table.newTemplateSymbol("A".toCharArray());
        ISymbol iSymbol = this.table.newSymbol("T".toCharArray(), ITypeInfo.t_templateParameter);
        iTemplateSymbol.addTemplateParameter(iSymbol);
        ITemplateFactory iTemplateFactory = this.table.newTemplateFactory();
        iTemplateFactory.setContainingSymbol(this.table.getCompilationUnit());
        iTemplateFactory.pushTemplate(iTemplateSymbol);
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("A".toCharArray(), ITypeInfo.t_class);
        iTemplateFactory.addSymbol((ISymbol)iDerivableContainerSymbol);
        iDerivableContainerSymbol.addParent(iSymbol);
        IDerivableContainerSymbol iDerivableContainerSymbol2 = this.table.newDerivableContainerSymbol("B".toCharArray(), ITypeInfo.t_class);
        ISymbol iSymbol2 = this.table.newSymbol("i".toCharArray(), ITypeInfo.t_int);
        iDerivableContainerSymbol2.addSymbol(iSymbol2);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol2);
        ITypeInfo iTypeInfo = TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_type, (int)0, (ISymbol)iDerivableContainerSymbol2);
        ArrayList<ITypeInfo> arrayList = new ArrayList<ITypeInfo>();
        arrayList.add(iTypeInfo);
        IContainerSymbol iContainerSymbol = (IContainerSymbol)this.table.getCompilationUnit().lookupTemplateId("A".toCharArray(), arrayList);
        Assert.assertEquals((Object)iContainerSymbol.getInstantiatedSymbol(), (Object)iDerivableContainerSymbol);
        ISymbol iSymbol3 = this.table.newSymbol("a".toCharArray(), ITypeInfo.t_type);
        iSymbol3.setTypeSymbol((ISymbol)iContainerSymbol);
        this.table.getCompilationUnit().addSymbol(iSymbol3);
        ISymbol iSymbol4 = this.table.getCompilationUnit().lookup("a".toCharArray());
        Assert.assertEquals((Object)iSymbol4, (Object)iSymbol3);
        ISymbol iSymbol5 = iSymbol3.getTypeSymbol();
        Assert.assertEquals((Object)iSymbol5, (Object)iContainerSymbol);
        iSymbol4 = iContainerSymbol.lookup("i".toCharArray());
        Assert.assertEquals((Object)iSymbol4, (Object)iSymbol2);
        Assert.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void testTemplateInstanceAsParent() throws Exception {
        this.newTable();
        ITemplateSymbol iTemplateSymbol = this.table.newTemplateSymbol("A".toCharArray());
        ISymbol iSymbol = this.table.newSymbol("T".toCharArray(), ITypeInfo.t_templateParameter);
        iTemplateSymbol.addTemplateParameter(iSymbol);
        ITemplateFactory iTemplateFactory = this.table.newTemplateFactory();
        iTemplateFactory.setContainingSymbol(this.table.getCompilationUnit());
        iTemplateFactory.pushTemplate(iTemplateSymbol);
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("A".toCharArray(), ITypeInfo.t_class);
        iTemplateFactory.addSymbol((ISymbol)iDerivableContainerSymbol);
        ISymbol iSymbol2 = this.table.newSymbol("t".toCharArray(), ITypeInfo.t_type);
        ISymbol iSymbol3 = iTemplateSymbol.lookup("T".toCharArray());
        Assert.assertEquals((Object)iSymbol3, (Object)iSymbol);
        iSymbol2.setTypeSymbol(iSymbol);
        iDerivableContainerSymbol.addSymbol(iSymbol2);
        IDerivableContainerSymbol iDerivableContainerSymbol2 = this.table.newDerivableContainerSymbol("B".toCharArray(), ITypeInfo.t_class);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol2);
        ITypeInfo iTypeInfo = TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_int, (int)0, null);
        ArrayList<ITypeInfo> arrayList = new ArrayList<ITypeInfo>();
        arrayList.add(iTypeInfo);
        iSymbol3 = this.table.getCompilationUnit().lookupTemplateId("A".toCharArray(), arrayList);
        Assert.assertTrue((boolean)iSymbol3.isTemplateInstance());
        Assert.assertEquals((Object)iSymbol3.getInstantiatedSymbol(), (Object)iDerivableContainerSymbol);
        iDerivableContainerSymbol2.addParent(iSymbol3);
        ISymbol iSymbol4 = this.table.newSymbol("b".toCharArray(), ITypeInfo.t_type);
        iSymbol4.setTypeSymbol((ISymbol)iDerivableContainerSymbol2);
        this.table.getCompilationUnit().addSymbol(iSymbol4);
        iSymbol3 = this.table.getCompilationUnit().lookup("b".toCharArray());
        Assert.assertEquals((Object)iSymbol3, (Object)iSymbol4);
        iSymbol3 = ((IDerivableContainerSymbol)iSymbol4.getTypeSymbol()).lookup("t".toCharArray());
        Assert.assertTrue((boolean)iSymbol3.isTemplateInstance());
        Assert.assertEquals((Object)iSymbol3.getInstantiatedSymbol(), (Object)iSymbol2);
        Assert.assertTrue((boolean)iSymbol3.isType(ITypeInfo.t_int));
        Assert.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void testTemplateParameterDefaults() throws Exception {
        this.newTable();
        ITemplateSymbol iTemplateSymbol = this.table.newTemplateSymbol("X".toCharArray());
        ISymbol iSymbol = this.table.newSymbol("T".toCharArray(), ITypeInfo.t_templateParameter);
        iTemplateSymbol.addTemplateParameter(iSymbol);
        ISymbol iSymbol2 = iTemplateSymbol.lookup("T".toCharArray());
        Assert.assertEquals((Object)iSymbol2, (Object)iSymbol);
        ISymbol iSymbol3 = this.table.newSymbol("U".toCharArray());
        iSymbol3.setTypeInfo(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_templateParameter, (int)0, null, null, (Object)TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_type, (int)0, (ISymbol)iSymbol2)));
        iTemplateSymbol.addTemplateParameter(iSymbol3);
        ITemplateFactory iTemplateFactory = this.table.newTemplateFactory();
        iTemplateFactory.setContainingSymbol(this.table.getCompilationUnit());
        iTemplateFactory.pushTemplate(iTemplateSymbol);
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("X".toCharArray(), ITypeInfo.t_class);
        iTemplateFactory.addSymbol((ISymbol)iDerivableContainerSymbol);
        iSymbol2 = iDerivableContainerSymbol.lookup("T".toCharArray());
        Assert.assertEquals((Object)iSymbol2, (Object)iSymbol);
        ISymbol iSymbol4 = this.table.newSymbol("t".toCharArray(), ITypeInfo.t_type);
        iSymbol4.setTypeSymbol(iSymbol2);
        iDerivableContainerSymbol.addSymbol(iSymbol4);
        iSymbol2 = iDerivableContainerSymbol.lookup("U".toCharArray());
        Assert.assertEquals((Object)iSymbol2, (Object)iSymbol3);
        ISymbol iSymbol5 = this.table.newSymbol("u".toCharArray(), ITypeInfo.t_type);
        iSymbol5.setTypeSymbol(iSymbol2);
        iDerivableContainerSymbol.addSymbol(iSymbol5);
        ITypeInfo iTypeInfo = TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_char, (int)0, null);
        ArrayList<ITypeInfo> arrayList = new ArrayList<ITypeInfo>();
        arrayList.add(iTypeInfo);
        IDerivableContainerSymbol iDerivableContainerSymbol2 = (IDerivableContainerSymbol)this.table.getCompilationUnit().lookupTemplateId("X".toCharArray(), arrayList);
        Assert.assertTrue((boolean)iDerivableContainerSymbol2.isTemplateInstance());
        Assert.assertEquals((Object)iDerivableContainerSymbol2.getInstantiatedSymbol(), (Object)iDerivableContainerSymbol);
        iSymbol2 = iDerivableContainerSymbol2.lookup("t".toCharArray());
        Assert.assertTrue((boolean)iSymbol2.isTemplateInstance());
        Assert.assertEquals((Object)iSymbol2.getInstantiatedSymbol(), (Object)iSymbol4);
        Assert.assertTrue((boolean)iSymbol2.isType(ITypeInfo.t_char));
        iSymbol2 = iDerivableContainerSymbol2.lookup("u".toCharArray());
        Assert.assertTrue((boolean)iSymbol2.isTemplateInstance());
        Assert.assertEquals((Object)iSymbol2.getInstantiatedSymbol(), (Object)iSymbol5);
        Assert.assertTrue((boolean)iSymbol2.isType(ITypeInfo.t_char));
        Assert.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void testTemplateParameterAsFunctionArgument() throws Exception {
        this.newTable();
        ITemplateSymbol iTemplateSymbol = this.table.newTemplateSymbol("A".toCharArray());
        ISymbol iSymbol = this.table.newSymbol("T".toCharArray(), ITypeInfo.t_templateParameter);
        iTemplateSymbol.addTemplateParameter(iSymbol);
        ITemplateFactory iTemplateFactory = this.table.newTemplateFactory();
        iTemplateFactory.setContainingSymbol(this.table.getCompilationUnit());
        iTemplateFactory.pushTemplate(iTemplateSymbol);
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("A".toCharArray(), ITypeInfo.t_class);
        iTemplateFactory.addSymbol((ISymbol)iDerivableContainerSymbol);
        ISymbol iSymbol2 = this.table.newSymbol("t".toCharArray(), ITypeInfo.t_type);
        iSymbol2.setTypeSymbol(iSymbol);
        iDerivableContainerSymbol.addSymbol(iSymbol2);
        IDerivableContainerSymbol iDerivableContainerSymbol2 = this.table.newDerivableContainerSymbol("B".toCharArray(), ITypeInfo.t_class);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol2);
        ArrayList<ITypeInfo> arrayList = new ArrayList<ITypeInfo>();
        ITypeInfo iTypeInfo = TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_type, (int)0, (ISymbol)iDerivableContainerSymbol2);
        arrayList.add(iTypeInfo);
        IDerivableContainerSymbol iDerivableContainerSymbol3 = (IDerivableContainerSymbol)this.table.getCompilationUnit().lookupTemplateId("A".toCharArray(), arrayList);
        Assert.assertTrue((boolean)iDerivableContainerSymbol3.isTemplateInstance());
        Assert.assertEquals((Object)iDerivableContainerSymbol3.getInstantiatedSymbol(), (Object)iDerivableContainerSymbol);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("f".toCharArray(), ITypeInfo.t_function);
        iParameterizedSymbol.addParameter(ITypeInfo.t_char, 0, null, false);
        this.table.getCompilationUnit().addSymbol((ISymbol)iParameterizedSymbol);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("f".toCharArray(), ITypeInfo.t_function);
        iParameterizedSymbol2.addParameter((ISymbol)iDerivableContainerSymbol3, 0, null, false);
        this.table.getCompilationUnit().addSymbol((ISymbol)iParameterizedSymbol2);
        IParameterizedSymbol iParameterizedSymbol3 = this.table.newParameterizedSymbol("f".toCharArray(), ITypeInfo.t_function);
        iParameterizedSymbol3.addParameter(ITypeInfo.t_int, 0, null, false);
        this.table.getCompilationUnit().addSymbol((ISymbol)iParameterizedSymbol3);
        arrayList = new ArrayList();
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_type, (int)0, (ISymbol)iDerivableContainerSymbol2));
        IDerivableContainerSymbol iDerivableContainerSymbol4 = (IDerivableContainerSymbol)this.table.getCompilationUnit().lookupTemplateId("A".toCharArray(), arrayList);
        Assert.assertEquals((Object)iDerivableContainerSymbol4, (Object)iDerivableContainerSymbol3);
        ISymbol iSymbol3 = this.table.newSymbol("a".toCharArray(), ITypeInfo.t_type);
        iSymbol3.setTypeSymbol((ISymbol)iDerivableContainerSymbol3);
        this.table.getCompilationUnit().addSymbol(iSymbol3);
        ArrayList<ITypeInfo> arrayList2 = new ArrayList<ITypeInfo>();
        arrayList2.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_type, (int)0, (ISymbol)iSymbol3));
        IParameterizedSymbol iParameterizedSymbol4 = this.table.getCompilationUnit().unqualifiedFunctionLookup("f".toCharArray(), arrayList2);
        Assert.assertEquals((Object)iParameterizedSymbol4, (Object)iParameterizedSymbol2);
        Assert.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void test_14_1__3_ParameterLookup() throws Exception {
        this.newTable();
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("T".toCharArray(), ITypeInfo.t_class);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol);
        ISymbol iSymbol = this.table.newSymbol("i".toCharArray(), ITypeInfo.t_int);
        this.table.getCompilationUnit().addSymbol(iSymbol);
        ITemplateSymbol iTemplateSymbol = this.table.newTemplateSymbol("f".toCharArray());
        ISymbol iSymbol2 = this.table.newSymbol("T".toCharArray(), ITypeInfo.t_templateParameter);
        iTemplateSymbol.addTemplateParameter(iSymbol2);
        ITemplateFactory iTemplateFactory = this.table.newTemplateFactory();
        iTemplateFactory.setContainingSymbol(this.table.getCompilationUnit());
        iTemplateFactory.pushTemplate(iTemplateSymbol);
        ISymbol iSymbol3 = this.table.newSymbol("i".toCharArray(), ITypeInfo.t_templateParameter);
        iSymbol3.getTypeInfo().setTemplateParameterType(ITypeInfo.t_type);
        ISymbol iSymbol4 = iTemplateFactory.lookup("T".toCharArray());
        Assert.assertEquals((Object)iSymbol4, (Object)iSymbol2);
        iSymbol3.setTypeSymbol(iSymbol4);
        iTemplateSymbol.addTemplateParameter(iSymbol3);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("f".toCharArray(), ITypeInfo.t_function);
        ISymbol iSymbol5 = this.table.newSymbol("t".toCharArray(), ITypeInfo.t_type);
        iSymbol5.setTypeSymbol(iSymbol2);
        iParameterizedSymbol.addParameter(iSymbol5);
        iTemplateFactory.addSymbol((ISymbol)iParameterizedSymbol);
        iSymbol4 = iParameterizedSymbol.lookup("T".toCharArray());
        Assert.assertEquals((Object)iSymbol4, (Object)iSymbol2);
        iSymbol4 = iParameterizedSymbol.lookup("i".toCharArray());
        Assert.assertEquals((Object)iSymbol4, (Object)iSymbol3);
        Assert.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void test_14_1__8_ParameterAdjustment() throws Exception {
        this.newTable();
        ITemplateSymbol iTemplateSymbol = this.table.newTemplateSymbol("R".toCharArray());
        ISymbol iSymbol = this.table.newSymbol("a".toCharArray(), ITypeInfo.t_templateParameter);
        iSymbol.getTypeInfo().setTemplateParameterType(ITypeInfo.t_int);
        iSymbol.addPtrOperator(new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_pointer));
        iTemplateSymbol.addTemplateParameter(iSymbol);
        ITemplateFactory iTemplateFactory = this.table.newTemplateFactory();
        iTemplateFactory.setContainingSymbol(this.table.getCompilationUnit());
        iTemplateFactory.pushTemplate(iTemplateSymbol);
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("R".toCharArray(), ITypeInfo.t_struct);
        iTemplateFactory.addSymbol((ISymbol)iDerivableContainerSymbol);
        ITemplateSymbol iTemplateSymbol2 = this.table.newTemplateSymbol("S".toCharArray());
        ISymbol iSymbol2 = this.table.newSymbol("b".toCharArray(), ITypeInfo.t_templateParameter);
        iSymbol2.getTypeInfo().setTemplateParameterType(ITypeInfo.t_int);
        iSymbol2.addPtrOperator(new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_array));
        iTemplateSymbol2.addTemplateParameter(iSymbol2);
        iTemplateFactory = this.table.newTemplateFactory();
        iTemplateFactory.setContainingSymbol(this.table.getCompilationUnit());
        iTemplateFactory.pushTemplate(iTemplateSymbol2);
        IDerivableContainerSymbol iDerivableContainerSymbol2 = this.table.newDerivableContainerSymbol("S".toCharArray(), ITypeInfo.t_struct);
        iTemplateFactory.addSymbol((ISymbol)iDerivableContainerSymbol2);
        ISymbol iSymbol3 = this.table.getCompilationUnit().lookup("S".toCharArray());
        Assert.assertEquals((Object)iSymbol3, (Object)iTemplateSymbol2);
        Iterator iterator = iTemplateSymbol2.getParameterList().iterator();
        ISymbol iSymbol4 = (ISymbol)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator = iSymbol4.getTypeInfo().getPtrOperators().iterator();
        ITypeInfo.PtrOp ptrOp = (ITypeInfo.PtrOp)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((Object)ptrOp.getType(), (Object)ITypeInfo.PtrOp.t_pointer);
        ISymbol iSymbol5 = this.table.newSymbol("p".toCharArray(), ITypeInfo.t_int);
        iSymbol5.addPtrOperator(new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_pointer));
        this.table.getCompilationUnit().addSymbol(iSymbol5);
        ArrayList<ITypeInfo> arrayList = new ArrayList<ITypeInfo>();
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_type, (int)0, (ISymbol)iSymbol5));
        iSymbol3 = this.table.getCompilationUnit().lookupTemplateId("R".toCharArray(), arrayList);
        Assert.assertTrue((boolean)iSymbol3.isTemplateInstance());
        Assert.assertEquals((Object)iSymbol3.getInstantiatedSymbol(), (Object)iDerivableContainerSymbol);
        iSymbol3 = this.table.getCompilationUnit().lookupTemplateId("S".toCharArray(), arrayList);
        Assert.assertTrue((boolean)iSymbol3.isTemplateInstance());
        Assert.assertEquals((Object)iSymbol3.getInstantiatedSymbol(), (Object)iDerivableContainerSymbol2);
        ISymbol iSymbol6 = this.table.newSymbol("v".toCharArray(), ITypeInfo.t_int);
        iSymbol6.addPtrOperator(new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_array));
        this.table.getCompilationUnit().addSymbol(iSymbol6);
        arrayList.clear();
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_type, (int)0, (ISymbol)iSymbol6));
        iSymbol3 = this.table.getCompilationUnit().lookupTemplateId("R".toCharArray(), arrayList);
        Assert.assertTrue((boolean)iSymbol3.isTemplateInstance());
        Assert.assertEquals((Object)iSymbol3.getInstantiatedSymbol(), (Object)iDerivableContainerSymbol);
        iSymbol3 = this.table.getCompilationUnit().lookupTemplateId("S".toCharArray(), arrayList);
        Assert.assertTrue((boolean)iSymbol3.isTemplateInstance());
        Assert.assertEquals((Object)iSymbol3.getInstantiatedSymbol(), (Object)iDerivableContainerSymbol2);
        Assert.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void test_14_3__4_ParameterDefaults() throws Exception {
        this.newTable();
        ITemplateSymbol iTemplateSymbol = this.table.newTemplateSymbol("String".toCharArray());
        ISymbol iSymbol = this.table.newSymbol("T".toCharArray());
        iSymbol.setTypeInfo(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_templateParameter, (int)0, null, null, (Object)TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_char, (int)0, null)));
        iTemplateSymbol.addTemplateParameter(iSymbol);
        ITemplateFactory iTemplateFactory = this.table.newTemplateFactory();
        iTemplateFactory.setContainingSymbol(this.table.getCompilationUnit());
        iTemplateFactory.pushTemplate(iTemplateSymbol);
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("String".toCharArray(), ITypeInfo.t_class);
        iTemplateFactory.addSymbol((ISymbol)iDerivableContainerSymbol);
        ArrayList arrayList = new ArrayList();
        ISymbol iSymbol2 = this.table.getCompilationUnit().lookupTemplateId("String".toCharArray(), arrayList);
        Assert.assertTrue((boolean)iSymbol2.isTemplateInstance());
        Assert.assertEquals((Object)iSymbol2.getInstantiatedSymbol(), (Object)iDerivableContainerSymbol);
        Assert.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void test_14_3_1__2_TypeArgumentRestrictions() throws Exception {
        this.newTable();
        ITemplateSymbol iTemplateSymbol = this.table.newTemplateSymbol("X".toCharArray());
        iTemplateSymbol.addTemplateParameter(this.table.newSymbol("T".toCharArray(), ITypeInfo.t_templateParameter));
        ITemplateFactory iTemplateFactory = this.table.newTemplateFactory();
        iTemplateFactory.setContainingSymbol(this.table.getCompilationUnit());
        iTemplateFactory.pushTemplate(iTemplateSymbol);
        iTemplateFactory.addSymbol((ISymbol)this.table.newDerivableContainerSymbol("X".toCharArray(), ITypeInfo.t_class));
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("f".toCharArray(), ITypeInfo.t_function);
        this.table.getCompilationUnit().addSymbol((ISymbol)iParameterizedSymbol);
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("S".toCharArray(), ITypeInfo.t_struct);
        iParameterizedSymbol.addSymbol((ISymbol)iDerivableContainerSymbol);
        ArrayList<ITypeInfo> arrayList = new ArrayList<ITypeInfo>();
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_type, (int)0, (ISymbol)iDerivableContainerSymbol));
        try {
            iParameterizedSymbol.lookupTemplateId("X".toCharArray(), arrayList);
            Assert.assertTrue((boolean)false);
        }
        catch (ParserSymbolTableException parserSymbolTableException) {
            Assert.assertEquals((int)parserSymbolTableException.reason, (int)8);
        }
        arrayList.clear();
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_type, (int)0, (ISymbol)iDerivableContainerSymbol, (ITypeInfo.PtrOp)new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_pointer), (boolean)false));
        try {
            iParameterizedSymbol.lookupTemplateId("X".toCharArray(), arrayList);
            Assert.assertTrue((boolean)false);
        }
        catch (ParserSymbolTableException parserSymbolTableException) {
            Assert.assertEquals((int)parserSymbolTableException.reason, (int)8);
        }
        Assert.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void test_14_3_2__2_NonTypeArgumentRestrictions() throws Exception {
        this.newTable();
        ITemplateSymbol iTemplateSymbol = this.table.newTemplateSymbol("X".toCharArray());
        iTemplateSymbol.addTemplateParameter(this.table.newSymbol("T".toCharArray(), ITypeInfo.t_templateParameter));
        ISymbol iSymbol = this.table.newSymbol("p".toCharArray(), ITypeInfo.t_templateParameter);
        iSymbol.getTypeInfo().setTemplateParameterType(ITypeInfo.t_char);
        iSymbol.addPtrOperator(new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_pointer));
        iTemplateSymbol.addTemplateParameter(iSymbol);
        ITemplateFactory iTemplateFactory = this.table.newTemplateFactory();
        iTemplateFactory.setContainingSymbol(this.table.getCompilationUnit());
        iTemplateFactory.pushTemplate(iTemplateSymbol);
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("X".toCharArray(), ITypeInfo.t_class);
        iTemplateFactory.addSymbol((ISymbol)iDerivableContainerSymbol);
        ArrayList<ITypeInfo> arrayList = new ArrayList<ITypeInfo>();
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_int, (int)0, null));
        this.provider.beginTypeConstruction();
        this.provider.setType(ITypeInfo.t_char);
        this.provider.setDefaultObj((Object)"Studebaker".toCharArray());
        ITypeInfo iTypeInfo = this.provider.completeConstruction();
        iTypeInfo.addPtrOperator(new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_pointer));
        arrayList.add(iTypeInfo);
        try {
            this.table.getCompilationUnit().lookupTemplateId("X".toCharArray(), arrayList);
            Assert.assertTrue((boolean)false);
        }
        catch (ParserSymbolTableException parserSymbolTableException) {
            Assert.assertEquals((int)parserSymbolTableException.reason, (int)8);
        }
        ISymbol iSymbol2 = this.table.newSymbol("p".toCharArray(), ITypeInfo.t_char);
        iSymbol2.addPtrOperator(new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_array));
        this.table.getCompilationUnit().addSymbol(iSymbol2);
        arrayList.clear();
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_int, (int)0, null));
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_type, (int)0, (ISymbol)iSymbol2));
        ISymbol iSymbol3 = this.table.getCompilationUnit().lookupTemplateId("X".toCharArray(), arrayList);
        Assert.assertTrue((boolean)iSymbol3.isTemplateInstance());
        Assert.assertEquals((Object)iSymbol3.getInstantiatedSymbol(), (Object)iDerivableContainerSymbol);
        Assert.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void test_14_3_2__3_NonTypeArgumentRestrictions() throws Exception {
        this.newTable();
        ITemplateSymbol iTemplateSymbol = this.table.newTemplateSymbol("X".toCharArray());
        ISymbol iSymbol = this.table.newSymbol("p".toCharArray(), ITypeInfo.t_templateParameter);
        iSymbol.getTypeInfo().setTemplateParameterType(ITypeInfo.t_int);
        iSymbol.addPtrOperator(new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_pointer));
        iTemplateSymbol.addTemplateParameter(iSymbol);
        ITemplateFactory iTemplateFactory = this.table.newTemplateFactory();
        iTemplateFactory.setContainingSymbol(this.table.getCompilationUnit());
        iTemplateFactory.pushTemplate(iTemplateSymbol);
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("X".toCharArray(), ITypeInfo.t_class);
        iTemplateFactory.addSymbol((ISymbol)iDerivableContainerSymbol);
        IDerivableContainerSymbol iDerivableContainerSymbol2 = this.table.newDerivableContainerSymbol("S".toCharArray(), ITypeInfo.t_struct);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol2);
        ISymbol iSymbol2 = this.table.newSymbol("m".toCharArray(), ITypeInfo.t_int);
        iDerivableContainerSymbol2.addSymbol(iSymbol2);
        ISymbol iSymbol3 = this.table.newSymbol("s".toCharArray(), ITypeInfo.t_int);
        iSymbol3.getTypeInfo().setBit(true, 4);
        iDerivableContainerSymbol2.addSymbol(iSymbol3);
        ISymbol iSymbol4 = this.table.newSymbol("t".toCharArray(), ITypeInfo.t_int);
        iSymbol4.addPtrOperator(new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_pointer));
        iDerivableContainerSymbol2.addSymbol(iSymbol4);
        ArrayList<ITypeInfo> arrayList = new ArrayList<ITypeInfo>();
        ITypeInfo iTypeInfo = TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_type, (int)0, (ISymbol)iSymbol2);
        iTypeInfo.applyOperatorExpression(ITypeInfo.OperatorExpression.addressof);
        arrayList.add(iTypeInfo);
        try {
            this.table.getCompilationUnit().lookupTemplateId("X".toCharArray(), arrayList);
            Assert.assertTrue((boolean)false);
        }
        catch (ParserSymbolTableException parserSymbolTableException) {
            Assert.assertEquals((int)parserSymbolTableException.reason, (int)8);
        }
        arrayList.clear();
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_type, (int)0, (ISymbol)iSymbol4));
        try {
            this.table.getCompilationUnit().lookupTemplateId("X".toCharArray(), arrayList);
            Assert.assertTrue((boolean)false);
        }
        catch (ParserSymbolTableException parserSymbolTableException) {
            Assert.assertEquals((int)parserSymbolTableException.reason, (int)8);
        }
        arrayList.clear();
        iTypeInfo = TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_type, (int)0, (ISymbol)iSymbol3);
        iTypeInfo.applyOperatorExpression(ITypeInfo.OperatorExpression.addressof);
        arrayList.add(iTypeInfo);
        Assert.assertNotNull((Object)this.table.getCompilationUnit().lookupTemplateId("X".toCharArray(), arrayList));
        Assert.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void test_14_3_2__4_NonTypeArgumentRestrictions() throws Exception {
        this.newTable();
        ITemplateSymbol iTemplateSymbol = this.table.newTemplateSymbol("B".toCharArray());
        ISymbol iSymbol = this.table.newSymbol("I".toCharArray(), ITypeInfo.t_templateParameter);
        iSymbol.getTypeInfo().setTemplateParameterType(ITypeInfo.t_int);
        iSymbol.addPtrOperator(new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_reference, true, false));
        iTemplateSymbol.addTemplateParameter(iSymbol);
        ITemplateFactory iTemplateFactory = this.table.newTemplateFactory();
        iTemplateFactory.setContainingSymbol(this.table.getCompilationUnit());
        iTemplateFactory.pushTemplate(iTemplateSymbol);
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("B".toCharArray(), ITypeInfo.t_struct);
        iTemplateFactory.addSymbol((ISymbol)iDerivableContainerSymbol);
        ArrayList<ITypeInfo> arrayList = new ArrayList<ITypeInfo>();
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_int, (int)0, null, null, (Object)"1".toCharArray()));
        try {
            this.table.getCompilationUnit().lookupTemplateId("B".toCharArray(), arrayList);
            Assert.assertTrue((boolean)false);
        }
        catch (ParserSymbolTableException parserSymbolTableException) {
            Assert.assertEquals((int)parserSymbolTableException.reason, (int)8);
        }
        ISymbol iSymbol2 = this.table.newSymbol("c".toCharArray(), ITypeInfo.t_int);
        this.table.getCompilationUnit().addSymbol(iSymbol2);
        arrayList.clear();
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_type, (int)0, (ISymbol)iSymbol2));
        ISymbol iSymbol3 = this.table.getCompilationUnit().lookupTemplateId("B".toCharArray(), arrayList);
        Assert.assertTrue((boolean)iSymbol3.isTemplateInstance());
        Assert.assertEquals((Object)iSymbol3.getInstantiatedSymbol(), (Object)iDerivableContainerSymbol);
        Assert.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void test_14_3_3__2_PartialSpecialization_TemplateTemplateParameter() throws Exception {
        this.newTable();
        ITemplateSymbol iTemplateSymbol = this.table.newTemplateSymbol("A".toCharArray());
        this.table.getCompilationUnit().addSymbol((ISymbol)iTemplateSymbol);
        iTemplateSymbol.addTemplateParameter(this.table.newSymbol("T".toCharArray(), ITypeInfo.t_templateParameter));
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("A".toCharArray(), ITypeInfo.t_class);
        iTemplateSymbol.addSymbol((ISymbol)iDerivableContainerSymbol);
        ISymbol iSymbol = this.table.newSymbol("x".toCharArray(), ITypeInfo.t_int);
        iDerivableContainerSymbol.addSymbol(iSymbol);
        ISpecializedSymbol iSpecializedSymbol = this.table.newSpecializedSymbol("A".toCharArray());
        iTemplateSymbol.addSpecialization(iSpecializedSymbol);
        ISymbol iSymbol2 = this.table.newSymbol("T".toCharArray(), ITypeInfo.t_templateParameter);
        iSpecializedSymbol.addTemplateParameter(iSymbol2);
        iSpecializedSymbol.addArgument(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_type, (int)0, (ISymbol)iSymbol2, (ITypeInfo.PtrOp)new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_pointer), (boolean)false));
        IDerivableContainerSymbol iDerivableContainerSymbol2 = this.table.newDerivableContainerSymbol("A".toCharArray(), ITypeInfo.t_class);
        iSpecializedSymbol.addSymbol((ISymbol)iDerivableContainerSymbol2);
        ISymbol iSymbol3 = this.table.newSymbol("x".toCharArray(), ITypeInfo.t_int);
        iSymbol3.getTypeInfo().setBit(true, 16384);
        iDerivableContainerSymbol2.addSymbol(iSymbol3);
        ITemplateSymbol iTemplateSymbol2 = this.table.newTemplateSymbol("C".toCharArray());
        this.table.getCompilationUnit().addSymbol((ISymbol)iTemplateSymbol2);
        ITemplateSymbol iTemplateSymbol3 = this.table.newTemplateSymbol("V".toCharArray());
        iTemplateSymbol3.setTypeInfo(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_templateParameter));
        iTemplateSymbol3.getTypeInfo().setTemplateParameterType(ITypeInfo.t_template);
        ISymbol iSymbol4 = this.table.newSymbol("U".toCharArray(), ITypeInfo.t_templateParameter);
        iTemplateSymbol3.addTemplateParameter(iSymbol4);
        iTemplateSymbol2.addTemplateParameter((ISymbol)iTemplateSymbol3);
        IDerivableContainerSymbol iDerivableContainerSymbol3 = this.table.newDerivableContainerSymbol("C".toCharArray(), ITypeInfo.t_class);
        iTemplateSymbol2.addSymbol((ISymbol)iDerivableContainerSymbol3);
        ArrayList<ITypeInfo> arrayList = new ArrayList<ITypeInfo>();
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_int, (int)0, null));
        ISymbol iSymbol5 = iTemplateSymbol2.lookupTemplateId("V".toCharArray(), arrayList);
        Assert.assertTrue((iSymbol5 != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(iSymbol5 instanceof IDeferredTemplateInstance));
        ISymbol iSymbol6 = this.table.newSymbol("y".toCharArray(), ITypeInfo.t_type);
        iSymbol6.setTypeSymbol(iSymbol5);
        iDerivableContainerSymbol3.addSymbol(iSymbol6);
        arrayList.clear();
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_int, (int)0, null, (ITypeInfo.PtrOp)new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_pointer), (boolean)false));
        iSymbol5 = iTemplateSymbol2.lookupTemplateId("V".toCharArray(), arrayList);
        Assert.assertTrue((iSymbol5 != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(iSymbol5 instanceof IDeferredTemplateInstance));
        ISymbol iSymbol7 = this.table.newSymbol("z".toCharArray(), ITypeInfo.t_type);
        iSymbol7.setTypeSymbol(iSymbol5);
        iDerivableContainerSymbol3.addSymbol(iSymbol7);
        iSymbol5 = this.table.getCompilationUnit().lookup("A".toCharArray());
        Assert.assertEquals((Object)iSymbol5, (Object)iTemplateSymbol);
        arrayList.clear();
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_type, (int)0, (ISymbol)iSymbol5));
        iSymbol5 = this.table.getCompilationUnit().lookupTemplateId("C".toCharArray(), arrayList);
        Assert.assertTrue((boolean)iSymbol5.isTemplateInstance());
        Assert.assertEquals((Object)iSymbol5.getInstantiatedSymbol(), (Object)iDerivableContainerSymbol3);
        IDerivableContainerSymbol iDerivableContainerSymbol4 = (IDerivableContainerSymbol)iSymbol5;
        iSymbol5 = iDerivableContainerSymbol4.lookup("y".toCharArray());
        Assert.assertEquals((Object)iSymbol5.getType(), (Object)ITypeInfo.t_type);
        ISymbol iSymbol8 = iSymbol5.getTypeSymbol();
        Assert.assertTrue((boolean)(iSymbol8 instanceof IContainerSymbol));
        Assert.assertTrue((boolean)iSymbol8.isTemplateInstance());
        Assert.assertEquals((Object)iSymbol8.getInstantiatedSymbol(), (Object)iDerivableContainerSymbol);
        iSymbol5 = ((IContainerSymbol)iSymbol8).lookup("x".toCharArray());
        Assert.assertEquals((Object)iSymbol5.getType(), (Object)ITypeInfo.t_int);
        Assert.assertEquals((boolean)iSymbol5.getTypeInfo().checkBit(16384), (boolean)false);
        iSymbol5 = iDerivableContainerSymbol4.lookup("z".toCharArray());
        Assert.assertEquals((Object)iSymbol5.getType(), (Object)ITypeInfo.t_type);
        iSymbol8 = iSymbol5.getTypeSymbol();
        Assert.assertTrue((boolean)(iSymbol8 instanceof IContainerSymbol));
        Assert.assertTrue((boolean)iSymbol8.isTemplateInstance());
        Assert.assertEquals((Object)iSymbol8.getInstantiatedSymbol(), (Object)iDerivableContainerSymbol2);
        iSymbol5 = ((IContainerSymbol)iSymbol8).lookup("x".toCharArray());
        Assert.assertEquals((Object)iSymbol5.getType(), (Object)ITypeInfo.t_int);
        Assert.assertEquals((boolean)iSymbol5.getTypeInfo().checkBit(16384), (boolean)true);
        Assert.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void test_14_5_1__3_MemberFunctions() throws Exception {
        this.newTable();
        ITemplateSymbol iTemplateSymbol = this.table.newTemplateSymbol(ParserSymbolTable.EMPTY_NAME_ARRAY);
        ISymbol iSymbol = this.table.newSymbol("T1".toCharArray(), ITypeInfo.t_templateParameter);
        ISymbol iSymbol2 = this.table.newSymbol("T2".toCharArray(), ITypeInfo.t_templateParameter);
        iTemplateSymbol.addTemplateParameter(iSymbol);
        iTemplateSymbol.addTemplateParameter(iSymbol2);
        ITemplateFactory iTemplateFactory = this.table.newTemplateFactory();
        iTemplateFactory.setContainingSymbol(this.table.getCompilationUnit());
        iTemplateFactory.pushTemplate(iTemplateSymbol);
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("A".toCharArray(), ITypeInfo.t_class);
        iTemplateFactory.addSymbol((ISymbol)iDerivableContainerSymbol);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("f1".toCharArray(), ITypeInfo.t_function);
        ISymbol iSymbol3 = iDerivableContainerSymbol.lookup("T1".toCharArray());
        Assert.assertEquals((Object)iSymbol3, (Object)iSymbol);
        iParameterizedSymbol.setIsForwardDeclaration(true);
        iParameterizedSymbol.setReturnType(iSymbol3);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("f2".toCharArray(), ITypeInfo.t_function);
        iParameterizedSymbol2.setIsForwardDeclaration(true);
        iDerivableContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol);
        iDerivableContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol2);
        ITemplateSymbol iTemplateSymbol2 = this.table.newTemplateSymbol(ParserSymbolTable.EMPTY_NAME_ARRAY);
        ISymbol iSymbol4 = this.table.newSymbol("U".toCharArray(), ITypeInfo.t_templateParameter);
        ISymbol iSymbol5 = this.table.newSymbol("V".toCharArray(), ITypeInfo.t_templateParameter);
        iTemplateSymbol2.addTemplateParameter(iSymbol4);
        iTemplateSymbol2.addTemplateParameter(iSymbol5);
        iTemplateFactory = this.table.newTemplateFactory();
        iTemplateFactory.setContainingSymbol(this.table.getCompilationUnit());
        iTemplateFactory.pushTemplate(iTemplateSymbol2);
        ISymbol iSymbol6 = iTemplateFactory.lookup("U".toCharArray());
        Assert.assertEquals((Object)iSymbol6, (Object)iSymbol4);
        ArrayList<ITypeInfo> arrayList = new ArrayList<ITypeInfo>();
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_type, (int)0, (ISymbol)iSymbol4));
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_type, (int)0, (ISymbol)iSymbol5));
        iSymbol3 = iTemplateFactory.lookupTemplateIdForDefinition("A".toCharArray(), arrayList);
        Assert.assertEquals((Object)iSymbol3, (Object)iDerivableContainerSymbol);
        iTemplateFactory.pushTemplateId(iSymbol3, arrayList);
        IParameterizedSymbol iParameterizedSymbol3 = iTemplateFactory.lookupMethodForDefinition("f1".toCharArray(), new ArrayList());
        Assert.assertEquals((Object)iParameterizedSymbol3, (Object)iParameterizedSymbol);
        Assert.assertTrue((boolean)iParameterizedSymbol3.isForwardDeclaration());
        IParameterizedSymbol iParameterizedSymbol4 = this.table.newParameterizedSymbol("f1".toCharArray(), ITypeInfo.t_function);
        iParameterizedSymbol.setForwardSymbol((ISymbol)iParameterizedSymbol4);
        iParameterizedSymbol4.setReturnType(iSymbol6);
        iTemplateFactory.addSymbol((ISymbol)iParameterizedSymbol4);
        arrayList.clear();
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_int, (int)0, null));
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_char, (int)0, null));
        IDerivableContainerSymbol iDerivableContainerSymbol2 = (IDerivableContainerSymbol)this.table.getCompilationUnit().lookupTemplateId("A".toCharArray(), arrayList);
        Assert.assertTrue((boolean)iDerivableContainerSymbol2.isTemplateInstance());
        Assert.assertEquals((Object)iDerivableContainerSymbol2.getInstantiatedSymbol(), (Object)iDerivableContainerSymbol);
        ArrayList arrayList2 = new ArrayList();
        iSymbol3 = iDerivableContainerSymbol2.qualifiedFunctionLookup("f1".toCharArray(), arrayList2);
        Assert.assertTrue((boolean)iSymbol3.isTemplateInstance());
        Assert.assertEquals((Object)iSymbol3.getInstantiatedSymbol(), (Object)iParameterizedSymbol4);
        Assert.assertTrue((boolean)((IParameterizedSymbol)iSymbol3).getReturnType().isType(ITypeInfo.t_int));
        arrayList2.clear();
        arrayList.clear();
        iTemplateSymbol2 = this.table.newTemplateSymbol(ParserSymbolTable.EMPTY_NAME_ARRAY);
        ISymbol iSymbol7 = this.table.newSymbol("X".toCharArray(), ITypeInfo.t_templateParameter);
        ISymbol iSymbol8 = this.table.newSymbol("Y".toCharArray(), ITypeInfo.t_templateParameter);
        iTemplateSymbol2.addTemplateParameter(iSymbol7);
        iTemplateSymbol2.addTemplateParameter(iSymbol8);
        iTemplateFactory = this.table.newTemplateFactory();
        iTemplateFactory.setContainingSymbol(this.table.getCompilationUnit());
        iTemplateFactory.pushTemplate(iTemplateSymbol2);
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_type, (int)0, (ISymbol)iSymbol8));
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_type, (int)0, (ISymbol)iSymbol7));
        try {
            iSymbol3 = iTemplateFactory.lookupTemplateIdForDefinition("A".toCharArray(), arrayList);
            Assert.assertTrue((boolean)false);
        }
        catch (ParserSymbolTableException parserSymbolTableException) {
            Assert.assertEquals((int)parserSymbolTableException.reason, (int)4);
        }
        Assert.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void test_14_5_1_2_MemberClass() throws Exception {
        this.newTable();
        ITemplateSymbol iTemplateSymbol = this.table.newTemplateSymbol("A".toCharArray());
        ISymbol iSymbol = this.table.newSymbol("T".toCharArray(), ITypeInfo.t_templateParameter);
        iTemplateSymbol.addTemplateParameter(iSymbol);
        ITemplateFactory iTemplateFactory = this.table.newTemplateFactory();
        iTemplateFactory.setContainingSymbol(this.table.getCompilationUnit());
        iTemplateFactory.pushTemplate(iTemplateSymbol);
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("A".toCharArray(), ITypeInfo.t_struct);
        iTemplateFactory.addSymbol((ISymbol)iDerivableContainerSymbol);
        IDerivableContainerSymbol iDerivableContainerSymbol2 = this.table.newDerivableContainerSymbol("B".toCharArray(), ITypeInfo.t_class);
        iDerivableContainerSymbol2.setIsForwardDeclaration(true);
        iDerivableContainerSymbol.addSymbol((ISymbol)iDerivableContainerSymbol2);
        ISymbol iSymbol2 = this.table.newSymbol("U".toCharArray(), ITypeInfo.t_templateParameter);
        ITemplateSymbol iTemplateSymbol2 = this.table.newTemplateSymbol("".toCharArray());
        iTemplateSymbol2.addTemplateParameter(iSymbol2);
        iTemplateFactory = this.table.newTemplateFactory();
        iTemplateFactory.setContainingSymbol(this.table.getCompilationUnit());
        iTemplateFactory.pushTemplate(iTemplateSymbol2);
        ArrayList<ITypeInfo> arrayList = new ArrayList<ITypeInfo>();
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_type, (int)0, (ISymbol)iSymbol2));
        IContainerSymbol iContainerSymbol = iTemplateFactory.lookupTemplateIdForDefinition("A".toCharArray(), arrayList);
        Assert.assertEquals((Object)iContainerSymbol, (Object)iDerivableContainerSymbol);
        iTemplateFactory.pushTemplateId((ISymbol)iContainerSymbol, arrayList);
        ISymbol iSymbol3 = iContainerSymbol.lookupMemberForDefinition("B".toCharArray());
        Assert.assertEquals((Object)iSymbol3, (Object)iDerivableContainerSymbol2);
        IDerivableContainerSymbol iDerivableContainerSymbol3 = this.table.newDerivableContainerSymbol("B".toCharArray(), ITypeInfo.t_class);
        iSymbol3.setForwardSymbol((ISymbol)iDerivableContainerSymbol3);
        iTemplateFactory.addSymbol((ISymbol)iDerivableContainerSymbol3);
        ISymbol iSymbol4 = this.table.newSymbol("i".toCharArray(), ITypeInfo.t_type);
        iSymbol3 = iDerivableContainerSymbol3.lookup("U".toCharArray());
        Assert.assertEquals((Object)iSymbol3, (Object)iSymbol2);
        iSymbol4.setTypeSymbol(iSymbol2);
        iDerivableContainerSymbol3.addSymbol(iSymbol4);
        arrayList.clear();
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_int, (int)0, null));
        iSymbol3 = this.table.getCompilationUnit().lookupTemplateId("A".toCharArray(), arrayList);
        Assert.assertTrue((boolean)iSymbol3.isTemplateInstance());
        Assert.assertEquals((Object)iSymbol3.getInstantiatedSymbol(), (Object)iDerivableContainerSymbol);
        Assert.assertTrue((boolean)(iSymbol3 instanceof IDerivableContainerSymbol));
        iContainerSymbol = (IDerivableContainerSymbol)iSymbol3;
        iSymbol3 = iContainerSymbol.qualifiedLookup("B".toCharArray());
        Assert.assertTrue((boolean)iSymbol3.isTemplateInstance());
        Assert.assertEquals((Object)iSymbol3.getInstantiatedSymbol(), (Object)iDerivableContainerSymbol3);
        iSymbol3 = ((IDerivableContainerSymbol)iSymbol3).lookup("i".toCharArray());
        Assert.assertTrue((boolean)iSymbol3.isTemplateInstance());
        Assert.assertEquals((Object)iSymbol3.getInstantiatedSymbol(), (Object)iSymbol4);
        Assert.assertEquals((Object)iSymbol3.getType(), (Object)ITypeInfo.t_int);
        Assert.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void test_14_5_1_3_StaticDataMember() throws Exception {
        this.newTable();
        ITemplateSymbol iTemplateSymbol = this.table.newTemplateSymbol("X".toCharArray());
        ISymbol iSymbol = this.table.newSymbol("T".toCharArray(), ITypeInfo.t_templateParameter);
        iTemplateSymbol.addTemplateParameter(iSymbol);
        ITemplateFactory iTemplateFactory = this.table.newTemplateFactory();
        iTemplateFactory.setContainingSymbol(this.table.getCompilationUnit());
        iTemplateFactory.pushTemplate(iTemplateSymbol);
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("X".toCharArray(), ITypeInfo.t_class);
        iTemplateFactory.addSymbol((ISymbol)iDerivableContainerSymbol);
        ISymbol iSymbol2 = iDerivableContainerSymbol.lookup("T".toCharArray());
        Assert.assertEquals((Object)iSymbol2, (Object)iSymbol);
        ISymbol iSymbol3 = this.table.newSymbol("s".toCharArray(), ITypeInfo.t_type);
        iSymbol3.setTypeSymbol(iSymbol2);
        iSymbol3.getTypeInfo().setBit(true, 4);
        iSymbol3.setIsForwardDeclaration(true);
        iDerivableContainerSymbol.addSymbol(iSymbol3);
        ITemplateSymbol iTemplateSymbol2 = this.table.newTemplateSymbol("".toCharArray());
        ISymbol iSymbol4 = this.table.newSymbol("U".toCharArray(), ITypeInfo.t_templateParameter);
        iTemplateSymbol2.addTemplateParameter(iSymbol4);
        iTemplateFactory = this.table.newTemplateFactory();
        iTemplateFactory.setContainingSymbol(this.table.getCompilationUnit());
        iTemplateFactory.pushTemplate(iTemplateSymbol2);
        ArrayList<ITypeInfo> arrayList = new ArrayList<ITypeInfo>();
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_type, (int)0, (ISymbol)iSymbol4));
        iSymbol2 = iTemplateFactory.lookupTemplateIdForDefinition("X".toCharArray(), arrayList);
        Assert.assertEquals((Object)iSymbol2, (Object)iDerivableContainerSymbol);
        iTemplateFactory.pushTemplateId((ISymbol)iDerivableContainerSymbol, arrayList);
        iSymbol2 = ((IContainerSymbol)iSymbol2).lookupMemberForDefinition("s".toCharArray());
        Assert.assertEquals((Object)iSymbol2, (Object)iSymbol3);
        Assert.assertTrue((boolean)iSymbol2.isForwardDeclaration());
        ISymbol iSymbol5 = this.table.newSymbol("s".toCharArray(), ITypeInfo.t_type);
        iSymbol5.setTypeSymbol(iSymbol4);
        iSymbol2.setForwardSymbol(iSymbol5);
        iTemplateFactory.addSymbol(iSymbol5);
        arrayList.clear();
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_float, (int)0, null));
        iSymbol2 = this.table.getCompilationUnit().lookupTemplateId("X".toCharArray(), arrayList);
        Assert.assertTrue((boolean)iSymbol2.isTemplateInstance());
        Assert.assertEquals((Object)iSymbol2.getInstantiatedSymbol(), (Object)iDerivableContainerSymbol);
        iSymbol2 = ((IContainerSymbol)iSymbol2).qualifiedLookup("s".toCharArray());
        Assert.assertTrue((boolean)iSymbol2.isType(ITypeInfo.t_float));
        Assert.assertTrue((boolean)iSymbol2.isTemplateInstance());
        Assert.assertEquals((Object)iSymbol2.getInstantiatedSymbol(), (Object)iSymbol5);
        Assert.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void test_14_5_2__1_MemberTemplates() throws Exception {
        this.newTable();
        ITemplateSymbol iTemplateSymbol = this.table.newTemplateSymbol("string".toCharArray());
        iTemplateSymbol.addTemplateParameter(this.table.newSymbol("T".toCharArray(), ITypeInfo.t_templateParameter));
        ITemplateFactory iTemplateFactory = this.table.newTemplateFactory();
        iTemplateFactory.setContainingSymbol(this.table.getCompilationUnit());
        iTemplateFactory.pushTemplate(iTemplateSymbol);
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("string".toCharArray(), ITypeInfo.t_class);
        iTemplateFactory.addSymbol((ISymbol)iDerivableContainerSymbol);
        ITemplateSymbol iTemplateSymbol2 = this.table.newTemplateSymbol("compare".toCharArray());
        ISymbol iSymbol = this.table.newSymbol("T2".toCharArray(), ITypeInfo.t_templateParameter);
        iTemplateSymbol2.addTemplateParameter(iSymbol);
        iTemplateFactory = this.table.newTemplateFactory();
        iTemplateFactory.setContainingSymbol((IContainerSymbol)iDerivableContainerSymbol);
        iTemplateFactory.pushTemplate(iTemplateSymbol2);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("compare".toCharArray(), ITypeInfo.t_function);
        iParameterizedSymbol.setIsForwardDeclaration(true);
        iParameterizedSymbol.addParameter(iSymbol, 0, new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_reference, true, false), false);
        ISymbol iSymbol2 = this.table.newSymbol("".toCharArray(), ITypeInfo.t_type);
        iSymbol2.setTypeSymbol(iSymbol);
        iParameterizedSymbol.setReturnType(iSymbol2);
        iTemplateFactory.addSymbol((ISymbol)iParameterizedSymbol);
        ITemplateSymbol iTemplateSymbol3 = this.table.newTemplateSymbol("".toCharArray());
        ISymbol iSymbol3 = this.table.newSymbol("U".toCharArray(), ITypeInfo.t_templateParameter);
        iTemplateSymbol3.addTemplateParameter(iSymbol3);
        iTemplateFactory = this.table.newTemplateFactory();
        iTemplateFactory.setContainingSymbol(this.table.getCompilationUnit());
        iTemplateFactory.pushTemplate(iTemplateSymbol3);
        ITemplateSymbol iTemplateSymbol4 = this.table.newTemplateSymbol("".toCharArray());
        ISymbol iSymbol4 = this.table.newSymbol("V".toCharArray(), ITypeInfo.t_templateParameter);
        iTemplateSymbol4.addTemplateParameter(iSymbol4);
        iTemplateFactory.pushTemplate(iTemplateSymbol4);
        ISymbol iSymbol5 = iTemplateFactory.lookup("V".toCharArray());
        Assert.assertEquals((Object)iSymbol5, (Object)iSymbol4);
        ArrayList<ITypeInfo> arrayList = new ArrayList<ITypeInfo>();
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_type, (int)0, (ISymbol)iSymbol3));
        IContainerSymbol iContainerSymbol = iTemplateFactory.lookupTemplateIdForDefinition("string".toCharArray(), arrayList);
        Assert.assertEquals((Object)iContainerSymbol, (Object)iDerivableContainerSymbol);
        iTemplateFactory.pushTemplateId((ISymbol)iContainerSymbol, arrayList);
        arrayList.clear();
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_type, (int)0, (ISymbol)iSymbol5, (ITypeInfo.PtrOp)new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_reference, true, false), (boolean)false));
        iContainerSymbol = iContainerSymbol.lookupMethodForDefinition("compare".toCharArray(), arrayList);
        Assert.assertEquals((Object)iContainerSymbol, (Object)iParameterizedSymbol);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("compare".toCharArray(), ITypeInfo.t_function);
        iParameterizedSymbol2.addParameter(iSymbol5, 0, new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_reference, true, false), false);
        ISymbol iSymbol6 = this.table.newSymbol("".toCharArray(), ITypeInfo.t_type);
        iSymbol6.setTypeSymbol(iSymbol5);
        iParameterizedSymbol2.setReturnType(iSymbol6);
        iParameterizedSymbol.setForwardSymbol((ISymbol)iParameterizedSymbol2);
        iTemplateFactory.addSymbol((ISymbol)iParameterizedSymbol2);
        iContainerSymbol = iParameterizedSymbol2.lookup("U".toCharArray());
        Assert.assertEquals((Object)iContainerSymbol, (Object)iSymbol3);
        ISymbol iSymbol7 = this.table.newSymbol("u".toCharArray(), ITypeInfo.t_type);
        iSymbol7.setTypeSymbol((ISymbol)iContainerSymbol);
        iParameterizedSymbol2.addSymbol(iSymbol7);
        arrayList.clear();
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_int, (int)0, null));
        iContainerSymbol = this.table.getCompilationUnit().lookupTemplateId("string".toCharArray(), arrayList);
        Assert.assertTrue((boolean)iContainerSymbol.isTemplateInstance());
        Assert.assertEquals((Object)iContainerSymbol.getInstantiatedSymbol(), (Object)iDerivableContainerSymbol);
        iContainerSymbol = ((IDerivableContainerSymbol)iContainerSymbol).lookupTemplateId("compare".toCharArray(), arrayList);
        Assert.assertTrue((boolean)iContainerSymbol.isTemplateInstance());
        Assert.assertTrue((boolean)iContainerSymbol.getInstantiatedSymbol().isTemplateInstance());
        Assert.assertEquals((Object)iContainerSymbol.getInstantiatedSymbol().getInstantiatedSymbol(), (Object)iParameterizedSymbol2);
        Assert.assertTrue((boolean)((IParameterizedSymbol)iContainerSymbol).getReturnType().isType(ITypeInfo.t_int));
        iContainerSymbol = iContainerSymbol.lookup("u".toCharArray());
        Assert.assertTrue((boolean)iContainerSymbol.isTemplateInstance());
        Assert.assertTrue((boolean)iContainerSymbol.getInstantiatedSymbol().isTemplateInstance());
        Assert.assertEquals((Object)iContainerSymbol.getInstantiatedSymbol().getInstantiatedSymbol(), (Object)iSymbol7);
        Assert.assertTrue((boolean)iContainerSymbol.isType(ITypeInfo.t_int));
        Assert.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void test_14_5_2__3_VirtualMemberFunctionTemplate() throws Exception {
        this.newTable();
        ITemplateSymbol iTemplateSymbol = this.table.newTemplateSymbol("A".toCharArray());
        iTemplateSymbol.addTemplateParameter(this.table.newSymbol("T".toCharArray(), ITypeInfo.t_templateParameter));
        ITemplateFactory iTemplateFactory = this.table.newTemplateFactory();
        iTemplateFactory.setContainingSymbol(this.table.getCompilationUnit());
        iTemplateFactory.pushTemplate(iTemplateSymbol);
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("A".toCharArray(), ITypeInfo.t_struct);
        iTemplateFactory.addSymbol((ISymbol)iDerivableContainerSymbol);
        ITemplateSymbol iTemplateSymbol2 = this.table.newTemplateSymbol("g".toCharArray());
        ISymbol iSymbol = this.table.newSymbol("C".toCharArray(), ITypeInfo.t_templateParameter);
        iTemplateSymbol2.addTemplateParameter(iSymbol);
        iTemplateFactory = this.table.newTemplateFactory();
        iTemplateFactory.setContainingSymbol((IContainerSymbol)iDerivableContainerSymbol);
        iTemplateFactory.pushTemplate(iTemplateSymbol2);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("g".toCharArray(), ITypeInfo.t_function);
        iParameterizedSymbol.addParameter(iSymbol, 0, null, false);
        iParameterizedSymbol.getTypeInfo().setBit(true, 64);
        try {
            iTemplateFactory.addSymbol((ISymbol)iTemplateSymbol2);
            Assert.assertTrue((boolean)false);
        }
        catch (ParserSymbolTableException parserSymbolTableException) {
            Assert.assertEquals((int)parserSymbolTableException.reason, (int)4);
        }
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("f".toCharArray(), ITypeInfo.t_function);
        iParameterizedSymbol2.getTypeInfo().setBit(true, 64);
        iDerivableContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol2);
        Assert.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void test_14_5_4__7_PartialSpecializationLookup() throws Exception {
        this.newTable();
        IContainerSymbol iContainerSymbol = this.table.newContainerSymbol("N".toCharArray(), ITypeInfo.t_namespace);
        this.table.getCompilationUnit().addSymbol((ISymbol)iContainerSymbol);
        ITemplateSymbol iTemplateSymbol = this.table.newTemplateSymbol("A".toCharArray());
        iTemplateSymbol.addTemplateParameter(this.table.newSymbol("T1".toCharArray(), ITypeInfo.t_templateParameter));
        iTemplateSymbol.addTemplateParameter(this.table.newSymbol("T2".toCharArray(), ITypeInfo.t_templateParameter));
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("A".toCharArray(), ITypeInfo.t_class);
        iTemplateSymbol.addSymbol((ISymbol)iDerivableContainerSymbol);
        iContainerSymbol.addSymbol((ISymbol)iTemplateSymbol);
        this.table.getCompilationUnit().addUsingDeclaration("A".toCharArray(), iContainerSymbol);
        ISpecializedSymbol iSpecializedSymbol = this.table.newSpecializedSymbol("A".toCharArray());
        ISymbol iSymbol = this.table.newSymbol("T".toCharArray(), ITypeInfo.t_templateParameter);
        iSpecializedSymbol.addTemplateParameter(iSymbol);
        iSpecializedSymbol.addArgument(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_type, (int)0, (ISymbol)iSymbol));
        iSpecializedSymbol.addArgument(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_type, (int)0, (ISymbol)iSymbol, (ITypeInfo.PtrOp)new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_pointer), (boolean)false));
        IDerivableContainerSymbol iDerivableContainerSymbol2 = this.table.newDerivableContainerSymbol("A".toCharArray(), ITypeInfo.t_class);
        iSpecializedSymbol.addSymbol((ISymbol)iDerivableContainerSymbol2);
        iTemplateSymbol.addSpecialization(iSpecializedSymbol);
        ArrayList<ITypeInfo> arrayList = new ArrayList<ITypeInfo>();
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_int, (int)0, null));
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_int, (int)0, null, (ITypeInfo.PtrOp)new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_pointer), (boolean)false));
        ISymbol iSymbol2 = this.table.getCompilationUnit().lookupTemplateId("A".toCharArray(), arrayList);
        Assert.assertTrue((iSymbol2 != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)iSymbol2.isTemplateInstance());
        Assert.assertEquals((Object)iSymbol2.getInstantiatedSymbol(), (Object)iDerivableContainerSymbol2);
        Assert.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void test_14_5_4_1__2_MatchingTemplateSpecializations() throws Exception {
        this.newTable();
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("A".toCharArray(), ITypeInfo.t_class);
        IDerivableContainerSymbol iDerivableContainerSymbol2 = this.table.newDerivableContainerSymbol("A".toCharArray(), ITypeInfo.t_class);
        IDerivableContainerSymbol iDerivableContainerSymbol3 = this.table.newDerivableContainerSymbol("A".toCharArray(), ITypeInfo.t_class);
        IDerivableContainerSymbol iDerivableContainerSymbol4 = this.table.newDerivableContainerSymbol("A".toCharArray(), ITypeInfo.t_class);
        IDerivableContainerSymbol iDerivableContainerSymbol5 = this.table.newDerivableContainerSymbol("A".toCharArray(), ITypeInfo.t_class);
        ITemplateSymbol iTemplateSymbol = this.table.newTemplateSymbol("A".toCharArray());
        ISymbol iSymbol = this.table.newSymbol("T1".toCharArray(), ITypeInfo.t_templateParameter);
        ISymbol iSymbol2 = this.table.newSymbol("T2".toCharArray(), ITypeInfo.t_templateParameter);
        ISymbol iSymbol3 = this.table.newSymbol("I".toCharArray(), ITypeInfo.t_templateParameter);
        iSymbol3.getTypeInfo().setTemplateParameterType(ITypeInfo.t_int);
        iTemplateSymbol.addTemplateParameter(iSymbol);
        iTemplateSymbol.addTemplateParameter(iSymbol2);
        iTemplateSymbol.addTemplateParameter(iSymbol3);
        iTemplateSymbol.addSymbol((ISymbol)iDerivableContainerSymbol);
        this.table.getCompilationUnit().addSymbol((ISymbol)iTemplateSymbol);
        ISpecializedSymbol iSpecializedSymbol = this.table.newSpecializedSymbol("A".toCharArray());
        ISymbol iSymbol4 = this.table.newSymbol("T".toCharArray(), ITypeInfo.t_templateParameter);
        ISymbol iSymbol5 = this.table.newSymbol("I".toCharArray(), ITypeInfo.t_templateParameter);
        iSymbol5.getTypeInfo().setTemplateParameterType(ITypeInfo.t_int);
        iSpecializedSymbol.addTemplateParameter(iSymbol4);
        iSpecializedSymbol.addTemplateParameter(iSymbol5);
        ITypeInfo iTypeInfo = TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_type, (int)0, (ISymbol)iSymbol4);
        ITypeInfo iTypeInfo2 = TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_type, (int)0, (ISymbol)iSymbol4, (ITypeInfo.PtrOp)new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_pointer), (boolean)false);
        ITypeInfo iTypeInfo3 = TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_type, (int)0, (ISymbol)iSymbol5);
        iSpecializedSymbol.addArgument(iTypeInfo);
        iSpecializedSymbol.addArgument(iTypeInfo2);
        iSpecializedSymbol.addArgument(iTypeInfo3);
        iSpecializedSymbol.addSymbol((ISymbol)iDerivableContainerSymbol2);
        iTemplateSymbol.addSpecialization(iSpecializedSymbol);
        ISpecializedSymbol iSpecializedSymbol2 = this.table.newSpecializedSymbol("A".toCharArray());
        ISymbol iSymbol6 = this.table.newSymbol("T1".toCharArray(), ITypeInfo.t_templateParameter);
        ISymbol iSymbol7 = this.table.newSymbol("T2".toCharArray(), ITypeInfo.t_templateParameter);
        ISymbol iSymbol8 = this.table.newSymbol("I".toCharArray(), ITypeInfo.t_templateParameter);
        iSymbol8.getTypeInfo().setTemplateParameterType(ITypeInfo.t_int);
        iSpecializedSymbol2.addTemplateParameter(iSymbol6);
        iSpecializedSymbol2.addTemplateParameter(iSymbol7);
        iSpecializedSymbol2.addTemplateParameter(iSymbol8);
        ITypeInfo iTypeInfo4 = TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_type, (int)0, (ISymbol)iSymbol6, (ITypeInfo.PtrOp)new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_pointer), (boolean)false);
        ITypeInfo iTypeInfo5 = TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_type, (int)0, (ISymbol)iSymbol7);
        ITypeInfo iTypeInfo6 = TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_type, (int)0, (ISymbol)iSymbol8);
        iSpecializedSymbol2.addArgument(iTypeInfo4);
        iSpecializedSymbol2.addArgument(iTypeInfo5);
        iSpecializedSymbol2.addArgument(iTypeInfo6);
        iSpecializedSymbol2.addSymbol((ISymbol)iDerivableContainerSymbol3);
        iTemplateSymbol.addSpecialization(iSpecializedSymbol2);
        ISpecializedSymbol iSpecializedSymbol3 = this.table.newSpecializedSymbol("A".toCharArray());
        ISymbol iSymbol9 = this.table.newSymbol("T".toCharArray(), ITypeInfo.t_templateParameter);
        iSpecializedSymbol3.addTemplateParameter(iSymbol9);
        ITypeInfo iTypeInfo7 = TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_int, (int)0, null);
        ITypeInfo iTypeInfo8 = TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_type, (int)0, (ISymbol)iSymbol9, (ITypeInfo.PtrOp)new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_pointer), (boolean)false);
        ITypeInfo iTypeInfo9 = TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_int, (int)0, null, null, (Object)"5".toCharArray());
        iSpecializedSymbol3.addArgument(iTypeInfo7);
        iSpecializedSymbol3.addArgument(iTypeInfo8);
        iSpecializedSymbol3.addArgument(iTypeInfo9);
        iSpecializedSymbol3.addSymbol((ISymbol)iDerivableContainerSymbol4);
        iTemplateSymbol.addSpecialization(iSpecializedSymbol3);
        ISpecializedSymbol iSpecializedSymbol4 = this.table.newSpecializedSymbol("A".toCharArray());
        ISymbol iSymbol10 = this.table.newSymbol("T1".toCharArray(), ITypeInfo.t_templateParameter);
        ISymbol iSymbol11 = this.table.newSymbol("T2".toCharArray(), ITypeInfo.t_templateParameter);
        ISymbol iSymbol12 = this.table.newSymbol("I".toCharArray(), ITypeInfo.t_templateParameter);
        iSymbol12.getTypeInfo().setTemplateParameterType(ITypeInfo.t_int);
        iSpecializedSymbol4.addTemplateParameter(iSymbol10);
        iSpecializedSymbol4.addTemplateParameter(iSymbol11);
        iSpecializedSymbol4.addTemplateParameter(iSymbol12);
        ITypeInfo iTypeInfo10 = TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_type, (int)0, (ISymbol)iSymbol10);
        ITypeInfo iTypeInfo11 = TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_type, (int)0, (ISymbol)iSymbol11, (ITypeInfo.PtrOp)new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_pointer), (boolean)false);
        ITypeInfo iTypeInfo12 = TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_type, (int)0, (ISymbol)iSymbol12);
        iSpecializedSymbol4.addArgument(iTypeInfo10);
        iSpecializedSymbol4.addArgument(iTypeInfo11);
        iSpecializedSymbol4.addArgument(iTypeInfo12);
        iSpecializedSymbol4.addSymbol((ISymbol)iDerivableContainerSymbol5);
        iTemplateSymbol.addSpecialization(iSpecializedSymbol4);
        ITemplateSymbol iTemplateSymbol2 = (ITemplateSymbol)this.table.getCompilationUnit().lookup("A".toCharArray());
        Assert.assertEquals((Object)iTemplateSymbol2, (Object)iTemplateSymbol);
        ArrayList<ITypeInfo> arrayList = new ArrayList<ITypeInfo>();
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_int, (int)0, null));
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_int, (int)0, null));
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_int, (int)0, null, null, (Object)"1".toCharArray()));
        IContainerSymbol iContainerSymbol = (IContainerSymbol)iTemplateSymbol2.instantiate(arrayList);
        Assert.assertTrue((boolean)iContainerSymbol.isTemplateInstance());
        Assert.assertEquals((Object)iContainerSymbol.getInstantiatedSymbol(), (Object)iDerivableContainerSymbol);
        arrayList.clear();
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_int, (int)0, null));
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_int, (int)0, null, (ITypeInfo.PtrOp)new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_pointer), (boolean)false));
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_int, (int)0, null, null, (Object)"1".toCharArray()));
        IContainerSymbol iContainerSymbol2 = (IContainerSymbol)iTemplateSymbol2.instantiate(arrayList);
        Assert.assertTrue((boolean)iContainerSymbol2.isTemplateInstance());
        Assert.assertEquals((Object)iContainerSymbol2.getInstantiatedSymbol(), (Object)iDerivableContainerSymbol2);
        arrayList.clear();
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_int, (int)0, null));
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_char, (int)0, null, (ITypeInfo.PtrOp)new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_pointer), (boolean)false));
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_int, (int)0, null, null, (Object)"5".toCharArray()));
        IContainerSymbol iContainerSymbol3 = (IContainerSymbol)iTemplateSymbol2.instantiate(arrayList);
        Assert.assertTrue((boolean)iContainerSymbol3.isTemplateInstance());
        Assert.assertEquals((Object)iContainerSymbol3.getInstantiatedSymbol(), (Object)iDerivableContainerSymbol4);
        arrayList.clear();
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_int, (int)0, null));
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_char, (int)0, null, (ITypeInfo.PtrOp)new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_pointer), (boolean)false));
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_int, (int)0, null, null, (Object)"1".toCharArray()));
        IContainerSymbol iContainerSymbol4 = (IContainerSymbol)iTemplateSymbol2.instantiate(arrayList);
        Assert.assertTrue((boolean)iContainerSymbol4.isTemplateInstance());
        Assert.assertEquals((Object)iContainerSymbol4.getInstantiatedSymbol(), (Object)iDerivableContainerSymbol5);
        arrayList.clear();
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_int, (int)0, null, (ITypeInfo.PtrOp)new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_pointer), (boolean)false));
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_int, (int)0, null, (ITypeInfo.PtrOp)new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_pointer), (boolean)false));
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_int, (int)0, null, null, (Object)"2".toCharArray()));
        try {
            iTemplateSymbol2.instantiate(arrayList);
            Assert.assertTrue((boolean)false);
        }
        catch (ParserSymbolTableException parserSymbolTableException) {
            Assert.assertEquals((int)parserSymbolTableException.reason, (int)0);
        }
        Assert.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void test_14_5_5_2__5_OrderingFunctionTemplates_1() throws Exception {
        this.newTable();
        ITemplateSymbol iTemplateSymbol = this.table.newTemplateSymbol("f".toCharArray());
        iTemplateSymbol.addTemplateParameter(this.table.newSymbol("T".toCharArray(), ITypeInfo.t_templateParameter));
        ITemplateFactory iTemplateFactory = this.table.newTemplateFactory();
        iTemplateFactory.setContainingSymbol(this.table.getCompilationUnit());
        iTemplateFactory.pushTemplate(iTemplateSymbol);
        ISymbol iSymbol = iTemplateSymbol.lookup("T".toCharArray());
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("f".toCharArray(), ITypeInfo.t_function);
        iParameterizedSymbol.addParameter(iSymbol, 0, null, false);
        iTemplateFactory.addSymbol((ISymbol)iParameterizedSymbol);
        ITemplateSymbol iTemplateSymbol2 = this.table.newTemplateSymbol("f".toCharArray());
        iTemplateSymbol2.addTemplateParameter(this.table.newSymbol("T".toCharArray(), ITypeInfo.t_templateParameter));
        iTemplateFactory = this.table.newTemplateFactory();
        iTemplateFactory.setContainingSymbol(this.table.getCompilationUnit());
        iTemplateFactory.pushTemplate(iTemplateSymbol2);
        iSymbol = iTemplateSymbol2.lookup("T".toCharArray());
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("f".toCharArray(), ITypeInfo.t_function);
        iParameterizedSymbol2.addParameter(iSymbol, 0, new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_pointer), false);
        iTemplateFactory.addSymbol((ISymbol)iParameterizedSymbol2);
        ITemplateSymbol iTemplateSymbol3 = this.table.newTemplateSymbol("f".toCharArray());
        iTemplateSymbol3.addTemplateParameter(this.table.newSymbol("T".toCharArray(), ITypeInfo.t_templateParameter));
        iTemplateFactory = this.table.newTemplateFactory();
        iTemplateFactory.setContainingSymbol(this.table.getCompilationUnit());
        iTemplateFactory.pushTemplate(iTemplateSymbol3);
        iSymbol = iTemplateSymbol3.lookup("T".toCharArray());
        IParameterizedSymbol iParameterizedSymbol3 = this.table.newParameterizedSymbol("f".toCharArray(), ITypeInfo.t_function);
        iParameterizedSymbol3.addParameter(iSymbol, 1024, new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_pointer, false, false), false);
        iTemplateFactory.addSymbol((ISymbol)iParameterizedSymbol3);
        ISymbol iSymbol2 = this.table.newSymbol("p".toCharArray(), ITypeInfo.t_int);
        iSymbol2.getTypeInfo().setBit(true, 1024);
        iSymbol2.addPtrOperator(new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_pointer, false, false));
        this.table.getCompilationUnit().addSymbol(iSymbol2);
        ArrayList<ITypeInfo> arrayList = new ArrayList<ITypeInfo>();
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_type, (int)0, (ISymbol)iSymbol2));
        IParameterizedSymbol iParameterizedSymbol4 = this.table.getCompilationUnit().unqualifiedFunctionLookup("f".toCharArray(), arrayList);
        Assert.assertTrue((boolean)iParameterizedSymbol4.isTemplateInstance());
        Assert.assertEquals((Object)iParameterizedSymbol4.getInstantiatedSymbol(), (Object)iParameterizedSymbol3);
        Assert.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void test_14_5_5_2__5_OrderingFunctionTemplates_2() throws Exception {
        this.newTable();
        ITemplateSymbol iTemplateSymbol = this.table.newTemplateSymbol("g".toCharArray());
        iTemplateSymbol.addTemplateParameter(this.table.newSymbol("T".toCharArray(), ITypeInfo.t_templateParameter));
        ITemplateFactory iTemplateFactory = this.table.newTemplateFactory();
        iTemplateFactory.setContainingSymbol(this.table.getCompilationUnit());
        iTemplateFactory.pushTemplate(iTemplateSymbol);
        ISymbol iSymbol = iTemplateSymbol.lookup("T".toCharArray());
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("g".toCharArray(), ITypeInfo.t_function);
        iParameterizedSymbol.addParameter(iSymbol, 0, null, false);
        iTemplateFactory.addSymbol((ISymbol)iParameterizedSymbol);
        ITemplateSymbol iTemplateSymbol2 = this.table.newTemplateSymbol("g".toCharArray());
        iTemplateSymbol2.addTemplateParameter(this.table.newSymbol("T".toCharArray(), ITypeInfo.t_templateParameter));
        iTemplateFactory = this.table.newTemplateFactory();
        iTemplateFactory.setContainingSymbol(this.table.getCompilationUnit());
        iTemplateFactory.pushTemplate(iTemplateSymbol2);
        iSymbol = iTemplateSymbol2.lookup("T".toCharArray());
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("g".toCharArray(), ITypeInfo.t_function);
        iParameterizedSymbol2.addParameter(iSymbol, 0, new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_reference), false);
        iTemplateFactory.addSymbol((ISymbol)iParameterizedSymbol2);
        ISymbol iSymbol2 = this.table.newSymbol("x".toCharArray(), ITypeInfo.t_float);
        ArrayList<ITypeInfo> arrayList = new ArrayList<ITypeInfo>();
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_type, (int)0, (ISymbol)iSymbol2));
        try {
            this.table.getCompilationUnit().unqualifiedFunctionLookup("g".toCharArray(), arrayList);
            Assert.assertTrue((boolean)false);
        }
        catch (ParserSymbolTableException parserSymbolTableException) {
            Assert.assertEquals((int)parserSymbolTableException.reason, (int)0);
        }
        Assert.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void test_14_5_5_2__5_OrderingFunctionTemplates_3() throws Exception {
        this.newTable();
        ITemplateSymbol iTemplateSymbol = this.table.newTemplateSymbol("A".toCharArray());
        iTemplateSymbol.addTemplateParameter(this.table.newSymbol("T".toCharArray(), ITypeInfo.t_templateParameter));
        ITemplateFactory iTemplateFactory = this.table.newTemplateFactory();
        iTemplateFactory.setContainingSymbol(this.table.getCompilationUnit());
        iTemplateFactory.pushTemplate(iTemplateSymbol);
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("A".toCharArray(), ITypeInfo.t_struct);
        iTemplateFactory.addSymbol((ISymbol)iDerivableContainerSymbol);
        ITemplateSymbol iTemplateSymbol2 = this.table.newTemplateSymbol("h".toCharArray());
        iTemplateSymbol2.addTemplateParameter(this.table.newSymbol("T".toCharArray(), ITypeInfo.t_templateParameter));
        iTemplateFactory = this.table.newTemplateFactory();
        iTemplateFactory.setContainingSymbol(this.table.getCompilationUnit());
        iTemplateFactory.pushTemplate(iTemplateSymbol2);
        ISymbol iSymbol = iTemplateSymbol2.lookup("T".toCharArray());
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("h".toCharArray(), ITypeInfo.t_function);
        iParameterizedSymbol.addParameter(iSymbol, 1024, new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_reference, false, false), false);
        iTemplateFactory.addSymbol((ISymbol)iParameterizedSymbol);
        ITemplateSymbol iTemplateSymbol3 = this.table.newTemplateSymbol("h".toCharArray());
        iTemplateSymbol3.addTemplateParameter(this.table.newSymbol("T".toCharArray(), ITypeInfo.t_templateParameter));
        iTemplateFactory = this.table.newTemplateFactory();
        iTemplateFactory.setContainingSymbol(this.table.getCompilationUnit());
        iTemplateFactory.pushTemplate(iTemplateSymbol3);
        iSymbol = iTemplateSymbol3.lookup("T".toCharArray());
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("h".toCharArray(), ITypeInfo.t_function);
        ArrayList<ITypeInfo> arrayList = new ArrayList<ITypeInfo>();
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_type, (int)0, (ISymbol)iSymbol));
        iParameterizedSymbol2.addParameter(iTemplateSymbol.instantiate(arrayList), 0, new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_reference), false);
        iTemplateFactory.addSymbol((ISymbol)iParameterizedSymbol2);
        ISymbol iSymbol2 = this.table.newSymbol("z".toCharArray(), ITypeInfo.t_type);
        ArrayList<ITypeInfo> arrayList2 = new ArrayList<ITypeInfo>();
        arrayList2.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_int, (int)0, null));
        ISymbol iSymbol3 = this.table.getCompilationUnit().lookupTemplateId("A".toCharArray(), arrayList2);
        Assert.assertTrue((boolean)iSymbol3.isTemplateInstance());
        Assert.assertEquals((Object)iSymbol3.getInstantiatedSymbol(), (Object)iDerivableContainerSymbol);
        iSymbol2.setTypeSymbol(iSymbol3);
        ArrayList<ITypeInfo> arrayList3 = new ArrayList<ITypeInfo>();
        arrayList3.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_type, (int)0, (ISymbol)iSymbol2));
        iSymbol3 = this.table.getCompilationUnit().unqualifiedFunctionLookup("h".toCharArray(), arrayList3);
        Assert.assertTrue((boolean)iSymbol3.isTemplateInstance());
        Assert.assertEquals((Object)iSymbol3.getInstantiatedSymbol(), (Object)iParameterizedSymbol2);
        ISymbol iSymbol4 = this.table.newSymbol("z2".toCharArray(), ITypeInfo.t_type);
        iSymbol3 = this.table.getCompilationUnit().lookupTemplateId("A".toCharArray(), arrayList2);
        Assert.assertTrue((boolean)iSymbol3.isTemplateInstance());
        Assert.assertEquals((Object)iSymbol3.getInstantiatedSymbol(), (Object)iDerivableContainerSymbol);
        iSymbol4.setTypeSymbol(iSymbol3);
        iSymbol4.getTypeInfo().setBit(true, 1024);
        arrayList3.clear();
        arrayList3.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_type, (int)0, (ISymbol)iSymbol4));
        iSymbol3 = this.table.getCompilationUnit().unqualifiedFunctionLookup("h".toCharArray(), arrayList3);
        Assert.assertTrue((boolean)iSymbol3.isTemplateInstance());
        Assert.assertEquals((Object)iSymbol3.getInstantiatedSymbol(), (Object)iParameterizedSymbol);
        Assert.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void test_14_6_1__1_TemplateName() throws Exception {
        this.newTable();
        ITemplateSymbol iTemplateSymbol = this.table.newTemplateSymbol("X".toCharArray());
        ISymbol iSymbol = this.table.newSymbol("T".toCharArray(), ITypeInfo.t_templateParameter);
        iTemplateSymbol.addTemplateParameter(iSymbol);
        ITemplateFactory iTemplateFactory = this.table.newTemplateFactory();
        iTemplateFactory.setContainingSymbol(this.table.getCompilationUnit());
        iTemplateFactory.pushTemplate(iTemplateSymbol);
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("X".toCharArray(), ITypeInfo.t_class);
        iTemplateFactory.addSymbol((ISymbol)iDerivableContainerSymbol);
        ISymbol iSymbol2 = iDerivableContainerSymbol.lookup("X".toCharArray());
        Assert.assertTrue((iSymbol2 != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(iSymbol2 instanceof IDeferredTemplateInstance));
        IDeferredTemplateInstance iDeferredTemplateInstance = (IDeferredTemplateInstance)iSymbol2;
        Assert.assertEquals((Object)iDeferredTemplateInstance.getTemplate(), (Object)iTemplateSymbol);
        Iterator iterator = iDeferredTemplateInstance.getArguments().iterator();
        ITypeInfo iTypeInfo = (ITypeInfo)iterator.next();
        Assert.assertTrue((boolean)iTypeInfo.isType(ITypeInfo.t_type));
        Assert.assertEquals((Object)iTypeInfo.getTypeSymbol(), (Object)iSymbol);
        Assert.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void test_14_6_1__2_SpecializationName() throws Exception {
        this.newTable();
        ITemplateSymbol iTemplateSymbol = this.table.newTemplateSymbol("Y".toCharArray());
        ISymbol iSymbol = this.table.newSymbol("T".toCharArray(), ITypeInfo.t_templateParameter);
        iTemplateSymbol.addTemplateParameter(iSymbol);
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("Y".toCharArray(), ITypeInfo.t_class);
        iTemplateSymbol.addSymbol((ISymbol)iDerivableContainerSymbol);
        this.table.getCompilationUnit().addSymbol((ISymbol)iTemplateSymbol);
        ISpecializedSymbol iSpecializedSymbol = this.table.newSpecializedSymbol("Y".toCharArray());
        iSpecializedSymbol.addArgument(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_int, (int)0, null));
        iTemplateSymbol.addSpecialization(iSpecializedSymbol);
        IDerivableContainerSymbol iDerivableContainerSymbol2 = this.table.newDerivableContainerSymbol("Y".toCharArray(), ITypeInfo.t_class);
        iSpecializedSymbol.addSymbol((ISymbol)iDerivableContainerSymbol2);
        ISymbol iSymbol2 = iDerivableContainerSymbol2.lookup("Y".toCharArray());
        Assert.assertTrue((iSymbol2 != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)iSymbol2.isTemplateInstance());
        Assert.assertEquals((Object)iSymbol2.getInstantiatedSymbol(), (Object)iDerivableContainerSymbol2);
        Assert.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void test_14_6_1__4_ParameterRedeclaration() throws Exception {
        this.newTable();
        ITemplateSymbol iTemplateSymbol = this.table.newTemplateSymbol("Y".toCharArray());
        iTemplateSymbol.addTemplateParameter(this.table.newSymbol("T".toCharArray(), ITypeInfo.t_templateParameter));
        ISymbol iSymbol = this.table.newSymbol("i".toCharArray(), ITypeInfo.t_templateParameter);
        iSymbol.getTypeInfo().setTemplateParameterType(ITypeInfo.t_int);
        iTemplateSymbol.addTemplateParameter(iSymbol);
        ITemplateFactory iTemplateFactory = this.table.newTemplateFactory();
        iTemplateFactory.setContainingSymbol(this.table.getCompilationUnit());
        iTemplateFactory.pushTemplate(iTemplateSymbol);
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("Y".toCharArray(), ITypeInfo.t_class);
        iTemplateFactory.addSymbol((ISymbol)iDerivableContainerSymbol);
        ISymbol iSymbol2 = this.table.newSymbol("T".toCharArray(), ITypeInfo.t_int);
        try {
            iDerivableContainerSymbol.addSymbol(iSymbol2);
            Assert.assertTrue((boolean)false);
        }
        catch (ParserSymbolTableException parserSymbolTableException) {
            Assert.assertEquals((int)parserSymbolTableException.reason, (int)10);
        }
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("f".toCharArray(), ITypeInfo.t_function);
        iDerivableContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol);
        try {
            iParameterizedSymbol.addSymbol(this.table.newSymbol("T".toCharArray(), ITypeInfo.t_char));
            Assert.assertTrue((boolean)false);
        }
        catch (ParserSymbolTableException parserSymbolTableException) {
            Assert.assertEquals((int)parserSymbolTableException.reason, (int)10);
        }
        ITemplateSymbol iTemplateSymbol2 = this.table.newTemplateSymbol("X".toCharArray());
        try {
            iTemplateSymbol2.addTemplateParameter(this.table.newSymbol("X".toCharArray(), ITypeInfo.t_templateParameter));
            Assert.assertTrue((boolean)false);
        }
        catch (ParserSymbolTableException parserSymbolTableException) {
            Assert.assertEquals((int)parserSymbolTableException.reason, (int)9);
        }
        Assert.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void test_14_7_3__5_ExplicitSpecialization() throws Exception {
        this.newTable();
        ITemplateSymbol iTemplateSymbol = this.table.newTemplateSymbol("A".toCharArray());
        ISymbol iSymbol = this.table.newSymbol("T".toCharArray(), ITypeInfo.t_templateParameter);
        iTemplateSymbol.addTemplateParameter(iSymbol);
        ITemplateFactory iTemplateFactory = this.table.newTemplateFactory();
        iTemplateFactory.setContainingSymbol(this.table.getCompilationUnit());
        iTemplateFactory.pushTemplate(iTemplateSymbol);
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("A".toCharArray(), ITypeInfo.t_struct);
        iTemplateFactory.addSymbol((ISymbol)iDerivableContainerSymbol);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("f".toCharArray(), ITypeInfo.t_function);
        iParameterizedSymbol.addParameter(iSymbol, 0, null, false);
        iDerivableContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol);
        ITemplateSymbol iTemplateSymbol2 = this.table.newTemplateSymbol("".toCharArray());
        iTemplateFactory = this.table.newTemplateFactory();
        iTemplateFactory.setContainingSymbol(this.table.getCompilationUnit());
        iTemplateFactory.pushTemplate(iTemplateSymbol2);
        ArrayList<ITypeInfo> arrayList = new ArrayList<ITypeInfo>();
        iTemplateFactory = this.table.newTemplateFactory();
        iTemplateFactory.setContainingSymbol(this.table.getCompilationUnit());
        ITemplateSymbol iTemplateSymbol3 = this.table.newTemplateSymbol(ParserSymbolTable.EMPTY_NAME_ARRAY);
        iTemplateFactory.pushTemplate(iTemplateSymbol3);
        IDerivableContainerSymbol iDerivableContainerSymbol2 = this.table.newDerivableContainerSymbol("A".toCharArray(), ITypeInfo.t_struct);
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_int, (int)0, null));
        iTemplateFactory.addTemplateId((ISymbol)iDerivableContainerSymbol2, arrayList);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("f".toCharArray(), ITypeInfo.t_function);
        iParameterizedSymbol2.addParameter(ITypeInfo.t_int, 0, null, false);
        iParameterizedSymbol2.setIsForwardDeclaration(true);
        iDerivableContainerSymbol2.addSymbol((ISymbol)iParameterizedSymbol2);
        IParameterizedSymbol iParameterizedSymbol3 = this.table.newParameterizedSymbol("f".toCharArray(), ITypeInfo.t_function);
        iParameterizedSymbol3.addParameter(ITypeInfo.t_int, 0, null, false);
        IDerivableContainerSymbol iDerivableContainerSymbol3 = (IDerivableContainerSymbol)this.table.getCompilationUnit().lookupTemplateId("A".toCharArray(), arrayList);
        Assert.assertTrue((boolean)iDerivableContainerSymbol3.isTemplateInstance());
        Assert.assertEquals((Object)iDerivableContainerSymbol3.getInstantiatedSymbol(), (Object)iDerivableContainerSymbol2);
        IParameterizedSymbol iParameterizedSymbol4 = iDerivableContainerSymbol3.lookupMethodForDefinition("f".toCharArray(), arrayList);
        Assert.assertTrue((boolean)iParameterizedSymbol4.isTemplateInstance());
        Assert.assertEquals((Object)iParameterizedSymbol4.getInstantiatedSymbol(), (Object)iParameterizedSymbol2);
        iParameterizedSymbol4.setForwardSymbol((ISymbol)iParameterizedSymbol3);
        iDerivableContainerSymbol3.addSymbol((ISymbol)iParameterizedSymbol3);
        iDerivableContainerSymbol3 = (IDerivableContainerSymbol)this.table.getCompilationUnit().lookupTemplateId("A".toCharArray(), arrayList);
        iParameterizedSymbol4 = iDerivableContainerSymbol3.qualifiedFunctionLookup("f".toCharArray(), arrayList);
        Assert.assertEquals((Object)iParameterizedSymbol4, (Object)iParameterizedSymbol3);
        Assert.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void test_14_7_3__11_ExplicitSpecializationArgumentDeduction() throws Exception {
        this.newTable();
        ITemplateSymbol iTemplateSymbol = this.table.newTemplateSymbol("Array".toCharArray());
        iTemplateSymbol.addTemplateParameter(this.table.newSymbol("T".toCharArray(), ITypeInfo.t_templateParameter));
        ITemplateFactory iTemplateFactory = this.table.newTemplateFactory();
        iTemplateFactory.setContainingSymbol(this.table.getCompilationUnit());
        iTemplateFactory.pushTemplate(iTemplateSymbol);
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("Array".toCharArray(), ITypeInfo.t_class);
        iTemplateFactory.addSymbol((ISymbol)iDerivableContainerSymbol);
        ITemplateSymbol iTemplateSymbol2 = this.table.newTemplateSymbol("sort".toCharArray());
        ISymbol iSymbol = this.table.newSymbol("T".toCharArray(), ITypeInfo.t_templateParameter);
        iTemplateSymbol2.addTemplateParameter(iSymbol);
        iTemplateFactory = this.table.newTemplateFactory();
        iTemplateFactory.setContainingSymbol(this.table.getCompilationUnit());
        iTemplateFactory.pushTemplate(iTemplateSymbol2);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("sort".toCharArray(), ITypeInfo.t_function);
        ArrayList<ITypeInfo> arrayList = new ArrayList<ITypeInfo>();
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_type, (int)0, (ISymbol)iSymbol));
        ISymbol iSymbol2 = iTemplateFactory.lookupTemplateId("Array".toCharArray(), arrayList);
        iParameterizedSymbol.addParameter(iSymbol2, 0, new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_reference), false);
        iTemplateFactory.addSymbol((ISymbol)iParameterizedSymbol);
        ITemplateSymbol iTemplateSymbol3 = this.table.newTemplateSymbol("".toCharArray());
        iTemplateFactory = this.table.newTemplateFactory();
        iTemplateFactory.setContainingSymbol(this.table.getCompilationUnit());
        iTemplateFactory.pushTemplate(iTemplateSymbol3);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("sort".toCharArray(), ITypeInfo.t_function);
        arrayList.clear();
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_int, (int)0, null));
        iSymbol2 = this.table.getCompilationUnit().lookupTemplateId("Array".toCharArray(), arrayList);
        Assert.assertTrue((boolean)iSymbol2.isTemplateInstance());
        Assert.assertEquals((Object)iSymbol2.getInstantiatedSymbol(), (Object)iDerivableContainerSymbol);
        iParameterizedSymbol2.addParameter(iSymbol2, 0, new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_reference), false);
        iTemplateFactory.addSymbol((ISymbol)iParameterizedSymbol2);
        ISymbol iSymbol3 = this.table.newSymbol("a".toCharArray(), ITypeInfo.t_type);
        iSymbol3.setTypeSymbol(iSymbol2);
        arrayList.clear();
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_type, (int)0, (ISymbol)iSymbol3));
        IParameterizedSymbol iParameterizedSymbol3 = this.table.getCompilationUnit().unqualifiedFunctionLookup("sort".toCharArray(), arrayList);
        Assert.assertTrue((boolean)iParameterizedSymbol3.isTemplateInstance());
        Assert.assertEquals((Object)iParameterizedSymbol3.getInstantiatedSymbol(), (Object)iParameterizedSymbol2);
        Assert.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void test_14_7_3__12_ExplicitSpecializationOverloadedFunction() throws Exception {
        this.newTable();
        ITemplateSymbol iTemplateSymbol = this.table.newTemplateSymbol("f".toCharArray());
        ISymbol iSymbol = this.table.newSymbol("T".toCharArray(), ITypeInfo.t_templateParameter);
        iTemplateSymbol.addTemplateParameter(iSymbol);
        ITemplateFactory iTemplateFactory = this.table.newTemplateFactory();
        iTemplateFactory.setContainingSymbol(this.table.getCompilationUnit());
        iTemplateFactory.pushTemplate(iTemplateSymbol);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("f".toCharArray(), ITypeInfo.t_function);
        iParameterizedSymbol.addParameter(iSymbol, 0, null, false);
        iTemplateFactory.addSymbol((ISymbol)iParameterizedSymbol);
        ITemplateSymbol iTemplateSymbol2 = this.table.newTemplateSymbol("f".toCharArray());
        ISymbol iSymbol2 = this.table.newSymbol("T".toCharArray(), ITypeInfo.t_templateParameter);
        iTemplateSymbol2.addTemplateParameter(iSymbol2);
        iTemplateFactory = this.table.newTemplateFactory();
        iTemplateFactory.setContainingSymbol(this.table.getCompilationUnit());
        iTemplateFactory.pushTemplate(iTemplateSymbol2);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("f".toCharArray(), ITypeInfo.t_function);
        iParameterizedSymbol2.addParameter(iSymbol2, 0, new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_pointer), false);
        iTemplateFactory.addSymbol((ISymbol)iParameterizedSymbol2);
        iTemplateFactory = this.table.newTemplateFactory();
        ITemplateSymbol iTemplateSymbol3 = this.table.newTemplateSymbol(ParserSymbolTable.EMPTY_NAME_ARRAY);
        iTemplateFactory.setContainingSymbol(this.table.getCompilationUnit());
        iTemplateFactory.pushTemplate(iTemplateSymbol3);
        IParameterizedSymbol iParameterizedSymbol3 = this.table.newParameterizedSymbol("f".toCharArray(), ITypeInfo.t_function);
        iParameterizedSymbol3.addParameter(ITypeInfo.t_int, 0, new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_pointer), false);
        ArrayList<ITypeInfo> arrayList = new ArrayList<ITypeInfo>();
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_int, (int)0, null, (ITypeInfo.PtrOp)new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_pointer), (boolean)false));
        iTemplateFactory.addTemplateId((ISymbol)iParameterizedSymbol3, arrayList);
        arrayList = new ArrayList();
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_int, (int)0, null));
        iTemplateSymbol3 = this.table.newTemplateSymbol(ParserSymbolTable.EMPTY_NAME_ARRAY);
        iTemplateFactory = this.table.newTemplateFactory();
        iTemplateFactory.setContainingSymbol(this.table.getCompilationUnit());
        iTemplateFactory.pushTemplate(iTemplateSymbol3);
        IParameterizedSymbol iParameterizedSymbol4 = this.table.newParameterizedSymbol("f".toCharArray(), ITypeInfo.t_function);
        iParameterizedSymbol4.addParameter(ITypeInfo.t_int, 0, new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_pointer), false);
        iTemplateFactory.addTemplateId((ISymbol)iParameterizedSymbol4, arrayList);
        arrayList.clear();
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_char, (int)0, null));
        iTemplateSymbol3 = this.table.newTemplateSymbol(ParserSymbolTable.EMPTY_NAME_ARRAY);
        iTemplateFactory = this.table.newTemplateFactory();
        iTemplateFactory.setContainingSymbol(this.table.getCompilationUnit());
        iTemplateFactory.pushTemplate(iTemplateSymbol3);
        IParameterizedSymbol iParameterizedSymbol5 = this.table.newParameterizedSymbol("f".toCharArray(), ITypeInfo.t_function);
        iParameterizedSymbol5.addParameter(ITypeInfo.t_char, 0, null, false);
        iTemplateFactory.addSymbol((ISymbol)iParameterizedSymbol5);
        arrayList.clear();
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_char, (int)0, null));
        IParameterizedSymbol iParameterizedSymbol6 = this.table.getCompilationUnit().unqualifiedFunctionLookup("f".toCharArray(), arrayList);
        Assert.assertTrue((boolean)iParameterizedSymbol6.isTemplateInstance());
        Assert.assertEquals((Object)iParameterizedSymbol6.getInstantiatedSymbol(), (Object)iParameterizedSymbol5);
        Assert.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void test_14_8_2_4__5_ArgumentDeduction() throws Exception {
        this.newTable();
        ITemplateSymbol iTemplateSymbol = this.table.newTemplateSymbol("f".toCharArray());
        ISymbol iSymbol = this.table.newSymbol("T".toCharArray(), ITypeInfo.t_templateParameter);
        iTemplateSymbol.addTemplateParameter(iSymbol);
        ITemplateFactory iTemplateFactory = this.table.newTemplateFactory();
        iTemplateFactory.setContainingSymbol(this.table.getCompilationUnit());
        iTemplateFactory.pushTemplate(iTemplateSymbol);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("f".toCharArray(), ITypeInfo.t_function);
        ISymbol iSymbol2 = iTemplateSymbol.lookup("T".toCharArray());
        Assert.assertEquals((Object)iSymbol2, (Object)iSymbol);
        ISymbol iSymbol3 = this.table.newSymbol("x".toCharArray(), ITypeInfo.t_type);
        iSymbol3.setTypeSymbol(iSymbol2);
        ISymbol iSymbol4 = this.table.newSymbol("y".toCharArray(), ITypeInfo.t_type);
        iSymbol4.setTypeSymbol(iSymbol2);
        iParameterizedSymbol.addParameter(iSymbol3);
        iParameterizedSymbol.addParameter(iSymbol4);
        iTemplateFactory.addSymbol((ISymbol)iParameterizedSymbol);
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("A".toCharArray(), ITypeInfo.t_struct);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol);
        IDerivableContainerSymbol iDerivableContainerSymbol2 = this.table.newDerivableContainerSymbol("B".toCharArray(), ITypeInfo.t_struct);
        iDerivableContainerSymbol2.addParent((ISymbol)iDerivableContainerSymbol);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol2);
        ISymbol iSymbol5 = this.table.newSymbol("a".toCharArray(), ITypeInfo.t_type);
        iSymbol5.setTypeSymbol((ISymbol)iDerivableContainerSymbol);
        ISymbol iSymbol6 = this.table.newSymbol("b".toCharArray(), ITypeInfo.t_type);
        iSymbol6.setTypeSymbol((ISymbol)iDerivableContainerSymbol2);
        this.table.getCompilationUnit().addSymbol(iSymbol5);
        this.table.getCompilationUnit().addSymbol(iSymbol6);
        ArrayList<ITypeInfo> arrayList = new ArrayList<ITypeInfo>();
        ITypeInfo iTypeInfo = TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_type, (int)0, (ISymbol)iSymbol5);
        ITypeInfo iTypeInfo2 = TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_type, (int)0, (ISymbol)iSymbol6);
        arrayList.add(iTypeInfo);
        arrayList.add(iTypeInfo2);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.getCompilationUnit().unqualifiedFunctionLookup("f".toCharArray(), arrayList);
        Assert.assertEquals((Object)iParameterizedSymbol2, null);
        arrayList.clear();
        arrayList.add(iTypeInfo2);
        arrayList.add(iTypeInfo);
        iParameterizedSymbol2 = this.table.getCompilationUnit().unqualifiedFunctionLookup("f".toCharArray(), arrayList);
        Assert.assertEquals((Object)iParameterizedSymbol2, null);
        arrayList.clear();
        arrayList.add(iTypeInfo);
        arrayList.add(iTypeInfo);
        iParameterizedSymbol2 = this.table.getCompilationUnit().unqualifiedFunctionLookup("f".toCharArray(), arrayList);
        Assert.assertTrue((boolean)iParameterizedSymbol2.isTemplateInstance());
        Assert.assertEquals((Object)iParameterizedSymbol2.getInstantiatedSymbol(), (Object)iParameterizedSymbol);
        arrayList.clear();
        arrayList.add(iTypeInfo2);
        arrayList.add(iTypeInfo2);
        iParameterizedSymbol2 = this.table.getCompilationUnit().unqualifiedFunctionLookup("f".toCharArray(), arrayList);
        Assert.assertTrue((boolean)iParameterizedSymbol2.isTemplateInstance());
        Assert.assertEquals((Object)iParameterizedSymbol2.getInstantiatedSymbol(), (Object)iParameterizedSymbol);
        Assert.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void test_14_8_2_4__6_ArgumentDeduction() throws Exception {
        this.newTable();
        ITemplateSymbol iTemplateSymbol = this.table.newTemplateSymbol("f".toCharArray());
        iTemplateSymbol.addTemplateParameter(this.table.newSymbol("T".toCharArray(), ITypeInfo.t_templateParameter));
        iTemplateSymbol.addTemplateParameter(this.table.newSymbol("U".toCharArray(), ITypeInfo.t_templateParameter));
        ITemplateFactory iTemplateFactory = this.table.newTemplateFactory();
        iTemplateFactory.setContainingSymbol(this.table.getCompilationUnit());
        iTemplateFactory.pushTemplate(iTemplateSymbol);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("".toCharArray(), ITypeInfo.t_function);
        iParameterizedSymbol.setIsTemplateMember(true);
        ISymbol iSymbol = iTemplateSymbol.lookup("T".toCharArray());
        ISymbol iSymbol2 = iTemplateSymbol.lookup("U".toCharArray());
        iParameterizedSymbol.setReturnType(iSymbol);
        iParameterizedSymbol.addParameter(iSymbol, 0, null, false);
        iParameterizedSymbol.addParameter(iSymbol2, 0, null, false);
        iParameterizedSymbol.addParameter(iSymbol2, 0, null, false);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("f".toCharArray(), ITypeInfo.t_function);
        iParameterizedSymbol2.addParameter((ISymbol)iParameterizedSymbol, 0, null, false);
        iTemplateFactory.addSymbol((ISymbol)iParameterizedSymbol2);
        IParameterizedSymbol iParameterizedSymbol3 = this.table.newParameterizedSymbol("g1".toCharArray(), ITypeInfo.t_function);
        iParameterizedSymbol3.setReturnType(this.table.newSymbol("".toCharArray(), ITypeInfo.t_int));
        iParameterizedSymbol3.addParameter(ITypeInfo.t_int, 0, null, false);
        iParameterizedSymbol3.addParameter(ITypeInfo.t_float, 0, null, false);
        iParameterizedSymbol3.addParameter(ITypeInfo.t_float, 0, null, false);
        this.table.getCompilationUnit().addSymbol((ISymbol)iParameterizedSymbol3);
        IParameterizedSymbol iParameterizedSymbol4 = this.table.newParameterizedSymbol("g2".toCharArray(), ITypeInfo.t_function);
        iParameterizedSymbol4.setReturnType(this.table.newSymbol("".toCharArray(), ITypeInfo.t_char));
        iParameterizedSymbol4.addParameter(ITypeInfo.t_int, 0, null, false);
        iParameterizedSymbol4.addParameter(ITypeInfo.t_float, 0, null, false);
        iParameterizedSymbol4.addParameter(ITypeInfo.t_float, 0, null, false);
        this.table.getCompilationUnit().addSymbol((ISymbol)iParameterizedSymbol4);
        IParameterizedSymbol iParameterizedSymbol5 = this.table.newParameterizedSymbol("g3".toCharArray(), ITypeInfo.t_function);
        iParameterizedSymbol5.setReturnType(this.table.newSymbol("".toCharArray(), ITypeInfo.t_int));
        iParameterizedSymbol5.addParameter(ITypeInfo.t_int, 0, null, false);
        iParameterizedSymbol5.addParameter(ITypeInfo.t_char, 0, null, false);
        iParameterizedSymbol5.addParameter(ITypeInfo.t_float, 0, null, false);
        this.table.getCompilationUnit().addSymbol((ISymbol)iParameterizedSymbol5);
        ITypeInfo iTypeInfo = TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_type, (int)0, (ISymbol)iParameterizedSymbol3);
        ArrayList<ITypeInfo> arrayList = new ArrayList<ITypeInfo>();
        arrayList.add(iTypeInfo);
        IParameterizedSymbol iParameterizedSymbol6 = this.table.getCompilationUnit().unqualifiedFunctionLookup("f".toCharArray(), arrayList);
        Assert.assertTrue((boolean)iParameterizedSymbol6.isTemplateInstance());
        Assert.assertEquals((Object)iParameterizedSymbol6.getInstantiatedSymbol(), (Object)iParameterizedSymbol2);
        iTypeInfo.setTypeSymbol((ISymbol)iParameterizedSymbol4);
        iParameterizedSymbol6 = this.table.getCompilationUnit().unqualifiedFunctionLookup("f".toCharArray(), arrayList);
        Assert.assertEquals((Object)iParameterizedSymbol6, null);
        iTypeInfo.setTypeSymbol((ISymbol)iParameterizedSymbol5);
        iParameterizedSymbol6 = this.table.getCompilationUnit().unqualifiedFunctionLookup("f".toCharArray(), arrayList);
        Assert.assertEquals((Object)iParameterizedSymbol6, null);
        Assert.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void test_14_8_2_4__7_ArgumentDeduction() throws Exception {
        this.newTable();
        ITemplateSymbol iTemplateSymbol = this.table.newTemplateSymbol("f".toCharArray());
        ISymbol iSymbol = this.table.newSymbol("T".toCharArray(), ITypeInfo.t_templateParameter);
        iTemplateSymbol.addTemplateParameter(iSymbol);
        ITemplateFactory iTemplateFactory = this.table.newTemplateFactory();
        iTemplateFactory.setContainingSymbol(this.table.getCompilationUnit());
        iTemplateFactory.pushTemplate(iTemplateSymbol);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("f".toCharArray(), ITypeInfo.t_function);
        iParameterizedSymbol.addParameter(iSymbol, 0, new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_pointer, true, false), false);
        iTemplateFactory.addSymbol((ISymbol)iParameterizedSymbol);
        ISymbol iSymbol2 = this.table.newSymbol("p".toCharArray(), ITypeInfo.t_int);
        iSymbol2.addPtrOperator(new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_pointer));
        ArrayList<ITypeInfo> arrayList = new ArrayList<ITypeInfo>();
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_type, (int)0, (ISymbol)iSymbol2));
        IParameterizedSymbol iParameterizedSymbol2 = this.table.getCompilationUnit().unqualifiedFunctionLookup("f".toCharArray(), arrayList);
        Assert.assertTrue((iParameterizedSymbol2 != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)iParameterizedSymbol2.isTemplateInstance());
        Assert.assertEquals((Object)iParameterizedSymbol2.getInstantiatedSymbol(), (Object)iParameterizedSymbol);
        IParameterizedSymbol iParameterizedSymbol3 = iParameterizedSymbol2;
        Iterator iterator = iParameterizedSymbol3.getParameterList().iterator();
        ISymbol iSymbol3 = (ISymbol)iterator.next();
        Assert.assertTrue((boolean)iSymbol3.isType(ITypeInfo.t_int));
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator = iSymbol3.getTypeInfo().getPtrOperators().iterator();
        ITypeInfo.PtrOp ptrOp = (ITypeInfo.PtrOp)iterator.next();
        Assert.assertTrue((boolean)ptrOp.isConst());
        Assert.assertEquals((Object)ptrOp.getType(), (Object)ITypeInfo.PtrOp.t_pointer);
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void test_14_8_2_4__8_ArgumentDeduction() throws Exception {
        this.newTable();
        ITemplateSymbol iTemplateSymbol = this.table.newTemplateSymbol("B".toCharArray());
        iTemplateSymbol.addTemplateParameter(this.table.newSymbol("T".toCharArray(), ITypeInfo.t_templateParameter));
        ITemplateFactory iTemplateFactory = this.table.newTemplateFactory();
        iTemplateFactory.setContainingSymbol(this.table.getCompilationUnit());
        iTemplateFactory.pushTemplate(iTemplateSymbol);
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("B".toCharArray(), ITypeInfo.t_struct);
        iTemplateFactory.addSymbol((ISymbol)iDerivableContainerSymbol);
        ITemplateSymbol iTemplateSymbol2 = this.table.newTemplateSymbol("D".toCharArray());
        iTemplateSymbol2.addTemplateParameter(this.table.newSymbol("T".toCharArray(), ITypeInfo.t_templateParameter));
        iTemplateFactory = this.table.newTemplateFactory();
        iTemplateFactory.setContainingSymbol(this.table.getCompilationUnit());
        iTemplateFactory.pushTemplate(iTemplateSymbol2);
        IDerivableContainerSymbol iDerivableContainerSymbol2 = this.table.newDerivableContainerSymbol("D".toCharArray(), ITypeInfo.t_struct);
        iTemplateFactory.addSymbol((ISymbol)iDerivableContainerSymbol2);
        ISymbol iSymbol = iTemplateSymbol2.lookup("T".toCharArray());
        ArrayList<ITypeInfo> arrayList = new ArrayList<ITypeInfo>();
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_type, (int)0, (ISymbol)iSymbol));
        ISymbol iSymbol2 = this.table.getCompilationUnit().lookupTemplateId("B".toCharArray(), arrayList);
        Assert.assertTrue((boolean)(iSymbol2 instanceof IDeferredTemplateInstance));
        Assert.assertEquals((Object)((IDeferredTemplateInstance)iSymbol2).getTemplate(), (Object)iTemplateSymbol);
        iDerivableContainerSymbol2.addParent(iSymbol2);
        IDerivableContainerSymbol iDerivableContainerSymbol3 = this.table.newDerivableContainerSymbol("D2".toCharArray(), ITypeInfo.t_struct);
        arrayList.clear();
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_int, (int)0, null));
        iSymbol2 = this.table.getCompilationUnit().lookupTemplateId("B".toCharArray(), arrayList);
        Assert.assertTrue((boolean)iSymbol2.isTemplateInstance());
        Assert.assertEquals((Object)iSymbol2.getInstantiatedSymbol(), (Object)iDerivableContainerSymbol);
        iDerivableContainerSymbol3.addParent(iSymbol2);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol3);
        ITemplateSymbol iTemplateSymbol3 = this.table.newTemplateSymbol("f".toCharArray());
        iSymbol = this.table.newSymbol("T".toCharArray(), ITypeInfo.t_templateParameter);
        iTemplateSymbol3.addTemplateParameter(iSymbol);
        iTemplateFactory = this.table.newTemplateFactory();
        iTemplateFactory.setContainingSymbol(this.table.getCompilationUnit());
        iTemplateFactory.pushTemplate(iTemplateSymbol3);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("f".toCharArray(), ITypeInfo.t_function);
        arrayList.clear();
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_type, (int)0, (ISymbol)iSymbol));
        iSymbol2 = this.table.getCompilationUnit().lookupTemplateId("B".toCharArray(), arrayList);
        Assert.assertTrue((boolean)(iSymbol2 instanceof IDeferredTemplateInstance));
        Assert.assertEquals((Object)((IDeferredTemplateInstance)iSymbol2).getTemplate(), (Object)iTemplateSymbol);
        ISymbol iSymbol3 = this.table.newSymbol("".toCharArray(), ITypeInfo.t_type);
        iSymbol3.setTypeSymbol(iSymbol2);
        iSymbol3.addPtrOperator(new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_reference));
        iParameterizedSymbol.addParameter(iSymbol3);
        iTemplateFactory.addSymbol((ISymbol)iParameterizedSymbol);
        ISymbol iSymbol4 = this.table.newSymbol("d".toCharArray(), ITypeInfo.t_type);
        arrayList.clear();
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_int, (int)0, null));
        iSymbol2 = this.table.getCompilationUnit().lookupTemplateId("D".toCharArray(), arrayList);
        Assert.assertTrue((boolean)iSymbol2.isTemplateInstance());
        Assert.assertEquals((Object)iSymbol2.getInstantiatedSymbol(), (Object)iDerivableContainerSymbol2);
        iSymbol4.setTypeSymbol(iSymbol2);
        this.table.getCompilationUnit().addSymbol(iSymbol4);
        ISymbol iSymbol5 = this.table.newSymbol("d2".toCharArray(), ITypeInfo.t_type);
        iSymbol5.setTypeSymbol((ISymbol)iDerivableContainerSymbol3);
        this.table.getCompilationUnit().addSymbol(iSymbol5);
        arrayList.clear();
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_type, (int)0, (ISymbol)iSymbol4));
        iSymbol2 = this.table.getCompilationUnit().unqualifiedFunctionLookup("f".toCharArray(), arrayList);
        Assert.assertTrue((iSymbol2 != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)iSymbol2.isTemplateInstance());
        Assert.assertEquals((Object)iSymbol2.getInstantiatedSymbol(), (Object)iParameterizedSymbol);
        arrayList.clear();
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_type, (int)0, (ISymbol)iSymbol5));
        IParameterizedSymbol iParameterizedSymbol2 = this.table.getCompilationUnit().unqualifiedFunctionLookup("f".toCharArray(), arrayList);
        Assert.assertTrue((iParameterizedSymbol2 != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)iParameterizedSymbol2.isTemplateInstance());
        Assert.assertEquals((Object)iParameterizedSymbol2.getInstantiatedSymbol(), (Object)iParameterizedSymbol);
        Assert.assertEquals((Object)iSymbol2, (Object)iParameterizedSymbol2);
        Assert.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void testPartialSpecializationDefinitions() throws Exception {
        this.newTable();
        ITemplateSymbol iTemplateSymbol = this.table.newTemplateSymbol("A".toCharArray());
        ISymbol iSymbol = this.table.newSymbol("T1".toCharArray(), ITypeInfo.t_templateParameter);
        ISymbol iSymbol2 = this.table.newSymbol("T2".toCharArray(), ITypeInfo.t_templateParameter);
        iTemplateSymbol.addTemplateParameter(iSymbol);
        iTemplateSymbol.addTemplateParameter(iSymbol2);
        ITemplateFactory iTemplateFactory = this.table.newTemplateFactory();
        iTemplateFactory.setContainingSymbol(this.table.getCompilationUnit());
        iTemplateFactory.pushTemplate(iTemplateSymbol);
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("A".toCharArray(), ITypeInfo.t_class);
        iTemplateFactory.addSymbol((ISymbol)iDerivableContainerSymbol);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("f".toCharArray(), ITypeInfo.t_function);
        iParameterizedSymbol.setIsForwardDeclaration(true);
        iDerivableContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol);
        ITemplateSymbol iTemplateSymbol2 = this.table.newTemplateSymbol("".toCharArray());
        ISymbol iSymbol3 = this.table.newSymbol("T".toCharArray(), ITypeInfo.t_templateParameter);
        iTemplateSymbol2.addTemplateParameter(iSymbol3);
        iTemplateFactory = this.table.newTemplateFactory();
        iTemplateFactory.setContainingSymbol(this.table.getCompilationUnit());
        iTemplateFactory.pushTemplate(iTemplateSymbol2);
        ArrayList<ITypeInfo> arrayList = new ArrayList<ITypeInfo>();
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_type, (int)0, (ISymbol)iSymbol3));
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_type, (int)0, (ISymbol)iSymbol3));
        IDerivableContainerSymbol iDerivableContainerSymbol2 = this.table.newDerivableContainerSymbol("A".toCharArray(), ITypeInfo.t_class);
        iTemplateFactory.addTemplateId((ISymbol)iDerivableContainerSymbol2, arrayList);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("f".toCharArray(), ITypeInfo.t_function);
        iParameterizedSymbol2.setIsForwardDeclaration(true);
        iDerivableContainerSymbol2.addSymbol((ISymbol)iParameterizedSymbol2);
        ITemplateSymbol iTemplateSymbol3 = this.table.newTemplateSymbol("".toCharArray());
        ISymbol iSymbol4 = this.table.newSymbol("T".toCharArray(), ITypeInfo.t_templateParameter);
        iTemplateSymbol3.addTemplateParameter(iSymbol4);
        iTemplateFactory = this.table.newTemplateFactory();
        iTemplateFactory.setContainingSymbol(this.table.getCompilationUnit());
        iTemplateFactory.pushTemplate(iTemplateSymbol3);
        arrayList.clear();
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_char, (int)0, null));
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_type, (int)0, (ISymbol)iSymbol4));
        IDerivableContainerSymbol iDerivableContainerSymbol3 = this.table.newDerivableContainerSymbol("A".toCharArray(), ITypeInfo.t_class);
        iTemplateFactory.addTemplateId((ISymbol)iDerivableContainerSymbol3, arrayList);
        IParameterizedSymbol iParameterizedSymbol3 = this.table.newParameterizedSymbol("f".toCharArray(), ITypeInfo.t_function);
        iParameterizedSymbol3.setIsForwardDeclaration(true);
        iDerivableContainerSymbol3.addSymbol((ISymbol)iParameterizedSymbol3);
        ITemplateSymbol iTemplateSymbol4 = this.table.newTemplateSymbol("".toCharArray());
        ISymbol iSymbol5 = this.table.newSymbol("U".toCharArray(), ITypeInfo.t_templateParameter);
        ISymbol iSymbol6 = this.table.newSymbol("V".toCharArray(), ITypeInfo.t_templateParameter);
        iTemplateSymbol4.addTemplateParameter(iSymbol5);
        iTemplateSymbol4.addTemplateParameter(iSymbol6);
        iTemplateFactory = this.table.newTemplateFactory();
        iTemplateFactory.setContainingSymbol(this.table.getCompilationUnit());
        iTemplateFactory.pushTemplate(iTemplateSymbol3);
        arrayList.clear();
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_type, (int)0, (ISymbol)iSymbol5));
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_type, (int)0, (ISymbol)iSymbol6));
        ISymbol iSymbol7 = iTemplateFactory.lookupTemplateId("A".toCharArray(), arrayList);
        Assert.assertEquals((Object)((IDeferredTemplateInstance)iSymbol7).getTemplate(), (Object)iTemplateSymbol);
        iTemplateFactory.pushTemplateId(iSymbol7, arrayList);
        IParameterizedSymbol iParameterizedSymbol4 = iTemplateFactory.lookupMethodForDefinition("f".toCharArray(), new ArrayList());
        Assert.assertEquals((Object)iParameterizedSymbol4, (Object)iParameterizedSymbol);
        IParameterizedSymbol iParameterizedSymbol5 = this.table.newParameterizedSymbol("f".toCharArray(), ITypeInfo.t_function);
        iParameterizedSymbol.setForwardSymbol((ISymbol)iParameterizedSymbol5);
        iTemplateFactory.addSymbol((ISymbol)iParameterizedSymbol5);
        ISymbol iSymbol8 = this.table.newSymbol("c".toCharArray(), ITypeInfo.t_int);
        iParameterizedSymbol5.addSymbol(iSymbol8);
        ITemplateSymbol iTemplateSymbol5 = this.table.newTemplateSymbol("".toCharArray());
        ISymbol iSymbol9 = this.table.newSymbol("W".toCharArray(), ITypeInfo.t_templateParameter);
        iTemplateSymbol5.addTemplateParameter(iSymbol9);
        iTemplateFactory = this.table.newTemplateFactory();
        iTemplateFactory.setContainingSymbol(this.table.getCompilationUnit());
        iTemplateFactory.pushTemplate(iTemplateSymbol5);
        arrayList = new ArrayList();
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_type, (int)0, (ISymbol)iSymbol9));
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_type, (int)0, (ISymbol)iSymbol9));
        iSymbol7 = iTemplateFactory.lookupTemplateId("A".toCharArray(), arrayList);
        iTemplateFactory.pushTemplateId(iSymbol7, arrayList);
        iParameterizedSymbol4 = iTemplateFactory.lookupMethodForDefinition("f".toCharArray(), new ArrayList());
        Assert.assertEquals((Object)iParameterizedSymbol4, (Object)iParameterizedSymbol2);
        IParameterizedSymbol iParameterizedSymbol6 = this.table.newParameterizedSymbol("f".toCharArray(), ITypeInfo.t_function);
        iParameterizedSymbol2.setForwardSymbol((ISymbol)iParameterizedSymbol6);
        iTemplateFactory.addSymbol((ISymbol)iParameterizedSymbol6);
        ISymbol iSymbol10 = this.table.newSymbol("c".toCharArray(), ITypeInfo.t_char);
        iParameterizedSymbol6.addSymbol(iSymbol10);
        ITemplateSymbol iTemplateSymbol6 = this.table.newTemplateSymbol("".toCharArray());
        ISymbol iSymbol11 = this.table.newSymbol("X".toCharArray(), ITypeInfo.t_templateParameter);
        iTemplateSymbol6.addTemplateParameter(iSymbol11);
        iTemplateFactory = this.table.newTemplateFactory();
        iTemplateFactory.setContainingSymbol(this.table.getCompilationUnit());
        iTemplateFactory.pushTemplate(iTemplateSymbol5);
        arrayList = new ArrayList();
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_char, (int)0, null));
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_type, (int)0, (ISymbol)iSymbol11));
        iSymbol7 = iTemplateFactory.lookupTemplateId("A".toCharArray(), arrayList);
        iTemplateFactory.pushTemplateId(iSymbol7, arrayList);
        iParameterizedSymbol4 = iTemplateFactory.lookupMethodForDefinition("f".toCharArray(), new ArrayList());
        Assert.assertEquals((Object)iParameterizedSymbol4, (Object)iParameterizedSymbol3);
        IParameterizedSymbol iParameterizedSymbol7 = this.table.newParameterizedSymbol("f".toCharArray(), ITypeInfo.t_function);
        iParameterizedSymbol3.setForwardSymbol((ISymbol)iParameterizedSymbol7);
        iTemplateFactory.addSymbol((ISymbol)iParameterizedSymbol7);
        ISymbol iSymbol12 = this.table.newSymbol("c".toCharArray(), ITypeInfo.t_float);
        iParameterizedSymbol7.addSymbol(iSymbol12);
        arrayList = new ArrayList();
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_int, (int)0, null));
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_char, (int)0, null));
        iParameterizedSymbol4 = this.table.getCompilationUnit().lookupTemplateId("A".toCharArray(), arrayList);
        Assert.assertTrue((boolean)iParameterizedSymbol4.isTemplateInstance());
        Assert.assertEquals((Object)iParameterizedSymbol4.getInstantiatedSymbol(), (Object)iDerivableContainerSymbol);
        iParameterizedSymbol4 = ((IContainerSymbol)iParameterizedSymbol4).qualifiedFunctionLookup("f".toCharArray(), new ArrayList());
        Assert.assertTrue((boolean)iParameterizedSymbol4.isTemplateInstance());
        Assert.assertEquals((Object)iParameterizedSymbol4.getInstantiatedSymbol(), (Object)iParameterizedSymbol5);
        iParameterizedSymbol4 = ((IContainerSymbol)iParameterizedSymbol4).qualifiedLookup("c".toCharArray());
        Assert.assertTrue((boolean)iParameterizedSymbol4.isTemplateInstance());
        Assert.assertEquals((Object)iParameterizedSymbol4.getInstantiatedSymbol(), (Object)iSymbol8);
        Assert.assertTrue((boolean)iParameterizedSymbol4.isType(ITypeInfo.t_int));
        arrayList.clear();
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_int, (int)0, null));
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_int, (int)0, null));
        iParameterizedSymbol4 = this.table.getCompilationUnit().lookupTemplateId("A".toCharArray(), arrayList);
        Assert.assertTrue((boolean)iParameterizedSymbol4.isTemplateInstance());
        Assert.assertEquals((Object)iParameterizedSymbol4.getInstantiatedSymbol(), (Object)iDerivableContainerSymbol2);
        iParameterizedSymbol4 = ((IContainerSymbol)iParameterizedSymbol4).qualifiedFunctionLookup("f".toCharArray(), new ArrayList());
        Assert.assertTrue((boolean)iParameterizedSymbol4.isTemplateInstance());
        Assert.assertEquals((Object)iParameterizedSymbol4.getInstantiatedSymbol(), (Object)iParameterizedSymbol6);
        iParameterizedSymbol4 = ((IContainerSymbol)iParameterizedSymbol4).qualifiedLookup("c".toCharArray());
        Assert.assertTrue((boolean)iParameterizedSymbol4.isTemplateInstance());
        Assert.assertEquals((Object)iParameterizedSymbol4.getInstantiatedSymbol(), (Object)iSymbol10);
        Assert.assertTrue((boolean)iParameterizedSymbol4.isType(ITypeInfo.t_char));
        arrayList.clear();
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_char, (int)0, null));
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_int, (int)0, null));
        iParameterizedSymbol4 = this.table.getCompilationUnit().lookupTemplateId("A".toCharArray(), arrayList);
        Assert.assertTrue((boolean)iParameterizedSymbol4.isTemplateInstance());
        Assert.assertEquals((Object)iParameterizedSymbol4.getInstantiatedSymbol(), (Object)iDerivableContainerSymbol3);
        iParameterizedSymbol4 = ((IContainerSymbol)iParameterizedSymbol4).qualifiedFunctionLookup("f".toCharArray(), new ArrayList());
        Assert.assertTrue((boolean)iParameterizedSymbol4.isTemplateInstance());
        Assert.assertEquals((Object)iParameterizedSymbol4.getInstantiatedSymbol(), (Object)iParameterizedSymbol7);
        iParameterizedSymbol4 = ((IContainerSymbol)iParameterizedSymbol4).qualifiedLookup("c".toCharArray());
        Assert.assertTrue((boolean)iParameterizedSymbol4.isTemplateInstance());
        Assert.assertEquals((Object)iParameterizedSymbol4.getInstantiatedSymbol(), (Object)iSymbol12);
        Assert.assertTrue((boolean)iParameterizedSymbol4.isType(ITypeInfo.t_float));
        Assert.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }
}

