/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.tests;

import java.io.StringWriter;
import java.io.Writer;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.IParser;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.NullLogService;
import org.eclipse.cdt.core.parser.NullSourceElementRequestor;
import org.eclipse.cdt.core.parser.ParseError;
import org.eclipse.cdt.core.parser.ParserFactory;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.ScannerInfo;
import org.eclipse.cdt.core.parser.ast.IASTMacro;
import org.eclipse.cdt.core.parser.ast.IASTVariable;
import org.eclipse.cdt.core.parser.tests.FileBasePluginTest;
import org.eclipse.core.resources.IFile;

public class ScannerParserLoopTest
extends FileBasePluginTest {
    private static final int NUMBER_ITERATIONS = 30000;
    static /* synthetic */ Class class$0;

    public ScannerParserLoopTest(String string) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.core.parser.tests.ScannerParserLoopTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        super(string, clazz);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.core.parser.tests.ScannerParserLoopTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite testSuite = new TestSuite((Class)clazz);
        testSuite.addTest((Test)new ScannerParserLoopTest("cleanupProject"));
        return testSuite;
    }

    public void testBug72611A() throws Exception {
        StringWriter stringWriter = new StringWriter();
        int n = 0;
        while (n < 30000) {
            ((Writer)stringWriter).write("#define A");
            ((Writer)stringWriter).write(String.valueOf(n));
            ((Writer)stringWriter).write(" B");
            ((Writer)stringWriter).write(String.valueOf(n));
            ((Writer)stringWriter).write("\n");
            ((Writer)stringWriter).write("#define B");
            ((Writer)stringWriter).write(String.valueOf(n));
            ((Writer)stringWriter).write(" C");
            ((Writer)stringWriter).write(String.valueOf(n));
            ((Writer)stringWriter).write("\n");
            ((Writer)stringWriter).write("#define C");
            ((Writer)stringWriter).write(String.valueOf(n));
            ((Writer)stringWriter).write(" D");
            ((Writer)stringWriter).write(String.valueOf(n));
            ((Writer)stringWriter).write("\n");
            ++n;
        }
        this.runCancelTest(stringWriter);
    }

    public void testBug72611B() throws Exception {
        StringWriter stringWriter = new StringWriter();
        int n = 0;
        while (n < 30000) {
            ((Writer)stringWriter).write("int a");
            ((Writer)stringWriter).write(String.valueOf(n));
            ((Writer)stringWriter).write("; // comment\n");
            ++n;
        }
        this.runCancelTest(stringWriter);
    }

    private void runCancelTest(Writer writer) throws Exception {
        IFile iFile = this.importFile("code.cpp", writer.toString());
        try {
            TimeoutCallback timeoutCallback = new TimeoutCallback();
            IParser iParser = ParserFactory.createParser((IScanner)ParserFactory.createScanner((CodeReader)new CodeReader(iFile.getRawLocation().toString()), (IScannerInfo)new ScannerInfo(), (ParserMode)ParserMode.COMPLETE_PARSE, (ParserLanguage)ParserLanguage.CPP, (ISourceElementRequestor)timeoutCallback, (IParserLogService)new NullLogService(), null), (ISourceElementRequestor)timeoutCallback, (ParserMode)ParserMode.COMPLETE_PARSE, (ParserLanguage)ParserLanguage.CPP, null);
            timeoutCallback.setParser(iParser);
            iParser.parse();
            Assert.assertTrue((boolean)false);
        }
        catch (ParseError parseError) {
            Assert.assertEquals((Object)parseError.getErrorKind(), (Object)ParseError.ParseErrorKind.TIMEOUT_OR_CANCELLED);
        }
    }

    private static class TimeoutCallback
    extends NullSourceElementRequestor
    implements ISourceElementRequestor {
        private IParser parser;
        private boolean timerStarted = false;

        TimeoutCallback() {
        }

        public void setParser(IParser iParser) {
            this.parser = iParser;
        }

        public void acceptMacro(IASTMacro iASTMacro) {
            this.parser.cancel();
        }

        public void acceptVariable(IASTVariable iASTVariable) {
            this.parser.cancel();
        }
    }
}

