/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.tests.ast2;

import junit.framework.Assert;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.tests.ast2.AST2SpecBaseTest;

public class AST2CPPSpecFailingTest
extends AST2SpecBaseTest {
    public void test2_3s2() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("??=define arraycheck(a,b) a??(b??) ??!??! b??(a??)\n");
        stringBuffer.append("// becomes\n");
        stringBuffer.append("#define arraycheck(a,b) a[b] || b[a]\n");
        try {
            this.parseCandCPP(stringBuffer.toString(), true, 0);
            Assert.assertTrue((boolean)false);
        }
        catch (Exception exception) {}
    }

    public void test6_4s3() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int foo() {\n");
        stringBuffer.append("if (int x = f()) {\n");
        stringBuffer.append("int x; // illformed,redeclaration of x\n");
        stringBuffer.append("}\n");
        stringBuffer.append("else {\n");
        stringBuffer.append("int x; // illformed,redeclaration of x\n");
        stringBuffer.append("}\n");
        stringBuffer.append("}\n");
        try {
            this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
        }
        catch (Exception exception) {}
    }

    public void test6_8s2() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class T {\n");
        stringBuffer.append("// ...\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("T();\n");
        stringBuffer.append("T(int);\n");
        stringBuffer.append("T(int, int);\n");
        stringBuffer.append("};\n");
        stringBuffer.append("T(a); //declaration\n");
        stringBuffer.append("T(*b)(); //declaration\n");
        stringBuffer.append("T(c)=7; //declaration\n");
        stringBuffer.append("T(d),e,f=3; //declaration\n");
        stringBuffer.append("extern int h;\n");
        stringBuffer.append("T(g)(h,2); //declaration\n");
        try {
            this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
            Assert.assertTrue((boolean)false);
        }
        catch (Exception exception) {}
    }

    public void test8_2s4() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template <class T>\n");
        stringBuffer.append("struct S {\n");
        stringBuffer.append("T *p;\n");
        stringBuffer.append("};\n");
        stringBuffer.append("S<int()> x; // typeid\n");
        stringBuffer.append("S<int(1)> y; // expression (illformed)\n");
        try {
            this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
            Assert.assertTrue((boolean)false);
        }
        catch (Exception exception) {}
    }

    public void test8_2s7a() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class C { };\n");
        stringBuffer.append("void f(int(C)) { } // void f(int (*fp)(C c)) { }\n");
        stringBuffer.append("// not: void f(int C);\n");
        stringBuffer.append("int g(C);\n");
        stringBuffer.append("void foo() {\n");
        stringBuffer.append("f(1); //error: cannot convert 1 to function pointer\n");
        stringBuffer.append("f(g); //OK\n");
        stringBuffer.append("}\n");
        try {
            this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
            Assert.assertTrue((boolean)false);
        }
        catch (Exception exception) {}
    }

    public void test8_5_2s1() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("char msg[] = \"Syntax error on line %s\n\";\n");
        try {
            this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
            Assert.assertTrue((boolean)false);
        }
        catch (Exception exception) {}
    }

    public void test14_5_3s1() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class T> class task;\n");
        stringBuffer.append("template<class T> task<T>* preempt(task<T>*);\n");
        stringBuffer.append("template<class T> class task {\n");
        stringBuffer.append("// ...\n");
        stringBuffer.append("friend void next_time();\n");
        stringBuffer.append("friend void process(task<T>*);\n");
        stringBuffer.append("friend task<T>* preempt<T>(task<T>*);\n");
        stringBuffer.append("template<class C> friend int func(C);\n");
        stringBuffer.append("friend class task<int>;\n");
        stringBuffer.append("template<class P> friend class frd;\n");
        stringBuffer.append("// ...\n");
        stringBuffer.append("};\n");
        try {
            this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
            Assert.assertTrue((boolean)false);
        }
        catch (Exception exception) {}
    }

    public void test14_5_4_2s2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<int I, int J, class T> class X { };\n");
        stringBuffer.append("template<int I, int J>          class X<I, J, int> { }; // #1\n");
        stringBuffer.append("template<int I>                 class X<I, I, int> { }; // #2\n");
        stringBuffer.append("template<int I, int J> void f(X<I, J, int>); // #A\n");
        stringBuffer.append("template<int I>        void f(X<I, I, int>); // #B\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 2);
    }

    public void test14_5_5_1s5() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template <int I, int J> A<I+J> f(A<I>, A<J>); // #1\n");
        stringBuffer.append("template <int K, int L> A<K+L> f(A<K>, A<L>); // same as #1\n");
        stringBuffer.append("template <int I, int J> A<IJ> f(A<I>, A<J>); // different from #1\n");
        try {
            this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
            Assert.assertTrue((boolean)false);
        }
        catch (Exception exception) {}
    }

    public void test14_5_5_1s6() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template <int I, int J> void f(A<I+J>); // #1\n");
        stringBuffer.append("template <int K, int L> void f(A<K+L>); // same as #1\n");
        try {
            this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
            Assert.assertTrue((boolean)false);
        }
        catch (Exception exception) {}
    }

    public void test14_6_2s3() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("typedef double A;\n");
        stringBuffer.append("template<class T> B {\n");
        stringBuffer.append("typedef int A;\n");
        stringBuffer.append("};\n");
        stringBuffer.append("template<class T> struct X : B<T> {\n");
        stringBuffer.append("A a; // a has type double\n");
        stringBuffer.append("};\n");
        try {
            this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
            Assert.assertTrue((boolean)false);
        }
        catch (Exception exception) {}
    }

    public void test14_8_2s2b() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template <class T> int f(typename T::B*);\n");
        stringBuffer.append("int i = f<int>(0);\n");
        try {
            this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 1);
            Assert.assertTrue((boolean)false);
        }
        catch (Exception exception) {}
    }

    public void test14_8_2s2c() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template <class T> int f(typename T::B*);\n");
        stringBuffer.append("struct A {};\n");
        stringBuffer.append("struct C { int B; };\n");
        stringBuffer.append("int i = f<A>(0);\n");
        stringBuffer.append("int j = f<C>(0);\n");
        try {
            this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 2);
            Assert.assertTrue((boolean)false);
        }
        catch (Exception exception) {}
    }

    public void test14_8_2s3() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template <class T> void f(T t);\n");
        stringBuffer.append("template <class X> void g(const X x);\n");
        stringBuffer.append("template <class Z> void h(Z, Z*);\n");
        stringBuffer.append("int main()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("// #1: function type is f(int), t is nonconst\n");
        stringBuffer.append("f<int>(1);\n");
        stringBuffer.append("// #2: function type is f(int), t is const\n");
        stringBuffer.append("f<const int>(1);\n");
        stringBuffer.append("// #3: function type is g(int), x is const\n");
        stringBuffer.append("g<int>(1);\n");
        stringBuffer.append("// #4: function type is g(int), x is const\n");
        stringBuffer.append("g<const int>(1);\n");
        stringBuffer.append("// #5: function type is h(int, const int*)\n");
        stringBuffer.append("h<const int>(1,0);\n");
        stringBuffer.append("}\n");
        try {
            this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
            Assert.assertTrue((boolean)false);
        }
        catch (Exception exception) {}
    }

    public void test14_8_2_4s7() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class T> void f(const T*) {}\n");
        stringBuffer.append("int *p;\n");
        stringBuffer.append("void s()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("f(p); // f(const int *)\n");
        stringBuffer.append("}\n");
        try {
            this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
            Assert.assertTrue((boolean)false);
        }
        catch (Exception exception) {}
    }

    public void test14_8_2_4s8() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template <class T> struct B { };\n");
        stringBuffer.append("template <class T> struct D : public B<T> {};\n");
        stringBuffer.append("struct D2 : public B<int> {};\n");
        stringBuffer.append("template <class T> void f(B<T>&){}\n");
        stringBuffer.append("void t()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("D<int> d;\n");
        stringBuffer.append("D2 d2;\n");
        stringBuffer.append("f(d); //calls f(B<int>&)\n");
        stringBuffer.append("f(d2); //calls f(B<int>&)\n");
        stringBuffer.append("}\n");
        try {
            this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
            Assert.assertTrue((boolean)false);
        }
        catch (Exception exception) {}
    }

    public void test14_8_2_4s18() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template <template X<class T> > struct A { };\n");
        stringBuffer.append("template <template X<class T> > void f(A<X>) { }\n");
        stringBuffer.append("template<class T> struct B { };\n");
        stringBuffer.append("int foo() {\n");
        stringBuffer.append("A<B> ab;\n");
        stringBuffer.append("f(ab); //calls f(A<B>)\n");
        stringBuffer.append("}\n");
        try {
            this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
            Assert.assertTrue((boolean)false);
        }
        catch (Exception exception) {}
    }

    public void test14_5_5_1s8a() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("// Guaranteed to be the same\n");
        stringBuffer.append("template <int I> void f(A<I>, A<I+10>);\n");
        stringBuffer.append("template <int I> void f(A<I>, A<I+10>);\n");
        stringBuffer.append("// Guaranteed to be different\n");
        stringBuffer.append("template <int I> void f(A<I>, A<I+10>);\n");
        stringBuffer.append("template <int I> void f(A<I>, A<I+11>);\n");
        try {
            this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
            Assert.assertTrue((boolean)false);
        }
        catch (Exception exception) {}
    }

    public void test14_5_5_1s8b() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("// Illformed, no diagnostic required\n");
        stringBuffer.append("template <int I> void f(A<I>, A<I+10>);\n");
        stringBuffer.append("template <int I> void f(A<I>, A<I+1+2+3+4>);\n");
        try {
            this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
            Assert.assertTrue((boolean)false);
        }
        catch (Exception exception) {}
    }

    public void test14_8_1s4() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class T> void f(T);\n");
        stringBuffer.append("class Complex {\n");
        stringBuffer.append("// ...\n");
        stringBuffer.append("Complex(double);\n");
        stringBuffer.append("};\n");
        stringBuffer.append("void g()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("f<Complex>(1); // OK, means f<Complex>(Complex(1))\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 1);
    }

    public void test14_8_2_4s14() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<int i, typename T>\n");
        stringBuffer.append("T deduce(typename A<T>::X x, // T is not deduced here\n");
        stringBuffer.append("T t, // but T is deduced here\n");
        stringBuffer.append("typename B<i>::Y y); // i is not deduced here\n");
        stringBuffer.append("A<int> a;\n");
        stringBuffer.append("B<77> b;\n");
        stringBuffer.append("int x = deduce<77>(a.xm, 62, y.ym);\n");
        stringBuffer.append("// T is deduced to be int, a.xm must be convertible to\n");
        stringBuffer.append("// A<int>::X\n");
        stringBuffer.append("// i is explicitly specified to be 77, y.ym must be convertible\n");
        stringBuffer.append("// to B<77>::Y\n");
        try {
            this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
            Assert.assertTrue((boolean)false);
        }
        catch (Exception exception) {}
    }

    public void test14_8_3s5() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class T> void f(T*,int); // #1\n");
        stringBuffer.append("template<class T> void f(T,char); // #2\n");
        stringBuffer.append("void h(int* pi, int i, char c)\n");
        stringBuffer.append("{\n");
        stringBuffer.append("f(pi,i); //#1: f<int>(pi,i)\n");
        stringBuffer.append("f(pi,c); //#2: f<int*>(pi,c)\n");
        stringBuffer.append("f(i,c); //#2: f<int>(i,c);\n");
        stringBuffer.append("f(i,i); //#2: f<int>(i,char(i))\n");
        stringBuffer.append("}\n");
        try {
            this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
            Assert.assertTrue((boolean)false);
        }
        catch (Exception exception) {}
    }
}

