/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.tests.ast2;

import java.util.Iterator;
import junit.framework.Assert;
import org.eclipse.cdt.core.dom.ast.ASTSignatureUtil;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTArrayDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTCastExpression;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarationStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTExpressionStatement;
import org.eclipse.cdt.core.dom.ast.IASTFieldReference;
import org.eclipse.cdt.core.dom.ast.IASTForStatement;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTIfStatement;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTInitializerExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializerList;
import org.eclipse.cdt.core.dom.ast.IASTLabelStatement;
import org.eclipse.cdt.core.dom.ast.IASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTNullStatement;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTProblem;
import org.eclipse.cdt.core.dom.ast.IASTReturnStatement;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStandardFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTWhileStatement;
import org.eclipse.cdt.core.dom.ast.IArrayType;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.ILabel;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IQualifierType;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.c.ICASTArrayModifier;
import org.eclipse.cdt.core.dom.ast.c.ICASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.c.ICASTDesignatedInitializer;
import org.eclipse.cdt.core.dom.ast.c.ICASTEnumerationSpecifier;
import org.eclipse.cdt.core.dom.ast.c.ICASTFieldDesignator;
import org.eclipse.cdt.core.dom.ast.c.ICASTPointer;
import org.eclipse.cdt.core.dom.ast.c.ICASTSimpleDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.c.ICArrayType;
import org.eclipse.cdt.core.dom.ast.c.ICExternalBinding;
import org.eclipse.cdt.core.dom.ast.c.ICFunctionScope;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.tests.ast2.AST2BaseTest;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.c.CFunction;
import org.eclipse.cdt.internal.core.dom.parser.c.CVisitor;
import org.eclipse.cdt.internal.core.parser.ParserException;

public class AST2Tests
extends AST2BaseTest {
    public void testBug75189() throws Exception {
        this.parseAndCheckBindings("struct A{};typedef int (*F) (A*);");
    }

    public void testBug75340() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parseAndCheckBindings("void f(int i = 0, int * p = 0);");
        IASTSimpleDeclaration iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[0];
        Assert.assertEquals((String)ASTSignatureUtil.getParameterSignature((IASTDeclarator)iASTSimpleDeclaration.getDeclarators()[0]), (String)"(int, int *)");
    }

    public void testBug78103() throws Exception {
        StringBuffer stringBuffer = new StringBuffer("int *p1; int *p2;\n");
        stringBuffer.append("union {\n");
        stringBuffer.append("struct {int a; int b;} A;\n");
        stringBuffer.append("struct {int a; int b;};\n");
        stringBuffer.append("} MyStruct;\n");
        stringBuffer.append("void test (void) {\n");
        stringBuffer.append("p1 = &MyStruct.A.a;\n");
        stringBuffer.append("p2 = &MyStruct.b;\n");
        stringBuffer.append("        MyStruct.b = 1;\n");
        stringBuffer.append("}\n");
        this.parseAndCheckBindings(stringBuffer.toString());
    }

    public void testBug43241() throws Exception {
        this.parseAndCheckBindings("int m(int); int (*pm)(int) = &m; int f(int); int x = f((*pm)(5));");
    }

    public void testBug40768() throws Exception {
        StringBuffer stringBuffer = new StringBuffer("int *zzz1 (char);\n");
        stringBuffer.append("int (*zzz2) (char); \n");
        stringBuffer.append("int ((*zzz3)) (char); \n");
        stringBuffer.append("int (*(zzz4)) (char); \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.C);
        AST2BaseTest.CNameCollector cNameCollector = new AST2BaseTest.CNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cNameCollector);
        this.assertNoProblemBindings(cNameCollector);
    }

    protected IASTTranslationUnit parseAndCheckBindings(String string) throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse(string, ParserLanguage.C);
        AST2BaseTest.CNameCollector cNameCollector = new AST2BaseTest.CNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cNameCollector);
        this.assertNoProblemBindings(cNameCollector);
        return iASTTranslationUnit;
    }

    public void testBasicFunction() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int x;\n");
        stringBuffer.append("void f(int y) {\n");
        stringBuffer.append("   int z = x + y;\n");
        stringBuffer.append("}\n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.C);
        IScope iScope = iASTTranslationUnit.getScope();
        IASTDeclaration[] iASTDeclarationArray = iASTTranslationUnit.getDeclarations();
        IASTSimpleDeclaration iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTDeclarationArray[0];
        IASTSimpleDeclSpecifier iASTSimpleDeclSpecifier = (IASTSimpleDeclSpecifier)iASTSimpleDeclaration.getDeclSpecifier();
        Assert.assertEquals((int)3, (int)iASTSimpleDeclSpecifier.getType());
        IASTDeclarator iASTDeclarator = iASTSimpleDeclaration.getDeclarators()[0];
        IASTName iASTName = iASTDeclarator.getName();
        Assert.assertEquals((String)"x", (String)iASTName.toString());
        IASTFunctionDefinition iASTFunctionDefinition = (IASTFunctionDefinition)iASTDeclarationArray[1];
        IASTSimpleDeclSpecifier iASTSimpleDeclSpecifier2 = (IASTSimpleDeclSpecifier)iASTFunctionDefinition.getDeclSpecifier();
        Assert.assertEquals((int)1, (int)iASTSimpleDeclSpecifier2.getType());
        IASTFunctionDeclarator iASTFunctionDeclarator = iASTFunctionDefinition.getDeclarator();
        IASTName iASTName2 = iASTFunctionDeclarator.getName();
        Assert.assertEquals((String)"f", (String)iASTName2.toString());
        Assert.assertTrue((boolean)(iASTFunctionDeclarator instanceof IASTStandardFunctionDeclarator));
        IASTParameterDeclaration iASTParameterDeclaration = ((IASTStandardFunctionDeclarator)iASTFunctionDeclarator).getParameters()[0];
        IASTSimpleDeclSpecifier iASTSimpleDeclSpecifier3 = (IASTSimpleDeclSpecifier)iASTParameterDeclaration.getDeclSpecifier();
        Assert.assertEquals((int)3, (int)iASTSimpleDeclSpecifier3.getType());
        IASTDeclarator iASTDeclarator2 = iASTParameterDeclaration.getDeclarator();
        IASTName iASTName3 = iASTDeclarator2.getName();
        Assert.assertEquals((String)"y", (String)iASTName3.toString());
        IASTCompoundStatement iASTCompoundStatement = (IASTCompoundStatement)iASTFunctionDefinition.getBody();
        IASTDeclarationStatement iASTDeclarationStatement = (IASTDeclarationStatement)iASTCompoundStatement.getStatements()[0];
        IASTSimpleDeclaration iASTSimpleDeclaration2 = (IASTSimpleDeclaration)iASTDeclarationStatement.getDeclaration();
        IASTSimpleDeclSpecifier iASTSimpleDeclSpecifier4 = (IASTSimpleDeclSpecifier)iASTSimpleDeclaration2.getDeclSpecifier();
        Assert.assertEquals((int)3, (int)iASTSimpleDeclSpecifier4.getType());
        IASTDeclarator iASTDeclarator3 = iASTSimpleDeclaration2.getDeclarators()[0];
        IASTName iASTName4 = iASTDeclarator3.getName();
        Assert.assertEquals((String)"z", (String)iASTName4.toString());
        IASTInitializerExpression iASTInitializerExpression = (IASTInitializerExpression)iASTDeclarator3.getInitializer();
        IASTBinaryExpression iASTBinaryExpression = (IASTBinaryExpression)iASTInitializerExpression.getExpression();
        Assert.assertEquals((int)4, (int)iASTBinaryExpression.getOperator());
        IASTIdExpression iASTIdExpression = (IASTIdExpression)iASTBinaryExpression.getOperand1();
        IASTName iASTName5 = iASTIdExpression.getName();
        Assert.assertEquals((String)"x", (String)iASTName5.toString());
        IASTIdExpression iASTIdExpression2 = (IASTIdExpression)iASTBinaryExpression.getOperand2();
        IASTName iASTName6 = iASTIdExpression2.getName();
        Assert.assertEquals((String)"y", (String)iASTName6.toString());
        IVariable iVariable = (IVariable)iASTName.resolveBinding();
        Assert.assertEquals((Object)iScope, (Object)iVariable.getScope());
        IFunction iFunction = (IFunction)iASTName2.resolveBinding();
        Assert.assertEquals((Object)iScope, (Object)iFunction.getScope());
        IParameter iParameter = (IParameter)iASTName3.resolveBinding();
        Assert.assertEquals((Object)((IASTCompoundStatement)iASTFunctionDefinition.getBody()).getScope(), (Object)iParameter.getScope());
        IVariable iVariable2 = (IVariable)iASTName4.resolveBinding();
        Assert.assertEquals((Object)((ICFunctionScope)iFunction.getFunctionScope()).getBodyScope(), (Object)iVariable2.getScope());
        Assert.assertEquals((Object)iVariable, (Object)iASTName5.resolveBinding());
        Assert.assertEquals((Object)iParameter, (Object)iASTName6.resolveBinding());
        IASTName[] iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName);
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName2.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName2);
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName3.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName3);
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName4.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName4);
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName5.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName);
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName6.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName3);
    }

    public void testSimpleStruct() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("typedef struct {\n");
        stringBuffer.append("    int x;\n");
        stringBuffer.append("} S;\n");
        stringBuffer.append("void f() {\n");
        stringBuffer.append("    S myS;\n");
        stringBuffer.append("    myS.x = 5;");
        stringBuffer.append("}");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.C);
        IASTSimpleDeclaration iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[0];
        IASTCompositeTypeSpecifier iASTCompositeTypeSpecifier = (IASTCompositeTypeSpecifier)iASTSimpleDeclaration.getDeclSpecifier();
        Assert.assertEquals((int)1, (int)iASTCompositeTypeSpecifier.getStorageClass());
        IASTName iASTName = iASTCompositeTypeSpecifier.getName();
        Assert.assertTrue((boolean)iASTName.isDeclaration());
        Assert.assertFalse((boolean)iASTName.isReference());
        Assert.assertEquals((String)"", (String)iASTName.toString());
        IASTSimpleDeclaration iASTSimpleDeclaration2 = (IASTSimpleDeclaration)iASTCompositeTypeSpecifier.getMembers()[0];
        IASTSimpleDeclSpecifier iASTSimpleDeclSpecifier = (IASTSimpleDeclSpecifier)iASTSimpleDeclaration2.getDeclSpecifier();
        Assert.assertEquals((int)3, (int)iASTSimpleDeclSpecifier.getType());
        IASTDeclarator iASTDeclarator = iASTSimpleDeclaration2.getDeclarators()[0];
        IASTName iASTName2 = iASTDeclarator.getName();
        Assert.assertEquals((String)"x", (String)iASTName2.toString());
        IASTDeclarator iASTDeclarator2 = iASTSimpleDeclaration.getDeclarators()[0];
        IASTName iASTName3 = iASTDeclarator2.getName();
        Assert.assertEquals((String)"S", (String)iASTName3.toString());
        IASTFunctionDefinition iASTFunctionDefinition = (IASTFunctionDefinition)iASTTranslationUnit.getDeclarations()[1];
        IASTCompoundStatement iASTCompoundStatement = (IASTCompoundStatement)iASTFunctionDefinition.getBody();
        IASTDeclarationStatement iASTDeclarationStatement = (IASTDeclarationStatement)iASTCompoundStatement.getStatements()[0];
        IASTSimpleDeclaration iASTSimpleDeclaration3 = (IASTSimpleDeclaration)iASTDeclarationStatement.getDeclaration();
        IASTNamedTypeSpecifier iASTNamedTypeSpecifier = (IASTNamedTypeSpecifier)iASTSimpleDeclaration3.getDeclSpecifier();
        IASTName iASTName4 = iASTNamedTypeSpecifier.getName();
        IASTDeclarator iASTDeclarator3 = iASTSimpleDeclaration3.getDeclarators()[0];
        IASTName iASTName5 = iASTDeclarator3.getName();
        IASTExpressionStatement iASTExpressionStatement = (IASTExpressionStatement)iASTCompoundStatement.getStatements()[1];
        IASTBinaryExpression iASTBinaryExpression = (IASTBinaryExpression)iASTExpressionStatement.getExpression();
        IASTFieldReference iASTFieldReference = (IASTFieldReference)iASTBinaryExpression.getOperand1();
        IASTIdExpression iASTIdExpression = (IASTIdExpression)iASTFieldReference.getFieldOwner();
        IASTLiteralExpression iASTLiteralExpression = (IASTLiteralExpression)iASTBinaryExpression.getOperand2();
        Assert.assertEquals((String)"5", (String)iASTLiteralExpression.toString());
        ICompositeType iCompositeType = (ICompositeType)iASTName.resolveBinding();
        ITypedef iTypedef = (ITypedef)iASTName3.resolveBinding();
        Assert.assertEquals((Object)iCompositeType, (Object)iTypedef.getType());
        ITypedef iTypedef2 = (ITypedef)iASTName4.resolveBinding();
        Assert.assertEquals((Object)iTypedef, (Object)iTypedef2);
        ICompositeType iCompositeType2 = (ICompositeType)iTypedef2.getType();
        Assert.assertEquals((Object)iCompositeType2, (Object)iCompositeType);
        IVariable iVariable = (IVariable)iASTName5.resolveBinding();
        Assert.assertEquals((Object)iTypedef, (Object)iVariable.getType());
        Assert.assertEquals((Object)iVariable, (Object)iASTIdExpression.getName().resolveBinding());
        IField iField = (IField)iASTName2.resolveBinding();
        Assert.assertEquals((Object)iField, (Object)iASTFieldReference.getFieldName().resolveBinding());
        IASTName[] iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName);
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName2.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName2);
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTFunctionDefinition.getDeclarator().getName().resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTFunctionDefinition.getDeclarator().getName());
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName3.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName3);
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName5.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName5);
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTIdExpression.getName().resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName5);
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTFieldReference.getFieldName().resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName2);
    }

    public void testCExpressions() throws ParserException {
        this.validateSimpleUnaryExpressionC("++x", 0);
        this.validateSimpleUnaryExpressionC("--x", 1);
        this.validateSimpleUnaryExpressionC("+x", 2);
        this.validateSimpleUnaryExpressionC("-x", 3);
        this.validateSimpleUnaryExpressionC("!x", 7);
        this.validateSimpleUnaryExpressionC("~x", 6);
        this.validateSimpleUnaryExpressionC("*x", 4);
        this.validateSimpleUnaryExpressionC("&x", 5);
        this.validateSimpleUnaryExpressionC("sizeof x", 8);
        this.validateSimpleTypeIdExpressionC("sizeof( int )", 0);
        this.validateSimpleUnaryTypeIdExpression("(int)x", 0);
        this.validateSimplePostfixInitializerExpressionC("(int) { 5 }");
        this.validateSimplePostfixInitializerExpressionC("(int) { 5, }");
        this.validateSimpleBinaryExpressionC("x=y", 17);
        this.validateSimpleBinaryExpressionC("x*=y", 18);
        this.validateSimpleBinaryExpressionC("x/=y", 19);
        this.validateSimpleBinaryExpressionC("x%=y", 20);
        this.validateSimpleBinaryExpressionC("x+=y", 21);
        this.validateSimpleBinaryExpressionC("x-=y", 22);
        this.validateSimpleBinaryExpressionC("x<<=y", 23);
        this.validateSimpleBinaryExpressionC("x>>=y", 24);
        this.validateSimpleBinaryExpressionC("x&=y", 25);
        this.validateSimpleBinaryExpressionC("x^=y", 26);
        this.validateSimpleBinaryExpressionC("x|=y", 27);
        this.validateSimpleBinaryExpressionC("x-y", 5);
        this.validateSimpleBinaryExpressionC("x+y", 4);
        this.validateSimpleBinaryExpressionC("x/y", 2);
        this.validateSimpleBinaryExpressionC("x*y", 1);
        this.validateSimpleBinaryExpressionC("x%y", 3);
        this.validateSimpleBinaryExpressionC("x<<y", 6);
        this.validateSimpleBinaryExpressionC("x>>y", 7);
        this.validateSimpleBinaryExpressionC("x<y", 8);
        this.validateSimpleBinaryExpressionC("x>y", 9);
        this.validateSimpleBinaryExpressionC("x<=y", 10);
        this.validateSimpleBinaryExpressionC("x>=y", 11);
        this.validateSimpleBinaryExpressionC("x==y", 28);
        this.validateSimpleBinaryExpressionC("x!=y", 29);
        this.validateSimpleBinaryExpressionC("x&y", 12);
        this.validateSimpleBinaryExpressionC("x^y", 13);
        this.validateSimpleBinaryExpressionC("x|y", 14);
        this.validateSimpleBinaryExpressionC("x&&y", 15);
        this.validateSimpleBinaryExpressionC("x||y", 16);
        this.validateConditionalExpressionC("x ? y : x");
    }

    public void testMultipleDeclarators() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("int r, s;", ParserLanguage.C);
        IASTSimpleDeclaration iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[0];
        IASTDeclarator[] iASTDeclaratorArray = iASTSimpleDeclaration.getDeclarators();
        Assert.assertEquals((int)2, (int)iASTDeclaratorArray.length);
        IASTDeclarator iASTDeclarator = iASTDeclaratorArray[0];
        IASTDeclarator iASTDeclarator2 = iASTDeclaratorArray[1];
        IASTName iASTName = iASTDeclarator.getName();
        IASTName iASTName2 = iASTDeclarator2.getName();
        Assert.assertEquals((String)iASTName.resolveBinding().getName(), (String)"r");
        Assert.assertEquals((String)iASTName2.resolveBinding().getName(), (String)"s");
        IASTName[] iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName);
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName2.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName2);
    }

    public void testStructureTagScoping_1() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct A;             \n");
        stringBuffer.append("void f(){             \n");
        stringBuffer.append("   struct A;          \n");
        stringBuffer.append("   struct A * a;      \n");
        stringBuffer.append("}                     \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.C);
        IASTSimpleDeclaration iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[0];
        IASTElaboratedTypeSpecifier iASTElaboratedTypeSpecifier = (IASTElaboratedTypeSpecifier)iASTSimpleDeclaration.getDeclSpecifier();
        Assert.assertEquals((int)0, (int)iASTSimpleDeclaration.getDeclarators().length);
        IASTName iASTName = iASTElaboratedTypeSpecifier.getName();
        IASTFunctionDefinition iASTFunctionDefinition = (IASTFunctionDefinition)iASTTranslationUnit.getDeclarations()[1];
        IASTCompoundStatement iASTCompoundStatement = (IASTCompoundStatement)iASTFunctionDefinition.getBody();
        Assert.assertEquals((int)2, (int)iASTCompoundStatement.getStatements().length);
        IASTDeclarationStatement iASTDeclarationStatement = (IASTDeclarationStatement)iASTCompoundStatement.getStatements()[0];
        IASTSimpleDeclaration iASTSimpleDeclaration2 = (IASTSimpleDeclaration)iASTDeclarationStatement.getDeclaration();
        iASTElaboratedTypeSpecifier = (IASTElaboratedTypeSpecifier)iASTSimpleDeclaration2.getDeclSpecifier();
        Assert.assertEquals((int)0, (int)iASTSimpleDeclaration2.getDeclarators().length);
        IASTName iASTName2 = iASTElaboratedTypeSpecifier.getName();
        iASTDeclarationStatement = (IASTDeclarationStatement)iASTCompoundStatement.getStatements()[1];
        IASTSimpleDeclaration iASTSimpleDeclaration3 = (IASTSimpleDeclaration)iASTDeclarationStatement.getDeclaration();
        iASTElaboratedTypeSpecifier = (IASTElaboratedTypeSpecifier)iASTSimpleDeclaration3.getDeclSpecifier();
        IASTName iASTName3 = iASTElaboratedTypeSpecifier.getName();
        IASTDeclarator iASTDeclarator = iASTSimpleDeclaration3.getDeclarators()[0];
        IASTName iASTName4 = iASTDeclarator.getName();
        Assert.assertEquals((int)1, (int)iASTDeclarator.getPointerOperators().length);
        Assert.assertTrue((boolean)(iASTDeclarator.getPointerOperators()[0] instanceof ICASTPointer));
        ICompositeType iCompositeType = (ICompositeType)iASTName.resolveBinding();
        ICompositeType iCompositeType2 = (ICompositeType)iASTName2.resolveBinding();
        IVariable iVariable = (IVariable)iASTName4.resolveBinding();
        IType iType = iVariable.getType();
        Assert.assertTrue((boolean)(iType instanceof IPointerType));
        ICompositeType iCompositeType3 = (ICompositeType)((IPointerType)iType).getType();
        ICompositeType iCompositeType4 = (ICompositeType)iASTName3.resolveBinding();
        Assert.assertNotNull((Object)iCompositeType);
        Assert.assertNotNull((Object)iCompositeType2);
        Assert.assertNotSame((Object)iCompositeType, (Object)iCompositeType2);
        Assert.assertSame((Object)iCompositeType2, (Object)iCompositeType3);
        Assert.assertSame((Object)iCompositeType3, (Object)iCompositeType4);
        IASTName[] iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName);
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTFunctionDefinition.getDeclarator().getName().resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTFunctionDefinition.getDeclarator().getName());
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName2.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName2);
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName3.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName2);
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName4.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName4);
    }

    public void testStructureTagScoping_2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct A;             \n");
        stringBuffer.append("void f(){             \n");
        stringBuffer.append("   struct A * a;      \n");
        stringBuffer.append("}                     \r\n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.C);
        IASTSimpleDeclaration iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[0];
        IASTElaboratedTypeSpecifier iASTElaboratedTypeSpecifier = (IASTElaboratedTypeSpecifier)iASTSimpleDeclaration.getDeclSpecifier();
        Assert.assertEquals((int)0, (int)iASTSimpleDeclaration.getDeclarators().length);
        IASTName iASTName = iASTElaboratedTypeSpecifier.getName();
        IASTFunctionDefinition iASTFunctionDefinition = (IASTFunctionDefinition)iASTTranslationUnit.getDeclarations()[1];
        IASTCompoundStatement iASTCompoundStatement = (IASTCompoundStatement)iASTFunctionDefinition.getBody();
        Assert.assertEquals((int)1, (int)iASTCompoundStatement.getStatements().length);
        IASTDeclarationStatement iASTDeclarationStatement = (IASTDeclarationStatement)iASTCompoundStatement.getStatements()[0];
        IASTSimpleDeclaration iASTSimpleDeclaration2 = (IASTSimpleDeclaration)iASTDeclarationStatement.getDeclaration();
        iASTElaboratedTypeSpecifier = (IASTElaboratedTypeSpecifier)iASTSimpleDeclaration2.getDeclSpecifier();
        IASTName iASTName2 = iASTElaboratedTypeSpecifier.getName();
        IASTDeclarator iASTDeclarator = iASTSimpleDeclaration2.getDeclarators()[0];
        IASTName iASTName3 = iASTDeclarator.getName();
        Assert.assertEquals((int)1, (int)iASTDeclarator.getPointerOperators().length);
        Assert.assertTrue((boolean)(iASTDeclarator.getPointerOperators()[0] instanceof ICASTPointer));
        ICompositeType iCompositeType = (ICompositeType)iASTName.resolveBinding();
        ICompositeType iCompositeType2 = (ICompositeType)iASTName2.resolveBinding();
        IVariable iVariable = (IVariable)iASTName3.resolveBinding();
        IPointerType iPointerType = (IPointerType)iVariable.getType();
        ICompositeType iCompositeType3 = (ICompositeType)iPointerType.getType();
        Assert.assertNotNull((Object)iCompositeType);
        Assert.assertSame((Object)iCompositeType, (Object)iCompositeType2);
        Assert.assertSame((Object)iCompositeType2, (Object)iCompositeType3);
        IASTName[] iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName);
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTFunctionDefinition.getDeclarator().getName().resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTFunctionDefinition.getDeclarator().getName());
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName2.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName);
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName3.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName3);
    }

    public void testStructureDef() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct A;                \r\n");
        stringBuffer.append("struct A * a;            \n");
        stringBuffer.append("struct A { int i; };     \n");
        stringBuffer.append("void f() {               \n");
        stringBuffer.append("   a->i;                 \n");
        stringBuffer.append("}                        \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.C);
        IASTSimpleDeclaration iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[0];
        IASTElaboratedTypeSpecifier iASTElaboratedTypeSpecifier = (IASTElaboratedTypeSpecifier)iASTSimpleDeclaration.getDeclSpecifier();
        Assert.assertEquals((int)0, (int)iASTSimpleDeclaration.getDeclarators().length);
        IASTName iASTName = iASTElaboratedTypeSpecifier.getName();
        IASTSimpleDeclaration iASTSimpleDeclaration2 = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[1];
        iASTElaboratedTypeSpecifier = (IASTElaboratedTypeSpecifier)iASTSimpleDeclaration2.getDeclSpecifier();
        IASTName iASTName2 = iASTElaboratedTypeSpecifier.getName();
        IASTDeclarator iASTDeclarator = iASTSimpleDeclaration2.getDeclarators()[0];
        IASTName iASTName3 = iASTDeclarator.getName();
        Assert.assertEquals((int)1, (int)iASTDeclarator.getPointerOperators().length);
        Assert.assertTrue((boolean)(iASTDeclarator.getPointerOperators()[0] instanceof ICASTPointer));
        IASTSimpleDeclaration iASTSimpleDeclaration3 = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[2];
        ICASTCompositeTypeSpecifier iCASTCompositeTypeSpecifier = (ICASTCompositeTypeSpecifier)iASTSimpleDeclaration3.getDeclSpecifier();
        IASTName iASTName4 = iCASTCompositeTypeSpecifier.getName();
        IASTSimpleDeclaration iASTSimpleDeclaration4 = (IASTSimpleDeclaration)iCASTCompositeTypeSpecifier.getMembers()[0];
        iASTDeclarator = iASTSimpleDeclaration4.getDeclarators()[0];
        IASTName iASTName5 = iASTDeclarator.getName();
        IASTFunctionDefinition iASTFunctionDefinition = (IASTFunctionDefinition)iASTTranslationUnit.getDeclarations()[3];
        IASTCompoundStatement iASTCompoundStatement = (IASTCompoundStatement)iASTFunctionDefinition.getBody();
        Assert.assertEquals((int)1, (int)iASTCompoundStatement.getStatements().length);
        IASTExpressionStatement iASTExpressionStatement = (IASTExpressionStatement)iASTCompoundStatement.getStatements()[0];
        IASTFieldReference iASTFieldReference = (IASTFieldReference)iASTExpressionStatement.getExpression();
        IASTIdExpression iASTIdExpression = (IASTIdExpression)iASTFieldReference.getFieldOwner();
        IASTName iASTName6 = iASTIdExpression.getName();
        IASTName iASTName7 = iASTFieldReference.getFieldName();
        IVariable iVariable = (IVariable)iASTName6.resolveBinding();
        IVariable iVariable2 = (IVariable)iASTName7.resolveBinding();
        IPointerType iPointerType = (IPointerType)iVariable.getType();
        ICompositeType iCompositeType = (ICompositeType)iPointerType.getType();
        ICompositeType iCompositeType2 = (ICompositeType)iASTName.resolveBinding();
        ICompositeType iCompositeType3 = (ICompositeType)iASTName2.resolveBinding();
        ICompositeType iCompositeType4 = (ICompositeType)iASTName4.resolveBinding();
        IVariable iVariable3 = (IVariable)iASTName3.resolveBinding();
        IVariable iVariable4 = (IVariable)iASTName5.resolveBinding();
        Assert.assertSame((Object)iVariable, (Object)iVariable3);
        Assert.assertSame((Object)iVariable2, (Object)iVariable4);
        Assert.assertSame((Object)iCompositeType, (Object)iCompositeType2);
        Assert.assertSame((Object)iCompositeType2, (Object)iCompositeType3);
        Assert.assertSame((Object)iCompositeType3, (Object)iCompositeType4);
        IASTName[] iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)2);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName);
        Assert.assertEquals((Object)iASTNameArray[1], (Object)iASTName4);
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName2.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)2);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName);
        Assert.assertEquals((Object)iASTNameArray[1], (Object)iASTName4);
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName3.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName3);
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName4.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)2);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName);
        Assert.assertEquals((Object)iASTNameArray[1], (Object)iASTName4);
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName5.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName5);
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTFunctionDefinition.getDeclarator().getName().resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTFunctionDefinition.getDeclarator().getName());
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName6.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName3);
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName7.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName5);
    }

    public void testStructureNamespace() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct x {};        \n");
        stringBuffer.append("void f( int x ) {   \n");
        stringBuffer.append("   struct x i;      \n");
        stringBuffer.append("}                   \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.C);
        IASTSimpleDeclaration iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[0];
        IASTCompositeTypeSpecifier iASTCompositeTypeSpecifier = (IASTCompositeTypeSpecifier)iASTSimpleDeclaration.getDeclSpecifier();
        IASTName iASTName = iASTCompositeTypeSpecifier.getName();
        IASTFunctionDefinition iASTFunctionDefinition = (IASTFunctionDefinition)iASTTranslationUnit.getDeclarations()[1];
        Assert.assertTrue((boolean)(iASTFunctionDefinition.getDeclarator() instanceof IASTStandardFunctionDeclarator));
        IASTParameterDeclaration iASTParameterDeclaration = ((IASTStandardFunctionDeclarator)iASTFunctionDefinition.getDeclarator()).getParameters()[0];
        IASTName iASTName2 = iASTParameterDeclaration.getDeclarator().getName();
        IASTCompoundStatement iASTCompoundStatement = (IASTCompoundStatement)iASTFunctionDefinition.getBody();
        IASTDeclarationStatement iASTDeclarationStatement = (IASTDeclarationStatement)iASTCompoundStatement.getStatements()[0];
        IASTSimpleDeclaration iASTSimpleDeclaration2 = (IASTSimpleDeclaration)iASTDeclarationStatement.getDeclaration();
        IASTElaboratedTypeSpecifier iASTElaboratedTypeSpecifier = (IASTElaboratedTypeSpecifier)iASTSimpleDeclaration2.getDeclSpecifier();
        IASTName iASTName3 = iASTElaboratedTypeSpecifier.getName();
        ICompositeType iCompositeType = (ICompositeType)iASTName.resolveBinding();
        IVariable iVariable = (IVariable)iASTName2.resolveBinding();
        ICompositeType iCompositeType2 = (ICompositeType)iASTName3.resolveBinding();
        Assert.assertNotNull((Object)iCompositeType);
        Assert.assertNotNull((Object)iVariable);
        Assert.assertSame((Object)iCompositeType, (Object)iCompositeType2);
        Assert.assertNotSame((Object)iVariable, (Object)iCompositeType2);
        IASTDeclarator iASTDeclarator = iASTSimpleDeclaration2.getDeclarators()[0];
        iASTDeclarator.getName().resolveBinding();
        IASTName[] iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName);
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTFunctionDefinition.getDeclarator().getName().resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTFunctionDefinition.getDeclarator().getName());
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName2.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName2);
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName3.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName);
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTSimpleDeclaration2.getDeclarators()[0].getName().resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTSimpleDeclaration2.getDeclarators()[0].getName());
    }

    public void testFunctionParameters() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void f( int a );        \n");
        stringBuffer.append("void f( int b ){        \n");
        stringBuffer.append("   b;                   \n");
        stringBuffer.append("}                       \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.C);
        IASTSimpleDeclaration iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[0];
        IASTStandardFunctionDeclarator iASTStandardFunctionDeclarator = (IASTStandardFunctionDeclarator)iASTSimpleDeclaration.getDeclarators()[0];
        IASTName iASTName = iASTStandardFunctionDeclarator.getName();
        IASTParameterDeclaration iASTParameterDeclaration = iASTStandardFunctionDeclarator.getParameters()[0];
        IASTDeclarator iASTDeclarator = iASTParameterDeclaration.getDeclarator();
        IASTName iASTName2 = iASTDeclarator.getName();
        IASTFunctionDefinition iASTFunctionDefinition = (IASTFunctionDefinition)iASTTranslationUnit.getDeclarations()[1];
        Assert.assertTrue((boolean)(iASTFunctionDefinition.getDeclarator() instanceof IASTStandardFunctionDeclarator));
        iASTStandardFunctionDeclarator = (IASTStandardFunctionDeclarator)iASTFunctionDefinition.getDeclarator();
        IASTName iASTName3 = iASTStandardFunctionDeclarator.getName();
        IASTParameterDeclaration iASTParameterDeclaration2 = iASTStandardFunctionDeclarator.getParameters()[0];
        iASTDeclarator = iASTParameterDeclaration2.getDeclarator();
        IASTName iASTName4 = iASTDeclarator.getName();
        IASTCompoundStatement iASTCompoundStatement = (IASTCompoundStatement)iASTFunctionDefinition.getBody();
        IASTExpressionStatement iASTExpressionStatement = (IASTExpressionStatement)iASTCompoundStatement.getStatements()[0];
        IASTIdExpression iASTIdExpression = (IASTIdExpression)iASTExpressionStatement.getExpression();
        IASTName iASTName5 = iASTIdExpression.getName();
        IParameter iParameter = (IParameter)iASTName5.resolveBinding();
        IParameter iParameter2 = (IParameter)iASTName4.resolveBinding();
        IParameter iParameter3 = (IParameter)iASTName2.resolveBinding();
        IFunction iFunction = (IFunction)iASTName.resolveBinding();
        IFunction iFunction2 = (IFunction)iASTName3.resolveBinding();
        Assert.assertNotNull((Object)iParameter);
        Assert.assertNotNull((Object)iFunction);
        Assert.assertSame((Object)iParameter, (Object)iParameter2);
        Assert.assertSame((Object)iParameter2, (Object)iParameter3);
        Assert.assertSame((Object)iFunction, (Object)iFunction2);
        CVisitor.clearBindings((IASTTranslationUnit)iASTTranslationUnit);
        iParameter = (IParameter)iASTName2.resolveBinding();
        iParameter2 = (IParameter)iASTName5.resolveBinding();
        iParameter3 = (IParameter)iASTName4.resolveBinding();
        iFunction = (IFunction)iASTName3.resolveBinding();
        iFunction2 = (IFunction)iASTName.resolveBinding();
        Assert.assertNotNull((Object)iParameter);
        Assert.assertNotNull((Object)iFunction);
        Assert.assertSame((Object)iParameter, (Object)iParameter2);
        Assert.assertSame((Object)iParameter2, (Object)iParameter3);
        Assert.assertSame((Object)iFunction, (Object)iFunction2);
        IASTName[] iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)2);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName);
        Assert.assertEquals((Object)iASTNameArray[1], (Object)iASTName3);
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName2.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)2);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName2);
        Assert.assertEquals((Object)iASTNameArray[1], (Object)iASTName4);
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName3.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)2);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName);
        Assert.assertEquals((Object)iASTNameArray[1], (Object)iASTName3);
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName4.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)2);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName2);
        Assert.assertEquals((Object)iASTNameArray[1], (Object)iASTName4);
    }

    public void testSimpleFunction() throws Exception {
        StringBuffer stringBuffer = new StringBuffer("void f( int a, int b ) { }  \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.C);
        IASTFunctionDefinition iASTFunctionDefinition = (IASTFunctionDefinition)iASTTranslationUnit.getDeclarations()[0];
        Assert.assertTrue((boolean)(iASTFunctionDefinition.getDeclarator() instanceof IASTStandardFunctionDeclarator));
        IASTStandardFunctionDeclarator iASTStandardFunctionDeclarator = (IASTStandardFunctionDeclarator)iASTFunctionDefinition.getDeclarator();
        IASTName iASTName = iASTStandardFunctionDeclarator.getName();
        IASTParameterDeclaration iASTParameterDeclaration = iASTStandardFunctionDeclarator.getParameters()[0];
        IASTName iASTName2 = iASTParameterDeclaration.getDeclarator().getName();
        IASTParameterDeclaration iASTParameterDeclaration2 = iASTStandardFunctionDeclarator.getParameters()[1];
        IASTName iASTName3 = iASTParameterDeclaration2.getDeclarator().getName();
        IFunction iFunction = (IFunction)iASTName.resolveBinding();
        IParameter iParameter = (IParameter)iASTName2.resolveBinding();
        IParameter iParameter2 = (IParameter)iASTName3.resolveBinding();
        Assert.assertEquals((String)"f", (String)iFunction.getName());
        Assert.assertEquals((String)"a", (String)iParameter.getName());
        Assert.assertEquals((String)"b", (String)iParameter2.getName());
        IParameter[] iParameterArray = iFunction.getParameters();
        Assert.assertEquals((int)2, (int)iParameterArray.length);
        Assert.assertSame((Object)iParameterArray[0], (Object)iParameter);
        Assert.assertSame((Object)iParameterArray[1], (Object)iParameter2);
        IASTName[] iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName);
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName2.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName2);
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName3.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName3);
    }

    public void testSimpleFunctionCall() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void f();              \n");
        stringBuffer.append("void g() {             \n");
        stringBuffer.append("   f();                \n");
        stringBuffer.append("}                      \n");
        stringBuffer.append("void f(){ }            \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.C);
        IASTSimpleDeclaration iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[0];
        IASTStandardFunctionDeclarator iASTStandardFunctionDeclarator = (IASTStandardFunctionDeclarator)iASTSimpleDeclaration.getDeclarators()[0];
        IASTName iASTName = iASTStandardFunctionDeclarator.getName();
        IASTFunctionDefinition iASTFunctionDefinition = (IASTFunctionDefinition)iASTTranslationUnit.getDeclarations()[1];
        IASTCompoundStatement iASTCompoundStatement = (IASTCompoundStatement)iASTFunctionDefinition.getBody();
        IASTExpressionStatement iASTExpressionStatement = (IASTExpressionStatement)iASTCompoundStatement.getStatements()[0];
        IASTFunctionCallExpression iASTFunctionCallExpression = (IASTFunctionCallExpression)iASTExpressionStatement.getExpression();
        IASTIdExpression iASTIdExpression = (IASTIdExpression)iASTFunctionCallExpression.getFunctionNameExpression();
        IASTName iASTName2 = iASTIdExpression.getName();
        Assert.assertNull((Object)iASTFunctionCallExpression.getParameterExpression());
        IASTFunctionDefinition iASTFunctionDefinition2 = (IASTFunctionDefinition)iASTTranslationUnit.getDeclarations()[2];
        Assert.assertTrue((boolean)(iASTFunctionDefinition2.getDeclarator() instanceof IASTStandardFunctionDeclarator));
        iASTStandardFunctionDeclarator = (IASTStandardFunctionDeclarator)iASTFunctionDefinition2.getDeclarator();
        IASTName iASTName3 = iASTStandardFunctionDeclarator.getName();
        IFunction iFunction = (IFunction)iASTName2.resolveBinding();
        IFunction iFunction2 = (IFunction)iASTName.resolveBinding();
        IFunction iFunction3 = (IFunction)iASTName3.resolveBinding();
        Assert.assertNotNull((Object)iFunction);
        Assert.assertSame((Object)iFunction, (Object)iFunction2);
        Assert.assertSame((Object)iFunction2, (Object)iFunction3);
        IASTName[] iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)2);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName);
        Assert.assertEquals((Object)iASTNameArray[1], (Object)iASTName3);
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTFunctionDefinition.getDeclarator().getName().resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTFunctionDefinition.getDeclarator().getName());
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName2.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)2);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName);
        Assert.assertEquals((Object)iASTNameArray[1], (Object)iASTName3);
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName3.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)2);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName);
        Assert.assertEquals((Object)iASTNameArray[1], (Object)iASTName3);
    }

    public void testForLoop() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void f() {                         \n");
        stringBuffer.append("   for( int i = 0; i < 5; i++ ) {  \n");
        stringBuffer.append("      i;                           \n");
        stringBuffer.append("   }                               \n");
        stringBuffer.append("}                                  \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.C);
        IASTFunctionDefinition iASTFunctionDefinition = (IASTFunctionDefinition)iASTTranslationUnit.getDeclarations()[0];
        IASTCompoundStatement iASTCompoundStatement = (IASTCompoundStatement)iASTFunctionDefinition.getBody();
        IASTForStatement iASTForStatement = (IASTForStatement)iASTCompoundStatement.getStatements()[0];
        IASTSimpleDeclaration iASTSimpleDeclaration = (IASTSimpleDeclaration)((IASTDeclarationStatement)iASTForStatement.getInitializerStatement()).getDeclaration();
        IASTDeclarator iASTDeclarator = iASTSimpleDeclaration.getDeclarators()[0];
        IASTName iASTName = iASTDeclarator.getName();
        IASTBinaryExpression iASTBinaryExpression = (IASTBinaryExpression)iASTForStatement.getConditionExpression();
        IASTIdExpression iASTIdExpression = (IASTIdExpression)iASTBinaryExpression.getOperand1();
        IASTName iASTName2 = iASTIdExpression.getName();
        IASTLiteralExpression iASTLiteralExpression = (IASTLiteralExpression)iASTBinaryExpression.getOperand2();
        Assert.assertEquals((int)0, (int)iASTLiteralExpression.getKind());
        IASTUnaryExpression iASTUnaryExpression = (IASTUnaryExpression)iASTForStatement.getIterationExpression();
        IASTIdExpression iASTIdExpression2 = (IASTIdExpression)iASTUnaryExpression.getOperand();
        IASTName iASTName3 = iASTIdExpression2.getName();
        Assert.assertEquals((int)9, (int)iASTUnaryExpression.getOperator());
        iASTCompoundStatement = (IASTCompoundStatement)iASTForStatement.getBody();
        IASTExpressionStatement iASTExpressionStatement = (IASTExpressionStatement)iASTCompoundStatement.getStatements()[0];
        IASTIdExpression iASTIdExpression3 = (IASTIdExpression)iASTExpressionStatement.getExpression();
        IASTName iASTName4 = iASTIdExpression3.getName();
        IVariable iVariable = (IVariable)iASTName4.resolveBinding();
        IVariable iVariable2 = (IVariable)iASTName.resolveBinding();
        IVariable iVariable3 = (IVariable)iASTName2.resolveBinding();
        IVariable iVariable4 = (IVariable)iASTName3.resolveBinding();
        Assert.assertSame((Object)iVariable, (Object)iVariable2);
        Assert.assertSame((Object)iVariable2, (Object)iVariable3);
        Assert.assertSame((Object)iVariable3, (Object)iVariable4);
        IASTName[] iASTNameArray = iASTTranslationUnit.getDeclarations(iASTFunctionDefinition.getDeclarator().getName().resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTFunctionDefinition.getDeclarator().getName());
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName);
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName2.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName);
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName3.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName);
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName4.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName);
    }

    public void testExpressionFieldReference() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct A { int x; };    \n");
        stringBuffer.append("void f(){               \n");
        stringBuffer.append("   ((struct A *) 1)->x; \n");
        stringBuffer.append("}                       \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.C);
        IASTSimpleDeclaration iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[0];
        IASTCompositeTypeSpecifier iASTCompositeTypeSpecifier = (IASTCompositeTypeSpecifier)iASTSimpleDeclaration.getDeclSpecifier();
        IASTSimpleDeclaration iASTSimpleDeclaration2 = (IASTSimpleDeclaration)iASTCompositeTypeSpecifier.getMembers()[0];
        IASTName iASTName = iASTSimpleDeclaration2.getDeclarators()[0].getName();
        IASTFunctionDefinition iASTFunctionDefinition = (IASTFunctionDefinition)iASTTranslationUnit.getDeclarations()[1];
        IASTCompoundStatement iASTCompoundStatement = (IASTCompoundStatement)iASTFunctionDefinition.getBody();
        IASTExpressionStatement iASTExpressionStatement = (IASTExpressionStatement)iASTCompoundStatement.getStatements()[0];
        IASTFieldReference iASTFieldReference = (IASTFieldReference)iASTExpressionStatement.getExpression();
        IASTName iASTName2 = iASTFieldReference.getFieldName();
        IField iField = (IField)iASTName.resolveBinding();
        IField iField2 = (IField)iASTName2.resolveBinding();
        Assert.assertNotNull((Object)iField);
        Assert.assertSame((Object)iField, (Object)iField2);
        IASTName[] iASTNameArray = iASTTranslationUnit.getDeclarations(iASTCompositeTypeSpecifier.getName().resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTCompositeTypeSpecifier.getName());
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName);
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTFunctionDefinition.getDeclarator().getName().resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTFunctionDefinition.getDeclarator().getName());
        IASTCastExpression iASTCastExpression = (IASTCastExpression)((IASTUnaryExpression)((IASTFieldReference)iASTExpressionStatement.getExpression()).getFieldOwner()).getOperand();
        IASTElaboratedTypeSpecifier iASTElaboratedTypeSpecifier = (IASTElaboratedTypeSpecifier)iASTCastExpression.getTypeId().getDeclSpecifier();
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTElaboratedTypeSpecifier.getName().resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTCompositeTypeSpecifier.getName());
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName2.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName);
    }

    public void testLabels() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void f() {          \n");
        stringBuffer.append("   while( 1 ) {     \n");
        stringBuffer.append("      if( 1 )       \n");
        stringBuffer.append("         goto end;  \n");
        stringBuffer.append("   }                \n");
        stringBuffer.append("   end: ;           \n");
        stringBuffer.append("}                   \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.C);
        AST2BaseTest.CNameCollector cNameCollector = new AST2BaseTest.CNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cNameCollector);
        Assert.assertEquals((int)cNameCollector.size(), (int)3);
        IFunction iFunction = (IFunction)cNameCollector.getName(0).resolveBinding();
        ILabel iLabel = (ILabel)cNameCollector.getName(1).resolveBinding();
        ILabel iLabel2 = (ILabel)cNameCollector.getName(2).resolveBinding();
        Assert.assertNotNull((Object)iFunction);
        Assert.assertNotNull((Object)iLabel);
        Assert.assertEquals((Object)iLabel, (Object)iLabel2);
        IASTName[] iASTNameArray = iASTTranslationUnit.getDeclarations(cNameCollector.getName(0).resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)cNameCollector.getName(0));
        iASTNameArray = iASTTranslationUnit.getDeclarations(cNameCollector.getName(1).resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)cNameCollector.getName(2));
        iASTNameArray = iASTTranslationUnit.getDeclarations(cNameCollector.getName(2).resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)cNameCollector.getName(2));
    }

    public void testAnonStruct() throws Exception {
        StringBuffer stringBuffer = new StringBuffer("typedef struct { } X;\n");
        stringBuffer.append("int f( X x );");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.C);
        IASTSimpleDeclaration iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[0];
        IASTSimpleDeclaration iASTSimpleDeclaration2 = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[1];
        IASTName iASTName = iASTSimpleDeclaration.getDeclarators()[0].getName();
        IASTName iASTName2 = iASTSimpleDeclaration2.getDeclarators()[0].getName();
        IASTName iASTName3 = ((IASTNamedTypeSpecifier)((IASTStandardFunctionDeclarator)iASTSimpleDeclaration2.getDeclarators()[0]).getParameters()[0].getDeclSpecifier()).getName();
        IASTName iASTName4 = ((IASTStandardFunctionDeclarator)iASTSimpleDeclaration2.getDeclarators()[0]).getParameters()[0].getDeclarator().getName();
        IASTName[] iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName);
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName2.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName2);
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName3.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName);
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName4.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName4);
    }

    public void testLongLong() throws ParserException {
        IASTTranslationUnit iASTTranslationUnit = this.parse("long long x;\n", ParserLanguage.C);
        IASTSimpleDeclaration iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[0];
        IASTName iASTName = iASTSimpleDeclaration.getDeclarators()[0].getName();
        IASTName[] iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName);
    }

    public void testEnumerations() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("enum hue { red, blue, green };     \n");
        stringBuffer.append("enum hue col, *cp;                 \n");
        stringBuffer.append("void f() {                         \n");
        stringBuffer.append("   col = blue;                     \n");
        stringBuffer.append("   cp = &col;                      \n");
        stringBuffer.append("   if( *cp != red )                \n");
        stringBuffer.append("      return;                      \n");
        stringBuffer.append("}                                  \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.C);
        IASTSimpleDeclaration iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[0];
        Assert.assertEquals((int)iASTSimpleDeclaration.getDeclarators().length, (int)0);
        ICASTEnumerationSpecifier iCASTEnumerationSpecifier = (ICASTEnumerationSpecifier)iASTSimpleDeclaration.getDeclSpecifier();
        IASTEnumerationSpecifier.IASTEnumerator iASTEnumerator = iCASTEnumerationSpecifier.getEnumerators()[0];
        IASTEnumerationSpecifier.IASTEnumerator iASTEnumerator2 = iCASTEnumerationSpecifier.getEnumerators()[1];
        IASTEnumerationSpecifier.IASTEnumerator iASTEnumerator3 = iCASTEnumerationSpecifier.getEnumerators()[2];
        IASTName iASTName = iCASTEnumerationSpecifier.getName();
        IASTSimpleDeclaration iASTSimpleDeclaration2 = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[1];
        IASTDeclarator iASTDeclarator = iASTSimpleDeclaration2.getDeclarators()[0];
        IASTName iASTName2 = iASTDeclarator.getName();
        iASTDeclarator = iASTSimpleDeclaration2.getDeclarators()[1];
        IASTName iASTName3 = iASTDeclarator.getName();
        IASTElaboratedTypeSpecifier iASTElaboratedTypeSpecifier = (IASTElaboratedTypeSpecifier)iASTSimpleDeclaration2.getDeclSpecifier();
        Assert.assertEquals((int)iASTElaboratedTypeSpecifier.getKind(), (int)0);
        IASTName iASTName4 = iASTElaboratedTypeSpecifier.getName();
        IASTFunctionDefinition iASTFunctionDefinition = (IASTFunctionDefinition)iASTTranslationUnit.getDeclarations()[2];
        IASTCompoundStatement iASTCompoundStatement = (IASTCompoundStatement)iASTFunctionDefinition.getBody();
        IASTExpressionStatement iASTExpressionStatement = (IASTExpressionStatement)iASTCompoundStatement.getStatements()[0];
        IASTBinaryExpression iASTBinaryExpression = (IASTBinaryExpression)iASTExpressionStatement.getExpression();
        Assert.assertEquals((int)iASTBinaryExpression.getOperator(), (int)17);
        IASTIdExpression iASTIdExpression = (IASTIdExpression)iASTBinaryExpression.getOperand1();
        IASTIdExpression iASTIdExpression2 = (IASTIdExpression)iASTBinaryExpression.getOperand2();
        IASTName iASTName5 = iASTIdExpression.getName();
        IASTName iASTName6 = iASTIdExpression2.getName();
        IASTExpressionStatement iASTExpressionStatement2 = (IASTExpressionStatement)iASTCompoundStatement.getStatements()[1];
        iASTBinaryExpression = (IASTBinaryExpression)iASTExpressionStatement2.getExpression();
        Assert.assertEquals((int)iASTBinaryExpression.getOperator(), (int)17);
        iASTIdExpression = (IASTIdExpression)iASTBinaryExpression.getOperand1();
        IASTUnaryExpression iASTUnaryExpression = (IASTUnaryExpression)iASTBinaryExpression.getOperand2();
        iASTIdExpression2 = (IASTIdExpression)iASTUnaryExpression.getOperand();
        IASTName iASTName7 = iASTIdExpression.getName();
        IASTName iASTName8 = iASTIdExpression2.getName();
        IASTIfStatement iASTIfStatement = (IASTIfStatement)iASTCompoundStatement.getStatements()[2];
        iASTBinaryExpression = (IASTBinaryExpression)iASTIfStatement.getConditionExpression();
        iASTUnaryExpression = (IASTUnaryExpression)iASTBinaryExpression.getOperand1();
        iASTIdExpression = (IASTIdExpression)iASTUnaryExpression.getOperand();
        iASTIdExpression2 = (IASTIdExpression)iASTBinaryExpression.getOperand2();
        IASTName iASTName9 = iASTIdExpression.getName();
        IASTName iASTName10 = iASTIdExpression2.getName();
        IEnumeration iEnumeration = (IEnumeration)iASTName.resolveBinding();
        IEnumerator iEnumerator = (IEnumerator)iASTEnumerator.getName().resolveBinding();
        IEnumerator iEnumerator2 = (IEnumerator)iASTEnumerator2.getName().resolveBinding();
        IEnumerator iEnumerator3 = (IEnumerator)iASTEnumerator3.getName().resolveBinding();
        IVariable iVariable = (IVariable)iASTName2.resolveBinding();
        IVariable iVariable2 = (IVariable)iASTName3.resolveBinding();
        IEnumeration iEnumeration2 = (IEnumeration)iASTName4.resolveBinding();
        IVariable iVariable3 = (IVariable)iASTName5.resolveBinding();
        IEnumerator iEnumerator4 = (IEnumerator)iASTName6.resolveBinding();
        IVariable iVariable4 = (IVariable)iASTName7.resolveBinding();
        IVariable iVariable5 = (IVariable)iASTName8.resolveBinding();
        IVariable iVariable6 = (IVariable)iASTName9.resolveBinding();
        IEnumerator iEnumerator5 = (IEnumerator)iASTName10.resolveBinding();
        Assert.assertNotNull((Object)iEnumeration);
        Assert.assertSame((Object)iEnumeration, (Object)iEnumeration2);
        Assert.assertNotNull((Object)iEnumerator);
        Assert.assertNotNull((Object)iEnumerator3);
        Assert.assertNotNull((Object)iEnumerator2);
        Assert.assertNotNull((Object)iVariable);
        Assert.assertNotNull((Object)iVariable2);
        Assert.assertSame((Object)iVariable, (Object)iVariable3);
        Assert.assertSame((Object)iEnumerator2, (Object)iEnumerator4);
        Assert.assertSame((Object)iVariable2, (Object)iVariable4);
        Assert.assertSame((Object)iVariable, (Object)iVariable5);
        Assert.assertSame((Object)iVariable2, (Object)iVariable6);
        Assert.assertSame((Object)iEnumerator, (Object)iEnumerator5);
        IASTName[] iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName);
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTEnumerator.getName().resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTEnumerator.getName());
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTEnumerator2.getName().resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTEnumerator2.getName());
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTEnumerator3.getName().resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTEnumerator3.getName());
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName4.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName);
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName2.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName2);
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName3.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName3);
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTFunctionDefinition.getDeclarator().getName().resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTFunctionDefinition.getDeclarator().getName());
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName5.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName2);
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName6.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTEnumerator2.getName());
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName7.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName3);
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName8.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName2);
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName9.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName3);
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName10.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTEnumerator.getName());
    }

    public void testPointerToFunction() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("int (*pfi)();", ParserLanguage.C);
        Assert.assertEquals((int)iASTTranslationUnit.getDeclarations().length, (int)1);
        IASTSimpleDeclaration iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[0];
        Assert.assertEquals((int)iASTSimpleDeclaration.getDeclarators().length, (int)1);
        IASTStandardFunctionDeclarator iASTStandardFunctionDeclarator = (IASTStandardFunctionDeclarator)iASTSimpleDeclaration.getDeclarators()[0];
        Assert.assertEquals((String)iASTStandardFunctionDeclarator.getName().toString(), (String)"");
        Assert.assertNotNull((Object)iASTStandardFunctionDeclarator.getNestedDeclarator());
        Assert.assertEquals((String)iASTStandardFunctionDeclarator.getNestedDeclarator().getName().toString(), (String)"pfi");
        Assert.assertTrue((iASTStandardFunctionDeclarator.getPointerOperators().length == 0 ? 1 : 0) != 0);
        Assert.assertFalse((iASTStandardFunctionDeclarator.getNestedDeclarator().getPointerOperators().length == 0 ? 1 : 0) != 0);
        IASTName[] iASTNameArray = iASTTranslationUnit.getDeclarations(iASTStandardFunctionDeclarator.getNestedDeclarator().getName().resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTStandardFunctionDeclarator.getNestedDeclarator().getName());
    }

    public void testBasicTypes() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int a;       \n");
        stringBuffer.append("char * b;    \n");
        stringBuffer.append("const int c; \n");
        stringBuffer.append("const char * const d; \n");
        stringBuffer.append("const char ** e; \n");
        stringBuffer.append("const char * const * const volatile ** const * f; \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.C);
        IASTSimpleDeclaration iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[0];
        IVariable iVariable = (IVariable)iASTSimpleDeclaration.getDeclarators()[0].getName().resolveBinding();
        iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[1];
        IVariable iVariable2 = (IVariable)iASTSimpleDeclaration.getDeclarators()[0].getName().resolveBinding();
        iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[2];
        IVariable iVariable3 = (IVariable)iASTSimpleDeclaration.getDeclarators()[0].getName().resolveBinding();
        iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[3];
        IVariable iVariable4 = (IVariable)iASTSimpleDeclaration.getDeclarators()[0].getName().resolveBinding();
        iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[4];
        IVariable iVariable5 = (IVariable)iASTSimpleDeclaration.getDeclarators()[0].getName().resolveBinding();
        iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[5];
        IVariable iVariable6 = (IVariable)iASTSimpleDeclaration.getDeclarators()[0].getName().resolveBinding();
        IType iType = iVariable.getType();
        Assert.assertTrue((boolean)(iType instanceof IBasicType));
        Assert.assertFalse((boolean)((IBasicType)iType).isLong());
        Assert.assertFalse((boolean)((IBasicType)iType).isShort());
        Assert.assertFalse((boolean)((IBasicType)iType).isSigned());
        Assert.assertFalse((boolean)((IBasicType)iType).isUnsigned());
        Assert.assertEquals((int)((IBasicType)iType).getType(), (int)3);
        IType iType2 = iVariable2.getType();
        Assert.assertTrue((boolean)(iType2 instanceof IPointerType));
        IType iType3 = ((IPointerType)iType2).getType();
        Assert.assertTrue((boolean)(iType3 instanceof IBasicType));
        Assert.assertEquals((int)((IBasicType)iType3).getType(), (int)2);
        IType iType4 = iVariable3.getType();
        Assert.assertTrue((boolean)(iType4 instanceof IQualifierType));
        Assert.assertTrue((boolean)((IQualifierType)iType4).isConst());
        IType iType5 = ((IQualifierType)iType4).getType();
        Assert.assertTrue((boolean)(iType5 instanceof IBasicType));
        Assert.assertEquals((int)((IBasicType)iType5).getType(), (int)3);
        IType iType6 = iVariable4.getType();
        Assert.assertTrue((boolean)(iType6 instanceof IPointerType));
        Assert.assertTrue((boolean)((IPointerType)iType6).isConst());
        IType iType7 = ((IPointerType)iType6).getType();
        Assert.assertTrue((boolean)(iType7 instanceof IQualifierType));
        Assert.assertTrue((boolean)((IQualifierType)iType7).isConst());
        IType iType8 = ((IQualifierType)iType7).getType();
        Assert.assertTrue((boolean)(iType8 instanceof IBasicType));
        Assert.assertEquals((int)((IBasicType)iType8).getType(), (int)2);
        IType iType9 = iVariable5.getType();
        Assert.assertTrue((boolean)(iType9 instanceof IPointerType));
        Assert.assertFalse((boolean)((IPointerType)iType9).isConst());
        IType iType10 = ((IPointerType)iType9).getType();
        Assert.assertTrue((boolean)(iType10 instanceof IPointerType));
        Assert.assertFalse((boolean)((IPointerType)iType10).isConst());
        IType iType11 = ((IPointerType)iType10).getType();
        Assert.assertTrue((boolean)(iType11 instanceof IQualifierType));
        Assert.assertTrue((boolean)((IQualifierType)iType11).isConst());
        IType iType12 = ((IQualifierType)iType11).getType();
        Assert.assertTrue((boolean)(iType12 instanceof IBasicType));
        Assert.assertEquals((int)((IBasicType)iType12).getType(), (int)2);
        IType iType13 = iVariable6.getType();
        Assert.assertTrue((boolean)(iType13 instanceof IPointerType));
        Assert.assertFalse((boolean)((IPointerType)iType13).isConst());
        Assert.assertFalse((boolean)((IPointerType)iType13).isVolatile());
        IType iType14 = ((IPointerType)iType13).getType();
        Assert.assertTrue((boolean)(iType14 instanceof IPointerType));
        Assert.assertTrue((boolean)((IPointerType)iType14).isConst());
        Assert.assertFalse((boolean)((IPointerType)iType14).isVolatile());
        IType iType15 = ((IPointerType)iType14).getType();
        Assert.assertTrue((boolean)(iType15 instanceof IPointerType));
        Assert.assertFalse((boolean)((IPointerType)iType15).isConst());
        Assert.assertFalse((boolean)((IPointerType)iType15).isVolatile());
        IType iType16 = ((IPointerType)iType15).getType();
        Assert.assertTrue((boolean)(iType16 instanceof IPointerType));
        Assert.assertTrue((boolean)((IPointerType)iType16).isConst());
        Assert.assertTrue((boolean)((IPointerType)iType16).isVolatile());
        IType iType17 = ((IPointerType)iType16).getType();
        Assert.assertTrue((boolean)(iType17 instanceof IPointerType));
        Assert.assertTrue((boolean)((IPointerType)iType17).isConst());
        Assert.assertFalse((boolean)((IPointerType)iType17).isVolatile());
        IType iType18 = ((IPointerType)iType17).getType();
        Assert.assertTrue((boolean)(iType18 instanceof IQualifierType));
        Assert.assertTrue((boolean)((IQualifierType)iType18).isConst());
        IType iType19 = ((IQualifierType)iType18).getType();
        Assert.assertTrue((boolean)(iType19 instanceof IBasicType));
        Assert.assertEquals((int)((IBasicType)iType19).getType(), (int)2);
    }

    public void testCompositeTypes() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct A {} a1;              \n");
        stringBuffer.append("typedef struct A * AP;       \n");
        stringBuffer.append("struct A * const a2;         \n");
        stringBuffer.append("AP a3;                       \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.C);
        IASTSimpleDeclaration iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[0];
        IASTCompositeTypeSpecifier iASTCompositeTypeSpecifier = (IASTCompositeTypeSpecifier)iASTSimpleDeclaration.getDeclSpecifier();
        ICompositeType iCompositeType = (ICompositeType)iASTCompositeTypeSpecifier.getName().resolveBinding();
        IASTName iASTName = iASTSimpleDeclaration.getDeclarators()[0].getName();
        IVariable iVariable = (IVariable)iASTSimpleDeclaration.getDeclarators()[0].getName().resolveBinding();
        iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[1];
        IASTName iASTName2 = ((IASTElaboratedTypeSpecifier)iASTSimpleDeclaration.getDeclSpecifier()).getName();
        IASTName iASTName3 = iASTSimpleDeclaration.getDeclarators()[0].getName();
        ITypedef iTypedef = (ITypedef)iASTSimpleDeclaration.getDeclarators()[0].getName().resolveBinding();
        iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[2];
        IASTName iASTName4 = ((IASTElaboratedTypeSpecifier)iASTSimpleDeclaration.getDeclSpecifier()).getName();
        IVariable iVariable2 = (IVariable)iASTSimpleDeclaration.getDeclarators()[0].getName().resolveBinding();
        IASTName iASTName5 = iASTSimpleDeclaration.getDeclarators()[0].getName();
        iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[3];
        IVariable iVariable3 = (IVariable)iASTSimpleDeclaration.getDeclarators()[0].getName().resolveBinding();
        IASTName iASTName6 = iASTSimpleDeclaration.getDeclarators()[0].getName();
        IASTName iASTName7 = ((IASTNamedTypeSpecifier)iASTSimpleDeclaration.getDeclSpecifier()).getName();
        IType iType = iVariable.getType();
        Assert.assertSame((Object)iType, (Object)iCompositeType);
        IType iType2 = iVariable2.getType();
        Assert.assertTrue((boolean)(iType2 instanceof IPointerType));
        Assert.assertTrue((boolean)((IPointerType)iType2).isConst());
        Assert.assertSame((Object)((IPointerType)iType2).getType(), (Object)iCompositeType);
        IType iType3 = iVariable3.getType();
        Assert.assertSame((Object)iType3, (Object)iTypedef);
        IType iType4 = iTypedef.getType();
        Assert.assertTrue((boolean)(iType4 instanceof IPointerType));
        Assert.assertSame((Object)((IPointerType)iType4).getType(), (Object)iCompositeType);
        IASTName[] iASTNameArray = iASTTranslationUnit.getDeclarations(iASTCompositeTypeSpecifier.getName().resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTCompositeTypeSpecifier.getName());
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName);
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName2.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTCompositeTypeSpecifier.getName());
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName3.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName3);
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName4.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTCompositeTypeSpecifier.getName());
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName5.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName5);
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName7.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName3);
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName6.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName6);
    }

    public void testArrayTypes() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int a[restrict];       \n");
        stringBuffer.append("char * b[][];    \n");
        stringBuffer.append("const char * const c[][][]; \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.C);
        IASTSimpleDeclaration iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[0];
        IASTName iASTName = iASTSimpleDeclaration.getDeclarators()[0].getName();
        IVariable iVariable = (IVariable)iASTSimpleDeclaration.getDeclarators()[0].getName().resolveBinding();
        iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[1];
        IASTName iASTName2 = iASTSimpleDeclaration.getDeclarators()[0].getName();
        IVariable iVariable2 = (IVariable)iASTSimpleDeclaration.getDeclarators()[0].getName().resolveBinding();
        iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[2];
        IASTName iASTName3 = iASTSimpleDeclaration.getDeclarators()[0].getName();
        IVariable iVariable3 = (IVariable)iASTSimpleDeclaration.getDeclarators()[0].getName().resolveBinding();
        IType iType = iVariable.getType();
        Assert.assertTrue((boolean)(iType instanceof ICArrayType));
        Assert.assertTrue((boolean)((ICArrayType)iType).isRestrict());
        IType iType2 = ((IArrayType)iType).getType();
        Assert.assertTrue((boolean)(iType2 instanceof IBasicType));
        Assert.assertEquals((int)((IBasicType)iType2).getType(), (int)3);
        IType iType3 = iVariable2.getType();
        Assert.assertTrue((boolean)(iType3 instanceof IArrayType));
        IType iType4 = ((IArrayType)iType3).getType();
        Assert.assertTrue((boolean)(iType4 instanceof IArrayType));
        IType iType5 = ((IArrayType)iType4).getType();
        Assert.assertTrue((boolean)(iType5 instanceof IPointerType));
        IType iType6 = ((IPointerType)iType5).getType();
        Assert.assertTrue((boolean)(iType6 instanceof IBasicType));
        Assert.assertEquals((int)((IBasicType)iType6).getType(), (int)2);
        IType iType7 = iVariable3.getType();
        Assert.assertTrue((boolean)(iType7 instanceof IArrayType));
        IType iType8 = ((IArrayType)iType7).getType();
        Assert.assertTrue((boolean)(iType8 instanceof IArrayType));
        IType iType9 = ((IArrayType)iType8).getType();
        Assert.assertTrue((boolean)(iType9 instanceof IArrayType));
        IType iType10 = ((IArrayType)iType9).getType();
        Assert.assertTrue((boolean)(iType10 instanceof IPointerType));
        Assert.assertTrue((boolean)((IPointerType)iType10).isConst());
        IType iType11 = ((IPointerType)iType10).getType();
        Assert.assertTrue((boolean)(iType11 instanceof IQualifierType));
        Assert.assertTrue((boolean)((IQualifierType)iType11).isConst());
        IType iType12 = ((IQualifierType)iType11).getType();
        Assert.assertTrue((boolean)(iType12 instanceof IBasicType));
        Assert.assertEquals((int)((IBasicType)iType12).getType(), (int)2);
        IASTName[] iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName);
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName2.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName2);
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName3.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName3);
    }

    public void testFunctionTypes() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct A;                           \n");
        stringBuffer.append("int * f( int i, char c );           \n");
        stringBuffer.append("void ( *g ) ( struct A * );         \n");
        stringBuffer.append("void (* (*h)(struct A**) ) ( int d ); \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.C);
        IASTSimpleDeclaration iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[0];
        IASTElaboratedTypeSpecifier iASTElaboratedTypeSpecifier = (IASTElaboratedTypeSpecifier)iASTSimpleDeclaration.getDeclSpecifier();
        ICompositeType iCompositeType = (ICompositeType)iASTElaboratedTypeSpecifier.getName().resolveBinding();
        IASTName iASTName = iASTElaboratedTypeSpecifier.getName();
        Assert.assertTrue((boolean)iASTName.isDeclaration());
        iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[1];
        IFunction iFunction = (IFunction)iASTSimpleDeclaration.getDeclarators()[0].getName().resolveBinding();
        IASTName iASTName2 = iASTSimpleDeclaration.getDeclarators()[0].getName();
        IASTName iASTName3 = ((IASTStandardFunctionDeclarator)iASTSimpleDeclaration.getDeclarators()[0]).getParameters()[0].getDeclarator().getName();
        IASTName iASTName4 = ((IASTStandardFunctionDeclarator)iASTSimpleDeclaration.getDeclarators()[0]).getParameters()[1].getDeclarator().getName();
        iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[2];
        IVariable iVariable = (IVariable)iASTSimpleDeclaration.getDeclarators()[0].getNestedDeclarator().getName().resolveBinding();
        IASTName iASTName5 = iASTSimpleDeclaration.getDeclarators()[0].getNestedDeclarator().getName();
        IASTName iASTName6 = ((IASTElaboratedTypeSpecifier)((IASTStandardFunctionDeclarator)iASTSimpleDeclaration.getDeclarators()[0]).getParameters()[0].getDeclSpecifier()).getName();
        iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[3];
        IVariable iVariable2 = (IVariable)iASTSimpleDeclaration.getDeclarators()[0].getNestedDeclarator().getNestedDeclarator().getName().resolveBinding();
        IASTName iASTName7 = iASTSimpleDeclaration.getDeclarators()[0].getNestedDeclarator().getNestedDeclarator().getName();
        IASTName iASTName8 = ((IASTElaboratedTypeSpecifier)((IASTStandardFunctionDeclarator)iASTSimpleDeclaration.getDeclarators()[0].getNestedDeclarator()).getParameters()[0].getDeclSpecifier()).getName();
        IASTName iASTName9 = ((IASTStandardFunctionDeclarator)iASTSimpleDeclaration.getDeclarators()[0]).getParameters()[0].getDeclarator().getName();
        IFunctionType iFunctionType = iFunction.getType();
        IType iType = iFunctionType.getReturnType();
        Assert.assertTrue((boolean)(iType instanceof IPointerType));
        Assert.assertTrue((boolean)(((IPointerType)iType).getType() instanceof IBasicType));
        IType[] iTypeArray = iFunctionType.getParameterTypes();
        Assert.assertEquals((int)iTypeArray.length, (int)2);
        Assert.assertTrue((boolean)(iTypeArray[0] instanceof IBasicType));
        Assert.assertTrue((boolean)(iTypeArray[1] instanceof IBasicType));
        IType iType2 = iVariable.getType();
        Assert.assertTrue((boolean)(iType2 instanceof IPointerType));
        Assert.assertTrue((boolean)(((IPointerType)iType2).getType() instanceof IFunctionType));
        IFunctionType iFunctionType2 = (IFunctionType)((IPointerType)iType2).getType();
        IType iType3 = iFunctionType2.getReturnType();
        Assert.assertTrue((boolean)(iType3 instanceof IBasicType));
        IType[] iTypeArray2 = iFunctionType2.getParameterTypes();
        Assert.assertEquals((int)iTypeArray2.length, (int)1);
        IType iType4 = iTypeArray2[0];
        Assert.assertTrue((boolean)(iType4 instanceof IPointerType));
        Assert.assertSame((Object)((IPointerType)iType4).getType(), (Object)iCompositeType);
        IType iType5 = iVariable2.getType();
        Assert.assertTrue((boolean)(iType5 instanceof IPointerType));
        Assert.assertTrue((boolean)(((IPointerType)iType5).getType() instanceof IFunctionType));
        IFunctionType iFunctionType3 = (IFunctionType)((IPointerType)iType5).getType();
        IType iType6 = iFunctionType3.getReturnType();
        IType[] iTypeArray3 = iFunctionType3.getParameterTypes();
        Assert.assertEquals((int)iTypeArray3.length, (int)1);
        IType iType7 = iTypeArray3[0];
        Assert.assertTrue((boolean)(iType7 instanceof IPointerType));
        Assert.assertTrue((boolean)(((IPointerType)iType7).getType() instanceof IPointerType));
        Assert.assertSame((Object)((IPointerType)((IPointerType)iType7).getType()).getType(), (Object)iCompositeType);
        Assert.assertTrue((boolean)(iType6 instanceof IPointerType));
        IFunctionType iFunctionType4 = (IFunctionType)((IPointerType)iType6).getType();
        IType iType8 = iFunctionType4.getReturnType();
        IType[] iTypeArray4 = iFunctionType4.getParameterTypes();
        Assert.assertTrue((boolean)(iType8 instanceof IBasicType));
        Assert.assertEquals((int)iTypeArray4.length, (int)1);
        Assert.assertTrue((boolean)(iTypeArray4[0] instanceof IBasicType));
        IASTName[] iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName);
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName2.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName2);
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName3.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName3);
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName4.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName4);
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName5.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName5);
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName6.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName);
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName7.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName7);
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName8.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName);
        Assert.assertNull((Object)iASTName9.resolveBinding());
    }

    public void testDesignatedInitializers() throws ParserException {
        StringBuffer stringBuffer = new StringBuffer("typedef struct {\n");
        stringBuffer.append(" int x;\n");
        stringBuffer.append(" int y;\n");
        stringBuffer.append("} Coord;\n");
        stringBuffer.append("typedef struct {\n");
        stringBuffer.append("Coord *pos;\n");
        stringBuffer.append("int width;\n");
        stringBuffer.append("} Point;\n");
        stringBuffer.append("int main(int argc, char *argv[])\n");
        stringBuffer.append("{\n");
        stringBuffer.append("Coord xy = {.y = 10, .x = 11};\n");
        stringBuffer.append("Point point = {.width = 100, .pos = &xy};\n");
        stringBuffer.append("}\n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.C);
        Assert.assertNotNull((Object)iASTTranslationUnit);
        IASTDeclaration[] iASTDeclarationArray = iASTTranslationUnit.getDeclarations();
        IASTName iASTName = ((IASTSimpleDeclaration)iASTDeclarationArray[0]).getDeclarators()[0].getName();
        IASTName iASTName2 = ((IASTSimpleDeclaration)((IASTCompositeTypeSpecifier)((IASTSimpleDeclaration)iASTDeclarationArray[0]).getDeclSpecifier()).getMembers()[0]).getDeclarators()[0].getName();
        IASTName iASTName3 = ((IASTSimpleDeclaration)((IASTCompositeTypeSpecifier)((IASTSimpleDeclaration)iASTDeclarationArray[0]).getDeclSpecifier()).getMembers()[1]).getDeclarators()[0].getName();
        IASTName iASTName4 = ((IASTSimpleDeclaration)iASTDeclarationArray[1]).getDeclarators()[0].getName();
        IASTName iASTName5 = ((IASTSimpleDeclaration)((IASTCompositeTypeSpecifier)((IASTSimpleDeclaration)iASTDeclarationArray[1]).getDeclSpecifier()).getMembers()[0]).getDeclarators()[0].getName();
        IASTName iASTName6 = ((IASTSimpleDeclaration)((IASTCompositeTypeSpecifier)((IASTSimpleDeclaration)iASTDeclarationArray[1]).getDeclSpecifier()).getMembers()[1]).getDeclarators()[0].getName();
        IASTFunctionDefinition iASTFunctionDefinition = (IASTFunctionDefinition)iASTDeclarationArray[2];
        IASTStatement[] iASTStatementArray = ((IASTCompoundStatement)iASTFunctionDefinition.getBody()).getStatements();
        IASTSimpleDeclaration iASTSimpleDeclaration = (IASTSimpleDeclaration)((IASTDeclarationStatement)iASTStatementArray[0]).getDeclaration();
        IASTName iASTName7 = ((IASTNamedTypeSpecifier)iASTSimpleDeclaration.getDeclSpecifier()).getName();
        IASTName iASTName8 = iASTSimpleDeclaration.getDeclarators()[0].getName();
        IASTDeclarator iASTDeclarator = iASTSimpleDeclaration.getDeclarators()[0];
        IASTInitializer[] iASTInitializerArray = ((IASTInitializerList)iASTDeclarator.getInitializer()).getInitializers();
        IASTName iASTName9 = ((ICASTFieldDesignator)((ICASTDesignatedInitializer)iASTInitializerArray[0]).getDesignators()[0]).getName();
        Assert.assertEquals((int)((ASTNode)((ICASTDesignatedInitializer)iASTInitializerArray[0])).getLength(), (int)7);
        IASTName iASTName10 = ((ICASTFieldDesignator)((ICASTDesignatedInitializer)iASTInitializerArray[1]).getDesignators()[0]).getName();
        IASTSimpleDeclaration iASTSimpleDeclaration2 = (IASTSimpleDeclaration)((IASTDeclarationStatement)iASTStatementArray[1]).getDeclaration();
        IASTName iASTName11 = ((IASTNamedTypeSpecifier)iASTSimpleDeclaration2.getDeclSpecifier()).getName();
        IASTName iASTName12 = iASTSimpleDeclaration2.getDeclarators()[0].getName();
        IASTDeclarator iASTDeclarator2 = iASTSimpleDeclaration2.getDeclarators()[0];
        IASTInitializer[] iASTInitializerArray2 = ((IASTInitializerList)iASTDeclarator2.getInitializer()).getInitializers();
        IASTName iASTName13 = ((ICASTFieldDesignator)((ICASTDesignatedInitializer)iASTInitializerArray2[0]).getDesignators()[0]).getName();
        IASTName iASTName14 = ((ICASTFieldDesignator)((ICASTDesignatedInitializer)iASTInitializerArray2[1]).getDesignators()[0]).getName();
        IASTName iASTName15 = ((IASTIdExpression)((IASTUnaryExpression)((IASTInitializerExpression)((ICASTDesignatedInitializer)iASTInitializerArray2[1]).getOperandInitializer()).getExpression()).getOperand()).getName();
        int n = 0;
        while (n < 2) {
            ICASTDesignatedInitializer iCASTDesignatedInitializer = (ICASTDesignatedInitializer)iASTInitializerArray[n];
            Assert.assertEquals((int)iCASTDesignatedInitializer.getDesignators().length, (int)1);
            ICASTFieldDesignator iCASTFieldDesignator = (ICASTFieldDesignator)iCASTDesignatedInitializer.getDesignators()[0];
            Assert.assertNotNull((Object)iCASTFieldDesignator.getName().toString());
            ++n;
        }
        IASTName[] iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName7.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName);
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName8.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName8);
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName9.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName3);
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName10.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName2);
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName11.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName4);
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName12.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName12);
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName13.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName6);
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName14.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName5);
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName15.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName8);
    }

    public void testMoreGetDeclarations1() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct S {\n");
        stringBuffer.append(" int a;\n");
        stringBuffer.append(" int b;\n");
        stringBuffer.append("} s;\n");
        stringBuffer.append("int f() {\n");
        stringBuffer.append("struct S s = {.a=1,.b=2};\n}\n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.C);
        IASTSimpleDeclaration iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[0];
        IASTFunctionDefinition iASTFunctionDefinition = (IASTFunctionDefinition)iASTTranslationUnit.getDeclarations()[1];
        IASTName iASTName = ((IASTSimpleDeclaration)((IASTCompositeTypeSpecifier)iASTSimpleDeclaration.getDeclSpecifier()).getMembers()[0]).getDeclarators()[0].getName();
        IASTName iASTName2 = ((IASTSimpleDeclaration)((IASTCompositeTypeSpecifier)iASTSimpleDeclaration.getDeclSpecifier()).getMembers()[1]).getDeclarators()[0].getName();
        IASTName iASTName3 = ((ICASTFieldDesignator)((ICASTDesignatedInitializer)((IASTInitializerList)((IASTSimpleDeclaration)((IASTDeclarationStatement)((IASTCompoundStatement)iASTFunctionDefinition.getBody()).getStatements()[0]).getDeclaration()).getDeclarators()[0].getInitializer()).getInitializers()[0]).getDesignators()[0]).getName();
        IASTName iASTName4 = ((ICASTFieldDesignator)((ICASTDesignatedInitializer)((IASTInitializerList)((IASTSimpleDeclaration)((IASTDeclarationStatement)((IASTCompoundStatement)iASTFunctionDefinition.getBody()).getStatements()[0]).getDeclaration()).getDeclarators()[0].getInitializer()).getInitializers()[1]).getDesignators()[0]).getName();
        Assert.assertEquals((Object)iASTName.resolveBinding(), (Object)iASTName3.resolveBinding());
        Assert.assertEquals((Object)iASTName2.resolveBinding(), (Object)iASTName4.resolveBinding());
        IASTName[] iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTName, (Object)iASTNameArray[0]);
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName2.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTName2, (Object)iASTNameArray[0]);
    }

    public void testMoreGetDeclarations2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" struct S { \n");
        stringBuffer.append(" int a; \n");
        stringBuffer.append(" int b; \n");
        stringBuffer.append("} s = {.a=1,.b=2};\n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.C);
        IASTSimpleDeclaration iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[0];
        IASTName iASTName = ((IASTSimpleDeclaration)((IASTCompositeTypeSpecifier)iASTSimpleDeclaration.getDeclSpecifier()).getMembers()[0]).getDeclarators()[0].getName();
        IASTName iASTName2 = ((IASTSimpleDeclaration)((IASTCompositeTypeSpecifier)iASTSimpleDeclaration.getDeclSpecifier()).getMembers()[1]).getDeclarators()[0].getName();
        IASTName iASTName3 = ((ICASTFieldDesignator)((ICASTDesignatedInitializer)((IASTInitializerList)iASTSimpleDeclaration.getDeclarators()[0].getInitializer()).getInitializers()[0]).getDesignators()[0]).getName();
        IASTName iASTName4 = ((ICASTFieldDesignator)((ICASTDesignatedInitializer)((IASTInitializerList)iASTSimpleDeclaration.getDeclarators()[0].getInitializer()).getInitializers()[1]).getDesignators()[0]).getName();
        Assert.assertEquals((Object)iASTName.resolveBinding(), (Object)iASTName3.resolveBinding());
        Assert.assertEquals((Object)iASTName2.resolveBinding(), (Object)iASTName4.resolveBinding());
        IASTName[] iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTName, (Object)iASTNameArray[0]);
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName2.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTName2, (Object)iASTNameArray[0]);
    }

    public void testMoreGetDeclarations3() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" typedef struct S { \n");
        stringBuffer.append(" int a; \n");
        stringBuffer.append(" int b; \n");
        stringBuffer.append("} s;\n");
        stringBuffer.append("typedef s t;\n");
        stringBuffer.append("typedef t y;\n");
        stringBuffer.append("y x = {.a=1,.b=2};\n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.C);
        IASTSimpleDeclaration iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[0];
        IASTSimpleDeclaration iASTSimpleDeclaration2 = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[3];
        IASTName iASTName = ((IASTSimpleDeclaration)((IASTCompositeTypeSpecifier)iASTSimpleDeclaration.getDeclSpecifier()).getMembers()[0]).getDeclarators()[0].getName();
        IASTName iASTName2 = ((IASTSimpleDeclaration)((IASTCompositeTypeSpecifier)iASTSimpleDeclaration.getDeclSpecifier()).getMembers()[1]).getDeclarators()[0].getName();
        IASTName iASTName3 = ((ICASTFieldDesignator)((ICASTDesignatedInitializer)((IASTInitializerList)iASTSimpleDeclaration2.getDeclarators()[0].getInitializer()).getInitializers()[0]).getDesignators()[0]).getName();
        IASTName iASTName4 = ((ICASTFieldDesignator)((ICASTDesignatedInitializer)((IASTInitializerList)iASTSimpleDeclaration2.getDeclarators()[0].getInitializer()).getInitializers()[1]).getDesignators()[0]).getName();
        Assert.assertEquals((Object)iASTName.resolveBinding(), (Object)iASTName3.resolveBinding());
        Assert.assertEquals((Object)iASTName2.resolveBinding(), (Object)iASTName4.resolveBinding());
        IASTName[] iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTName, (Object)iASTNameArray[0]);
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName2.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTName2, (Object)iASTNameArray[0]);
    }

    public void testFnReturningPtrToFn() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("void ( * f( int ) )(){}", ParserLanguage.C);
        IASTFunctionDefinition iASTFunctionDefinition = (IASTFunctionDefinition)iASTTranslationUnit.getDeclarations()[0];
        IFunction iFunction = (IFunction)iASTFunctionDefinition.getDeclarator().getNestedDeclarator().getName().resolveBinding();
        IFunctionType iFunctionType = iFunction.getType();
        Assert.assertTrue((boolean)(iFunctionType.getReturnType() instanceof IPointerType));
        Assert.assertTrue((boolean)(((IPointerType)iFunctionType.getReturnType()).getType() instanceof IFunctionType));
        Assert.assertEquals((int)iFunctionType.getParameterTypes().length, (int)1);
        IASTName[] iASTNameArray = iASTTranslationUnit.getDeclarations(iASTFunctionDefinition.getDeclarator().getNestedDeclarator().getName().resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTFunctionDefinition.getDeclarator().getNestedDeclarator().getName());
    }

    public void testArrayTypeToQualifiedPointerTypeParm() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("void f(int parm[const 3]);", ParserLanguage.C);
        IASTSimpleDeclaration iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[0];
        IFunction iFunction = (IFunction)iASTSimpleDeclaration.getDeclarators()[0].getName().resolveBinding();
        IFunctionType iFunctionType = iFunction.getType();
        Assert.assertTrue((boolean)(iFunctionType.getParameterTypes()[0] instanceof IPointerType));
        Assert.assertTrue((boolean)((IPointerType)iFunctionType.getParameterTypes()[0]).isConst());
        IASTName iASTName = ((IASTStandardFunctionDeclarator)iASTSimpleDeclaration.getDeclarators()[0]).getParameters()[0].getDeclarator().getName();
        IASTName[] iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName);
    }

    public void testFunctionDefTypes() throws Exception {
        StringBuffer stringBuffer = new StringBuffer("int f() {}\n");
        stringBuffer.append("int *f2() {}\n");
        stringBuffer.append("int (* f3())() {}\n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.C);
        IASTFunctionDefinition iASTFunctionDefinition = (IASTFunctionDefinition)iASTTranslationUnit.getDeclarations()[0];
        IFunction iFunction = (IFunction)iASTFunctionDefinition.getDeclarator().getName().resolveBinding();
        IASTFunctionDefinition iASTFunctionDefinition2 = (IASTFunctionDefinition)iASTTranslationUnit.getDeclarations()[1];
        IFunction iFunction2 = (IFunction)iASTFunctionDefinition2.getDeclarator().getName().resolveBinding();
        IASTFunctionDefinition iASTFunctionDefinition3 = (IASTFunctionDefinition)iASTTranslationUnit.getDeclarations()[2];
        IFunction iFunction3 = (IFunction)iASTFunctionDefinition3.getDeclarator().getName().resolveBinding();
        IFunctionType iFunctionType = iFunction.getType();
        IFunctionType iFunctionType2 = iFunction2.getType();
        IFunctionType iFunctionType3 = iFunction3.getType();
        Assert.assertTrue((boolean)(iFunctionType.getReturnType() instanceof IBasicType));
        Assert.assertTrue((boolean)(iFunctionType2.getReturnType() instanceof IPointerType));
        Assert.assertTrue((boolean)(((IPointerType)iFunctionType2.getReturnType()).getType() instanceof IBasicType));
        Assert.assertTrue((boolean)(iFunctionType3.getReturnType() instanceof IPointerType));
        Assert.assertTrue((boolean)(((IPointerType)iFunctionType3.getReturnType()).getType() instanceof IFunctionType));
        Assert.assertTrue((boolean)(((IFunctionType)((IPointerType)iFunctionType3.getReturnType()).getType()).getReturnType() instanceof IBasicType));
        IASTName[] iASTNameArray = iASTTranslationUnit.getDeclarations(iASTFunctionDefinition.getDeclarator().getName().resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTFunctionDefinition.getDeclarator().getName());
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTFunctionDefinition2.getDeclarator().getName().resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTFunctionDefinition2.getDeclarator().getName());
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTFunctionDefinition3.getDeclarator().getNestedDeclarator().getName().resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTFunctionDefinition3.getDeclarator().getNestedDeclarator().getName());
    }

    public void testParmToFunction() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("int f(int g(void)) { return g();}", ParserLanguage.C);
        IASTFunctionDefinition iASTFunctionDefinition = (IASTFunctionDefinition)iASTTranslationUnit.getDeclarations()[0];
        IFunction iFunction = (IFunction)iASTFunctionDefinition.getDeclarator().getName().resolveBinding();
        IFunctionType iFunctionType = ((CFunction)iFunction).getType();
        Assert.assertTrue((boolean)(iFunctionType instanceof IFunctionType));
        IType iType = iFunctionType.getParameterTypes()[0];
        Assert.assertTrue((boolean)(iType instanceof IPointerType));
        IType iType2 = ((IPointerType)iType).getType();
        Assert.assertTrue((boolean)(iType2 instanceof IFunctionType));
        IType iType3 = ((IFunctionType)iType2).getReturnType();
        Assert.assertTrue((boolean)(iType3 instanceof IBasicType));
        Assert.assertEquals((int)((IBasicType)iType3).getType(), (int)3);
        IType iType4 = ((IFunctionType)iType2).getParameterTypes()[0];
        Assert.assertTrue((boolean)(iType4 instanceof IBasicType));
        Assert.assertEquals((int)((IBasicType)iType4).getType(), (int)1);
        Assert.assertTrue((boolean)(iASTFunctionDefinition.getDeclarator() instanceof IASTStandardFunctionDeclarator));
        IASTName iASTName = ((IASTStandardFunctionDeclarator)iASTFunctionDefinition.getDeclarator()).getParameters()[0].getDeclarator().getName();
        IASTName iASTName2 = ((IASTIdExpression)((IASTFunctionCallExpression)((IASTReturnStatement)((IASTCompoundStatement)iASTFunctionDefinition.getBody()).getStatements()[0]).getReturnValue()).getFunctionNameExpression()).getName();
        IASTName[] iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName2.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName);
    }

    public void testArrayPointerFunction() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("int (*v[])(int *x, int *y);", ParserLanguage.C);
        IASTSimpleDeclaration iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[0];
        IVariable iVariable = (IVariable)((IASTStandardFunctionDeclarator)iASTSimpleDeclaration.getDeclarators()[0]).getNestedDeclarator().getName().resolveBinding();
        IType iType = iVariable.getType();
        Assert.assertTrue((boolean)(iType instanceof IArrayType));
        IType iType2 = ((IArrayType)iType).getType();
        Assert.assertTrue((boolean)(iType2 instanceof IPointerType));
        IType iType3 = ((IPointerType)iType2).getType();
        Assert.assertTrue((boolean)(iType3 instanceof IFunctionType));
        IType iType4 = ((IFunctionType)iType3).getReturnType();
        Assert.assertTrue((boolean)(iType4 instanceof IBasicType));
        Assert.assertEquals((int)((IBasicType)iType4).getType(), (int)3);
        Assert.assertEquals((int)((IFunctionType)iType3).getParameterTypes().length, (int)2);
        IType iType5 = ((IFunctionType)iType3).getParameterTypes()[0];
        Assert.assertTrue((boolean)(iType5 instanceof IPointerType));
        IType iType6 = ((IPointerType)iType5).getType();
        Assert.assertTrue((boolean)(iType6 instanceof IBasicType));
        Assert.assertEquals((int)((IBasicType)iType6).getType(), (int)3);
        IType iType7 = ((IFunctionType)iType3).getParameterTypes()[0];
        Assert.assertTrue((boolean)(iType7 instanceof IPointerType));
        IType iType8 = ((IPointerType)iType5).getType();
        Assert.assertTrue((boolean)(iType8 instanceof IBasicType));
        Assert.assertEquals((int)((IBasicType)iType8).getType(), (int)3);
        IASTName[] iASTNameArray = iASTTranslationUnit.getDeclarations(((IASTStandardFunctionDeclarator)iASTSimpleDeclaration.getDeclarators()[0]).getNestedDeclarator().getName().resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)((IASTStandardFunctionDeclarator)iASTSimpleDeclaration.getDeclarators()[0]).getNestedDeclarator().getName());
    }

    public void testTypedefExample4a() throws Exception {
        StringBuffer stringBuffer = new StringBuffer("typedef void DWORD;\n");
        stringBuffer.append("typedef DWORD v;\n");
        stringBuffer.append("v signal(int);\n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.C);
        IASTSimpleDeclaration iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[0];
        ITypedef iTypedef = (ITypedef)iASTSimpleDeclaration.getDeclarators()[0].getName().resolveBinding();
        IType iType = iTypedef.getType();
        Assert.assertTrue((boolean)(iType instanceof IBasicType));
        Assert.assertEquals((int)((IBasicType)iType).getType(), (int)1);
        IASTSimpleDeclaration iASTSimpleDeclaration2 = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[1];
        ITypedef iTypedef2 = (ITypedef)iASTSimpleDeclaration2.getDeclarators()[0].getName().resolveBinding();
        IType iType2 = iTypedef2.getType();
        Assert.assertTrue((boolean)(iType2 instanceof ITypedef));
        IType iType3 = ((ITypedef)iType2).getType();
        Assert.assertTrue((boolean)(iType3 instanceof IBasicType));
        Assert.assertEquals((int)((IBasicType)iType3).getType(), (int)1);
        IASTSimpleDeclaration iASTSimpleDeclaration3 = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[2];
        IFunction iFunction = (IFunction)iASTSimpleDeclaration3.getDeclarators()[0].getName().resolveBinding();
        IFunctionType iFunctionType = iFunction.getType();
        IType iType4 = iFunctionType.getReturnType();
        Assert.assertTrue((boolean)(iType4 instanceof ITypedef));
        IType iType5 = ((ITypedef)iType4).getType();
        Assert.assertTrue((boolean)(iType5 instanceof ITypedef));
        IType iType6 = ((ITypedef)iType5).getType();
        Assert.assertTrue((boolean)(iType6 instanceof IBasicType));
        Assert.assertEquals((int)((IBasicType)iType6).getType(), (int)1);
        IASTName iASTName = iASTSimpleDeclaration.getDeclarators()[0].getName();
        IASTName iASTName2 = iASTSimpleDeclaration2.getDeclarators()[0].getName();
        IASTName[] iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName);
        iASTNameArray = iASTTranslationUnit.getDeclarations(((IASTNamedTypeSpecifier)iASTSimpleDeclaration2.getDeclSpecifier()).getName().resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName);
        iASTNameArray = iASTTranslationUnit.getDeclarations(((IASTNamedTypeSpecifier)iASTSimpleDeclaration3.getDeclSpecifier()).getName().resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName2);
    }

    public void testTypedefExample4b() throws Exception {
        StringBuffer stringBuffer = new StringBuffer("typedef void DWORD;\n");
        stringBuffer.append("typedef DWORD (*pfv)(int);\n");
        stringBuffer.append("pfv signal(int, pfv);\n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.C);
        IASTSimpleDeclaration iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[0];
        ITypedef iTypedef = (ITypedef)iASTSimpleDeclaration.getDeclarators()[0].getName().resolveBinding();
        IType iType = iTypedef.getType();
        Assert.assertTrue((boolean)(iType instanceof IBasicType));
        Assert.assertEquals((int)((IBasicType)iType).getType(), (int)1);
        IASTSimpleDeclaration iASTSimpleDeclaration2 = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[1];
        ITypedef iTypedef2 = (ITypedef)iASTSimpleDeclaration2.getDeclarators()[0].getNestedDeclarator().getName().resolveBinding();
        IType iType2 = iTypedef2.getType();
        Assert.assertTrue((boolean)(iType2 instanceof IPointerType));
        IType iType3 = ((IPointerType)iType2).getType();
        Assert.assertTrue((boolean)(iType3 instanceof IFunctionType));
        IType iType4 = ((IFunctionType)iType3).getReturnType();
        Assert.assertTrue((boolean)(iType4 instanceof ITypedef));
        IType iType5 = ((ITypedef)iType4).getType();
        Assert.assertTrue((boolean)(iType5 instanceof IBasicType));
        Assert.assertEquals((int)((IBasicType)iType5).getType(), (int)1);
        Assert.assertTrue((boolean)((ITypedef)iType4).getName().equals("DWORD"));
        IType iType6 = ((IFunctionType)iType3).getParameterTypes()[0];
        Assert.assertTrue((boolean)(iType6 instanceof IBasicType));
        Assert.assertEquals((int)((IBasicType)iType6).getType(), (int)3);
        IASTSimpleDeclaration iASTSimpleDeclaration3 = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[2];
        IFunction iFunction = (IFunction)iASTSimpleDeclaration3.getDeclarators()[0].getName().resolveBinding();
        IFunctionType iFunctionType = iFunction.getType();
        IType iType7 = iFunctionType.getReturnType();
        Assert.assertTrue((boolean)(iType7 instanceof ITypedef));
        IType iType8 = ((ITypedef)iType7).getType();
        Assert.assertTrue((boolean)(iType8 instanceof IPointerType));
        IType iType9 = ((IPointerType)iType8).getType();
        Assert.assertTrue((boolean)(iType9 instanceof IFunctionType));
        IType iType10 = ((IFunctionType)iType9).getReturnType();
        Assert.assertTrue((boolean)(iType10 instanceof ITypedef));
        IType iType11 = ((ITypedef)iType10).getType();
        Assert.assertTrue((boolean)(iType11 instanceof IBasicType));
        Assert.assertEquals((int)((IBasicType)iType11).getType(), (int)1);
        Assert.assertTrue((boolean)((ITypedef)iType10).getName().equals("DWORD"));
        IType iType12 = iFunctionType.getParameterTypes()[0];
        Assert.assertTrue((boolean)(iType12 instanceof IBasicType));
        Assert.assertEquals((int)((IBasicType)iType12).getType(), (int)3);
        IType iType13 = iFunctionType.getParameterTypes()[1];
        Assert.assertTrue((boolean)(iType13 instanceof ITypedef));
        IType iType14 = ((ITypedef)iType13).getType();
        Assert.assertTrue((boolean)(iType14 instanceof IPointerType));
        IType iType15 = ((IPointerType)iType14).getType();
        Assert.assertTrue((boolean)(iType15 instanceof IFunctionType));
        IType iType16 = ((IFunctionType)iType15).getReturnType();
        Assert.assertTrue((boolean)(iType16 instanceof ITypedef));
        IType iType17 = ((ITypedef)iType16).getType();
        Assert.assertTrue((boolean)(iType17 instanceof IBasicType));
        Assert.assertEquals((int)((IBasicType)iType17).getType(), (int)1);
        Assert.assertTrue((boolean)((ITypedef)iType16).getName().equals("DWORD"));
        IASTName iASTName = iASTSimpleDeclaration2.getDeclarators()[0].getNestedDeclarator().getName();
        IASTName iASTName2 = ((IASTNamedTypeSpecifier)iASTSimpleDeclaration3.getDeclSpecifier()).getName();
        IASTName iASTName3 = ((IASTNamedTypeSpecifier)((IASTStandardFunctionDeclarator)iASTSimpleDeclaration3.getDeclarators()[0]).getParameters()[1].getDeclSpecifier()).getName();
        IASTName[] iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName2.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName);
        iASTNameArray = iASTTranslationUnit.getDeclarations(iASTName3.resolveBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((Object)iASTNameArray[0], (Object)iASTName);
    }

    public void testTypedefExample4c() throws Exception {
        StringBuffer stringBuffer = new StringBuffer("typedef void fv(int), (*pfv)(int);\n");
        stringBuffer.append("void (*signal1(int, void (*)(int)))(int);\n");
        stringBuffer.append("fv *signal2(int, fv *);\n");
        stringBuffer.append("pfv signal3(int, pfv);\n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.C);
        IASTSimpleDeclaration iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[0];
        ITypedef iTypedef = (ITypedef)iASTSimpleDeclaration.getDeclarators()[0].getName().resolveBinding();
        ITypedef iTypedef2 = (ITypedef)iASTSimpleDeclaration.getDeclarators()[1].getNestedDeclarator().getName().resolveBinding();
        IType iType = iTypedef.getType();
        Assert.assertEquals((int)((IBasicType)((IFunctionType)iType).getReturnType()).getType(), (int)1);
        Assert.assertEquals((int)((IBasicType)((IFunctionType)iType).getParameterTypes()[0]).getType(), (int)3);
        IType iType2 = iTypedef2.getType();
        Assert.assertEquals((int)((IBasicType)((IFunctionType)((IPointerType)iType2).getType()).getReturnType()).getType(), (int)1);
        Assert.assertEquals((int)((IBasicType)((IFunctionType)((IPointerType)iTypedef2.getType()).getType()).getParameterTypes()[0]).getType(), (int)3);
        iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[1];
        IFunction iFunction = (IFunction)iASTSimpleDeclaration.getDeclarators()[0].getNestedDeclarator().getName().resolveBinding();
        IFunctionType iFunctionType = iFunction.getType();
        iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[2];
        IFunction iFunction2 = (IFunction)iASTSimpleDeclaration.getDeclarators()[0].getName().resolveBinding();
        IFunctionType iFunctionType2 = iFunction2.getType();
        iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[3];
        IFunction iFunction3 = (IFunction)iASTSimpleDeclaration.getDeclarators()[0].getName().resolveBinding();
        IFunctionType iFunctionType3 = iFunction3.getType();
        Assert.assertEquals((int)((IBasicType)((IFunctionType)((IPointerType)iFunctionType.getReturnType()).getType()).getReturnType()).getType(), (int)1);
        Assert.assertEquals((int)((IBasicType)iFunctionType.getParameterTypes()[0]).getType(), (int)3);
        Assert.assertEquals((int)((IBasicType)((IFunctionType)((IPointerType)iFunctionType.getParameterTypes()[1]).getType()).getReturnType()).getType(), (int)1);
        Assert.assertEquals((int)((IBasicType)((IFunctionType)((IPointerType)iFunctionType.getParameterTypes()[1]).getType()).getParameterTypes()[0]).getType(), (int)3);
        Assert.assertEquals((int)((IBasicType)((IFunctionType)((ITypedef)((IPointerType)iFunctionType2.getReturnType()).getType()).getType()).getReturnType()).getType(), (int)1);
        Assert.assertEquals((int)((IBasicType)iFunctionType2.getParameterTypes()[0]).getType(), (int)3);
        Assert.assertEquals((int)((IBasicType)((IFunctionType)((ITypedef)((IPointerType)iFunctionType2.getParameterTypes()[1]).getType()).getType()).getReturnType()).getType(), (int)1);
        Assert.assertEquals((int)((IBasicType)((IFunctionType)((ITypedef)((IPointerType)iFunctionType2.getParameterTypes()[1]).getType()).getType()).getParameterTypes()[0]).getType(), (int)3);
        Assert.assertEquals((int)((IBasicType)((IFunctionType)((IPointerType)((ITypedef)iFunctionType3.getReturnType()).getType()).getType()).getReturnType()).getType(), (int)1);
        Assert.assertEquals((int)((IBasicType)iFunctionType3.getParameterTypes()[0]).getType(), (int)3);
        Assert.assertEquals((int)((IBasicType)((IFunctionType)((IPointerType)((ITypedef)iFunctionType3.getParameterTypes()[1]).getType()).getType()).getReturnType()).getType(), (int)1);
        Assert.assertEquals((int)((IBasicType)((IFunctionType)((IPointerType)((ITypedef)iFunctionType3.getParameterTypes()[1]).getType()).getType()).getParameterTypes()[0]).getType(), (int)3);
    }

    public void testBug80992() throws Exception {
        StringBuffer stringBuffer = new StringBuffer("const int x = 10;\n");
        stringBuffer.append("int y [ const static x ];");
        ICASTArrayModifier iCASTArrayModifier = (ICASTArrayModifier)((IASTArrayDeclarator)((IASTSimpleDeclaration)this.parse(stringBuffer.toString(), ParserLanguage.C).getDeclarations()[1]).getDeclarators()[0]).getArrayModifiers()[0];
        Assert.assertTrue((boolean)iCASTArrayModifier.isConst());
        Assert.assertTrue((boolean)iCASTArrayModifier.isStatic());
        Assert.assertFalse((boolean)iCASTArrayModifier.isRestrict());
        Assert.assertFalse((boolean)iCASTArrayModifier.isVolatile());
        Assert.assertFalse((boolean)iCASTArrayModifier.isVariableSized());
    }

    public void testBug80978() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int y ( int [ const *] );");
        ICASTArrayModifier iCASTArrayModifier = (ICASTArrayModifier)((IASTArrayDeclarator)((IASTStandardFunctionDeclarator)((IASTSimpleDeclaration)this.parse(stringBuffer.toString(), ParserLanguage.C).getDeclarations()[0]).getDeclarators()[0]).getParameters()[0].getDeclarator()).getArrayModifiers()[0];
        Assert.assertTrue((boolean)iCASTArrayModifier.isConst());
        Assert.assertTrue((boolean)iCASTArrayModifier.isVariableSized());
        Assert.assertFalse((boolean)iCASTArrayModifier.isStatic());
        Assert.assertFalse((boolean)iCASTArrayModifier.isRestrict());
        Assert.assertFalse((boolean)iCASTArrayModifier.isVolatile());
    }

    public void testExternalDefs() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void f() {               \n");
        stringBuffer.append("   int a = 1;            \n");
        stringBuffer.append("   if( a == 0 )          \n");
        stringBuffer.append("      g( a );            \n");
        stringBuffer.append("   if( a < 0 )           \n");
        stringBuffer.append("      g( a >> 1 );       \n");
        stringBuffer.append("   if( a > 0 )           \n");
        stringBuffer.append("      g( *(&a + 2) );    \n");
        stringBuffer.append("}                        \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.C);
        AST2BaseTest.CNameCollector cNameCollector = new AST2BaseTest.CNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cNameCollector);
        IVariable iVariable = (IVariable)cNameCollector.getName(1).resolveBinding();
        IFunction iFunction = (IFunction)cNameCollector.getName(3).resolveBinding();
        Assert.assertNotNull((Object)iVariable);
        Assert.assertNotNull((Object)iFunction);
        Assert.assertTrue((boolean)(iFunction instanceof ICExternalBinding));
        Assert.assertEquals((int)cNameCollector.size(), (int)11);
        this.assertInstances(cNameCollector, (IBinding)iVariable, 7);
        this.assertInstances(cNameCollector, (IBinding)iFunction, 3);
    }

    public void testFieldDesignators() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("typedef struct { int x; int y; } Coord;  \n");
        stringBuffer.append("int f() {                               \n");
        stringBuffer.append("   Coord xy = { .x = 10, .y = 11 };     \n");
        stringBuffer.append("}                                       \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.C);
        AST2BaseTest.CNameCollector cNameCollector = new AST2BaseTest.CNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cNameCollector);
        Assert.assertEquals((int)cNameCollector.size(), (int)9);
        IField iField = (IField)cNameCollector.getName(1).resolveBinding();
        IField iField2 = (IField)cNameCollector.getName(2).resolveBinding();
        ITypedef iTypedef = (ITypedef)cNameCollector.getName(3).resolveBinding();
        this.assertInstances(cNameCollector, (IBinding)iField, 2);
        this.assertInstances(cNameCollector, (IBinding)iField2, 2);
        this.assertInstances(cNameCollector, (IBinding)iTypedef, 2);
    }

    public void testArrayDesignator() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("enum { member_one, member_two };    \n");
        stringBuffer.append("const char *nm[] = {                \n");
        stringBuffer.append("   [member_one] = \"one\",          \n");
        stringBuffer.append("   [member_two] = \"two\"           \n");
        stringBuffer.append("};                                  \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.C);
        AST2BaseTest.CNameCollector cNameCollector = new AST2BaseTest.CNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cNameCollector);
        Assert.assertEquals((int)cNameCollector.size(), (int)6);
        IEnumerator iEnumerator = (IEnumerator)cNameCollector.getName(1).resolveBinding();
        IEnumerator iEnumerator2 = (IEnumerator)cNameCollector.getName(2).resolveBinding();
        this.assertInstances(cNameCollector, (IBinding)iEnumerator, 2);
        this.assertInstances(cNameCollector, (IBinding)iEnumerator2, 2);
    }

    public void testBug83737() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void f() {\n");
        stringBuffer.append("if( a == 0 )\n");
        stringBuffer.append("g( a );\n");
        stringBuffer.append("else if( a < 0 )\n");
        stringBuffer.append("g( a >> 1 );\n");
        stringBuffer.append("else if( a > 0 )\n");
        stringBuffer.append("g( *(&a + 2) );\n");
        stringBuffer.append("}\n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.C);
        IASTIfStatement iASTIfStatement = (IASTIfStatement)((IASTCompoundStatement)((IASTFunctionDefinition)iASTTranslationUnit.getDeclarations()[0]).getBody()).getStatements()[0];
        Assert.assertEquals((int)((IASTBinaryExpression)iASTIfStatement.getConditionExpression()).getOperator(), (int)28);
        IASTIfStatement iASTIfStatement2 = (IASTIfStatement)iASTIfStatement.getElseClause();
        Assert.assertEquals((int)((IASTBinaryExpression)iASTIfStatement2.getConditionExpression()).getOperator(), (int)8);
        IASTIfStatement iASTIfStatement3 = (IASTIfStatement)iASTIfStatement2.getElseClause();
        Assert.assertEquals((int)((IASTBinaryExpression)iASTIfStatement3.getConditionExpression()).getOperator(), (int)9);
    }

    public void testBug84090_LabelReferences() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void f() {                    \n");
        stringBuffer.append("   while(1){                  \n");
        stringBuffer.append("      if( 1 ) goto end;       \n");
        stringBuffer.append("   }                          \n");
        stringBuffer.append("   end: ;                     \n");
        stringBuffer.append("}                             \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.C);
        AST2BaseTest.CNameCollector cNameCollector = new AST2BaseTest.CNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cNameCollector);
        Assert.assertEquals((int)cNameCollector.size(), (int)3);
        ILabel iLabel = (ILabel)cNameCollector.getName(1).resolveBinding();
        IASTName[] iASTNameArray = iASTTranslationUnit.getReferences((IBinding)iLabel);
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertSame((Object)iASTNameArray[0].resolveBinding(), (Object)iLabel);
    }

    public void testBug84092_EnumReferences() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("enum col { red, blue };    \n");
        stringBuffer.append("enum col c;                \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.C);
        AST2BaseTest.CNameCollector cNameCollector = new AST2BaseTest.CNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cNameCollector);
        Assert.assertEquals((int)cNameCollector.size(), (int)5);
        IEnumeration iEnumeration = (IEnumeration)cNameCollector.getName(0).resolveBinding();
        IASTName[] iASTNameArray = iASTTranslationUnit.getReferences((IBinding)iEnumeration);
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertSame((Object)iASTNameArray[0].resolveBinding(), (Object)iEnumeration);
    }

    public void testBug84096_FieldDesignatorRef() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("struct s { int a; } ss = { .a = 1 }; \n", ParserLanguage.C);
        AST2BaseTest.CNameCollector cNameCollector = new AST2BaseTest.CNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cNameCollector);
        Assert.assertEquals((int)cNameCollector.size(), (int)4);
        IField iField = (IField)cNameCollector.getName(1).resolveBinding();
        IASTName[] iASTNameArray = iASTTranslationUnit.getReferences((IBinding)iField);
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertSame((Object)iASTNameArray[0].resolveBinding(), (Object)iField);
    }

    public void testProblems() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("    a += ;", ParserLanguage.C, true, false);
        IASTProblem[] iASTProblemArray = CVisitor.getProblems((IASTTranslationUnit)iASTTranslationUnit);
        Assert.assertEquals((int)iASTProblemArray.length, (int)1);
        iASTProblemArray[0].getMessage();
    }

    public void testEnumerationForwards() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("enum e;          \n;");
        stringBuffer.append("enum e{ one };   \n;");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.C);
        AST2BaseTest.CNameCollector cNameCollector = new AST2BaseTest.CNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cNameCollector);
        Assert.assertEquals((int)cNameCollector.size(), (int)3);
        IEnumeration iEnumeration = (IEnumeration)cNameCollector.getName(0).resolveBinding();
        IEnumerator[] iEnumeratorArray = iEnumeration.getEnumerators();
        Assert.assertTrue((iEnumeratorArray.length == 1 ? 1 : 0) != 0);
        Assert.assertFalse((boolean)(iEnumeratorArray[0] instanceof IProblemBinding));
        this.assertInstances(cNameCollector, (IBinding)iEnumeration, 2);
    }

    public void testBug84185() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void f() {                 \n");
        stringBuffer.append("   int ( *p ) [2];         \n");
        stringBuffer.append("   (&p)[0] = 1;            \n");
        stringBuffer.append("}                          \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.C);
        AST2BaseTest.CNameCollector cNameCollector = new AST2BaseTest.CNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cNameCollector);
        Assert.assertEquals((int)cNameCollector.size(), (int)3);
        IVariable iVariable = (IVariable)cNameCollector.getName(1).resolveBinding();
        Assert.assertTrue((boolean)(iVariable.getType() instanceof IPointerType));
        Assert.assertTrue((boolean)(((IPointerType)iVariable.getType()).getType() instanceof IArrayType));
        IArrayType iArrayType = (IArrayType)((IPointerType)iVariable.getType()).getType();
        Assert.assertTrue((boolean)(iArrayType.getType() instanceof IBasicType));
        this.assertInstances(cNameCollector, (IBinding)iVariable, 2);
    }

    public void testBug84185_2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void f() {                 \n");
        stringBuffer.append("   int ( *p ) [2];         \n");
        stringBuffer.append("   (&p)[0] = 1;            \n");
        stringBuffer.append("}                          \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.C);
        AST2BaseTest.CNameCollector cNameCollector = new AST2BaseTest.CNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cNameCollector);
        Assert.assertEquals((int)cNameCollector.size(), (int)3);
        IVariable iVariable = (IVariable)cNameCollector.getName(2).resolveBinding();
        IVariable iVariable2 = (IVariable)cNameCollector.getName(1).resolveBinding();
        Assert.assertSame((Object)iVariable, (Object)iVariable2);
    }

    public void testBug84176() throws Exception {
        StringBuffer stringBuffer = new StringBuffer("// example from: C99 6.5.2.5-16\n");
        stringBuffer.append("struct s { int i; };\n");
        stringBuffer.append("void f (void)\n");
        stringBuffer.append("{\n");
        stringBuffer.append("\t\t struct s *p = 0, *q;\n");
        stringBuffer.append("int j = 0;\n");
        stringBuffer.append("q = p;\n");
        stringBuffer.append("p = &((struct s){ j++ }); \n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.C, false, true);
    }

    public void testBug84266() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct s { double i; } f(void);  \n");
        stringBuffer.append("struct s f(void){}               \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.C);
        AST2BaseTest.CNameCollector cNameCollector = new AST2BaseTest.CNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cNameCollector);
        Assert.assertEquals((int)cNameCollector.size(), (int)7);
        ICompositeType iCompositeType = (ICompositeType)cNameCollector.getName(4).resolveBinding();
        ICompositeType iCompositeType2 = (ICompositeType)cNameCollector.getName(0).resolveBinding();
        Assert.assertSame((Object)iCompositeType, (Object)iCompositeType2);
        CVisitor.clearBindings((IASTTranslationUnit)iASTTranslationUnit);
        iCompositeType2 = (ICompositeType)cNameCollector.getName(0).resolveBinding();
        iCompositeType = (ICompositeType)cNameCollector.getName(4).resolveBinding();
        Assert.assertSame((Object)iCompositeType, (Object)iCompositeType2);
    }

    public void testBug84266_2() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("struct s f(void);", ParserLanguage.C);
        AST2BaseTest.CNameCollector cNameCollector = new AST2BaseTest.CNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cNameCollector);
        Assert.assertEquals((int)cNameCollector.size(), (int)3);
        ICompositeType iCompositeType = (ICompositeType)cNameCollector.getName(0).resolveBinding();
        Assert.assertNotNull((Object)iCompositeType);
        iASTTranslationUnit = this.parse("struct s f(void){}", ParserLanguage.C);
        cNameCollector = new AST2BaseTest.CNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cNameCollector);
        Assert.assertEquals((int)cNameCollector.size(), (int)3);
        iCompositeType = (ICompositeType)cNameCollector.getName(0).resolveBinding();
        Assert.assertNotNull((Object)iCompositeType);
    }

    public void testBug84250() throws Exception {
        Assert.assertTrue((boolean)(((IASTDeclarationStatement)((IASTCompoundStatement)((IASTFunctionDefinition)this.parse("void f() { int (*p) [2]; }", ParserLanguage.C).getDeclarations()[0]).getBody()).getStatements()[0]).getDeclaration() instanceof IASTSimpleDeclaration));
    }

    public void testBug84186() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct s1 { struct s2 *s2p; /* ... */ }; // D1 \n");
        stringBuffer.append("struct s2 { struct s1 *s1p; /* ... */ }; // D2 \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.C);
        AST2BaseTest.CNameCollector cNameCollector = new AST2BaseTest.CNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cNameCollector);
        Assert.assertEquals((int)cNameCollector.size(), (int)6);
        ICompositeType iCompositeType = (ICompositeType)cNameCollector.getName(1).resolveBinding();
        ICompositeType iCompositeType2 = (ICompositeType)cNameCollector.getName(3).resolveBinding();
        Assert.assertSame((Object)iCompositeType, (Object)iCompositeType2);
        CVisitor.clearBindings((IASTTranslationUnit)iASTTranslationUnit);
        iCompositeType2 = (ICompositeType)cNameCollector.getName(3).resolveBinding();
        iCompositeType = (ICompositeType)cNameCollector.getName(1).resolveBinding();
        Assert.assertSame((Object)iCompositeType, (Object)iCompositeType2);
    }

    public void testBug84267() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("typedef struct { int a; } S;      \n");
        stringBuffer.append("void g( S* (*funcp) (void) ) {    \n");
        stringBuffer.append("   (*funcp)()->a;                 \n");
        stringBuffer.append("   funcp()->a;                    \n");
        stringBuffer.append("}                                 \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.C);
        AST2BaseTest.CNameCollector cNameCollector = new AST2BaseTest.CNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cNameCollector);
        Assert.assertEquals((int)cNameCollector.size(), (int)11);
        ITypedef iTypedef = (ITypedef)cNameCollector.getName(2).resolveBinding();
        IField iField = (IField)cNameCollector.getName(10).resolveBinding();
        IParameter iParameter = (IParameter)cNameCollector.getName(7).resolveBinding();
        Assert.assertNotNull((Object)iParameter);
        this.assertInstances(cNameCollector, (IBinding)iParameter, 3);
        this.assertInstances(cNameCollector, (IBinding)iField, 3);
        Assert.assertTrue((boolean)(iParameter.getType() instanceof IPointerType));
        IType iType = ((IPointerType)iParameter.getType()).getType();
        Assert.assertTrue((boolean)(iType instanceof IFunctionType));
        IFunctionType iFunctionType = (IFunctionType)iType;
        Assert.assertTrue((boolean)(iFunctionType.getReturnType() instanceof IPointerType));
        Assert.assertSame((Object)((IPointerType)iFunctionType.getReturnType()).getType(), (Object)iTypedef);
    }

    public void testBug84228() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void f( int m, int c[m][m] );        \n");
        stringBuffer.append("void f( int m, int c[m][m] ){        \n");
        stringBuffer.append("   int x;                            \n");
        stringBuffer.append("   { int x = x; }                    \n");
        stringBuffer.append("}                                    \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.C);
        AST2BaseTest.CNameCollector cNameCollector = new AST2BaseTest.CNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cNameCollector);
        Assert.assertEquals((int)cNameCollector.size(), (int)13);
        IParameter iParameter = (IParameter)cNameCollector.getName(3).resolveBinding();
        IVariable iVariable = (IVariable)cNameCollector.getName(12).resolveBinding();
        IVariable iVariable2 = (IVariable)cNameCollector.getName(11).resolveBinding();
        IVariable iVariable3 = (IVariable)cNameCollector.getName(10).resolveBinding();
        Assert.assertSame((Object)iVariable2, (Object)iVariable);
        Assert.assertNotSame((Object)iVariable3, (Object)iVariable2);
        this.assertInstances(cNameCollector, (IBinding)iParameter, 6);
        this.assertInstances(cNameCollector, (IBinding)iVariable3, 1);
        this.assertInstances(cNameCollector, (IBinding)iVariable2, 2);
        IASTName[] iASTNameArray = iASTTranslationUnit.getDeclarations((IBinding)iVariable2);
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertSame((Object)iASTNameArray[0], (Object)cNameCollector.getName(11));
    }

    public void testBug84236() throws Exception {
        String string = "double maximum(double a[ ][*]);";
        IASTSimpleDeclaration iASTSimpleDeclaration = (IASTSimpleDeclaration)this.parse(string, ParserLanguage.C).getDeclarations()[0];
        IASTStandardFunctionDeclarator iASTStandardFunctionDeclarator = (IASTStandardFunctionDeclarator)iASTSimpleDeclaration.getDeclarators()[0];
        IASTParameterDeclaration iASTParameterDeclaration = iASTStandardFunctionDeclarator.getParameters()[0];
        IASTArrayDeclarator iASTArrayDeclarator = (IASTArrayDeclarator)iASTParameterDeclaration.getDeclarator();
        ICASTArrayModifier iCASTArrayModifier = (ICASTArrayModifier)iASTArrayDeclarator.getArrayModifiers()[1];
        Assert.assertTrue((boolean)iCASTArrayModifier.isVariableSized());
    }

    public void testBug85049() throws Exception {
        StringBuffer stringBuffer = new StringBuffer("typedef int B;\n");
        stringBuffer.append("void g() {\n");
        stringBuffer.append("B * bp;  //1\n");
        stringBuffer.append("}\n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.C);
        IASTFunctionDefinition iASTFunctionDefinition = (IASTFunctionDefinition)iASTTranslationUnit.getDeclarations()[1];
        IASTCompoundStatement iASTCompoundStatement = (IASTCompoundStatement)iASTFunctionDefinition.getBody();
        IASTStatement iASTStatement = iASTCompoundStatement.getStatements()[0];
        Assert.assertTrue((boolean)(iASTStatement instanceof IASTDeclarationStatement));
        IASTSimpleDeclaration iASTSimpleDeclaration = (IASTSimpleDeclaration)((IASTDeclarationStatement)iASTStatement).getDeclaration();
        Assert.assertTrue((boolean)(iASTSimpleDeclaration.getDeclarators()[0].getName().resolveBinding() instanceof IVariable));
    }

    public void testBug86766() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("char foo; void foo(){}", ParserLanguage.C);
        AST2BaseTest.CNameCollector cNameCollector = new AST2BaseTest.CNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cNameCollector);
        IVariable iVariable = (IVariable)cNameCollector.getName(0).resolveBinding();
        IProblemBinding iProblemBinding = (IProblemBinding)cNameCollector.getName(1).resolveBinding();
        Assert.assertEquals((int)iProblemBinding.getID(), (int)2);
        Assert.assertNotNull((Object)iVariable);
    }

    public void testBug88338_C() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("struct A; struct A* a;", ParserLanguage.C);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        Assert.assertTrue((boolean)cPPNameCollector.getName(0).isDeclaration());
        Assert.assertFalse((boolean)cPPNameCollector.getName(0).isReference());
        Assert.assertTrue((boolean)cPPNameCollector.getName(1).isReference());
        Assert.assertFalse((boolean)cPPNameCollector.getName(1).isDeclaration());
        iASTTranslationUnit = this.parse("struct A* a; struct A;", ParserLanguage.C);
        cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        cPPNameCollector.getName(2).resolveBinding();
        Assert.assertTrue((boolean)cPPNameCollector.getName(0).isDeclaration());
        Assert.assertFalse((boolean)cPPNameCollector.getName(0).isReference());
        Assert.assertTrue((boolean)cPPNameCollector.getName(2).isDeclaration());
        Assert.assertFalse((boolean)cPPNameCollector.getName(2).isReference());
    }

    public void test88460() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("void f();", ParserLanguage.C);
        AST2BaseTest.CNameCollector cNameCollector = new AST2BaseTest.CNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cNameCollector);
        IFunction iFunction = (IFunction)cNameCollector.getName(0).resolveBinding();
        Assert.assertFalse((boolean)iFunction.isStatic());
    }

    public void testBug90253() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("void f(int par) { int v1; };", ParserLanguage.C);
        AST2BaseTest.CNameCollector cNameCollector = new AST2BaseTest.CNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cNameCollector);
        IFunction iFunction = (IFunction)cNameCollector.getName(0).resolveBinding();
        IParameter iParameter = (IParameter)cNameCollector.getName(1).resolveBinding();
        IVariable iVariable = (IVariable)cNameCollector.getName(2).resolveBinding();
        IScope iScope = iFunction.getFunctionScope();
        IBinding[] iBindingArray = iScope.find("par");
        Assert.assertEquals((int)iBindingArray.length, (int)1);
        Assert.assertSame((Object)iBindingArray[0], (Object)iParameter);
        iBindingArray = iScope.find("v1");
        Assert.assertEquals((int)iBindingArray.length, (int)1);
        Assert.assertSame((Object)iBindingArray[0], (Object)iVariable);
    }

    public void testFind() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct S {};                \n");
        stringBuffer.append("int S;                      \n");
        stringBuffer.append("void f( ) {                 \n");
        stringBuffer.append("   int S;                   \n");
        stringBuffer.append("   {                        \n");
        stringBuffer.append("      S :  ;                \n");
        stringBuffer.append("   }                        \n");
        stringBuffer.append("}                           \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.C);
        AST2BaseTest.CNameCollector cNameCollector = new AST2BaseTest.CNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cNameCollector);
        ICompositeType iCompositeType = (ICompositeType)cNameCollector.getName(0).resolveBinding();
        IVariable iVariable = (IVariable)cNameCollector.getName(1).resolveBinding();
        IFunction iFunction = (IFunction)cNameCollector.getName(2).resolveBinding();
        IVariable iVariable2 = (IVariable)cNameCollector.getName(3).resolveBinding();
        ILabel iLabel = (ILabel)cNameCollector.getName(4).resolveBinding();
        IScope iScope = iFunction.getFunctionScope();
        IBinding[] iBindingArray = iScope.find("S");
        Assert.assertNotNull((Object)iVariable);
        Assert.assertEquals((int)iBindingArray.length, (int)3);
        Assert.assertSame((Object)iBindingArray[0], (Object)iVariable2);
        Assert.assertSame((Object)iBindingArray[1], (Object)iCompositeType);
        Assert.assertSame((Object)iBindingArray[2], (Object)iLabel);
    }

    public void test92791() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("void f() { int x, y; x * y; }", ParserLanguage.C);
        AST2BaseTest.CNameCollector cNameCollector = new AST2BaseTest.CNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cNameCollector);
        int n = 0;
        while (n < cNameCollector.size()) {
            Assert.assertFalse((boolean)(cNameCollector.getName(n).resolveBinding() instanceof IProblemBinding));
            ++n;
        }
        iASTTranslationUnit = this.parse("void f() { typedef int x; int y; x * y; }", ParserLanguage.C);
        cNameCollector = new AST2BaseTest.CNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cNameCollector);
        n = 0;
        while (n < cNameCollector.size()) {
            Assert.assertFalse((boolean)(cNameCollector.getName(n).resolveBinding() instanceof IProblemBinding));
            ++n;
        }
    }

    public void testBug85786() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("void f( int ); void foo () { void * p = &f; ( (void (*) (int)) p ) ( 1 ); }", ParserLanguage.C);
        AST2BaseTest.CNameCollector cNameCollector = new AST2BaseTest.CNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cNameCollector);
        this.assertNoProblemBindings(cNameCollector);
    }

    public void testBug95720() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void func() {\n");
        stringBuffer.append("    int i=0;\n");
        stringBuffer.append("i= i&0x00ff;\n");
        stringBuffer.append("i= (i)&0x00ff;\n");
        stringBuffer.append("}\n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.C);
        AST2BaseTest.CNameCollector cNameCollector = new AST2BaseTest.CNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cNameCollector);
        this.assertNoProblemBindings(cNameCollector);
    }

    protected void assertNoProblemBindings(AST2BaseTest.CNameCollector cNameCollector) {
        Iterator iterator = cNameCollector.nameList.iterator();
        while (iterator.hasNext()) {
            IASTName iASTName = (IASTName)iterator.next();
            Assert.assertFalse((boolean)(iASTName.resolveBinding() instanceof IProblemBinding));
        }
    }

    protected void assertProblemBindings(AST2BaseTest.CNameCollector cNameCollector, int n) {
        Iterator iterator = cNameCollector.nameList.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            IASTName iASTName = (IASTName)iterator.next();
            if (!(iASTName.getBinding() instanceof IProblemBinding)) continue;
            ++n2;
        }
        Assert.assertEquals((int)n, (int)n2);
    }

    public void testBug94365() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("#define ONE(a, ...) int x\n");
        stringBuffer.append("#define TWO(b, args...) int y\n");
        stringBuffer.append("int main()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("ONE(\"string\"); /* err */\n");
        stringBuffer.append("TWO(\"string\"); /* err */\n");
        stringBuffer.append("return 0;\t\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.C);
    }

    public void testBug95119() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("#define MACRO(a)\n");
        stringBuffer.append("void main() {\n");
        stringBuffer.append("MACRO('\"');\n");
        stringBuffer.append("}\n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.C);
        IASTDeclaration[] iASTDeclarationArray = iASTTranslationUnit.getDeclarations();
        Assert.assertEquals((int)iASTDeclarationArray.length, (int)1);
        Assert.assertNotNull((Object)iASTDeclarationArray[0]);
        Assert.assertTrue((boolean)(iASTDeclarationArray[0] instanceof IASTFunctionDefinition));
        Assert.assertEquals((String)((IASTFunctionDefinition)iASTDeclarationArray[0]).getDeclarator().getName().toString(), (String)"main");
        Assert.assertTrue((boolean)(((IASTCompoundStatement)((IASTFunctionDefinition)iASTDeclarationArray[0]).getBody()).getStatements()[0] instanceof IASTNullStatement));
        stringBuffer = new StringBuffer();
        stringBuffer.append("#define MACRO(a)\n");
        stringBuffer.append("void main() {\n");
        stringBuffer.append("MACRO('X');\n");
        stringBuffer.append("}\n");
        iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.C);
        iASTDeclarationArray = iASTTranslationUnit.getDeclarations();
        Assert.assertEquals((int)iASTDeclarationArray.length, (int)1);
        Assert.assertNotNull((Object)iASTDeclarationArray[0]);
        Assert.assertTrue((boolean)(iASTDeclarationArray[0] instanceof IASTFunctionDefinition));
        Assert.assertEquals((String)((IASTFunctionDefinition)iASTDeclarationArray[0]).getDeclarator().getName().toString(), (String)"main");
        Assert.assertTrue((boolean)(((IASTCompoundStatement)((IASTFunctionDefinition)iASTDeclarationArray[0]).getBody()).getStatements()[0] instanceof IASTNullStatement));
    }

    public void testBug81739() throws Exception {
        StringBuffer stringBuffer = new StringBuffer("typedef long _TYPE;\n");
        stringBuffer.append("typedef _TYPE TYPE;\n");
        stringBuffer.append("int function(TYPE (* pfv)(int parm));\n");
        this.parse(stringBuffer.toString(), ParserLanguage.C);
    }

    public void testBug95757() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("float _Complex x;\n");
        stringBuffer.append("double _Complex y;\n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.C, true, true);
        IASTDeclaration[] iASTDeclarationArray = iASTTranslationUnit.getDeclarations();
        Assert.assertTrue((boolean)((ICASTSimpleDeclSpecifier)((IASTSimpleDeclaration)iASTDeclarationArray[0]).getDeclSpecifier()).isComplex());
        Assert.assertEquals((int)((ICASTSimpleDeclSpecifier)((IASTSimpleDeclaration)iASTDeclarationArray[0]).getDeclSpecifier()).getType(), (int)4);
        Assert.assertTrue((boolean)((ICASTSimpleDeclSpecifier)((IASTSimpleDeclaration)iASTDeclarationArray[1]).getDeclSpecifier()).isComplex());
        Assert.assertEquals((int)((ICASTSimpleDeclSpecifier)((IASTSimpleDeclaration)iASTDeclarationArray[1]).getDeclSpecifier()).getType(), (int)5);
    }

    public void testBug93980() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int foo();                 \n");
        stringBuffer.append("typeof({ int x = foo();    \n");
        stringBuffer.append("         x; }) zoot;       \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.C, true);
        AST2BaseTest.CNameCollector cNameCollector = new AST2BaseTest.CNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cNameCollector);
        IFunction iFunction = (IFunction)cNameCollector.getName(0).resolveBinding();
        Assert.assertSame((Object)iFunction, (Object)cNameCollector.getName(2).resolveBinding());
        IVariable iVariable = (IVariable)cNameCollector.getName(4).resolveBinding();
        IType iType = iVariable.getType();
        Assert.assertTrue((boolean)(iType instanceof IBasicType));
        Assert.assertEquals((int)((IBasicType)iType).getType(), (int)3);
    }

    public void testBug95866() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("int test[10] = { [0 ... 9] = 2 };", ParserLanguage.C, true, true);
        AST2BaseTest.CNameCollector cNameCollector = new AST2BaseTest.CNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cNameCollector);
        this.assertNoProblemBindings(cNameCollector);
    }

    public void testBug98502() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("typedef enum { ONE } e;", ParserLanguage.C, true, true);
        AST2BaseTest.CNameCollector cNameCollector = new AST2BaseTest.CNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cNameCollector);
        IEnumeration iEnumeration = (IEnumeration)cNameCollector.getName(0).resolveBinding();
        ITypedef iTypedef = (ITypedef)cNameCollector.getName(2).resolveBinding();
        Assert.assertSame((Object)iTypedef.getType(), (Object)iEnumeration);
    }

    public void testBug98365() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("typedef struct _loop_data {   \n");
        stringBuffer.append("   enum { PIPERR } pipe_err;  \n");
        stringBuffer.append("} loop_data;                  \n");
        stringBuffer.append("void f(){                     \n");
        stringBuffer.append("   PIPERR;                    \n");
        stringBuffer.append("}                             \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.C, true);
        AST2BaseTest.CNameCollector cNameCollector = new AST2BaseTest.CNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cNameCollector);
        IEnumerator iEnumerator = (IEnumerator)cNameCollector.getName(2).resolveBinding();
        Assert.assertSame((Object)iEnumerator, (Object)cNameCollector.getName(6).resolveBinding());
    }

    public void testBug99262() throws Exception {
        this.parse("void foo() {void *f; f=__null;}", ParserLanguage.C, true, true);
    }

    public void testBug99262B() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int foo2(void *) {\n");
        stringBuffer.append("return 0;\n");
        stringBuffer.append("}\n");
        stringBuffer.append("int foo3() {\n");
        stringBuffer.append("return foo2(__null);\n");
        stringBuffer.append("}\n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.C, true, true);
        Assert.assertTrue((boolean)(((IASTIdExpression)((IASTFunctionCallExpression)((IASTReturnStatement)((IASTCompoundStatement)((IASTFunctionDefinition)iASTTranslationUnit.getDeclarations()[1]).getBody()).getStatements()[0]).getReturnValue()).getFunctionNameExpression()).getName().resolveBinding() instanceof IFunction));
    }

    public void testBug98960() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void f() {                    \n");
        stringBuffer.append("   int a;                     \n");
        stringBuffer.append("   { a; int a; }              \n");
        stringBuffer.append("}                             \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.C, true);
        AST2BaseTest.CNameCollector cNameCollector = new AST2BaseTest.CNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cNameCollector);
        IVariable iVariable = (IVariable)cNameCollector.getName(1).resolveBinding();
        IVariable iVariable2 = (IVariable)cNameCollector.getName(2).resolveBinding();
        IVariable iVariable3 = (IVariable)cNameCollector.getName(3).resolveBinding();
        Assert.assertSame((Object)iVariable, (Object)iVariable2);
        Assert.assertNotSame((Object)iVariable2, (Object)iVariable3);
    }

    public void testBug100408() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("int foo() { int x=1; (x)*3; }", ParserLanguage.C);
        AST2BaseTest.CNameCollector cNameCollector = new AST2BaseTest.CNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cNameCollector);
        this.assertNoProblemBindings(cNameCollector);
    }

    public void testBug98760() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct nfa;                   \n");
        stringBuffer.append("void f() {                    \n");
        stringBuffer.append("   struct nfa * n;            \n");
        stringBuffer.append("   freenfa( n );              \n");
        stringBuffer.append("}                             \n");
        stringBuffer.append("static void freenfa( nfa )    \n");
        stringBuffer.append("struct nfa * nfa;             \n");
        stringBuffer.append("{                             \n");
        stringBuffer.append("}                             \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.C, true);
        AST2BaseTest.CNameCollector cNameCollector = new AST2BaseTest.CNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cNameCollector);
        IFunction iFunction = (IFunction)cNameCollector.getName(4).resolveBinding();
        IParameter[] iParameterArray = iFunction.getParameters();
        Assert.assertEquals((int)iParameterArray.length, (int)1);
        Assert.assertSame((Object)iFunction, (Object)cNameCollector.getName(6).resolveBinding());
    }

    public void testBug79650() throws Exception {
        StringBuffer stringBuffer = new StringBuffer("void testCasting() {\n");
        stringBuffer.append("typedef struct {\n");
        stringBuffer.append("    int employee_id;\n");
        stringBuffer.append("int dept_id;\n");
        stringBuffer.append("} Employee;\n");
        stringBuffer.append("#define MY_DETAILS { 20, 30 }\n");
        stringBuffer.append("Employee e = (Employee)MY_DETAILS; \n");
        stringBuffer.append("}\n");
        this.parseAndCheckBindings(stringBuffer.toString());
    }

    public void testBug80171() throws Exception {
        this.parseAndCheckBindings("static var;");
    }

    public void testBug79067() throws Exception {
        StringBuffer stringBuffer = new StringBuffer("enum E_OPTIONCODE {\n");
        stringBuffer.append("    red = 1,\n");
        stringBuffer.append("black = 2,\n");
        stringBuffer.append("};\n");
        stringBuffer.append("void arithConversionTest(enum E_OPTIONCODE eOption)\n");
        stringBuffer.append("{\n");
        stringBuffer.append("int myColor = 5;\n");
        stringBuffer.append("int temp = eOption - myColor; /* Syntax error */\n");
        stringBuffer.append("if(eOption-myColor) /* Invalid arithmetic conversion */\n");
        stringBuffer.append("{\n");
        stringBuffer.append("}\n");
        stringBuffer.append("}\n");
        this.parseAndCheckBindings(stringBuffer.toString());
    }

    public void testBug84759() throws Exception {
        StringBuffer stringBuffer = new StringBuffer("enum COLOR {\n");
        stringBuffer.append("RED=1\n");
        stringBuffer.append("};\n");
        stringBuffer.append("enum COLOR getColor() {\n");
        stringBuffer.append("enum COLOR ret;\n");
        stringBuffer.append("return ret;\n");
        stringBuffer.append("}\n");
        IASTTranslationUnit iASTTranslationUnit = this.parseAndCheckBindings(stringBuffer.toString());
        IASTFunctionDefinition iASTFunctionDefinition = (IASTFunctionDefinition)iASTTranslationUnit.getDeclarations()[1];
        Assert.assertEquals((String)iASTFunctionDefinition.getDeclSpecifier().getRawSignature(), (String)"enum COLOR");
    }

    public void test1043290() throws Exception {
        StringBuffer stringBuffer = new StringBuffer("int f() { ");
        stringBuffer.append("int x = 4;  while( x < 10 ) blah: ++x; ");
        stringBuffer.append("}");
        IASTTranslationUnit iASTTranslationUnit = this.parseAndCheckBindings(stringBuffer.toString());
        IASTFunctionDefinition iASTFunctionDefinition = (IASTFunctionDefinition)iASTTranslationUnit.getDeclarations()[0];
        IASTStatement[] iASTStatementArray = ((IASTCompoundStatement)iASTFunctionDefinition.getBody()).getStatements();
        IASTWhileStatement iASTWhileStatement = (IASTWhileStatement)iASTStatementArray[1];
        IASTLabelStatement iASTLabelStatement = (IASTLabelStatement)iASTWhileStatement.getBody();
        Assert.assertTrue((boolean)(iASTLabelStatement.getNestedStatement() instanceof IASTExpressionStatement));
        IASTExpressionStatement iASTExpressionStatement = (IASTExpressionStatement)iASTLabelStatement.getNestedStatement();
        Assert.assertTrue((boolean)(iASTExpressionStatement.getExpression() instanceof IASTUnaryExpression));
    }

    public void testBug104390_2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void f() {                         \n");
        stringBuffer.append("   int x;                          \n");
        stringBuffer.append("   for( int x; ; )                 \n");
        stringBuffer.append("      blah: x;                     \n");
        stringBuffer.append("}                                  \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.C, true);
        AST2BaseTest.CNameCollector cNameCollector = new AST2BaseTest.CNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cNameCollector);
        IVariable iVariable = (IVariable)cNameCollector.getName(1).resolveBinding();
        IVariable iVariable2 = (IVariable)cNameCollector.getName(2).resolveBinding();
        Assert.assertNotSame((Object)iVariable, (Object)iVariable2);
        Assert.assertSame((Object)iVariable2, (Object)cNameCollector.getName(4).resolveBinding());
        Assert.assertTrue((boolean)(cNameCollector.getName(3).resolveBinding() instanceof ILabel));
    }

    public void testBug104800() throws Exception {
        StringBuffer stringBuffer = new StringBuffer("int f() { \n");
        stringBuffer.append("int i;\n");
        stringBuffer.append("do { ++i; } while( i < 10 );\n");
        stringBuffer.append("return 0;\n");
        stringBuffer.append("}\n");
        IASTTranslationUnit iASTTranslationUnit = this.parseAndCheckBindings(stringBuffer.toString());
        IASTFunctionDefinition iASTFunctionDefinition = (IASTFunctionDefinition)iASTTranslationUnit.getDeclarations()[0];
        IASTCompoundStatement iASTCompoundStatement = (IASTCompoundStatement)iASTFunctionDefinition.getBody();
        Assert.assertEquals((int)iASTCompoundStatement.getStatements().length, (int)3);
    }
}

