/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.tests.ast2;

import junit.framework.Assert;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTMacroExpansion;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNodeLocation;
import org.eclipse.cdt.core.dom.ast.IASTPointer;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorFunctionStyleMacroDefinition;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroDefinition;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorObjectStyleMacroDefinition;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorUndefStatement;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IMacroBinding;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.tests.ast2.AST2BaseTest;
import org.eclipse.cdt.internal.core.parser.ParserException;

public class DOMLocationMacroTests
extends AST2BaseTest {
    public void testObjectStyleMacroExpansionSimpleDeclarator() throws Exception {
        StringBuffer stringBuffer = new StringBuffer("#define ABC D\n");
        stringBuffer.append("int ABC;");
        String string = stringBuffer.toString();
        ParserLanguage parserLanguage = ParserLanguage.C;
        while (parserLanguage != null) {
            IASTTranslationUnit iASTTranslationUnit = this.parse(string, parserLanguage);
            IASTPreprocessorObjectStyleMacroDefinition iASTPreprocessorObjectStyleMacroDefinition = (IASTPreprocessorObjectStyleMacroDefinition)iASTTranslationUnit.getMacroDefinitions()[0];
            IASTSimpleDeclaration iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[0];
            IASTDeclarator iASTDeclarator = iASTSimpleDeclaration.getDeclarators()[0];
            Assert.assertEquals((String)iASTDeclarator.getName().toString(), (String)"D");
            IASTNodeLocation[] iASTNodeLocationArray = iASTDeclarator.getNodeLocations();
            Assert.assertEquals((int)iASTNodeLocationArray.length, (int)1);
            IASTMacroExpansion iASTMacroExpansion = (IASTMacroExpansion)iASTNodeLocationArray[0];
            IASTPreprocessorObjectStyleMacroDefinition iASTPreprocessorObjectStyleMacroDefinition2 = (IASTPreprocessorObjectStyleMacroDefinition)iASTMacroExpansion.getMacroDefinition();
            this.assertEqualsMacros((IASTPreprocessorMacroDefinition)iASTPreprocessorObjectStyleMacroDefinition2, (IASTPreprocessorMacroDefinition)iASTPreprocessorObjectStyleMacroDefinition);
            Assert.assertEquals((int)iASTMacroExpansion.getNodeOffset(), (int)0);
            Assert.assertEquals((int)iASTMacroExpansion.getNodeLength(), (int)1);
            IASTNodeLocation[] iASTNodeLocationArray2 = iASTMacroExpansion.getExpansionLocations();
            Assert.assertEquals((int)iASTNodeLocationArray2.length, (int)1);
            Assert.assertTrue((boolean)(iASTNodeLocationArray2[0] instanceof IASTFileLocation));
            Assert.assertEquals((int)iASTNodeLocationArray2[0].getNodeOffset(), (int)(string.indexOf("int ABC;") + "int ".length()));
            Assert.assertEquals((int)iASTNodeLocationArray2[0].getNodeLength(), (int)"ABC".length());
            Object object = parserLanguage = parserLanguage == ParserLanguage.C ? ParserLanguage.CPP : null;
        }
    }

    public void testObjectMacroExpansionModestDeclarator() throws Exception {
        StringBuffer stringBuffer = new StringBuffer("#define ABC * D\n");
        stringBuffer.append("int ABC;");
        String string = stringBuffer.toString();
        ParserLanguage parserLanguage = ParserLanguage.C;
        while (parserLanguage != null) {
            IASTTranslationUnit iASTTranslationUnit = this.parse(string, parserLanguage);
            IASTPreprocessorObjectStyleMacroDefinition iASTPreprocessorObjectStyleMacroDefinition = (IASTPreprocessorObjectStyleMacroDefinition)iASTTranslationUnit.getMacroDefinitions()[0];
            IASTSimpleDeclaration iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[0];
            IASTDeclarator iASTDeclarator = iASTSimpleDeclaration.getDeclarators()[0];
            Assert.assertEquals((String)iASTDeclarator.getName().toString(), (String)"D");
            Assert.assertEquals((int)iASTDeclarator.getPointerOperators().length, (int)1);
            IASTNodeLocation[] iASTNodeLocationArray = iASTDeclarator.getNodeLocations();
            Assert.assertEquals((int)iASTNodeLocationArray.length, (int)1);
            IASTMacroExpansion iASTMacroExpansion = (IASTMacroExpansion)iASTNodeLocationArray[0];
            IASTPreprocessorObjectStyleMacroDefinition iASTPreprocessorObjectStyleMacroDefinition2 = (IASTPreprocessorObjectStyleMacroDefinition)iASTMacroExpansion.getMacroDefinition();
            this.assertEqualsMacros((IASTPreprocessorMacroDefinition)iASTPreprocessorObjectStyleMacroDefinition2, (IASTPreprocessorMacroDefinition)iASTPreprocessorObjectStyleMacroDefinition);
            Assert.assertEquals((int)iASTMacroExpansion.getNodeOffset(), (int)0);
            Assert.assertEquals((int)iASTMacroExpansion.getNodeLength(), (int)3);
            IASTNodeLocation[] iASTNodeLocationArray2 = iASTMacroExpansion.getExpansionLocations();
            Assert.assertEquals((int)iASTNodeLocationArray2.length, (int)1);
            Assert.assertTrue((boolean)(iASTNodeLocationArray2[0] instanceof IASTFileLocation));
            Assert.assertEquals((int)iASTNodeLocationArray2[0].getNodeOffset(), (int)(string.indexOf("int ABC;") + "int ".length()));
            Assert.assertEquals((int)iASTNodeLocationArray2[0].getNodeLength(), (int)"ABC".length());
            IASTName iASTName = iASTDeclarator.getName();
            IASTNodeLocation[] iASTNodeLocationArray3 = iASTName.getNodeLocations();
            Assert.assertEquals((int)iASTNodeLocationArray3.length, (int)1);
            IASTMacroExpansion iASTMacroExpansion2 = (IASTMacroExpansion)iASTNodeLocationArray3[0];
            Assert.assertEquals((int)iASTMacroExpansion2.getNodeOffset(), (int)2);
            Assert.assertEquals((int)iASTMacroExpansion2.getNodeLength(), (int)1);
            Assert.assertEquals((int)iASTMacroExpansion2.getExpansionLocations()[0].getNodeOffset(), (int)iASTNodeLocationArray2[0].getNodeOffset());
            Assert.assertEquals((int)iASTMacroExpansion2.getExpansionLocations()[0].getNodeLength(), (int)iASTNodeLocationArray2[0].getNodeLength());
            IASTPointer iASTPointer = (IASTPointer)iASTDeclarator.getPointerOperators()[0];
            Assert.assertFalse((boolean)iASTPointer.isConst());
            Assert.assertFalse((boolean)iASTPointer.isVolatile());
            IASTMacroExpansion iASTMacroExpansion3 = (IASTMacroExpansion)iASTPointer.getNodeLocations()[0];
            Assert.assertEquals((int)iASTMacroExpansion3.getNodeOffset(), (int)0);
            Assert.assertEquals((int)iASTMacroExpansion3.getNodeLength(), (int)1);
            Assert.assertEquals((int)iASTMacroExpansion3.getExpansionLocations()[0].getNodeOffset(), (int)iASTNodeLocationArray2[0].getNodeOffset());
            Assert.assertEquals((int)iASTMacroExpansion3.getExpansionLocations()[0].getNodeLength(), (int)iASTNodeLocationArray2[0].getNodeLength());
            this.assertEqualsMacros(iASTMacroExpansion3.getMacroDefinition(), iASTMacroExpansion2.getMacroDefinition());
            Object object = parserLanguage = parserLanguage == ParserLanguage.C ? ParserLanguage.CPP : null;
        }
    }

    public void testObjectMacroExpansionPartialDeclSpec() throws Exception {
        StringBuffer stringBuffer = new StringBuffer("#define XYZ const\n");
        stringBuffer.append("XYZ int var;");
        String string = stringBuffer.toString();
        ParserLanguage parserLanguage = ParserLanguage.C;
        while (parserLanguage != null) {
            IASTTranslationUnit iASTTranslationUnit = this.parse(string, parserLanguage);
            IASTPreprocessorObjectStyleMacroDefinition iASTPreprocessorObjectStyleMacroDefinition = (IASTPreprocessorObjectStyleMacroDefinition)iASTTranslationUnit.getMacroDefinitions()[0];
            IASTSimpleDeclaration iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[0];
            IASTSimpleDeclSpecifier iASTSimpleDeclSpecifier = (IASTSimpleDeclSpecifier)iASTSimpleDeclaration.getDeclSpecifier();
            IASTNodeLocation[] iASTNodeLocationArray = iASTSimpleDeclSpecifier.getNodeLocations();
            Assert.assertEquals((int)iASTNodeLocationArray.length, (int)2);
            IASTMacroExpansion iASTMacroExpansion = (IASTMacroExpansion)iASTNodeLocationArray[0];
            this.assertEqualsMacros((IASTPreprocessorMacroDefinition)iASTPreprocessorObjectStyleMacroDefinition, iASTMacroExpansion.getMacroDefinition());
            Assert.assertEquals((int)iASTMacroExpansion.getNodeOffset(), (int)0);
            Assert.assertEquals((int)iASTMacroExpansion.getNodeLength(), (int)6);
            IASTNodeLocation[] iASTNodeLocationArray2 = iASTMacroExpansion.getExpansionLocations();
            Assert.assertEquals((int)iASTNodeLocationArray2.length, (int)1);
            Assert.assertTrue((boolean)(iASTNodeLocationArray2[0] instanceof IASTFileLocation));
            Assert.assertEquals((int)iASTNodeLocationArray2[0].getNodeOffset(), (int)string.indexOf("XYZ int"));
            Assert.assertEquals((int)iASTNodeLocationArray2[0].getNodeLength(), (int)"XYZ".length());
            IASTFileLocation iASTFileLocation = (IASTFileLocation)iASTNodeLocationArray[1];
            Assert.assertEquals((int)iASTFileLocation.getNodeOffset(), (int)string.indexOf(" int"));
            Assert.assertEquals((int)iASTFileLocation.getNodeLength(), (int)" int".length());
            Object object = parserLanguage = parserLanguage == ParserLanguage.C ? ParserLanguage.CPP : null;
        }
    }

    public void testObjectMacroExpansionNested() throws Exception {
        StringBuffer stringBuffer = new StringBuffer("#define XYZ const\n");
        stringBuffer.append("#define PO *\n");
        stringBuffer.append("#define C_PO PO XYZ\n");
        stringBuffer.append("int C_PO var;");
        String string = stringBuffer.toString();
        ParserLanguage parserLanguage = ParserLanguage.C;
        while (parserLanguage != null) {
            IASTTranslationUnit iASTTranslationUnit = this.parse(string, parserLanguage);
            IASTPreprocessorMacroDefinition[] iASTPreprocessorMacroDefinitionArray = iASTTranslationUnit.getMacroDefinitions();
            IASTPreprocessorMacroDefinition iASTPreprocessorMacroDefinition = iASTPreprocessorMacroDefinitionArray[0];
            IASTPreprocessorMacroDefinition iASTPreprocessorMacroDefinition2 = iASTPreprocessorMacroDefinitionArray[1];
            IASTPreprocessorMacroDefinition iASTPreprocessorMacroDefinition3 = iASTPreprocessorMacroDefinitionArray[2];
            IASTSimpleDeclaration iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[0];
            Assert.assertTrue((iASTSimpleDeclaration.getDeclarators()[0].getPointerOperators().length > 0 ? 1 : 0) != 0);
            IASTNodeLocation[] iASTNodeLocationArray = iASTSimpleDeclaration.getNodeLocations();
            Assert.assertEquals((int)3, (int)iASTNodeLocationArray.length);
            IASTFileLocation iASTFileLocation = (IASTFileLocation)iASTNodeLocationArray[0];
            Assert.assertEquals((int)iASTFileLocation.getNodeOffset(), (int)string.indexOf("int"));
            Assert.assertEquals((int)iASTFileLocation.getNodeLength(), (int)"int ".length());
            IASTMacroExpansion iASTMacroExpansion = (IASTMacroExpansion)iASTNodeLocationArray[1];
            IASTPreprocessorMacroDefinition iASTPreprocessorMacroDefinition4 = iASTMacroExpansion.getMacroDefinition();
            this.assertEqualsMacros(iASTPreprocessorMacroDefinition3, iASTPreprocessorMacroDefinition4);
            Assert.assertEquals((int)0, (int)iASTMacroExpansion.getNodeOffset());
            Assert.assertEquals((int)(4 + iASTPreprocessorMacroDefinition3.getExpansion().length() + iASTPreprocessorMacroDefinition.getExpansion().length() + iASTPreprocessorMacroDefinition2.getExpansion().length()), (int)iASTMacroExpansion.getNodeLength());
            IASTFileLocation iASTFileLocation2 = (IASTFileLocation)iASTNodeLocationArray[2];
            Assert.assertEquals((int)string.indexOf(" var"), (int)iASTFileLocation2.getNodeOffset());
            Assert.assertEquals((int)" var;".length(), (int)iASTFileLocation2.getNodeLength());
            Object object = parserLanguage = parserLanguage == ParserLanguage.C ? ParserLanguage.CPP : null;
        }
    }

    public void testObjectMacroExpansionComplex() throws Exception {
        StringBuffer stringBuffer = new StringBuffer("#define XYZ const\n");
        stringBuffer.append("#define PO *\n");
        stringBuffer.append("#define C_PO PO XYZ\n");
        stringBuffer.append("#define IT int\n");
        stringBuffer.append("#define V var\n");
        stringBuffer.append("XYZ IT C_PO C_PO V;");
        String string = stringBuffer.toString();
        ParserLanguage parserLanguage = ParserLanguage.C;
        while (parserLanguage != null) {
            IASTTranslationUnit iASTTranslationUnit = this.parse(string, parserLanguage);
            IASTPreprocessorObjectStyleMacroDefinition iASTPreprocessorObjectStyleMacroDefinition = (IASTPreprocessorObjectStyleMacroDefinition)iASTTranslationUnit.getMacroDefinitions()[0];
            IASTPreprocessorObjectStyleMacroDefinition iASTPreprocessorObjectStyleMacroDefinition2 = (IASTPreprocessorObjectStyleMacroDefinition)iASTTranslationUnit.getMacroDefinitions()[2];
            IASTPreprocessorObjectStyleMacroDefinition iASTPreprocessorObjectStyleMacroDefinition3 = (IASTPreprocessorObjectStyleMacroDefinition)iASTTranslationUnit.getMacroDefinitions()[3];
            IASTPreprocessorObjectStyleMacroDefinition iASTPreprocessorObjectStyleMacroDefinition4 = (IASTPreprocessorObjectStyleMacroDefinition)iASTTranslationUnit.getMacroDefinitions()[4];
            IASTSimpleDeclaration iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[0];
            IASTNodeLocation[] iASTNodeLocationArray = iASTSimpleDeclaration.getNodeLocations();
            Assert.assertEquals((int)10, (int)iASTNodeLocationArray.length);
            IASTMacroExpansion iASTMacroExpansion = (IASTMacroExpansion)iASTNodeLocationArray[0];
            this.assertEqualsMacros(iASTMacroExpansion.getMacroDefinition(), (IASTPreprocessorMacroDefinition)iASTPreprocessorObjectStyleMacroDefinition);
            IASTFileLocation iASTFileLocation = (IASTFileLocation)iASTNodeLocationArray[1];
            Assert.assertEquals((int)1, (int)iASTFileLocation.getNodeLength());
            IASTMacroExpansion iASTMacroExpansion2 = (IASTMacroExpansion)iASTNodeLocationArray[2];
            this.assertEqualsMacros(iASTMacroExpansion2.getMacroDefinition(), (IASTPreprocessorMacroDefinition)iASTPreprocessorObjectStyleMacroDefinition3);
            IASTFileLocation iASTFileLocation2 = (IASTFileLocation)iASTNodeLocationArray[3];
            Assert.assertEquals((int)1, (int)iASTFileLocation2.getNodeLength());
            IASTMacroExpansion iASTMacroExpansion3 = (IASTMacroExpansion)iASTNodeLocationArray[4];
            this.assertEqualsMacros(iASTMacroExpansion3.getMacroDefinition(), (IASTPreprocessorMacroDefinition)iASTPreprocessorObjectStyleMacroDefinition2);
            IASTFileLocation iASTFileLocation3 = (IASTFileLocation)iASTNodeLocationArray[5];
            Assert.assertEquals((int)1, (int)iASTFileLocation3.getNodeLength());
            IASTMacroExpansion iASTMacroExpansion4 = (IASTMacroExpansion)iASTNodeLocationArray[6];
            this.assertEqualsMacros(iASTMacroExpansion4.getMacroDefinition(), (IASTPreprocessorMacroDefinition)iASTPreprocessorObjectStyleMacroDefinition2);
            IASTFileLocation iASTFileLocation4 = (IASTFileLocation)iASTNodeLocationArray[7];
            Assert.assertEquals((int)1, (int)iASTFileLocation4.getNodeLength());
            IASTMacroExpansion iASTMacroExpansion5 = (IASTMacroExpansion)iASTNodeLocationArray[8];
            this.assertEqualsMacros(iASTMacroExpansion5.getMacroDefinition(), (IASTPreprocessorMacroDefinition)iASTPreprocessorObjectStyleMacroDefinition4);
            IASTFileLocation iASTFileLocation5 = (IASTFileLocation)iASTNodeLocationArray[9];
            Assert.assertEquals((int)1, (int)iASTFileLocation5.getNodeLength());
            IASTFileLocation iASTFileLocation6 = iASTSimpleDeclaration.getFileLocation();
            Assert.assertNotNull((Object)iASTFileLocation6);
            Assert.assertEquals((int)string.indexOf("XYZ IT C_PO C_PO V;"), (int)iASTFileLocation6.getNodeOffset());
            Assert.assertEquals((int)"XYZ IT C_PO C_PO V;".length(), (int)iASTFileLocation6.getNodeLength());
            Object object = parserLanguage = parserLanguage == ParserLanguage.C ? ParserLanguage.CPP : null;
        }
    }

    public void testStdioBug() throws ParserException {
        StringBuffer stringBuffer = new StringBuffer("#define    _PTR        void *\n");
        stringBuffer.append("#define __cdecl __attribute__ ((__cdecl__))\n");
        stringBuffer.append("#define _EXFUN(name, proto)     __cdecl name proto\n");
        stringBuffer.append("_PTR     _EXFUN(memchr,(const _PTR, int, size_t));\n");
        String string = stringBuffer.toString();
        ParserLanguage parserLanguage = ParserLanguage.C;
        while (parserLanguage != null) {
            IASTTranslationUnit iASTTranslationUnit = this.parse(string, parserLanguage, true, true);
            IASTPreprocessorMacroDefinition[] iASTPreprocessorMacroDefinitionArray = iASTTranslationUnit.getMacroDefinitions();
            IASTPreprocessorObjectStyleMacroDefinition iASTPreprocessorObjectStyleMacroDefinition = (IASTPreprocessorObjectStyleMacroDefinition)iASTPreprocessorMacroDefinitionArray[0];
            IASTPreprocessorFunctionStyleMacroDefinition iASTPreprocessorFunctionStyleMacroDefinition = (IASTPreprocessorFunctionStyleMacroDefinition)iASTPreprocessorMacroDefinitionArray[2];
            IASTSimpleDeclaration iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[0];
            IASTNodeLocation[] iASTNodeLocationArray = iASTSimpleDeclaration.getNodeLocations();
            Assert.assertEquals((int)iASTNodeLocationArray.length, (int)4);
            IASTMacroExpansion iASTMacroExpansion = (IASTMacroExpansion)iASTNodeLocationArray[0];
            this.assertEqualsMacros((IASTPreprocessorMacroDefinition)iASTPreprocessorObjectStyleMacroDefinition, iASTMacroExpansion.getMacroDefinition());
            IASTFileLocation iASTFileLocation = (IASTFileLocation)iASTNodeLocationArray[1];
            Assert.assertEquals((int)iASTFileLocation.getNodeOffset(), (int)string.indexOf("     _EXFUN("));
            Assert.assertEquals((int)iASTFileLocation.getNodeLength(), (int)"     ".length());
            IASTMacroExpansion iASTMacroExpansion2 = (IASTMacroExpansion)iASTNodeLocationArray[2];
            this.assertEqualsMacros((IASTPreprocessorMacroDefinition)iASTPreprocessorFunctionStyleMacroDefinition, iASTMacroExpansion2.getMacroDefinition());
            IASTFileLocation iASTFileLocation2 = (IASTFileLocation)iASTNodeLocationArray[3];
            Assert.assertEquals((int)iASTFileLocation2.getNodeOffset(), (int)string.indexOf(";"));
            Assert.assertEquals((int)iASTFileLocation2.getNodeLength(), (int)1);
            IASTFileLocation iASTFileLocation3 = iASTSimpleDeclaration.getFileLocation();
            Assert.assertEquals((int)iASTFileLocation3.getNodeOffset(), (int)string.indexOf("_PTR     _EXFUN(memchr,(const _PTR, int, size_t));"));
            Assert.assertEquals((int)iASTFileLocation3.getNodeLength(), (int)"_PTR     _EXFUN(memchr,(const _PTR, int, size_t));".length());
            IASTDeclarator iASTDeclarator = iASTSimpleDeclaration.getDeclarators()[0];
            IASTFileLocation iASTFileLocation4 = iASTDeclarator.getFileLocation();
            Assert.assertEquals((int)string.indexOf("_PTR     _EXFUN(memchr,(const _PTR, int, size_t))"), (int)iASTFileLocation4.getNodeOffset());
            Assert.assertEquals((int)"_PTR     _EXFUN(memchr,(const _PTR, int, size_t))".length(), (int)iASTFileLocation4.getNodeLength());
            Object object = parserLanguage = parserLanguage == ParserLanguage.C ? ParserLanguage.CPP : null;
        }
    }

    private void assertEqualsMacros(IASTPreprocessorMacroDefinition iASTPreprocessorMacroDefinition, IASTPreprocessorMacroDefinition iASTPreprocessorMacroDefinition2) {
        Assert.assertEquals((String)iASTPreprocessorMacroDefinition.getExpansion(), (String)iASTPreprocessorMacroDefinition2.getExpansion());
        Assert.assertEquals((String)iASTPreprocessorMacroDefinition.getName().toString(), (String)iASTPreprocessorMacroDefinition2.getName().toString());
    }

    public void testMacroBindings() throws Exception {
        StringBuffer stringBuffer = new StringBuffer("#define ABC def\n");
        stringBuffer.append("int ABC;\n");
        stringBuffer.append("#undef ABC\n");
        stringBuffer.append("#define ABC ghi\n");
        stringBuffer.append("int ABC;\n");
        String string = stringBuffer.toString();
        ParserLanguage parserLanguage = ParserLanguage.C;
        while (parserLanguage != null) {
            IASTTranslationUnit iASTTranslationUnit = this.parse(string, parserLanguage);
            IASTPreprocessorMacroDefinition[] iASTPreprocessorMacroDefinitionArray = iASTTranslationUnit.getMacroDefinitions();
            Assert.assertEquals((int)iASTPreprocessorMacroDefinitionArray.length, (int)2);
            IASTPreprocessorObjectStyleMacroDefinition iASTPreprocessorObjectStyleMacroDefinition = (IASTPreprocessorObjectStyleMacroDefinition)iASTPreprocessorMacroDefinitionArray[0];
            IASTPreprocessorObjectStyleMacroDefinition iASTPreprocessorObjectStyleMacroDefinition2 = (IASTPreprocessorObjectStyleMacroDefinition)iASTPreprocessorMacroDefinitionArray[1];
            IMacroBinding iMacroBinding = (IMacroBinding)iASTPreprocessorObjectStyleMacroDefinition.getName().resolveBinding();
            Assert.assertNotNull((Object)iMacroBinding);
            IMacroBinding iMacroBinding2 = (IMacroBinding)iASTPreprocessorObjectStyleMacroDefinition2.getName().resolveBinding();
            Assert.assertNotNull((Object)iMacroBinding2);
            Assert.assertNotSame((Object)iMacroBinding, (Object)iMacroBinding2);
            IASTName[] iASTNameArray = iASTTranslationUnit.getReferences((IBinding)iMacroBinding);
            IASTName[] iASTNameArray2 = iASTTranslationUnit.getDeclarations((IBinding)iMacroBinding);
            Assert.assertEquals((int)iASTNameArray.length, (int)2);
            Assert.assertEquals((Object)iASTNameArray[0].getPropertyInParent(), (Object)IASTTranslationUnit.EXPANSION_NAME);
            Assert.assertEquals((Object)iASTNameArray[0].getParent(), (Object)iASTTranslationUnit);
            Assert.assertEquals((Object)iASTNameArray[1].getPropertyInParent(), (Object)IASTPreprocessorUndefStatement.MACRO_NAME);
            Assert.assertTrue((boolean)(iASTNameArray[1].getParent() instanceof IASTPreprocessorUndefStatement));
            Assert.assertEquals((int)iASTNameArray2.length, (int)1);
            Assert.assertSame((Object)iASTPreprocessorObjectStyleMacroDefinition.getName(), (Object)iASTNameArray2[0]);
            IASTName[] iASTNameArray3 = iASTTranslationUnit.getReferences((IBinding)iMacroBinding2);
            IASTName[] iASTNameArray4 = iASTTranslationUnit.getDeclarations((IBinding)iMacroBinding2);
            Assert.assertEquals((int)1, (int)iASTNameArray3.length);
            Assert.assertEquals((Object)iASTNameArray3[0].getPropertyInParent(), (Object)IASTTranslationUnit.EXPANSION_NAME);
            Assert.assertEquals((Object)iASTNameArray3[0].getParent(), (Object)iASTTranslationUnit);
            Assert.assertSame((Object)iASTPreprocessorObjectStyleMacroDefinition2.getName(), (Object)iASTNameArray4[0]);
            Object object = parserLanguage = parserLanguage == ParserLanguage.C ? ParserLanguage.CPP : null;
        }
    }

    public void testBug90978() throws Exception {
        StringBuffer stringBuffer = new StringBuffer("#define MACRO mm\n");
        stringBuffer.append("int MACRO;\n");
        String string = stringBuffer.toString();
        ParserLanguage parserLanguage = ParserLanguage.C;
        while (parserLanguage != null) {
            IASTTranslationUnit iASTTranslationUnit = this.parse(string, parserLanguage);
            IASTPreprocessorObjectStyleMacroDefinition iASTPreprocessorObjectStyleMacroDefinition = (IASTPreprocessorObjectStyleMacroDefinition)iASTTranslationUnit.getMacroDefinitions()[0];
            IASTName iASTName = iASTPreprocessorObjectStyleMacroDefinition.getName();
            IMacroBinding iMacroBinding = (IMacroBinding)iASTName.resolveBinding();
            IASTName[] iASTNameArray = iASTTranslationUnit.getReferences((IBinding)iMacroBinding);
            Assert.assertEquals((int)iASTNameArray.length, (int)1);
            IASTName iASTName2 = iASTNameArray[0];
            IASTNodeLocation[] iASTNodeLocationArray = iASTName2.getNodeLocations();
            Assert.assertEquals((int)iASTNodeLocationArray.length, (int)1);
            Assert.assertTrue((boolean)(iASTNodeLocationArray[0] instanceof IASTFileLocation));
            IASTFileLocation iASTFileLocation = (IASTFileLocation)iASTNodeLocationArray[0];
            Assert.assertEquals((int)(string.indexOf("int MACRO") + "int ".length()), (int)iASTFileLocation.getNodeOffset());
            Assert.assertEquals((int)"MACRO".length(), (int)iASTFileLocation.getNodeLength());
            Object object = parserLanguage = parserLanguage == ParserLanguage.C ? ParserLanguage.CPP : null;
        }
    }

    public void testBug94933() throws Exception {
        StringBuffer stringBuffer = new StringBuffer("#define API extern\n");
        stringBuffer.append("#define MYAPI API\n");
        stringBuffer.append("MYAPI void func() {}");
        String string = stringBuffer.toString();
        ParserLanguage parserLanguage = ParserLanguage.C;
        while (parserLanguage != null) {
            IASTTranslationUnit iASTTranslationUnit = this.parse(string, parserLanguage);
            IASTFunctionDefinition iASTFunctionDefinition = (IASTFunctionDefinition)iASTTranslationUnit.getDeclarations()[0];
            Assert.assertNotNull((Object)iASTFunctionDefinition.getFileLocation());
            Object object = parserLanguage = parserLanguage == ParserLanguage.C ? ParserLanguage.CPP : null;
        }
    }
}

