/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.tests.ast2;

import java.io.StringWriter;
import java.io.Writer;
import junit.framework.Assert;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.ILabel;
import org.eclipse.cdt.core.dom.ast.IMacroBinding;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.c.ICExternalBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateInstance;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPVariable;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.parser.tests.ast2.DOMFileBasePluginTest;
import org.eclipse.cdt.core.parser.tests.ast2.DOMSelectionParseBaseTest;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.model.CProject;
import org.eclipse.core.resources.IFile;

public class DOMSelectionParseTest
extends DOMSelectionParseBaseTest {
    static /* synthetic */ Class class$0;

    public DOMSelectionParseTest(String string) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.core.parser.tests.ast2.DOMSelectionParseTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        super(string, clazz);
    }

    public void testBaseCase_VariableReference() throws Exception {
        String string = "void f() { int x; x=3; }";
        int n = string.indexOf("x=");
        int n2 = string.indexOf(61);
        IASTNode iASTNode = this.parse(string, n, n2);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(((IASTName)iASTNode).resolveBinding() instanceof IVariable));
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"x");
        IASTName[] iASTNameArray = this.getDeclarationOffTU((IASTName)iASTNode);
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((String)iASTNameArray[0].toString(), (String)"x");
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getOffset(), (int)15);
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getLength(), (int)1);
    }

    public void testBaseCase_FunctionReference() throws Exception {
        String string = "int x(){x( );}";
        int n = string.indexOf("x( ");
        int n2 = string.indexOf("( )");
        IASTNode iASTNode = this.parse(string, n, n2);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(((IASTName)iASTNode).resolveBinding() instanceof IFunction));
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"x");
        IASTName[] iASTNameArray = this.getDeclarationOffTU((IASTName)iASTNode);
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((String)iASTNameArray[0].toString(), (String)"x");
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getOffset(), (int)4);
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getLength(), (int)1);
    }

    public void testBaseCase_Error() throws Exception {
        String string = "int x() { y( ) }";
        int n = string.indexOf("y( ");
        int n2 = string.indexOf("( )");
        Assert.assertNull((Object)this.parse(string, n, n2, false));
    }

    public void testBaseCase_FunctionDeclaration() throws Exception {
        String string = "int x(); x( );";
        int n = string.indexOf("x()");
        int n2 = string.indexOf("()");
        IASTNode iASTNode = this.parse(string, n, n2);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(((IASTName)iASTNode).resolveBinding() instanceof IFunction));
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"x");
        IASTName[] iASTNameArray = this.getDeclarationOffTU((IASTName)iASTNode);
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((String)iASTNameArray[0].toString(), (String)"x");
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getOffset(), (int)4);
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getLength(), (int)1);
    }

    public void testBaseCase_FunctionDeclaration2() throws Exception {
        String string = "int printf( const char *, ... ); ";
        int n = string.indexOf("printf");
        int n2 = string.indexOf("( const");
        IASTNode iASTNode = this.parse(string, n, n2);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(((IASTName)iASTNode).resolveBinding() instanceof IFunction));
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"printf");
    }

    public void testBaseCase_VariableDeclaration() throws Exception {
        String string = "int x = 3;";
        int n = string.indexOf("x");
        int n2 = string.indexOf(" =");
        IASTNode iASTNode = this.parse(string, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(((IASTName)iASTNode).resolveBinding() instanceof IVariable));
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"x");
    }

    public void testBaseCase_Parameter() throws Exception {
        String string = "int main( int argc ) { int x = argc; }";
        int n = string.indexOf("argc;");
        int n2 = string.indexOf(";");
        IASTNode iASTNode = this.parse(string, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(((IASTName)iASTNode).resolveBinding() instanceof IParameter));
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"argc");
        IASTName[] iASTNameArray = this.getDeclarationOffTU((IASTName)iASTNode);
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((String)iASTNameArray[0].toString(), (String)"argc");
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getOffset(), (int)14);
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getLength(), (int)4);
    }

    public void testBug57898() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class Gonzo {  public: void playHorn(); };\n");
        ((Writer)stringWriter).write("void Gonzo::playHorn() { return; }\n");
        ((Writer)stringWriter).write("int\tmain(int argc, char **argv) { Gonzo gonzo; gonzo.playHorn(); }\n");
        String string = ((Object)stringWriter).toString();
        int n = 0;
        while (n < 3) {
            int n2 = -1;
            int n3 = -1;
            switch (n) {
                case 0: {
                    n2 = string.indexOf("void playHorn") + 5;
                    break;
                }
                case 1: {
                    n2 = string.indexOf("::playHorn") + 2;
                    break;
                }
                case 2: {
                    n2 = string.indexOf(".playHorn") + 1;
                }
            }
            n3 = n2 + 8;
            IASTNode iASTNode = this.parse(string, n2, n3);
            Assert.assertNotNull((Object)iASTNode);
            Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
            Assert.assertTrue((boolean)(((IASTName)iASTNode).resolveBinding() instanceof ICPPMethod));
            Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"playHorn");
            IASTName[] iASTNameArray = this.getDeclarationOffTU((IASTName)iASTNode);
            Assert.assertEquals((int)iASTNameArray.length, (int)2);
            Assert.assertEquals((String)iASTNameArray[0].toString(), (String)"playHorn");
            Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getOffset(), (int)28);
            Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getLength(), (int)8);
            ++n;
        }
    }

    public void testConstructorDestructorDeclaration() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class Gonzo { Gonzo(); ~Gonzo(); };");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf(" Gonzo()") + 1;
        IASTNode iASTNode = this.parse(string, n, n + 5);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(((IASTName)iASTNode).resolveBinding() instanceof ICPPConstructor));
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"Gonzo");
        n = string.indexOf("~Gonzo");
        iASTNode = this.parse(string, n, n + 6);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(((IASTName)iASTNode).resolveBinding() instanceof ICPPMethod));
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"~Gonzo");
    }

    public void testBug60264() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("namespace Muppets { int i;\t}\n");
        ((Writer)stringWriter).write("int\tmain(int argc, char **argv) {\tMuppets::i = 1; }\n");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf("Muppets::");
        IASTNode iASTNode = this.parse(string, n, n + 7);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(((IASTName)iASTNode).resolveBinding() instanceof ICPPNamespace));
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"Muppets");
        IASTName[] iASTNameArray = this.getDeclarationOffTU((IASTName)iASTNode);
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((String)iASTNameArray[0].toString(), (String)"Muppets");
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getOffset(), (int)10);
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getLength(), (int)7);
        n = string.indexOf("e Muppets") + 2;
        iASTNode = this.parse(string, n, n + 7);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(((IASTName)iASTNode).resolveBinding() instanceof ICPPNamespace));
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"Muppets");
        iASTNameArray = this.getDeclarationOffTU((IASTName)iASTNode);
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((String)iASTNameArray[0].toString(), (String)"Muppets");
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getOffset(), (int)10);
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getLength(), (int)7);
    }

    public void testBug61613() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class Foo {  // ** (A) **\n");
        ((Writer)stringWriter).write("\tpublic:\n");
        ((Writer)stringWriter).write("Foo() {};\n");
        ((Writer)stringWriter).write("};\n");
        ((Writer)stringWriter).write("int \n");
        ((Writer)stringWriter).write("main(int argc, char **argv) {\n");
        ((Writer)stringWriter).write("Foo foo;  // ** (B) **\n");
        ((Writer)stringWriter).write("}\n");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf("class Foo") + 6;
        IASTNode iASTNode = this.parse(string, n, n + 3);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(((IASTName)iASTNode).resolveBinding() instanceof ICPPClassType));
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"Foo");
        IASTName[] iASTNameArray = this.getDeclarationOffTU((IASTName)iASTNode);
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((String)iASTNameArray[0].toString(), (String)"Foo");
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getOffset(), (int)6);
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getLength(), (int)3);
    }

    public void testBug60038() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class Gonzo {\n");
        ((Writer)stringWriter).write("public:\n");
        ((Writer)stringWriter).write("Gonzo( const Gonzo & other ){}\n");
        ((Writer)stringWriter).write("Gonzo()\t{}\n");
        ((Writer)stringWriter).write("~Gonzo(){}\n");
        ((Writer)stringWriter).write("};\n");
        ((Writer)stringWriter).write("int main(int argc, char **argv) {\n");
        ((Writer)stringWriter).write(" Gonzo * g = new Gonzo();\n");
        ((Writer)stringWriter).write(" Gonzo * g2 = new Gonzo( *g );\n");
        ((Writer)stringWriter).write(" g->~Gonzo();\n");
        ((Writer)stringWriter).write(" return (int) g2;\n");
        ((Writer)stringWriter).write("}\n");
        String string = ((Object)stringWriter).toString();
        int n = 0;
        while (n < 3) {
            int n2 = 0;
            int n3 = 0;
            switch (n) {
                case 0: {
                    n2 = string.indexOf("new Gonzo()") + 4;
                    n3 = n2 + 5;
                    break;
                }
                case 1: {
                    n2 = string.indexOf("new Gonzo( ") + 4;
                    n3 = n2 + 5;
                    break;
                }
                default: {
                    n2 = string.indexOf("->~") + 2;
                    n3 = n2 + 6;
                }
            }
            IASTNode iASTNode = this.parse(string, n2, n3);
            Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
            Assert.assertTrue((boolean)(((IASTName)iASTNode).resolveBinding() instanceof ICPPMethod));
            IBinding iBinding = ((IASTName)iASTNode).resolveBinding();
            IASTName[] iASTNameArray = null;
            switch (n) {
                case 0: {
                    Assert.assertTrue((boolean)(iBinding instanceof ICPPConstructor));
                    iASTNameArray = this.getDeclarationOffTU((IASTName)iASTNode);
                    Assert.assertEquals((int)iASTNameArray.length, (int)1);
                    Assert.assertEquals((String)iASTNameArray[0].toString(), (String)"Gonzo");
                    Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getOffset(), (int)53);
                    Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getLength(), (int)5);
                    break;
                }
                case 1: {
                    Assert.assertTrue((boolean)(iBinding instanceof ICPPConstructor));
                    iASTNameArray = this.getDeclarationOffTU((IASTName)iASTNode);
                    Assert.assertEquals((int)iASTNameArray.length, (int)1);
                    Assert.assertEquals((String)iASTNameArray[0].toString(), (String)"Gonzo");
                    Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getOffset(), (int)22);
                    Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getLength(), (int)5);
                    break;
                }
                default: {
                    Assert.assertFalse((boolean)(iBinding instanceof ICPPConstructor));
                    String string2 = ((IASTName)iASTNode).toString();
                    Assert.assertEquals((int)string2.indexOf("~"), (int)0);
                    Assert.assertEquals((int)string2.indexOf("Gonzo"), (int)1);
                    iASTNameArray = this.getDeclarationOffTU((IASTName)iASTNode);
                    Assert.assertEquals((int)iASTNameArray.length, (int)1);
                    Assert.assertEquals((String)iASTNameArray[0].toString(), (String)"~Gonzo");
                    Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getOffset(), (int)64);
                    Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getLength(), (int)6);
                }
            }
            ++n;
        }
    }

    public void testMethodReference() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class Sample { public:\n");
        ((Writer)stringWriter).write("  int getAnswer() const;\n");
        ((Writer)stringWriter).write("};\n");
        ((Writer)stringWriter).write("int main(int argc, char **argv) {\n");
        ((Writer)stringWriter).write(" Sample * s = new Sample();\n");
        ((Writer)stringWriter).write(" return s->getAnswer();\n");
        ((Writer)stringWriter).write("}\n");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf("->getAnswer") + 2;
        IASTNode iASTNode = this.parse(string, n, n + 9);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(((IASTName)iASTNode).resolveBinding() instanceof ICPPMethod));
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"getAnswer");
        IASTName[] iASTNameArray = this.getDeclarationOffTU((IASTName)iASTNode);
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((String)iASTNameArray[0].toString(), (String)"getAnswer");
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getOffset(), (int)29);
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getLength(), (int)9);
    }

    public void testConstructorDefinition() throws Exception {
        String string = "class ABC { public: ABC(); }; ABC::ABC(){}";
        int n = string.indexOf("::ABC") + 2;
        IASTNode iASTNode = this.parse(string, n, n + 3);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(((IASTName)iASTNode).resolveBinding() instanceof ICPPConstructor));
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"ABC");
        IASTName[] iASTNameArray = this.getDeclarationOffTU((IASTName)iASTNode);
        Assert.assertEquals((int)iASTNameArray.length, (int)2);
        Assert.assertEquals((String)iASTNameArray[0].toString(), (String)"ABC");
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getOffset(), (int)20);
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getLength(), (int)3);
    }

    public void testBug63966() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("void foo(int a) {}\n");
        ((Writer)stringWriter).write("void foo(long a) {}\n");
        ((Writer)stringWriter).write("int main(int argc, char **argv) {\n");
        ((Writer)stringWriter).write("foo(1); \n }");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf("foo(1)");
        this.parse(string, n, n + 3);
    }

    public void testBug66744() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("enum EColours { RED, GREEN, BLUE };      \n");
        ((Writer)stringWriter).write("void foo() {  EColours color = GREEN; }  \n");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf("EColours color");
        this.parse(string, n, n + 8);
    }

    public void testBug68527() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("struct X;\n");
        ((Writer)stringWriter).write("struct X anA;");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf("X anA");
        this.parse(string, n, n + 1);
    }

    public void testBug60407() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("struct ZZZ { int x, y, z; };\n");
        ((Writer)stringWriter).write("typedef struct ZZZ _FILE;\n");
        ((Writer)stringWriter).write("typedef _FILE FILE;\n");
        ((Writer)stringWriter).write("static void static_function(FILE * lcd){}\n");
        ((Writer)stringWriter).write("int\tmain(int argc, char **argv) {\n");
        ((Writer)stringWriter).write("FILE * file = 0;\n");
        ((Writer)stringWriter).write("static_function( file );\n");
        ((Writer)stringWriter).write("return 0;\n");
        ((Writer)stringWriter).write("}\n");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf("static_function( file )");
        this.parse(string, n, n + "static_function".length());
    }

    public void testBug61800() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class B {};\n");
        ((Writer)stringWriter).write("class ABCDEF {\n");
        ((Writer)stringWriter).write(" static B stInt; };\n");
        ((Writer)stringWriter).write("B ABCDEF::stInt = 5;\n");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf("::stInt") + 2;
        IASTNode iASTNode = this.parse(string, n, n + 5);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(((IASTName)iASTNode).resolveBinding() instanceof ICPPField));
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"stInt");
        IASTName[] iASTNameArray = this.getDeclarationOffTU((IASTName)iASTNode);
        Assert.assertEquals((int)iASTNameArray.length, (int)2);
        Assert.assertEquals((String)iASTNameArray[0].toString(), (String)"stInt");
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getOffset(), (int)37);
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getLength(), (int)5);
    }

    public void testBug68739() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("int fprintf( int *, const char *, ... );               \n");
        ((Writer)stringWriter).write("void boo( int * lcd ) {                                \n");
        ((Writer)stringWriter).write("  /**/fprintf( lcd, \"%c%s 0x%x\", ' ', \"bbb\", 2 );  \n");
        ((Writer)stringWriter).write("}                                                      \n");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf("/**/fprintf") + 4;
        IASTNode iASTNode = this.parse(string, n, n + 7);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(((IASTName)iASTNode).resolveBinding() instanceof IFunction));
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"fprintf");
    }

    public void testBug72818() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("union Squaw\t{\tint x;\tdouble u; };\n");
        ((Writer)stringWriter).write("int\tmain(int argc, char **argv) {\n");
        ((Writer)stringWriter).write("return sizeof( Squaw );\n");
        ((Writer)stringWriter).write("}\n");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf("sizeof( ") + "sizeof( ".length();
        IASTNode iASTNode = this.parse(string, n, n + 5);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(((IASTName)iASTNode).resolveBinding() instanceof ICPPClassType));
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"Squaw");
        Assert.assertEquals((int)((ICPPClassType)((IASTName)iASTNode).resolveBinding()).getKey(), (int)2);
        IASTName[] iASTNameArray = this.getDeclarationOffTU((IASTName)iASTNode);
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((String)iASTNameArray[0].toString(), (String)"Squaw");
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getOffset(), (int)6);
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getLength(), (int)5);
    }

    public void test72220() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("const int FOUND_ME = 1;\n");
        ((Writer)stringWriter).write("class Test{\n");
        ((Writer)stringWriter).write("public:\n");
        ((Writer)stringWriter).write("const int findCode() const;\n");
        ((Writer)stringWriter).write("};\n");
        ((Writer)stringWriter).write("const int Test::findCode() const {\n");
        ((Writer)stringWriter).write("return FOUND_ME;\n");
        ((Writer)stringWriter).write("}\n");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf("return ") + "return ".length();
        IASTNode iASTNode = this.parse(string, n, n + 8);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(((IASTName)iASTNode).resolveBinding() instanceof IVariable));
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"FOUND_ME");
        IASTName[] iASTNameArray = this.getDeclarationOffTU((IASTName)iASTNode);
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((String)iASTNameArray[0].toString(), (String)"FOUND_ME");
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getOffset(), (int)10);
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getLength(), (int)8);
    }

    public void testBug72721() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write(" class ABC { public: ABC(int); };   \n");
        ((Writer)stringWriter).write("void f() {                          \n");
        ((Writer)stringWriter).write("   int j = 1;                       \n");
        ((Writer)stringWriter).write("   new ABC( j + 1 );                \n");
        ((Writer)stringWriter).write("}                                   \n");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf("ABC(");
        IASTNode iASTNode = this.parse(string, n, n + 3);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(((IASTName)iASTNode).resolveBinding() instanceof ICPPConstructor));
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"ABC");
        IASTName[] iASTNameArray = this.getDeclarationOffTU((IASTName)iASTNode);
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((String)iASTNameArray[0].toString(), (String)"ABC");
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getOffset(), (int)21);
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getLength(), (int)3);
    }

    public void testBug72372() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("namespace B {                                   \n");
        ((Writer)stringWriter).write("   class SD_02 { void f_SD(); };                \n");
        ((Writer)stringWriter).write("}                                               \n");
        ((Writer)stringWriter).write("using namespace B;                              \n");
        ((Writer)stringWriter).write("void SD_02::f_SD(){}                            \n");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf(":f_SD");
        IASTNode iASTNode = this.parse(string, n + 1, n + 5);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(((IASTName)iASTNode).resolveBinding() instanceof ICPPMethod));
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"f_SD");
        IASTName[] iASTNameArray = this.getDeclarationOffTU((IASTName)iASTNode);
        Assert.assertEquals((int)iASTNameArray.length, (int)2);
        Assert.assertEquals((String)iASTNameArray[0].toString(), (String)"f_SD");
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getOffset(), (int)71);
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getLength(), (int)4);
    }

    public void testBug72372_2() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("namespace A {                                   \n");
        ((Writer)stringWriter).write("   namespace B {                                \n");
        ((Writer)stringWriter).write("      void f_SD();                              \n");
        ((Writer)stringWriter).write("   }                                            \n");
        ((Writer)stringWriter).write("}                                               \n");
        ((Writer)stringWriter).write("namespace C {                                   \n");
        ((Writer)stringWriter).write("   using namespace A;                           \n");
        ((Writer)stringWriter).write("}                                               \n");
        ((Writer)stringWriter).write("void C::B::f_SD(){}                             \n");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf(":f_SD");
        IASTNode iASTNode = this.parse(string, n + 1, n + 5);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(((IASTName)iASTNode).resolveBinding() instanceof IFunction));
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"f_SD");
        IASTName[] iASTNameArray = this.getDeclarationOffTU((IASTName)iASTNode);
        Assert.assertEquals((int)iASTNameArray.length, (int)2);
        Assert.assertEquals((String)iASTNameArray[0].toString(), (String)"f_SD");
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getOffset(), (int)109);
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getLength(), (int)4);
    }

    public void testBug72713() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class Deck{ void initialize(); };   \n");
        ((Writer)stringWriter).write("void Deck::initialize(){}           \n");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf(":initialize");
        IASTNode iASTNode = this.parse(string, n + 1, n + 11);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(((IASTName)iASTNode).resolveBinding() instanceof ICPPMethod));
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"initialize");
        IASTName[] iASTNameArray = this.getDeclarationOffTU((IASTName)iASTNode);
        Assert.assertEquals((int)iASTNameArray.length, (int)2);
        Assert.assertEquals((String)iASTNameArray[0].toString(), (String)"initialize");
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getOffset(), (int)17);
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getLength(), (int)10);
    }

    public void testBug72712() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class B{ public: B(); }; void f(){ B* b; b = new B(); }");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf("new B") + 4;
        IASTNode iASTNode = this.parse(string, n, n + 1);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(((IASTName)iASTNode).resolveBinding() instanceof ICPPConstructor));
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"B");
        IASTName[] iASTNameArray = this.getDeclarationOffTU((IASTName)iASTNode);
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((String)iASTNameArray[0].toString(), (String)"B");
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getOffset(), (int)17);
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getLength(), (int)1);
    }

    public void testBug72712_2() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class A {};                                        \n");
        ((Writer)stringWriter).write("class B{ public: B( A* ); };                       \n");
        ((Writer)stringWriter).write("void f(){ B* b; b = new B( (A*)0 ); }              \n");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf("(A*)") + 1;
        IASTNode iASTNode = this.parse(string, n, n + 1);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(((IASTName)iASTNode).resolveBinding() instanceof ICPPClassType));
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"A");
        IASTName[] iASTNameArray = this.getDeclarationOffTU((IASTName)iASTNode);
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((String)iASTNameArray[0].toString(), (String)"A");
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getOffset(), (int)6);
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getLength(), (int)1);
    }

    public void testBug72814() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("namespace N{                                \n");
        ((Writer)stringWriter).write("   template < class T > class AAA { T _t; };\n");
        ((Writer)stringWriter).write("}                                           \n");
        ((Writer)stringWriter).write("N::AAA<int> a;                              \n");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf("AAA<int>");
        IASTNode iASTNode = this.parse(string, n, n + 3);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(((IASTName)iASTNode).resolveBinding() instanceof ICPPClassType));
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"AAA");
        IASTName[] iASTNameArray = this.getDeclarationOffTU((IASTName)iASTNode);
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((String)iASTNameArray[0].toString(), (String)"AAA");
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getOffset(), (int)75);
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getLength(), (int)3);
        iASTNode = this.parse(string, n, n + 8);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(((IASTName)iASTNode).resolveBinding() instanceof ICPPClassType));
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"AAA");
        iASTNameArray = this.getDeclarationOffTU((IASTName)iASTNode);
    }

    public void testBug72710() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class Card{\n");
        ((Writer)stringWriter).write("\tCard( int rank );\n");
        ((Writer)stringWriter).write(" int rank;\n");
        ((Writer)stringWriter).write("};\n");
        ((Writer)stringWriter).write("Card::Card( int rank ) {\n");
        ((Writer)stringWriter).write("this->rank = rank;\n");
        ((Writer)stringWriter).write("}\n");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf("this->rank") + 6;
        IASTNode iASTNode = this.parse(string, n, n + 4);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(((IASTName)iASTNode).resolveBinding() instanceof ICPPField));
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"rank");
        IASTName[] iASTNameArray = this.getDeclarationOffTU((IASTName)iASTNode);
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((String)iASTNameArray[0].toString(), (String)"rank");
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getOffset(), (int)36);
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getLength(), (int)4);
    }

    public void testBug75731() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("int rank() {\n");
        ((Writer)stringWriter).write("return 5;\n}\n");
        ((Writer)stringWriter).write("class Card{\n");
        ((Writer)stringWriter).write("private:\n");
        ((Writer)stringWriter).write("Card( int rank );\n");
        ((Writer)stringWriter).write("int rank;\n");
        ((Writer)stringWriter).write("public:\n");
        ((Writer)stringWriter).write("int getRank();\n};\n");
        ((Writer)stringWriter).write("Card::Card( int rank )\n{\n");
        ((Writer)stringWriter).write("this->rank = ::rank();\n");
        ((Writer)stringWriter).write("this->rank = this->rank;\n");
        ((Writer)stringWriter).write("this->rank = rank;\n");
        ((Writer)stringWriter).write("this->rank = Card::rank;\n");
        ((Writer)stringWriter).write("this->rank = getRank();\n}\n");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf("int rank() {") + 4;
        IASTNode iASTNode = this.parse(string, n, n + 4);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(((IASTName)iASTNode).resolveBinding() instanceof IFunction));
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"rank");
        Assert.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)n);
        IASTName[] iASTNameArray = this.getDeclarationOffTU((IASTName)iASTNode);
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((String)iASTNameArray[0].toString(), (String)"rank");
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getOffset(), (int)4);
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getLength(), (int)4);
        n = string.indexOf("class Card{") + 6;
        iASTNode = this.parse(string, n, n + 4);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(((IASTName)iASTNode).resolveBinding() instanceof ICPPClassType));
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"Card");
        Assert.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)n);
        iASTNameArray = this.getDeclarationOffTU((IASTName)iASTNode);
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((String)iASTNameArray[0].toString(), (String)"Card");
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getOffset(), (int)31);
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getLength(), (int)4);
        n = string.indexOf("Card( int rank );");
        iASTNode = this.parse(string, n, n + 4);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(((IASTName)iASTNode).resolveBinding() instanceof ICPPConstructor));
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"Card");
        Assert.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)n);
        iASTNameArray = this.getDeclarationOffTU((IASTName)iASTNode);
        Assert.assertEquals((int)iASTNameArray.length, (int)2);
        Assert.assertEquals((String)iASTNameArray[0].toString(), (String)"Card");
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getOffset(), (int)46);
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getLength(), (int)4);
        n = string.indexOf("Card( int rank );") + 10;
        iASTNode = this.parse(string, n, n + 4);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(((IASTName)iASTNode).resolveBinding() instanceof IParameter));
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"rank");
        Assert.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)n);
        iASTNameArray = this.getDeclarationOffTU((IASTName)iASTNode);
        Assert.assertEquals((int)iASTNameArray.length, (int)2);
        Assert.assertEquals((String)iASTNameArray[0].toString(), (String)"rank");
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getOffset(), (int)56);
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getLength(), (int)4);
        n = string.indexOf("int rank;") + 4;
        iASTNode = this.parse(string, n, n + 4);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(((IASTName)iASTNode).resolveBinding() instanceof ICPPField));
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"rank");
        Assert.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)n);
        iASTNameArray = this.getDeclarationOffTU((IASTName)iASTNode);
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((String)iASTNameArray[0].toString(), (String)"rank");
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getOffset(), (int)68);
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getLength(), (int)4);
        n = string.indexOf("int getRank();") + 4;
        iASTNode = this.parse(string, n, n + 7);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(((IASTName)iASTNode).resolveBinding() instanceof ICPPMethod));
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"getRank");
        Assert.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)n);
        iASTNameArray = this.getDeclarationOffTU((IASTName)iASTNode);
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((String)iASTNameArray[0].toString(), (String)"getRank");
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getOffset(), (int)86);
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getLength(), (int)7);
        n = string.indexOf("Card::Card( int rank )");
        iASTNode = this.parse(string, n, n + 4);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(((IASTName)iASTNode).resolveBinding() instanceof ICPPClassType));
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"Card");
        Assert.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)n);
        iASTNameArray = this.getDeclarationOffTU((IASTName)iASTNode);
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((String)iASTNameArray[0].toString(), (String)"Card");
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getOffset(), (int)31);
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getLength(), (int)4);
        n = string.indexOf("Card::Card( int rank )") + 6;
        iASTNode = this.parse(string, n, n + 4);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(((IASTName)iASTNode).resolveBinding() instanceof ICPPConstructor));
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"Card");
        Assert.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)n);
        iASTNameArray = this.getDeclarationOffTU((IASTName)iASTNode);
        Assert.assertEquals((int)iASTNameArray.length, (int)2);
        Assert.assertEquals((String)iASTNameArray[0].toString(), (String)"Card");
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getOffset(), (int)46);
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getLength(), (int)4);
        n = string.indexOf("Card::Card( int rank )") + 16;
        iASTNode = this.parse(string, n, n + 4);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(((IASTName)iASTNode).resolveBinding() instanceof IParameter));
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"rank");
        Assert.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)n);
        iASTNameArray = this.getDeclarationOffTU((IASTName)iASTNode);
        Assert.assertEquals((int)iASTNameArray.length, (int)2);
        Assert.assertEquals((String)iASTNameArray[0].toString(), (String)"rank");
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getOffset(), (int)56);
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getLength(), (int)4);
        n = string.indexOf("this->rank = ::rank();") + 6;
        iASTNode = this.parse(string, n, n + 4);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(((IASTName)iASTNode).resolveBinding() instanceof ICPPField));
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"rank");
        Assert.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)n);
        iASTNameArray = this.getDeclarationOffTU((IASTName)iASTNode);
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((String)iASTNameArray[0].toString(), (String)"rank");
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getOffset(), (int)68);
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getLength(), (int)4);
        n = string.indexOf("this->rank = ::rank();") + 15;
        iASTNode = this.parse(string, n, n + 4);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(((IASTName)iASTNode).resolveBinding() instanceof IFunction));
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"rank");
        Assert.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)n);
        iASTNameArray = this.getDeclarationOffTU((IASTName)iASTNode);
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((String)iASTNameArray[0].toString(), (String)"rank");
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getOffset(), (int)4);
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getLength(), (int)4);
        n = string.indexOf("this->rank = this->rank;") + 6;
        iASTNode = this.parse(string, n, n + 4);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(((IASTName)iASTNode).resolveBinding() instanceof ICPPField));
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"rank");
        Assert.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)n);
        iASTNameArray = this.getDeclarationOffTU((IASTName)iASTNode);
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((String)iASTNameArray[0].toString(), (String)"rank");
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getOffset(), (int)68);
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getLength(), (int)4);
        n = string.indexOf("this->rank = this->rank;") + 19;
        iASTNode = this.parse(string, n, n + 4);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(((IASTName)iASTNode).resolveBinding() instanceof ICPPField));
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"rank");
        Assert.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)n);
        iASTNameArray = this.getDeclarationOffTU((IASTName)iASTNode);
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((String)iASTNameArray[0].toString(), (String)"rank");
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getOffset(), (int)68);
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getLength(), (int)4);
        n = string.indexOf("this->rank = rank;") + 6;
        iASTNode = this.parse(string, n, n + 4);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(((IASTName)iASTNode).resolveBinding() instanceof ICPPField));
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"rank");
        Assert.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)n);
        iASTNameArray = this.getDeclarationOffTU((IASTName)iASTNode);
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((String)iASTNameArray[0].toString(), (String)"rank");
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getOffset(), (int)68);
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getLength(), (int)4);
        n = string.indexOf("this->rank = rank;") + 13;
        iASTNode = this.parse(string, n, n + 4);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(((IASTName)iASTNode).resolveBinding() instanceof IParameter));
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"rank");
        Assert.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)n);
        iASTNameArray = this.getDeclarationOffTU((IASTName)iASTNode);
        Assert.assertEquals((int)iASTNameArray.length, (int)2);
        Assert.assertEquals((String)iASTNameArray[0].toString(), (String)"rank");
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getOffset(), (int)56);
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getLength(), (int)4);
        n = string.indexOf("this->rank = Card::rank;") + 6;
        iASTNode = this.parse(string, n, n + 4);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(((IASTName)iASTNode).resolveBinding() instanceof ICPPField));
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"rank");
        Assert.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)n);
        iASTNameArray = this.getDeclarationOffTU((IASTName)iASTNode);
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((String)iASTNameArray[0].toString(), (String)"rank");
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getOffset(), (int)68);
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getLength(), (int)4);
        n = string.indexOf("this->rank = Card::rank;") + 19;
        iASTNode = this.parse(string, n, n + 4);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(((IASTName)iASTNode).resolveBinding() instanceof ICPPField));
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"rank");
        Assert.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)n);
        iASTNameArray = this.getDeclarationOffTU((IASTName)iASTNode);
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((String)iASTNameArray[0].toString(), (String)"rank");
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getOffset(), (int)68);
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getLength(), (int)4);
        n = string.indexOf("this->rank = getRank();") + 6;
        iASTNode = this.parse(string, n, n + 4);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(((IASTName)iASTNode).resolveBinding() instanceof ICPPField));
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"rank");
        Assert.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)n);
        iASTNameArray = this.getDeclarationOffTU((IASTName)iASTNode);
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((String)iASTNameArray[0].toString(), (String)"rank");
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getOffset(), (int)68);
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getLength(), (int)4);
        n = string.indexOf("this->rank = getRank();") + 13;
        iASTNode = this.parse(string, n, n + 7);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(((IASTName)iASTNode).resolveBinding() instanceof ICPPMethod));
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"getRank");
        Assert.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)n);
        iASTNameArray = this.getDeclarationOffTU((IASTName)iASTNode);
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((String)iASTNameArray[0].toString(), (String)"getRank");
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getOffset(), (int)86);
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getLength(), (int)7);
    }

    public void testBug77989() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("namespace N {        /* A */\n");
        ((Writer)stringWriter).write("class C{};\n}\n");
        ((Writer)stringWriter).write("using namespace N;   /* B */\n");
        ((Writer)stringWriter).write("N::C c;              /* C */\n");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf("using namespace N;") + 16;
        IASTNode iASTNode = this.parse(string, n, n + 1);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(((IASTName)iASTNode).resolveBinding() instanceof ICPPNamespace));
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"N");
        Assert.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)n);
        IASTName[] iASTNameArray = this.getDeclarationOffTU((IASTName)iASTNode);
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((String)iASTNameArray[0].toString(), (String)"N");
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getOffset(), (int)10);
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getLength(), (int)1);
    }

    public void testBug78435() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("int itself;          //A\n");
        ((Writer)stringWriter).write("void f(int itself){} //B\n");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf("void f(int itself){}") + 11;
        IASTNode iASTNode = this.parse(string, n, n + 6);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(((IASTName)iASTNode).resolveBinding() instanceof IParameter));
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"itself");
        Assert.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)n);
        IASTName[] iASTNameArray = this.getDeclarationOffTU((IASTName)iASTNode);
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((String)iASTNameArray[0].toString(), (String)"itself");
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getOffset(), (int)36);
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getLength(), (int)6);
    }

    public void testBug78231A() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("struct Base {\n");
        ((Writer)stringWriter).write("int Data; // 1\n");
        ((Writer)stringWriter).write("struct Data; // 2\n};\n");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf("struct Data;") + 7;
        IASTNode iASTNode = this.parse(string, n, n + 4);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(((IASTName)iASTNode).resolveBinding() instanceof ICompositeType));
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"Data");
        Assert.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)n);
        IASTName[] iASTNameArray = this.getDeclarationOffTU((IASTName)iASTNode);
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((String)iASTNameArray[0].toString(), (String)"Data");
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getOffset(), (int)36);
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getLength(), (int)4);
    }

    public void testBug78231B() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("int Data;\n");
        ((Writer)stringWriter).write("struct Base {\n");
        ((Writer)stringWriter).write("int Data; // 1\n");
        ((Writer)stringWriter).write("struct Data; // 2\n};\n");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf("struct Data;") + 7;
        IASTNode iASTNode = this.parse(string, n, n + 4);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(((IASTName)iASTNode).resolveBinding() instanceof ICompositeType));
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"Data");
        Assert.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)n);
    }

    public void testBug64326() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class foo {\n");
        ((Writer)stringWriter).write("public:\n");
        ((Writer)stringWriter).write("foo() {}\n");
        ((Writer)stringWriter).write("int bar;\n");
        ((Writer)stringWriter).write("};\n");
        ((Writer)stringWriter).write("int\n");
        ((Writer)stringWriter).write("main(int argc, char **argv) {\n");
        ((Writer)stringWriter).write("foo* f;\n");
        ((Writer)stringWriter).write("f->bar = 1; // ** (A) **\n");
        ((Writer)stringWriter).write("}\n");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf("f->bar") + 3;
        IASTNode iASTNode = this.parse(string, n, n + 3);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(((IASTName)iASTNode).resolveBinding() instanceof ICPPField));
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"bar");
        IASTName[] iASTNameArray = this.getDeclarationOffTU((IASTName)iASTNode);
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((String)iASTNameArray[0].toString(), (String)"bar");
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getOffset(), (int)33);
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getLength(), (int)3);
    }

    public void testBug92605() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#define UINT32 unsigned int\n");
        ((Writer)stringWriter).write("#define HANDLE unsigned int**\n");
        ((Writer)stringWriter).write("// ...\n");
        ((Writer)stringWriter).write("void foo()\n");
        ((Writer)stringWriter).write("{\n");
        ((Writer)stringWriter).write("UINT32 u;  // line A\n");
        ((Writer)stringWriter).write("HANDLE h;  // line B\n");
        ((Writer)stringWriter).write("}\n");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf("UINT32 u;");
        IASTNode iASTNode = this.parse(string, n, n + 6, true);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(((IASTName)iASTNode).resolveBinding() instanceof IMacroBinding));
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"UINT32");
        IASTName[] iASTNameArray = this.getDeclarationOffTU((IASTName)iASTNode);
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((String)iASTNameArray[0].toString(), (String)"UINT32");
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getOffset(), (int)8);
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getLength(), (int)6);
    }

    public void testBug79877() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("int Func2() {\n");
        ((Writer)stringWriter).write("int i;\n");
        ((Writer)stringWriter).write("i = Func1();\n");
        ((Writer)stringWriter).write("return(0);\n");
        ((Writer)stringWriter).write("}\n");
        String string = ((Object)stringWriter).toString();
        IFile iFile = this.importFile("test1.c", string);
        ((Writer)stringWriter).write("int Func1(void) {\n");
        ((Writer)stringWriter).write("return(10);\n");
        ((Writer)stringWriter).write("}\n");
        this.importFile("test2.c", ((Object)stringWriter).toString());
        int n = string.indexOf("Func1");
        IASTNode iASTNode = this.parse(iFile, n, n + 5, true);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(((IASTName)iASTNode).resolveBinding() instanceof ICExternalBinding));
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"Func1");
        ICElement[] iCElementArray = new ICElement[]{new CProject(null, DOMFileBasePluginTest.project)};
    }

    public void testBug78114() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class Point{\t\t\t//line C\n");
        ((Writer)stringWriter).write("public:\n");
        ((Writer)stringWriter).write("Point(): xCoord(0){}\n");
        ((Writer)stringWriter).write("Point(int x){}\t\t//line B\t\n");
        ((Writer)stringWriter).write("private:\t\n");
        ((Writer)stringWriter).write("int xCoord;\t\n");
        ((Writer)stringWriter).write("};\n");
        ((Writer)stringWriter).write("int main(int argc, char **argv) {\n");
        ((Writer)stringWriter).write("Point &p2 = *(new Point(10));\t// line A\n");
        ((Writer)stringWriter).write("return (0);\n");
        ((Writer)stringWriter).write("}\n");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf("Point(10)");
        IASTNode iASTNode = this.parse(string, n, n + 5, true);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(((IASTName)iASTNode).resolveBinding() instanceof ICPPConstructor));
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"Point");
        IASTName[] iASTNameArray = this.getDeclarationOffTU((IASTName)iASTNode);
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((String)iASTNameArray[0].toString(), (String)"Point");
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getOffset(), (int)53);
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getLength(), (int)5);
    }

    public void testBug73398() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("int joo=4;\n");
        ((Writer)stringWriter).write("#define koo 4\n");
        ((Writer)stringWriter).write("int main(int argc, char **argv) {\n");
        ((Writer)stringWriter).write("return (koo);\n");
        ((Writer)stringWriter).write("}\n");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf("koo);");
        IASTNode iASTNode = this.parse(string, n, n + 3, true);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(((IASTName)iASTNode).resolveBinding() instanceof IMacroBinding));
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"koo");
        IASTName[] iASTNameArray = this.getDeclarationOffTU((IASTName)iASTNode);
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((String)iASTNameArray[0].toString(), (String)"koo");
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getOffset(), (int)19);
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getLength(), (int)3);
    }

    public void testBug() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class Point{\t\n");
        ((Writer)stringWriter).write("public:\n");
        ((Writer)stringWriter).write("Point(): xCoord(0){}\n");
        ((Writer)stringWriter).write(" Point& operator=(const Point &rhs){return *this;}\t// line A\n");
        ((Writer)stringWriter).write("private:\t\t\n");
        ((Writer)stringWriter).write("int xCoord;\t\t\n");
        ((Writer)stringWriter).write("};\n");
        ((Writer)stringWriter).write("static const Point zero;\n");
        ((Writer)stringWriter).write("int main(int argc, char **argv) {\t\n");
        ((Writer)stringWriter).write(" Point *p2 = new Point();\n");
        ((Writer)stringWriter).write("p2->operator=(zero);           // line B\n");
        ((Writer)stringWriter).write("return (0);\t\n");
        ((Writer)stringWriter).write(" }\n");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf("operator=(zero)");
        IASTNode iASTNode = this.parse(string, n, n + 9, true);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(((IASTName)iASTNode).resolveBinding() instanceof ICPPMethod));
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"operator =");
        IASTName[] iASTNameArray = this.getDeclarationOffTU((IASTName)iASTNode);
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((String)iASTNameArray[0].toString(), (String)"operator =");
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getOffset(), (int)51);
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getLength(), (int)9);
    }

    public void testBug80826() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("void swapImpl(int& a, int& b) {/*...*/} // line C\n");
        ((Writer)stringWriter).write("#define swap(a,b) (swapImpl(a,b))   // line B\n");
        ((Writer)stringWriter).write("//\t\t...\n");
        ((Writer)stringWriter).write("void foo(int x, int y)\n");
        ((Writer)stringWriter).write("{\n");
        ((Writer)stringWriter).write("swap(x,y); // line A\n");
        ((Writer)stringWriter).write("\t\t  //...\n");
        ((Writer)stringWriter).write("}\n");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf("swap(x,y);");
        IASTNode iASTNode = this.parse(string, n, n + 4, true);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(((IASTName)iASTNode).resolveBinding() instanceof IMacroBinding));
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"swap");
        IASTName[] iASTNameArray = this.getDeclarationOffTU((IASTName)iASTNode);
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((String)iASTNameArray[0].toString(), (String)"swap");
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getOffset(), (int)58);
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getLength(), (int)4);
    }

    public void testBug78389() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class A{\n");
        ((Writer)stringWriter).write("void method1(){}  //line A\n");
        ((Writer)stringWriter).write("void method1(int i){} //line B\n");
        ((Writer)stringWriter).write("};\n");
        ((Writer)stringWriter).write("void f(){\n");
        ((Writer)stringWriter).write("A a; \n");
        ((Writer)stringWriter).write("a.method1(3); // F3 on method1 in this line should highlight method1 on line B\n");
        ((Writer)stringWriter).write("}\n");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf("method1(3)");
        IASTNode iASTNode = this.parse(string, n, n + 7, true);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(((IASTName)iASTNode).resolveBinding() instanceof ICPPMethod));
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"method1");
        IASTName[] iASTNameArray = this.getDeclarationOffTU((IASTName)iASTNode);
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((String)iASTNameArray[0].toString(), (String)"method1");
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getOffset(), (int)41);
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getLength(), (int)7);
    }

    public void testBug78625() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class A{            \n");
        ((Writer)stringWriter).write("public: A(int i){} \n");
        ((Writer)stringWriter).write("};\n");
        ((Writer)stringWriter).write("class B: A{\n");
        ((Writer)stringWriter).write("B():A(2) {}    //line 5\n");
        ((Writer)stringWriter).write("};\n");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf("A(2)");
        IASTNode iASTNode = this.parse(string, n, n + 1, true);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(((IASTName)iASTNode).resolveBinding() instanceof ICPPConstructor));
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"A");
        IASTName[] iASTNameArray = this.getDeclarationOffTU((IASTName)iASTNode);
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((String)iASTNameArray[0].toString(), (String)"A");
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getOffset(), (int)29);
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getLength(), (int)1);
    }

    public void testBug78656() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class A{\n");
        ((Writer)stringWriter).write("public: int method1(){} //line 2\n");
        ((Writer)stringWriter).write("};\n");
        ((Writer)stringWriter).write("void f() {\n");
        ((Writer)stringWriter).write("A a;\n");
        ((Writer)stringWriter).write("int i=a.method1();  //line 6\n");
        ((Writer)stringWriter).write("}\n");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf("method1();");
        IASTNode iASTNode = this.parse(string, n, n + 7, true);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(((IASTName)iASTNode).resolveBinding() instanceof ICPPMethod));
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"method1");
        IASTName[] iASTNameArray = this.getDeclarationOffTU((IASTName)iASTNode);
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((String)iASTNameArray[0].toString(), (String)"method1");
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getOffset(), (int)21);
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getLength(), (int)7);
    }

    public void testBug79965() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("int i = 2, half_i = i / 2;\n");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf("i / 2");
        IASTNode iASTNode = this.parse(string, n, n + 1, true);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(((IASTName)iASTNode).resolveBinding() instanceof IVariable));
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"i");
        IASTName[] iASTNameArray = this.getDeclarationOffTU((IASTName)iASTNode);
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((String)iASTNameArray[0].toString(), (String)"i");
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getOffset(), (int)4);
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getLength(), (int)1);
    }

    public void testBug64326A() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class foo {\n");
        ((Writer)stringWriter).write("public:\n");
        ((Writer)stringWriter).write("foo() {}\n");
        ((Writer)stringWriter).write("void bar() {}\n");
        ((Writer)stringWriter).write("};\n");
        ((Writer)stringWriter).write("int\n");
        ((Writer)stringWriter).write("main(int argc, char **argv) {\n");
        ((Writer)stringWriter).write("foo* f;\n");
        ((Writer)stringWriter).write("f->bar(); // ** (A) **\n");
        ((Writer)stringWriter).write("}\n");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf("bar();");
        IASTNode iASTNode = this.parse(string, n, n + 3, true);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(((IASTName)iASTNode).resolveBinding() instanceof ICPPMethod));
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"bar");
        IASTName[] iASTNameArray = this.getDeclarationOffTU((IASTName)iASTNode);
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((String)iASTNameArray[0].toString(), (String)"bar");
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getOffset(), (int)34);
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getLength(), (int)3);
    }

    public void testBug64326B() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class foo {\n");
        ((Writer)stringWriter).write("public:\n");
        ((Writer)stringWriter).write("foo() {}\n");
        ((Writer)stringWriter).write("int bar;\n");
        ((Writer)stringWriter).write("};\n");
        ((Writer)stringWriter).write("int \n");
        ((Writer)stringWriter).write("main(int argc, char **argv) {\n");
        ((Writer)stringWriter).write("foo* f;\n");
        ((Writer)stringWriter).write("f->bar = 1; // ** (A) **\n");
        ((Writer)stringWriter).write("}\n");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf("bar = ");
        IASTNode iASTNode = this.parse(string, n, n + 3, true);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(((IASTName)iASTNode).resolveBinding() instanceof ICPPField));
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"bar");
        IASTName[] iASTNameArray = this.getDeclarationOffTU((IASTName)iASTNode);
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((String)iASTNameArray[0].toString(), (String)"bar");
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getOffset(), (int)33);
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getLength(), (int)3);
    }

    public void testBug43128A() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("void foo()\n");
        ((Writer)stringWriter).write("{\n");
        ((Writer)stringWriter).write("int x=3;\n");
        ((Writer)stringWriter).write("\t\t  // ...\n");
        ((Writer)stringWriter).write("x++;\n");
        ((Writer)stringWriter).write("}\n");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf("x++");
        IASTNode iASTNode = this.parse(string, n, n + 1, true);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(((IASTName)iASTNode).resolveBinding() instanceof IVariable));
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"x");
        IASTName[] iASTNameArray = this.getDeclarationOffTU((IASTName)iASTNode);
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((String)iASTNameArray[0].toString(), (String)"x");
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getOffset(), (int)17);
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getLength(), (int)1);
    }

    public void testBug43128B() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("int\n");
        ((Writer)stringWriter).write("main(int argc, char **argv) {\n");
        ((Writer)stringWriter).write("int x = argc;\n");
        ((Writer)stringWriter).write("}\n");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf("argc;");
        IASTNode iASTNode = this.parse(string, n, n + 4, true);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(((IASTName)iASTNode).resolveBinding() instanceof IParameter));
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"argc");
        IASTName[] iASTNameArray = this.getDeclarationOffTU((IASTName)iASTNode);
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((String)iASTNameArray[0].toString(), (String)"argc");
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getOffset(), (int)13);
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getLength(), (int)4);
    }

    public void testBug43128C() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("int j;\n");
        ((Writer)stringWriter).write("int foo(int x) \n");
        ((Writer)stringWriter).write("{\t\n");
        ((Writer)stringWriter).write("int y;\n");
        ((Writer)stringWriter).write("x = 4;\n");
        ((Writer)stringWriter).write("j = 5;\n");
        ((Writer)stringWriter).write("y = 6;\n");
        ((Writer)stringWriter).write("}\n");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf("x =");
        IASTNode iASTNode = this.parse(string, n, n + 1, true);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(((IASTName)iASTNode).resolveBinding() instanceof IVariable));
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"x");
        IASTName[] iASTNameArray = this.getDeclarationOffTU((IASTName)iASTNode);
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((String)iASTNameArray[0].toString(), (String)"x");
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getOffset(), (int)19);
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getLength(), (int)1);
        n = string.indexOf("j =");
        iASTNode = this.parse(string, n, n + 1, true);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(((IASTName)iASTNode).resolveBinding() instanceof IVariable));
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"j");
        iASTNameArray = this.getDeclarationOffTU((IASTName)iASTNode);
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((String)iASTNameArray[0].toString(), (String)"j");
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getOffset(), (int)4);
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getLength(), (int)1);
        n = string.indexOf("y =");
        iASTNode = this.parse(string, n, n + 1, true);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(((IASTName)iASTNode).resolveBinding() instanceof IVariable));
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"y");
        iASTNameArray = this.getDeclarationOffTU((IASTName)iASTNode);
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((String)iASTNameArray[0].toString(), (String)"y");
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getOffset(), (int)30);
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getLength(), (int)1);
    }

    public void testBug86504() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class C { };\n");
        ((Writer)stringWriter).write("void f(int(C)) { } // void f(int (*fp)(C c)) { }\n");
        ((Writer)stringWriter).write("// not: void f(int C);\n");
        ((Writer)stringWriter).write("int g(C);\n");
        ((Writer)stringWriter).write("void foo() {\n");
        ((Writer)stringWriter).write("f(g); // openDeclarations on g causes StackOverflowError\n");
        ((Writer)stringWriter).write("}\n");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf("g); ");
        IASTNode iASTNode = this.parse(string, n, n + 1, true);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(((IASTName)iASTNode).resolveBinding() instanceof ICPPFunction));
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"g");
        IASTName[] iASTNameArray = this.getDeclarationOffTU((IASTName)iASTNode);
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((String)iASTNameArray[0].toString(), (String)"g");
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getOffset(), (int)89);
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getLength(), (int)1);
    }

    public void testBug79811() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("enum E{E0};\n");
        ((Writer)stringWriter).write("void f() {\n");
        ((Writer)stringWriter).write("enum E{E1};\n");
        ((Writer)stringWriter).write("E e;   //this one is incorrectly found\n");
        ((Writer)stringWriter).write("}\n");
        ((Writer)stringWriter).write("E f;   //ok\n");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf("E{E0}");
        IASTNode iASTNode = this.parse(string, n, n + 1, true);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(((IASTName)iASTNode).resolveBinding() instanceof IEnumeration));
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"E");
        IASTName[] iASTNameArray = this.getReferencesOffTU((IASTName)iASTNode);
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((String)iASTNameArray[0].toString(), (String)"E");
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getOffset(), (int)76);
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getLength(), (int)1);
    }

    public void testBugLabelWithMacro() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#define UINT32 unsigned int\n");
        ((Writer)stringWriter).write("#define HANDLE unsigned int**\n");
        ((Writer)stringWriter).write("void foo()\n");
        ((Writer)stringWriter).write("{\n");
        ((Writer)stringWriter).write("UINT32 u;\n");
        ((Writer)stringWriter).write("HANDLE h;\n");
        ((Writer)stringWriter).write("}\n");
        ((Writer)stringWriter).write("int foo2() {\n");
        ((Writer)stringWriter).write("test:\n");
        ((Writer)stringWriter).write("goto test;\n");
        ((Writer)stringWriter).write("return foo();\n");
        ((Writer)stringWriter).write("}\n");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf("HANDLE h");
        IASTNode iASTNode = this.parse(string, n, n + 6, true);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(((IASTName)iASTNode).resolveBinding() instanceof IMacroBinding));
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"HANDLE");
        IASTName[] iASTNameArray = this.getDeclarationOffTU((IASTName)iASTNode);
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((String)iASTNameArray[0].toString(), (String)"HANDLE");
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getOffset(), (int)36);
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getLength(), (int)6);
        n = string.indexOf("test;");
        iASTNode = this.parse(string, n, n + 4, true);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(((IASTName)iASTNode).resolveBinding() instanceof ILabel));
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"test");
        iASTNameArray = this.getDeclarationOffTU((IASTName)iASTNode);
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((String)iASTNameArray[0].toString(), (String)"test");
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getOffset(), (int)132);
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getLength(), (int)4);
    }

    public void testBugMethodDef() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class tetrahedron {\n");
        ((Writer)stringWriter).write("private:\n");
        ((Writer)stringWriter).write("int color;\n");
        ((Writer)stringWriter).write("public:\n");
        ((Writer)stringWriter).write("/* Methods */\n");
        ((Writer)stringWriter).write("void setColor(int c) \n");
        ((Writer)stringWriter).write("{color = c < 0 ? 0 : c;};\n");
        ((Writer)stringWriter).write("void set();\n");
        ((Writer)stringWriter).write("};\n");
        ((Writer)stringWriter).write("void tetrahedron::set() {\n");
        ((Writer)stringWriter).write("int color;\n");
        ((Writer)stringWriter).write("setColor(color);\n");
        ((Writer)stringWriter).write("}\n");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf("setColor(color)");
        IASTNode iASTNode = this.parse(string, n, n + 8, true);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(((IASTName)iASTNode).resolveBinding() instanceof ICPPMethod));
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"setColor");
        IASTName[] iASTNameArray = this.getDeclarationOffTU((IASTName)iASTNode);
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((String)iASTNameArray[0].toString(), (String)"setColor");
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getOffset(), (int)67);
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getLength(), (int)8);
        IASTName[] iASTNameArray2 = this.getReferencesOffTU((IASTName)iASTNode);
        Assert.assertEquals((int)iASTNameArray2.length, (int)1);
        Assert.assertEquals((String)iASTNameArray2[0].toString(), (String)"setColor");
        Assert.assertEquals((int)((ASTNode)iASTNameArray2[0]).getOffset(), (int)162);
        Assert.assertEquals((int)((ASTNode)iASTNameArray2[0]).getLength(), (int)8);
    }

    public void testBug86698A() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("struct C;\n");
        ((Writer)stringWriter).write("void no_opt(C*);\n");
        ((Writer)stringWriter).write("struct C {\n");
        ((Writer)stringWriter).write("int c;\n");
        ((Writer)stringWriter).write("C() : c(0) { no_opt(this); }\n");
        ((Writer)stringWriter).write("};\n");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf("c(0)");
        IASTNode iASTNode = this.parse(string, n, n + 1, true);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(((IASTName)iASTNode).resolveBinding() instanceof IVariable));
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"c");
        IASTName[] iASTNameArray = this.getDeclarationOffTU((IASTName)iASTNode);
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((String)iASTNameArray[0].toString(), (String)"c");
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getOffset(), (int)42);
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getLength(), (int)1);
    }

    public void testBug86698B() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("void foo() {\n");
        ((Writer)stringWriter).write("int f(int);\n");
        ((Writer)stringWriter).write("class C {\n");
        ((Writer)stringWriter).write("int i;\n");
        ((Writer)stringWriter).write("double d;\n");
        ((Writer)stringWriter).write("public:\n");
        ((Writer)stringWriter).write("C(int, double);\n");
        ((Writer)stringWriter).write("};\n");
        ((Writer)stringWriter).write("C::C(int ii, double id)\n");
        ((Writer)stringWriter).write("try\n");
        ((Writer)stringWriter).write(": i(f(ii)), d(id)\n");
        ((Writer)stringWriter).write("{\n");
        ((Writer)stringWriter).write("//\t\t constructor function body\n");
        ((Writer)stringWriter).write("}\n");
        ((Writer)stringWriter).write("catch (...)\n");
        ((Writer)stringWriter).write("{\n");
        ((Writer)stringWriter).write("//\t\t handles exceptions thrown from the ctorinitializer\n");
        ((Writer)stringWriter).write("//\t\t and from the constructor function body\n");
        ((Writer)stringWriter).write("}\n");
        ((Writer)stringWriter).write("}\n");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf("i(f(ii)), d(id)");
        IASTNode iASTNode = this.parse(string, n, n + 1, true);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(((IASTName)iASTNode).resolveBinding() instanceof ICPPField));
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"i");
        IASTName[] iASTNameArray = this.getDeclarationOffTU((IASTName)iASTNode);
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((String)iASTNameArray[0].toString(), (String)"i");
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getOffset(), (int)39);
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getLength(), (int)1);
    }

    public void testBug64181() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("namespace Foo { // ** (A) **\n");
        stringBuffer.append("int bar;\n");
        stringBuffer.append("}\n");
        stringBuffer.append("namespace Foo { // ** (B) **\n");
        stringBuffer.append("long fooboo;\n");
        stringBuffer.append("}\n");
        stringBuffer.append("int \n");
        stringBuffer.append("main(int argc, char **argv) {\n");
        stringBuffer.append("Foo::bar; // ** (C) **\n");
        stringBuffer.append("}\n");
        String string = stringBuffer.toString();
        int n = string.indexOf("Foo::bar;");
        IASTNode iASTNode = this.parse(string, n, n + 3, true);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(((IASTName)iASTNode).resolveBinding() instanceof ICPPNamespace));
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"Foo");
        IASTName[] iASTNameArray = this.getDeclarationOffTU((IASTName)iASTNode);
        Assert.assertEquals((int)iASTNameArray.length, (int)2);
        Assert.assertEquals((String)iASTNameArray[0].toString(), (String)"Foo");
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getOffset(), (int)10);
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getLength(), (int)3);
        Assert.assertEquals((int)((ASTNode)iASTNameArray[1]).getOffset(), (int)50);
        Assert.assertEquals((int)((ASTNode)iASTNameArray[1]).getLength(), (int)3);
    }

    public void testBug80823() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class MyEggImpl {}; // line A\n");
        stringBuffer.append("#define MyChicken MyEggImpl\n");
        stringBuffer.append("MyChicken c; // line C\n");
        String string = stringBuffer.toString();
        int n = string.indexOf("MyChicken c;");
        IASTNode iASTNode = this.parse(string, n, n + 9, true);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(((IASTName)iASTNode).resolveBinding() instanceof IMacroBinding));
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"MyChicken");
        IASTName[] iASTNameArray = this.getDeclarationOffTU((IASTName)iASTNode);
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((String)iASTNameArray[0].toString(), (String)"MyChicken");
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getOffset(), (int)38);
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getLength(), (int)9);
    }

    public void testBug86993() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("#define _BEGIN_STD_C extern \"C\" {\n");
        stringBuffer.append("#define _END_STD_C  }\n");
        stringBuffer.append("_BEGIN_STD_C\n");
        stringBuffer.append("char c; // selection on this fails because offset for \n");
        stringBuffer.append("_END_STD_C\n");
        stringBuffer.append("char foo() {\n");
        stringBuffer.append("return c;   \n");
        stringBuffer.append("}\n");
        String string = stringBuffer.toString();
        int n = string.indexOf("return c;");
        IASTNode iASTNode = this.parse(string, n + 7, n + 8, true);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(((IASTName)iASTNode).resolveBinding() instanceof ICPPVariable));
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"c");
        IASTName[] iASTNameArray = this.getDeclarationOffTU((IASTName)iASTNode);
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((String)iASTNameArray[0].toString(), (String)"c");
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getOffset(), (int)86);
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getLength(), (int)1);
        n = string.indexOf("char c");
        iASTNode = this.parse(string, n + 5, n + 6, true);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(((IASTName)iASTNode).resolveBinding() instanceof ICPPVariable));
        IASTName[] iASTNameArray2 = this.getReferencesOffTU((IASTName)iASTNode);
        Assert.assertEquals((int)iASTNameArray2.length, (int)1);
        Assert.assertEquals((String)iASTNameArray2[0].toString(), (String)"c");
        Assert.assertEquals((int)((ASTNode)iASTNameArray2[0]).getOffset(), (int)168);
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getLength(), (int)1);
    }

    public void testBug92632() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("namespace N{ \n");
        stringBuffer.append("            template < class T > class AAA { T _t; };\n");
        stringBuffer.append("}       \n");
        stringBuffer.append("N::AAA<int> a;  \n");
        String string = stringBuffer.toString();
        int n = string.indexOf("AAA<int>");
        IASTNode iASTNode = this.parse(string, n, n + 8, true);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(((IASTName)iASTNode).resolveBinding() instanceof ICPPTemplateInstance));
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"AAA");
        IASTName[] iASTNameArray = this.getDeclarationOffTU((IASTName)iASTNode);
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertEquals((String)iASTNameArray[0].toString(), (String)"AAA");
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getOffset(), (int)53);
        Assert.assertEquals((int)((ASTNode)iASTNameArray[0]).getLength(), (int)3);
    }
}

