/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.tests.ast2;

import junit.framework.Assert;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.ILabel;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.tests.ast2.AST2BaseTest;

public class GCCTests
extends AST2BaseTest {
    public void testGCC20000113() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct x {                           \n");
        stringBuffer.append("   unsigned x1:1;                    \n");
        stringBuffer.append("   unsigned x2:2;                    \n");
        stringBuffer.append("   unsigned x3:3;                    \n");
        stringBuffer.append("};                                   \n");
        stringBuffer.append("foobar( int x, int y, int z ){       \n");
        stringBuffer.append("   struct x a = {x, y, z};           \n");
        stringBuffer.append("   struct x b = {x, y, z};           \n");
        stringBuffer.append("   struct x *c = &b;                 \n");
        stringBuffer.append("   c->x3 += ( a.x2 - a.x1) * c->x2;  \n");
        stringBuffer.append("   if( a.x1 != 1 || c->x3 != 5 )     \n");
        stringBuffer.append("      return -1;                     \n");
        stringBuffer.append("   return 0;                         \n");
        stringBuffer.append("}                                    \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.C);
        AST2BaseTest.CNameCollector cNameCollector = new AST2BaseTest.CNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cNameCollector);
        Assert.assertEquals((int)cNameCollector.size(), (int)33);
        ICompositeType iCompositeType = (ICompositeType)cNameCollector.getName(0).resolveBinding();
        IField iField = (IField)cNameCollector.getName(1).resolveBinding();
        IField iField2 = (IField)cNameCollector.getName(2).resolveBinding();
        IField iField3 = (IField)cNameCollector.getName(3).resolveBinding();
        IVariable iVariable = (IVariable)cNameCollector.getName(5).resolveBinding();
        IVariable iVariable2 = (IVariable)cNameCollector.getName(6).resolveBinding();
        IVariable iVariable3 = (IVariable)cNameCollector.getName(7).resolveBinding();
        IVariable iVariable4 = (IVariable)cNameCollector.getName(9).resolveBinding();
        IVariable iVariable5 = (IVariable)cNameCollector.getName(14).resolveBinding();
        IVariable iVariable6 = (IVariable)cNameCollector.getName(19).resolveBinding();
        this.assertInstances(cNameCollector, (IBinding)iCompositeType, 4);
        this.assertInstances(cNameCollector, (IBinding)iField, 3);
        this.assertInstances(cNameCollector, (IBinding)iField2, 3);
        this.assertInstances(cNameCollector, (IBinding)iField3, 3);
        this.assertInstances(cNameCollector, (IBinding)iVariable, 3);
        this.assertInstances(cNameCollector, (IBinding)iVariable2, 3);
        this.assertInstances(cNameCollector, (IBinding)iVariable3, 3);
        this.assertInstances(cNameCollector, (IBinding)iVariable4, 4);
        this.assertInstances(cNameCollector, (IBinding)iVariable5, 2);
        this.assertInstances(cNameCollector, (IBinding)iVariable6, 4);
    }

    public void testGCC20000205() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("static int f( int a ) {           \n");
        stringBuffer.append("   if( a == 0 )                   \n");
        stringBuffer.append("      return 0;                   \n");
        stringBuffer.append("   do                             \n");
        stringBuffer.append("      if( a & 128 )               \n");
        stringBuffer.append("         return 1;                \n");
        stringBuffer.append("   while( f(0) );                 \n");
        stringBuffer.append("   return 0;                      \n");
        stringBuffer.append("}                                 \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.C);
        AST2BaseTest.CNameCollector cNameCollector = new AST2BaseTest.CNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cNameCollector);
        Assert.assertEquals((int)cNameCollector.size(), (int)5);
        IFunction iFunction = (IFunction)cNameCollector.getName(0).resolveBinding();
        IVariable iVariable = (IVariable)cNameCollector.getName(1).resolveBinding();
        this.assertInstances(cNameCollector, (IBinding)iFunction, 2);
        this.assertInstances(cNameCollector, (IBinding)iVariable, 3);
    }

    public void testGCC20000217() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("unsigned short int showbug( unsigned short int * a,    \n");
        stringBuffer.append("                            unsigned short int * b ) { \n");
        stringBuffer.append("   *a += *b - 8;                                       \n");
        stringBuffer.append("   return (*a >= 8 );                                  \n");
        stringBuffer.append("}                                                      \n");
        stringBuffer.append("int main(){                                            \n");
        stringBuffer.append("   unsigned short int x = 0;                           \n");
        stringBuffer.append("   unsigned short int y = 10;                          \n");
        stringBuffer.append("   if( showbug( &x, &y ) != 0 )                        \n");
        stringBuffer.append("      return -1;                                       \n");
        stringBuffer.append("   return 0;                                           \n");
        stringBuffer.append("}                                                      \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.C);
        AST2BaseTest.CNameCollector cNameCollector = new AST2BaseTest.CNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cNameCollector);
        Assert.assertEquals((int)cNameCollector.size(), (int)12);
        IFunction iFunction = (IFunction)cNameCollector.getName(0).resolveBinding();
        IVariable iVariable = (IVariable)cNameCollector.getName(1).resolveBinding();
        IVariable iVariable2 = (IVariable)cNameCollector.getName(2).resolveBinding();
        IVariable iVariable3 = (IVariable)cNameCollector.getName(7).resolveBinding();
        IVariable iVariable4 = (IVariable)cNameCollector.getName(8).resolveBinding();
        this.assertInstances(cNameCollector, (IBinding)iFunction, 2);
        this.assertInstances(cNameCollector, (IBinding)iVariable, 3);
        this.assertInstances(cNameCollector, (IBinding)iVariable2, 2);
        this.assertInstances(cNameCollector, (IBinding)iVariable3, 2);
        this.assertInstances(cNameCollector, (IBinding)iVariable4, 2);
    }

    public void testGCC20000224() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int loop_1 = 100;                         \n");
        stringBuffer.append("int loop_2 = 7;                           \n");
        stringBuffer.append("int flag = 0;                             \n");
        stringBuffer.append("int test( void ) {                        \n");
        stringBuffer.append("   int i;                                 \n");
        stringBuffer.append("   int counter = 0;                       \n");
        stringBuffer.append("   while( loop_1 > counter ) {            \n");
        stringBuffer.append("      if( flag & 1 ) {                    \n");
        stringBuffer.append("         for( i = 0; i < loop_2; i++ ) {  \n");
        stringBuffer.append("            counter++;                    \n");
        stringBuffer.append("         }                                \n");
        stringBuffer.append("      }                                   \n");
        stringBuffer.append("      flag++;                             \n");
        stringBuffer.append("   }                                      \n");
        stringBuffer.append("   return 1;                              \n");
        stringBuffer.append("}                                         \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.C);
        AST2BaseTest.CNameCollector cNameCollector = new AST2BaseTest.CNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cNameCollector);
        Assert.assertEquals((int)cNameCollector.size(), (int)16);
        IVariable iVariable = (IVariable)cNameCollector.getName(0).resolveBinding();
        IVariable iVariable2 = (IVariable)cNameCollector.getName(1).resolveBinding();
        IVariable iVariable3 = (IVariable)cNameCollector.getName(2).resolveBinding();
        IVariable iVariable4 = (IVariable)cNameCollector.getName(5).resolveBinding();
        IVariable iVariable5 = (IVariable)cNameCollector.getName(6).resolveBinding();
        this.assertInstances(cNameCollector, (IBinding)iVariable, 2);
        this.assertInstances(cNameCollector, (IBinding)iVariable2, 2);
        this.assertInstances(cNameCollector, (IBinding)iVariable3, 3);
        this.assertInstances(cNameCollector, (IBinding)iVariable4, 4);
        this.assertInstances(cNameCollector, (IBinding)iVariable5, 3);
    }

    public void testGCC20000225() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int main() {                        \n");
        stringBuffer.append("   int nResult, b = 0, i = -1;      \n");
        stringBuffer.append("   do {                             \n");
        stringBuffer.append("      if( b != 0 ) {                \n");
        stringBuffer.append("         nResult = 1;               \n");
        stringBuffer.append("      } else {                      \n");
        stringBuffer.append("         nResult = 0;               \n");
        stringBuffer.append("      }                             \n");
        stringBuffer.append("      i++;                          \n");
        stringBuffer.append("      b = ( i + 2 ) * 4;            \n");
        stringBuffer.append("   } while ( i < 0 );               \n");
        stringBuffer.append("   return -1;                       \n");
        stringBuffer.append("}                                   \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.C);
        AST2BaseTest.CNameCollector cNameCollector = new AST2BaseTest.CNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cNameCollector);
        Assert.assertEquals((int)cNameCollector.size(), (int)11);
        IVariable iVariable = (IVariable)cNameCollector.getName(1).resolveBinding();
        IVariable iVariable2 = (IVariable)cNameCollector.getName(2).resolveBinding();
        IVariable iVariable3 = (IVariable)cNameCollector.getName(3).resolveBinding();
        this.assertInstances(cNameCollector, (IBinding)iVariable, 3);
        this.assertInstances(cNameCollector, (IBinding)iVariable2, 3);
        this.assertInstances(cNameCollector, (IBinding)iVariable3, 4);
    }

    public void testGCC20000227() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("static const unsigned char f[] = \"\\0\\377\";        \n");
        stringBuffer.append("static const unsigned char g[] = \"\\0y\";            \n");
        stringBuffer.append("int main() {                                          \n");
        stringBuffer.append("   if( sizeof f != 3 || sizeof g != 3 )               \n");
        stringBuffer.append("      return -1;                                      \n");
        stringBuffer.append("   if( f[0] != g[0] )                                 \n");
        stringBuffer.append("      return -1;                                      \n");
        stringBuffer.append("   if( f[1] != g[1] || f[2] != g[2] )                 \n");
        stringBuffer.append("      return -1;                                      \n");
        stringBuffer.append("   return 0;                                          \n");
        stringBuffer.append("}                                                     \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.C);
        AST2BaseTest.CNameCollector cNameCollector = new AST2BaseTest.CNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cNameCollector);
        Assert.assertEquals((int)cNameCollector.size(), (int)11);
        IVariable iVariable = (IVariable)cNameCollector.getName(0).resolveBinding();
        IVariable iVariable2 = (IVariable)cNameCollector.getName(1).resolveBinding();
        this.assertInstances(cNameCollector, (IBinding)iVariable, 5);
        this.assertInstances(cNameCollector, (IBinding)iVariable2, 5);
    }

    public void testGCC20000313() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("unsigned int buggy( unsigned int *param ) {           \n");
        stringBuffer.append("   unsigned int accu, zero = 0, borrow;               \n");
        stringBuffer.append("   accu = - *param;                                   \n");
        stringBuffer.append("   borrow = - ( accu > zero );                        \n");
        stringBuffer.append("   return borrow;                                     \n");
        stringBuffer.append("}                                                     \n");
        stringBuffer.append("int main(void){                                       \n");
        stringBuffer.append("   unsigned int param = 1;                            \n");
        stringBuffer.append("   unsigned int borrow = buggy (&param);              \n");
        stringBuffer.append("   if( param != 0 )                                   \n");
        stringBuffer.append("      return -1;                                      \n");
        stringBuffer.append("   if( borrow +1 != 0 )                               \n");
        stringBuffer.append("      return -1;                                      \n");
        stringBuffer.append("   return 0;                                          \n");
        stringBuffer.append("}                                                     \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.C);
        AST2BaseTest.CNameCollector cNameCollector = new AST2BaseTest.CNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cNameCollector);
        Assert.assertEquals((int)cNameCollector.size(), (int)19);
        IFunction iFunction = (IFunction)cNameCollector.getName(0).resolveBinding();
        IParameter iParameter = (IParameter)cNameCollector.getName(1).resolveBinding();
        IVariable iVariable = (IVariable)cNameCollector.getName(2).resolveBinding();
        IVariable iVariable2 = (IVariable)cNameCollector.getName(3).resolveBinding();
        IVariable iVariable3 = (IVariable)cNameCollector.getName(4).resolveBinding();
        IVariable iVariable4 = (IVariable)cNameCollector.getName(13).resolveBinding();
        IVariable iVariable5 = (IVariable)cNameCollector.getName(14).resolveBinding();
        this.assertInstances(cNameCollector, (IBinding)iFunction, 2);
        this.assertInstances(cNameCollector, (IBinding)iParameter, 2);
        this.assertInstances(cNameCollector, (IBinding)iVariable, 3);
        this.assertInstances(cNameCollector, (IBinding)iVariable2, 2);
        this.assertInstances(cNameCollector, (IBinding)iVariable3, 3);
        this.assertInstances(cNameCollector, (IBinding)iVariable4, 3);
        this.assertInstances(cNameCollector, (IBinding)iVariable5, 2);
    }

    public void testGCC20000314_1() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int main() {                                       \n");
        stringBuffer.append("   long winds = 0;                                 \n");
        stringBuffer.append("   while( winds != 0 ) {                           \n");
        stringBuffer.append("      if( *(char*)winds )                          \n");
        stringBuffer.append("         break;                                    \n");
        stringBuffer.append("   }                                               \n");
        stringBuffer.append("   if( winds == 0 || winds != 0 || *(char*)winds ) \n");
        stringBuffer.append("      return 0;                                    \n");
        stringBuffer.append("   return -1;                                      \n");
        stringBuffer.append("}                                                  \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.C);
        AST2BaseTest.CNameCollector cNameCollector = new AST2BaseTest.CNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cNameCollector);
        Assert.assertEquals((int)cNameCollector.size(), (int)7);
        IVariable iVariable = (IVariable)cNameCollector.getName(1).resolveBinding();
        this.assertInstances(cNameCollector, (IBinding)iVariable, 6);
    }

    public void testGCC20000314_2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("typedef unsigned long long uint64;                \n");
        stringBuffer.append("const uint64 bigconst = 1ULL << 34;               \n");
        stringBuffer.append("int a = 1;                                        \n");
        stringBuffer.append("static uint64 getmask(void) {                     \n");
        stringBuffer.append("   if(a)  return bigconst;                        \n");
        stringBuffer.append("   else   return 0;                               \n");
        stringBuffer.append("}                                                 \n");
        stringBuffer.append("main(){                                           \n");
        stringBuffer.append("   uint64 f = getmask();                          \n");
        stringBuffer.append("   if( sizeof (long long) == 8 && f != bigconst ) \n");
        stringBuffer.append("      return -1;                                  \n");
        stringBuffer.append("   return 0;                                      \n");
        stringBuffer.append("}                                                 \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.C);
        AST2BaseTest.CNameCollector cNameCollector = new AST2BaseTest.CNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cNameCollector);
        Assert.assertEquals((int)cNameCollector.size(), (int)15);
        ITypedef iTypedef = (ITypedef)cNameCollector.getName(0).resolveBinding();
        IVariable iVariable = (IVariable)cNameCollector.getName(2).resolveBinding();
        IVariable iVariable2 = (IVariable)cNameCollector.getName(3).resolveBinding();
        IFunction iFunction = (IFunction)cNameCollector.getName(5).resolveBinding();
        IVariable iVariable3 = (IVariable)cNameCollector.getName(11).resolveBinding();
        this.assertInstances(cNameCollector, (IBinding)iTypedef, 4);
        this.assertInstances(cNameCollector, (IBinding)iVariable, 3);
        this.assertInstances(cNameCollector, (IBinding)iVariable2, 2);
        this.assertInstances(cNameCollector, (IBinding)iFunction, 2);
        this.assertInstances(cNameCollector, (IBinding)iVariable3, 2);
    }

    public void testGCC20000403() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("extern unsigned long aa[], bb[];                                     \n");
        stringBuffer.append("int seqgt( unsigned long a, unsigned short win, unsigned long b );   \n");
        stringBuffer.append("int seqgt2 ( unsigned long a, unsigned short win, unsigned long b ); \n");
        stringBuffer.append("main() {                                                             \n");
        stringBuffer.append("   if( !seqgt( *aa, 0x1000, *bb) || !seqgt2( *aa, 0x1000, *bb) )     \n");
        stringBuffer.append("      return -1;                                                     \n");
        stringBuffer.append("   return 0;                                                         \n");
        stringBuffer.append("}                                                                    \n");
        stringBuffer.append("int seqgt( unsigned long a, unsigned short win, unsigned long b) {   \n");
        stringBuffer.append("   return (long) ((a + win) - b) > 0;                                \n");
        stringBuffer.append("}                                                                    \n");
        stringBuffer.append("int seqgt2( unsigned long a, unsigned short win, unsigned long b) {  \n");
        stringBuffer.append("   long l = ((a + win) - b);                                         \n");
        stringBuffer.append("   return 1 > 0;                                                     \n");
        stringBuffer.append("}                                                                    \n");
        stringBuffer.append("unsigned long aa[] = { (1UL << (sizeof(long) *8 - 1)) = 0xfff };     \n");
        stringBuffer.append("unsigned long bb[] = { (1UL << (sizeof(long) *8 - 1)) = 0xfff };     \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.C);
        AST2BaseTest.CNameCollector cNameCollector = new AST2BaseTest.CNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cNameCollector);
        Assert.assertEquals((int)cNameCollector.size(), (int)34);
        IVariable iVariable = (IVariable)cNameCollector.getName(0).resolveBinding();
        IVariable iVariable2 = (IVariable)cNameCollector.getName(1).resolveBinding();
        IFunction iFunction = (IFunction)cNameCollector.getName(2).resolveBinding();
        IParameter iParameter = (IParameter)cNameCollector.getName(3).resolveBinding();
        IParameter iParameter2 = (IParameter)cNameCollector.getName(4).resolveBinding();
        IParameter iParameter3 = (IParameter)cNameCollector.getName(5).resolveBinding();
        IFunction iFunction2 = (IFunction)cNameCollector.getName(6).resolveBinding();
        IParameter iParameter4 = (IParameter)cNameCollector.getName(7).resolveBinding();
        IParameter iParameter5 = (IParameter)cNameCollector.getName(8).resolveBinding();
        IParameter iParameter6 = (IParameter)cNameCollector.getName(9).resolveBinding();
        this.assertInstances(cNameCollector, (IBinding)iVariable, 4);
        this.assertInstances(cNameCollector, (IBinding)iVariable2, 4);
        this.assertInstances(cNameCollector, (IBinding)iFunction, 3);
        this.assertInstances(cNameCollector, (IBinding)iParameter, 3);
        this.assertInstances(cNameCollector, (IBinding)iParameter2, 3);
        this.assertInstances(cNameCollector, (IBinding)iParameter3, 3);
        this.assertInstances(cNameCollector, (IBinding)iFunction2, 3);
        this.assertInstances(cNameCollector, (IBinding)iParameter4, 3);
        this.assertInstances(cNameCollector, (IBinding)iParameter5, 3);
        this.assertInstances(cNameCollector, (IBinding)iParameter6, 3);
    }

    public void testGCC20000412_1() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("short int i = -1;                                               \n");
        stringBuffer.append("const char * const wordlist[207];                               \n");
        stringBuffer.append("const char * const * foo( void ) {                              \n");
        stringBuffer.append("   register const char * const *wordptr = &wordlist[207u + i];  \n");
        stringBuffer.append("   return wordptr;                                              \n");
        stringBuffer.append("}                                                               \n");
        stringBuffer.append("int main() {                                                    \n");
        stringBuffer.append("   if( foo() != &wordlist[206] )                                \n");
        stringBuffer.append("      return -1;                                                \n");
        stringBuffer.append("   return 0;                                                    \n");
        stringBuffer.append("}                                                               \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.C);
        AST2BaseTest.CNameCollector cNameCollector = new AST2BaseTest.CNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cNameCollector);
        Assert.assertEquals((int)cNameCollector.size(), (int)11);
        IVariable iVariable = (IVariable)cNameCollector.getName(0).resolveBinding();
        IVariable iVariable2 = (IVariable)cNameCollector.getName(1).resolveBinding();
        IFunction iFunction = (IFunction)cNameCollector.getName(2).resolveBinding();
        IVariable iVariable3 = (IVariable)cNameCollector.getName(4).resolveBinding();
        this.assertInstances(cNameCollector, (IBinding)iVariable, 2);
        this.assertInstances(cNameCollector, (IBinding)iVariable2, 3);
        this.assertInstances(cNameCollector, (IBinding)iFunction, 2);
        this.assertInstances(cNameCollector, (IBinding)iVariable3, 2);
    }

    public void testGCC20000412_2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int f( int a, int *y ) {                 \n");
        stringBuffer.append("   int x = a;                            \n");
        stringBuffer.append("   if( a == 0 )  return *y;              \n");
        stringBuffer.append("   return f( a-1, &x );                  \n");
        stringBuffer.append("}                                        \n");
        stringBuffer.append("int main( int argc, char** argv){        \n");
        stringBuffer.append("   if( f(100, (int *) 0 ) != 1)          \n");
        stringBuffer.append("      return -1;                         \n");
        stringBuffer.append("   return 0;                             \n");
        stringBuffer.append("}                                        \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.C);
        AST2BaseTest.CNameCollector cNameCollector = new AST2BaseTest.CNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cNameCollector);
        Assert.assertEquals((int)cNameCollector.size(), (int)14);
        IFunction iFunction = (IFunction)cNameCollector.getName(0).resolveBinding();
        IParameter iParameter = (IParameter)cNameCollector.getName(1).resolveBinding();
        IParameter iParameter2 = (IParameter)cNameCollector.getName(2).resolveBinding();
        IVariable iVariable = (IVariable)cNameCollector.getName(3).resolveBinding();
        this.assertInstances(cNameCollector, (IBinding)iFunction, 3);
        this.assertInstances(cNameCollector, (IBinding)iParameter, 4);
        this.assertInstances(cNameCollector, (IBinding)iParameter2, 2);
        this.assertInstances(cNameCollector, (IBinding)iVariable, 2);
    }

    public void testGCC20000412_3() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("typedef struct {                         \n");
        stringBuffer.append("   char y;                               \n");
        stringBuffer.append("   char x[32];                           \n");
        stringBuffer.append("} X;                                     \n");
        stringBuffer.append("int z(void) {                            \n");
        stringBuffer.append("   X xxx;                                \n");
        stringBuffer.append("   xxx.x[0] = xxx.x[31] = '0';           \n");
        stringBuffer.append("   xxx.y = 0xf;                          \n");
        stringBuffer.append("   return f( xxx, xxx );                 \n");
        stringBuffer.append("}                                        \n");
        stringBuffer.append("int main (void) {                        \n");
        stringBuffer.append("   int val;                              \n");
        stringBuffer.append("   val = z();                            \n");
        stringBuffer.append("   if( val != 0x60 ) return -1;          \n");
        stringBuffer.append("   return 0;                             \n");
        stringBuffer.append("}                                        \n");
        stringBuffer.append("int f( X x, X y ) {                      \n");
        stringBuffer.append("   if( x.y != y.y )                      \n");
        stringBuffer.append("      return 'F';                        \n");
        stringBuffer.append("   return x.x[0] + y.x[0];               \n");
        stringBuffer.append("}                                        \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.C);
        AST2BaseTest.CNameCollector cNameCollector = new AST2BaseTest.CNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cNameCollector);
        Assert.assertEquals((int)cNameCollector.size(), (int)36);
        IField iField = (IField)cNameCollector.getName(1).resolveBinding();
        IField iField2 = (IField)cNameCollector.getName(2).resolveBinding();
        ITypedef iTypedef = (ITypedef)cNameCollector.getName(3).resolveBinding();
        IFunction iFunction = (IFunction)cNameCollector.getName(4).resolveBinding();
        IVariable iVariable = (IVariable)cNameCollector.getName(7).resolveBinding();
        IVariable iVariable2 = (IVariable)cNameCollector.getName(19).resolveBinding();
        IParameter iParameter = (IParameter)cNameCollector.getName(25).resolveBinding();
        IParameter iParameter2 = (IParameter)cNameCollector.getName(27).resolveBinding();
        this.assertInstances(cNameCollector, (IBinding)iField, 4);
        this.assertInstances(cNameCollector, (IBinding)iField2, 5);
        this.assertInstances(cNameCollector, (IBinding)iTypedef, 4);
        this.assertInstances(cNameCollector, (IBinding)iFunction, 2);
        this.assertInstances(cNameCollector, (IBinding)iVariable, 6);
        this.assertInstances(cNameCollector, (IBinding)iVariable2, 3);
        this.assertInstances(cNameCollector, (IBinding)iParameter, 3);
        this.assertInstances(cNameCollector, (IBinding)iParameter2, 3);
    }

    public void testGCC20000412_4() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void f(int i, int j, int radius, int width, int N) { \n");
        stringBuffer.append("   const int diff = i - radius;                      \n");
        stringBuffer.append("   const int lowk = (diff > 0 ? diff : 0 );          \n");
        stringBuffer.append("   int k;                                            \n");
        stringBuffer.append("   for( k = lowk; k <= 2; k++ ){                     \n");
        stringBuffer.append("      int idx = ((k-i+radius) * width - j + radius); \n");
        stringBuffer.append("      if( idx < 0 ) return -1;                       \n");
        stringBuffer.append("   }                                                 \n");
        stringBuffer.append("   for( k = lowk; k <= 2; k++ ) ;                    \n");
        stringBuffer.append("}                                                    \n");
        stringBuffer.append("int main (int argc, char** argv ){                   \n");
        stringBuffer.append("   int exc_rad = 2;                                  \n");
        stringBuffer.append("   int N = 8;                                        \n");
        stringBuffer.append("   int i;                                            \n");
        stringBuffer.append("   for( i = 1; i < 4; i++ )                          \n");
        stringBuffer.append("      f( i, 1, exc_rad, 2*exc_rad + 1, N );          \n");
        stringBuffer.append("   return 0;                                         \n");
        stringBuffer.append("}                                                    \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.C);
        AST2BaseTest.CNameCollector cNameCollector = new AST2BaseTest.CNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cNameCollector);
        Assert.assertEquals((int)cNameCollector.size(), (int)43);
        IFunction iFunction = (IFunction)cNameCollector.getName(0).resolveBinding();
        IParameter iParameter = (IParameter)cNameCollector.getName(1).resolveBinding();
        IParameter iParameter2 = (IParameter)cNameCollector.getName(2).resolveBinding();
        IParameter iParameter3 = (IParameter)cNameCollector.getName(3).resolveBinding();
        IParameter iParameter4 = (IParameter)cNameCollector.getName(4).resolveBinding();
        IParameter iParameter5 = (IParameter)cNameCollector.getName(5).resolveBinding();
        IVariable iVariable = (IVariable)cNameCollector.getName(6).resolveBinding();
        IVariable iVariable2 = (IVariable)cNameCollector.getName(9).resolveBinding();
        IVariable iVariable3 = (IVariable)cNameCollector.getName(12).resolveBinding();
        IVariable iVariable4 = (IVariable)cNameCollector.getName(17).resolveBinding();
        IVariable iVariable5 = (IVariable)cNameCollector.getName(32).resolveBinding();
        IVariable iVariable6 = (IVariable)cNameCollector.getName(33).resolveBinding();
        IVariable iVariable7 = (IVariable)cNameCollector.getName(34).resolveBinding();
        this.assertInstances(cNameCollector, (IBinding)iFunction, 2);
        this.assertInstances(cNameCollector, (IBinding)iParameter, 3);
        this.assertInstances(cNameCollector, (IBinding)iParameter2, 2);
        this.assertInstances(cNameCollector, (IBinding)iParameter3, 4);
        this.assertInstances(cNameCollector, (IBinding)iParameter4, 2);
        this.assertInstances(cNameCollector, (IBinding)iParameter5, 1);
        this.assertInstances(cNameCollector, (IBinding)iVariable, 3);
        this.assertInstances(cNameCollector, (IBinding)iVariable2, 3);
        this.assertInstances(cNameCollector, (IBinding)iVariable3, 8);
        this.assertInstances(cNameCollector, (IBinding)iVariable4, 2);
        this.assertInstances(cNameCollector, (IBinding)iVariable5, 3);
        this.assertInstances(cNameCollector, (IBinding)iVariable6, 2);
        this.assertInstances(cNameCollector, (IBinding)iVariable7, 5);
    }

    public void testGCC20000412_5() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int main( void ) {                                      \n");
        stringBuffer.append("   struct {                                             \n");
        stringBuffer.append("      int node;                                         \n");
        stringBuffer.append("      int type;                                         \n");
        stringBuffer.append("   } lastglob[1] = { { 0, 1 } };                        \n");
        stringBuffer.append("   if( lastglob[0].node != 0 || lastglob[0].type != 1 ) \n");
        stringBuffer.append("      return -1;                                        \n");
        stringBuffer.append("   return 0;                                            \n");
        stringBuffer.append("}                                                       \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.C);
        AST2BaseTest.CNameCollector cNameCollector = new AST2BaseTest.CNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cNameCollector);
        Assert.assertEquals((int)cNameCollector.size(), (int)10);
        IField iField = (IField)cNameCollector.getName(3).resolveBinding();
        IField iField2 = (IField)cNameCollector.getName(4).resolveBinding();
        IVariable iVariable = (IVariable)cNameCollector.getName(5).resolveBinding();
        this.assertInstances(cNameCollector, (IBinding)iField, 2);
        this.assertInstances(cNameCollector, (IBinding)iField2, 2);
        this.assertInstances(cNameCollector, (IBinding)iVariable, 3);
    }

    public void testGCC20000419() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct foo { int a, b, c; };                            \n");
        stringBuffer.append("void brother( int a, int b, int c ) {                   \n");
        stringBuffer.append("   if( a ) return;                                      \n");
        stringBuffer.append("}                                                       \n");
        stringBuffer.append("void sister( struct foo f, int b, int c ) {             \n");
        stringBuffer.append("   brother( (f.b == b), b, c );                         \n");
        stringBuffer.append("}                                                       \n");
        stringBuffer.append("int main() {                                            \n");
        stringBuffer.append("   struct foo f = { 7, 8, 9 };                          \n");
        stringBuffer.append("   sister( f, 1, 2 );                                   \n");
        stringBuffer.append("   return 0;                                            \n");
        stringBuffer.append("}                                                       \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.C);
        AST2BaseTest.CNameCollector cNameCollector = new AST2BaseTest.CNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cNameCollector);
        Assert.assertEquals((int)cNameCollector.size(), (int)25);
        ICompositeType iCompositeType = (ICompositeType)cNameCollector.getName(0).resolveBinding();
        IField iField = (IField)cNameCollector.getName(1).resolveBinding();
        IField iField2 = (IField)cNameCollector.getName(2).resolveBinding();
        IField iField3 = (IField)cNameCollector.getName(3).resolveBinding();
        IFunction iFunction = (IFunction)cNameCollector.getName(4).resolveBinding();
        IParameter iParameter = (IParameter)cNameCollector.getName(5).resolveBinding();
        IParameter iParameter2 = (IParameter)cNameCollector.getName(6).resolveBinding();
        IParameter iParameter3 = (IParameter)cNameCollector.getName(7).resolveBinding();
        IFunction iFunction2 = (IFunction)cNameCollector.getName(9).resolveBinding();
        IParameter iParameter4 = (IParameter)cNameCollector.getName(11).resolveBinding();
        IParameter iParameter5 = (IParameter)cNameCollector.getName(12).resolveBinding();
        IParameter iParameter6 = (IParameter)cNameCollector.getName(13).resolveBinding();
        IVariable iVariable = (IVariable)cNameCollector.getName(22).resolveBinding();
        this.assertInstances(cNameCollector, (IBinding)iCompositeType, 3);
        this.assertInstances(cNameCollector, (IBinding)iField, 1);
        this.assertInstances(cNameCollector, (IBinding)iField2, 2);
        this.assertInstances(cNameCollector, (IBinding)iField3, 1);
        this.assertInstances(cNameCollector, (IBinding)iFunction, 2);
        this.assertInstances(cNameCollector, (IBinding)iParameter, 2);
        this.assertInstances(cNameCollector, (IBinding)iParameter2, 1);
        this.assertInstances(cNameCollector, (IBinding)iParameter3, 1);
        this.assertInstances(cNameCollector, (IBinding)iFunction2, 2);
        this.assertInstances(cNameCollector, (IBinding)iParameter4, 2);
        this.assertInstances(cNameCollector, (IBinding)iParameter5, 3);
        this.assertInstances(cNameCollector, (IBinding)iParameter6, 2);
        this.assertInstances(cNameCollector, (IBinding)iVariable, 2);
    }

    public void testGCC20000503() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("unsigned long sub( int a ) {                          \n");
        stringBuffer.append("   return ((0 > a - 2) ? 0 : a - 2) * sizeof(long);   \n");
        stringBuffer.append("}                                                     \n");
        stringBuffer.append("main(){                                               \n");
        stringBuffer.append("   return ( sub(0) != 0 );                            \n");
        stringBuffer.append("}                                                     \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.C);
        AST2BaseTest.CNameCollector cNameCollector = new AST2BaseTest.CNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cNameCollector);
        Assert.assertEquals((int)cNameCollector.size(), (int)6);
        IFunction iFunction = (IFunction)cNameCollector.getName(0).resolveBinding();
        IParameter iParameter = (IParameter)cNameCollector.getName(1).resolveBinding();
        this.assertInstances(cNameCollector, (IBinding)iFunction, 2);
        this.assertInstances(cNameCollector, (IBinding)iParameter, 3);
    }

    public void testGCC20000511() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int  f( int value, int expect ) {                     \n");
        stringBuffer.append("   return ( value == expect );                        \n");
        stringBuffer.append("}                                                     \n");
        stringBuffer.append("main(){                                               \n");
        stringBuffer.append("   int a = 7, b = 6, c = 4, d = 7, e = 2;             \n");
        stringBuffer.append("   f( a || b % c, 1 );                                \n");
        stringBuffer.append("   f( a ? b % c : 0, 2 );                             \n");
        stringBuffer.append("   f( a = b % c, 2);                                  \n");
        stringBuffer.append("   f( a *= b % c, 4 );                                \n");
        stringBuffer.append("   f( a /= b % c, 2 );                                \n");
        stringBuffer.append("   f( a %= b % c, 0 );                                \n");
        stringBuffer.append("   f( a += b % c, 2 );                                \n");
        stringBuffer.append("   f( d || c && e, 1 );                               \n");
        stringBuffer.append("   f( d ? c && e : 0, 1 );                            \n");
        stringBuffer.append("   f( d = c && e, 1 );                                \n");
        stringBuffer.append("   f( d *= c && e, 1 );                               \n");
        stringBuffer.append("   f( d %= c && e, 0);                                \n");
        stringBuffer.append("   f( d += c && e, 1);                                \n");
        stringBuffer.append("   f( d -= c && e, 0);                                \n");
        stringBuffer.append("   f( d || c || e, 1);                                \n");
        stringBuffer.append("   f( d ? c || e : 0, 0);                             \n");
        stringBuffer.append("   f( d = c || e, 1 );                                \n");
        stringBuffer.append("   f( d *= c || e, 1);                                \n");
        stringBuffer.append("   f( d %= c || e, 0);                                \n");
        stringBuffer.append("   f( d += c || e, 1);                                \n");
        stringBuffer.append("   f( d -= c || e, 0 );                               \n");
        stringBuffer.append("}                                                     \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.C);
        AST2BaseTest.CNameCollector cNameCollector = new AST2BaseTest.CNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cNameCollector);
        Assert.assertEquals((int)cNameCollector.size(), (int)95);
        IFunction iFunction = (IFunction)cNameCollector.getName(0).resolveBinding();
        IParameter iParameter = (IParameter)cNameCollector.getName(1).resolveBinding();
        IParameter iParameter2 = (IParameter)cNameCollector.getName(2).resolveBinding();
        IVariable iVariable = (IVariable)cNameCollector.getName(6).resolveBinding();
        IVariable iVariable2 = (IVariable)cNameCollector.getName(7).resolveBinding();
        IVariable iVariable3 = (IVariable)cNameCollector.getName(8).resolveBinding();
        IVariable iVariable4 = (IVariable)cNameCollector.getName(9).resolveBinding();
        IVariable iVariable5 = (IVariable)cNameCollector.getName(10).resolveBinding();
        this.assertInstances(cNameCollector, (IBinding)iFunction, 22);
        this.assertInstances(cNameCollector, (IBinding)iParameter, 2);
        this.assertInstances(cNameCollector, (IBinding)iParameter2, 2);
        this.assertInstances(cNameCollector, (IBinding)iVariable, 8);
        this.assertInstances(cNameCollector, (IBinding)iVariable2, 8);
        this.assertInstances(cNameCollector, (IBinding)iVariable3, 22);
        this.assertInstances(cNameCollector, (IBinding)iVariable4, 15);
        this.assertInstances(cNameCollector, (IBinding)iVariable5, 15);
    }

    public void testGCC20000603() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct s1 { double d; };                                \n");
        stringBuffer.append("struct s2 { double d; };                                \n");
        stringBuffer.append("double f( struct s1 * a, struct s2 *b) {                \n");
        stringBuffer.append("   a->d = 1.0;                                          \n");
        stringBuffer.append("   return b->d + 1.0;                                   \n");
        stringBuffer.append("}                                                       \n");
        stringBuffer.append("int main() {                                            \n");
        stringBuffer.append("   struct s1 a;                                         \n");
        stringBuffer.append("   a.d = 0.0;                                           \n");
        stringBuffer.append("   if( f( &a, (struct s2 *)&a ) != 2.0 )                \n");
        stringBuffer.append("      return -1;                                        \n");
        stringBuffer.append("   return 0;                                            \n");
        stringBuffer.append("}                                                       \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.C);
        AST2BaseTest.CNameCollector cNameCollector = new AST2BaseTest.CNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cNameCollector);
        Assert.assertEquals((int)cNameCollector.size(), (int)22);
        ICompositeType iCompositeType = (ICompositeType)cNameCollector.getName(0).resolveBinding();
        IField iField = (IField)cNameCollector.getName(1).resolveBinding();
        ICompositeType iCompositeType2 = (ICompositeType)cNameCollector.getName(2).resolveBinding();
        IField iField2 = (IField)cNameCollector.getName(3).resolveBinding();
        IFunction iFunction = (IFunction)cNameCollector.getName(4).resolveBinding();
        IParameter iParameter = (IParameter)cNameCollector.getName(6).resolveBinding();
        IParameter iParameter2 = (IParameter)cNameCollector.getName(8).resolveBinding();
        IVariable iVariable = (IVariable)cNameCollector.getName(15).resolveBinding();
        this.assertInstances(cNameCollector, (IBinding)iCompositeType, 3);
        this.assertInstances(cNameCollector, (IBinding)iCompositeType2, 3);
        this.assertInstances(cNameCollector, (IBinding)iField, 3);
        this.assertInstances(cNameCollector, (IBinding)iField2, 2);
        this.assertInstances(cNameCollector, (IBinding)iFunction, 2);
        this.assertInstances(cNameCollector, (IBinding)iParameter, 2);
        this.assertInstances(cNameCollector, (IBinding)iParameter2, 2);
        this.assertInstances(cNameCollector, (IBinding)iVariable, 4);
    }

    public void testGCC20000605_2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct F { int i; };                                    \n");
        stringBuffer.append("void f1( struct F *x, struct F * y ) {                  \n");
        stringBuffer.append("   int timeout = 0;                                     \n");
        stringBuffer.append("   for( ; ((const struct F*)x)->i < y->i; x->i++ )      \n");
        stringBuffer.append("      if( ++timeout > 5 )                               \n");
        stringBuffer.append("         return;                                        \n");
        stringBuffer.append("}                                                       \n");
        stringBuffer.append("main() {                                                \n");
        stringBuffer.append("   struct F x, y;                                       \n");
        stringBuffer.append("   x.i = 0;   y.i = 1;                                  \n");
        stringBuffer.append("   f1( &x, &y );                                        \n");
        stringBuffer.append("}                                                       \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.C);
        AST2BaseTest.CNameCollector cNameCollector = new AST2BaseTest.CNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cNameCollector);
        Assert.assertEquals((int)cNameCollector.size(), (int)27);
        ICompositeType iCompositeType = (ICompositeType)cNameCollector.getName(0).resolveBinding();
        IField iField = (IField)cNameCollector.getName(1).resolveBinding();
        IFunction iFunction = (IFunction)cNameCollector.getName(2).resolveBinding();
        IParameter iParameter = (IParameter)cNameCollector.getName(4).resolveBinding();
        IParameter iParameter2 = (IParameter)cNameCollector.getName(6).resolveBinding();
        IVariable iVariable = (IVariable)cNameCollector.getName(7).resolveBinding();
        IVariable iVariable2 = (IVariable)cNameCollector.getName(18).resolveBinding();
        IVariable iVariable3 = (IVariable)cNameCollector.getName(19).resolveBinding();
        this.assertInstances(cNameCollector, (IBinding)iCompositeType, 5);
        this.assertInstances(cNameCollector, (IBinding)iField, 6);
        this.assertInstances(cNameCollector, (IBinding)iFunction, 2);
        this.assertInstances(cNameCollector, (IBinding)iParameter, 3);
        this.assertInstances(cNameCollector, (IBinding)iParameter2, 2);
        this.assertInstances(cNameCollector, (IBinding)iVariable, 2);
        this.assertInstances(cNameCollector, (IBinding)iVariable2, 3);
        this.assertInstances(cNameCollector, (IBinding)iVariable3, 3);
    }

    public void testGCC20000605_3() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct F { int x; int y; };                             \n");
        stringBuffer.append("int main() {                                            \n");
        stringBuffer.append("   int timeout = 0, x = 0;                              \n");
        stringBuffer.append("   while( 1 ) {                                         \n");
        stringBuffer.append("      const struct F i = { x++, };                      \n");
        stringBuffer.append("      if( i.x > 0 )                                     \n");
        stringBuffer.append("         break;                                         \n");
        stringBuffer.append("      if( ++timeout > 5 )                                \n");
        stringBuffer.append("         goto die;                                      \n");
        stringBuffer.append("   }                                                    \n");
        stringBuffer.append("   die: return 0;                                       \n");
        stringBuffer.append("}                                                       \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.C);
        AST2BaseTest.CNameCollector cNameCollector = new AST2BaseTest.CNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cNameCollector);
        Assert.assertEquals((int)cNameCollector.size(), (int)14);
        ICompositeType iCompositeType = (ICompositeType)cNameCollector.getName(0).resolveBinding();
        IField iField = (IField)cNameCollector.getName(1).resolveBinding();
        IField iField2 = (IField)cNameCollector.getName(2).resolveBinding();
        IVariable iVariable = (IVariable)cNameCollector.getName(4).resolveBinding();
        IVariable iVariable2 = (IVariable)cNameCollector.getName(5).resolveBinding();
        IVariable iVariable3 = (IVariable)cNameCollector.getName(7).resolveBinding();
        ILabel iLabel = (ILabel)cNameCollector.getName(13).resolveBinding();
        this.assertInstances(cNameCollector, (IBinding)iCompositeType, 2);
        this.assertInstances(cNameCollector, (IBinding)iField, 2);
        this.assertInstances(cNameCollector, (IBinding)iField2, 1);
        this.assertInstances(cNameCollector, (IBinding)iVariable, 2);
        this.assertInstances(cNameCollector, (IBinding)iVariable2, 2);
        this.assertInstances(cNameCollector, (IBinding)iVariable3, 2);
        this.assertInstances(cNameCollector, (IBinding)iLabel, 2);
    }

    public void testGCCenum_2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("enum foo { FOO, BAR };                                  \n");
        stringBuffer.append("int main() {                                            \n");
        stringBuffer.append("   int i;                                               \n");
        stringBuffer.append("   for( i = BAR; i >= FOO; --i )                        \n");
        stringBuffer.append("      if( i == -1 ) return -1;                          \n");
        stringBuffer.append("   return 0;                                            \n");
        stringBuffer.append("}                                                       \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.C);
        AST2BaseTest.CNameCollector cNameCollector = new AST2BaseTest.CNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cNameCollector);
        Assert.assertEquals((int)cNameCollector.size(), (int)11);
        IEnumeration iEnumeration = (IEnumeration)cNameCollector.getName(0).resolveBinding();
        IEnumerator iEnumerator = (IEnumerator)cNameCollector.getName(1).resolveBinding();
        IEnumerator iEnumerator2 = (IEnumerator)cNameCollector.getName(2).resolveBinding();
        IVariable iVariable = (IVariable)cNameCollector.getName(4).resolveBinding();
        this.assertInstances(cNameCollector, (IBinding)iEnumeration, 1);
        this.assertInstances(cNameCollector, (IBinding)iEnumerator, 2);
        this.assertInstances(cNameCollector, (IBinding)iEnumerator2, 2);
        this.assertInstances(cNameCollector, (IBinding)iVariable, 5);
    }
}

