/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.tests.prefix;

import junit.framework.Assert;
import org.eclipse.cdt.core.dom.ast.ASTCompletionNode;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.parser.tests.prefix.CompletionTestBase;

public class BasicCompletionTest
extends CompletionTestBase {
    private void testVar(ASTCompletionNode aSTCompletionNode) throws Exception {
        IASTName[] iASTNameArray = aSTCompletionNode.getNames();
        Assert.assertEquals((int)1, (int)iASTNameArray.length);
        IBinding[] iBindingArray = iASTNameArray[0].resolvePrefix();
        Assert.assertEquals((int)1, (int)iBindingArray.length);
        IVariable iVariable = (IVariable)iBindingArray[0];
        Assert.assertEquals((String)"blah", (String)iVariable.getName());
    }

    public void testVar() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int blah = 4;");
        stringBuffer.append("int two = bl");
        this.testVar(this.getGPPCompletionNode(stringBuffer.toString()));
        this.testVar(this.getGCCCompletionNode(stringBuffer.toString()));
    }

    public void testFunction() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void func(int x) { }");
        stringBuffer.append("void func2() { fu");
        ASTCompletionNode aSTCompletionNode = this.getGPPCompletionNode(stringBuffer.toString());
        IASTName[] iASTNameArray = aSTCompletionNode.getNames();
        Assert.assertEquals((int)3, (int)iASTNameArray.length);
        IBinding[] iBindingArray = iASTNameArray[0].resolvePrefix();
        Assert.assertEquals((int)2, (int)iBindingArray.length);
        Assert.assertEquals((String)"func", (String)((IFunction)iBindingArray[0]).getName());
        Assert.assertEquals((String)"func2", (String)((IFunction)iBindingArray[1]).getName());
        Assert.assertNull((Object)iASTNameArray[1].getTranslationUnit());
        iBindingArray = iASTNameArray[2].resolvePrefix();
        Assert.assertEquals((int)0, (int)iBindingArray.length);
        aSTCompletionNode = this.getGCCCompletionNode(stringBuffer.toString());
        iASTNameArray = aSTCompletionNode.getNames();
        Assert.assertEquals((int)2, (int)iASTNameArray.length);
        iBindingArray = this.sortBindings(iASTNameArray[0].resolvePrefix());
        Assert.assertEquals((int)2, (int)iBindingArray.length);
        Assert.assertEquals((String)"func", (String)((IFunction)iBindingArray[0]).getName());
        Assert.assertEquals((String)"func2", (String)((IFunction)iBindingArray[1]).getName());
        iBindingArray = iASTNameArray[1].resolvePrefix();
        Assert.assertEquals((int)0, (int)iBindingArray.length);
    }

    public void testTypedef() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("typedef int blah;");
        stringBuffer.append("bl");
        ASTCompletionNode aSTCompletionNode = this.getGPPCompletionNode(stringBuffer.toString());
        IASTName[] iASTNameArray = aSTCompletionNode.getNames();
        Assert.assertEquals((int)2, (int)iASTNameArray.length);
        Assert.assertNull((Object)iASTNameArray[0].getTranslationUnit());
        IBinding[] iBindingArray = iASTNameArray[1].resolvePrefix();
        Assert.assertEquals((int)1, (int)iBindingArray.length);
        Assert.assertEquals((String)"blah", (String)((ITypedef)iBindingArray[0]).getName());
        aSTCompletionNode = this.getGCCCompletionNode(stringBuffer.toString());
        iASTNameArray = aSTCompletionNode.getNames();
        Assert.assertEquals((int)1, (int)iASTNameArray.length);
        iBindingArray = iASTNameArray[0].resolvePrefix();
        Assert.assertEquals((int)1, (int)iBindingArray.length);
        Assert.assertEquals((String)"blah", (String)((ITypedef)iBindingArray[0]).getName());
    }
}

