/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.tests.scanner2;

import java.io.InputStream;
import java.util.Collections;
import java.util.Iterator;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.ExtendedScannerInfo;
import org.eclipse.cdt.core.parser.IParser;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.NullLogService;
import org.eclipse.cdt.core.parser.ParserFactory;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.ScannerInfo;
import org.eclipse.cdt.core.parser.ast.IASTScope;
import org.eclipse.cdt.core.parser.ast.IASTVariable;
import org.eclipse.cdt.core.parser.tests.CompleteParseBaseTest;
import org.eclipse.cdt.core.parser.tests.CompleteParsePluginTest;
import org.eclipse.cdt.core.parser.tests.FileBasePluginTest;
import org.eclipse.cdt.internal.core.parser.Parser;
import org.eclipse.cdt.internal.core.parser.ParserException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;

public class IncludeTest
extends FileBasePluginTest {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    CompleteParseBaseTest.FullParseCallback c;
    static /* synthetic */ Class class$0;

    public IncludeTest(String string) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.core.parser.tests.scanner2.IncludeTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        super(string, clazz);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.core.parser.tests.scanner2.IncludeTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite testSuite = new TestSuite((Class)clazz);
        testSuite.addTest((Test)new CompleteParsePluginTest("cleanupProject"));
        return testSuite;
    }

    protected IASTScope parse(IFile iFile, ParserLanguage parserLanguage, IScannerInfo iScannerInfo) throws Exception {
        this.c = new CompleteParseBaseTest.FullParseCallback();
        InputStream inputStream = iFile.getContents();
        IParser iParser = ParserFactory.createParser((IScanner)ParserFactory.createScanner((CodeReader)new CodeReader(iFile.getLocation().toOSString(), inputStream), (IScannerInfo)iScannerInfo, (ParserMode)ParserMode.COMPLETE_PARSE, (ParserLanguage)parserLanguage, (ISourceElementRequestor)this.c, (IParserLogService)new NullLogService(), null), (ISourceElementRequestor)this.c, (ParserMode)ParserMode.COMPLETE_PARSE, (ParserLanguage)parserLanguage, null);
        inputStream.close();
        boolean bl = iParser.parse();
        if (!bl) {
            throw new ParserException("FAILURE");
        }
        Assert.assertTrue((boolean)((Parser)iParser).validateCaches());
        return this.c.getCompilationUnit();
    }

    public void testIncludeNext() throws Exception {
        String string = "int zero; \n#include \"foo.h\"";
        String string2 = "int one; \n#include_next <foo.h>";
        String string3 = "int two; \n#include_next \"foo.h\"";
        String string4 = "int three; \n";
        IFile iFile = this.importFile("base.cpp", string);
        this.importFile("foo.h", string2);
        IFolder iFolder = this.importFolder("two");
        IFolder iFolder2 = this.importFolder("three");
        this.importFile("two/foo.h", string3);
        this.importFile("three/foo.h", string4);
        String[] stringArray = new String[]{iFolder.getFullPath().toOSString(), iFolder2.getFullPath().toOSString()};
        ExtendedScannerInfo extendedScannerInfo = new ExtendedScannerInfo(Collections.EMPTY_MAP, stringArray, EMPTY_STRING_ARRAY, stringArray);
        Iterator iterator = this.parse(iFile, ParserLanguage.C, (IScannerInfo)extendedScannerInfo).getDeclarations();
        Assert.assertTrue((boolean)iterator.hasNext());
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        Assert.assertEquals((String)iASTVariable.getName(), (String)"zero");
        Assert.assertTrue((boolean)iterator.hasNext());
        iASTVariable = (IASTVariable)iterator.next();
        Assert.assertEquals((String)iASTVariable.getName(), (String)"one");
        Assert.assertTrue((boolean)iterator.hasNext());
        iASTVariable = (IASTVariable)iterator.next();
        Assert.assertEquals((String)iASTVariable.getName(), (String)"two");
        Assert.assertTrue((boolean)iterator.hasNext());
        iASTVariable = (IASTVariable)iterator.next();
        Assert.assertEquals((String)iASTVariable.getName(), (String)"three");
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    public void testIncludePathOrdering() throws Exception {
        String string = "#include <foo.h>";
        String string2 = "int one;\n";
        String string3 = "int two;\n";
        String string4 = "int three;\n";
        IFile iFile = this.importFile("base.cpp", string);
        this.importFile("foo.h", string2);
        IFolder iFolder = this.importFolder("two");
        IFolder iFolder2 = this.importFolder("three");
        this.importFile("two/foo.h", string3);
        this.importFile("three/foo.h", string4);
        String[] stringArray = new String[]{iFolder.getFullPath().toOSString(), iFolder2.getFullPath().toOSString()};
        ExtendedScannerInfo extendedScannerInfo = new ExtendedScannerInfo(Collections.EMPTY_MAP, stringArray, EMPTY_STRING_ARRAY, stringArray);
        Iterator iterator = this.parse(iFile, ParserLanguage.C, (IScannerInfo)extendedScannerInfo).getDeclarations();
        Assert.assertTrue((boolean)iterator.hasNext());
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        Assert.assertEquals((String)iASTVariable.getName(), (String)"two");
        Assert.assertFalse((boolean)iterator.hasNext());
        stringArray[0] = iFolder2.getFullPath().toOSString();
        stringArray[1] = iFolder.getFullPath().toOSString();
        extendedScannerInfo = new ExtendedScannerInfo(Collections.EMPTY_MAP, stringArray, EMPTY_STRING_ARRAY, stringArray);
        iterator = this.parse(iFile, ParserLanguage.C, (IScannerInfo)extendedScannerInfo).getDeclarations();
        Assert.assertTrue((boolean)iterator.hasNext());
        iASTVariable = (IASTVariable)iterator.next();
        Assert.assertEquals((String)iASTVariable.getName(), (String)"three");
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    public void testBug91086() throws Exception {
        IFile iFile = this.importFile("file.h", "#define FOUND 666\n");
        StringBuffer stringBuffer = new StringBuffer("#include \"");
        stringBuffer.append(iFile.getLocation().toOSString());
        stringBuffer.append("\"\n");
        stringBuffer.append("int var = FOUND;\n");
        IFile iFile2 = this.importFile("code.c", stringBuffer.toString());
        ParserLanguage parserLanguage = ParserLanguage.C;
        while (parserLanguage != null) {
            Iterator iterator = this.parse(iFile2, parserLanguage, (IScannerInfo)new ScannerInfo()).getDeclarations();
            IASTVariable iASTVariable = (IASTVariable)iterator.next();
            Assert.assertEquals((String)iASTVariable.getInitializerClause().getAssigmentExpression().getLiteralString(), (String)"666");
            Assert.assertFalse((boolean)iterator.hasNext());
            Object object = parserLanguage = parserLanguage == ParserLanguage.C ? ParserLanguage.CPP : null;
        }
    }
}

