/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.tests.scanner2;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import org.eclipse.cdt.core.parser.IProblem;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.IToken;
import org.eclipse.cdt.core.parser.NullSourceElementRequestor;
import org.eclipse.cdt.core.parser.ParserFactoryError;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.ast.IASTInclusion;
import org.eclipse.cdt.core.parser.tests.scanner2.BaseScanner2Test;
import org.eclipse.cdt.internal.core.parser.QuickParseCallback;
import org.eclipse.cdt.internal.core.parser.scanner2.FunctionStyleMacro;

public class Scanner2Test
extends BaseScanner2Test {
    public static final int SIZEOF_TRUTHTABLE = 10;

    public void testBug102825_1() throws Exception {
        StringBuffer stringBuffer = new StringBuffer("#define CURLOPTTYPE_OBJECTPOINT   10000\n");
        stringBuffer.append("#define CINIT = CURLOPTTYPE_##OBJECTPOINT + 1\n");
        stringBuffer.append("CINIT\n");
        this.initializeScanner(stringBuffer.toString());
        this.validateToken(38);
        this.validateInteger("10000");
    }

    public void testBug102825_2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer("#define CURLOPTTYPE_OBJECTPOINT   10000\n");
        stringBuffer.append("#define CINIT(name,type,number) = CURLOPTTYPE_##type + number\n");
        stringBuffer.append("CINIT(FILE, OBJECTPOINT, 1)\n");
        this.initializeScanner(stringBuffer.toString());
        this.validateToken(38);
        this.validateInteger("10000");
    }

    public void testBug102825_3() throws Exception {
        StringBuffer stringBuffer = new StringBuffer("#define CURLOPTTYPE_OBJECTPOINT   10000\n");
        stringBuffer.append("#define CINIT(name,type,number) CURLOPT_ ## name = CURLOPTTYPE_\t## type + number\n");
        stringBuffer.append("CINIT(FILE, OBJECTPOINT, 1)\n");
        this.initializeScanner(stringBuffer.toString());
        this.validateIdentifier("CURLOPT_FILE");
        this.validateToken(38);
        this.validateInteger("10000");
    }

    public void testBug102825_4() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("#define glue( a, b ) a ## b\n");
        stringBuffer.append("#define HIGHLOW \"hello\"\n");
        stringBuffer.append("glue( HIGH, LOW )\n");
        this.initializeScanner(stringBuffer.toString());
        Callback callback = new Callback(ParserMode.QUICK_PARSE);
        this.initializeScanner(stringBuffer.toString(), ParserMode.QUICK_PARSE, callback);
        this.validateString("hello");
        Assert.assertEquals((int)callback.problems.size(), (int)0);
    }

    public void testWeirdStrings() throws Exception {
        this.initializeScanner("Living Life L\"LONG\"");
        this.validateIdentifier("Living");
        this.validateIdentifier("Life");
        this.validateString("LONG", true);
        this.validateEOF();
    }

    public void testNumerics() throws Exception {
        this.initializeScanner("3.0 0.9 .5 3. 4E5 2.01E-03 ...");
        this.validateFloatingPointLiteral("3.0");
        this.validateFloatingPointLiteral("0.9");
        this.validateFloatingPointLiteral(".5");
        this.validateFloatingPointLiteral("3.");
        this.validateFloatingPointLiteral("4E5");
        this.validateFloatingPointLiteral("2.01E-03");
        this.validateToken(48);
        this.validateEOF();
    }

    public Scanner2Test(String string) {
        super(string);
    }

    public void testPreprocessorDefines() throws Exception {
        this.initializeScanner("#define SIMPLE_NUMERIC 5\nint x = SIMPLE_NUMERIC");
        this.validateToken(88);
        this.validateDefinition("SIMPLE_NUMERIC", "5");
        this.validateIdentifier("x");
        this.validateToken(38);
        this.validateInteger("5");
        this.validateEOF();
        this.initializeScanner("#define SIMPLE_STRING \"This is a simple string.\"\n\nconst char * myVariable = SIMPLE_STRING;");
        this.validateToken(67);
        this.validateDefinition("SIMPLE_STRING", "\"This is a simple string.\"");
        this.validateToken(64);
        this.validateToken(23);
        this.validateIdentifier("myVariable");
        this.validateToken(38);
        this.validateString("This is a simple string.");
        this.validateToken(5);
        this.validateEOF();
        this.initializeScanner("#define FOOL 5  \n int tryAFOOL = FOOL + FOOL;");
        this.validateToken(88);
        this.validateIdentifier("tryAFOOL");
        this.validateToken(38);
        this.validateInteger("5");
        this.validateToken(16);
        this.validateInteger("5");
        this.validateToken(5);
        this.validateEOF();
        this.initializeScanner("#define FOOL 5  \n int FOOLer = FOOL;");
        this.validateToken(88);
        this.validateIdentifier("FOOLer");
        this.validateToken(38);
        this.validateInteger("5");
        this.validateToken(5);
        this.validateEOF();
        this.initializeScanner("#define _ALPHA (0x0100|_UPPER|_LOWER)");
        this.validateEOF();
        this.validateDefinition("_ALPHA", "(0x0100|_UPPER|_LOWER)");
        this.initializeScanner("#define NO_COMMENT// ignore me");
        this.validateEOF();
        this.validateDefinition("NO_COMMENT", "");
        this.initializeScanner("#define NO_COMMENT/* ignore me*/");
        this.validateEOF();
        this.validateDefinition("NO_COMMENT", "");
        this.initializeScanner("#define ANSWER 42 // i think");
        this.validateEOF();
        this.validateDefinition("ANSWER", "42");
        this.initializeScanner("#define ANSWER 42 /* i think */");
        this.validateEOF();
        this.validateDefinition("ANSWER", "42");
        this.initializeScanner("#define MULTILINE 3 /* comment \n that goes more than one line */");
        this.validateEOF();
        this.validateDefinition("MULTILINE", "3");
        this.initializeScanner("#define MULTICOMMENT X /* comment1 */ + Y /* comment 2 */");
        this.validateEOF();
        this.validateDefinition("MULTICOMMENT", "X  + Y");
        this.initializeScanner("#define SIMPLE_STRING This is a simple string.\n");
        this.validateEOF();
        this.validateDefinition("SIMPLE_STRING", "This is a simple string.");
        this.initializeScanner("#\tdefine SIMPLE_NUMERIC 5\n");
        this.validateEOF();
        this.validateDefinition("SIMPLE_NUMERIC", "5");
        this.initializeScanner("#\tdefine\t\tSIMPLE_NUMERIC   \t5\n");
        this.validateEOF();
        this.validateDefinition("SIMPLE_NUMERIC", "5");
        this.initializeScanner("#define \t\tSIMPLE_STRING \"This \tis a simple     string.\"\n");
        this.validateEOF();
        this.validateDefinition("SIMPLE_STRING", "\"This \tis a simple     string.\"");
        this.initializeScanner("#define SIMPLE_STRING \t  \tThis \tis a simple \tstring.\n");
        this.validateEOF();
        this.validateDefinition("SIMPLE_STRING", "This \tis a simple \tstring.");
        this.initializeScanner("#define FLAKE\n\nFLAKE");
        this.validateEOF();
        this.validateDefinition("FLAKE", "");
        this.initializeScanner("#define SIMPLE_STRING \t  \tThis \tis a simple \tstring.\\\n\t\tContinue please.");
        this.validateEOF();
        this.validateDefinition("SIMPLE_STRING", "This \tis a simple \tstring.\t\tContinue please.");
    }

    public void testBug67834() throws Exception {
        this.initializeScanner("#if ! BAR\nfoo\n#else\nbar\n#endif\n");
        this.validateIdentifier("foo");
        this.validateEOF();
        this.initializeScanner("#if ! (BAR)\nfoo\n#else\nbar\n#endif\n");
        this.validateIdentifier("foo");
        this.validateEOF();
    }

    public void testConcatenation() {
        try {
            this.initializeScanner("#define F1 3\n#define F2 F1##F1\nint x=F2;");
            this.validateToken(88);
            this.validateDefinition("F1", "3");
            this.validateDefinition("F2", "F1##F1");
            this.validateIdentifier("x");
            this.validateToken(38);
            this.validateInteger("33");
            this.validateToken(5);
            this.validateEOF();
            this.initializeScanner("#define PREFIX RT_\n#define RUN PREFIX##Run");
            this.validateEOF();
            this.validateDefinition("PREFIX", "RT_");
            this.validateDefinition("RUN", "PREFIX##Run");
        }
        catch (Exception exception) {
            Assert.fail((String)("Exception thrown " + exception.toString()));
        }
        try {
            this.initializeScanner("#define DECLARE_HANDLE(name) struct name##__ { int unused; }; typedef struct name##__ *name\n DECLARE_HANDLE( joe )");
            this.validateToken(109);
            this.validateIdentifier("joe__");
            this.validateToken(12);
            this.validateToken(88);
            this.validateIdentifier("unused");
            this.validateToken(5);
            this.validateToken(13);
            this.validateToken(5);
            this.validateToken(116);
            this.validateToken(109);
            this.validateIdentifier("joe__");
            this.validateToken(23);
            this.validateIdentifier("joe");
            this.validateEOF();
        }
        catch (Exception exception) {
            Assert.fail((String)("Exception thrown " + exception.toString()));
        }
    }

    public void testSimpleIfdef() {
        try {
            this.initializeScanner("#define SYMBOL 5\n#ifdef SYMBOL\nint counter(SYMBOL);\n#endif");
            this.validateToken(88);
            this.validateIdentifier("counter");
            this.validateToken(8);
            this.validateInteger("5");
            this.validateToken(9);
            this.validateToken(5);
            this.validateEOF();
            this.initializeScanner("#define SYMBOL 5\n#ifndef SYMBOL\nint counter(SYMBOL);\n#endif");
            this.validateEOF();
            this.initializeScanner("#ifndef DEFINED\n#define DEFINED 100\n#endif\nint count = DEFINED;");
            this.validateToken(88);
            this.validateDefinition("DEFINED", "100");
            this.validateIdentifier("count");
            this.validateToken(38);
            this.validateInteger("100");
            this.validateToken(5);
            this.validateEOF();
            this.initializeScanner("#ifndef DEFINED\n#define DEFINED 100\n#endif\nint count = DEFINED;");
            this.addDefinition("DEFINED", "101");
            this.validateDefinition("DEFINED", "101");
            this.validateToken(88);
            this.validateIdentifier("count");
            this.validateToken(38);
            this.validateInteger("101");
            this.validateToken(5);
            this.validateEOF();
            this.initializeScanner("/* NB: This is #if 0'd out */");
            this.validateEOF();
        }
        catch (Exception exception) {
            Assert.fail((String)("Exception thrown " + exception.toString()));
        }
    }

    private void addDefinition(String string, String string2) {
        this.scanner.addDefinition(string.toCharArray(), string2.toCharArray());
    }

    public void testMultipleLines() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#define COMPLEX_MACRO 33 \\\n");
        ((Writer)stringWriter).write("\t+ 44\n\nCOMPLEX_MACRO");
        this.initializeScanner(((Object)stringWriter).toString());
        this.validateInteger("33");
        this.validateToken(16);
        this.validateInteger("44");
    }

    public void testSlightlyComplexIfdefStructure() {
        try {
            this.initializeScanner("#ifndef BASE\n#define BASE 10\n#endif\n#ifndef BASE\n#error BASE is defined\n#endif");
            this.validateEOF();
        }
        catch (Exception exception) {
            Assert.fail((String)("Exception thrown " + exception.toString()));
        }
        try {
            this.initializeScanner("#ifndef ONE\n#define ONE 1\n#ifdef TWO\n#define THREE ONE + TWO\n#endif\n#endif\nint three(THREE);");
            this.validateToken(88);
            this.validateDefinition("ONE", "1");
            this.validateAsUndefined("TWO");
            this.validateAsUndefined("THREE");
            this.validateIdentifier("three");
            this.validateToken(8);
            this.validateIdentifier("THREE");
            this.validateToken(9);
            this.validateToken(5);
            this.validateEOF();
            this.initializeScanner("#ifndef ONE\n#define ONE 1\n#ifdef TWO\n#define THREE ONE + TWO\n#endif\n#endif\nint three(THREE);");
            this.addDefinition("TWO", "2");
            this.validateToken(88);
            this.validateDefinition("ONE", "1");
            this.validateDefinition("TWO", "2");
            this.validateDefinition("THREE", "ONE + TWO");
            this.validateIdentifier("three");
            this.validateToken(8);
            this.validateInteger("1");
            this.validateToken(16);
            this.validateInteger("2");
            this.validateToken(9);
            this.validateToken(5);
            this.validateEOF();
            this.initializeScanner("#ifndef FOO\n#define FOO 4\n#else\n#undef FOO\n#define FOO 6\n#endif");
            this.validateEOF();
            this.validateDefinition("FOO", "4");
            this.initializeScanner("#ifndef FOO\n#define FOO 4\n#else\n#undef FOO\n#define FOO 6\n#endif");
            this.addDefinition("FOO", "2");
            this.validateEOF();
            this.validateDefinition("FOO", "6");
            this.initializeScanner("#ifndef ONE\n#   define ONE 1\n#   ifndef TWO\n#       define TWO ONE + ONE \n#   else\n#       undef TWO\n#       define TWO 2 \n#   endif\n#else\n#   ifndef TWO\n#      define TWO ONE + ONE \n#   else\n#       undef TWO\n#       define TWO 2 \n#   endif\n#endif\n");
            this.validateEOF();
            this.validateDefinition("ONE", "1");
            this.validateDefinition("TWO", "ONE + ONE");
            this.initializeScanner("#ifndef ONE\r\n#   define ONE 1\n#   ifndef TWO\n#       define TWO ONE + ONE \n#   else\n#       undef TWO\n#       define TWO 2 \n#   endif\n#else\n#   ifndef TWO\n#      define TWO ONE + ONE \n#   else\n#       undef TWO\n#       define TWO 2 \n#   endif\n#endif\n");
            this.addDefinition("ONE", "one");
            this.validateEOF();
            this.validateDefinition("ONE", "one");
            this.validateDefinition("TWO", "ONE + ONE");
            this.initializeScanner("#ifndef ONE\n#   define ONE 1\n#   ifndef TWO\n#       define TWO ONE + ONE \n#   else\n#       undef TWO\n#       define TWO 2 \n#   endif\n#else\n#   ifndef TWO\n#      define TWO ONE + ONE \n#   else\n#       undef TWO\n#       define TWO 2 \n#   endif\n#endif\n");
            this.addDefinition("ONE", "one");
            this.addDefinition("TWO", "two");
            this.validateEOF();
            this.validateDefinition("ONE", "one");
            this.validateDefinition("TWO", "2");
            this.initializeScanner("#ifndef ONE\n#   define ONE 1\n#   ifndef TWO\n#       define TWO ONE + ONE \n#   else\n#       undef TWO\n#       define TWO 2 \n#   endif\n#else\n#   ifndef TWO\n#      define TWO ONE + ONE \n#   else\n#       undef TWO\n#       define TWO 2 \n#   endif\n#endif\n");
            this.addDefinition("TWO", "two");
            this.validateEOF();
            this.validateDefinition("ONE", "1");
            this.validateDefinition("TWO", "2");
        }
        catch (Exception exception) {
            Assert.fail((String)("Exception thrown " + exception.toString()));
        }
    }

    public void testIfs() throws Exception {
        try {
            this.initializeScanner("#if 0\n#error NEVER\n#endif\n");
            this.validateEOF();
            this.initializeScanner("#define X 5\n#define Y 7\n#if (X < Y)\n#define Z X + Y\n#endif");
            this.validateEOF();
            this.validateDefinition("X", "5");
            this.validateDefinition("Y", "7");
            this.validateDefinition("Z", "X + Y");
            this.initializeScanner("#if T < 20\n#define Z T + 1\n#endif");
            this.addDefinition("X", "5");
            this.addDefinition("Y", "7");
            this.addDefinition("T", "X + Y");
            this.validateEOF();
            this.validateDefinition("X", "5");
            this.validateDefinition("Y", "7");
            this.validateDefinition("T", "X + Y");
            this.validateDefinition("Z", "T + 1");
        }
        catch (Exception exception) {
            Assert.fail((String)("Exception thrown " + exception.toString()));
        }
        try {
            this.initializeScanner("#if ( 10 / 5 ) != 2\n#error 10/5 seems to not equal 2 anymore\n#endif\n");
            this.validateEOF();
        }
        catch (Exception exception) {
            Assert.fail((String)("Exception thrown " + exception.toString()));
        }
        Callback callback = new Callback(ParserMode.QUICK_PARSE);
        this.initializeScanner("#ifndef FIVE \n#define FIVE 5\n#endif \n#ifndef TEN\n#define TEN 2 * FIVE\n#endif\n#if TEN != 10\n#define MISTAKE 1\n#error Five does not equal 10\n#endif\n", ParserMode.QUICK_PARSE, callback);
        this.addDefinition("FIVE", "55");
        this.validateEOF();
        this.validateDefinition("FIVE", "55");
        this.validateDefinition("TEN", "2 * FIVE");
        this.validateDefinition("MISTAKE", "1");
        Assert.assertFalse((boolean)callback.problems.isEmpty());
        try {
            this.initializeScanner("#if ((( FOUR / TWO ) * THREE )< FIVE )\n#error 6 is not less than 5 \n#endif\n#if ( ( FIVE * ONE ) != (( (FOUR) + ONE ) * ONE ) )\n#error 5 should equal 5\n#endif \n");
            this.addDefinition("ONE", "1");
            this.addDefinition("TWO", "(ONE + ONE)");
            this.addDefinition("THREE", "(TWO + ONE)");
            this.addDefinition("FOUR", "(TWO * TWO)");
            this.addDefinition("FIVE", "(THREE + TWO)");
            this.validateEOF();
            this.validateDefinition("ONE", "1");
            this.validateDefinition("TWO", "(ONE + ONE)");
            this.validateDefinition("THREE", "(TWO + ONE)");
            this.validateDefinition("FOUR", "(TWO * TWO)");
            this.validateDefinition("FIVE", "(THREE + TWO)");
            TruthTable truthTable = new TruthTable(10);
            int n = truthTable.getNumberOfRows();
            TableRow[] tableRowArray = truthTable.rows;
            int n2 = 0;
            while (n2 < n) {
                TableRow tableRow = tableRowArray[n2];
                String string = tableRow.generateCode();
                this.initializeScanner(string);
                this.validateEOF();
                this.validateAllDefinitions(tableRow);
                ++n2;
            }
        }
        catch (Exception exception) {
            Assert.fail((String)("Exception thrown " + exception.toString()));
        }
        this.initializeScanner("#if ! 0\n#error Correct!\n#endif");
        this.validateEOF();
    }

    public void testPreprocessorMacros() {
        try {
            this.initializeScanner("#define GO(x) x+1\nint y(5);\ny = GO(y);");
            this.validateToken(88);
            this.validateIdentifier("y");
            this.validateToken(8);
            this.validateInteger("5");
            this.validateToken(9);
            this.validateToken(5);
            this.validateIdentifier("y");
            this.validateToken(38);
            this.validateIdentifier("y");
            this.validateToken(16);
            this.validateInteger("1");
            this.validateToken(5);
            this.validateEOF();
            this.initializeScanner("#define ONE 1\n#define SUM(a,b,c,d,e,f,g) ( a + b + c + d + e + f + g )\nint daSum = SUM(ONE,3,5,7,9,11,13);");
            this.validateToken(88);
            this.validateIdentifier("daSum");
            this.validateToken(38);
            this.validateToken(8);
            this.validateInteger("1");
            this.validateToken(16);
            this.validateInteger("3");
            this.validateToken(16);
            this.validateInteger("5");
            this.validateToken(16);
            this.validateInteger("7");
            this.validateToken(16);
            this.validateInteger("9");
            this.validateToken(16);
            this.validateInteger("11");
            this.validateToken(16);
            this.validateInteger("13");
            this.validateToken(9);
            this.validateToken(5);
            this.validateEOF();
            this.initializeScanner("#define LOG( format, var1)   printf( format, var1 )\nLOG( \"My name is %s\", \"Bogdan\" );\n");
            this.validateIdentifier("printf");
            this.validateToken(8);
            this.validateString("My name is %s");
            this.validateToken(6);
            this.validateString("Bogdan");
            this.validateToken(9);
            this.validateToken(5);
            this.validateEOF();
            this.initializeScanner("#define INCR( x )   ++x\nint y(2);\nINCR(y);");
            this.validateToken(88);
            this.validateIdentifier("y");
            this.validateToken(8);
            this.validateInteger("2");
            this.validateToken(9);
            this.validateToken(5);
            this.validateToken(15);
            this.validateIdentifier("y");
            this.validateToken(5);
            this.validateEOF();
            this.initializeScanner("#define CHECK_AND_SET( x, y, z )     if( x ) { \\\n y = z; \\\n }\n\nCHECK_AND_SET( 1, balance, 5000 );\nCHECK_AND_SET( confused(), you, dumb );");
            this.validateToken(86);
            this.validateToken(8);
            this.validateInteger("1");
            this.validateToken(9);
            this.validateToken(12);
            this.validateIdentifier("balance");
            this.validateToken(38);
            this.validateInteger("5000");
            this.validateToken(5);
            this.validateToken(13);
            this.validateToken(5);
            this.validateToken(86);
            this.validateToken(8);
            this.validateIdentifier("confused");
            this.validateToken(8);
            this.validateToken(9);
            this.validateToken(9);
            this.validateToken(12);
            this.validateIdentifier("you");
            this.validateToken(38);
            this.validateIdentifier("dumb");
            this.validateToken(5);
            this.validateToken(13);
            this.validateToken(5);
            this.validateEOF();
            this.initializeScanner("#define ON 7\n#if defined(ON)\nint itsOn = ON;\n#endif");
            this.validateToken(88);
            this.validateBalance(1);
            this.validateIdentifier("itsOn");
            this.validateToken(38);
            this.validateInteger("7");
            this.validateToken(5);
            this.validateEOF();
            this.initializeScanner("#if defined( NOTHING ) \nint x = NOTHING;\n#endif");
            this.validateEOF();
        }
        catch (Exception exception) {
            Assert.fail((String)("Exception thrown " + exception.toString()));
        }
    }

    public void testQuickScan() throws Exception {
        this.initializeScanner("#if X + 5 < 7\n  int found = 1;\n#endif", ParserMode.QUICK_PARSE);
        this.validateToken(88);
        this.validateIdentifier("found");
        this.validateToken(38);
        this.validateInteger("1");
        this.validateToken(5);
        this.validateEOF();
        this.initializeScanner("#if 0\n  int error = 666;\n#endif");
        this.validateEOF();
    }

    public void testOtherPreprocessorCommands() throws ParserFactoryError {
        try {
            this.initializeScanner("#\n#\t\n#define MAX_SIZE 1024\n#\n#  ");
            this.validateEOF();
            this.validateDefinition("MAX_SIZE", "1024");
        }
        catch (Exception exception) {
            Assert.fail((String)("Exception thrown " + exception.toString()));
        }
        int n = 0;
        while (n < 4) {
            switch (n) {
                case 0: {
                    this.initializeScanner("#  ape");
                    break;
                }
                case 1: {
                    this.initializeScanner("#  #");
                    break;
                }
                case 2: {
                    this.initializeScanner("#  32");
                    break;
                }
                case 3: {
                    this.initializeScanner("#  defines");
                }
            }
            try {
                this.validateEOF();
            }
            catch (Exception exception) {
                Assert.fail((String)("Exception thrown " + exception.toString()));
            }
            ++n;
        }
    }

    public void validateAllDefinitions(TableRow tableRow) {
        int n = tableRow.selectWinner();
        int n2 = tableRow.getLength();
        int n3 = 0;
        while (n3 <= n2) {
            if (n3 == n) {
                this.validateDefinition(tableRow.symbolName(n3), tableRow.symbolValue(n3));
            } else {
                this.validateAsUndefined(tableRow.symbolName(n3));
            }
            ++n3;
        }
    }

    public void testBug36287() throws Exception {
        this.initializeScanner("X::X( const X & rtg_arg ) : U( rtg_arg ) , Z( rtg_arg.Z ) , er( rtg_arg.er ){}");
        this.validateIdentifier("X");
        this.validateToken(3);
        this.validateIdentifier("X");
        this.validateToken(8);
        this.validateToken(67);
        this.validateIdentifier("X");
        this.validateToken(30);
        this.validateIdentifier("rtg_arg");
        this.validateToken(9);
        this.validateToken(4);
        this.validateIdentifier("U");
        this.validateToken(8);
        this.validateIdentifier("rtg_arg");
        this.validateToken(9);
        this.validateToken(6);
        this.validateIdentifier("Z");
        this.validateToken(8);
        this.validateIdentifier("rtg_arg");
        this.validateToken(50);
        this.validateIdentifier("Z");
        this.validateToken(9);
        this.validateToken(6);
        this.validateIdentifier("er");
        this.validateToken(8);
        this.validateIdentifier("rtg_arg");
        this.validateToken(50);
        this.validateIdentifier("er");
        this.validateToken(9);
        this.validateToken(12);
        this.validateToken(13);
        this.validateEOF();
        this.initializeScanner("foo.*bar");
        this.validateIdentifier("foo");
        this.validateToken(49);
        this.validateIdentifier("bar");
        this.validateEOF();
        this.initializeScanner("foo...bar");
        this.validateIdentifier("foo");
        this.validateToken(48);
        this.validateIdentifier("bar");
        this.validateEOF();
    }

    public void testBug35892() throws Exception {
        this.initializeScanner("'c'");
        this.validateChar('c');
        this.validateEOF();
    }

    public void testBug36045() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('\"');
        stringBuffer.append('\\');
        stringBuffer.append('\"');
        stringBuffer.append('\"');
        stringBuffer.append('\"');
        stringBuffer.append('\\');
        stringBuffer.append('\\');
        stringBuffer.append('\"');
        stringBuffer.append("\n\n");
        this.initializeScanner(stringBuffer.toString());
        this.validateString("\\\"\\\\");
    }

    public void testConditionalWithBraces() throws Exception {
        int n = 0;
        while (n < 4) {
            this.initializeScanner("int foobar(int a) { if(a == 0) {\n#ifdef THIS\n} else {}\n#elif THAT\n} else {}\n#endif\nreturn 0;}");
            switch (n) {
                case 0: {
                    this.addDefinition("THIS", "1");
                    this.addDefinition("THAT", "1");
                    break;
                }
                case 1: {
                    this.addDefinition("THIS", "1");
                    this.addDefinition("THAT", "0");
                    break;
                }
                case 2: {
                    this.addDefinition("THAT", "1");
                    break;
                }
                case 3: {
                    this.addDefinition("THAT", "0");
                }
            }
            this.validateToken(88);
            this.validateIdentifier("foobar");
            this.validateToken(8);
            this.validateToken(88);
            this.validateIdentifier("a");
            this.validateToken(9);
            this.validateToken(12);
            this.validateToken(86);
            this.validateToken(8);
            this.validateIdentifier("a");
            this.validateToken(37);
            this.validateInteger("0");
            this.validateToken(9);
            this.validateToken(12);
            if (n <= 1) {
                this.validateToken(13);
                this.validateToken(76);
                this.validateToken(12);
                this.validateToken(13);
            }
            if (n == 2) {
                this.validateToken(13);
                this.validateToken(76);
                this.validateToken(12);
                this.validateToken(13);
            }
            this.validateToken(103);
            this.validateInteger("0");
            this.validateToken(5);
            this.validateToken(13);
            this.validateEOF();
            ++n;
        }
    }

    public void testNestedRecursiveDefines() throws Exception {
        this.initializeScanner("#define C B A\n#define B C C\n#define A B\nA");
        this.validateIdentifier("B");
        this.validateDefinition("A", "B");
        this.validateDefinition("B", "C C");
        this.validateDefinition("C", "B A");
        this.validateIdentifier("A");
        this.validateIdentifier("B");
        this.validateIdentifier("A");
        this.validateEOF();
    }

    public void testBug36316() throws Exception {
        this.initializeScanner("#define A B->A\nA");
        this.validateIdentifier("B");
        this.validateDefinition("A", "B->A");
        this.validateToken(20);
        this.validateIdentifier("A");
        this.validateEOF();
    }

    public void testBug36434() throws Exception {
        this.initializeScanner("#define X(Y)\nX(55)");
        this.validateEOF();
    }

    public void testBug36047() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("# define MAD_VERSION_STRINGIZE(str)\t#str\n");
        stringWriter.write("# define MAD_VERSION_STRING(num)\tMAD_VERSION_STRINGIZE(num)\n");
        stringWriter.write("# define MAD_VERSION\t\tMAD_VERSION_STRING(MAD_VERSION_MAJOR) \".\" \\\n");
        stringWriter.write("                         MAD_VERSION_STRING(MAD_VERSION_MINOR) \".\" \\\n");
        stringWriter.write("                         MAD_VERSION_STRING(MAD_VERSION_PATCH) \".\" \\\n");
        stringWriter.write("                         MAD_VERSION_STRING(MAD_VERSION_EXTRA)\n");
        stringWriter.write("# define MAD_VERSION_MAJOR 2\n");
        stringWriter.write("# define MAD_VERSION_MINOR 1\n");
        stringWriter.write("# define MAD_VERSION_PATCH 3\n");
        stringWriter.write("# define MAD_VERSION_EXTRA boo\n");
        stringWriter.write("MAD_VERSION\n");
        this.initializeScanner(stringWriter.toString());
        this.validateString("2.1.3.boo");
        this.validateEOF();
    }

    public void testBug36475() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write(" \"A\" \"B\" \"C\" ");
        this.initializeScanner(stringWriter.toString());
        this.validateString("ABC");
        this.validateEOF();
    }

    public void testBug36509() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("#define debug(s, t) printf(\"x\" # s \"= %d, x\" # t \"= %s\", \\\n");
        stringWriter.write("                    x ## s, x ## t) \n");
        stringWriter.write("debug(1, 2);");
        this.initializeScanner(stringWriter.toString());
        this.validateIdentifier("printf");
        this.validateToken(8);
        this.validateString("x1= %d, x2= %s");
        this.validateToken(6);
        this.validateIdentifier("x1");
        this.validateToken(6);
        this.validateIdentifier("x2");
        this.validateToken(9);
        this.validateToken(5);
        this.validateEOF();
    }

    public void testBug36695() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("'\\4'  '\\n'");
        this.initializeScanner(stringWriter.toString());
        this.validateChar("\\4");
        this.validateChar("\\n");
        this.validateEOF();
    }

    public void testBug36521() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("#define str(s)      # s\n");
        stringWriter.write("fputs(str(strncmp(\"abc\\0d\", \"abc\", '\\4')\n");
        stringWriter.write("        == 0), s);\n");
        this.initializeScanner(stringWriter.toString());
        this.validateIdentifier("fputs");
        this.validateToken(8);
        this.validateString("strncmp(\\\"abc\\\\0d\\\", \\\"abc\\\", '\\\\4')         == 0");
        this.validateToken(6);
        this.validateIdentifier("s");
        this.validateToken(9);
        this.validateToken(5);
    }

    public void testBug36770() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("#define A 0\n");
        stringWriter.write("#if ( A == 1 )\n");
        stringWriter.write("#  define foo 1\n");
        stringWriter.write("#else\n");
        stringWriter.write("# define foo 2\n");
        stringWriter.write("#endif\n");
        stringWriter.write("foo\n");
        this.initializeScanner(stringWriter.toString());
        this.validateInteger("2");
        this.validateEOF();
    }

    public void testBug36816() throws Exception {
        Callback callback = new Callback(ParserMode.QUICK_PARSE);
        this.initializeScanner("#include \"foo.h", ParserMode.QUICK_PARSE, callback);
        this.validateEOF();
        callback = new Callback(ParserMode.QUICK_PARSE);
        this.initializeScanner("#include <foo.h", ParserMode.QUICK_PARSE, callback);
        this.validateEOF();
        callback = new Callback(ParserMode.QUICK_PARSE);
        this.initializeScanner("#define FOO(A", ParserMode.QUICK_PARSE, callback);
        this.validateEOF();
        callback = new Callback(ParserMode.QUICK_PARSE);
        this.initializeScanner("#define FOO(A \\ B", ParserMode.QUICK_PARSE, callback);
        this.validateEOF();
    }

    public void testBug36255() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("#if defined ( A ) \n");
        stringWriter.write("   #if defined ( B ) && ( B != 0 ) \n");
        stringWriter.write("      boo\n");
        stringWriter.write("   #endif /*B*/\n");
        stringWriter.write("#endif /*A*/");
        this.initializeScanner(stringWriter.toString());
        this.validateEOF();
    }

    public void testBug37011() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("#define A \"//\"");
        this.initializeScanner(stringWriter.toString());
        this.validateEOF();
        this.validateDefinition("A", "\"//\"");
    }

    public void testOtherPreprocessorDefines() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("#define A a//boo\n");
        stringWriter.write("#define B a /*boo*/ a\n");
        stringWriter.write("#define C a \" //boo \"\n");
        stringWriter.write("#define D a \\\"//boo\n");
        stringWriter.write("#define E a \\n \"\\\"\"\n");
        stringWriter.write("#define F a\\\n b\n");
        stringWriter.write("#define G a '\"'//boo\n");
        stringWriter.write("#define H a '\\'//b'\"/*bo\\o*/\" b\n");
        this.initializeScanner(stringWriter.toString());
        this.validateEOF();
        this.validateDefinition("A", "a");
        this.validateDefinition("B", "a  a");
        this.validateDefinition("C", "a \" //boo \"");
        this.validateDefinition("D", "a \\\"");
        this.validateDefinition("E", "a \\n \"\\\"\"");
        this.validateDefinition("F", "a b");
        this.validateDefinition("G", "a '\"'");
        this.validateDefinition("H", "a '\\'//b'\"/*bo\\o*/\" b");
    }

    public void testBug38065() throws Exception {
        this.initializeScanner("Foo\\\nBar");
        this.validateIdentifier("FooBar");
        this.validateEOF();
    }

    public void testBug36701A() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("#define str(s) # s\n");
        stringWriter.write("str( @ \\n )\n");
        this.initializeScanner(stringWriter.toString());
        this.validateString("@ \\\\n");
        this.validateEOF();
    }

    public void testBug36701B() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("#define str(s) # s\n");
        stringWriter.write("str( @ /*ff*/  \\n  hh  \"aa\"  )\n");
        this.initializeScanner(stringWriter.toString());
        this.validateString("@ /*ff*/  \\\\n  hh  \\\"aa\\\"");
        this.validateEOF();
    }

    public void testBug44305() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("#define WCHAR_MAX 0 \n");
        stringWriter.write("#if WCHAR_MAX <= 0xff\n");
        stringWriter.write("bool\n");
        stringWriter.write("#endif");
        this.initializeScanner(stringWriter.toString());
        this.validateToken(60);
        this.validateEOF();
    }

    public void testBug45287() throws Exception {
        this.initializeScanner("'abcdefg' L'hijklmnop'");
        this.validateChar("abcdefg");
        this.validateWideChar("hijklmnop");
        this.validateEOF();
    }

    public void testBug45476() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("#define X 5\n");
        stringBuffer.append("#if defined X\n");
        stringBuffer.append("#define Y 10\n");
        stringBuffer.append("#endif");
        this.initializeScanner(stringBuffer.toString());
        this.validateEOF();
        this.validateDefinition("Y", "10");
    }

    public void testBug45477() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("#define D\n");
        stringBuffer.append("#define D\n");
        stringBuffer.append("#define sum(x,y) x+y\n");
        stringBuffer.append("#define E 3\n");
        stringBuffer.append("#define E 3\n");
        stringBuffer.append("#define sum(x,y) x+y\n");
        stringBuffer.append("#if defined(D)\n");
        stringBuffer.append("printf\n");
        stringBuffer.append("#endif\n");
        stringBuffer.append("#if defined(sum)\n");
        stringBuffer.append("scanf\n");
        stringBuffer.append("#endif\n");
        stringBuffer.append("#if defined(E)\n");
        stringBuffer.append("sprintf\n");
        stringBuffer.append("#endif\n");
        this.initializeScanner(stringBuffer.toString());
        this.validateIdentifier("printf");
        this.validateIdentifier("scanf");
        this.validateIdentifier("sprintf");
        this.validateEOF();
        int n = 0;
        while (n < 5) {
            stringBuffer = new StringBuffer();
            stringBuffer.append("#define D blah\n");
            switch (n) {
                case 0: {
                    stringBuffer.append("#define D\n");
                    break;
                }
                case 1: {
                    stringBuffer.append("#define D( x ) echo\n");
                    break;
                }
                case 2: {
                    stringBuffer.append("#define D ACDC\n");
                    break;
                }
                case 3: {
                    stringBuffer.append("#define D defined( D )\n");
                    break;
                }
                case 4: {
                    stringBuffer.append("#define D blahh\n");
                }
            }
            this.initializeScanner(stringBuffer.toString());
            this.validateEOF();
            ++n;
        }
        stringBuffer = new StringBuffer();
        stringBuffer.append("#define X 5\n");
        stringBuffer.append("#define Y 7\n");
        stringBuffer.append("#define SUMXY X    _+     Y");
        stringBuffer.append("#define SUMXY   X + Y");
        this.initializeScanner(stringBuffer.toString());
        this.validateEOF();
    }

    public void testBug45551() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("#define stdio someNonExistantIncludeFile\n");
        stringBuffer.append("#include <stdio.h>\n");
        Callback callback = new Callback(ParserMode.QUICK_PARSE);
        this.initializeScanner(stringBuffer.toString(), ParserMode.QUICK_PARSE, callback);
        this.validateEOF();
        Assert.assertEquals((int)callback.problems.size(), (int)0);
        Assert.assertEquals((int)callback.inclusions.size(), (int)1);
        Assert.assertEquals(callback.inclusions.get(0), (Object)"stdio.h");
    }

    public void testBug46402() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("#define X 5\n");
        stringBuffer.append("#if defined( X )\n");
        stringBuffer.append("// blah\n");
        stringBuffer.append("#elif Y > 5 \n");
        stringBuffer.append("// coo\n");
        stringBuffer.append("#endif\n");
        this.initializeScanner(stringBuffer.toString(), ParserMode.COMPLETE_PARSE);
        this.validateEOF();
    }

    public void testBug50821() throws Exception {
        Callback callback = new Callback(ParserMode.QUICK_PARSE);
        this.initializeScanner("'\n\n\n", ParserMode.QUICK_PARSE, callback);
        this.scanner.nextToken();
        Assert.assertEquals((int)callback.problems.size(), (int)1);
    }

    public void test54778() throws Exception {
        this.initializeScanner("#if 1 || 0 < 3 \n printf \n #endif\n");
        this.validateIdentifier("printf");
        this.validateEOF();
        this.initializeScanner("#if !defined FOO || FOO > 3\nprintf\n#endif\n");
        this.validateIdentifier("printf");
        this.validateEOF();
        this.initializeScanner("#if !defined FOO || FOO < 3\nprintf\n#endif\n");
        this.validateIdentifier("printf");
        this.validateEOF();
    }

    public void test68229() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#define COUNT 0     \n");
        ((Writer)stringWriter).write("1                   \n");
        ((Writer)stringWriter).write("#if COUNT           \n");
        ((Writer)stringWriter).write("   2                \n");
        ((Writer)stringWriter).write("#endif              \n");
        ((Writer)stringWriter).write("3                   \n");
        this.initializeScanner(((Object)stringWriter).toString());
        IToken iToken = this.scanner.nextToken();
        IToken iToken2 = this.scanner.nextToken();
        Assert.assertEquals((String)iToken.getImage(), (String)"1");
        Assert.assertEquals((String)iToken2.getImage(), (String)"3");
        Assert.assertEquals((Object)iToken.getNext(), (Object)iToken2);
        this.validateEOF();
        stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#define FOO( x ) x   \n");
        ((Writer)stringWriter).write("1  FOO( 2 )  3       \n");
        this.initializeScanner(((Object)stringWriter).toString());
        iToken = this.scanner.nextToken();
        IToken iToken3 = this.scanner.nextToken();
        iToken2 = this.scanner.nextToken();
        this.validateEOF();
        Assert.assertEquals((String)iToken.getImage(), (String)"1");
        Assert.assertEquals((String)iToken3.getImage(), (String)"2");
        Assert.assertEquals((String)iToken2.getImage(), (String)"3");
        Assert.assertEquals((Object)iToken.getNext(), (Object)iToken3);
    }

    public void testBug56517() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#if 0 \n");
        ((Writer)stringWriter).write("char * x = \"#boo\";\n");
        ((Writer)stringWriter).write("#endif\n");
        this.initializeScanner(((Object)stringWriter).toString());
        this.validateEOF();
    }

    public void testBug36770B() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#define A 0\n");
        ((Writer)stringWriter).write("#if ( A == 1 )\n");
        ((Writer)stringWriter).write("#  define foo\n");
        ((Writer)stringWriter).write("#else\n");
        ((Writer)stringWriter).write("#   define bar\n");
        ((Writer)stringWriter).write("#endif\n");
        this.initializeScanner(((Object)stringWriter).toString(), ParserMode.QUICK_PARSE);
        this.validateEOF();
        this.validateDefinition("A", 0);
        this.validateDefinition("bar", "");
    }

    public void testBug47797() throws Exception {
        this.initializeScanner("\"\\uABCD\" '\\uABCD' \\uABCD_ident \\u001A01BC_ident ident\\U01AF ident\\u01bc00AF");
        this.validateString("\\uABCD");
        this.validateChar("\\uABCD");
        this.validateIdentifier("\\uABCD_ident");
        this.validateIdentifier("\\u001A01BC_ident");
        this.validateIdentifier("ident\\U01AF");
        this.validateIdentifier("ident\\u01bc00AF");
        this.validateEOF();
    }

    public void testBug59768() throws Exception {
        this.initializeScanner("#define A A\nA");
        this.validateIdentifier("A");
        this.validateEOF();
    }

    public void testBug60764() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#define P   a,b\n");
        ((Writer)stringWriter).write("#define M(x) M1(x)\n");
        ((Writer)stringWriter).write("#define M1(x,y) #x  #y\n");
        ((Writer)stringWriter).write("M(P)\n");
        this.initializeScanner(((Object)stringWriter).toString());
        this.validateString("ab");
        this.validateEOF();
    }

    public void testBug62042() throws Exception {
        Callback callback = new Callback(ParserMode.QUICK_PARSE);
        this.initializeScanner("0x", ParserMode.QUICK_PARSE, callback);
        this.validateInteger("0x");
        this.validateEOF();
    }

    public void testBug61968() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("unsigned int ui = 2172748163; //ok \n");
        ((Writer)stringWriter).write("int big = 999999999999999;//ok \n");
        ((Writer)stringWriter).write("void main() { \n");
        ((Writer)stringWriter).write("caller(4);  //ok\n");
        ((Writer)stringWriter).write("caller(2172748163);//causes java.lang.NumberFormatException \n");
        ((Writer)stringWriter).write("caller(999999999999999); //also causes NumberFormatException \n");
        ((Writer)stringWriter).write("}\n");
        Callback callback = new Callback(ParserMode.QUICK_PARSE);
        this.initializeScanner(((Object)stringWriter).toString(), ParserMode.QUICK_PARSE, callback);
        this.fullyTokenize();
        Assert.assertTrue((boolean)callback.problems.isEmpty());
    }

    public void testBug62378() throws Exception {
        this.initializeScanner("\"\\?\\?<\"");
        this.validateString("\\?\\?<");
    }

    public void testBug62384() throws Exception {
        this.initializeScanner("18446744073709551615LL");
        this.validateInteger("18446744073709551615LL");
    }

    public void testBug62390() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#define f(x) x\n");
        ((Writer)stringWriter).write("#if f(\n");
        ((Writer)stringWriter).write("5) == 5\n");
        ((Writer)stringWriter).write("true1\n");
        ((Writer)stringWriter).write("#endif\n");
        ((Writer)stringWriter).write("#if A\n");
        ((Writer)stringWriter).write("#elif f(\n");
        ((Writer)stringWriter).write("5) == 5\n");
        ((Writer)stringWriter).write("true2\n");
        ((Writer)stringWriter).write("#endif\n");
        ((Writer)stringWriter).write("#undef f\n");
        ((Writer)stringWriter).write("#define f(x) \"A0I70_001.h\"\n");
        ((Writer)stringWriter).write("#include f(\n");
        ((Writer)stringWriter).write("5\n");
        ((Writer)stringWriter).write(")\n");
        ((Writer)stringWriter).write("#undef f\n");
        ((Writer)stringWriter).write("#define f(x) 1467\n");
        ((Writer)stringWriter).write("#line f(\n");
        ((Writer)stringWriter).write("5\n");
        ((Writer)stringWriter).write(")\n");
        ((Writer)stringWriter).write("#pragma f(\n");
        ((Writer)stringWriter).write("5\n");
        ((Writer)stringWriter).write(")\n");
        ((Writer)stringWriter).write("}\n");
        Callback callback = new Callback(ParserMode.QUICK_PARSE);
        this.initializeScanner(((Object)stringWriter).toString(), ParserMode.QUICK_PARSE, callback);
        this.fullyTokenize();
    }

    public void testBug62009() throws Exception {
        Callback callback = new Callback(ParserMode.QUICK_PARSE);
        this.initializeScanner("#define def(x) (x#)\ndef(orange)\n", ParserMode.QUICK_PARSE, callback);
        this.fullyTokenize();
        Assert.assertFalse((boolean)callback.problems.isEmpty());
    }

    public void testBug61972() throws Exception {
        this.initializeScanner("#define DEF1(A1) A1\n#define DEF2     DEF1(DEF2)\nDEF2;");
        this.validateIdentifier("DEF2");
        this.validateToken(5);
        this.validateEOF();
    }

    public void testBug64268() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#define BODY \\\n");
        ((Writer)stringWriter).write(" {\t \\\n");
        ((Writer)stringWriter).write(" /* this multi-line comment messes \\\n");
        ((Writer)stringWriter).write(" up the parser.  */ }\n");
        ((Writer)stringWriter).write("BODY ");
        this.initializeScanner(((Object)stringWriter).toString());
        this.validateToken(12);
        this.validateToken(13);
        this.validateEOF();
    }

    public void testUndef() throws Exception {
        this.initializeScanner("#define A 5\n#define B 10\n#undef A\nA B");
        this.validateIdentifier("A");
        this.validateInteger("10");
        this.validateEOF();
    }

    public void testWackyFunctionMacros() throws Exception {
        this.initializeScanner("#define A(X) hi##X\n#define B(Y) A(Y)\nB(there)");
        this.validateIdentifier("hithere");
        this.validateEOF();
    }

    public void testSlashes() throws Exception {
        this.initializeScanner("__q / __n");
        this.validateIdentifier("__q");
        this.validateToken(52);
        this.validateIdentifier("__n");
        this.validateEOF();
    }

    public void testStringify() throws Exception {
        this.initializeScanner("#define xS(s) #s\n#define S(s) xS(s)\n#define X hi\nS(X)");
        this.validateString("hi");
        this.validateEOF();
    }

    public void testWideToNarrowConcatenation() throws Exception {
        this.initializeScanner("\"ONE\" L\"TWO\"");
        this.validateString("ONETWO", true);
        this.validateEOF();
    }

    public void testEmptyIncludeDirective() throws Exception {
        QuickParseCallback quickParseCallback = new QuickParseCallback();
        this.initializeScanner("#include \n#include <foo.h>\n", ParserMode.QUICK_PARSE, (ISourceElementRequestor)quickParseCallback);
        this.validateEOF();
        Iterator iterator = quickParseCallback.getInclusions();
        Assert.assertTrue((boolean)iterator.hasNext());
        IASTInclusion iASTInclusion = (IASTInclusion)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((String)iASTInclusion.getName(), (String)"foo.h");
    }

    public void testBug69412() throws Exception {
        Callback callback = new Callback(ParserMode.COMPLETE_PARSE);
        this.initializeScanner("'\\\\'", ParserMode.COMPLETE_PARSE, callback);
        this.validateChar("\\\\");
        this.validateEOF();
        Assert.assertTrue((boolean)callback.problems.isEmpty());
    }

    public void testBug70072() throws Exception {
        this.initializeScanner("#if 1/0\nint i;\n#elif 2/0\nint j;\n#endif\nint k;\n");
        this.fullyTokenize();
    }

    public void testBug70261() throws Exception {
        this.initializeScanner("0X0");
        this.validateInteger("0X0");
    }

    public void testBug62571() throws Exception {
        StringBuffer stringBuffer = new StringBuffer("#define J(X,Y) X##Y\n");
        stringBuffer.append("J(A,1Xxyz)\n");
        stringBuffer.append("J(B,1X1X1Xxyz)\n");
        stringBuffer.append("J(C,0Xxyz)\n");
        stringBuffer.append("J(CC,0Xxyz)\n");
        stringBuffer.append("J(D,0xxyz)\n");
        stringBuffer.append("J(E,0x0x0xxyz)\n");
        this.initializeScanner(stringBuffer.toString());
        this.validateIdentifier("A1Xxyz");
        this.validateIdentifier("B1X1X1Xxyz");
        this.validateIdentifier("C0Xxyz");
        this.validateIdentifier("CC0Xxyz");
        this.validateIdentifier("D0xxyz");
        this.validateIdentifier("E0x0x0xxyz");
    }

    public void testBug69134() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("# ifdef YYDEBUG\n");
        ((Writer)stringWriter).write("if (yyDebug) {\n");
        ((Writer)stringWriter).write("(void) fprintf (yyTrace,\n");
        ((Writer)stringWriter).write("\"  # |Position|State|Mod|Lev|Action |Terminal and Lookahead or Rule\n\");\n");
        ((Writer)stringWriter).write("yyNl ();\n");
        ((Writer)stringWriter).write("}\n");
        ((Writer)stringWriter).write("# endif\n");
        Callback callback = new Callback(ParserMode.COMPLETE_PARSE);
        this.initializeScanner(((Object)stringWriter).toString(), ParserMode.COMPLETE_PARSE, callback);
        this.fullyTokenize();
        Assert.assertTrue((boolean)callback.problems.isEmpty());
    }

    public void testBug70073() throws Exception {
        StringBuffer stringBuffer = new StringBuffer("#if CONST \n #endif \n #elif CONST \n int");
        final ArrayList arrayList = new ArrayList();
        NullSourceElementRequestor nullSourceElementRequestor = new NullSourceElementRequestor(){

            public boolean acceptProblem(IProblem iProblem) {
                arrayList.add(iProblem);
                return super.acceptProblem(iProblem);
            }
        };
        this.initializeScanner(stringBuffer.toString(), ParserMode.COMPLETE_PARSE, (ISourceElementRequestor)nullSourceElementRequestor);
        this.validateToken(88);
        Assert.assertEquals((int)arrayList.size(), (int)1);
    }

    public void testBug73652() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("#define DoSuperMethodA IDoSuperMethodA\n");
        stringWriter.write("#define IDoSuperMethodA(a,b,c) IIntuition->IDoSuperMethodA(a,b,c)\n");
        stringWriter.write("DoSuperMethodA(0,0,0);\n");
        this.initializeScanner(stringWriter.toString());
        this.validateIdentifier("IIntuition");
        this.validateToken(20);
        this.validateIdentifier("IDoSuperMethodA");
        this.validateToken(8);
        this.validateInteger("0");
        this.validateToken(6);
        this.validateInteger("0");
        this.validateToken(6);
        this.validateInteger("0");
        this.validateToken(9);
        this.validateToken(5);
        this.validateEOF();
    }

    public void testBug73652_2() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("#define DoSuperMethodA DoSuperMethodB //doobalie\n");
        stringWriter.write("#define DoSuperMethodB DoSuperMethodC /*oogalie*/ \n");
        stringWriter.write("#define DoSuperMethodC IDoSuperMethodA \\\n\n");
        stringWriter.write("#define IDoSuperMethodA(a,b,c) IIntuition->IDoSuperMethodA(a,b,c)\n");
        stringWriter.write("DoSuperMethodA  (0,0,0);\n");
        this.initializeScanner(stringWriter.toString());
        this.validateIdentifier("IIntuition");
        this.validateToken(20);
        this.validateIdentifier("IDoSuperMethodA");
        this.validateToken(8);
        this.validateInteger("0");
        this.validateToken(6);
        this.validateInteger("0");
        this.validateToken(6);
        this.validateInteger("0");
        this.validateToken(9);
        this.validateToken(5);
        this.validateEOF();
    }

    public void testBug72997() throws Exception {
        this.initializeScanner("'\\\\'");
        this.validateChar("\\\\");
        this.validateEOF();
    }

    public void testBug72725() throws Exception {
        int n = 0;
        while (n < 2) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("#define a \\");
            if (n == 0) {
                stringBuffer.append("\r");
            }
            stringBuffer.append("\n");
            stringBuffer.append("long macro stuff");
            if (n == 0) {
                stringBuffer.append("\r");
            }
            stringBuffer.append("\n");
            Callback callback = new Callback(ParserMode.COMPLETE_PARSE);
            this.initializeScanner(stringBuffer.toString(), ParserMode.COMPLETE_PARSE, callback);
            this.validateEOF();
            Assert.assertTrue((boolean)callback.problems.isEmpty());
            ++n;
        }
    }

    public void testBug72506() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("#define INCFILE(x) ver ## x\n");
        stringWriter.write("#define xstr(x) str(x)\n");
        stringWriter.write("#define str(x) #x\n");
        stringWriter.write("xstr(INCFILE(2).h)\n");
        this.initializeScanner(stringWriter.toString());
        this.validateString("ver2.h");
        this.validateEOF();
    }

    public void testBug72506_2() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("#define str(x) #x\n");
        stringWriter.write("#define A B\n");
        stringWriter.write("#define B A\n");
        stringWriter.write("str(B)\n");
        this.initializeScanner(stringWriter.toString());
        this.validateString("B");
        this.validateEOF();
    }

    public void testMacroPastingError() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("#define m(expr) \\\r\n");
        stringWriter.write("    foo( #expr )  \r\n");
        Callback callback = new Callback(ParserMode.COMPLETE_PARSE);
        this.initializeScanner(stringWriter.toString(), ParserMode.COMPLETE_PARSE, callback);
        this.validateEOF();
        Assert.assertTrue((boolean)callback.problems.isEmpty());
    }

    public void testBug74176() throws Exception {
        this.initializeScanner("#define MYSTRING \"X Y Z ");
        this.validateEOF();
        this.initializeScanner("#define m(b) #");
        this.validateEOF();
        this.initializeScanner("#define m(foo,b) #b");
        this.validateEOF();
    }

    public void testBug74180() throws Exception {
        this.initializeScanner("true false", ParserLanguage.C);
        this.validateIdentifier("true");
        this.validateIdentifier("false");
        this.initializeScanner("true false", ParserLanguage.CPP);
        this.validateToken(114);
        this.validateToken(81);
    }

    public void testBug73492() throws Exception {
        String string = "#define PTR void *\nPTR;\n";
        int n = string.indexOf("PTR;");
        this.initializeScanner(string);
        IToken iToken = this.scanner.nextToken();
        Assert.assertEquals((int)iToken.getType(), (int)123);
        Assert.assertEquals((int)iToken.getOffset(), (int)n);
        Assert.assertEquals((int)iToken.getLineNumber(), (int)2);
        iToken = this.scanner.nextToken();
        Assert.assertEquals((int)iToken.getType(), (int)23);
        Assert.assertEquals((int)iToken.getOffset(), (int)n);
        Assert.assertEquals((int)iToken.getLineNumber(), (int)2);
        iToken = this.scanner.nextToken();
        Assert.assertEquals((int)iToken.getType(), (int)5);
        Assert.assertEquals((int)iToken.getOffset(), (int)(n + 3));
        Assert.assertEquals((int)iToken.getLineNumber(), (int)2);
    }

    public void testBug74328() throws Exception {
        this.initializeScanner("\"\";\n");
        this.validateString("");
        this.validateToken(5);
        this.validateEOF();
    }

    public void testBug72537() throws Exception {
        this.initializeScanner("FOO BAR(boo)");
        this.scanner.addDefinition("FOO".toCharArray(), "foo".toCharArray());
        this.scanner.addDefinition("BAR(x)".toCharArray(), "x".toCharArray());
        this.validateIdentifier("foo");
        this.validateIdentifier("boo");
        this.validateEOF();
    }

    public void testBug75083() throws Exception {
        String string = "#define blah() { extern foo\n blah()\n";
        this.initializeScanner(string);
        int n = string.indexOf("\n blah()") + 2;
        IToken iToken = this.scanner.nextToken();
        Assert.assertEquals((int)iToken.getType(), (int)12);
        Assert.assertEquals((int)iToken.getOffset(), (int)n);
        Assert.assertEquals((int)iToken.getEndOffset(), (int)(n + 6));
        iToken = this.scanner.nextToken();
        Assert.assertEquals((int)iToken.getType(), (int)80);
        Assert.assertEquals((int)iToken.getOffset(), (int)n);
        Assert.assertEquals((int)iToken.getEndOffset(), (int)(n + 6));
        iToken = this.scanner.nextToken();
        Assert.assertEquals((int)iToken.getType(), (int)1);
        Assert.assertEquals((int)iToken.getOffset(), (int)n);
        Assert.assertEquals((int)iToken.getEndOffset(), (int)(n + 6));
    }

    public void testBug75532IProblems() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#if 09 == 9\n#endif\n");
        ((Writer)stringWriter).write("#if 1A == 0x1A\n#endif\n");
        ((Writer)stringWriter).write("#if 0x == 0x0\n#endif\n");
        ((Writer)stringWriter).write("#if 0xAX == 0xA\n#endif\n");
        ((Writer)stringWriter).write("#if 1/0 == 1\n#endif\n");
        ((Writer)stringWriter).write("#if defined ( sadf a\n#endif\n");
        ((Writer)stringWriter).write("#if defined ( sadf\n#endif\n");
        ((Writer)stringWriter).write("#if defined ( 2sadf )\n#endif\n");
        ((Writer)stringWriter).write("#if ( 1 == 1 ? 1\n#endif\n");
        ((Writer)stringWriter).write("#if (  \n#endif\n");
        ((Writer)stringWriter).write("#if @\n#endif\n");
        ((Writer)stringWriter).write("#if \n#endif\n");
        ((Writer)stringWriter).write("#if -\n#endif\n");
        ((Writer)stringWriter).write("#if ( 1 == 1\n#endif\n");
        ((Writer)stringWriter).write("#if 1 = 1\n#endif\n");
        ((Writer)stringWriter).write("int main(int argc, char **argv) {\n");
        ((Writer)stringWriter).write("if ( 09 == 9 )\n");
        ((Writer)stringWriter).write("return 1;\nreturn 0;\n}\n");
        Callback callback = new Callback(ParserMode.COMPLETE_PARSE);
        this.initializeScanner(((Object)stringWriter).toString(), ParserMode.COMPLETE_PARSE, callback);
        this.fullyTokenize();
        Assert.assertTrue((callback.problems.size() == 16 ? 1 : 0) != 0);
        Iterator iterator = callback.problems.iterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertTrue((((IProblem)iterator.next()).getID() == 0x1000007 ? 1 : 0) != 0);
        Assert.assertTrue((((IProblem)iterator.next()).getID() == 0x1000008 ? 1 : 0) != 0);
        Assert.assertTrue((((IProblem)iterator.next()).getID() == 0x1000005 ? 1 : 0) != 0);
        Assert.assertTrue((((IProblem)iterator.next()).getID() == 0x1000005 ? 1 : 0) != 0);
        Assert.assertTrue((((IProblem)iterator.next()).getID() == 0x100000A ? 1 : 0) != 0);
        Assert.assertTrue((((IProblem)iterator.next()).getID() == 0x100000B ? 1 : 0) != 0);
        Assert.assertTrue((((IProblem)iterator.next()).getID() == 0x100000B ? 1 : 0) != 0);
        Assert.assertTrue((((IProblem)iterator.next()).getID() == 0x100000D ? 1 : 0) != 0);
        Assert.assertTrue((((IProblem)iterator.next()).getID() == 0x100000E ? 1 : 0) != 0);
        Assert.assertTrue((((IProblem)iterator.next()).getID() == 0x100000C ? 1 : 0) != 0);
        Assert.assertTrue((((IProblem)iterator.next()).getID() == 0x100000C ? 1 : 0) != 0);
        Assert.assertTrue((((IProblem)iterator.next()).getID() == 0x100000C ? 1 : 0) != 0);
        Assert.assertTrue((((IProblem)iterator.next()).getID() == 0x100000C ? 1 : 0) != 0);
        Assert.assertTrue((((IProblem)iterator.next()).getID() == 0x100000B ? 1 : 0) != 0);
        Assert.assertTrue((((IProblem)iterator.next()).getID() == 0x1000009 ? 1 : 0) != 0);
        Assert.assertTrue((((IProblem)iterator.next()).getID() == 0x1000007 ? 1 : 0) != 0);
    }

    public void testExpressionEvalProblems() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write(" #if 1 == 1L       \n");
        ((Writer)stringWriter).write(" #endif            \n");
        Callback callback = new Callback(ParserMode.COMPLETE_PARSE);
        this.initializeScanner(((Object)stringWriter).toString(), ParserMode.COMPLETE_PARSE, callback);
        this.validateEOF();
        Assert.assertEquals((int)0, (int)callback.problems.size());
    }

    public void testExpressionEvalProblems_2() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#define FOO( a, b ) a##b    \n");
        ((Writer)stringWriter).write("#if FOO ( 1, 0 ) == 10      \n");
        ((Writer)stringWriter).write("1                           \n");
        ((Writer)stringWriter).write("#endif                      \n");
        Callback callback = new Callback(ParserMode.COMPLETE_PARSE);
        this.initializeScanner(((Object)stringWriter).toString(), ParserMode.COMPLETE_PARSE, callback);
        this.validateInteger("1");
        this.validateEOF();
        Assert.assertEquals((int)0, (int)callback.problems.size());
    }

    public void testUnExpandedFunctionMacro() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#define foo( a ) #a         \n");
        ((Writer)stringWriter).write("foo( 1 )   foo              \n");
        this.initializeScanner(((Object)stringWriter).toString());
        this.validateString("1");
        this.validateIdentifier("foo");
        this.validateEOF();
    }

    public void testBug39688A() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#define decl1(type, ...    \\\n  )   type var;\n");
        ((Writer)stringWriter).write("decl1(int, x, y, z)\n");
        ((Writer)stringWriter).write("#define decl2(type, args...) type args;");
        ((Writer)stringWriter).write("decl2(int, a, b, c, x, y, z)\n");
        ((Writer)stringWriter).write("#define decl3(type, args...) \\\n   type args;");
        ((Writer)stringWriter).write("decl3(int, a, b, c, x, y)\n");
        ((Writer)stringWriter).write("#define decl4(type, args... \\\n   ) type args;");
        ((Writer)stringWriter).write("decl4(int, a, b, z)\n");
        ((Writer)stringWriter).write("#define decl5(type, ...) type __VA_ARGS__;");
        ((Writer)stringWriter).write("decl5(int, z)\n");
        ((Writer)stringWriter).write("#define decl6(type, ...    \\\n) type __VA_ARGS__;");
        ((Writer)stringWriter).write("decl6(int, a, b, c, x)\n");
        ((Writer)stringWriter).write("#define foo(a) a __VA_ARGS__;\n");
        ((Writer)stringWriter).write("#define foo2(a) a #__VA_ARGS__;\n");
        Callback callback = new Callback(ParserMode.COMPLETE_PARSE);
        this.initializeScanner(((Object)stringWriter).toString(), ParserMode.COMPLETE_PARSE, callback);
        this.fullyTokenize();
        Iterator iterator = callback.problems.iterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertTrue((((IProblem)iterator.next()).getID() == 0x200000D ? 1 : 0) != 0);
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertTrue((((IProblem)iterator.next()).getID() == 0x200000A ? 1 : 0) != 0);
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    public void testBug39688B() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#define debug(...) fprintf(stderr, __VA_ARGS__)\n");
        ((Writer)stringWriter).write("#define showlist(...) puts(#__VA_ARGS__)\n");
        ((Writer)stringWriter).write("#define report(test, ...) ((test)?puts(#test):\\\n   printf(__VA_ARGS__))\n");
        ((Writer)stringWriter).write("int main() {\n");
        ((Writer)stringWriter).write("debug(\"Flag\");\n");
        ((Writer)stringWriter).write("debug(\"X = %d\\n\", x);\n");
        ((Writer)stringWriter).write("showlist(The first, second, and third items.);\n");
        ((Writer)stringWriter).write("report(x>y, \"x is %d but y is %d\", x, y);\n");
        ((Writer)stringWriter).write("return 0; }\n");
        Callback callback = new Callback(ParserMode.COMPLETE_PARSE);
        this.initializeScanner(((Object)stringWriter).toString(), ParserMode.COMPLETE_PARSE, callback);
        this.fullyTokenize();
        Iterator iterator = callback.problems.iterator();
        Assert.assertFalse((boolean)iterator.hasNext());
        Map map = this.scanner.getDefinitions();
        Assert.assertTrue((boolean)map.containsKey("debug"));
        Assert.assertTrue((boolean)map.containsKey("showlist"));
        Assert.assertTrue((boolean)map.containsKey("report"));
        FunctionStyleMacro functionStyleMacro = (FunctionStyleMacro)map.get("debug");
        Assert.assertTrue((boolean)new String(functionStyleMacro.arglist[0]).equals("__VA_ARGS__"));
        Assert.assertTrue((boolean)functionStyleMacro.hasVarArgs());
        Assert.assertFalse((boolean)functionStyleMacro.hasGCCVarArgs());
        Assert.assertTrue((boolean)new String(functionStyleMacro.expansion).equals("fprintf(stderr, __VA_ARGS__)"));
        FunctionStyleMacro functionStyleMacro2 = (FunctionStyleMacro)map.get("showlist");
        Assert.assertTrue((boolean)new String(functionStyleMacro2.arglist[0]).equals("__VA_ARGS__"));
        Assert.assertTrue((boolean)functionStyleMacro2.hasVarArgs());
        Assert.assertFalse((boolean)functionStyleMacro2.hasGCCVarArgs());
        Assert.assertTrue((boolean)new String(functionStyleMacro2.expansion).equals("puts(#__VA_ARGS__)"));
        FunctionStyleMacro functionStyleMacro3 = (FunctionStyleMacro)map.get("report");
        Assert.assertTrue((boolean)new String(functionStyleMacro3.arglist[0]).equals("test"));
        Assert.assertTrue((boolean)new String(functionStyleMacro3.arglist[1]).equals("__VA_ARGS__"));
        Assert.assertTrue((boolean)functionStyleMacro3.hasVarArgs());
        Assert.assertFalse((boolean)functionStyleMacro3.hasGCCVarArgs());
        Assert.assertTrue((boolean)new String(functionStyleMacro3.expansion).equals("((test)?puts(#test):   printf(__VA_ARGS__))"));
        this.validate39688Common(stringWriter, callback);
    }

    public void testBug39688C() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#define debug(vars...) fprintf(stderr, vars)\n");
        ((Writer)stringWriter).write("#define showlist(vars...) puts(#vars)\n");
        ((Writer)stringWriter).write("#define report(test, vars...) ((test)?puts(#test):\\\n   printf(vars))\n");
        ((Writer)stringWriter).write("int main() {\n");
        ((Writer)stringWriter).write("debug(\"Flag\");\n");
        ((Writer)stringWriter).write("debug(\"X = %d\\n\", x);\n");
        ((Writer)stringWriter).write("showlist(The first, second, and third items.);\n");
        ((Writer)stringWriter).write("report(x>y, \"x is %d but y is %d\", x, y);\n");
        ((Writer)stringWriter).write("return 0; }\n");
        Callback callback = new Callback(ParserMode.COMPLETE_PARSE);
        this.initializeScanner(((Object)stringWriter).toString(), ParserMode.COMPLETE_PARSE, callback);
        this.fullyTokenize();
        Iterator iterator = callback.problems.iterator();
        Assert.assertFalse((boolean)iterator.hasNext());
        Map map = this.scanner.getDefinitions();
        Assert.assertTrue((boolean)map.containsKey("debug"));
        Assert.assertTrue((boolean)map.containsKey("showlist"));
        Assert.assertTrue((boolean)map.containsKey("report"));
        FunctionStyleMacro functionStyleMacro = (FunctionStyleMacro)map.get("debug");
        Assert.assertTrue((boolean)new String(functionStyleMacro.arglist[0]).equals("vars"));
        Assert.assertFalse((boolean)functionStyleMacro.hasVarArgs());
        Assert.assertTrue((boolean)functionStyleMacro.hasGCCVarArgs());
        Assert.assertTrue((boolean)new String(functionStyleMacro.expansion).equals("fprintf(stderr, vars)"));
        FunctionStyleMacro functionStyleMacro2 = (FunctionStyleMacro)map.get("showlist");
        Assert.assertTrue((boolean)new String(functionStyleMacro2.arglist[0]).equals("vars"));
        Assert.assertFalse((boolean)functionStyleMacro2.hasVarArgs());
        Assert.assertTrue((boolean)functionStyleMacro2.hasGCCVarArgs());
        Assert.assertTrue((boolean)new String(functionStyleMacro2.expansion).equals("puts(#vars)"));
        FunctionStyleMacro functionStyleMacro3 = (FunctionStyleMacro)map.get("report");
        Assert.assertTrue((boolean)new String(functionStyleMacro3.arglist[0]).equals("test"));
        Assert.assertTrue((boolean)new String(functionStyleMacro3.arglist[1]).equals("vars"));
        Assert.assertFalse((boolean)functionStyleMacro3.hasVarArgs());
        Assert.assertTrue((boolean)functionStyleMacro3.hasGCCVarArgs());
        Assert.assertTrue((boolean)new String(functionStyleMacro3.expansion).equals("((test)?puts(#test):   printf(vars))"));
        this.validate39688Common(stringWriter, callback);
    }

    private void validate39688Common(Writer writer, Callback callback) throws Exception {
        this.initializeScanner(writer.toString(), ParserMode.COMPLETE_PARSE, callback);
        this.validateToken(88);
        this.validateIdentifier("main");
        this.validateToken(8);
        this.validateToken(9);
        this.validateToken(12);
        this.validateIdentifier("fprintf");
        this.validateToken(8);
        this.validateIdentifier("stderr");
        this.validateToken(6);
        this.validateString("Flag");
        this.validateToken(9);
        this.validateToken(5);
        this.validateIdentifier("fprintf");
        this.validateToken(8);
        this.validateIdentifier("stderr");
        this.validateToken(6);
        this.validateString("X = %d\\n");
        this.validateToken(6);
        this.validateIdentifier("x");
        this.validateToken(9);
        this.validateToken(5);
        this.validateIdentifier("puts");
        this.validateToken(8);
        this.validateString("The first, second, and third items.");
        this.validateToken(9);
        this.validateToken(5);
        this.validateToken(8);
        this.validateToken(8);
        this.validateIdentifier("x");
        this.validateToken(46);
        this.validateIdentifier("y");
        this.validateToken(9);
        this.validateToken(7);
        this.validateIdentifier("puts");
        this.validateToken(8);
        this.validateString("x>y");
        this.validateToken(9);
        this.validateToken(4);
        this.validateIdentifier("printf");
        this.validateToken(8);
        this.validateString("x is %d but y is %d");
        this.validateToken(6);
        this.validateIdentifier("x");
        this.validateToken(6);
        this.validateIdentifier("y");
        this.validateToken(9);
        this.validateToken(9);
        this.validateToken(5);
        this.validateToken(103);
        this.validateInteger("0");
        this.validateToken(5);
        this.validateToken(13);
        this.validateEOF();
    }

    public void testMacroArgumentExpansion() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#define g_return( expr ) ( expr )                                   \n");
        ((Writer)stringWriter).write("#define ETH( obj ) ( CHECK( (obj), boo ) )                          \n");
        ((Writer)stringWriter).write("#define CHECK CHECK_INSTANCE                                        \n");
        ((Writer)stringWriter).write("#define CHECK_INSTANCE( instance, type ) (foo((instance), (type)))  \n");
        ((Writer)stringWriter).write("g_return( ETH(ooga) )                                               \n");
        this.initializeScanner(((Object)stringWriter).toString());
        this.validateToken(8);
        this.validateToken(8);
        this.validateToken(8);
        this.validateIdentifier("foo");
        this.validateToken(8);
        this.validateToken(8);
        this.validateToken(8);
        this.validateIdentifier("ooga");
        this.validateToken(9);
        this.validateToken(9);
        this.validateToken(6);
        this.validateToken(8);
        this.validateIdentifier("boo");
        this.validateToken(9);
        this.validateToken(9);
        this.validateToken(9);
        this.validateToken(9);
        this.validateToken(9);
    }

    public void testBug75956() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#define ROPE( name ) name##Alloc\n");
        ((Writer)stringWriter).write("#define _C 040                  \n");
        ((Writer)stringWriter).write("ROPE( _C )                      \n");
        this.initializeScanner(((Object)stringWriter).toString());
        this.validateIdentifier("_CAlloc");
        this.validateEOF();
        stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#define ROPE( name ) Alloc ## name \n");
        ((Writer)stringWriter).write("#define _C 040                     \n");
        ((Writer)stringWriter).write("ROPE( _C )                         \n");
        this.initializeScanner(((Object)stringWriter).toString());
        this.validateIdentifier("Alloc_C");
        this.validateEOF();
        stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#define ROPE( name ) name##Alloc\n");
        ((Writer)stringWriter).write("#define _C 040                  \n");
        ((Writer)stringWriter).write("#define _CAlloc ooga            \n");
        ((Writer)stringWriter).write("ROPE( _C )                      \n");
        this.initializeScanner(((Object)stringWriter).toString());
        this.validateIdentifier("ooga");
        this.validateEOF();
    }

    public void testUnExpandedFunctionMacros() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#define ETH(x) x  \n");
        ((Writer)stringWriter).write("#define E ETH     \n");
        ((Writer)stringWriter).write("ETH( c ), ETH, E; \n");
        this.initializeScanner(((Object)stringWriter).toString());
        this.validateIdentifier("c");
        this.validateToken(6);
        this.validateIdentifier("ETH");
        this.validateToken(6);
        this.validateIdentifier("ETH");
        this.validateToken(5);
        this.validateEOF();
    }

    public void testBug79490A() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#define TEST 'n'\n");
        ((Writer)stringWriter).write("#if TEST == 'y'\n");
        ((Writer)stringWriter).write("#define TRUE 1\n");
        ((Writer)stringWriter).write("#else\n");
        ((Writer)stringWriter).write("#define FALSE 1\n");
        ((Writer)stringWriter).write("#endif\n");
        this.initializeScanner(((Object)stringWriter).toString());
        this.validateEOF();
        this.validateDefinition("TEST", "'n'");
        this.validateDefinition("FALSE", "1");
    }

    public void testBug79490B() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#define TEST 'y'\n");
        ((Writer)stringWriter).write("#if TEST == 'y'\n");
        ((Writer)stringWriter).write("#define TRUE 1\n");
        ((Writer)stringWriter).write("#else\n");
        ((Writer)stringWriter).write("#define FALSE 1\n");
        ((Writer)stringWriter).write("#endif\n");
        this.initializeScanner(((Object)stringWriter).toString());
        this.validateEOF();
        this.validateDefinition("TEST", "'y'");
        this.validateDefinition("TRUE", "1");
    }

    public void testBug102568A() throws Exception {
        this.initializeScanner("///*\r\nint x;\r\n");
        this.validateToken(88);
        this.validateIdentifier("x");
        this.validateToken(5);
        this.validateEOF();
    }

    public void testBug102568B() throws Exception {
        this.initializeScanner("// bla some thing /* ... \r\nint x;\r\n");
        this.validateToken(88);
        this.validateIdentifier("x");
        this.validateToken(5);
        this.validateEOF();
    }

    public void testbug84270() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#define h g( ~\n");
        ((Writer)stringWriter).write("#define g f\n");
        ((Writer)stringWriter).write("#define f(a) f(x * (a))\n");
        ((Writer)stringWriter).write("h 5) \n");
        this.initializeScanner(((Object)stringWriter).toString());
        this.fullyTokenize();
    }

    public class TableRow {
        private int[] values;
        private int length;

        public TableRow(int[] nArray) {
            this.length = nArray.length;
            this.values = new int[this.length];
            System.arraycopy(nArray, 0, this.values, 0, this.length);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < this.length) {
                stringBuffer.append("var").append(n).append("=").append(this.values[n]).append(" ");
                ++n;
            }
            return stringBuffer.toString();
        }

        public String symbolName(int n) {
            return "DEFINITION" + n;
        }

        public int symbolValue(int n) {
            return new Long(Math.round(Math.pow(n, n))).intValue();
        }

        public String generateCode() {
            if (this.length < 2) {
                return "Array must have at least 2 elements";
            }
            int n = this.length - 1;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("#if ").append(this.values[0]).append("\n#\tdefine ");
            stringBuffer.append(this.symbolName(0)).append(" ").append(this.symbolValue(0));
            int n2 = 0;
            while (n2 < n) {
                stringBuffer.append("\n#elif ").append(this.values[1 + n2]).append("\n#\tdefine ").append(this.symbolName(n2 + 1)).append(" ").append(this.symbolValue(n2 + 1));
                ++n2;
            }
            stringBuffer.append("\n#else \n#\tdefine ").append(this.symbolName(this.length)).append(" ").append(this.symbolValue(this.length)).append("\n#endif");
            return stringBuffer.toString();
        }

        public int selectWinner() {
            int n = 0;
            while (n < this.values.length) {
                if (this.values[n] != 0) {
                    return n;
                }
                ++n;
            }
            return this.length;
        }

        public int getLength() {
            return this.length;
        }
    }

    public class TruthTable {
        private int numberOfVariables;
        private int numberOfRows;
        public TableRow[] rows;

        public TruthTable(int n) {
            this.numberOfVariables = n;
            this.numberOfRows = new Long(Math.round(Math.pow(2.0, n))).intValue();
            this.rows = new TableRow[this.numberOfRows];
            int n2 = 0;
            while (n2 < this.numberOfRows) {
                String string = Integer.toBinaryString(n2);
                int[] nArray = new int[this.numberOfVariables];
                int n3 = 0;
                while (n3 < this.numberOfVariables) {
                    int n4 = this.numberOfVariables - string.length();
                    int n5 = 0;
                    while (n5 < n4) {
                        nArray[n5] = 0;
                        ++n5;
                    }
                    int n6 = 0;
                    while (n6 < string.length()) {
                        char c = string.charAt(n6);
                        int n7 = Character.digit(c, 10);
                        nArray[n5++] = n7;
                        ++n6;
                    }
                    ++n3;
                }
                this.rows[n2] = new TableRow(nArray);
                ++n2;
            }
        }

        public int getNumberOfRows() {
            return this.numberOfRows;
        }
    }

    protected static class Callback
    extends NullSourceElementRequestor
    implements ISourceElementRequestor {
        public List inclusions = new ArrayList();
        public List problems = new ArrayList();

        public void enterInclusion(IASTInclusion iASTInclusion) {
            this.inclusions.add(iASTInclusion.getName());
        }

        public boolean acceptProblem(IProblem iProblem) {
            this.problems.add(iProblem);
            return super.acceptProblem(iProblem);
        }

        public Callback(ParserMode parserMode) {
            super(parserMode);
        }
    }
}

