/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.tests.scanner2;

import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.IParser;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.NullSourceElementRequestor;
import org.eclipse.cdt.core.parser.ParserFactory;
import org.eclipse.cdt.core.parser.ParserFactoryError;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.ScannerInfo;
import org.eclipse.cdt.internal.core.parser.scanner2.GCCScannerExtensionConfiguration;
import org.eclipse.cdt.internal.core.parser.scanner2.GPPScannerExtensionConfiguration;
import org.eclipse.cdt.internal.core.parser.scanner2.IScannerExtensionConfiguration;
import org.eclipse.cdt.internal.core.parser.scanner2.Scanner2;

public class SpeedTest2
extends TestCase {
    private static final ISourceElementRequestor CALLBACK = new NullSourceElementRequestor();

    public static void main(String[] stringArray) {
        try {
            new SpeedTest2().runTest(1);
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public void test() throws Exception {
        this.runTest(20);
    }

    private void runTest(int n) throws Exception {
        String string = "#include <windows.h>\n#include <stdio.h>\n#include <iostream>\n";
        CodeReader codeReader = new CodeReader(string.toCharArray());
        IScannerInfo iScannerInfo = this.getScannerInfo(false);
        long l = 0L;
        int n2 = 0;
        while (n2 < n) {
            long l2 = this.testParse(codeReader, false, iScannerInfo, ParserLanguage.CPP);
            if (n2 > 4) {
                l += l2;
            }
            ++n2;
        }
        if (n > 5) {
            System.out.println("Average Time: " + l / (long)(n - 5) + " millisecs");
        }
    }

    protected long testParse(CodeReader codeReader, boolean bl, IScannerInfo iScannerInfo, ParserLanguage parserLanguage) throws Exception {
        ParserMode parserMode = bl ? ParserMode.QUICK_PARSE : ParserMode.COMPLETE_PARSE;
        Scanner2 scanner2 = SpeedTest2.createScanner(codeReader, iScannerInfo, parserMode, parserLanguage, CALLBACK, null, Collections.EMPTY_LIST);
        IParser iParser = ParserFactory.createParser((IScanner)scanner2, (ISourceElementRequestor)CALLBACK, (ParserMode)parserMode, (ParserLanguage)parserLanguage, null);
        long l = System.currentTimeMillis();
        iParser.parse();
        long l2 = System.currentTimeMillis() - l;
        System.out.println("Resulting parse took " + l2 + " millisecs " + scanner2.getCount() + " tokens");
        return l2;
    }

    public static Scanner2 createScanner(CodeReader codeReader, IScannerInfo iScannerInfo, ParserMode parserMode, ParserLanguage parserLanguage, ISourceElementRequestor iSourceElementRequestor, IParserLogService iParserLogService, List list) throws ParserFactoryError {
        if (iScannerInfo == null) {
            throw new ParserFactoryError(ParserFactoryError.Kind.NULL_CONFIG);
        }
        if (parserLanguage == null) {
            throw new ParserFactoryError(ParserFactoryError.Kind.NULL_LANGUAGE);
        }
        IParserLogService iParserLogService2 = iParserLogService == null ? ParserFactory.createDefaultLogService() : iParserLogService;
        ParserMode parserMode2 = parserMode == null ? ParserMode.COMPLETE_PARSE : parserMode;
        ISourceElementRequestor iSourceElementRequestor2 = iSourceElementRequestor == null ? new NullSourceElementRequestor() : iSourceElementRequestor;
        Object object = null;
        object = parserLanguage == ParserLanguage.C ? new GCCScannerExtensionConfiguration() : new GPPScannerExtensionConfiguration();
        return new Scanner2(codeReader, iScannerInfo, iSourceElementRequestor2, parserMode2, parserLanguage, iParserLogService2, list, (IScannerExtensionConfiguration)object);
    }

    protected IScannerInfo getScannerInfo(boolean bl) {
        if (bl) {
            return new ScannerInfo();
        }
        String string = System.getProperty("speedTest.config");
        if (string == null) {
            return this.mingwScannerInfo(false);
        }
        if (string.equals("msvc")) {
            return this.msvcScannerInfo(false);
        }
        if (string.equals("ydl")) {
            return this.ydlScannerInfo(false);
        }
        return this.mingwScannerInfo(false);
    }

    private IScannerInfo msvcScannerInfo(boolean bl) {
        if (bl) {
            return new ScannerInfo();
        }
        Hashtable hashtable = new Hashtable();
        String[] stringArray = new String[]{"C:\\Program Files\\Microsoft SDK\\Include", "C:\\Program Files\\Microsoft Visual C++ Toolkit 2003\\include"};
        return new ScannerInfo(hashtable, stringArray);
    }

    private IScannerInfo mingwScannerInfo(boolean bl) {
        if (bl) {
            return new ScannerInfo();
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("__GNUC__", "3");
        hashtable.put("__GNUC_MINOR__", "2");
        hashtable.put("__GNUC_PATCHLEVEL__", "3");
        hashtable.put("__GXX_ABI_VERSION", "102");
        hashtable.put("_WIN32", "");
        hashtable.put("__WIN32", "");
        hashtable.put("__WIN32__", "");
        hashtable.put("WIN32", "");
        hashtable.put("__MINGW32__", "");
        hashtable.put("__MSVCRT__", "");
        hashtable.put("WINNT", "");
        hashtable.put("_X86_", "1");
        hashtable.put("__WINNT", "");
        hashtable.put("_NO_INLINE__", "");
        hashtable.put("__STDC_HOSTED__", "1");
        hashtable.put("i386", "");
        hashtable.put("__i386", "");
        hashtable.put("__i386__", "");
        hashtable.put("__tune_i586__", "");
        hashtable.put("__tune_pentium__", "");
        hashtable.put("__stdcall", "__attribute__((__stdcall__))");
        hashtable.put("__cdecl", "__attribute__((__cdecl__))");
        hashtable.put("__fastcall", "__attribute__((__fastcall__))");
        hashtable.put("_stdcall", "__attribute__((__stdcall__))");
        hashtable.put("_cdecl", "__attribute__((__cdecl__))");
        hashtable.put("_fastcall", "__attribute__((__fastcall__))");
        hashtable.put("__declspec(x)", "__attribute__((x))");
        hashtable.put("__DEPRECATED", "");
        hashtable.put("__EXCEPTIONS", "");
        String[] stringArray = new String[]{"c:/mingw/include/c++/3.2.3", "c:/mingw/include/c++/3.2.3/mingw32", "c:/mingw/include/c++/3.2.3/backward", "c:/mingw/include", "c:/mingw/lib/gcc-lib/mingw32/3.2.3/include"};
        return new ScannerInfo(hashtable, stringArray);
    }

    private IScannerInfo ydlScannerInfo(boolean bl) {
        if (bl) {
            return new ScannerInfo();
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("__GNUC__", "3");
        hashtable.put("__GNUC_MINOR__", "3");
        hashtable.put("__GNUC_PATCHLEVEL__", "3");
        hashtable.put("_GNU_SOURCE", "");
        hashtable.put("__unix__", "");
        hashtable.put("__gnu_linux__", "");
        hashtable.put("__linux__", "");
        hashtable.put("unix", "");
        hashtable.put("__unix", "");
        hashtable.put("linux", "");
        hashtable.put("__linux", "");
        hashtable.put("__GNUG__", "3");
        String[] stringArray = new String[]{"/usr/include/g++", "/usr/include/g++/powerpc-yellowdog-linux", "/usr/include/g++/backward", "/usr/local/include", "/usr/lib/gcc-lib/powerpc-yellowdog-linux/3.3.3/include", "/usr/include"};
        return new ScannerInfo(hashtable, stringArray);
    }
}

