/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.tests;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.Set;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.ICDescriptorOperation;
import org.eclipse.cdt.core.index.ICDTIndexer;
import org.eclipse.cdt.core.index.IIndexChangeListener;
import org.eclipse.cdt.core.index.IIndexDelta;
import org.eclipse.cdt.core.index.IndexChangeEvent;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.search.BasicSearchMatch;
import org.eclipse.cdt.core.search.BasicSearchResultCollector;
import org.eclipse.cdt.core.search.ICSearchConstants;
import org.eclipse.cdt.core.search.ICSearchPattern;
import org.eclipse.cdt.core.search.ICSearchResultCollector;
import org.eclipse.cdt.core.search.ICSearchScope;
import org.eclipse.cdt.core.search.IMatch;
import org.eclipse.cdt.core.search.IOffsetLocatable;
import org.eclipse.cdt.core.search.SearchEngine;
import org.eclipse.cdt.core.testplugin.CProjectHelper;
import org.eclipse.cdt.core.tests.BaseTestFramework;
import org.eclipse.cdt.core.tests.FailingTest;
import org.eclipse.cdt.internal.core.browser.cache.TypeCacheManager;
import org.eclipse.cdt.internal.core.index.domsourceindexer.DOMSourceIndexer;
import org.eclipse.cdt.internal.core.index.domsourceindexer.DOMSourceIndexerRunner;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;

public class SearchRegressionTests
extends BaseTestFramework
implements ICSearchConstants,
IIndexChangeListener {
    protected static ICSearchScope scope;
    protected static SearchEngine searchEngine;
    protected static BasicSearchResultCollector resultCollector;
    private static boolean indexChanged;

    static {
        indexChanged = false;
    }

    public SearchRegressionTests() {
        scope = SearchEngine.createWorkspaceScope();
        resultCollector = new BasicSearchResultCollector();
        searchEngine = new SearchEngine();
    }

    public SearchRegressionTests(String string) {
        super(string);
        scope = SearchEngine.createWorkspaceScope();
        resultCollector = new BasicSearchResultCollector();
        searchEngine = new SearchEngine();
    }

    protected void setUp() throws Exception {
        super.setUp();
        try {
            if (BaseTestFramework.project == null) {
                BaseTestFramework.cproject = CProjectHelper.createCCProject("RegressionTestProject", "bin");
                BaseTestFramework.project = BaseTestFramework.cproject.getProject();
            }
        }
        catch (CoreException coreException) {}
        this.resetIndexer("org.eclipse.cdt.core.domsourceindexer");
        DOMSourceIndexerRunner.setSkipScannerInfoTest((boolean)true);
        TypeCacheManager typeCacheManager = TypeCacheManager.getInstance();
        typeCacheManager.setProcessTypeCacheEvents(false);
        CCorePlugin.getDefault().getCoreModel().getIndexManager();
        BaseTestFramework.indexDisabled = false;
        ICDTIndexer iCDTIndexer = CCorePlugin.getDefault().getCoreModel().getIndexManager().getIndexerForProject(BaseTestFramework.project);
        if (iCDTIndexer instanceof DOMSourceIndexer) {
            ((DOMSourceIndexer)iCDTIndexer).addIndexChangeListener((IIndexChangeListener)this);
        }
    }

    protected void tearDown() throws Exception {
        if (BaseTestFramework.project == null || !BaseTestFramework.project.exists()) {
            return;
        }
        CCorePlugin.getDefault().getCoreModel().getIndexManager();
        try {
            BaseTestFramework.project.setSessionProperty(DOMSourceIndexer.activationKey, (Object)new Boolean(false));
            BaseTestFramework.project.delete(true, true, (IProgressMonitor)new NullProgressMonitor());
            BaseTestFramework.project = null;
        }
        catch (CoreException coreException) {}
        super.tearDown();
    }

    protected Set search(ICSearchPattern iCSearchPattern) {
        try {
            resultCollector.aboutToStart();
            searchEngine.search(BaseTestFramework.workspace, iCSearchPattern, scope, (ICSearchResultCollector)resultCollector, false);
        }
        catch (InterruptedException interruptedException) {}
        return resultCollector.getSearchResults();
    }

    protected Set search(ICSearchPattern iCSearchPattern, ICElement[] iCElementArray) {
        try {
            ICSearchScope iCSearchScope = SearchEngine.createCSearchScope((ICElement[])iCElementArray);
            searchEngine.search(BaseTestFramework.workspace, iCSearchPattern, iCSearchScope, (ICSearchResultCollector)resultCollector, false);
        }
        catch (InterruptedException interruptedException) {}
        return resultCollector.getSearchResults();
    }

    public void indexChanged(IndexChangeEvent indexChangeEvent) {
        if (indexChangeEvent.getDelta().getDeltaType() == IIndexDelta.MERGE_DELTA) {
            indexChanged = true;
        }
    }

    protected IFile importFile(String string, String string2) throws Exception {
        indexChanged = false;
        IFile iFile = super.importFile(string, string2);
        if (!BaseTestFramework.indexDisabled) {
            while (!indexChanged) {
                Thread.sleep(100L);
            }
        }
        return iFile;
    }

    public void assertMatch(Set set, IFile iFile, int n) throws Exception {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            IMatch iMatch = (IMatch)iterator.next();
            if (((IOffsetLocatable)iMatch.getLocatable()).getNameStartOffset() != n || !iMatch.getLocation().equals((Object)iFile.getLocation())) continue;
            return;
        }
        Assert.fail((String)("Match at offset " + n + " in \"" + iFile.getLocation() + "\" not found."));
    }

    public void resetIndexer(final String string) {
        if (BaseTestFramework.project != null) {
            ICDescriptorOperation iCDescriptorOperation = new ICDescriptorOperation(){

                public void execute(ICDescriptor iCDescriptor, IProgressMonitor iProgressMonitor) throws CoreException {
                    iCDescriptor.remove("org.eclipse.cdt.core.CIndexer");
                    iCDescriptor.create("org.eclipse.cdt.core.CIndexer", string);
                }
            };
            try {
                CCorePlugin.getDefault().getCDescriptorManager().runDescriptorOperation(BaseTestFramework.project, iCDescriptorOperation, (IProgressMonitor)new NullProgressMonitor());
                CCorePlugin.getDefault().getCoreModel().getIndexManager().indexerChangeNotification(BaseTestFramework.project);
            }
            catch (CoreException coreException) {}
        }
    }

    public static Test suite() {
        return SearchRegressionTests.suite(true);
    }

    public static Test suite(boolean bl) {
        TestSuite testSuite = new TestSuite("SearchRegressionTests");
        testSuite.addTest((Test)new SearchRegressionTests("testClassDeclarationReference"));
        testSuite.addTest((Test)new SearchRegressionTests("testClassStructDeclaration"));
        testSuite.addTest((Test)new SearchRegressionTests("testClassStructReference"));
        testSuite.addTest((Test)new SearchRegressionTests("testNamespaceDeclaration"));
        testSuite.addTest((Test)new SearchRegressionTests("testNamespaceDefinition"));
        testSuite.addTest((Test)new SearchRegressionTests("testNamespaceReference"));
        testSuite.addTest((Test)new SearchRegressionTests("testMethodDeclaration"));
        testSuite.addTest((Test)new SearchRegressionTests("testMethodDefinition"));
        testSuite.addTest((Test)new SearchRegressionTests("testMethodReference"));
        testSuite.addTest((Test)new SearchRegressionTests("testMethodReferenceOperator"));
        testSuite.addTest((Test)new FailingTest((Test)new SearchRegressionTests("testMethodReferenceImplicitOperator"), 80117));
        testSuite.addTest((Test)new SearchRegressionTests("testMethodReferenceInitializer"));
        testSuite.addTest((Test)new SearchRegressionTests("testMethodReferenceInline"));
        testSuite.addTest((Test)new SearchRegressionTests("testMethodReferenceWithCctor"));
        testSuite.addTest((Test)new SearchRegressionTests("testConstructorReferenceArg"));
        testSuite.addTest((Test)new SearchRegressionTests("testConstructorReferenceAlone"));
        testSuite.addTest((Test)new SearchRegressionTests("testDestructorReference"));
        testSuite.addTest((Test)new SearchRegressionTests("testFunctionDeclaration"));
        testSuite.addTest((Test)new SearchRegressionTests("testFunctionDefinition"));
        testSuite.addTest((Test)new SearchRegressionTests("testFunctionReference"));
        testSuite.addTest((Test)new SearchRegressionTests("testFieldDeclaration"));
        testSuite.addTest((Test)new SearchRegressionTests("testBitFieldDeclaration"));
        testSuite.addTest((Test)new SearchRegressionTests("testFieldDefinition"));
        testSuite.addTest((Test)new SearchRegressionTests("testFieldReference"));
        testSuite.addTest((Test)new FailingTest((Test)new SearchRegressionTests("testNestedFieldReference"), 76203));
        testSuite.addTest((Test)new SearchRegressionTests("testVarDeclaration"));
        testSuite.addTest((Test)new FailingTest((Test)new SearchRegressionTests("testVarDefinition")));
        testSuite.addTest((Test)new FailingTest((Test)new SearchRegressionTests("testVarReference")));
        testSuite.addTest((Test)new FailingTest((Test)new SearchRegressionTests("testVarDeclarationArgument")));
        testSuite.addTest((Test)new FailingTest((Test)new SearchRegressionTests("testVarReferenceInitializer"), 72735));
        testSuite.addTest((Test)new SearchRegressionTests("testVarDefinitionArgument"));
        testSuite.addTest((Test)new FailingTest((Test)new SearchRegressionTests("testUnionDeclaration")));
        testSuite.addTest((Test)new FailingTest((Test)new SearchRegressionTests("testUnionReference")));
        testSuite.addTest((Test)new FailingTest((Test)new SearchRegressionTests("testEnumerationDeclaration")));
        testSuite.addTest((Test)new SearchRegressionTests("testEnumerationReference"));
        testSuite.addTest((Test)new FailingTest((Test)new SearchRegressionTests("testEnumerationReferenceGlobal"), 79811));
        testSuite.addTest((Test)new FailingTest((Test)new SearchRegressionTests("testEnumeratorDeclaration")));
        testSuite.addTest((Test)new SearchRegressionTests("testEnumeratorReference"));
        testSuite.addTest((Test)new FailingTest((Test)new SearchRegressionTests("testEnumeratorDeclarationCase"), 79717));
        testSuite.addTest((Test)new SearchRegressionTests("testTypedefDeclaration"));
        testSuite.addTest((Test)new SearchRegressionTests("testMacroDeclaration"));
        testSuite.addTest((Test)new SearchRegressionTests("testMethodFieldReferenceInExpressions"));
        if (bl) {
            testSuite.addTest((Test)new SearchRegressionTests("cleanupProject"));
        }
        return testSuite;
    }

    public void testClassDeclarationReference() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write(" class A {               \n");
        ((Writer)stringWriter).write("    int foo();           \n");
        ((Writer)stringWriter).write(" };                      \n");
        ((Writer)stringWriter).write(" int A::foo() {          \n");
        ((Writer)stringWriter).write(" }                       \n");
        String string = ((Object)stringWriter).toString();
        IFile iFile = this.importFile("ClassDeclarationReference.cpp", string);
        ICElement[] iCElementArray = new ICElement[]{BaseTestFramework.cproject.getCProject()};
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"A", (ICSearchConstants.SearchFor)ICSearchConstants.CLASS, (ICSearchConstants.LimitTo)ICSearchConstants.ALL_OCCURRENCES, (boolean)true);
        Set set = this.search(iCSearchPattern, iCElementArray);
        Assert.assertEquals((int)2, (int)set.size());
        this.assertMatch(set, iFile, string.indexOf("A {"));
        this.assertMatch(set, iFile, string.indexOf("A::"));
    }

    public void testClassStructDeclaration() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write(" namespace N1 {\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\tstruct linkedlist1{//decl \t\t\t\t\n");
        ((Writer)stringWriter).write("\t\tint field1_t;\t\t\t\t\t    \n");
        ((Writer)stringWriter).write("\t\tstruct linkedlist1 *field2;\t  \t\t\n");
        ((Writer)stringWriter).write("\t};\t\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\tclass linkedlist2{//decl\t\t\t\t\n");
        ((Writer)stringWriter).write("\t\tint field3;\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\t\tclass linkedlist2 *field4;\t\t\t\n");
        ((Writer)stringWriter).write("\t};\t\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write(" namespace N2 {\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("  class C { \t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("  \tstruct linkedlist1 field5;\t\t    \n");
        ((Writer)stringWriter).write("   \tlinkedlist2 *field6;\t\t\t\t\n");
        ((Writer)stringWriter).write("  };\t\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write(" }\t\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("  class linkedlist2 var1;\t\t\t\t\t\n");
        ((Writer)stringWriter).write(" }\t\t\t\t\t\t\t\t\t\t\n");
        String string = ((Object)stringWriter).toString();
        IFile iFile = this.importFile("ClassStructDeclaration.h", string);
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"N1::*", (ICSearchConstants.SearchFor)ICSearchConstants.CLASS_STRUCT, (ICSearchConstants.LimitTo)ICSearchConstants.DEFINITIONS, (boolean)true);
        Set set = this.search(iCSearchPattern);
        Assert.assertEquals((int)2, (int)set.size());
        this.assertMatch(set, iFile, string.indexOf("linkedlist1{//decl"));
        this.assertMatch(set, iFile, string.indexOf("linkedlist2{//decl"));
    }

    public void testClassStructReference() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class Mammal {\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\tpublic:\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\tMammal(bool b){}\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("  static litter=12;\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("};\t\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("class Bear : Mammal/*ref1*/{\t\t\t\t\n");
        ((Writer)stringWriter).write("public:\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\tBear(int s,int t): Mammal(true) { \t\t\n");
        ((Writer)stringWriter).write("    biotics.littersPerYear=t;\t\t\t\t\n");
        ((Writer)stringWriter).write("  }\t\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("  struct {\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\t  int littersPerYear; \t\t\t\t\t\n");
        ((Writer)stringWriter).write("  } biotics;\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("  class BearPaws{};\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("};\t\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("struct bioticPotential {\t\t\t\t\t\n");
        ((Writer)stringWriter).write("  int litterSize;\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\tint matureYears;\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("};\t\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("struct bioticPotential/*ref2*/ bp;\t\t\n");
        ((Writer)stringWriter).write("int main(int argc, char **argv) {\t\t\t\n");
        ((Writer)stringWriter).write(" \tbioticPotential/*ref3*/ brownbear_bt = {1, 3};\t\t\t\n");
        ((Writer)stringWriter).write("\tBear/*ref4*/ *grizzly = new Bear(4,3);\t\t\t\t\t\n");
        ((Writer)stringWriter).write("    \tbrownbear_bt.litterSize = Mammal::litter;/*ref5*/\t\n");
        ((Writer)stringWriter).write("  Bear::BearPaws p;//ref6,ref7\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("} \t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        String string = ((Object)stringWriter).toString();
        IFile iFile = this.importFile("ClassStructReference.cpp", string);
        ICElement[] iCElementArray = new ICElement[]{BaseTestFramework.cproject.getCProject()};
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"*", (ICSearchConstants.SearchFor)ICSearchConstants.CLASS_STRUCT, (ICSearchConstants.LimitTo)ICSearchConstants.REFERENCES, (boolean)true);
        Set set = this.search(iCSearchPattern, iCElementArray);
        this.assertMatch(set, iFile, string.indexOf("Mammal/*ref1*/"));
        this.assertMatch(set, iFile, string.indexOf("bioticPotential/*ref2*/"));
        this.assertMatch(set, iFile, string.indexOf("bioticPotential/*ref3*/"));
        this.assertMatch(set, iFile, string.indexOf("Bear/*ref4*/"));
        this.assertMatch(set, iFile, string.indexOf("Mammal::litter;/*ref5*/"));
        this.assertMatch(set, iFile, string.indexOf("Bear::BearPaws p;//ref6"));
        this.assertMatch(set, iFile, string.indexOf("BearPaws p;//ref6,ref7"));
        Assert.assertEquals((int)7, (int)set.size());
    }

    public void testNamespaceDeclaration() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("namespace N {//defn,decl\t\t\t\t\n");
        ((Writer)stringWriter).write("  int a;\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("  namespace M {//defn,decl\t\t\t\n");
        ((Writer)stringWriter).write("    struct linkedlist {\t\t\t\t\n");
        ((Writer)stringWriter).write("      int item;\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("      struct linkedlist *next;\t\t\n");
        ((Writer)stringWriter).write("    };\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("  }\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("}\t\t\t\t\t\t\t\t\t\t\n");
        String string = ((Object)stringWriter).toString();
        IFile iFile = this.importFile("NamespaceDeclaration.h", string);
        stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#include \"NamespaceDeclaration.h\"\t\t\t\t\t\n");
        ((Writer)stringWriter).write("using namespace N::M;\t\t\t\t\n");
        ((Writer)stringWriter).write("linkedlist serial_numbers;\t\t\n");
        ((Writer)stringWriter).write("namespace R {//defn,decl\t\t\t\n");
        ((Writer)stringWriter).write("\tclass C {\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\tpublic:\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\t  char c();\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\t};\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("}\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("using namespace R;\t\t\t\t\n");
        ((Writer)stringWriter).write("char C::c(){\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("return 'a';\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("}\t\t\t\t\t\t\t\t\t\n");
        String string2 = ((Object)stringWriter).toString();
        IFile iFile2 = this.importFile("NamespaceDeclaration.cpp", string2);
        ICElement[] iCElementArray = new ICElement[]{BaseTestFramework.cproject.getCProject()};
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"*", (ICSearchConstants.SearchFor)ICSearchConstants.NAMESPACE, (ICSearchConstants.LimitTo)ICSearchConstants.DEFINITIONS, (boolean)true);
        Set set = this.search(iCSearchPattern, iCElementArray);
        Assert.assertEquals((int)3, (int)set.size());
        this.assertMatch(set, iFile, string.indexOf("N"));
        this.assertMatch(set, iFile, string.indexOf("M"));
        this.assertMatch(set, iFile2, string2.indexOf("R {//defn,decl"));
    }

    public void testNamespaceDefinition() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("namespace N/*def1*/ {\t\t\t\t\n");
        ((Writer)stringWriter).write("  int a;\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("  namespace M/*def2*/ {\t\t\t\n");
        ((Writer)stringWriter).write("    struct linkedlist {};\t\t\t\n");
        ((Writer)stringWriter).write("  }\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("}\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("namespace N/*def3*/{int i;}\t\t\n");
        String string = ((Object)stringWriter).toString();
        IFile iFile = this.importFile("NamespaceDefinition.h", string);
        stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#include \"NamespaceDefinition.h\"\n");
        ((Writer)stringWriter).write("using namespace N::M;\t\t\t\t\n");
        ((Writer)stringWriter).write("linkedlist serial_numbers;\t\t\n");
        ((Writer)stringWriter).write("namespace R/*def4*/ {\t\t\t\t\n");
        ((Writer)stringWriter).write("\tclass C {};\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("}\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("using namespace R;\t\t\t\t\n");
        String string2 = ((Object)stringWriter).toString();
        IFile iFile2 = this.importFile("NamespaceDefinition.cpp", string2);
        ICElement[] iCElementArray = new ICElement[]{BaseTestFramework.cproject.getCProject()};
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"*", (ICSearchConstants.SearchFor)ICSearchConstants.NAMESPACE, (ICSearchConstants.LimitTo)ICSearchConstants.DEFINITIONS, (boolean)true);
        Set set = this.search(iCSearchPattern, iCElementArray);
        Assert.assertEquals((int)4, (int)set.size());
        this.assertMatch(set, iFile, string.indexOf("N/*def1*/"));
        this.assertMatch(set, iFile, string.indexOf("M"));
        this.assertMatch(set, iFile, string.indexOf("N/*def3*/"));
        this.assertMatch(set, iFile2, string2.indexOf("R/*def4*/"));
    }

    public void testNamespaceReference() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("namespace N1 {\n");
        ((Writer)stringWriter).write("\tclass C1 {};\n");
        ((Writer)stringWriter).write("\tnamespace N2 {\n");
        ((Writer)stringWriter).write("\t\tclass C2{};\n");
        ((Writer)stringWriter).write("\t\tnamespace N3 {\n");
        ((Writer)stringWriter).write("\t\t\tclass C3{};\n");
        ((Writer)stringWriter).write("\t\t}\t\t\n");
        ((Writer)stringWriter).write("\t}\t\t\t\n");
        ((Writer)stringWriter).write("}\t\t\t\t\n");
        String string = ((Object)stringWriter).toString();
        this.importFile("NamespaceReference.h", string);
        stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#include \"NamespaceReference.h\"\t\t\t\t\n");
        ((Writer)stringWriter).write("N1::N2::C2 *c = new N1::N2::C2();\t\t\n");
        ((Writer)stringWriter).write("using namespace N1::N2;\t\t\t\t\n");
        ((Writer)stringWriter).write("N3::C3 *d = new N3::C3();       \t\t\n");
        String string2 = ((Object)stringWriter).toString();
        IFile iFile = this.importFile("NamespaceReference.cpp", string2);
        ICElement[] iCElementArray = new ICElement[]{BaseTestFramework.cproject.getCProject()};
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"*", (ICSearchConstants.SearchFor)ICSearchConstants.NAMESPACE, (ICSearchConstants.LimitTo)ICSearchConstants.REFERENCES, (boolean)true);
        Set set = this.search(iCSearchPattern, iCElementArray);
        Assert.assertEquals((int)8, (int)set.size());
        this.assertMatch(set, iFile, string2.indexOf("N1::N2::C2 *c"));
        this.assertMatch(set, iFile, string2.indexOf("N2::C2 *c"));
        this.assertMatch(set, iFile, string2.indexOf("N1::N2::C2();"));
        this.assertMatch(set, iFile, string2.indexOf("N2::C2();"));
        this.assertMatch(set, iFile, string2.indexOf("N1::N2;"));
        this.assertMatch(set, iFile, string2.indexOf("N2;"));
        this.assertMatch(set, iFile, string2.indexOf("N3::C3 *d"));
        this.assertMatch(set, iFile, string2.indexOf("N3::C3();"));
    }

    public void testMethodDeclaration() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class M {\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("public:\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\tint m;\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\tM/*dec1*/();\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\texplicit M/*dec2*/(int i){}\t\t\t\t\n");
        ((Writer)stringWriter).write("\tvirtual ~M/*dec3*/(){}\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\tvoid m1/*dec4*/();\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\tstatic int m2/*dec5*/(){return 1;}\t\t\n");
        ((Writer)stringWriter).write("\tM& operator <</*dec7*/ (const M &rhs);\t\n");
        ((Writer)stringWriter).write("\tM& operator==/*dec8*/ (const M &rhs);\t\n");
        ((Writer)stringWriter).write("};\t\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("namespace N{\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("class C{ \t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\tinline int m3/*dec6*/(int i){return 2;}\t\n");
        ((Writer)stringWriter).write("};\t\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("}\t\t\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("int f1(M m){}\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("void foo(){\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\tf1(M(3)); \t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("}\t\t\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("M::M() {\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\tfz();\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("}\t\t\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("void M::m1() {\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\tfz();\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write(" }\t\t\t\t\t\t\t\t\t\t\n");
        String string = ((Object)stringWriter).toString();
        IFile iFile = this.importFile("MethodDeclaration.cpp", string);
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"*M", (ICSearchConstants.SearchFor)ICSearchConstants.METHOD, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true);
        ICElement[] iCElementArray = new ICElement[]{BaseTestFramework.cproject.getCProject()};
        Set set = this.search(iCSearchPattern, iCElementArray);
        Assert.assertEquals((int)1, (int)set.size());
        this.assertMatch(set, iFile, string.indexOf("M/*dec1*/"));
        iCSearchPattern = SearchEngine.createSearchPattern((String)"m*", (ICSearchConstants.SearchFor)ICSearchConstants.METHOD, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true);
        set = this.search(iCSearchPattern, iCElementArray);
        Assert.assertEquals((int)1, (int)set.size());
        this.assertMatch(set, iFile, string.indexOf("m1/*dec4*/"));
        iCSearchPattern = SearchEngine.createSearchPattern((String)"N::C::m3", (ICSearchConstants.SearchFor)ICSearchConstants.METHOD, (ICSearchConstants.LimitTo)ICSearchConstants.DEFINITIONS, (boolean)true);
        set = this.search(iCSearchPattern, iCElementArray);
        Assert.assertEquals((int)1, (int)set.size());
        this.assertMatch(set, iFile, string.indexOf("m3/*dec6*/"));
        iCSearchPattern = SearchEngine.createSearchPattern((String)"operator ??", (ICSearchConstants.SearchFor)ICSearchConstants.METHOD, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true);
        set = this.search(iCSearchPattern, iCElementArray);
        Assert.assertEquals((int)2, (int)set.size());
        this.assertMatch(set, iFile, string.indexOf("operator <</*dec7*/"));
        this.assertMatch(set, iFile, string.indexOf("operator==/*dec8*/"));
    }

    public void testMethodDefinition() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class N {\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write(" N& operator ||(const N &rhs){return *this;}\n");
        ((Writer)stringWriter).write(" N& operator|(const N &rhs);\t\t\t\t\n");
        ((Writer)stringWriter).write(" int m;\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("};\t\t\t\t\t\t\t\t\t\t\n");
        String string = ((Object)stringWriter).toString();
        this.importFile("MethodDefinition.h", string);
        stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#include \"MethodDefinition.h\"\t\t\t\n");
        ((Writer)stringWriter).write("N& N::operator|/*def1*/(const N &rhs){}\t\n");
        ((Writer)stringWriter).write("class M {\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("public:\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\tint m;\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\tM/*def2*/(){}\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\texplicit M(int i);\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\tvirtual ~M/*def3*/(){}\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\tvoid m1();\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\tstatic int m2/*def4*/(){return 1;}\t\t\n");
        ((Writer)stringWriter).write("};\t\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("namespace NN{\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("class C{ \t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\tinline int m3/*def5*/(int i){return 2;}\t\n");
        ((Writer)stringWriter).write("\tvoid foo() const;\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("};\t\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("}\t\t\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\t\t\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("void NN::C::foo/*def6*/() const{}\t\t\t\n");
        ((Writer)stringWriter).write("M::M/*def7*/(int i) {\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\tm=i;\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("}\t\t\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("void M::m1/*def8*/() {}\t\t\t\t\t\n");
        String string2 = ((Object)stringWriter).toString();
        IFile iFile = this.importFile("MethodDefinition.cpp", string2);
        ICElement[] iCElementArray = new ICElement[]{BaseTestFramework.cproject};
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"*", (ICSearchConstants.SearchFor)ICSearchConstants.METHOD, (ICSearchConstants.LimitTo)ICSearchConstants.DEFINITIONS, (boolean)true);
        Set set = this.search(iCSearchPattern, iCElementArray);
        this.assertMatch(set, iFile, string2.indexOf("operator|/*def1*/"));
        this.assertMatch(set, iFile, string2.indexOf("M/*def2*/"));
        this.assertMatch(set, iFile, string2.indexOf("~M/*def3*/"));
        this.assertMatch(set, iFile, string2.indexOf("m2/*def4*/"));
        this.assertMatch(set, iFile, string2.indexOf("m3/*def5*/"));
        this.assertMatch(set, iFile, string2.indexOf("foo/*def6*/"));
        this.assertMatch(set, iFile, string2.indexOf("M/*def7*/"));
        this.assertMatch(set, iFile, string2.indexOf("m1/*def8*/"));
        Assert.assertEquals((int)9, (int)set.size());
        iCSearchPattern = SearchEngine.createSearchPattern((String)"operator |*", (ICSearchConstants.SearchFor)ICSearchConstants.METHOD, (ICSearchConstants.LimitTo)ICSearchConstants.DEFINITIONS, (boolean)true);
        set = this.search(iCSearchPattern, iCElementArray);
        Assert.assertEquals((int)2, (int)set.size());
        this.assertMatch(set, iFile, string2.indexOf("operator|/*def1*/"));
    }

    public void testMethodReference() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class K{\t\t\t\t\t\n");
        ((Writer)stringWriter).write("public:\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\tK();\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\tvirtual ~K();\t\t\t\n");
        ((Writer)stringWriter).write("\tstatic int fx();\t\t\n");
        ((Writer)stringWriter).write("\tinline void fz(){}\t\t\n");
        ((Writer)stringWriter).write("\tvoid fy(){fz/*ref*/()}\t\n");
        ((Writer)stringWriter).write("\tint kk;\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\texplicit K(int i){}\t\t\n");
        ((Writer)stringWriter).write("};\t\t\t\t\t\t\n");
        String string = ((Object)stringWriter).toString();
        this.importFile("MethodReference.h", string);
        stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#include \"MethodReference.h\"\n");
        ((Writer)stringWriter).write("K::K(){}\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("K::~K(){}\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("int K::fx(){return 12;}\t\t\n");
        ((Writer)stringWriter).write("void fw(){}\t\t\t\t\t\n");
        ((Writer)stringWriter).write("void foo(){\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\tint i = K::fx/*ref1*/();\t\n");
        ((Writer)stringWriter).write("\t(new K/*ref4*/())->fy/*ref2*/();\t\n");
        ((Writer)stringWriter).write("\tfw();\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\tK k;\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\tk.fy/*ref3*/();\t\t\t\t\n");
        ((Writer)stringWriter).write("  k.~K/*ref5*/();\t\t\t\t\n");
        ((Writer)stringWriter).write("}\t\t\t\t\t\t\t\t\n");
        String string2 = ((Object)stringWriter).toString();
        IFile iFile = this.importFile("MethodReference.cpp", string2);
        ICElement[] iCElementArray = new ICElement[]{BaseTestFramework.cproject.findElement((IPath)new Path("MethodReference.cpp"))};
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"f*", (ICSearchConstants.SearchFor)ICSearchConstants.METHOD, (ICSearchConstants.LimitTo)ICSearchConstants.REFERENCES, (boolean)true);
        Set set = this.search(iCSearchPattern, iCElementArray);
        this.assertMatch(set, iFile, string2.lastIndexOf("fx/*ref1*/"));
        this.assertMatch(set, iFile, string2.indexOf("fy/*ref2*/"));
        this.assertMatch(set, iFile, string2.lastIndexOf("fy/*ref3*/"));
        iCSearchPattern = SearchEngine.createSearchPattern((String)"*K", (ICSearchConstants.SearchFor)ICSearchConstants.METHOD, (ICSearchConstants.LimitTo)ICSearchConstants.REFERENCES, (boolean)true);
        set = this.search(iCSearchPattern);
        Assert.assertEquals((int)2, (int)set.size());
        this.assertMatch(set, iFile, string2.indexOf("K/*ref4*/"));
        this.assertMatch(set, iFile, string2.indexOf("~K/*ref5*/"));
    }

    public void testMethodReferenceOperator() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class K{\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("public:\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\tK();\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\tK& operator == (const K &rhs){}\t\n");
        ((Writer)stringWriter).write("};\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("void foo(){\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\tK k;\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\tK m=k;\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\tif (m.operator==/*ref1*/(k)){}\t\n");
        ((Writer)stringWriter).write("}\t\t\t\t\t\t\t\t\t\n");
        String string = ((Object)stringWriter).toString();
        IFile iFile = this.importFile("MethodReferenceOperator.cpp", string);
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"operator ==", (ICSearchConstants.SearchFor)ICSearchConstants.METHOD, (ICSearchConstants.LimitTo)ICSearchConstants.REFERENCES, (boolean)true);
        Set set = this.search(iCSearchPattern);
        Assert.assertEquals((int)1, (int)set.size());
        this.assertMatch(set, iFile, string.indexOf("operator==/*ref1*/"));
    }

    public void testMethodReferenceImplicitOperator() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class K{\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("public:\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\tK();\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\tK& operator == (const K &rhs){}\t\n");
        ((Writer)stringWriter).write("};\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("void foo(){\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\tK k;\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\tK m=k;\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\tif (m==/*ref*/k){}\t\t\t\t\n");
        ((Writer)stringWriter).write("}\t\t\t\t\t\t\t\t\t\n");
        String string = ((Object)stringWriter).toString();
        IFile iFile = this.importFile("MethodReferenceImplicitOperator.cpp", string);
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"operator ==", (ICSearchConstants.SearchFor)ICSearchConstants.METHOD, (ICSearchConstants.LimitTo)ICSearchConstants.REFERENCES, (boolean)true);
        Set set = this.search(iCSearchPattern);
        Assert.assertEquals((int)1, (int)set.size());
        this.assertMatch(set, iFile, string.indexOf("==/*ref*/"));
    }

    public void testMethodReferenceInitializer() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class Mammal {\t\t\t\n");
        ((Writer)stringWriter).write("\tpublic:\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\tMammal(int t): num(t){}\t\n");
        ((Writer)stringWriter).write("\tprivate:\t\t\t\t\n");
        ((Writer)stringWriter).write("\tint num;\t\t\t\t\n");
        ((Writer)stringWriter).write("};\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("class Bear : Mammal{\t\t\n");
        ((Writer)stringWriter).write("public:\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\t  Bear(int t): Mammal(t) {} \n");
        ((Writer)stringWriter).write("};\t\t\t\t\t\t\n");
        String string = ((Object)stringWriter).toString();
        IFile iFile = this.importFile("MethodReferenceInitializer.cpp", string);
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"Mammal", (ICSearchConstants.SearchFor)ICSearchConstants.METHOD, (ICSearchConstants.LimitTo)ICSearchConstants.REFERENCES, (boolean)true);
        Set set = this.search(iCSearchPattern);
        Assert.assertEquals((int)1, (int)set.size());
        this.assertMatch(set, iFile, string.indexOf("Mammal(t)"));
    }

    public void testMethodReferenceInline() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class A{\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("  friend class M;\t\t\t\t\n");
        ((Writer)stringWriter).write("  void aa();\t\t\t\t\t\n");
        ((Writer)stringWriter).write("};\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("class M {\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("public:\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\tM();\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\tvoid zz(){a->aa();}//ref\t\t\n");
        ((Writer)stringWriter).write("  A *a;\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("};\t\t\t\t\t\t\t\n");
        String string = ((Object)stringWriter).toString();
        IFile iFile = this.importFile("MethodReferenceInline.cpp", string);
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"aa", (ICSearchConstants.SearchFor)ICSearchConstants.METHOD, (ICSearchConstants.LimitTo)ICSearchConstants.REFERENCES, (boolean)true);
        Set set = this.search(iCSearchPattern);
        Assert.assertEquals((int)1, (int)set.size());
        this.assertMatch(set, iFile, string.indexOf("aa();}//ref"));
    }

    public void testMethodReferenceWithCctor() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class C{\t\t\t\n");
        ((Writer)stringWriter).write(" void cc(){}\t\t\n");
        ((Writer)stringWriter).write("};\t\t\t\t\n");
        ((Writer)stringWriter).write("void g(){\t\t\t\n");
        ((Writer)stringWriter).write("\tC().cc/*ref*/();\n");
        ((Writer)stringWriter).write("}\t\t\t\t\t\n");
        String string = ((Object)stringWriter).toString();
        IFile iFile = this.importFile("MethodReferenceWithCctor.cpp", string);
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"cc", (ICSearchConstants.SearchFor)ICSearchConstants.METHOD, (ICSearchConstants.LimitTo)ICSearchConstants.REFERENCES, (boolean)true);
        Set set = this.search(iCSearchPattern);
        Assert.assertEquals((int)1, (int)set.size());
        this.assertMatch(set, iFile, string.indexOf("cc/*ref*/"));
    }

    public void testConstructorReferenceArg() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class C{\t\t\t\n");
        ((Writer)stringWriter).write(" C();\t\t\t\t\n");
        ((Writer)stringWriter).write("};\t\t\t\t\n");
        ((Writer)stringWriter).write("void f(C c){}\t\t\n");
        ((Writer)stringWriter).write("void g(){\t\t\t\n");
        ((Writer)stringWriter).write("\tf(C/*ref*/());;\t\n");
        ((Writer)stringWriter).write("}\t\t\t\t\t\n");
        String string = ((Object)stringWriter).toString();
        IFile iFile = this.importFile("ConstructorReferenceArg.cpp", string);
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"C", (ICSearchConstants.SearchFor)ICSearchConstants.METHOD, (ICSearchConstants.LimitTo)ICSearchConstants.REFERENCES, (boolean)true);
        Set set = this.search(iCSearchPattern);
        Assert.assertEquals((int)1, (int)set.size());
        this.assertMatch(set, iFile, string.indexOf("C/*ref*/"));
    }

    public void testConstructorReferenceAlone() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class C{\t\t\t\n");
        ((Writer)stringWriter).write(" C(){}\t\t\t\n");
        ((Writer)stringWriter).write("};\t\t\t\t\n");
        ((Writer)stringWriter).write("void g(){\t\t\t\n");
        ((Writer)stringWriter).write("\tC/*ref*/();\t\t\n");
        ((Writer)stringWriter).write("}\t\t\t\t\t\n");
        String string = ((Object)stringWriter).toString();
        IFile iFile = this.importFile("ConstructorReferenceAlone.cpp", string);
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"C", (ICSearchConstants.SearchFor)ICSearchConstants.METHOD, (ICSearchConstants.LimitTo)ICSearchConstants.REFERENCES, (boolean)true);
        Set set = this.search(iCSearchPattern);
        Assert.assertEquals((int)1, (int)set.size());
        this.assertMatch(set, iFile, string.indexOf("C/*ref*/"));
    }

    public void testDestructorReference() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class A{\t\t\t\t\t\n");
        ((Writer)stringWriter).write("  friend class M;\t\t\t\n");
        ((Writer)stringWriter).write("  ~A();\t\t\t\t\t\n");
        ((Writer)stringWriter).write("};\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("class M {\t\t\t\t\t\n");
        ((Writer)stringWriter).write("public:\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\tM();\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\t~M();\t\t\t\t\t\n");
        ((Writer)stringWriter).write("  A *a;\t\t\t\t\t\n");
        ((Writer)stringWriter).write("};\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("M::~M(){a->~A();}//ref\t\n");
        ((Writer)stringWriter).write("void f() {\t\t\t\t\n");
        ((Writer)stringWriter).write("\tM m;\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\tm.~M();//ref\t\t\t\n");
        ((Writer)stringWriter).write("}\t\t\t\t\t\t\t\n");
        String string = ((Object)stringWriter).toString();
        IFile iFile = this.importFile("DestructorReference.cpp", string);
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"~A", (ICSearchConstants.SearchFor)ICSearchConstants.METHOD, (ICSearchConstants.LimitTo)ICSearchConstants.REFERENCES, (boolean)true);
        Set set = this.search(iCSearchPattern);
        Assert.assertEquals((int)1, (int)set.size());
        this.assertMatch(set, iFile, string.indexOf("~A();}//ref"));
        iCSearchPattern = SearchEngine.createSearchPattern((String)"~M", (ICSearchConstants.SearchFor)ICSearchConstants.METHOD, (ICSearchConstants.LimitTo)ICSearchConstants.REFERENCES, (boolean)true);
        set = this.search(iCSearchPattern);
        Assert.assertEquals((int)1, (int)set.size());
        this.assertMatch(set, iFile, string.indexOf("~M();//ref"));
    }

    public void testFunctionDeclaration() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("namespace N{\t\t\t\t\t\n");
        ((Writer)stringWriter).write("int f1/*decl*/(){return 0;}\t\n");
        ((Writer)stringWriter).write("}\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("static int f2/*decl*/();\t\t\n");
        ((Writer)stringWriter).write("extern int f3/*decl*/();\t\t\n");
        ((Writer)stringWriter).write("inline void f4/*decl*/(int *a, int *b){int t=*b; *b=*a; *a=t;}\t\n");
        String string = ((Object)stringWriter).toString();
        IFile iFile = this.importFile("FunctionDeclaration.h", string);
        stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#include \"FunctionDeclaration.h\"\n");
        ((Writer)stringWriter).write("void f5()/*decl*/{\t\t\t\t\n");
        ((Writer)stringWriter).write("\tint i = N::f1();\t\t\t\t\n");
        ((Writer)stringWriter).write("\tint j = f3();\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\tf4(&i, &j);\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("}\t\t\t\t\t\t\t\t\t\n");
        String string2 = ((Object)stringWriter).toString();
        this.importFile("FunctionDeclaration.cpp", string2);
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"f*", (ICSearchConstants.SearchFor)ICSearchConstants.FUNCTION, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true);
        ICElement[] iCElementArray = new ICElement[]{BaseTestFramework.cproject.getCProject()};
        Set set = this.search(iCSearchPattern, iCElementArray);
        this.assertMatch(set, iFile, string.indexOf("f2"));
        this.assertMatch(set, iFile, string.indexOf("f3"));
        Assert.assertEquals((int)2, (int)set.size());
    }

    public void testFunctionDefinition() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("namespace N{\t\t\t\t\t\n");
        ((Writer)stringWriter).write("int f1/*def*/(){return 0;}\t\n");
        ((Writer)stringWriter).write("}\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("static int f2();\t\t\t\t\n");
        ((Writer)stringWriter).write("extern int f3/*decl*/();\t\t\n");
        ((Writer)stringWriter).write("inline void f4/*def*/(int *a, int *b){int t=*b; *b=*a; *a=t;}\t\n");
        String string = ((Object)stringWriter).toString();
        IFile iFile = this.importFile("FunctionDefinition.h", string);
        stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#include \"FunctionDefinition.h\"\n");
        ((Writer)stringWriter).write("int f2/*def*/(){return 2;}\t\t\n");
        ((Writer)stringWriter).write("void f5/*def*/(){\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\tint i = N::f1();\t\t\t\t\n");
        ((Writer)stringWriter).write("\tint j = f3();\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\tf4(&i, &j);\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("}\t\t\t\t\t\t\t\t\t\n");
        String string2 = ((Object)stringWriter).toString();
        IFile iFile2 = this.importFile("FunctionDefinition.cpp", string2);
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"f*", (ICSearchConstants.SearchFor)ICSearchConstants.FUNCTION, (ICSearchConstants.LimitTo)ICSearchConstants.DEFINITIONS, (boolean)true);
        ICElement[] iCElementArray = new ICElement[]{BaseTestFramework.cproject.getCProject()};
        Set set = this.search(iCSearchPattern, iCElementArray);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            BasicSearchMatch cfr_ignored_0 = (BasicSearchMatch)iterator.next();
        }
        this.assertMatch(set, iFile, string.indexOf("f1"));
        this.assertMatch(set, iFile2, string2.indexOf("f2"));
        this.assertMatch(set, iFile, string.indexOf("f4"));
        this.assertMatch(set, iFile2, string2.indexOf("f5"));
        Assert.assertEquals((int)4, (int)set.size());
    }

    public void testFunctionReference() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("namespace N{\t\t\t\n");
        ((Writer)stringWriter).write("int fz(){return 0;}\t\n");
        ((Writer)stringWriter).write("}\t\t\t\t\t\t\n");
        String string = ((Object)stringWriter).toString();
        this.importFile("FunctionReference.h", string);
        stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#include \"FunctionReference.h\"\t\n");
        ((Writer)stringWriter).write("int fw(){return 0;}\t\t\t\t\n");
        ((Writer)stringWriter).write("void fg(int i){}\t\t\t\t\t\n");
        ((Writer)stringWriter).write("void f(){\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\tint i = N::fz/*ref1*/();\t\t\n");
        ((Writer)stringWriter).write("\tfg/*ref2*/(fw/*ref3*/());\t\t\n");
        ((Writer)stringWriter).write("}\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("using N::fz/*ref4*/;\t\t\t\t\n");
        String string2 = ((Object)stringWriter).toString();
        IFile iFile = this.importFile("FunctionReference.cpp", string2);
        ICElement[] iCElementArray = new ICElement[]{BaseTestFramework.cproject.findElement((IPath)new Path("FunctionReference.cpp"))};
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"f*", (ICSearchConstants.SearchFor)ICSearchConstants.FUNCTION, (ICSearchConstants.LimitTo)ICSearchConstants.REFERENCES, (boolean)true);
        Set set = this.search(iCSearchPattern, iCElementArray);
        this.assertMatch(set, iFile, string2.indexOf("fz/*ref1*/"));
        this.assertMatch(set, iFile, string2.lastIndexOf("fg/*ref2*/"));
        this.assertMatch(set, iFile, string2.indexOf("fw/*ref3*/"));
        this.assertMatch(set, iFile, string2.lastIndexOf("fz/*ref4*/"));
        Assert.assertEquals((int)4, (int)set.size());
    }

    public void testFieldDeclaration() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write(" namespace N2 {\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\tstruct linkedlist1{ \t\t\t\t\t\n");
        ((Writer)stringWriter).write("\t\tlong field1_t;\t\t\t\t\t    \n");
        ((Writer)stringWriter).write("\t\tstruct linkedlist1 *field2;\t  \t\t\n");
        ((Writer)stringWriter).write("\t\tstatic int sfield;\t  \t\t\t\t\n");
        ((Writer)stringWriter).write("\t};\t\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\tclass linkedlist2{ \t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\t\tunsigned char field3;\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\t\tclass linkedlist2 *field4;\t\t\t\n");
        ((Writer)stringWriter).write("\t};\t\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write(" }\t\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write(" class C { \t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write(" \tstruct {} field5;\t\t    \t\t\t\n");
        ((Writer)stringWriter).write("  class C1 {\t\t    \t\t\t\t\t\n");
        ((Writer)stringWriter).write("  \tN2::linkedlist2 *field6;\t\t    \n");
        ((Writer)stringWriter).write("  };\t\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write(" };\t\t\t\t\t\t\t\t\t\t\n");
        String string = ((Object)stringWriter).toString();
        IFile iFile = this.importFile("FieldDeclaration.h", string);
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"*", (ICSearchConstants.SearchFor)ICSearchConstants.FIELD, (ICSearchConstants.LimitTo)ICSearchConstants.DEFINITIONS, (boolean)true);
        ICElement[] iCElementArray = new ICElement[]{BaseTestFramework.cproject.getCProject()};
        Set set = this.search(iCSearchPattern, iCElementArray);
        this.assertMatch(set, iFile, string.indexOf("field1"));
        this.assertMatch(set, iFile, string.indexOf("field2"));
        this.assertMatch(set, iFile, string.indexOf("field3"));
        this.assertMatch(set, iFile, string.indexOf("field4"));
        this.assertMatch(set, iFile, string.indexOf("field5"));
        this.assertMatch(set, iFile, string.indexOf("field6"));
        Assert.assertEquals((int)6, (int)set.size());
    }

    public void testBitFieldDeclaration() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("struct Date\t{\t\t\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("    unsigned nWeekDay  : 3;    // 0..7   (3 bits)\t\t\t\n");
        ((Writer)stringWriter).write("    unsigned nMonthDay : 6;    // 0..31  (6 bits)\t\t\t\n");
        ((Writer)stringWriter).write("    unsigned           : 0;    // Force alignment to next boundary.\n");
        ((Writer)stringWriter).write("    unsigned nMonth    : 5;    // 0..12  (5 bits)\t\t\t\n");
        ((Writer)stringWriter).write("    unsigned nYear     : 8;    // 0..100 (8 bits)\t\t\t\n");
        ((Writer)stringWriter).write("}; \t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        String string = ((Object)stringWriter).toString();
        IFile iFile = this.importFile("BitFieldDeclaration.cpp", string);
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"n*", (ICSearchConstants.SearchFor)ICSearchConstants.FIELD, (ICSearchConstants.LimitTo)ICSearchConstants.DEFINITIONS, (boolean)true);
        ICElement[] iCElementArray = new ICElement[]{BaseTestFramework.cproject.getCProject()};
        Set set = this.search(iCSearchPattern, iCElementArray);
        Assert.assertEquals((int)4, (int)set.size());
        this.assertMatch(set, iFile, string.indexOf("nWeekDay"));
        this.assertMatch(set, iFile, string.indexOf("nMonthDay"));
        this.assertMatch(set, iFile, string.indexOf("nMonth"));
        this.assertMatch(set, iFile, string.indexOf("nYear"));
    }

    public void testFieldDefinition() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("    enum ZooLocs {ZOOANIMAL, BEAR, PANDA};\n");
        ((Writer)stringWriter).write("    namespace zoo {\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("    class ZooAnimal{\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("    public:\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("    \tZooAnimal(char *s = \"ZooAnimal\");\t\n");
        ((Writer)stringWriter).write("    protected:\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("    \tchar *name/*def*/;\t\t\t\t\t\n");
        ((Writer)stringWriter).write("    \tZooAnimal *next/*def*/;\t\t\t\t\n");
        ((Writer)stringWriter).write("    };\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("    class Mammal{\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("    protected:\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("    \tbool isCarnivore/*def*/;\t\t\t\n");
        ((Writer)stringWriter).write("    };\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("    class Bear : public ZooAnimal, Mammal{\n");
        ((Writer)stringWriter).write("    public:  static int number;\t\t\t\n");
        ((Writer)stringWriter).write("    protected:\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("    \tZooLocs zooArea/*def*/;\t\t\t\t\n");
        ((Writer)stringWriter).write("      class Beez{\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("        const double dutch/*def*/;\t\t\n");
        ((Writer)stringWriter).write("      };\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("    };\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("    }\t\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("    int zoo::Bear::number/*def*/=3;\t\t\t\t\t\t\t\t\t\n");
        String string = ((Object)stringWriter).toString();
        IFile iFile = this.importFile("FieldDefinition.cpp", string);
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"*", (ICSearchConstants.SearchFor)ICSearchConstants.FIELD, (ICSearchConstants.LimitTo)ICSearchConstants.DEFINITIONS, (boolean)true);
        ICElement[] iCElementArray = new ICElement[]{BaseTestFramework.cproject.getCProject()};
        Set set = this.search(iCSearchPattern, iCElementArray);
        Assert.assertEquals((int)6, (int)set.size());
        this.assertMatch(set, iFile, string.indexOf("name/*def*/"));
        this.assertMatch(set, iFile, string.indexOf("next/*def*/"));
        this.assertMatch(set, iFile, string.indexOf("isCarnivore/*def*/"));
        this.assertMatch(set, iFile, string.indexOf("zooArea/*def*/"));
        this.assertMatch(set, iFile, string.indexOf("dutch/*def*/"));
        this.assertMatch(set, iFile, string.indexOf("number/*def*/"));
    }

    public void testFieldReference() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class Mammal {//decl\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\tpublic:\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\tMammal(bool b): isCarnivore/*ref*/(b){}\t\n");
        ((Writer)stringWriter).write("\tprivate:\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\tbool isCarnivore;\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("};\t\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("class Bear : Mammal{\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("public:\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\tBear(int s,int t): Mammal(true) { \t\t\n");
        ((Writer)stringWriter).write("    biotics.matureYears=s;//ref\t\t\t\n");
        ((Writer)stringWriter).write("  }\t\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("  struct {\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("    int matureYears;\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("  } biotics;\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("};\t\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("struct bioticPotential {\t\t\t\t\t\n");
        ((Writer)stringWriter).write("  int litterSize;\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\tint matureYears;\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("};\t\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("int main(int argc, char **argv) {\t\t\t\n");
        ((Writer)stringWriter).write(" \tbioticPotential brownbear_bt = {1, 3};\t\n");
        ((Writer)stringWriter).write("\tBear *grizzly = new Bear(4,3);\t\t\t\n");
        ((Writer)stringWriter).write("    \tbrownbear_bt.matureYears = grizzly->biotics.matureYears;//ref\n");
        ((Writer)stringWriter).write("} \t\t\t\t\t\t\t\t\t\t\n");
        String string = ((Object)stringWriter).toString();
        IFile iFile = this.importFile("FieldReference.cpp", string);
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"isCarnivore", (ICSearchConstants.SearchFor)ICSearchConstants.FIELD, (ICSearchConstants.LimitTo)ICSearchConstants.REFERENCES, (boolean)true);
        Set set = this.search(iCSearchPattern);
        Assert.assertEquals((int)1, (int)set.size());
        this.assertMatch(set, iFile, string.indexOf("isCarnivore/*ref*/"));
        iCSearchPattern = SearchEngine.createSearchPattern((String)"biotics", (ICSearchConstants.SearchFor)ICSearchConstants.FIELD, (ICSearchConstants.LimitTo)ICSearchConstants.REFERENCES, (boolean)true);
        set = this.search(iCSearchPattern);
        Assert.assertEquals((int)2, (int)set.size());
        this.assertMatch(set, iFile, string.indexOf("biotics.matureYears=s;"));
        this.assertMatch(set, iFile, string.indexOf("biotics.matureYears;//ref"));
    }

    public void testNestedFieldReference() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class Bear {\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("public:\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\tBear(int s,int t) { \t\t\t\t\t\n");
        ((Writer)stringWriter).write("    biotics.matureYears=s;//ref\t\t\t\n");
        ((Writer)stringWriter).write("    biotics.littersPerYear=t;\t\t\t\t\n");
        ((Writer)stringWriter).write("  }\t\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("  struct {\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("    int matureYears;\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\t  int littersPerYear; \t\t\t\t\t\n");
        ((Writer)stringWriter).write("  } biotics;\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("};\t\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("struct bioticPotential {\t\t\t\t\t\n");
        ((Writer)stringWriter).write("  int litterSize;\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\tint matureYears;\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("};\t\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("int main(int argc, char **argv) {\t\t\t\n");
        ((Writer)stringWriter).write(" \tbioticPotential brownbear_bt = {1, 3};\t\n");
        ((Writer)stringWriter).write("\tBear *grizzly = new Bear(4,3);\t\t\t\n");
        ((Writer)stringWriter).write("    \tbrownbear_bt.matureYears = grizzly->biotics.matureYears;//ref\n");
        ((Writer)stringWriter).write("} \t\t\t\t\t\t\t\t\t\t\n");
        String string = ((Object)stringWriter).toString();
        IFile iFile = this.importFile("NestedFieldReference.cpp", string);
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"matureYears", (ICSearchConstants.SearchFor)ICSearchConstants.FIELD, (ICSearchConstants.LimitTo)ICSearchConstants.REFERENCES, (boolean)true);
        Set set = this.search(iCSearchPattern);
        Assert.assertEquals((int)3, (int)set.size());
        this.assertMatch(set, iFile, string.indexOf("matureYears = grizzly"));
        this.assertMatch(set, iFile, string.indexOf("matureYears;//ref"));
        this.assertMatch(set, iFile, string.indexOf("matureYears=s;//ref,ref"));
    }

    public void testVarDeclaration() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write(" namespace N2 {\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\tclass linkedlist2{ \t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\t\tint field3;\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\t\tclass linkedlist2 *field4;\t\t\t\n");
        ((Writer)stringWriter).write("\t};\t\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("  class linkedlist2 var1;\t\t\t\t\t\n");
        ((Writer)stringWriter).write(" }\t\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("extern bool var2;\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("unsigned int var3(1024);\t\t\t\t\t\n");
        ((Writer)stringWriter).write("unsigned long long var4=123456,\t\t\t\n");
        ((Writer)stringWriter).write("\t\tvar5=1234567;\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("void f(){\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\t\tvolatile unsigned long var6;\t\t\n");
        ((Writer)stringWriter).write("  \tfor (register int var7=0; var7<10000; var7++){}\t\n");
        ((Writer)stringWriter).write(" }\t\t\t\t\t\t\t\t\t\t\n");
        String string = ((Object)stringWriter).toString();
        IFile iFile = this.importFile("VarDeclaration.h", string);
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"*", (ICSearchConstants.SearchFor)ICSearchConstants.VAR, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true);
        ICElement[] iCElementArray = new ICElement[]{BaseTestFramework.cproject.getCProject()};
        Set set = this.search(iCSearchPattern, iCElementArray);
        Assert.assertEquals((int)1, (int)set.size());
        this.assertMatch(set, iFile, string.indexOf("var2"));
    }

    public void testVarDefinition() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("namespace zoo {\t\t\t\t\n");
        ((Writer)stringWriter).write("  int var1/*def*/;\t\t\t\n");
        ((Writer)stringWriter).write("}\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("extern int var;\t\t\t\t\n");
        ((Writer)stringWriter).write("extern char var2/*def*/=3;\t\n");
        ((Writer)stringWriter).write("int& var3/*def*/=zoo::var1;\t\n");
        ((Writer)stringWriter).write("long long var4/*def*/;\t\t\n");
        ((Writer)stringWriter).write("void f(){\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\tshort var5/*def*/=0xabcd;\t\n");
        ((Writer)stringWriter).write("  const float var6/*def*/=1.5;\n");
        ((Writer)stringWriter).write("}\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("class A{\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("  void f(){\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\t  long double** var7/*def*/;\t\n");
        ((Writer)stringWriter).write("    float var8/*def*/=1.5;\t\n");
        ((Writer)stringWriter).write("  }\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("};\t\t\t\t\t\t\t\n");
        String string = ((Object)stringWriter).toString();
        IFile iFile = this.importFile("VarDefinition.cpp", string);
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"*", (ICSearchConstants.SearchFor)ICSearchConstants.VAR, (ICSearchConstants.LimitTo)ICSearchConstants.DEFINITIONS, (boolean)true);
        ICElement[] iCElementArray = new ICElement[]{BaseTestFramework.cproject.getCProject()};
        Set set = this.search(iCSearchPattern, iCElementArray);
        Assert.assertEquals((int)8, (int)set.size());
        this.assertMatch(set, iFile, string.indexOf("var1"));
        this.assertMatch(set, iFile, string.indexOf("var2"));
        this.assertMatch(set, iFile, string.indexOf("var3"));
        this.assertMatch(set, iFile, string.indexOf("var4"));
        this.assertMatch(set, iFile, string.indexOf("var5"));
        this.assertMatch(set, iFile, string.indexOf("var6"));
        this.assertMatch(set, iFile, string.indexOf("var7"));
        this.assertMatch(set, iFile, string.indexOf("var8"));
    }

    public void testVarReference() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("char * strcpy( char *, const char * );   \t\t\n");
        ((Writer)stringWriter).write("namespace zoo {\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("  int sci=1;\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("  class ZooAnimal{\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("    public:\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("    \tZooAnimal(char *s = \"ZooAnimal\"){}\t\n");
        ((Writer)stringWriter).write("    protected:\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("    \tchar *name;\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("  };\t\t\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("  class Bear : public ZooAnimal{\t\t\t\t\n");
        ((Writer)stringWriter).write("    public:\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("    \tBear(char *sci = \"Ursidae\" );\t\t\t\n");
        ((Writer)stringWriter).write("    protected:\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("    \tchar *sciName;\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("  };\t\t\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("  Bear::Bear(char *sci)\t{\t\t\t\t\t\n");
        ((Writer)stringWriter).write("    \tstrcpy (sciName, sci/*ref1*/);\t\t\t\n");
        ((Writer)stringWriter).write("  \tint j=zoo::sci/*ref2*/;\t\t\t\t\t\n");
        ((Writer)stringWriter).write("  }\t\t\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write(" }\t\t\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("void f() {\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("  int sci;\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("  sci/*ref3*/++;\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("  --sci/*ref4*/;\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("}\t\t\t\t\t\t\t\t\t\t\t\t\n");
        String string = ((Object)stringWriter).toString();
        IFile iFile = this.importFile("VarReference.cpp", string);
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"sci", (ICSearchConstants.SearchFor)ICSearchConstants.VAR, (ICSearchConstants.LimitTo)ICSearchConstants.REFERENCES, (boolean)true);
        Set set = this.search(iCSearchPattern);
        Assert.assertEquals((int)4, (int)set.size());
        this.assertMatch(set, iFile, string.indexOf("sci/*ref1*/"));
        this.assertMatch(set, iFile, string.indexOf("sci/*ref2*/"));
        this.assertMatch(set, iFile, string.indexOf("sci/*ref3*/"));
        this.assertMatch(set, iFile, string.indexOf("sci/*ref4*/"));
    }

    public void testVarDeclarationArgument() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("namespace zoo {\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write(" class Bear {\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("   public:\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("   \tBear( char *s/*decl1*/ = \"Bear\" );\n");
        ((Writer)stringWriter).write(" };\t\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("  Bear::Bear(char *s/*decl2*/)\t\t\t\n");
        ((Writer)stringWriter).write("   \t: ZooAnimal(s) {\t\t\t\t\t\n");
        ((Writer)stringWriter).write("  }\t\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("}\t\t\t\t\t\t\t\t\t\t\t\n");
        String string = ((Object)stringWriter).toString();
        IFile iFile = this.importFile("VarDeclarationArgument.cpp", string);
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"s", (ICSearchConstants.SearchFor)ICSearchConstants.VAR, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true);
        Set set = this.search(iCSearchPattern);
        this.assertMatch(set, iFile, string.indexOf("s/*decl1*/"));
        this.assertMatch(set, iFile, string.indexOf("s/*decl2*/"));
        Assert.assertEquals((int)2, (int)set.size());
    }

    public void testVarReferenceInitializer() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("enum ZooLocs {ZOOANIMAL, BEAR, PANDA};\t\t\t\t\t\n");
        ((Writer)stringWriter).write("namespace zoo {\t\t\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("  class ZooAnimal{\t\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("    public:\t\t\t\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("    \tZooAnimal(char *s = \"ZooAnimal\");\t\t\t\t\t\n");
        ((Writer)stringWriter).write("  };\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("  class Bear : public ZooAnimal{\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("    public:\t\t\t\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("    \tBear( char *s = \"Bear\", ZooLocs loc = \"BEAR\" );\t\n");
        ((Writer)stringWriter).write("    protected:\t\t\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("    \tZooLocs zooArea;\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("  };\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("  Bear::Bear(char *s, ZooLocs loc)\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("   \t: ZooAnimal(s), zooArea (loc/*ref*/) {}\t\t\t\t\n");
        ((Writer)stringWriter).write("  }\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write(" }\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        String string = ((Object)stringWriter).toString();
        IFile iFile = this.importFile("VarReferenceInitializer.cpp", string);
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"loc", (ICSearchConstants.SearchFor)ICSearchConstants.VAR, (ICSearchConstants.LimitTo)ICSearchConstants.REFERENCES, (boolean)true);
        Set set = this.search(iCSearchPattern);
        Assert.assertEquals((int)1, (int)set.size());
        this.assertMatch(set, iFile, string.indexOf("loc/*ref*/"));
    }

    public void testVarDefinitionArgument() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write(" class C {\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("   public:\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("   \tC( char *s/*def1*/ = \"Bear\" );\n");
        ((Writer)stringWriter).write(" };\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("  C::C(char *s/*def2*/){}\t\t\t\t\n");
        String string = ((Object)stringWriter).toString();
        this.importFile("VarDeclarationArgument.cpp", string);
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"s", (ICSearchConstants.SearchFor)ICSearchConstants.VAR, (ICSearchConstants.LimitTo)ICSearchConstants.DEFINITIONS, (boolean)true);
        Set set = this.search(iCSearchPattern);
        Assert.assertEquals((int)0, (int)set.size());
    }

    public void testUnionDeclaration() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("enum Tokentype {ID, ICONST};\t\t\n");
        ((Writer)stringWriter).write("class Token {\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("  public:\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("  Tokentype tok;\t\t\t\t\t\n");
        ((Writer)stringWriter).write("  union { //anon field\t \t\t\n");
        ((Writer)stringWriter).write("\tchar *sval;\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\tint ival;\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\tdouble dval;\t\t   \t\t\t\n");
        ((Writer)stringWriter).write("\t} val1;\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("};\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("static union { //anon static\t\t\n");
        ((Writer)stringWriter).write("\tchar *sval;\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\tint ival;\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\tdouble dval;\t\t\t\t\t\n");
        ((Writer)stringWriter).write("};\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("union TokenValue { \t\t\t\t\n");
        ((Writer)stringWriter).write("TokenValue (int ix) {ival = ix;}\t\n");
        ((Writer)stringWriter).write("TokenValue (char *s) {sval = s;}\t\n");
        ((Writer)stringWriter).write("TokenValue () {}  \t\t\t\t\n");
        ((Writer)stringWriter).write("\tchar *sval;\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\tint ival;\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\tdouble dval;\t\t\t\t\t\n");
        ((Writer)stringWriter).write("};\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("TokenValue val2;     \t\t\t\t\n");
        String string = ((Object)stringWriter).toString();
        IFile iFile = this.importFile("UnionDeclaration.h", string);
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"*", (ICSearchConstants.SearchFor)ICSearchConstants.UNION, (ICSearchConstants.LimitTo)ICSearchConstants.DEFINITIONS, (boolean)true);
        ICElement[] iCElementArray = new ICElement[]{BaseTestFramework.cproject.getCProject()};
        Set set = this.search(iCSearchPattern, iCElementArray);
        Assert.assertEquals((int)3, (int)set.size());
        this.assertMatch(set, iFile, string.indexOf("union { //anon field"));
        this.assertMatch(set, iFile, string.indexOf("union { //anon static"));
        this.assertMatch(set, iFile, string.indexOf("TokenValue"));
    }

    public void testUnionReference() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter = new StringWriter();
        ((Writer)stringWriter).write("enum Tokentype {ID, ICONST};\t\t\n");
        ((Writer)stringWriter).write("class Token {\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("  public:\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("  Tokentype tok;\t\t\t\t\t\n");
        ((Writer)stringWriter).write("union TokenValue { \t\t\t\t\n");
        ((Writer)stringWriter).write("TokenValue (int ix) {ival = ix;}\t\n");
        ((Writer)stringWriter).write("TokenValue (char *s) {sval = s;}\t\n");
        ((Writer)stringWriter).write("TokenValue () {}  \t\t\t\t\n");
        ((Writer)stringWriter).write("\tchar *sval;\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\tint ival;\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\tdouble dval;\t\t\t\t\t\n");
        ((Writer)stringWriter).write("};\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("TokenValue val2;     \t\t\t\t\n");
        String string = ((Object)stringWriter).toString();
        this.importFile("UnionReference.h", string);
        stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#include \"UnionReference.h\"\t\t\n");
        ((Writer)stringWriter).write("union Uu{int i; double d;};\t\t\n");
        ((Writer)stringWriter).write("void f(TokenValue/*ref1*/ t){};\t\n");
        ((Writer)stringWriter).write("void g(){\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("  f(TokenValue/*ref2*/(3));\t\t\n");
        ((Writer)stringWriter).write("  char *p=\"hello\";\t\t\t\t\n");
        ((Writer)stringWriter).write("  f(p);\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("  TokenValue/*ref3*/ t=(TokenValue/*ref4*/) p;\n");
        ((Writer)stringWriter).write("}\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("Uu/*ref5*/ t;\t\t\t\t\t\n");
        String string2 = ((Object)stringWriter).toString();
        IFile iFile = this.importFile("UnionReference.cpp", string2);
        ICElement[] iCElementArray = new ICElement[]{BaseTestFramework.cproject.findElement((IPath)new Path("UnionReference.cpp"))};
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"*", (ICSearchConstants.SearchFor)ICSearchConstants.UNION, (ICSearchConstants.LimitTo)ICSearchConstants.REFERENCES, (boolean)true);
        Set set = this.search(iCSearchPattern, iCElementArray);
        Assert.assertEquals((int)5, (int)set.size());
        this.assertMatch(set, iFile, string2.indexOf("TokenValue/*ref1*/"));
        this.assertMatch(set, iFile, string2.indexOf("TokenValue/*ref2*/"));
        this.assertMatch(set, iFile, string2.indexOf("TokenValue/*ref3*/"));
        this.assertMatch(set, iFile, string2.indexOf("TokenValue/*ref4*/"));
        this.assertMatch(set, iFile, string2.indexOf("Uu/*ref5*/"));
    }

    public void testEnumerationDeclaration() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class B { \t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\tenum EE/*def2*/ {B0, B1};\t\t\t\n");
        ((Writer)stringWriter).write("  B(){\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\t\tenum EE/*def3*/ {M0, M1};\t\t\n");
        ((Writer)stringWriter).write("  }\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\tvoid foo();\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("};\t\t\t\t\t\t\t\t\t\n");
        String string = ((Object)stringWriter).toString();
        IFile iFile = this.importFile("EnumerationDeclaration.h", string);
        stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#include \"EnumerationDeclaration.h\"\t\n");
        ((Writer)stringWriter).write("void B::foo() {\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\t\tenum EE/*def4*/ {F0, F1};\t\t\n");
        ((Writer)stringWriter).write("\t\tenum EE ee;\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("};\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("void boo() {\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\t\tenum EE/*def5*/ {G0, G1};\t\t\n");
        ((Writer)stringWriter).write("};\t\t\t\t\t\t\t\t\t\n");
        String string2 = ((Object)stringWriter).toString();
        IFile iFile2 = this.importFile("EnumerationDeclaration.cpp", string2);
        ICElement[] iCElementArray = new ICElement[]{BaseTestFramework.cproject.findElement((IPath)new Path("EnumerationDeclaration.h"))};
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"EE", (ICSearchConstants.SearchFor)ICSearchConstants.ENUM, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true);
        Set set = this.search(iCSearchPattern, iCElementArray);
        Assert.assertEquals((int)2, (int)set.size());
        this.assertMatch(set, iFile, string.indexOf("EE/*def2*/"));
        this.assertMatch(set, iFile, string.indexOf("EE/*def3*/"));
        iCElementArray[0] = BaseTestFramework.cproject.findElement((IPath)new Path("EnumerationDeclaration.cpp"));
        set = this.search(iCSearchPattern, iCElementArray);
        Assert.assertEquals((int)2, (int)set.size());
        this.assertMatch(set, iFile2, string2.indexOf("EE/*def4*/"));
        this.assertMatch(set, iFile2, string2.indexOf("EE/*def5*/"));
    }

    public void testEnumerationReference() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class B { \t\t\t\t\t\n");
        ((Writer)stringWriter).write("\tenum EE {B0, B1};\t\t\t\n");
        ((Writer)stringWriter).write("  B(){\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("  }\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\tEE/*ref8*/ bee;\t\t\t\t\n");
        ((Writer)stringWriter).write("\tvoid foo();\t\t\t\t\t\n");
        ((Writer)stringWriter).write("};\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("B::EE/*ref2*/ eieio;\t\t\t\n");
        String string = ((Object)stringWriter).toString();
        IFile iFile = this.importFile("EnumerationReference.h", string);
        stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#include \"EnumerationReference.h\"\t\n");
        ((Writer)stringWriter).write("void B::foo() {\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\t\tenum EE {F0, F1};\t\t\t\t\n");
        ((Writer)stringWriter).write("\t\tenum EE/*ref3*/ ib4e;\t\t\t\n");
        ((Writer)stringWriter).write("}\t\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("void boo(B::EE/*ref4*/ e) {\t\t\t\n");
        ((Writer)stringWriter).write("\t\tenum EE {G0, G1};\t\t\t\t\n");
        ((Writer)stringWriter).write("\t\tEE/*ref6*/ i=(EE/*ref7*/)2;\t\t\n");
        ((Writer)stringWriter).write("}\t\t\t\t\t\t\t\t\t\t\n");
        String string2 = ((Object)stringWriter).toString();
        IFile iFile2 = this.importFile("EnumerationReference.cpp", string2);
        ICElement[] iCElementArray = new ICElement[]{BaseTestFramework.cproject.findElement((IPath)new Path("EnumerationReference.h"))};
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"EE", (ICSearchConstants.SearchFor)ICSearchConstants.ENUM, (ICSearchConstants.LimitTo)ICSearchConstants.REFERENCES, (boolean)true);
        Set set = this.search(iCSearchPattern, iCElementArray);
        Assert.assertEquals((int)2, (int)set.size());
        this.assertMatch(set, iFile, string.indexOf("EE/*ref2*/"));
        this.assertMatch(set, iFile, string.indexOf("EE/*ref8*/"));
        iCElementArray[0] = BaseTestFramework.cproject.findElement((IPath)new Path("EnumerationReference.cpp"));
        set = this.search(iCSearchPattern, iCElementArray);
        Assert.assertEquals((int)4, (int)set.size());
        this.assertMatch(set, iFile2, string2.indexOf("EE/*ref3*/"));
        this.assertMatch(set, iFile2, string2.indexOf("EE/*ref4*/"));
        this.assertMatch(set, iFile2, string2.indexOf("EE/*ref6*/"));
        this.assertMatch(set, iFile2, string2.indexOf("EE/*ref7*/"));
        iCSearchPattern = SearchEngine.createSearchPattern((String)"B::EE", (ICSearchConstants.SearchFor)ICSearchConstants.ENUM, (ICSearchConstants.LimitTo)ICSearchConstants.REFERENCES, (boolean)true);
        set = this.search(iCSearchPattern);
        Assert.assertEquals((int)3, (int)set.size());
        this.assertMatch(set, iFile, string.indexOf("EE/*ref2*/"));
        this.assertMatch(set, iFile, string.indexOf("EE/*ref8*/"));
        this.assertMatch(set, iFile2, string2.indexOf("EE/*ref4*/"));
    }

    public void testEnumerationReferenceGlobal() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("enum E{E0};\t\t\t\t\n");
        ((Writer)stringWriter).write("void f() { \t\t\t\t\n");
        ((Writer)stringWriter).write("\tenum E{E1};\t\t\t\t\n");
        ((Writer)stringWriter).write("   E e;\t\t\t\t\t\n");
        ((Writer)stringWriter).write("}\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("E/*ref*/ f; \t\t\t\t\n");
        String string = ((Object)stringWriter).toString();
        IFile iFile = this.importFile("EnumerationReferenceGlobal.cpp", string);
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"::E", (ICSearchConstants.SearchFor)ICSearchConstants.ENUM, (ICSearchConstants.LimitTo)ICSearchConstants.REFERENCES, (boolean)true);
        Set set = this.search(iCSearchPattern);
        Assert.assertEquals((int)1, (int)set.size());
        this.assertMatch(set, iFile, string.indexOf("E/*ref*/"));
    }

    public void testEnumeratorDeclaration() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("enum ZooLocs {ZOOANIMAL, BEAR/*decl1*/};\t\t\t\n");
        ((Writer)stringWriter).write("class Bear {\t\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("    public:\t\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\t\tenum BType{BEAR/*decl2*/, PANDA/*decl3*/};\t\n");
        ((Writer)stringWriter).write("    \tBear(ZooLocs loc = ::BEAR );\t\t\t\t\n");
        ((Writer)stringWriter).write("};\t\t\t\t\t\t\t\t\t\t\t\t\n");
        String string = ((Object)stringWriter).toString();
        IFile iFile = this.importFile("EnumeratorDeclaration.cpp", string);
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"BEAR", (ICSearchConstants.SearchFor)ICSearchConstants.ENUMTOR, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true);
        Set set = this.search(iCSearchPattern);
        Assert.assertEquals((int)2, (int)set.size());
        this.assertMatch(set, iFile, string.indexOf("BEAR/*decl1*/"));
        this.assertMatch(set, iFile, string.indexOf("BEAR/*decl2*/"));
        iCSearchPattern = SearchEngine.createSearchPattern((String)"::BEAR", (ICSearchConstants.SearchFor)ICSearchConstants.ENUMTOR, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true);
        set = this.search(iCSearchPattern);
        Assert.assertEquals((int)1, (int)set.size());
        this.assertMatch(set, iFile, string.indexOf("BEAR/*decl1*/"));
        iCSearchPattern = SearchEngine.createSearchPattern((String)"Bear::PANDA", (ICSearchConstants.SearchFor)ICSearchConstants.ENUMTOR, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true);
        set = this.search(iCSearchPattern);
        Assert.assertEquals((int)1, (int)set.size());
        this.assertMatch(set, iFile, string.indexOf("PANDA"));
    }

    public void testEnumeratorReference() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("enum ZooLocs {ZOOANIMAL, BEAR};\t\t\t\n");
        ((Writer)stringWriter).write("class Bear{\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("    public:\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\t\tenum BType {BEAR=2, PANDA};\t\t\t\n");
        ((Writer)stringWriter).write("    \tBear(ZooLocs loc = ::BEAR/*ref1*/ );\n");
        ((Writer)stringWriter).write("    protected:\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("    \tZooLocs zooArea;\t\t\t\t\t\n");
        ((Writer)stringWriter).write("};\t\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("Bear::Bear(ZooLocs loc){\t\t\t\t\t\n");
        ((Writer)stringWriter).write("    \tzooArea=::BEAR/*ref2*/;\t\t\t\t\n");
        ((Writer)stringWriter).write("    \tBEAR/*ref3*/;\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("}\t\t\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("void f(){\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write(" Bear::PANDA/*ref5*/;\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("}\t\t\t\t\t\t\t\t\t\t\t\n");
        String string = ((Object)stringWriter).toString();
        IFile iFile = this.importFile("EnumeratorReference.cpp", string);
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"BEAR", (ICSearchConstants.SearchFor)ICSearchConstants.ENUMTOR, (ICSearchConstants.LimitTo)ICSearchConstants.REFERENCES, (boolean)true);
        Set set = this.search(iCSearchPattern);
        Assert.assertEquals((int)3, (int)set.size());
        this.assertMatch(set, iFile, string.indexOf("BEAR/*ref1*/"));
        this.assertMatch(set, iFile, string.indexOf("BEAR/*ref2*/"));
        this.assertMatch(set, iFile, string.indexOf("BEAR/*ref3*/"));
        iCSearchPattern = SearchEngine.createSearchPattern((String)"Bear::PANDA", (ICSearchConstants.SearchFor)ICSearchConstants.ENUMTOR, (ICSearchConstants.LimitTo)ICSearchConstants.REFERENCES, (boolean)true);
        set = this.search(iCSearchPattern);
        Assert.assertEquals((int)1, (int)set.size());
        this.assertMatch(set, iFile, string.indexOf("PANDA/*ref5*/"));
    }

    public void testEnumeratorDeclarationCase() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("enum A {B};\t\t\t\t\n");
        ((Writer)stringWriter).write("class C {\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\t\tenum D {B0};\t\t\n");
        ((Writer)stringWriter).write("};\t\t\t\t\t\t\n");
        String string = ((Object)stringWriter).toString();
        IFile iFile = this.importFile("EnumeratorDeclarationCase.cpp", string);
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"C::B0", (ICSearchConstants.SearchFor)ICSearchConstants.ENUMTOR, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true);
        Set set = this.search(iCSearchPattern);
        Assert.assertEquals((int)1, (int)set.size());
        this.assertMatch(set, iFile, string.indexOf("B0"));
        iCSearchPattern = SearchEngine.createSearchPattern((String)"C::B0", (ICSearchConstants.SearchFor)ICSearchConstants.ENUMTOR, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)false);
        set = this.search(iCSearchPattern);
        Assert.assertEquals((int)1, (int)set.size());
        this.assertMatch(set, iFile, string.indexOf("B0"));
    }

    public void testTypedefDeclaration() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write(" class A {               \t\t\t\t\t\n");
        ((Writer)stringWriter).write("    typedef struct alpha {} beta/*decl*/;\t\n");
        ((Writer)stringWriter).write(" };                      \t\t\t\t\t\n");
        String string = ((Object)stringWriter).toString();
        IFile iFile = this.importFile("TypedefDeclaration.cpp", string);
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"beta", (ICSearchConstants.SearchFor)ICSearchConstants.TYPEDEF, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true);
        Set set = this.search(iCSearchPattern);
        Assert.assertEquals((int)1, (int)set.size());
        this.assertMatch(set, iFile, string.indexOf("beta/*decl*/"));
    }

    public void testMacroDeclaration() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#define paster/*decl1*/( n ) printf( \"token\" #n \" = %d\", token##n )\t\n");
        ((Writer)stringWriter).write("#define token9/*decl2*/ 3  \t\t\t\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("#define HELLO/*decl3*/\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("#ifdef HELLO\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write(" #define HI/*decl4*/\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("#endif\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("#ifdef GOODBYE\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write(" #define BYE/*decl5*/\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("#endif\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        String string = ((Object)stringWriter).toString();
        IFile iFile = this.importFile("MacroDeclaration.cpp", string);
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"paster", (ICSearchConstants.SearchFor)ICSearchConstants.MACRO, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true);
        Set set = this.search(iCSearchPattern);
        Assert.assertEquals((int)1, (int)set.size());
        this.assertMatch(set, iFile, string.indexOf("paster/*decl1*/"));
        iCSearchPattern = SearchEngine.createSearchPattern((String)"token9", (ICSearchConstants.SearchFor)ICSearchConstants.MACRO, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true);
        set = this.search(iCSearchPattern);
        Assert.assertEquals((int)1, (int)set.size());
        this.assertMatch(set, iFile, string.indexOf("token9/*decl2*/"));
        iCSearchPattern = SearchEngine.createSearchPattern((String)"HELLO", (ICSearchConstants.SearchFor)ICSearchConstants.MACRO, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true);
        set = this.search(iCSearchPattern);
        Assert.assertEquals((int)1, (int)set.size());
        this.assertMatch(set, iFile, string.indexOf("HELLO/*decl3*/"));
        iCSearchPattern = SearchEngine.createSearchPattern((String)"HI", (ICSearchConstants.SearchFor)ICSearchConstants.MACRO, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true);
        set = this.search(iCSearchPattern);
        Assert.assertEquals((int)1, (int)set.size());
        this.assertMatch(set, iFile, string.indexOf("HI/*decl4*"));
        iCSearchPattern = SearchEngine.createSearchPattern((String)"BYE", (ICSearchConstants.SearchFor)ICSearchConstants.MACRO, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true);
        set = this.search(iCSearchPattern);
        Assert.assertEquals((int)0, (int)set.size());
    }

    public void testMethodFieldReferenceInExpressions() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class M {\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\tpublic:\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\tint mm(){return 0;}\t\t\t\n");
        ((Writer)stringWriter).write("\tfloat fm;\t\t\t\t\t\n");
        ((Writer)stringWriter).write("};\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("class N{\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("public:\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\tdouble mn(){return 3.2;} \t\n");
        ((Writer)stringWriter).write("  static const int fn= 12;\t\n");
        ((Writer)stringWriter).write("};\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("void foo() {\t\t\t\t\t\n");
        ((Writer)stringWriter).write(" \tM m; \t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\tN *n;\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("  double i= ((double)m.mm/*11*/()+n->fn/*21*/-m.fm/*22*/\t\n");
        ((Writer)stringWriter).write("  /n->mn/*12*/())*(m.fm/*23*/*n->mn/*13*/())\t\t\t\t\n");
        ((Writer)stringWriter).write("  &&m.mm/*14*/()||(int)n->fn/*24*/\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("  &(int)n->mn/*15*/()|(int)m.fm/*25*/\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("  <<(int)n->fn/*26*/>>m.mm/*16*/(); \t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("} \t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        String string = ((Object)stringWriter).toString();
        IFile iFile = this.importFile("MethodFieldReferenceInExpressions.cpp", string);
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"m*", (ICSearchConstants.SearchFor)ICSearchConstants.METHOD, (ICSearchConstants.LimitTo)ICSearchConstants.REFERENCES, (boolean)true);
        Set set = this.search(iCSearchPattern);
        Assert.assertEquals((int)6, (int)set.size());
        this.assertMatch(set, iFile, string.indexOf("mm/*11*/"));
        this.assertMatch(set, iFile, string.indexOf("mn/*12*/"));
        this.assertMatch(set, iFile, string.indexOf("mn/*13*/"));
        this.assertMatch(set, iFile, string.indexOf("mm/*14*/"));
        this.assertMatch(set, iFile, string.indexOf("mn/*15*/"));
        this.assertMatch(set, iFile, string.indexOf("mm/*16*/"));
        iCSearchPattern = SearchEngine.createSearchPattern((String)"f*", (ICSearchConstants.SearchFor)ICSearchConstants.FIELD, (ICSearchConstants.LimitTo)ICSearchConstants.REFERENCES, (boolean)true);
        set = this.search(iCSearchPattern);
        Assert.assertEquals((int)6, (int)set.size());
        this.assertMatch(set, iFile, string.indexOf("fn/*21*/"));
        this.assertMatch(set, iFile, string.indexOf("fm/*22*/"));
        this.assertMatch(set, iFile, string.indexOf("fm/*23*/"));
        this.assertMatch(set, iFile, string.indexOf("fn/*24*/"));
        this.assertMatch(set, iFile, string.indexOf("fm/*22*/"));
        this.assertMatch(set, iFile, string.indexOf("fn/*26*/"));
    }
}

