/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.tests;

import java.io.StringWriter;
import java.io.Writer;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.IParser;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.NullLogService;
import org.eclipse.cdt.core.parser.ParserFactory;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.ScannerInfo;
import org.eclipse.cdt.core.parser.ast.IASTNode;
import org.eclipse.cdt.core.parser.ast.IASTOffsetableNamedElement;
import org.eclipse.cdt.core.parser.tests.CompleteParseBaseTest;
import org.eclipse.cdt.core.testplugin.CProjectHelper;
import org.eclipse.cdt.core.tests.BaseTestFramework;
import org.eclipse.cdt.core.tests.FailingTest;
import org.eclipse.cdt.internal.core.browser.cache.TypeCacheManager;
import org.eclipse.cdt.internal.core.index.domsourceindexer.DOMSourceIndexer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class SelectionRegressionTest
extends BaseTestFramework {
    public SelectionRegressionTest() {
    }

    public SelectionRegressionTest(String string) {
        super(string);
    }

    public static Test suite() {
        return SelectionRegressionTest.suite(true);
    }

    public static Test suite(boolean bl) {
        TestSuite testSuite = new TestSuite("SelectionRegressionTests");
        testSuite.addTest((Test)new SelectionRegressionTest("testSimpleOpenDeclaration"));
        testSuite.addTest((Test)new SelectionRegressionTest("testClass"));
        testSuite.addTest((Test)new SelectionRegressionTest("testClassRHS"));
        testSuite.addTest((Test)new SelectionRegressionTest("testStruct"));
        testSuite.addTest((Test)new SelectionRegressionTest("testStructRHS"));
        testSuite.addTest((Test)new SelectionRegressionTest("testEnumeration"));
        testSuite.addTest((Test)new SelectionRegressionTest("testEnumerationArg"));
        testSuite.addTest((Test)new SelectionRegressionTest("testEnumerator"));
        testSuite.addTest((Test)new SelectionRegressionTest("testMethod"));
        testSuite.addTest((Test)new FailingTest((Test)new SelectionRegressionTest("testMethodRHS78656"), 78656));
        testSuite.addTest((Test)new FailingTest((Test)new SelectionRegressionTest("testMethod78114"), 78114));
        testSuite.addTest((Test)new SelectionRegressionTest("testMethod78118"));
        testSuite.addTest((Test)new FailingTest((Test)new SelectionRegressionTest("testOverloadedMethod78389"), 78389));
        testSuite.addTest((Test)new FailingTest((Test)new SelectionRegressionTest("testConstructor78625"), 78625));
        testSuite.addTest((Test)new SelectionRegressionTest("testClassField"));
        testSuite.addTest((Test)new SelectionRegressionTest("testStructField"));
        testSuite.addTest((Test)new SelectionRegressionTest("testNamespace"));
        testSuite.addTest((Test)new SelectionRegressionTest("testNamespace77989"));
        testSuite.addTest((Test)new SelectionRegressionTest("testFunction"));
        testSuite.addTest((Test)new SelectionRegressionTest("testFunctionArg"));
        testSuite.addTest((Test)new FailingTest((Test)new SelectionRegressionTest("testFunctionArg78435"), 78435));
        testSuite.addTest((Test)new SelectionRegressionTest("testVariable"));
        testSuite.addTest((Test)new SelectionRegressionTest("testVariableStruct"));
        testSuite.addTest((Test)new SelectionRegressionTest("testVariableArg"));
        testSuite.addTest((Test)new FailingTest((Test)new SelectionRegressionTest("testVariableArg77996"), 77996));
        testSuite.addTest((Test)new FailingTest((Test)new SelectionRegressionTest("testVariable77996"), 77996));
        testSuite.addTest((Test)new SelectionRegressionTest("testUnion"));
        if (bl) {
            testSuite.addTest((Test)new SelectionRegressionTest("cleanupProject"));
        }
        return testSuite;
    }

    protected void setUp() throws Exception {
        super.setUp();
        try {
            if (BaseTestFramework.project == null) {
                BaseTestFramework.cproject = CProjectHelper.createCCProject("RegressionTestProject", "bin");
                BaseTestFramework.project = BaseTestFramework.cproject.getProject();
            }
        }
        catch (CoreException coreException) {}
        TypeCacheManager typeCacheManager = TypeCacheManager.getInstance();
        typeCacheManager.setProcessTypeCacheEvents(false);
    }

    protected void tearDown() throws Exception {
        if (BaseTestFramework.project == null || !BaseTestFramework.project.exists()) {
            return;
        }
        try {
            BaseTestFramework.project.setSessionProperty(DOMSourceIndexer.activationKey, (Object)new Boolean(false));
            BaseTestFramework.project.delete(true, true, (IProgressMonitor)new NullProgressMonitor());
            BaseTestFramework.project = null;
        }
        catch (CoreException coreException) {}
        super.tearDown();
    }

    protected IASTNode getSelection(IFile iFile, int n, int n2) throws Exception {
        return this.getSelection(iFile, n, n2, ParserLanguage.CPP);
    }

    protected IASTNode getSelection(IFile iFile, int n, int n2, ParserLanguage parserLanguage) throws Exception {
        CompleteParseBaseTest.FullParseCallback fullParseCallback = new CompleteParseBaseTest.FullParseCallback();
        IParser iParser = ParserFactory.createParser((IScanner)ParserFactory.createScanner((CodeReader)new CodeReader(iFile.getLocation().toOSString(), iFile.getContents()), (IScannerInfo)new ScannerInfo(), (ParserMode)ParserMode.SELECTION_PARSE, (ParserLanguage)ParserLanguage.CPP, (ISourceElementRequestor)fullParseCallback, (IParserLogService)new NullLogService(), null), (ISourceElementRequestor)fullParseCallback, (ParserMode)ParserMode.SELECTION_PARSE, (ParserLanguage)ParserLanguage.CPP, (IParserLogService)ParserFactory.createDefaultLogService());
        IParser.ISelectionParseResult iSelectionParseResult = iParser.parse(n, n2);
        return (IASTNode)(iSelectionParseResult != null ? iSelectionParseResult.getOffsetableNamedElement() : null);
    }

    protected void assertNodeLocation(IASTNode iASTNode, IFile iFile, int n) throws Exception {
        if (iASTNode != null && iASTNode instanceof IASTOffsetableNamedElement) {
            IASTOffsetableNamedElement iASTOffsetableNamedElement = (IASTOffsetableNamedElement)iASTNode;
            Assert.assertEquals((String)iFile.getLocation().toOSString(), (String)new String(iASTOffsetableNamedElement.getFilename()));
            Assert.assertEquals((int)n, (int)iASTOffsetableNamedElement.getNameOffset());
            return;
        }
        Assert.fail((String)("Node not found in " + iFile.getLocation().toOSString() + " offset " + n));
    }

    protected void assertNodeNull(IASTNode iASTNode) throws Exception {
        if (iASTNode == null) {
            return;
        }
        if (iASTNode instanceof IASTOffsetableNamedElement) {
            IASTOffsetableNamedElement iASTOffsetableNamedElement = (IASTOffsetableNamedElement)iASTNode;
            Assert.fail((String)("node found at " + new String(iASTOffsetableNamedElement.getFilename()) + " offset " + iASTOffsetableNamedElement.getNameOffset()));
            return;
        }
        Assert.fail((String)"Node found when none expected.");
    }

    public void testSimpleOpenDeclaration() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class A{};           \n");
        String string = ((Object)stringWriter).toString();
        IFile iFile = this.importFile("a.h", string);
        stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#include \"a.h\"       \n");
        ((Writer)stringWriter).write("void f(){              \n");
        ((Writer)stringWriter).write("   A a;                \n");
        ((Writer)stringWriter).write("}                      \n");
        String string2 = ((Object)stringWriter).toString();
        IFile iFile2 = this.importFile("a.cpp", string2);
        int n = string2.indexOf("A");
        IASTNode iASTNode = this.getSelection(iFile2, n, n + 1);
        this.assertNodeLocation(iASTNode, iFile, string.indexOf("A"));
    }

    public void testClass() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class A{};           \t\t\n");
        ((Writer)stringWriter).write("namespace N {           \t\n");
        ((Writer)stringWriter).write("  class B {       \t\t\n");
        ((Writer)stringWriter).write("     class C{};       \t\n");
        ((Writer)stringWriter).write("  };\t\t\t     \t\t\n");
        ((Writer)stringWriter).write("}\t\t\t     \t\t\t\n");
        String string = ((Object)stringWriter).toString();
        IFile iFile = this.importFile("a.h", string);
        stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#include \"a.h\"       \t\n");
        ((Writer)stringWriter).write("A/*vp1*/ a;              \n");
        ((Writer)stringWriter).write("N::B/*vp2*/ b;           \n");
        ((Writer)stringWriter).write("using namespace N;       \n");
        ((Writer)stringWriter).write("B::C/*vp3*/ c;           \n");
        String string2 = ((Object)stringWriter).toString();
        IFile iFile2 = this.importFile("a.cpp", string2);
        int n = string2.indexOf("A/*vp1*/");
        IASTNode iASTNode = this.getSelection(iFile2, n, n + 1);
        this.assertNodeLocation(iASTNode, iFile, string.indexOf("A"));
        n = string2.indexOf("N::B/*vp2*/");
        iASTNode = this.getSelection(iFile2, n, n + 4);
        this.assertNodeLocation(iASTNode, iFile, string.indexOf("B"));
        n = string2.indexOf("C/*vp3*/");
        iASTNode = this.getSelection(iFile2, n, n + 1);
        this.assertNodeLocation(iASTNode, iFile, string.indexOf("C"));
    }

    public void testClassRHS() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class A{           \t\t\n");
        ((Writer)stringWriter).write("  enum{E0};        \t\t\n");
        ((Writer)stringWriter).write("};           \t\t\t\t\n");
        String string = ((Object)stringWriter).toString();
        IFile iFile = this.importFile("a.h", string);
        stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#include \"a.h\"       \t\n");
        ((Writer)stringWriter).write("int a=A::E0;             \n");
        String string2 = ((Object)stringWriter).toString();
        IFile iFile2 = this.importFile("a.cpp", string2);
        int n = string2.indexOf("A");
        IASTNode iASTNode = this.getSelection(iFile2, n, n + 1);
        this.assertNodeLocation(iASTNode, iFile, string.indexOf("A"));
    }

    public void testStruct() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("struct A{};//vp1\t\t    \n");
        ((Writer)stringWriter).write("class B{           \t\t\n");
        ((Writer)stringWriter).write("  public: struct C{};     \n");
        ((Writer)stringWriter).write("};           \t\t\t\t\n");
        ((Writer)stringWriter).write("namespace N{           \t\n");
        ((Writer)stringWriter).write("  struct A{};//vp3\t\t\n");
        ((Writer)stringWriter).write("  struct D{};           \t\n");
        ((Writer)stringWriter).write("};           \t\t\t\t\n");
        String string = ((Object)stringWriter).toString();
        IFile iFile = this.importFile("a.h", string);
        stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#include \"a.h\"       \t\n");
        ((Writer)stringWriter).write("void f(){              \t\n");
        ((Writer)stringWriter).write("   A a;//vp1             \n");
        ((Writer)stringWriter).write("   B::C d;//vp2          \n");
        ((Writer)stringWriter).write("   N::A e;//vp3          \n");
        ((Writer)stringWriter).write("   using namespace N;    \n");
        ((Writer)stringWriter).write("   A/*vp4*/ f;           \n");
        ((Writer)stringWriter).write("}                      \t\n");
        String string2 = ((Object)stringWriter).toString();
        IFile iFile2 = this.importFile("a.cpp", string2);
        int n = string2.indexOf("A a;//vp1");
        IASTNode iASTNode = this.getSelection(iFile2, n, n + 1);
        this.assertNodeLocation(iASTNode, iFile, string.indexOf("A{};//vp1"));
        n = string2.indexOf("C");
        iASTNode = this.getSelection(iFile2, n, n + 1);
        this.assertNodeLocation(iASTNode, iFile, string.indexOf("C"));
        n = string2.indexOf("N::A");
        iASTNode = this.getSelection(iFile2, n, n + 4);
        this.assertNodeLocation(iASTNode, iFile, string.indexOf("A{};//vp3"));
        n = string2.indexOf("A/*vp4*/");
        iASTNode = this.getSelection(iFile2, n, n + 1);
        this.assertNodeNull(iASTNode);
    }

    public void testStructRHS() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("struct A{\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write(" static const float pi=3.14;  \n");
        ((Writer)stringWriter).write("};\t\t\t\t\t\t\t\n");
        String string = ((Object)stringWriter).toString();
        IFile iFile = this.importFile("a.h", string);
        stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#include \"a.h\"       \n");
        ((Writer)stringWriter).write("void f(){              \n");
        ((Writer)stringWriter).write("   float f=A::pi;      \n");
        ((Writer)stringWriter).write("}                      \n");
        String string2 = ((Object)stringWriter).toString();
        IFile iFile2 = this.importFile("a.cpp", string2);
        int n = string2.indexOf("A");
        IASTNode iASTNode = this.getSelection(iFile2, n, n + 1);
        this.assertNodeLocation(iASTNode, iFile, string.indexOf("A"));
    }

    public void testEnumeration() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("enum A{};           \t\n");
        ((Writer)stringWriter).write("class B{      \t\t\n");
        ((Writer)stringWriter).write(" public:\t\t        \n");
        ((Writer)stringWriter).write(" enum C {enum2};      \n");
        ((Writer)stringWriter).write(" void boo();\t\t\t\n");
        ((Writer)stringWriter).write("};           \t\t\t\n");
        String string = ((Object)stringWriter).toString();
        IFile iFile = this.importFile("a.h", string);
        stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#include \"a.h\"      \n");
        ((Writer)stringWriter).write("void f(){             \n");
        ((Writer)stringWriter).write("   A/*vp1*/ a;        \n");
        ((Writer)stringWriter).write("   B::C/*vp2*/ c;     \n");
        ((Writer)stringWriter).write("}                     \n");
        String string2 = ((Object)stringWriter).toString();
        IFile iFile2 = this.importFile("a.cpp", string2);
        int n = string2.indexOf("A");
        IASTNode iASTNode = this.getSelection(iFile2, n, n + 1);
        this.assertNodeLocation(iASTNode, iFile, string.indexOf("A"));
        n = string2.indexOf("B::C");
        iASTNode = this.getSelection(iFile2, n, n + 4);
        this.assertNodeLocation(iASTNode, iFile, string.indexOf("C"));
    }

    public void testEnumerationArg() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("enum A{};              \n");
        String string = ((Object)stringWriter).toString();
        IFile iFile = this.importFile("a.h", string);
        stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#include \"a.h\"      \n");
        ((Writer)stringWriter).write("void f(A a){};        \n");
        String string2 = ((Object)stringWriter).toString();
        IFile iFile2 = this.importFile("a.cpp", string2);
        int n = string2.indexOf("A");
        IASTNode iASTNode = this.getSelection(iFile2, n, n + 1);
        this.assertNodeLocation(iASTNode, iFile, string.indexOf("A"));
    }

    public void testEnumerator() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("enum A{enum1};           \n");
        ((Writer)stringWriter).write("class B{      \t\t   \n");
        ((Writer)stringWriter).write(" public:\t\t           \n");
        ((Writer)stringWriter).write(" enum {enum2};           \n");
        ((Writer)stringWriter).write(" enum {enum3} f1;        \n");
        ((Writer)stringWriter).write(" void boo();\t\t\t   \n");
        ((Writer)stringWriter).write("};           \t\t\t   \n");
        String string = ((Object)stringWriter).toString();
        IFile iFile = this.importFile("a.h", string);
        stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#include \"a.h\"        \n");
        ((Writer)stringWriter).write("void f(){               \n");
        ((Writer)stringWriter).write("   A a;                 \n");
        ((Writer)stringWriter).write("   a=enum1;//vp1        \n");
        ((Writer)stringWriter).write("   int i=B::enum2;//vp2 \n");
        ((Writer)stringWriter).write("}                   \t   \n");
        ((Writer)stringWriter).write("void B::boo() {         \n");
        ((Writer)stringWriter).write("   f1=enum3;//vp3       \n");
        ((Writer)stringWriter).write("}                       \n");
        String string2 = ((Object)stringWriter).toString();
        IFile iFile2 = this.importFile("a.cpp", string2);
        int n = string2.indexOf("enum1");
        IASTNode iASTNode = this.getSelection(iFile2, n, n + 5);
        this.assertNodeLocation(iASTNode, iFile, string.indexOf("enum1"));
        n = string2.indexOf("enum2");
        iASTNode = this.getSelection(iFile2, n, n + 5);
        this.assertNodeLocation(iASTNode, iFile, string.indexOf("enum2"));
        n = string2.indexOf("enum3");
        iASTNode = this.getSelection(iFile2, n, n + 5);
        this.assertNodeLocation(iASTNode, iFile, string.indexOf("enum3"));
    }

    public void testMethod() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class A{           \t\t\t\n");
        ((Writer)stringWriter).write("int method1(){}           \t\n");
        ((Writer)stringWriter).write("static const int method2();   \n");
        ((Writer)stringWriter).write("}           \t\t\t\t\t\n");
        String string = ((Object)stringWriter).toString();
        IFile iFile = this.importFile("a.h", string);
        stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#include \"a.h\"       \t\t\n");
        ((Writer)stringWriter).write("void f(){              \t\t\n");
        ((Writer)stringWriter).write("   A a;                \t\t\n");
        ((Writer)stringWriter).write("   a.method1();//vp1        \t\n");
        ((Writer)stringWriter).write("   A *b=new A();       \t\t\n");
        ((Writer)stringWriter).write("   b->method1();//vp2       \t\n");
        ((Writer)stringWriter).write("   A::method2();//vp3       \t\n");
        ((Writer)stringWriter).write("}                       \t\t\n");
        String string2 = ((Object)stringWriter).toString();
        IFile iFile2 = this.importFile("a.cpp", string2);
        int n = string2.indexOf("method1();//vp1");
        IASTNode iASTNode = this.getSelection(iFile2, n, n + 7);
        this.assertNodeLocation(iASTNode, iFile, string.indexOf("method1"));
        n = string2.indexOf("method1();//vp2");
        iASTNode = this.getSelection(iFile2, n, n + 7);
        this.assertNodeLocation(iASTNode, iFile, string.indexOf("method1"));
        n = string2.indexOf("method2();//vp3");
        iASTNode = this.getSelection(iFile2, n, n + 7);
        this.assertNodeLocation(iASTNode, iFile, string.indexOf("method2"));
    }

    public void testMethodRHS78656() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class A{           \t\t\t\n");
        ((Writer)stringWriter).write("int method1(){}           \t\t\n");
        ((Writer)stringWriter).write("}           \t\t\t\t\t\n");
        String string = ((Object)stringWriter).toString();
        IFile iFile = this.importFile("a.h", string);
        stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#include \"a.h\"       \t\t\n");
        ((Writer)stringWriter).write("void f(){              \t\t\n");
        ((Writer)stringWriter).write("   A a;                \t\t\n");
        ((Writer)stringWriter).write("   int i=a.method1();//vp1        \t\n");
        ((Writer)stringWriter).write("}                       \t\t\n");
        String string2 = ((Object)stringWriter).toString();
        IFile iFile2 = this.importFile("a.cpp", string2);
        int n = string2.indexOf("method1();//vp1");
        IASTNode iASTNode = this.getSelection(iFile2, n, n + 7);
        this.assertNodeLocation(iASTNode, iFile, string.indexOf("method1"));
    }

    public void testMethod78114() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class Point{           \t\n");
        ((Writer)stringWriter).write(" public:            \t\t\n");
        ((Writer)stringWriter).write(" Point(): xCoord(0){}     \n");
        ((Writer)stringWriter).write(" private: int xCoord;     \n");
        ((Writer)stringWriter).write("}\t\t\t\t\t\t\t\n");
        String string = ((Object)stringWriter).toString();
        IFile iFile = this.importFile("a.h", string);
        stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#include \"a.h\"       \t\t\t\n");
        ((Writer)stringWriter).write("void f(){              \t\t\t\n");
        ((Writer)stringWriter).write("   Point &p2 = *(new Point());   \n");
        ((Writer)stringWriter).write("}                       \t\t\t\n");
        String string2 = ((Object)stringWriter).toString();
        IFile iFile2 = this.importFile("a.cpp", string2);
        int n = string2.indexOf("Point()");
        IASTNode iASTNode = this.getSelection(iFile2, n, n + 5);
        this.assertNodeLocation(iASTNode, iFile, string.indexOf("Point()"));
    }

    public void testMethod78118() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class Point{           \t\t\t\n");
        ((Writer)stringWriter).write(" public:            \t\t\t\t\n");
        ((Writer)stringWriter).write(" Point(): xCoord(0){}           \t\n");
        ((Writer)stringWriter).write(" Point& operator=(const Point &rhs){return *this};  \n");
        ((Writer)stringWriter).write("};\t\t\t\t\t\t\t\t\n");
        String string = ((Object)stringWriter).toString();
        IFile iFile = this.importFile("a.h", string);
        stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#include \"a.h\"       \t\t\t\n");
        ((Writer)stringWriter).write("void f(){              \t\t\t\n");
        ((Writer)stringWriter).write("   Point a;                \t\t\n");
        ((Writer)stringWriter).write("   const Point zero;        \t\t\n");
        ((Writer)stringWriter).write("   a.operator=(zero);//vp1       \n");
        ((Writer)stringWriter).write("}                       \t\t\t\n");
        String string2 = ((Object)stringWriter).toString();
        IFile iFile2 = this.importFile("a.cpp", string2);
        int n = string2.indexOf("operator=");
        IASTNode iASTNode = this.getSelection(iFile2, n, n + 9);
        this.assertNodeLocation(iASTNode, iFile, string.indexOf("operator="));
    }

    public void testOverloadedMethod78389() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class Point{           \t\t\t\n");
        ((Writer)stringWriter).write(" public:            \t\t\t\t\n");
        ((Writer)stringWriter).write(" void method1(){}         \t\t\n");
        ((Writer)stringWriter).write(" void method1(int i){}          \t\n");
        ((Writer)stringWriter).write("};\t\t\t\t\t\t\t\t\n");
        String string = ((Object)stringWriter).toString();
        IFile iFile = this.importFile("a.h", string);
        stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#include \"a.h\"       \t\t\t\n");
        ((Writer)stringWriter).write("void f(){              \t\t\t\n");
        ((Writer)stringWriter).write("   Point a;                \t\t\n");
        ((Writer)stringWriter).write("   a.method1(3);        \t\t\t\n");
        ((Writer)stringWriter).write("}                       \t\t\t\n");
        String string2 = ((Object)stringWriter).toString();
        IFile iFile2 = this.importFile("a.cpp", string2);
        int n = string2.indexOf("method1");
        IASTNode iASTNode = this.getSelection(iFile2, n, n + 7);
        this.assertNodeLocation(iASTNode, iFile, string.indexOf("method1(int i)"));
    }

    public void testConstructor78625() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class Mammal {\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\tpublic:\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\tMammal(bool b): isCarnivore(b){}\t\n");
        ((Writer)stringWriter).write("\tprivate:\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\tbool isCarnivore;\t\t\t\t\t\n");
        ((Writer)stringWriter).write("};\t\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("class Bear : Mammal{\t\t\t\t\t\n");
        ((Writer)stringWriter).write("public:\t\t\t\t\t\t\t\t\n");
        ((Writer)stringWriter).write("\tBear(int s): Mammal(true){}//vp1 \t\n");
        ((Writer)stringWriter).write("};\t\t\t\t\t\t\t\t\t\n");
        String string = ((Object)stringWriter).toString();
        IFile iFile = this.importFile("a.cpp", string);
        int n = string.indexOf("Mammal(true)");
        IASTNode iASTNode = this.getSelection(iFile, n, n + 6);
        this.assertNodeLocation(iASTNode, iFile, string.indexOf("Mammal(bool b)"));
    }

    public void testClassField() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class A{;          \t\t\n");
        ((Writer)stringWriter).write("int bee;           \t\t\n");
        ((Writer)stringWriter).write("};         \t\t\t\t\n");
        String string = ((Object)stringWriter).toString();
        IFile iFile = this.importFile("a.h", string);
        stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#include \"a.h\"       \t\n");
        ((Writer)stringWriter).write("void f(){              \t\n");
        ((Writer)stringWriter).write("   A *a=new A();         \n");
        ((Writer)stringWriter).write("   a->bee;//vp1          \n");
        ((Writer)stringWriter).write("   A b;                \t\n");
        ((Writer)stringWriter).write("   b.bee;//vp2           \n");
        ((Writer)stringWriter).write("}                      \t\n");
        String string2 = ((Object)stringWriter).toString();
        IFile iFile2 = this.importFile("a.cpp", string2);
        int n = string2.indexOf("bee;//vp1");
        IASTNode iASTNode = this.getSelection(iFile2, n, n + 3);
        this.assertNodeLocation(iASTNode, iFile, string.indexOf("bee"));
        n = string2.indexOf("bee;//vp2");
        iASTNode = this.getSelection(iFile2, n, n + 3);
        this.assertNodeLocation(iASTNode, iFile, string.indexOf("bee"));
    }

    public void testStructField() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("namespace N{           \t\n");
        ((Writer)stringWriter).write("struct A{          \t\t\n");
        ((Writer)stringWriter).write("int bee;           \t\t\n");
        ((Writer)stringWriter).write("};         \t\t\t\t\n");
        ((Writer)stringWriter).write("}         \t\t\t\t\n");
        String string = ((Object)stringWriter).toString();
        IFile iFile = this.importFile("a.h", string);
        stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#include \"a.h\"       \t\n");
        ((Writer)stringWriter).write("void f(){              \t\n");
        ((Writer)stringWriter).write("   N::A *a;              \n");
        ((Writer)stringWriter).write("   a->bee;//vp1          \n");
        ((Writer)stringWriter).write("   using namespace N;    \n");
        ((Writer)stringWriter).write("   A b;                \t\n");
        ((Writer)stringWriter).write("   b.bee;//vp2           \n");
        ((Writer)stringWriter).write("}                      \t\n");
        String string2 = ((Object)stringWriter).toString();
        IFile iFile2 = this.importFile("a.cpp", string2);
        int n = string2.indexOf("bee;//vp1");
        IASTNode iASTNode = this.getSelection(iFile2, n, n + 3);
        this.assertNodeLocation(iASTNode, iFile, string.indexOf("bee"));
        n = string2.indexOf("bee;//vp2");
        iASTNode = this.getSelection(iFile2, n, n + 3);
        this.assertNodeLocation(iASTNode, iFile, string.indexOf("bee"));
    }

    public void testNamespace() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("namespace N{           \t\n");
        ((Writer)stringWriter).write("class A{};           \t\t\n");
        ((Writer)stringWriter).write("}           \t\t\t\t\n");
        String string = ((Object)stringWriter).toString();
        IFile iFile = this.importFile("a.h", string);
        stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#include \"a.h\"       \t\n");
        ((Writer)stringWriter).write("void f(){              \t\n");
        ((Writer)stringWriter).write("   N::A a;               \n");
        ((Writer)stringWriter).write("}                      \t\n");
        String string2 = ((Object)stringWriter).toString();
        IFile iFile2 = this.importFile("a.cpp", string2);
        int n = string2.indexOf("N::A a;");
        IASTNode iASTNode = this.getSelection(iFile2, n, n + 1);
        this.assertNodeLocation(iASTNode, iFile, string.indexOf("N"));
    }

    public void testNamespace77989() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("namespace N{           \t\n");
        ((Writer)stringWriter).write("class A{};           \t\t\n");
        ((Writer)stringWriter).write("}           \t\t\t\t\n");
        String string = ((Object)stringWriter).toString();
        IFile iFile = this.importFile("a.h", string);
        stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#include \"a.h\"       \t\n");
        ((Writer)stringWriter).write("void f(){              \t\n");
        ((Writer)stringWriter).write("   using namespace N;//vp1  \n");
        ((Writer)stringWriter).write("}                      \t\n");
        String string2 = ((Object)stringWriter).toString();
        IFile iFile2 = this.importFile("a.cpp", string2);
        int n = string2.indexOf("N;//vp1");
        IASTNode iASTNode = this.getSelection(iFile2, n, n + 1);
        this.assertNodeLocation(iASTNode, iFile, string.indexOf("N"));
    }

    public void testFunction() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("namespace N{           \t\n");
        ((Writer)stringWriter).write("char *foo(){}          \t\n");
        ((Writer)stringWriter).write("}          \t\t\t\t\n");
        String string = ((Object)stringWriter).toString();
        IFile iFile = this.importFile("a.h", string);
        stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#include \"a.h\"       \t\n");
        ((Writer)stringWriter).write("void f(){              \t\n");
        ((Writer)stringWriter).write("   N::foo();//vp1        \n");
        ((Writer)stringWriter).write("   char* x = N::foo();//vp2  \n");
        ((Writer)stringWriter).write("}                      \t\n");
        String string2 = ((Object)stringWriter).toString();
        IFile iFile2 = this.importFile("a.cpp", string2);
        int n = string2.indexOf("foo();//vp1");
        IASTNode iASTNode = this.getSelection(iFile2, n, n + 3);
        this.assertNodeLocation(iASTNode, iFile, string.indexOf("foo"));
        n = string2.indexOf("N::foo();//vp2");
        iASTNode = this.getSelection(iFile2, n, n + 6);
        this.assertNodeLocation(iASTNode, iFile, string.indexOf("foo"));
    }

    public void testFunctionArg() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("double f(double){return 2.0;};          \n");
        ((Writer)stringWriter).write("double g(double){return 2.0;};          \n");
        String string = ((Object)stringWriter).toString();
        IFile iFile = this.importFile("a.h", string);
        stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#include \"a.h\"       \n");
        ((Writer)stringWriter).write("double sum_sq(double (*foo)(double), double d){}              \n");
        ((Writer)stringWriter).write("void hi() {double x = sum_sq(g,g(3.2));}              \n");
        String string2 = ((Object)stringWriter).toString();
        IFile iFile2 = this.importFile("a.cpp", string2);
        int n = string2.indexOf("g,g(3.2)");
        IASTNode iASTNode = this.getSelection(iFile2, n, n + 1);
        this.assertNodeLocation(iASTNode, iFile, string.indexOf("g"));
        n = string2.indexOf("g(3.2)");
        iASTNode = this.getSelection(iFile2, n, n + 1);
        this.assertNodeLocation(iASTNode, iFile, string.indexOf("g"));
    }

    public void testFunctionArg78435() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("double sum_sq(double (*foo)/*vp1*/(double), double d){}    \n");
        String string = ((Object)stringWriter).toString();
        IFile iFile = this.importFile("a.cpp", string);
        int n = string.indexOf("foo");
        IASTNode iASTNode = this.getSelection(iFile, n, n + 3);
        this.assertNodeLocation(iASTNode, iFile, string.indexOf("foo"));
    }

    public void testVariable() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("char* a_pc=\"hello\";           \t\n");
        ((Writer)stringWriter).write("union B{int x; char y;} b_u;      \n");
        String string = ((Object)stringWriter).toString();
        IFile iFile = this.importFile("a.h", string);
        stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#include \"a.h\"       \t\t\t\n");
        ((Writer)stringWriter).write("void f(){              \t\t\t\n");
        ((Writer)stringWriter).write("   int s=(sizeof(a_pc));//vp1    \n");
        ((Writer)stringWriter).write("   b_u=3;                \t\t\n");
        ((Writer)stringWriter).write("}                      \t\t\t\n");
        String string2 = ((Object)stringWriter).toString();
        IFile iFile2 = this.importFile("a.cpp", string2);
        int n = string2.indexOf("a_pc");
        IASTNode iASTNode = this.getSelection(iFile2, n, n + 4);
        this.assertNodeLocation(iASTNode, iFile, string.indexOf("a_pc"));
        n = string2.indexOf("b_u");
        iASTNode = this.getSelection(iFile2, n, n + 3);
        this.assertNodeLocation(iASTNode, iFile, string.indexOf("b_u"));
    }

    public void testVariableArg78435() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("int aa;       \t\t\t\t\t\n");
        ((Writer)stringWriter).write("void f(int aa){}              \t\n");
        String string = ((Object)stringWriter).toString();
        IFile iFile = this.importFile("a.cpp", string);
        int n = string.indexOf("aa");
        IASTNode iASTNode = this.getSelection(iFile, n, n + 2);
        this.assertNodeLocation(iASTNode, iFile, string.indexOf("aa){}"));
    }

    public void testVariableStruct() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("struct C {int i;};      \n");
        ((Writer)stringWriter).write("C c;              \t  \n");
        String string = ((Object)stringWriter).toString();
        IFile iFile = this.importFile("a.h", string);
        stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#include \"a.h\"       \n");
        ((Writer)stringWriter).write("void f(){              \n");
        ((Writer)stringWriter).write("   c.i/*vp1*/=3;       \n");
        ((Writer)stringWriter).write("}                      \n");
        String string2 = ((Object)stringWriter).toString();
        IFile iFile2 = this.importFile("a.cpp", string2);
        int n = string2.indexOf("c.i/*vp1*/");
        IASTNode iASTNode = this.getSelection(iFile2, n, n + 1);
        this.assertNodeLocation(iASTNode, iFile, string.indexOf("c;"));
    }

    public void testVariableArg() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("int aa=3;              \n");
        ((Writer)stringWriter).write("void f(int aa){//decl  \n");
        ((Writer)stringWriter).write("  int bb=aa;//vp1      \n");
        ((Writer)stringWriter).write("}                      \n");
        String string = ((Object)stringWriter).toString();
        IFile iFile = this.importFile("a.cpp", string);
        int n = string.indexOf("aa;");
        IASTNode iASTNode = this.getSelection(iFile, n, n + 2);
        this.assertNodeLocation(iASTNode, iFile, string.indexOf("aa){//decl"));
    }

    public void testVariableClass77996() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class C {public: int i;};           \n");
        String string = ((Object)stringWriter).toString();
        this.importFile("a.h", string);
        stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#include \"a.h\"       \n");
        ((Writer)stringWriter).write("void f(){              \n");
        ((Writer)stringWriter).write("  C c;              \t  \n");
        ((Writer)stringWriter).write("  c.i/*vp1*/=3;        \n");
        ((Writer)stringWriter).write("}                      \n");
        String string2 = ((Object)stringWriter).toString();
        IFile iFile = this.importFile("a.cpp", string2);
        int n = string2.indexOf("c.i/*vp1*/");
        IASTNode iASTNode = this.getSelection(iFile, n, n + 1);
        this.assertNodeLocation(iASTNode, iFile, string2.indexOf("c;"));
    }

    public void testUnion() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("union A{};           \t\n");
        ((Writer)stringWriter).write("class B{           \t\n");
        ((Writer)stringWriter).write(" union C{} c;         \n");
        ((Writer)stringWriter).write("}           \t\t\t\n");
        String string = ((Object)stringWriter).toString();
        IFile iFile = this.importFile("a.h", string);
        stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#include \"a.h\"     \n");
        ((Writer)stringWriter).write("void f(){            \n");
        ((Writer)stringWriter).write("   A a;  //vp1       \n");
        ((Writer)stringWriter).write("   B::C c; //vp2     \n");
        ((Writer)stringWriter).write("}                    \n");
        String string2 = ((Object)stringWriter).toString();
        IFile iFile2 = this.importFile("a.cpp", string2);
        int n = string2.indexOf("A");
        IASTNode iASTNode = this.getSelection(iFile2, n, n + 1);
        this.assertNodeLocation(iASTNode, iFile, string.indexOf("A"));
        n = string2.indexOf("B::C");
        iASTNode = this.getSelection(iFile2, n, n + 4);
        this.assertNodeLocation(iASTNode, iFile, string.indexOf("C"));
    }
}

