/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.core.tests;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.ListIterator;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.cdt.managedbuilder.core.IAdditionalInput;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IInputType;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IOutputType;
import org.eclipse.cdt.managedbuilder.core.IResourceConfiguration;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.Tool;
import org.eclipse.cdt.managedbuilder.internal.core.ToolChain;
import org.eclipse.cdt.managedbuilder.projectconverter.UpdateManagedProjectManager;
import org.eclipse.cdt.managedbuilder.testplugin.CTestPlugin;
import org.eclipse.cdt.managedbuilder.testplugin.ManagedBuildTestHelper;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.ui.dialogs.IOverwriteQuery;

public class ManagedProject30MakefileTests
extends TestCase {
    public static final String MBS_TEMP_DIR = "MBSTemp";
    static boolean pathVariableCreated = false;
    static /* synthetic */ Class class$0;

    public ManagedProject30MakefileTests(String string) {
        super(string);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.managedbuilder.core.tests.ManagedProject30MakefileTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite testSuite = new TestSuite(clazz.getName());
        testSuite.addTest((Test)new ManagedProject30MakefileTests("test30SingleFileExe"));
        testSuite.addTest((Test)new ManagedProject30MakefileTests("test30TwoFileSO"));
        testSuite.addTest((Test)new ManagedProject30MakefileTests("test30MultiResConfig"));
        testSuite.addTest((Test)new ManagedProject30MakefileTests("test30LinkedLib"));
        testSuite.addTest((Test)new ManagedProject30MakefileTests("test30CopyandDeploy"));
        testSuite.addTest((Test)new ManagedProject30MakefileTests("test30DeleteFile"));
        testSuite.addTest((Test)new ManagedProject30MakefileTests("test30NoFilesToBuild"));
        testSuite.addTest((Test)new ManagedProject30MakefileTests("testFileWithNoExtension"));
        testSuite.addTest((Test)new ManagedProject30MakefileTests("testPreAndPostProcessBuildSteps"));
        testSuite.addTest((Test)new ManagedProject30MakefileTests("testResourceCustomBuildStep"));
        testSuite.addTest((Test)new ManagedProject30MakefileTests("test30_1"));
        testSuite.addTest((Test)new ManagedProject30MakefileTests("test30_2"));
        testSuite.addTest((Test)new ManagedProject30MakefileTests("testTopTC"));
        return testSuite;
    }

    private IProject[] createProject(String string, IPath iPath, String string2, boolean bl) {
        ArrayList<IProject> arrayList = null;
        if (bl) {
            File file = CTestPlugin.getFileInPlugin((IPath)new Path("resources/test30Projects/" + string));
            if (file == null) {
                Assert.fail((String)("Test project directory " + string + " is missing."));
                return null;
            }
            File[] fileArray = file.listFiles(new FileFilter(){

                public boolean accept(File file) {
                    return !file.isDirectory();
                }
            });
            arrayList = new ArrayList(fileArray.length);
            int n = 0;
            while (n < fileArray.length) {
                try {
                    IProject iProject;
                    String string3 = fileArray[n].getName();
                    if (string3.endsWith(".zip") && (string3 = string3.substring(0, string3.length() - ".zip".length())).length() != 0 && (iProject = ManagedBuildTestHelper.createProject(string3, fileArray[n], iPath, string2)) != null) {
                        arrayList.add(iProject);
                    }
                }
                catch (Exception exception) {}
                ++n;
            }
            if (arrayList.size() == 0) {
                Assert.fail((String)("No projects found in test project directory " + file.getName() + ".  The .zip file may be missing or corrupt."));
                return null;
            }
        } else {
            try {
                IProject iProject = ManagedBuildTestHelper.createProject(string, null, iPath, string2);
                if (iProject != null) {
                    arrayList = new ArrayList<IProject>(1);
                }
                arrayList.add(iProject);
            }
            catch (Exception exception) {}
        }
        return arrayList.toArray(new IProject[arrayList.size()]);
    }

    private IProject[] createProjects(String string, IPath iPath, String string2, boolean bl) {
        IOverwriteQuery iOverwriteQuery = new IOverwriteQuery(){

            public String queryOverwrite(String string) {
                return "ALL";
            }
        };
        new IOverwriteQuery(){

            public String queryOverwrite(String string) {
                return "NOALL";
            }
        };
        UpdateManagedProjectManager.setBackupFileOverwriteQuery((IOverwriteQuery)iOverwriteQuery);
        UpdateManagedProjectManager.setUpdateProjectQuery((IOverwriteQuery)iOverwriteQuery);
        IProject[] iProjectArray = this.createProject(string, iPath, string2, bl);
        return iProjectArray;
    }

    private void buildProjectsWorker(IProject[] iProjectArray, IPath[] iPathArray, boolean bl) {
        if (iProjectArray == null || iProjectArray.length == 0) {
            return;
        }
        boolean bl2 = true;
        int n = 0;
        while (n < iProjectArray.length) {
            IProject iProject = iProjectArray[n];
            IManagedBuildInfo iManagedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)iProject);
            boolean bl3 = UpdateManagedProjectManager.isCompatibleProject((IManagedBuildInfo)iManagedBuildInfo);
            Assert.assertTrue((boolean)bl3);
            if (bl3) {
                try {
                    iProject.build(10, null);
                }
                catch (CoreException coreException) {
                    Assert.fail((String)coreException.getStatus().getMessage());
                }
                catch (OperationCanceledException operationCanceledException) {
                    Assert.fail((String)("the project \"" + iProject.getName() + "\" build was cancelled, exception message: " + operationCanceledException.getMessage()));
                }
                if (iPathArray != null && iPathArray.length > 0 && n == 0) {
                    String string = iManagedBuildInfo.getDefaultConfiguration().getName();
                    IPath iPath = Path.fromOSString((String)string);
                    bl2 = bl ? ManagedBuildTestHelper.compareBenchmarks(iProject, iPath, iPathArray) : ManagedBuildTestHelper.verifyFilesDoNotExist(iProject, iPath, iPathArray);
                }
            }
            ++n;
        }
        if (bl2) {
            n = 0;
            while (n < iProjectArray.length) {
                ManagedBuildTestHelper.removeProject(iProjectArray[n].getName());
                ++n;
            }
        }
    }

    private void buildProjects(IProject[] iProjectArray, IPath[] iPathArray) {
        this.buildProjectsWorker(iProjectArray, iPathArray, true);
    }

    private void buildDegenerativeProjects(IProject[] iProjectArray, IPath[] iPathArray) {
        this.buildProjectsWorker(iProjectArray, iPathArray, false);
    }

    private void createPathVariable(IPath iPath) {
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        iWorkspace = ResourcesPlugin.getWorkspace();
        IPathVariableManager iPathVariableManager = iWorkspace.getPathVariableManager();
        String string = MBS_TEMP_DIR;
        try {
            if (iPathVariableManager.validateName(string).isOK() && iPathVariableManager.validateValue(iPath).isOK()) {
                iPathVariableManager.setValue(string, iPath);
                Assert.assertTrue((boolean)iPathVariableManager.isDefined(string));
            } else {
                Assert.fail((String)("could not create the path variable " + string));
            }
        }
        catch (Exception exception) {
            Assert.fail((String)("could not create the path variable " + string));
        }
    }

    private void createFileLink(IProject iProject, IPath iPath, String string, String string2) {
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        String string3 = MBS_TEMP_DIR;
        if (!pathVariableCreated) {
            this.createPathVariable(iPath);
            pathVariableCreated = true;
        }
        try {
            IFile iFile = iProject.getFile(string);
            Path path = new Path("MBSTemp/" + string2);
            if (iWorkspace.validateLinkLocation((IResource)iFile, (IPath)path).isOK()) {
                iFile.createLink((IPath)path, 0, null);
            } else {
                Assert.fail((String)("could not create the link to " + string3));
            }
        }
        catch (Exception exception) {
            Assert.fail((String)("could not create the link to " + string3));
        }
    }

    public void test30SingleFileExe() {
        IPath[] iPathArray = new IPath[]{Path.fromOSString((String)"makefile"), Path.fromOSString((String)"objects.mk"), Path.fromOSString((String)"sources.mk"), Path.fromOSString((String)"subdir.mk")};
        IProject[] iProjectArray = this.createProjects("singleFileExe", null, null, true);
        this.buildProjects(iProjectArray, iPathArray);
    }

    public void test30TwoFileSO() {
        IPath[] iPathArray = new IPath[]{Path.fromOSString((String)"makefile"), Path.fromOSString((String)"objects.mk"), Path.fromOSString((String)"sources.mk"), Path.fromOSString((String)"subdir.mk")};
        IProject[] iProjectArray = this.createProjects("twoFileSO", null, null, true);
        this.buildProjects(iProjectArray, iPathArray);
    }

    public void test30MultiResConfig() {
        IPath[] iPathArray = new IPath[]{Path.fromOSString((String)"makefile"), Path.fromOSString((String)"objects.mk"), Path.fromOSString((String)"sources.mk"), Path.fromOSString((String)"subdir.mk"), Path.fromOSString((String)"source1/subdir.mk"), Path.fromOSString((String)"source2/subdir.mk"), Path.fromOSString((String)"source2/source21/subdir.mk")};
        IProject[] iProjectArray = this.createProjects("multiResConfig", null, null, true);
        this.buildProjects(iProjectArray, iPathArray);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void test30LinkedLib() {
        IPath[] iPathArray = new IPath[]{Path.fromOSString((String)"makefile"), Path.fromOSString((String)"objects.mk"), Path.fromOSString((String)"sources.mk")};
        IPath[] iPathArray2 = new IPath[]{Path.fromOSString((String)"f1.c"), Path.fromOSString((String)"f2.c"), Path.fromOSString((String)"test_ar.h")};
        File file = CTestPlugin.getFileInPlugin((IPath)new Path("resources/test30Projects/linkedLib/"));
        IPath iPath = Path.fromOSString((String)file.toString());
        IPath iPath2 = Path.fromOSString((String)"CDTMBSTest");
        IPath iPath3 = ManagedBuildTestHelper.copyFilesToTempDir(iPath, iPath2, iPathArray2);
        try {
            IProject[] iProjectArray = this.createProjects("linkedLib", null, "cdt.managedbuild.target.gnu30.lib", true);
            IProject iProject = iProjectArray[0];
            this.createFileLink(iProject, iPath3, "f1.c", "f1.c");
            this.createFileLink(iProject, iPath3, "f2link.c", "f2.c");
            this.createFileLink(iProject, iPath3, "test_ar.h", "test_ar.h");
            this.buildProjects(iProjectArray, iPathArray);
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            ManagedBuildTestHelper.deleteTempDir(iPath2, iPathArray2);
            throw throwable;
        }
        {
            Object var9_11 = null;
        }
        ManagedBuildTestHelper.deleteTempDir(iPath2, iPathArray2);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void test30LinkedFolder() {
        IPath[] iPathArray = new IPath[]{Path.fromOSString((String)"makefile"), Path.fromOSString((String)"objects.mk"), Path.fromOSString((String)"subdir.mk"), Path.fromOSString((String)"sources.mk")};
        IPath[] iPathArray2 = new IPath[]{Path.fromOSString((String)"f1.c"), Path.fromOSString((String)"f2.c"), Path.fromOSString((String)"test_ar.h"), Path.fromOSString((String)"Benchmarks/makefile"), Path.fromOSString((String)"Benchmarks/objects.mk"), Path.fromOSString((String)"Benchmarks/subdir.mk"), Path.fromOSString((String)"Benchmarks/sources.mk")};
        File file = CTestPlugin.getFileInPlugin((IPath)new Path("resources/test30Projects/linkedFolder/"));
        IPath iPath = Path.fromOSString((String)file.toString());
        IPath iPath2 = Path.fromOSString((String)"CDTMBSTest");
        IPath iPath3 = ManagedBuildTestHelper.copyFilesToTempDir(iPath, iPath2, iPathArray2);
        if (!pathVariableCreated) {
            this.createPathVariable(iPath3);
            pathVariableCreated = true;
        }
        try {
            IPath iPath4 = Path.fromOSString((String)MBS_TEMP_DIR);
            IProject[] iProjectArray = this.createProjects("linkedFolder", iPath4, "cdt.managedbuild.target.gnu30.lib", false);
            this.buildProjects(iProjectArray, iPathArray);
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            ManagedBuildTestHelper.deleteTempDir(iPath2, iPathArray2);
            throw throwable;
        }
        {
            Object var9_11 = null;
        }
        ManagedBuildTestHelper.deleteTempDir(iPath2, iPathArray2);
    }

    public void test30CopyandDeploy() {
        IPath[] iPathArray = new IPath[]{Path.fromOSString((String)"makefile"), Path.fromOSString((String)"objects.mk"), Path.fromOSString((String)"sources.mk"), Path.fromOSString((String)"subdir.mk"), Path.fromOSString((String)"Functions/subdir.mk")};
        IProject[] iProjectArray = this.createProjects("copyandDeploy", null, null, true);
        this.buildProjects(iProjectArray, iPathArray);
    }

    public void test30DeleteFile() {
        IPath[] iPathArray = new IPath[]{Path.fromOSString((String)"makefile"), Path.fromOSString((String)"objects.mk"), Path.fromOSString((String)"subdir.mk"), Path.fromOSString((String)"sources.mk")};
        IProject[] iProjectArray = this.createProjects("deleteFile", null, null, true);
        final IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        ArrayList<IFile> arrayList = new ArrayList<IFile>(1);
        IProject iProject = iProjectArray[0];
        IFile iFile = iProject.getFile("filetobedeleted.cxx");
        arrayList.add(iFile);
        final IResource[] iResourceArray = arrayList.toArray(new IResource[arrayList.size()]);
        IWorkspaceRunnable iWorkspaceRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                iWorkspace.delete(iResourceArray, false, null);
            }
        };
        try {
            NullProgressMonitor nullProgressMonitor = new NullProgressMonitor();
            iWorkspace.run(iWorkspaceRunnable, (ISchedulingRule)iWorkspace.getRoot(), 1, (IProgressMonitor)nullProgressMonitor);
        }
        catch (Exception exception) {
            Assert.fail((String)("could not delete file in project " + iProject.getName()));
        }
        this.buildProjects(iProjectArray, iPathArray);
    }

    public void test30NoFilesToBuild() {
        IPath[] iPathArray = new IPath[]{Path.fromOSString((String)"makefile"), Path.fromOSString((String)"objects.mk"), Path.fromOSString((String)"subdir.mk"), Path.fromOSString((String)"sources.mk")};
        IProject[] iProjectArray = this.createProjects("noFilesToBuild", null, null, true);
        IProject iProject = iProjectArray[0];
        IFile iFile = iProject.getFile("filetobeexcluded.cxx");
        IManagedBuildInfo iManagedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)iProject);
        IConfiguration iConfiguration = iManagedBuildInfo.getDefaultConfiguration();
        IResourceConfiguration iResourceConfiguration = iConfiguration.createResourceConfiguration(iFile);
        iResourceConfiguration.setExclude(true);
        this.buildDegenerativeProjects(iProjectArray, iPathArray);
    }

    public void testFileWithNoExtension() {
        IPath[] iPathArray = new IPath[]{Path.fromOSString((String)"makefile"), Path.fromOSString((String)"objects.mk"), Path.fromOSString((String)"sources.mk"), Path.fromOSString((String)"subdir.mk")};
        IProject[] iProjectArray = this.createProjects("testFileWithNoExtension", null, null, true);
        this.buildProjects(iProjectArray, iPathArray);
    }

    public void testPreAndPostProcessBuildSteps() {
        IPath[] iPathArray = new IPath[]{Path.fromOSString((String)"makefile"), Path.fromOSString((String)"objects.mk"), Path.fromOSString((String)"subdir.mk"), Path.fromOSString((String)"sources.mk")};
        IProject[] iProjectArray = this.createProjects("preAndPostBuildSteps", null, null, true);
        IProject iProject = iProjectArray[0];
        IManagedBuildInfo iManagedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)iProject);
        IConfiguration iConfiguration = iManagedBuildInfo.getDefaultConfiguration();
        iProject.getFile("main.cxx");
        iConfiguration.setPreannouncebuildStep("Pre-announce Build Step");
        iConfiguration.setPrebuildStep("echo 'executing Pre-Build Step' ");
        iConfiguration.setPostannouncebuildStep("Post-announce Build Step");
        iConfiguration.setPostbuildStep("echo 'executing Post-Build Step' ");
        this.buildProjects(iProjectArray, iPathArray);
    }

    public void testResourceCustomBuildStep() {
        IPath[] iPathArray = new IPath[]{Path.fromOSString((String)"makefile"), Path.fromOSString((String)"objects.mk"), Path.fromOSString((String)"subdir.mk"), Path.fromOSString((String)"sources.mk")};
        IProject[] iProjectArray = this.createProjects("rcbsBasicTest", null, null, true);
        IProject iProject = iProjectArray[0];
        IManagedBuildInfo iManagedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)iProject);
        IConfiguration iConfiguration = iManagedBuildInfo.getDefaultConfiguration();
        IFile iFile = iProject.getFile("rcbsBasicTest.c");
        IResourceConfiguration iResourceConfiguration = iConfiguration.createResourceConfiguration(iFile);
        ITool iTool = iResourceConfiguration.createTool(null, "rcbsBasicTestTool", "rcbs Basic Test Tool", false);
        IInputType iInputType = iTool.createInputType(null, "rcbsToolInputTypeId", "rcbsToolInputTypeName", false);
        IAdditionalInput iAdditionalInput = iInputType.createAdditionalInput("");
        iAdditionalInput.setKind(3);
        IOutputType iOutputType = iTool.createOutputType(null, "rcbsToolOutputTypeId", "rcbsToolOutputTypeName", false);
        iOutputType.setOutputNames("rcbsBasicTest.o");
        iTool.setCustomBuildStep(true);
        iTool.setToolCommand("gcc -g -c ../rcbsBasicTest.c -o ./rcbsBasicTest.o");
        iTool.setAnnouncement("Now executing custom build step for rcbsBasicTest debug config");
        iResourceConfiguration.setRcbsApplicability(1);
        this.buildProjects(iProjectArray, iPathArray);
    }

    public void test30_1() {
        IPath[] iPathArray = new IPath[]{Path.fromOSString((String)"makefile"), Path.fromOSString((String)"objects.mk"), Path.fromOSString((String)"sources.mk"), Path.fromOSString((String)"subdir.mk")};
        IProject[] iProjectArray = this.createProjects("test30_1", null, null, true);
        this.buildProjects(iProjectArray, iPathArray);
    }

    public void test30_2() {
        IPath[] iPathArray = new IPath[]{Path.fromOSString((String)"makefile"), Path.fromOSString((String)"objects.mk"), Path.fromOSString((String)"sources.mk"), Path.fromOSString((String)"subdir.mk")};
        IProject[] iProjectArray = this.createProjects("test30_2", null, null, true);
        this.buildProjects(iProjectArray, iPathArray);
    }

    public void testTopTC() {
        IProject[] iProjectArray = this.createProjects("TopTC", null, "TopTC.target.exe", false);
        Assert.assertNotNull((Object)iProjectArray);
        Assert.assertEquals((int)1, (int)iProjectArray.length);
        IProject iProject = iProjectArray[0];
        IManagedBuildInfo iManagedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)iProject);
        Assert.assertNotNull((Object)iManagedBuildInfo);
        IManagedProject iManagedProject = iManagedBuildInfo.getManagedProject();
        Assert.assertNotNull((Object)iManagedProject);
        IConfiguration[] iConfigurationArray = iManagedProject.getConfigurations();
        Assert.assertNotNull((Object)iConfigurationArray);
        Assert.assertEquals((int)2, (int)iConfigurationArray.length);
        int n = 0;
        while (n < iConfigurationArray.length) {
            IConfiguration iConfiguration = iConfigurationArray[n];
            ToolChain toolChain = (ToolChain)iConfiguration.getToolChain();
            ListIterator listIterator = toolChain.getToolList().listIterator();
            int n2 = 0;
            while (listIterator.hasNext()) {
                Tool cfr_ignored_0 = (Tool)listIterator.next();
                ++n2;
            }
            Assert.assertEquals((int)5, (int)n2);
            ++n;
        }
        this.buildDegenerativeProjects(iProjectArray, null);
    }
}

