/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.testplugin;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.zip.ZipFile;
import junit.framework.Assert;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.core.ManagedCProjectNature;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedBuildInfo;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;
import org.eclipse.ui.wizards.datatransfer.ZipFileStructureProvider;

public class ManagedBuildTestHelper {
    public static IProject createProject(String string, IPath iPath, String string2, String string3) throws CoreException {
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        final IProject iProject = iWorkspaceRoot.getProject(string);
        IProject iProject2 = null;
        if (!iProject.exists()) {
            IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
            if (string2.equals(ManagedBuilderCorePlugin.MANAGED_MAKE_PROJECT_ID)) {
                ManagedBuildTestHelper.createNewManagedProject(iProject, string, iPath, string2, string3);
                iProject2 = iProject;
            } else {
                IWorkspaceDescription iWorkspaceDescription = iWorkspace.getDescription();
                iWorkspaceDescription.setAutoBuilding(false);
                iWorkspace.setDescription(iWorkspaceDescription);
                IProjectDescription iProjectDescription = iWorkspace.newProjectDescription(iProject.getName());
                iProject2 = CCorePlugin.getDefault().createCProject(iProjectDescription, iProject, (IProgressMonitor)new NullProgressMonitor(), MakeCorePlugin.MAKE_PROJECT_ID);
            }
        } else {
            ResourcesPlugin.getWorkspace();
            new IWorkspaceRunnable(){

                public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                    iProject.refreshLocal(2, iProgressMonitor);
                }
            };
            new NullProgressMonitor();
            iProject2 = iProject;
        }
        if (!iProject2.isOpen()) {
            iProject2.open((IProgressMonitor)new NullProgressMonitor());
        }
        return iProject2;
    }

    public static void removeProject(String string) {
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        final IProject iProject = iWorkspaceRoot.getProject(string);
        if (iProject.exists()) {
            IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
            IWorkspaceRunnable iWorkspaceRunnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                    System.gc();
                    System.runFinalization();
                    iProject.delete(true, true, null);
                }
            };
            NullProgressMonitor nullProgressMonitor = new NullProgressMonitor();
            try {
                iWorkspace.run(iWorkspaceRunnable, (ISchedulingRule)iWorkspaceRoot, 1, (IProgressMonitor)nullProgressMonitor);
            }
            catch (CoreException coreException) {
                Assert.assertTrue((boolean)false);
            }
        }
    }

    public static IProject createProject(String string, File file, IPath iPath, String string2) throws CoreException, InvocationTargetException, IOException {
        IPath iPath2;
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject iProject = iWorkspaceRoot.getProject(string);
        if (iProject.exists()) {
            ManagedBuildTestHelper.removeProject(string);
        }
        IPath iPath3 = iPath2 = iPath != null ? iPath : iProject.getFullPath();
        if (file != null) {
            ManagedBuildTestHelper.importFilesFromZip(new ZipFile(file), iPath2, null);
        }
        return ManagedBuildTestHelper.createProject(string, iPath, ManagedBuilderCorePlugin.MANAGED_MAKE_PROJECT_ID, string2);
    }

    public static void importFilesFromZip(ZipFile zipFile, IPath iPath, IProgressMonitor iProgressMonitor) throws InvocationTargetException {
        ZipFileStructureProvider zipFileStructureProvider = new ZipFileStructureProvider(zipFile);
        try {
            ImportOperation importOperation = new ImportOperation(iPath, (Object)zipFileStructureProvider.getRoot(), (IImportStructureProvider)zipFileStructureProvider, new IOverwriteQuery(){

                public String queryOverwrite(String string) {
                    return "ALL";
                }
            });
            importOperation.run(iProgressMonitor);
        }
        catch (InterruptedException interruptedException) {
            Assert.assertTrue((boolean)false);
        }
    }

    public static IProject createNewManagedProject(IProject iProject, String string, final IPath iPath, final String string2, final String string3) throws CoreException {
        final IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot iWorkspaceRoot = iWorkspace.getRoot();
        final IProject iProject2 = iProject;
        IWorkspaceRunnable iWorkspaceRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                IWorkspaceDescription iWorkspaceDescription = iWorkspace.getDescription();
                iWorkspaceDescription.setAutoBuilding(false);
                iWorkspace.setDescription(iWorkspaceDescription);
                IProjectDescription iProjectDescription = iWorkspace.newProjectDescription(iProject2.getName());
                if (iPath != null) {
                    iProjectDescription.setLocation(iPath);
                }
                CCorePlugin.getDefault().createCProject(iProjectDescription, iProject2, (IProgressMonitor)new NullProgressMonitor(), string2);
                ManagedBuildTestHelper.addManagedBuildNature(iProject2);
                ManagedBuildManager.getDefinedProjectTypes();
                IProjectType iProjectType = ManagedBuildManager.getProjectType((String)string3);
                Assert.assertNotNull((Object)iProjectType);
                IManagedProject iManagedProject = null;
                try {
                    iManagedProject = ManagedBuildManager.createManagedProject((IResource)iProject2, (IProjectType)iProjectType);
                }
                catch (Exception exception) {
                    Assert.fail((String)("Failed to create managed project for: " + iProject2.getName()));
                }
                Assert.assertEquals((String)iManagedProject.getName(), (String)iProjectType.getName());
                Assert.assertFalse((boolean)iManagedProject.equals(iProjectType));
                ManagedBuildManager.setNewProjectVersion((IProject)iProject2);
                IConfiguration iConfiguration = null;
                IConfiguration[] iConfigurationArray = iProjectType.getConfigurations();
                int n = 0;
                while (n < iConfigurationArray.length) {
                    if (n == 0) {
                        iConfiguration = iManagedProject.createConfiguration(iConfigurationArray[n], String.valueOf(iProjectType.getId()) + "." + n);
                    } else {
                        iManagedProject.createConfiguration(iConfigurationArray[n], String.valueOf(iProjectType.getId()) + "." + n);
                    }
                    ++n;
                }
                ManagedBuildManager.setDefaultConfiguration((IProject)iProject2, iConfiguration);
            }
        };
        NullProgressMonitor nullProgressMonitor = new NullProgressMonitor();
        try {
            iWorkspace.run(iWorkspaceRunnable, (ISchedulingRule)iWorkspaceRoot, 1, (IProgressMonitor)nullProgressMonitor);
        }
        catch (CoreException coreException) {
            Assert.assertTrue((boolean)false);
        }
        IStatus iStatus = ManagedBuildManager.initBuildInfoContainer((IResource)iProject2);
        if (iStatus.getCode() != 0) {
            Assert.fail((String)("Initializing build information failed for: " + iProject2.getName() + " because: " + iStatus.getMessage()));
        }
        return iProject2;
    }

    public static void addManagedBuildNature(IProject iProject) {
        ManagedBuildInfo managedBuildInfo = ManagedBuildManager.createBuildInfo((IResource)iProject);
        managedBuildInfo.setValid(true);
        try {
            ManagedCProjectNature.addManagedNature((IProject)iProject, (IProgressMonitor)new NullProgressMonitor());
            ManagedCProjectNature.addManagedBuilder((IProject)iProject, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException coreException) {
            Assert.fail((String)("Test failed on adding managed build nature or builder: " + coreException.getLocalizedMessage()));
        }
        ICDescriptor iCDescriptor = null;
        try {
            iCDescriptor = CCorePlugin.getDefault().getCProjectDescription(iProject, true);
            iCDescriptor.remove("org.eclipse.cdt.core.ScannerInfoProvider");
            iCDescriptor.create("org.eclipse.cdt.core.ScannerInfoProvider", ManagedBuildManager.INTERFACE_IDENTITY);
        }
        catch (CoreException coreException) {
            Assert.fail((String)("Test failed on adding managed builder as scanner info provider: " + coreException.getLocalizedMessage()));
        }
        try {
            iCDescriptor.saveProjectData();
        }
        catch (CoreException coreException) {
            Assert.fail((String)("Test failed on saving the ICDescriptor data: " + coreException.getLocalizedMessage()));
        }
    }

    public static boolean compareBenchmarks(final IProject iProject, IPath iPath, IPath[] iPathArray) {
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRunnable iWorkspaceRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                iProject.refreshLocal(2, iProgressMonitor);
            }
        };
        try {
            NullProgressMonitor nullProgressMonitor = new NullProgressMonitor();
            iWorkspace.run(iWorkspaceRunnable, (ISchedulingRule)iWorkspace.getRoot(), 1, (IProgressMonitor)nullProgressMonitor);
        }
        catch (Exception exception) {
            Assert.fail((String)("File " + iPathArray[0].lastSegment() + " - project refresh failed."));
        }
        int n = 0;
        while (n < iPathArray.length) {
            IPath iPath2 = iPath.append(iPathArray[n]);
            IPath iPath3 = Path.fromOSString((String)("Benchmarks/" + iPathArray[n]));
            StringBuffer stringBuffer = ManagedBuildTestHelper.readContentsStripLineEnds(iProject, iPath2);
            StringBuffer stringBuffer2 = ManagedBuildTestHelper.readContentsStripLineEnds(iProject, iPath3);
            if (!stringBuffer.toString().equals(stringBuffer2.toString())) {
                Assert.fail((String)("File " + iPath2.lastSegment() + " does not match its benchmark."));
            }
            ++n;
        }
        return true;
    }

    public static boolean verifyFilesDoNotExist(final IProject iProject, IPath iPath, IPath[] iPathArray) {
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRunnable iWorkspaceRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                iProject.refreshLocal(2, iProgressMonitor);
            }
        };
        try {
            NullProgressMonitor nullProgressMonitor = new NullProgressMonitor();
            iWorkspace.run(iWorkspaceRunnable, (ISchedulingRule)iWorkspace.getRoot(), 1, (IProgressMonitor)nullProgressMonitor);
        }
        catch (Exception exception) {
            Assert.fail((String)("File " + iPathArray[0].lastSegment() + " - project refresh failed."));
        }
        int n = 0;
        while (n < iPathArray.length) {
            IPath iPath2 = iPath.append(iPathArray[n]);
            IPath iPath3 = iProject.getLocation().append(iPath2);
            try {
                if (iPath3.toFile().exists()) {
                    Assert.fail((String)("File " + iPath2.lastSegment() + " unexpectedly found."));
                    return false;
                }
            }
            catch (Exception exception) {
                Assert.fail((String)("File " + iPath3.toString() + " could not be referenced."));
            }
            ++n;
        }
        return true;
    }

    public static StringBuffer readContentsStripLineEnds(IProject iProject, IPath iPath) {
        StringBuffer stringBuffer = new StringBuffer();
        IPath iPath2 = iProject.getLocation().append(iPath);
        try {
            int n;
            FileReader fileReader = null;
            try {
                fileReader = new FileReader(iPath2.toFile());
            }
            catch (Exception exception) {
                Assert.fail((String)("File " + iPath2.toString() + " could not be read."));
            }
            while ((n = fileReader.read()) != -1) {
                if (n != 13 && n != 10) {
                    stringBuffer.append((char)n);
                }
                if (n != -1) continue;
            }
            fileReader.close();
        }
        catch (Exception exception) {
            Assert.fail((String)("File " + iPath2.toString() + " could not be read."));
        }
        return stringBuffer;
    }

    public static IPath copyFilesToTempDir(IPath iPath, IPath iPath2, IPath[] iPathArray) {
        IPath iPath3 = null;
        String string = System.getProperty("user.home");
        if (string != null) {
            IPath iPath4 = Path.fromOSString((String)string);
            iPath3 = iPath4.append(iPath2);
            if (iPath4.toString().equalsIgnoreCase(iPath3.toString())) {
                Assert.fail((String)"Temporary sub-directory cannot be the empty string.");
            } else {
                boolean bl;
                File file = iPath3.toFile();
                if (file.exists()) {
                    if (iPath3.lastSegment().equals(iPath2.lastSegment())) {
                        ManagedBuildTestHelper.deleteDirectory(file);
                    } else {
                        Assert.fail((String)("Temporary directory " + file.toString() + " already exists."));
                    }
                }
                if (bl = file.mkdir()) {
                    int n = 0;
                    while (n < iPathArray.length) {
                        Object object;
                        IPath iPath5;
                        IPath iPath6 = iPathArray[n];
                        IPath iPath7 = iPath.append(iPath6);
                        FileReader fileReader = null;
                        try {
                            fileReader = new FileReader(iPath7.toFile());
                        }
                        catch (Exception exception) {
                            Assert.fail((String)("File " + iPath6.toString() + " could not be read."));
                        }
                        if (iPath6.segmentCount() > 1) {
                            iPath5 = iPath3;
                            do {
                                object = iPath6.uptoSegment(1);
                                iPath5 = iPath5.append((IPath)object);
                                iPath6 = iPath6.removeFirstSegments(1);
                                bl = iPath5.toFile().mkdir();
                            } while (iPath6.segmentCount() > 1);
                        }
                        iPath5 = iPath3.append(iPathArray[n]);
                        object = null;
                        try {
                            object = new FileWriter(iPath5.toFile());
                        }
                        catch (Exception exception) {
                            Assert.fail((String)("File " + iPathArray[n].toString() + " could not be written."));
                        }
                        try {
                            int n2;
                            while ((n2 = fileReader.read()) != -1) {
                                ((OutputStreamWriter)object).write(n2);
                                if (n2 != -1) continue;
                            }
                            fileReader.close();
                            ((OutputStreamWriter)object).close();
                        }
                        catch (Exception exception) {
                            Assert.fail((String)("File " + iPath6.toString() + " could not be copied."));
                        }
                        ++n;
                    }
                }
            }
        }
        return iPath3;
    }

    public static void deleteTempDir(IPath iPath, IPath[] iPathArray) {
        IPath iPath2 = null;
        String string = System.getProperty("user.home");
        if (string != null) {
            IPath iPath3 = Path.fromOSString((String)string);
            iPath2 = iPath3.append(iPath);
            if (iPath3.toString().equalsIgnoreCase(iPath2.toString())) {
                Assert.fail((String)"Temporary sub-directory cannot be the empty string.");
            } else {
                File file = iPath2.toFile();
                if (!file.exists()) {
                    Assert.fail((String)("Temporary directory " + file.toString() + " does not exist."));
                } else {
                    int n = 0;
                    while (n < iPathArray.length) {
                        IPath iPath4 = iPath2.append(iPathArray[n]);
                        iPath4.toFile().delete();
                        ++n;
                    }
                    file.delete();
                }
            }
        }
    }

    private static void deleteDirectory(File file) {
        File[] fileArray = file.listFiles();
        int n = 0;
        while (n < fileArray.length) {
            File file2 = fileArray[n];
            if (file2.isDirectory()) {
                ManagedBuildTestHelper.deleteDirectory(file2);
            }
            file2.delete();
            ++n;
        }
        file.delete();
    }
}

