/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.standardbuilder.core.tests;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.eclipse.cdt.core.CCProjectNature;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.MakeProjectNature;
import org.eclipse.cdt.make.core.scannerconfig.ScannerConfigNature;
import org.eclipse.cdt.make.internal.core.scannerconfig2.PerProjectSICollector;
import org.eclipse.cdt.managedbuilder.testplugin.ManagedBuildTestHelper;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class ScannerConfigDiscoveryTests
extends TestCase {
    private IProject fCProject = null;
    private IFile fCFile = null;
    IProgressMonitor fMonitor = null;

    public ScannerConfigDiscoveryTests(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        this.fMonitor = new NullProgressMonitor();
        this.fCProject = ManagedBuildTestHelper.createProject("SCD", null, MakeCorePlugin.MAKE_PROJECT_ID, null);
        this.fCFile = this.fCProject.getProject().getFile("main.c");
        if (!this.fCFile.exists()) {
            this.fCFile.create((InputStream)new ByteArrayInputStream(" \n".getBytes()), false, this.fMonitor);
        }
    }

    protected void tearDown() throws Exception {
        ManagedBuildTestHelper.removeProject("SCDC");
    }

    public void testGetCCompilerBuiltins() throws CoreException {
        MakeProjectNature.addNature((IProject)this.fCProject, (IProgressMonitor)this.fMonitor);
        ScannerConfigNature.addScannerConfigNature((IProject)this.fCProject);
        PerProjectSICollector.calculateCompilerBuiltins((IProject)this.fCProject);
        IScannerInfo iScannerInfo = CCorePlugin.getDefault().getScannerInfoProvider(this.fCProject).getScannerInformation((IResource)this.fCFile);
        Assert.assertNotNull((Object)iScannerInfo);
        String[] stringArray = iScannerInfo.getIncludePaths();
        Assert.assertTrue((stringArray.length > 0 ? 1 : 0) != 0);
        Map map = iScannerInfo.getDefinedSymbols();
        Assert.assertFalse((boolean)map.isEmpty());
    }

    public void testGetCCCompilerBuiltins() throws CoreException {
        CCProjectNature.addCCNature((IProject)this.fCProject, (IProgressMonitor)this.fMonitor);
        MakeProjectNature.addNature((IProject)this.fCProject, (IProgressMonitor)this.fMonitor);
        ScannerConfigNature.addScannerConfigNature((IProject)this.fCProject);
        PerProjectSICollector.calculateCompilerBuiltins((IProject)this.fCProject);
        IScannerInfo iScannerInfo = CCorePlugin.getDefault().getScannerInfoProvider(this.fCProject).getScannerInformation((IResource)this.fCFile);
        Assert.assertNotNull((Object)iScannerInfo);
        String[] stringArray = iScannerInfo.getIncludePaths();
        Assert.assertTrue((stringArray.length > 0 ? 1 : 0) != 0);
        Map map = iScannerInfo.getDefinedSymbols();
        Assert.assertFalse((boolean)map.isEmpty());
    }
}

