/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.internal.ui.actions;

import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDISession;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.mi.core.MIPlugin;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.SharedLibraryManager;
import org.eclipse.cdt.debug.mi.core.cdi.model.Target;
import org.eclipse.cdt.debug.mi.internal.ui.actions.ActionMessages;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;

public class SetAutoSolibActionDelegate
implements IViewActionDelegate,
ISelectionListener,
IPartListener {
    private IViewPart fView = null;
    private IAction fAction;
    private IStatus fStatus = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void init(IViewPart view) {
        this.fView = view;
        view.getSite().getPage().addPartListener((IPartListener)this);
        view.getSite().getPage().addSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (part.getSite().getId().equals("org.eclipse.debug.ui.DebugView")) {
            this.update(this.getAction());
        }
    }

    public void run(IAction action) {
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            public void run() {
                try {
                    SetAutoSolibActionDelegate.this.doAction(DebugUITools.getDebugContext());
                    SetAutoSolibActionDelegate.this.setStatus(null);
                }
                catch (DebugException e) {
                    SetAutoSolibActionDelegate.this.setStatus(e.getStatus());
                }
            }
        });
        if (this.getStatus() != null && !this.getStatus().isOK()) {
            IWorkbenchWindow window = CDebugUIPlugin.getActiveWorkbenchWindow();
            if (window != null) {
                CDebugUIPlugin.errorDialog((String)this.getErrorDialogMessage(), (IStatus)this.getStatus());
            } else {
                CDebugUIPlugin.log((IStatus)this.getStatus());
            }
        }
        this.update(action);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.setAction(action);
        if (this.getView() != null) {
            this.update(action);
        }
    }

    protected void update(IAction action) {
        if (action != null) {
            IAdaptable element = DebugUITools.getDebugContext();
            action.setEnabled(this.getEnableStateForSelection(element));
            action.setChecked(this.getCheckStateForSelection(element));
        }
    }

    public void partActivated(IWorkbenchPart part) {
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        if (part.equals(this.getView())) {
            this.dispose();
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    protected IViewPart getView() {
        return this.fView;
    }

    protected void setView(IViewPart viewPart) {
        this.fView = viewPart;
    }

    protected void setAction(IAction action) {
        this.fAction = action;
    }

    protected IAction getAction() {
        return this.fAction;
    }

    protected void dispose() {
        if (this.getView() != null) {
            this.getView().getViewSite().getPage().removeSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
            this.getView().getViewSite().getPage().removePartListener((IPartListener)this);
        }
    }

    protected boolean getCheckStateForSelection(IAdaptable element) {
        SharedLibraryManager slm = this.getSharedLibraryManager(element);
        Target target = this.getTarget(element);
        if (slm != null && target != null) {
            try {
                return slm.isAutoLoadSymbols(target);
            }
            catch (CDIException cDIException) {}
        }
        return false;
    }

    protected boolean getEnableStateForSelection(IAdaptable element) {
        return element instanceof IDebugElement && ((IDebugElement)element).getDebugTarget().isSuspended() && this.getSharedLibraryManager(element) != null;
    }

    protected String getStatusMessage() {
        return ActionMessages.getString("SetAutoSolibActionDelegate.0");
    }

    protected String getErrorDialogMessage() {
        return ActionMessages.getString("SetAutoSolibActionDelegate.1");
    }

    protected void setStatus(IStatus status) {
        this.fStatus = status;
    }

    protected IStatus getStatus() {
        return this.fStatus;
    }

    protected void doAction(IAdaptable element) throws DebugException {
        if (this.getView() == null) {
            return;
        }
        SharedLibraryManager slm = this.getSharedLibraryManager(element);
        Target target = this.getTarget(element);
        if (slm != null && target != null && this.getAction() != null) {
            try {
                slm.setAutoLoadSymbols(target, this.getAction().isChecked());
            }
            catch (CDIException e) {
                this.getAction().setChecked(!this.getAction().isChecked());
                throw new DebugException((IStatus)new Status(4, MIPlugin.getUniqueIdentifier(), 5010, e.getMessage(), null));
            }
        }
    }

    private SharedLibraryManager getSharedLibraryManager(IAdaptable element) {
        if (element != null) {
            ICDISession session;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.debug.core.cdi.ICDISession");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((session = (ICDISession)element.getAdapter((Class)clazz)) instanceof Session) {
                return ((Session)session).getSharedLibraryManager();
            }
        }
        return null;
    }

    private Target getTarget(IAdaptable element) {
        if (element != null) {
            ICDITarget target;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.cdt.debug.core.cdi.model.ICDITarget");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((target = (ICDITarget)element.getAdapter((Class)clazz)) instanceof Target) {
                return (Target)target;
            }
        }
        return null;
    }
}

