/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.complete;

import java.util.List;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ITokenDuple;
import org.eclipse.cdt.core.parser.ast.ASTNotImplementedException;
import org.eclipse.cdt.core.parser.ast.ASTUtil;
import org.eclipse.cdt.core.parser.ast.IASTExpression;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTExpression;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTUnaryExpression;

public class ASTBinaryExpression
extends ASTUnaryExpression {
    private final IASTExpression rhs;

    public ASTBinaryExpression(IASTExpression.Kind kind, List references, IASTExpression lhs, IASTExpression rhs) {
        super(kind, references, lhs);
        this.rhs = rhs;
    }

    public IASTExpression getRHSExpression() {
        return this.rhs;
    }

    public ASTExpression findOwnerExpressionForIDExpression(ITokenDuple duple) {
        if (this.isIDExpressionForDuple(this.rhs, duple)) {
            return this;
        }
        ASTExpression result = this.recursiveFindExpressionForDuple(this.rhs, duple);
        if (result != null) {
            return result;
        }
        return super.findOwnerExpressionForIDExpression(duple);
    }

    public void purgeReferences() throws ASTNotImplementedException {
        super.purgeReferences();
        this.rhs.purgeReferences();
        this.purgeSubExpression((ASTExpression)this.rhs);
    }

    public void reconcileReferences() throws ASTNotImplementedException {
        super.reconcileReferences();
        this.rhs.reconcileReferences();
        this.reconcileSubExpression((ASTExpression)this.rhs);
    }

    protected void processCallbacks(ISourceElementRequestor requestor) {
        super.processCallbacks(requestor);
        this.rhs.acceptElement(requestor);
    }

    public void freeReferences() {
        super.freeReferences();
        this.rhs.freeReferences();
    }

    public String toString() {
        return ASTUtil.getExpressionString(this);
    }
}

