/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui;

import java.io.File;
import org.eclipse.cdt.debug.core.CDIDebugModel;
import org.eclipse.cdt.debug.core.model.ICBreakpoint;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointsListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;

public class DebugMarkerAnnotationModel
extends AbstractMarkerAnnotationModel
implements IBreakpointsListener {
    private File fFile;

    public DebugMarkerAnnotationModel(File file) {
        this.fFile = file;
    }

    protected IMarker[] retrieveMarkers() throws CoreException {
        IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(CDIDebugModel.getPluginIdentifier());
        IMarker[] markers = new IMarker[breakpoints.length];
        int i = 0;
        while (i < markers.length) {
            markers[i] = breakpoints[i].getMarker();
            ++i;
        }
        return markers;
    }

    protected void deleteMarkers(IMarker[] markers) throws CoreException {
    }

    protected void listenToMarkerChanges(boolean listen) {
        if (listen) {
            DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener((IBreakpointsListener)this);
        } else {
            DebugPlugin.getDefault().getBreakpointManager().removeBreakpointListener((IBreakpointsListener)this);
        }
    }

    protected boolean isAcceptable(IMarker marker) {
        IBreakpoint b = DebugPlugin.getDefault().getBreakpointManager().getBreakpoint(marker);
        if (b != null) {
            return this.isAcceptable(b);
        }
        return false;
    }

    protected File getFile() {
        return this.fFile;
    }

    public void breakpointsAdded(IBreakpoint[] breakpoints) {
        int i = 0;
        while (i < breakpoints.length) {
            if (this.isAcceptable(breakpoints[i])) {
                this.addMarkerAnnotation(breakpoints[i].getMarker());
                this.fireModelChanged();
            }
            ++i;
        }
    }

    public void breakpointsRemoved(IBreakpoint[] breakpoints, IMarkerDelta[] deltas) {
        int i = 0;
        while (i < breakpoints.length) {
            if (this.isAcceptable(breakpoints[i])) {
                this.removeMarkerAnnotation(breakpoints[i].getMarker());
                this.fireModelChanged();
            }
            ++i;
        }
    }

    public void breakpointsChanged(IBreakpoint[] breakpoints, IMarkerDelta[] deltas) {
        int i = 0;
        while (i < breakpoints.length) {
            if (this.isAcceptable(breakpoints[i])) {
                this.modifyMarkerAnnotation(breakpoints[i].getMarker());
                this.fireModelChanged();
            }
            ++i;
        }
    }

    private boolean isAcceptable(IBreakpoint b) {
        if (b instanceof ICBreakpoint) {
            try {
                String handle = ((ICBreakpoint)b).getSourceHandle();
                File file = new File(handle);
                return file.equals(this.getFile());
            }
            catch (CoreException coreException) {}
        }
        return false;
    }
}

