/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.browser.cache;

import java.io.IOException;
import org.eclipse.cdt.core.browser.ITypeSearchScope;
import org.eclipse.cdt.core.browser.PathUtil;
import org.eclipse.cdt.internal.core.browser.cache.ITypeCache;
import org.eclipse.cdt.internal.core.browser.cache.IndexerJob2;
import org.eclipse.cdt.internal.core.index.IEntryResult;
import org.eclipse.cdt.internal.core.index.cindexstorage.Index;
import org.eclipse.cdt.internal.core.index.cindexstorage.IndexedFileEntry;
import org.eclipse.cdt.internal.core.index.cindexstorage.io.BlocksIndexInput;
import org.eclipse.cdt.internal.core.index.cindexstorage.io.IndexInput;
import org.eclipse.cdt.internal.core.search.indexing.IndexManager;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class IndexerDependenciesJob2
extends IndexerJob2 {
    private ITypeCache fTypeCache;
    private ITypeSearchScope fScope;

    public IndexerDependenciesJob2(IndexManager indexManager, ITypeCache typeCache, ITypeSearchScope scope) {
        super(indexManager, typeCache.getProject());
        this.fTypeCache = typeCache;
        this.fScope = scope;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean processIndex(IProgressMonitor progressMonitor) throws InterruptedException {
        BlocksIndexInput input = new BlocksIndexInput(this.fProjectIndex.getIndexFile());
        try {
            try {
                ((IndexInput)input).open();
                this.flushDependencies(input, progressMonitor);
                Object var3_3 = null;
            }
            catch (IOException iOException) {
                Object var3_4 = null;
                try {
                    ((IndexInput)input).close();
                    return false;
                }
                catch (IOException iOException2) {
                    return false;
                }
            }
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            try {}
            catch (IOException iOException) {
                return false;
            }
            ((IndexInput)input).close();
            throw throwable;
        }
        try {}
        catch (IOException iOException) {
            return false;
        }
        ((IndexInput)input).close();
        return true;
    }

    private void flushDependencies(IndexInput input, IProgressMonitor progressMonitor) throws InterruptedException, IOException {
        if (progressMonitor.isCanceled()) {
            throw new InterruptedException();
        }
        IEntryResult[] includeEntries = input.queryEntriesPrefixedBy(Index.encodeEntry(8, 0, 2));
        if (includeEntries != null) {
            int i = 0;
            while (i < includeEntries.length) {
                int[] references;
                if (progressMonitor.isCanceled()) {
                    throw new InterruptedException();
                }
                IEntryResult entry = includeEntries[i];
                IPath includePath = this.getIncludePath(entry);
                if (this.fScope != null && this.fScope.encloses(includePath) && (references = entry.getFileReferences()) != null) {
                    int j = 0;
                    while (j < references.length) {
                        if (progressMonitor.isCanceled()) {
                            throw new InterruptedException();
                        }
                        IndexedFileEntry file = input.getIndexedFile(references[j]);
                        if (file != null && file.getPath() != null) {
                            IPath path = PathUtil.getWorkspaceRelativePath(file.getPath());
                            this.fTypeCache.flush(path);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    private IPath getIncludePath(IEntryResult entry) {
        return PathUtil.getWorkspaceRelativePath(entry.getName());
    }
}

