/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.model;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.core.IAddressFactory;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.debug.core.CDIDebugModel;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.core.DebugCoreMessages;
import org.eclipse.cdt.debug.core.ICDebugConstants;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDIAddressLocation;
import org.eclipse.cdt.debug.core.cdi.ICDIBreakpointHit;
import org.eclipse.cdt.debug.core.cdi.ICDIEndSteppingRange;
import org.eclipse.cdt.debug.core.cdi.ICDIErrorInfo;
import org.eclipse.cdt.debug.core.cdi.ICDIFunctionLocation;
import org.eclipse.cdt.debug.core.cdi.ICDILineLocation;
import org.eclipse.cdt.debug.core.cdi.ICDILocation;
import org.eclipse.cdt.debug.core.cdi.ICDISessionConfiguration;
import org.eclipse.cdt.debug.core.cdi.ICDISessionObject;
import org.eclipse.cdt.debug.core.cdi.ICDISharedLibraryEvent;
import org.eclipse.cdt.debug.core.cdi.ICDISignalReceived;
import org.eclipse.cdt.debug.core.cdi.ICDIWatchpointScope;
import org.eclipse.cdt.debug.core.cdi.ICDIWatchpointTrigger;
import org.eclipse.cdt.debug.core.cdi.event.ICDIChangedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDICreatedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIDestroyedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIDisconnectedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEventListener;
import org.eclipse.cdt.debug.core.cdi.event.ICDIExitedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIRestartedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIResumedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDISuspendedEvent;
import org.eclipse.cdt.debug.core.cdi.model.ICDIGlobalVariableDescriptor;
import org.eclipse.cdt.debug.core.cdi.model.ICDIObject;
import org.eclipse.cdt.debug.core.cdi.model.ICDISharedLibrary;
import org.eclipse.cdt.debug.core.cdi.model.ICDISignal;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.core.cdi.model.ICDITargetConfiguration;
import org.eclipse.cdt.debug.core.cdi.model.ICDIThread;
import org.eclipse.cdt.debug.core.model.CDebugElementState;
import org.eclipse.cdt.debug.core.model.ICBreakpoint;
import org.eclipse.cdt.debug.core.model.ICDebugTarget;
import org.eclipse.cdt.debug.core.model.ICGlobalVariable;
import org.eclipse.cdt.debug.core.model.ICLineBreakpoint;
import org.eclipse.cdt.debug.core.model.ICModule;
import org.eclipse.cdt.debug.core.model.ICSignal;
import org.eclipse.cdt.debug.core.model.IDisassembly;
import org.eclipse.cdt.debug.core.model.IGlobalVariableDescriptor;
import org.eclipse.cdt.debug.core.model.IPersistableRegisterGroup;
import org.eclipse.cdt.debug.core.model.IRegisterDescriptor;
import org.eclipse.cdt.debug.core.sourcelookup.CDirectorySourceContainer;
import org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator;
import org.eclipse.cdt.debug.core.sourcelookup.ISourceLookupChangeListener;
import org.eclipse.cdt.debug.internal.core.CBreakpointManager;
import org.eclipse.cdt.debug.internal.core.CGlobalVariableManager;
import org.eclipse.cdt.debug.internal.core.CMemoryBlockRetrievalExtension;
import org.eclipse.cdt.debug.internal.core.CRegisterManager;
import org.eclipse.cdt.debug.internal.core.CSignalManager;
import org.eclipse.cdt.debug.internal.core.model.CDebugElement;
import org.eclipse.cdt.debug.internal.core.model.CExpression;
import org.eclipse.cdt.debug.internal.core.model.CModule;
import org.eclipse.cdt.debug.internal.core.model.CModuleManager;
import org.eclipse.cdt.debug.internal.core.model.CStackFrame;
import org.eclipse.cdt.debug.internal.core.model.CThread;
import org.eclipse.cdt.debug.internal.core.model.CVariableFactory;
import org.eclipse.cdt.debug.internal.core.model.CoreModelMessages;
import org.eclipse.cdt.debug.internal.core.model.Disassembly;
import org.eclipse.cdt.debug.internal.core.sourcelookup.CSourceLookupParticipant;
import org.eclipse.cdt.debug.internal.core.sourcelookup.CSourceManager;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IExpressionListener;
import org.eclipse.debug.core.IExpressionManager;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.ISourceLookupParticipant;
import org.eclipse.debug.core.sourcelookup.containers.FolderSourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.ProjectSourceContainer;

public class CDebugTarget
extends CDebugElement
implements ICDebugTarget,
ICDIEventListener,
ILaunchListener,
IExpressionListener,
ISourceLookupChangeListener {
    private ArrayList fThreads;
    private IProcess fDebuggeeProcess = null;
    private ICDITarget fCDITarget;
    private String fName;
    private ILaunch fLaunch;
    private ICDITargetConfiguration fConfig;
    private Disassembly fDisassembly;
    private CModuleManager fModuleManager;
    private CSignalManager fSignalManager;
    private CRegisterManager fRegisterManager;
    private CBreakpointManager fBreakpointManager;
    private CGlobalVariableManager fGlobalVariableManager;
    private IBinaryParser.IBinaryObject fBinaryFile;
    private IProject fProject;
    private Boolean fIsLittleEndian = null;
    private Preferences fPreferences = null;
    private IAddressFactory fAddressFactory;
    private CMemoryBlockRetrievalExtension fMemoryBlockRetrieval;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;
    static /* synthetic */ Class class$12;
    static /* synthetic */ Class class$13;
    static /* synthetic */ Class class$14;
    static /* synthetic */ Class class$15;
    static /* synthetic */ Class class$16;
    static /* synthetic */ Class class$17;

    public CDebugTarget(ILaunch launch, IProject project, ICDITarget cdiTarget, String name, IProcess debuggeeProcess, IBinaryParser.IBinaryObject file, boolean allowsTerminate, boolean allowsDisconnect) {
        super(null);
        this.setLaunch(launch);
        this.setDebugTarget(this);
        this.setName(name);
        this.setProcess(debuggeeProcess);
        this.setProject(project);
        this.setExecFile(file);
        this.setCDITarget(cdiTarget);
        this.setState(CDebugElementState.SUSPENDED);
        this.initializePreferences();
        this.setConfiguration(cdiTarget.getConfiguration());
        this.setThreadList(new ArrayList(5));
        this.createDisassembly();
        this.setModuleManager(new CModuleManager(this));
        this.setSignalManager(new CSignalManager(this));
        this.setRegisterManager(new CRegisterManager(this));
        this.setBreakpointManager(new CBreakpointManager(this));
        this.setGlobalVariableManager(new CGlobalVariableManager(this));
        this.setMemoryBlockRetrieval(new CMemoryBlockRetrievalExtension(this));
        this.initialize();
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchListener)this);
        DebugPlugin.getDefault().getExpressionManager().addExpressionListener((IExpressionListener)this);
        this.getCDISession().getEventManager().addEventListener(this);
    }

    protected void initialize() {
        this.initializeSourceLookupPath();
        ArrayList<DebugEvent> debugEvents = new ArrayList<DebugEvent>(1);
        debugEvents.add(this.createCreateEvent());
        this.initializeThreads(debugEvents);
        this.initializeBreakpoints();
        this.initializeRegisters();
        this.initializeSourceManager();
        this.initializeModuleManager();
        this.initializeMemoryBlocks();
        this.getLaunch().addDebugTarget((IDebugTarget)this);
        this.fireEventSet(debugEvents.toArray(new DebugEvent[debugEvents.size()]));
    }

    private void initializeBreakpoints() {
        this.getBreakpointManager().initialize();
    }

    public void start(boolean stopInMain, boolean resume) throws DebugException {
        ICDITargetConfiguration config = this.getConfiguration();
        if (config.supportsBreakpoints()) {
            this.getBreakpointManager().setInitialBreakpoints();
            if (stopInMain) {
                this.stopInMain();
            }
        }
        if (config.supportsResume() && resume) {
            this.resume();
        }
    }

    protected void initializeThreads(List debugEvents) {
        ICDIThread[] cdiThreads = new ICDIThread[]{};
        try {
            cdiThreads = this.getCDITarget().getThreads();
        }
        catch (CDIException cDIException) {}
        DebugEvent suspendEvent = null;
        int i = 0;
        while (i < cdiThreads.length) {
            CThread thread = this.createThread(cdiThreads[i]);
            debugEvents.add(thread.createCreateEvent());
            try {
                if (cdiThreads[i].equals(this.getCDITarget().getCurrentThread()) && thread.isSuspended()) {
                    suspendEvent = thread.createSuspendEvent(16);
                }
            }
            catch (CDIException cDIException) {}
            ++i;
        }
        if (suspendEvent != null) {
            debugEvents.add(suspendEvent);
        }
    }

    protected void initializeRegisters() {
        this.getRegisterManager().initialize();
    }

    protected void initializeSourceManager() {
        ISourceLocator locator = this.getLaunch().getSourceLocator();
        if (locator instanceof IAdaptable) {
            IResourceChangeListener listener;
            ICSourceLocator clocator;
            IAdaptable iAdaptable = (IAdaptable)locator;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((clocator = (ICSourceLocator)iAdaptable.getAdapter((Class)clazz)) instanceof IAdaptable) {
                CSourceManager sm;
                IAdaptable iAdaptable2 = (IAdaptable)clocator;
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("org.eclipse.cdt.debug.internal.core.sourcelookup.CSourceManager");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((sm = (CSourceManager)iAdaptable2.getAdapter((Class)clazz2)) != null) {
                    sm.setDebugTarget(this);
                }
            }
            IAdaptable iAdaptable3 = (IAdaptable)locator;
            Class<?> clazz3 = class$2;
            if (clazz3 == null) {
                try {
                    clazz3 = class$2 = Class.forName("org.eclipse.core.resources.IResourceChangeListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((listener = (IResourceChangeListener)iAdaptable3.getAdapter((Class)clazz3)) != null) {
                CCorePlugin.getWorkspace().addResourceChangeListener(listener);
            }
        }
    }

    protected void initializeSourceLookupPath() {
        ISourceLocator locator = this.getLaunch().getSourceLocator();
        if (locator instanceof ISourceLookupDirector) {
            ISourceLookupParticipant[] participants = ((ISourceLookupDirector)locator).getParticipants();
            int i = 0;
            while (i < participants.length) {
                if (participants[i] instanceof CSourceLookupParticipant) {
                    ((CSourceLookupParticipant)participants[i]).addSourceLookupChangeListener(this);
                }
                ++i;
            }
            this.setSourceLookupPath(((ISourceLookupDirector)locator).getSourceContainers());
        }
    }

    protected void initializeModuleManager() {
        this.getModuleManager().addModules(new ICModule[]{CModule.createExecutable(this, this.getExecFile().getPath())});
    }

    protected void initializeMemoryBlocks() {
        this.getMemoryBlockRetrieval().initialize();
    }

    public IProcess getProcess() {
        return this.fDebuggeeProcess;
    }

    protected void setProcess(IProcess debuggeeProcess) {
        this.fDebuggeeProcess = debuggeeProcess;
    }

    public IThread[] getThreads() {
        ArrayList threads = this.getThreadList();
        return threads.toArray(new IThread[threads.size()]);
    }

    public boolean hasThreads() throws DebugException {
        return this.getThreadList().size() > 0;
    }

    public String getName() throws DebugException {
        return this.fName;
    }

    protected void setName(String name) {
        this.fName = name;
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        if (!this.getConfiguration().supportsBreakpoints()) {
            return false;
        }
        return breakpoint instanceof ICBreakpoint && this.getBreakpointManager().supportsBreakpoint((ICBreakpoint)breakpoint);
    }

    public void launchRemoved(ILaunch launch) {
        if (!this.isAvailable()) {
            return;
        }
        if (launch.equals(this.getLaunch())) {
            this.disconnected();
        }
    }

    public void launchAdded(ILaunch launch) {
    }

    public void launchChanged(ILaunch launch) {
    }

    public boolean canTerminate() {
        return this.supportsTerminate() && this.isAvailable();
    }

    public boolean isTerminated() {
        return this.getState().equals(CDebugElementState.TERMINATED);
    }

    public void terminate() throws DebugException {
        if (!this.canTerminate()) {
            return;
        }
        this.changeState(CDebugElementState.TERMINATING);
        try {
            this.getCDITarget().terminate();
        }
        catch (CDIException e) {
            this.restoreOldState();
            CDebugElement.targetRequestFailed(e.getMessage(), null);
        }
    }

    public boolean canResume() {
        return this.getConfiguration().supportsResume() && this.isSuspended();
    }

    public boolean canSuspend() {
        if (!this.getConfiguration().supportsSuspend()) {
            return false;
        }
        if (this.getState().equals(CDebugElementState.RESUMED)) {
            IThread[] threads = this.getThreads();
            int i = 0;
            while (i < threads.length) {
                if (threads[i].isSuspended()) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public boolean isSuspended() {
        return this.getState().equals(CDebugElementState.SUSPENDED);
    }

    public void resume() throws DebugException {
        if (!this.canResume()) {
            return;
        }
        this.changeState(CDebugElementState.RESUMING);
        try {
            this.getCDITarget().resume(false);
        }
        catch (CDIException e) {
            this.restoreOldState();
            CDebugElement.targetRequestFailed(e.getMessage(), null);
        }
    }

    public void suspend() throws DebugException {
        if (!this.canSuspend()) {
            return;
        }
        this.changeState(CDebugElementState.SUSPENDING);
        try {
            this.getCDITarget().suspend();
        }
        catch (CDIException e) {
            this.restoreOldState();
            CDebugElement.targetRequestFailed(e.getMessage(), null);
        }
    }

    protected boolean isSuspending() {
        return this.getState().equals(CDebugElementState.SUSPENDING);
    }

    protected void suspendThreads(ICDISuspendedEvent event) {
        Iterator it = this.getThreadList().iterator();
        while (it.hasNext()) {
            CThread thread = (CThread)it.next();
            ICDIThread suspensionThread = null;
            try {
                suspensionThread = this.getCDITarget().getCurrentThread();
            }
            catch (CDIException cDIException) {}
            thread.suspendByTarget(event.getReason(), suspensionThread);
        }
    }

    protected synchronized List refreshThreads() {
        CThread thread;
        ArrayList<CThread> newThreads = new ArrayList<CThread>(5);
        ArrayList<CThread> list = new ArrayList<CThread>(5);
        ArrayList<DebugEvent> debugEvents = new ArrayList<DebugEvent>(5);
        List oldList = (List)this.getThreadList().clone();
        ICDIThread[] cdiThreads = new ICDIThread[]{};
        ICDIThread currentCDIThread = null;
        try {
            cdiThreads = this.getCDITarget().getThreads();
            currentCDIThread = this.getCDITarget().getCurrentThread();
        }
        catch (CDIException cDIException) {}
        int i = 0;
        while (i < cdiThreads.length) {
            thread = this.findThread(oldList, cdiThreads[i]);
            if (thread == null) {
                thread = new CThread(this, cdiThreads[i]);
                newThreads.add(thread);
            } else {
                oldList.remove(thread);
            }
            thread.setCurrent(cdiThreads[i].equals(currentCDIThread));
            list.add(thread);
            ++i;
        }
        Iterator it = oldList.iterator();
        while (it.hasNext()) {
            thread = (CThread)it.next();
            thread.terminated();
            debugEvents.add(thread.createTerminateEvent());
        }
        this.setThreadList(list);
        it = newThreads.iterator();
        while (it.hasNext()) {
            debugEvents.add(((CThread)it.next()).createCreateEvent());
        }
        if (debugEvents.size() > 0) {
            this.fireEventSet(debugEvents.toArray(new DebugEvent[debugEvents.size()]));
        }
        return newThreads;
    }

    protected synchronized void resumeThreads(List debugEvents, int detail) {
        Iterator it = this.getThreadList().iterator();
        while (it.hasNext()) {
            ((CThread)it.next()).resumedByTarget(detail, debugEvents);
        }
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
    }

    protected boolean supportsDisconnect() {
        return this.getConfiguration().supportsDisconnect();
    }

    protected boolean supportsTerminate() {
        return this.getConfiguration().supportsTerminate();
    }

    public boolean canDisconnect() {
        return this.supportsDisconnect() && this.isAvailable();
    }

    public void disconnect() throws DebugException {
        if (this.isDisconnecting()) {
            return;
        }
        this.changeState(CDebugElementState.DISCONNECTING);
        try {
            this.getCDITarget().disconnect();
        }
        catch (CDIException e) {
            this.restoreOldState();
            CDebugElement.targetRequestFailed(e.getMessage(), null);
        }
    }

    public boolean isDisconnected() {
        return this.getState().equals(CDebugElementState.DISCONNECTED);
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        return null;
    }

    public ILaunch getLaunch() {
        return this.fLaunch;
    }

    private void setLaunch(ILaunch launch) {
        this.fLaunch = launch;
    }

    protected ArrayList getThreadList() {
        return this.fThreads;
    }

    private void setThreadList(ArrayList threads) {
        this.fThreads = threads;
    }

    private void setCDITarget(ICDITarget cdiTarget) {
        this.fCDITarget = cdiTarget;
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.cdt.debug.core.model.ICDebugElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz)) {
            return this;
        }
        Class<?> clazz2 = class$4;
        if (clazz2 == null) {
            try {
                clazz2 = class$4 = Class.forName("org.eclipse.cdt.debug.internal.core.model.CDebugElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz2)) {
            return this;
        }
        Class<?> clazz3 = class$5;
        if (clazz3 == null) {
            try {
                clazz3 = class$5 = Class.forName("org.eclipse.debug.core.model.IDebugTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz3)) {
            return this;
        }
        Class<?> clazz4 = class$6;
        if (clazz4 == null) {
            try {
                clazz4 = class$6 = Class.forName("org.eclipse.cdt.debug.core.model.ICDebugTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz4)) {
            return this;
        }
        Class<?> clazz5 = class$7;
        if (clazz5 == null) {
            try {
                clazz5 = class$7 = Class.forName("org.eclipse.cdt.debug.internal.core.model.CDebugTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz5)) {
            return this;
        }
        Class<?> clazz6 = class$8;
        if (clazz6 == null) {
            try {
                clazz6 = class$8 = Class.forName("org.eclipse.cdt.debug.core.cdi.model.ICDITarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz6)) {
            return this.fCDITarget;
        }
        Class<?> clazz7 = class$9;
        if (clazz7 == null) {
            try {
                clazz7 = class$9 = Class.forName("org.eclipse.cdt.debug.core.model.IDebuggerProcessSupport");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz7)) {
            return this;
        }
        Class<?> clazz8 = class$10;
        if (clazz8 == null) {
            try {
                clazz8 = class$10 = Class.forName("org.eclipse.cdt.debug.core.model.IExecFileInfo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz8)) {
            return this;
        }
        Class<?> clazz9 = class$11;
        if (clazz9 == null) {
            try {
                clazz9 = class$11 = Class.forName("org.eclipse.cdt.debug.internal.core.CBreakpointManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz9)) {
            return this.getBreakpointManager();
        }
        Class<?> clazz10 = class$12;
        if (clazz10 == null) {
            try {
                clazz10 = class$12 = Class.forName("org.eclipse.cdt.debug.internal.core.CSignalManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz10)) {
            return this.getSignalManager();
        }
        Class<?> clazz11 = class$13;
        if (clazz11 == null) {
            try {
                clazz11 = class$13 = Class.forName("org.eclipse.cdt.debug.internal.core.CRegisterManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz11)) {
            return this.getRegisterManager();
        }
        Class<?> clazz12 = class$14;
        if (clazz12 == null) {
            try {
                clazz12 = class$14 = Class.forName("org.eclipse.cdt.debug.core.ICGlobalVariableManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz12)) {
            return this.getGlobalVariableManager();
        }
        Class<?> clazz13 = class$15;
        if (clazz13 == null) {
            try {
                clazz13 = class$15 = Class.forName("org.eclipse.cdt.debug.core.cdi.ICDISession");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz13)) {
            return this.getCDISession();
        }
        Class<?> clazz14 = class$16;
        if (clazz14 == null) {
            try {
                clazz14 = class$16 = Class.forName("org.eclipse.debug.core.model.IMemoryBlockRetrievalExtension");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz14)) {
            return this.getMemoryBlockRetrieval();
        }
        Class<?> clazz15 = class$17;
        if (clazz15 == null) {
            try {
                clazz15 = class$17 = Class.forName("org.eclipse.debug.core.model.IMemoryBlockRetrieval");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz15)) {
            return this.getMemoryBlockRetrieval();
        }
        return super.getAdapter(adapter);
    }

    public void handleDebugEvents(ICDIEvent[] events) {
        int i = 0;
        while (i < events.length) {
            ICDIEvent event = events[i];
            ICDIObject source = event.getSource();
            if (source == null && event instanceof ICDIDestroyedEvent) {
                this.handleTerminatedEvent((ICDIDestroyedEvent)event);
            } else if (source.getTarget().equals(this.getCDITarget())) {
                if (event instanceof ICDICreatedEvent) {
                    if (source instanceof ICDIThread) {
                        this.handleThreadCreatedEvent((ICDICreatedEvent)event);
                    }
                    if (source instanceof ICDISharedLibrary) {
                        this.getModuleManager().sharedLibraryLoaded((ICDISharedLibrary)source);
                    }
                } else if (event instanceof ICDISuspendedEvent) {
                    if (source instanceof ICDITarget) {
                        this.handleSuspendedEvent((ICDISuspendedEvent)event);
                    }
                } else if (event instanceof ICDIResumedEvent) {
                    if (source instanceof ICDITarget) {
                        this.handleResumedEvent((ICDIResumedEvent)event);
                    }
                } else if (event instanceof ICDIExitedEvent) {
                    if (source instanceof ICDITarget) {
                        this.handleExitedEvent((ICDIExitedEvent)event);
                    }
                } else if (event instanceof ICDIDestroyedEvent) {
                    if (source instanceof ICDIThread) {
                        this.handleThreadTerminatedEvent((ICDIDestroyedEvent)event);
                    }
                    if (source instanceof ICDISharedLibrary) {
                        this.getModuleManager().sharedLibraryUnloaded((ICDISharedLibrary)source);
                    }
                } else if (event instanceof ICDIDisconnectedEvent) {
                    if (source instanceof ICDITarget) {
                        this.handleDisconnectedEvent((ICDIDisconnectedEvent)event);
                    }
                } else if (event instanceof ICDIChangedEvent) {
                    if (source instanceof ICDITarget) {
                        this.handleChangedEvent((ICDIChangedEvent)event);
                    }
                    if (source instanceof ICDISharedLibrary) {
                        this.handleSymbolsLoaded((ICDISharedLibrary)source);
                    }
                    if (source instanceof ICDISignal) {
                        this.getSignalManager().signalChanged((ICDISignal)source);
                    }
                } else if (event instanceof ICDIRestartedEvent && source instanceof ICDITarget) {
                    this.handleRestartedEvent((ICDIRestartedEvent)event);
                }
            }
            ++i;
        }
    }

    public boolean canRestart() {
        return this.getConfiguration().supportsRestart() && this.isSuspended();
    }

    public void restart() throws DebugException {
        if (!this.canRestart()) {
            return;
        }
        this.changeState(CDebugElementState.RESTARTING);
        ICDIFunctionLocation location = this.getCDITarget().createFunctionLocation("", "main");
        this.setInternalTemporaryBreakpoint(location);
        try {
            this.getCDITarget().restart();
        }
        catch (CDIException e) {
            this.restoreOldState();
            CDebugElement.targetRequestFailed(e.getMessage(), e);
        }
    }

    public boolean isAvailable() {
        return !this.isTerminated() && !this.isTerminating() && !this.isDisconnected() && !this.isDisconnecting();
    }

    protected boolean isTerminating() {
        return this.getState().equals(CDebugElementState.TERMINATING);
    }

    protected void terminated() {
        if (!this.isTerminated()) {
            if (!this.isDisconnected()) {
                this.setState(CDebugElementState.TERMINATED);
            }
            this.cleanup();
            this.fireTerminateEvent();
        }
    }

    protected boolean isDisconnecting() {
        return this.getState().equals(CDebugElementState.DISCONNECTING);
    }

    protected void disconnected() {
        if (!this.isDisconnected()) {
            this.setState(CDebugElementState.DISCONNECTED);
            this.cleanup();
            this.fireTerminateEvent();
        }
    }

    protected void cleanup() {
        this.resetStatus();
        this.removeAllThreads();
        this.getCDISession().getEventManager().removeEventListener(this);
        DebugPlugin.getDefault().getExpressionManager().removeExpressionListener((IExpressionListener)this);
        DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchListener)this);
        this.saveGlobalVariables();
        this.disposeGlobalVariableManager();
        this.disposeModuleManager();
        this.disposeSignalManager();
        this.saveRegisterGroups();
        this.disposeRegisterManager();
        this.saveMemoryBlocks();
        this.disposeMemoryBlockRetrieval();
        this.disposeDisassembly();
        this.disposeSourceManager();
        this.disposeSourceLookupPath();
        this.disposeBreakpointManager();
        this.removeAllExpressions();
        this.disposePreferences();
    }

    protected void removeAllThreads() {
        ArrayList threads = this.getThreadList();
        this.setThreadList(new ArrayList(0));
        ArrayList<DebugEvent> debugEvents = new ArrayList<DebugEvent>(threads.size());
        Iterator it = threads.iterator();
        while (it.hasNext()) {
            CThread thread = (CThread)it.next();
            thread.terminated();
            debugEvents.add(thread.createTerminateEvent());
        }
        this.fireEventSet(debugEvents.toArray(new DebugEvent[debugEvents.size()]));
    }

    protected void removeAllExpressions() {
        IExpressionManager em = DebugPlugin.getDefault().getExpressionManager();
        IExpression[] expressions = em.getExpressions();
        int i = 0;
        while (i < expressions.length) {
            if (expressions[i] instanceof CExpression && expressions[i].getDebugTarget().equals(this)) {
                em.removeExpression(expressions[i]);
            }
            ++i;
        }
    }

    protected CThread createThread(ICDIThread cdiThread) {
        CThread thread = new CThread(this, cdiThread);
        this.getThreadList().add(thread);
        return thread;
    }

    private void handleSuspendedEvent(ICDISuspendedEvent event) {
        CThread thread;
        this.setState(CDebugElementState.SUSPENDED);
        ICDISessionObject reason = event.getReason();
        this.setCurrentStateInfo(reason);
        this.getRegisterManager().targetSuspended();
        this.getBreakpointManager().skipBreakpoints(false);
        List newThreads = this.refreshThreads();
        if (event.getSource() instanceof ICDITarget) {
            this.suspendThreads(event);
        } else if (event.getSource() instanceof ICDIThread && (thread = this.findThread((ICDIThread)event.getSource())) != null && newThreads.contains(thread)) {
            ICDIEvent[] evts = new ICDIEvent[]{event};
            thread.handleDebugEvents(evts);
        }
        if (reason instanceof ICDIEndSteppingRange) {
            this.handleEndSteppingRange((ICDIEndSteppingRange)reason);
        } else if (reason instanceof ICDIBreakpointHit) {
            this.handleBreakpointHit((ICDIBreakpointHit)reason);
        } else if (reason instanceof ICDISignalReceived) {
            this.handleSuspendedBySignal((ICDISignalReceived)reason);
        } else if (reason instanceof ICDIWatchpointTrigger) {
            this.handleWatchpointTrigger((ICDIWatchpointTrigger)reason);
        } else if (reason instanceof ICDIWatchpointScope) {
            this.handleWatchpointScope((ICDIWatchpointScope)reason);
        } else if (reason instanceof ICDIErrorInfo) {
            this.handleErrorInfo((ICDIErrorInfo)reason);
        } else if (reason instanceof ICDISharedLibraryEvent) {
            this.handleSuspendedBySolibEvent((ICDISharedLibraryEvent)reason);
        } else {
            this.fireSuspendEvent(0);
        }
    }

    private void handleResumedEvent(ICDIResumedEvent event) {
        this.setState(CDebugElementState.RESUMED);
        this.setCurrentStateInfo(null);
        this.resetStatus();
        ArrayList<DebugEvent> debugEvents = new ArrayList<DebugEvent>(10);
        int detail = 0;
        switch (event.getType()) {
            case 0: {
                detail = 32;
                break;
            }
            case 2: 
            case 4: {
                detail = 1;
                break;
            }
            case 1: 
            case 3: {
                detail = 2;
                break;
            }
            case 5: {
                detail = 4;
            }
        }
        debugEvents.add(this.createResumeEvent(detail));
        this.resumeThreads(debugEvents, detail);
        this.fireEventSet(debugEvents.toArray(new DebugEvent[debugEvents.size()]));
    }

    private void handleEndSteppingRange(ICDIEndSteppingRange endSteppingRange) {
        this.fireSuspendEvent(0);
    }

    private void handleBreakpointHit(ICDIBreakpointHit breakpointHit) {
        this.fireSuspendEvent(16);
    }

    private void handleWatchpointTrigger(ICDIWatchpointTrigger wt) {
        this.fireSuspendEvent(16);
    }

    private void handleWatchpointScope(ICDIWatchpointScope ws) {
        this.getBreakpointManager().watchpointOutOfScope(ws.getWatchpoint());
        this.fireSuspendEvent(16);
    }

    private void handleSuspendedBySignal(ICDISignalReceived signal) {
        this.fireSuspendEvent(0);
    }

    private void handleErrorInfo(ICDIErrorInfo info) {
        this.setStatus(2, info != null ? info.getMessage() : null);
        if (info != null) {
            MultiStatus status = new MultiStatus(CDebugCorePlugin.getUniqueIdentifier(), 10002, CoreModelMessages.getString("CDebugTarget.1"), null);
            StringTokenizer st = new StringTokenizer(info.getDetailMessage(), "\n\r");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (token.length() > 200) {
                    token = token.substring(0, 200);
                }
                status.add((IStatus)new Status(4, status.getPlugin(), 10002, token, null));
            }
            CDebugUtils.error((IStatus)status, this);
        }
        this.fireSuspendEvent(0);
    }

    private void handleSuspendedBySolibEvent(ICDISharedLibraryEvent solibEvent) {
        this.fireSuspendEvent(0);
    }

    private void handleExitedEvent(ICDIExitedEvent event) {
        this.removeAllThreads();
        this.setState(CDebugElementState.EXITED);
        this.setCurrentStateInfo(event.getReason());
        this.fireChangeEvent(512);
        ICDISessionConfiguration sessionConfig = this.getCDISession().getConfiguration();
        if (sessionConfig != null && sessionConfig.terminateSessionOnExit()) {
            this.terminated();
        }
    }

    private void handleTerminatedEvent(ICDIDestroyedEvent event) {
        this.terminated();
    }

    private void handleDisconnectedEvent(ICDIDisconnectedEvent event) {
        this.disconnected();
    }

    private void handleChangedEvent(ICDIChangedEvent event) {
    }

    private void handleRestartedEvent(ICDIRestartedEvent event) {
    }

    private void handleThreadCreatedEvent(ICDICreatedEvent event) {
        ICDIThread cdiThread = (ICDIThread)event.getSource();
        CThread thread = this.findThread(cdiThread);
        if (thread == null) {
            thread = this.createThread(cdiThread);
            thread.fireCreationEvent();
        }
    }

    private void handleThreadTerminatedEvent(ICDIDestroyedEvent event) {
        ICDIThread cdiThread = (ICDIThread)event.getSource();
        CThread thread = this.findThread(cdiThread);
        if (thread != null) {
            this.getThreadList().remove(thread);
            thread.terminated();
            thread.fireTerminateEvent();
        }
    }

    public CThread findThread(ICDIThread cdiThread) {
        ArrayList threads = this.getThreadList();
        int i = 0;
        while (i < threads.size()) {
            CThread t = (CThread)threads.get(i);
            if (t.getCDIThread().equals(cdiThread)) {
                return t;
            }
            ++i;
        }
        return null;
    }

    public CThread findThread(List threads, ICDIThread cdiThread) {
        int i = 0;
        while (i < threads.size()) {
            CThread t = (CThread)threads.get(i);
            if (t.getCDIThread().equals(cdiThread)) {
                return t;
            }
            ++i;
        }
        return null;
    }

    protected ICDITargetConfiguration getConfiguration() {
        return this.fConfig;
    }

    private void setConfiguration(ICDITargetConfiguration config) {
        this.fConfig = config;
    }

    protected boolean supportsExpressionEvaluation() {
        return this.getConfiguration().supportsExpressionEvaluation();
    }

    public void expressionAdded(IExpression expression) {
    }

    public void expressionChanged(IExpression expression) {
    }

    public void expressionRemoved(IExpression expression) {
        if (expression instanceof CExpression && expression.getDebugTarget().equals(this)) {
            ((CExpression)expression).dispose();
        }
    }

    public void setInternalTemporaryBreakpoint(ICDILocation location) throws DebugException {
        try {
            if (location instanceof ICDIFunctionLocation) {
                this.getCDITarget().setFunctionBreakpoint(1, (ICDIFunctionLocation)location, null, false);
            } else if (location instanceof ICDILineLocation) {
                this.getCDITarget().setLineBreakpoint(1, (ICDILineLocation)location, null, false);
            } else if (location instanceof ICDIAddressLocation) {
                this.getCDITarget().setAddressBreakpoint(1, (ICDIAddressLocation)location, null, false);
            } else {
                CDebugElement.targetRequestFailed("not_a_location", null);
            }
        }
        catch (CDIException e) {
            CDebugElement.targetRequestFailed(e.getMessage(), null);
        }
    }

    protected IThread getCurrentThread() throws DebugException {
        IThread[] threads = this.getThreads();
        int i = 0;
        while (i < threads.length) {
            if (((CThread)threads[i]).isCurrent()) {
                return threads[i];
            }
            ++i;
        }
        return null;
    }

    protected ISourceLocator getSourceLocator() {
        return this.getLaunch().getSourceLocator();
    }

    public boolean isLittleEndian() {
        if (this.fIsLittleEndian == null) {
            this.fIsLittleEndian = Boolean.TRUE;
            IBinaryParser.IBinaryObject file = this.getBinaryFile();
            if (file != null) {
                this.fIsLittleEndian = new Boolean(file.isLittleEndian());
            }
        }
        return this.fIsLittleEndian;
    }

    public IBinaryParser.IBinaryObject getExecFile() {
        return this.getBinaryFile();
    }

    public IBinaryParser.IBinaryObject getBinaryFile() {
        return this.fBinaryFile;
    }

    private void setExecFile(IBinaryParser.IBinaryObject file) {
        this.fBinaryFile = file;
    }

    private void setProject(IProject project) {
        this.fProject = project;
    }

    public IProject getProject() {
        return this.fProject;
    }

    public IGlobalVariableDescriptor[] getGlobals() throws DebugException {
        ArrayList list = new ArrayList();
        IBinaryParser.IBinaryObject file = this.getBinaryFile();
        if (file != null) {
            list.addAll(this.getCFileGlobals(file));
        }
        return list.toArray(new IGlobalVariableDescriptor[list.size()]);
    }

    private List getCFileGlobals(IBinaryParser.IBinaryObject file) throws DebugException {
        ArrayList<IGlobalVariableDescriptor> list = new ArrayList<IGlobalVariableDescriptor>();
        IBinaryParser.ISymbol[] symbols = file.getSymbols();
        int i = 0;
        while (i < symbols.length) {
            if (symbols[i].getType() == 2) {
                list.add(CVariableFactory.createGlobalVariableDescriptor(symbols[i]));
            }
            ++i;
        }
        return list;
    }

    protected void setModuleManager(CModuleManager mm) {
        this.fModuleManager = mm;
    }

    protected CModuleManager getModuleManager() {
        return this.fModuleManager;
    }

    protected void disposeModuleManager() {
        this.fModuleManager.dispose();
        this.fModuleManager = null;
    }

    protected void setSignalManager(CSignalManager sm) {
        this.fSignalManager = sm;
    }

    protected CSignalManager getSignalManager() {
        return this.fSignalManager;
    }

    protected void disposeSignalManager() {
        this.fSignalManager.dispose();
    }

    protected void saveRegisterGroups() {
        this.fRegisterManager.save();
    }

    protected void disposeRegisterManager() {
        this.fRegisterManager.dispose();
    }

    protected void saveGlobalVariables() {
        this.fGlobalVariableManager.save();
    }

    protected void disposeGlobalVariableManager() {
        this.fGlobalVariableManager.dispose();
    }

    public boolean canResumeWithoutSignal() {
        return this.canResume() && this.getCurrentStateInfo() instanceof ICDISignalReceived;
    }

    public void resumeWithoutSignal() throws DebugException {
        if (!this.canResume()) {
            return;
        }
        this.changeState(CDebugElementState.RESUMING);
        try {
            this.getCDITarget().resume(false);
        }
        catch (CDIException e) {
            this.restoreOldState();
            CDebugElement.targetRequestFailed(e.getMessage(), e);
        }
    }

    public CRegisterManager getRegisterManager() {
        return this.fRegisterManager;
    }

    protected void setRegisterManager(CRegisterManager registerManager) {
        this.fRegisterManager = registerManager;
    }

    public IRegisterGroup[] getRegisterGroups(CStackFrame frame) throws DebugException {
        return this.getRegisterManager().getRegisterGroups(frame);
    }

    protected void disposeSourceManager() {
        ISourceLocator locator = this.getSourceLocator();
        if (locator instanceof IAdaptable) {
            IResourceChangeListener listener;
            IAdaptable iAdaptable = (IAdaptable)locator;
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.core.resources.IResourceChangeListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((listener = (IResourceChangeListener)iAdaptable.getAdapter((Class)clazz)) != null) {
                CCorePlugin.getWorkspace().removeResourceChangeListener(listener);
            }
        }
    }

    protected void disposeSourceLookupPath() {
        ISourceLocator locator = this.getLaunch().getSourceLocator();
        if (locator instanceof ISourceLookupDirector) {
            ISourceLookupParticipant[] participants = ((ISourceLookupDirector)locator).getParticipants();
            int i = 0;
            while (i < participants.length) {
                if (participants[i] instanceof CSourceLookupParticipant) {
                    ((CSourceLookupParticipant)participants[i]).removeSourceLookupChangeListener(this);
                }
                ++i;
            }
        }
    }

    protected void saveMemoryBlocks() {
        this.getMemoryBlockRetrieval().save();
    }

    protected void disposeMemoryBlockRetrieval() {
        this.getMemoryBlockRetrieval().dispose();
    }

    protected CBreakpointManager getBreakpointManager() {
        return this.fBreakpointManager;
    }

    protected void setBreakpointManager(CBreakpointManager manager) {
        this.fBreakpointManager = manager;
    }

    protected void disposeBreakpointManager() {
        if (this.getBreakpointManager() != null) {
            this.getBreakpointManager().dispose();
        }
    }

    public String toString() {
        String result = "";
        try {
            result = this.getName();
        }
        catch (DebugException debugException) {}
        return result;
    }

    public IDisassembly getDisassembly() throws DebugException {
        return this.fDisassembly;
    }

    public ICSignal[] getSignals() throws DebugException {
        CSignalManager sm = this.getSignalManager();
        if (sm != null) {
            return sm.getSignals();
        }
        return new ICSignal[0];
    }

    public boolean hasSignals() throws DebugException {
        CSignalManager sm = this.getSignalManager();
        if (sm != null) {
            return sm.getSignals().length > 0;
        }
        return false;
    }

    private void createDisassembly() {
        this.fDisassembly = new Disassembly(this);
    }

    private void disposeDisassembly() {
        if (this.fDisassembly != null) {
            this.fDisassembly.dispose();
        }
        this.fDisassembly = null;
    }

    public IAddress getBreakpointAddress(ICLineBreakpoint breakpoint) throws DebugException {
        return this.getBreakpointManager() != null ? this.getBreakpointManager().getBreakpointAddress(breakpoint) : this.getAddressFactory().getZero();
    }

    public void enableInstructionStepping(boolean enabled) {
        this.fPreferences.setValue("instruction_stepping_mode", enabled);
    }

    public boolean isInstructionSteppingEnabled() {
        return this.fPreferences.getBoolean("instruction_stepping_mode") || CDebugCorePlugin.getDefault().getPluginPreferences().getBoolean(ICDebugConstants.PREF_INSTRUCTION_STEP_MODE_ON);
    }

    public boolean supportsInstructionStepping() {
        return this.getConfiguration().supportsInstructionStepping();
    }

    private void initializePreferences() {
        this.fPreferences = new Preferences();
        this.fPreferences.setDefault("instruction_stepping_mode", false);
    }

    private void disposePreferences() {
        this.fPreferences = null;
    }

    public void addPropertyChangeListener(Preferences.IPropertyChangeListener listener) {
        if (this.fPreferences != null) {
            this.fPreferences.addPropertyChangeListener(listener);
        }
    }

    public void removePropertyChangeListener(Preferences.IPropertyChangeListener listener) {
        if (this.fPreferences != null) {
            this.fPreferences.removePropertyChangeListener(listener);
        }
    }

    protected CGlobalVariableManager getGlobalVariableManager() {
        return this.fGlobalVariableManager;
    }

    private void setGlobalVariableManager(CGlobalVariableManager globalVariableManager) {
        this.fGlobalVariableManager = globalVariableManager;
    }

    public boolean isPostMortem() {
        return false;
    }

    public IAddressFactory getAddressFactory() {
        IBinaryParser.IBinaryObject file;
        if (this.fAddressFactory == null && this.getExecFile() != null && this.getProject() != null && (file = this.getBinaryFile()) != null) {
            this.fAddressFactory = file.getAddressFactory();
        }
        return this.fAddressFactory;
    }

    private CMemoryBlockRetrievalExtension getMemoryBlockRetrieval() {
        return this.fMemoryBlockRetrieval;
    }

    private void setMemoryBlockRetrieval(CMemoryBlockRetrievalExtension memoryBlockRetrieval) {
        this.fMemoryBlockRetrieval = memoryBlockRetrieval;
    }

    private void changeState(CDebugElementState state) {
        this.setState(state);
        Iterator it = this.getThreadList().iterator();
        while (it.hasNext()) {
            ((CThread)it.next()).setState(state);
        }
    }

    protected void restoreOldState() {
        this.restoreState();
        Iterator it = this.getThreadList().iterator();
        while (it.hasNext()) {
            ((CThread)it.next()).restoreState();
        }
    }

    private void handleSymbolsLoaded(ICDISharedLibrary library) {
        this.getModuleManager().symbolsLoaded(library);
    }

    public ICGlobalVariable createGlobalVariable(IGlobalVariableDescriptor info) throws DebugException {
        ICDIGlobalVariableDescriptor vo = null;
        try {
            vo = this.getCDITarget().getGlobalVariableDescriptors(info.getPath().lastSegment(), null, info.getName());
        }
        catch (CDIException e) {
            throw new DebugException((IStatus)new Status(4, CDIDebugModel.getPluginIdentifier(), 5010, vo != null ? String.valueOf(vo.getName()) + ": " + e.getMessage() : e.getMessage(), null));
        }
        return CVariableFactory.createGlobalVariable(this, info, vo);
    }

    public boolean hasModules() throws DebugException {
        CModuleManager mm = this.getModuleManager();
        return mm != null ? mm.hasModules() : false;
    }

    public ICModule[] getModules() throws DebugException {
        CModuleManager mm = this.getModuleManager();
        return mm != null ? mm.getModules() : new ICModule[]{};
    }

    public void loadSymbolsForAllModules() throws DebugException {
        CModuleManager mm = this.getModuleManager();
        mm.loadSymbolsForAll();
    }

    public void sourceContainersChanged(ISourceLookupDirector director) {
        this.setSourceLookupPath(director.getSourceContainers());
    }

    private void setSourceLookupPath(ISourceContainer[] containers) {
        String[] paths = this.getSourceLookupPath(containers);
        try {
            this.getCDITarget().setSourcePaths(paths);
        }
        catch (CDIException e) {
            CDebugCorePlugin.log(e);
        }
    }

    private String[] getSourceLookupPath(ISourceContainer[] containers) {
        ArrayList cList = new ArrayList(containers.length);
        this.getSourceContainers(cList, containers);
        ArrayList<String> list = new ArrayList<String>(cList.size());
        Iterator it = cList.iterator();
        while (it.hasNext()) {
            File dir;
            IContainer container;
            IProject project;
            ISourceContainer c = (ISourceContainer)it.next();
            if (c instanceof ProjectSourceContainer && (project = ((ProjectSourceContainer)c).getProject()) != null && project.exists()) {
                list.add(project.getLocation().toPortableString());
            }
            if (c instanceof FolderSourceContainer && (container = ((FolderSourceContainer)c).getContainer()) != null && container.exists()) {
                list.add(container.getLocation().toPortableString());
            }
            if (!(c instanceof CDirectorySourceContainer) || (dir = ((CDirectorySourceContainer)c).getDirectory()) == null || !dir.exists()) continue;
            Path path = new Path(dir.getAbsolutePath());
            list.add(path.toPortableString());
        }
        cList.clear();
        return list.toArray(new String[list.size()]);
    }

    private void getSourceContainers(List list, ISourceContainer[] containers) {
        int i = 0;
        while (i < containers.length) {
            if (!list.contains(containers[i])) {
                list.add(containers[i]);
                if (containers[i].isComposite()) {
                    try {
                        this.getSourceContainers(list, containers[i].getSourceContainers());
                    }
                    catch (CoreException e) {
                        CDebugCorePlugin.log(e.getStatus());
                    }
                }
            }
            ++i;
        }
    }

    public IRegisterDescriptor[] getRegisterDescriptors() throws DebugException {
        return this.getRegisterManager().getAllRegisterDescriptors();
    }

    public void addRegisterGroup(String name, IRegisterDescriptor[] descriptors) {
        this.getRegisterManager().addRegisterGroup(name, descriptors);
    }

    public void removeRegisterGroups(IRegisterGroup[] groups) {
        this.getRegisterManager().removeRegisterGroups(groups);
    }

    public void modifyRegisterGroup(IPersistableRegisterGroup group, IRegisterDescriptor[] descriptors) {
        this.getRegisterManager().modifyRegisterGroup(group, descriptors);
    }

    public void restoreDefaultRegisterGroups() {
        this.getRegisterManager().restoreDefaults();
    }

    protected void skipBreakpoints(boolean enabled) {
        this.getBreakpointManager().skipBreakpoints(enabled);
    }

    protected void stopInMain() throws DebugException {
        block2: {
            ICDIFunctionLocation location = this.getCDITarget().createFunctionLocation("", "main");
            try {
                this.setInternalTemporaryBreakpoint(location);
            }
            catch (DebugException e) {
                String message = MessageFormat.format(DebugCoreMessages.getString("CDebugModel.0"), e.getStatus().getMessage());
                Status newStatus = new Status(2, e.getStatus().getPlugin(), 10000, message, null);
                if (CDebugUtils.question((IStatus)newStatus, this)) break block2;
                this.terminate();
                throw new DebugException((IStatus)new Status(0, e.getStatus().getPlugin(), e.getStatus().getCode(), e.getStatus().getMessage(), null));
            }
        }
    }
}

