/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.browser.util;

import java.util.ArrayList;

public class SimpleStack {
    private static int INITIAL_STACK_SIZE = 10;
    private ArrayList items;
    private static boolean VERBOSE = false;

    public SimpleStack() {
        this.items = new ArrayList(INITIAL_STACK_SIZE);
    }

    public SimpleStack(int initialSize) {
        this.items = new ArrayList(initialSize);
    }

    public void clear() {
        this.items.clear();
    }

    public Object push(Object item) {
        this.items.add(item);
        if (VERBOSE) {
            SimpleStack.trace("push on stack: " + item);
        }
        return item;
    }

    public Object pop() {
        int top = this.items.size() - 1;
        if (top < 0) {
            return null;
        }
        Object item = this.items.get(top);
        this.items.remove(top);
        if (VERBOSE) {
            SimpleStack.trace("pop from stack: " + item);
        }
        return item;
    }

    public Object top() {
        int top = this.items.size() - 1;
        if (top < 0) {
            return null;
        }
        return this.items.get(top);
    }

    public Object bottom() {
        if (this.items.size() == 0) {
            return null;
        }
        return this.items.get(0);
    }

    public boolean isEmpty() {
        return this.items.size() == 0;
    }

    public Object[] toArray() {
        return this.items.toArray();
    }

    public Object[] toArray(Object[] a) {
        return this.items.toArray(a);
    }

    private static void trace(String msg) {
        System.out.println("(" + Thread.currentThread() + ") " + msg);
    }
}

