/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.properties;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOptionApplicability;
import org.eclipse.cdt.managedbuilder.core.IOptionCategory;
import org.eclipse.cdt.managedbuilder.core.IResourceConfiguration;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.ui.properties.AbstractBuildPropertyPage;
import org.eclipse.cdt.managedbuilder.ui.properties.BuildOptionComboFieldEditor;
import org.eclipse.cdt.managedbuilder.ui.properties.BuildSettingsPage;
import org.eclipse.cdt.managedbuilder.ui.properties.FileListControlFieldEditor;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;

public class BuildOptionSettingsPage
extends BuildSettingsPage {
    private Map fieldsMap = new HashMap();
    private IOptionCategory clonedCategory;
    private boolean isItResourceConfigPage;
    private Map fieldEditorsToParentMap = new HashMap();
    private AbstractBuildPropertyPage buildPropPage;

    public BuildOptionSettingsPage(AbstractBuildPropertyPage page, IConfiguration clonedConfig, IOptionCategory clonedCategory) {
        super(clonedConfig);
        this.clonedCategory = clonedCategory;
        this.isItResourceConfigPage = false;
        this.buildPropPage = page;
    }

    public BuildOptionSettingsPage(AbstractBuildPropertyPage page, IResourceConfiguration clonedResConfig, IOptionCategory clonedCategory) {
        super(clonedResConfig);
        this.clonedCategory = clonedCategory;
        this.isItResourceConfigPage = true;
        this.buildPropPage = page;
    }

    public Point computeSize() {
        return super.computeSize();
    }

    protected void createFieldEditors() {
        super.createFieldEditors();
        Object[][] options = this.isItResourceConfigPage ? this.clonedCategory.getOptions(this.clonedResConfig) : this.clonedCategory.getOptions(this.clonedConfig);
        int index = 0;
        while (index < options.length) {
            IHoldsOptions holder = (IHoldsOptions)options[index][0];
            if (holder == null) break;
            IOption opt = (IOption)options[index][1];
            String prefName = this.getToolSettingsPreferenceStore().getOptionPrefName(opt);
            IOptionApplicability applicabilityCalculator = opt.getApplicabilityCalculator();
            Object config = this.isItResourceConfigPage ? this.clonedResConfig : this.clonedConfig;
            if (applicabilityCalculator == null || applicabilityCalculator.isOptionVisible((IBuildObject)config, holder, opt)) {
                try {
                    block2 : switch (opt.getValueType()) {
                        case 2: {
                            switch (opt.getBrowseType()) {
                                case 2: {
                                    Composite fieldEditorParent2 = this.getFieldEditorParent();
                                    DirectoryFieldEditor dirFieldEditor = new DirectoryFieldEditor(prefName, opt.getName(), fieldEditorParent2);
                                    this.setFieldEditorEnablement(holder, opt, applicabilityCalculator, (FieldEditor)dirFieldEditor, fieldEditorParent2);
                                    this.addField((FieldEditor)dirFieldEditor);
                                    this.fieldsMap.put(prefName, dirFieldEditor);
                                    this.fieldEditorsToParentMap.put(dirFieldEditor, fieldEditorParent2);
                                    break block2;
                                }
                                case 1: {
                                    Composite fieldEditorParent3 = this.getFieldEditorParent();
                                    FileFieldEditor fileFieldEditor = new FileFieldEditor(prefName, opt.getName(), fieldEditorParent3);
                                    this.setFieldEditorEnablement(holder, opt, applicabilityCalculator, (FieldEditor)fileFieldEditor, fieldEditorParent3);
                                    this.addField((FieldEditor)fileFieldEditor);
                                    this.fieldsMap.put(prefName, fileFieldEditor);
                                    this.fieldEditorsToParentMap.put(fileFieldEditor, fieldEditorParent3);
                                    break block2;
                                }
                                case 0: {
                                    Composite fieldEditorParent4 = this.getFieldEditorParent();
                                    StringFieldEditor stringField = new StringFieldEditor(prefName, opt.getName(), fieldEditorParent4);
                                    this.setFieldEditorEnablement(holder, opt, applicabilityCalculator, (FieldEditor)stringField, fieldEditorParent4);
                                    this.addField((FieldEditor)stringField);
                                    this.fieldsMap.put(prefName, stringField);
                                    this.fieldEditorsToParentMap.put(stringField, fieldEditorParent4);
                                    break block2;
                                }
                            }
                            throw new AssertionError();
                        }
                        case 0: {
                            Composite fieldEditorParent5 = this.getFieldEditorParent();
                            BooleanFieldEditor booleanField = new BooleanFieldEditor(prefName, opt.getName(), fieldEditorParent5);
                            this.setFieldEditorEnablement(holder, opt, applicabilityCalculator, (FieldEditor)booleanField, fieldEditorParent5);
                            this.addField((FieldEditor)booleanField);
                            this.fieldsMap.put(prefName, booleanField);
                            this.fieldEditorsToParentMap.put(booleanField, fieldEditorParent5);
                            break;
                        }
                        case 1: {
                            String sel;
                            try {
                                String selId = opt.getSelectedEnum();
                                sel = opt.getEnumName(selId);
                            }
                            catch (BuildException buildException) {
                                break;
                            }
                            String[] enumNames = opt.getApplicableValues();
                            Vector<String> enumValidList = new Vector<String>();
                            int i = 0;
                            while (i < enumNames.length) {
                                if (opt.getValueHandler().isEnumValueAppropriate((IBuildObject)config, opt.getOptionHolder(), opt, opt.getValueHandlerExtraArgument(), enumNames[i])) {
                                    enumValidList.add(enumNames[i]);
                                }
                                ++i;
                            }
                            Object[] enumValidNames = new String[enumValidList.size()];
                            enumValidList.copyInto(enumValidNames);
                            Composite fieldEditorParent6 = this.getFieldEditorParent();
                            BuildOptionComboFieldEditor comboField = new BuildOptionComboFieldEditor(prefName, opt.getName(), (String[])enumValidNames, sel, fieldEditorParent6);
                            this.setFieldEditorEnablement(holder, opt, applicabilityCalculator, comboField, fieldEditorParent6);
                            this.addField(comboField);
                            this.fieldsMap.put(prefName, comboField);
                            this.fieldEditorsToParentMap.put(comboField, fieldEditorParent6);
                            break;
                        }
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: {
                            Composite fieldEditorParent7 = this.getFieldEditorParent();
                            FileListControlFieldEditor listField = new FileListControlFieldEditor(prefName, opt.getName(), fieldEditorParent7, opt.getBrowseType());
                            this.setFieldEditorEnablement(holder, opt, applicabilityCalculator, listField, fieldEditorParent7);
                            this.addField(listField);
                            this.fieldsMap.put(prefName, listField);
                            this.fieldEditorsToParentMap.put(listField, fieldEditorParent7);
                            break;
                        }
                    }
                }
                catch (BuildException buildException) {}
            }
            ++index;
        }
    }

    public boolean isForCategory(IOptionCategory category) {
        if (category != null) {
            return category.equals(this.clonedCategory);
        }
        return false;
    }

    public boolean performOk() {
        Object[][] clonedOptions;
        boolean ok = super.performOk();
        IResourceConfiguration realRcCfg = null;
        IConfiguration realCfg = null;
        IResourceConfiguration handler = null;
        if (this.isItResourceConfigPage) {
            realRcCfg = this.buildPropPage.getRealRcConfig(this.clonedResConfig);
            if (realRcCfg == null) {
                return false;
            }
            handler = realRcCfg;
            clonedOptions = this.clonedCategory.getOptions(this.clonedResConfig);
        } else {
            realCfg = this.buildPropPage.getRealConfig(this.clonedConfig);
            if (realCfg == null) {
                return false;
            }
            handler = realCfg;
            clonedOptions = this.clonedCategory.getOptions(this.clonedConfig);
        }
        int i = 0;
        while (i < clonedOptions.length) {
            IOption realOption;
            IHoldsOptions clonedHolder = (IHoldsOptions)clonedOptions[i][0];
            if (clonedHolder == null) break;
            IOption clonedOption = (IOption)clonedOptions[i][1];
            IHoldsOptions realHolder = this.buildPropPage.getRealHoldsOptions(clonedHolder);
            if (realHolder != null && (realOption = this.buildPropPage.getRealOption(clonedOption, clonedHolder)) != null) {
                try {
                    IOption setOption = null;
                    switch (clonedOption.getValueType()) {
                        case 0: {
                            boolean boolVal = clonedOption.getBooleanValue();
                            if (this.isItResourceConfigPage) {
                                setOption = ManagedBuildManager.setOption((IResourceConfiguration)realRcCfg, (IHoldsOptions)realHolder, (IOption)realOption, (boolean)boolVal);
                                break;
                            }
                            setOption = ManagedBuildManager.setOption((IConfiguration)realCfg, (IHoldsOptions)realHolder, (IOption)realOption, (boolean)boolVal);
                            break;
                        }
                        case 1: {
                            String enumVal = clonedOption.getStringValue();
                            String enumId = clonedOption.getEnumeratedId(enumVal);
                            if (this.isItResourceConfigPage) {
                                setOption = ManagedBuildManager.setOption((IResourceConfiguration)realRcCfg, (IHoldsOptions)realHolder, (IOption)realOption, (String)(enumId != null && enumId.length() > 0 ? enumId : enumVal));
                                break;
                            }
                            setOption = ManagedBuildManager.setOption((IConfiguration)realCfg, (IHoldsOptions)realHolder, (IOption)realOption, (String)(enumId != null && enumId.length() > 0 ? enumId : enumVal));
                            break;
                        }
                        case 2: {
                            String strVal = clonedOption.getStringValue();
                            if (this.isItResourceConfigPage) {
                                setOption = ManagedBuildManager.setOption((IResourceConfiguration)realRcCfg, (IHoldsOptions)realHolder, (IOption)realOption, (String)strVal);
                                break;
                            }
                            setOption = ManagedBuildManager.setOption((IConfiguration)realCfg, (IHoldsOptions)realHolder, (IOption)realOption, (String)strVal);
                            break;
                        }
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: {
                            String[] listVal = ((List)clonedOption.getValue()).toArray(new String[0]);
                            if (this.isItResourceConfigPage) {
                                setOption = ManagedBuildManager.setOption((IResourceConfiguration)realRcCfg, (IHoldsOptions)realHolder, (IOption)realOption, (String[])listVal);
                                break;
                            }
                            setOption = ManagedBuildManager.setOption((IConfiguration)realCfg, (IHoldsOptions)realHolder, (IOption)realOption, (String[])listVal);
                            break;
                        }
                    }
                    if (setOption == null) {
                        setOption = realOption;
                    }
                    setOption.getValueHandler().handleValue((IBuildObject)handler, setOption.getOptionHolder(), setOption, setOption.getValueHandlerExtraArgument(), 4);
                }
                catch (BuildException buildException) {
                }
                catch (ClassCastException classCastException) {}
            }
            ++i;
        }
        return ok;
    }

    public void updateFields() {
        Object[][] options = this.isItResourceConfigPage ? this.clonedCategory.getOptions(this.clonedResConfig) : this.clonedCategory.getOptions(this.clonedConfig);
        int index = 0;
        while (index < options.length) {
            IOptionApplicability applicabilityCalculator;
            IHoldsOptions holder = (IHoldsOptions)options[index][0];
            if (holder == null) break;
            IOption opt = (IOption)options[index][1];
            String prefName = this.getToolSettingsPreferenceStore().getOptionPrefName(opt);
            if (this.fieldsMap.containsKey(prefName) && (applicabilityCalculator = opt.getApplicabilityCalculator()) != null) {
                FieldEditor fieldEditor = (FieldEditor)this.fieldsMap.get(prefName);
                Composite parent = (Composite)this.fieldEditorsToParentMap.get(fieldEditor);
                this.setFieldEditorEnablement(holder, opt, applicabilityCalculator, fieldEditor, parent);
            }
            ++index;
        }
        Collection fieldsList = this.fieldsMap.values();
        Iterator iter = fieldsList.iterator();
        while (iter.hasNext()) {
            FieldEditor editor = (FieldEditor)iter.next();
            editor.load();
        }
    }

    public void storeSettings() {
    }

    private void setFieldEditorEnablement(IHoldsOptions holder, IOption option, IOptionApplicability optionApplicability, FieldEditor fieldEditor, Composite parent) {
        if (optionApplicability == null) {
            return;
        }
        Object config = this.isItResourceConfigPage ? this.clonedResConfig : this.clonedConfig;
        if (!optionApplicability.isOptionEnabled((IBuildObject)config, holder, option)) {
            fieldEditor.setEnabled(false, parent);
        } else {
            fieldEditor.setEnabled(true, parent);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        Object source = event.getSource();
        IOption changedOption = null;
        IHoldsOptions changedHolder = null;
        String id = null;
        if (source instanceof FieldEditor) {
            FieldEditor fe = (FieldEditor)source;
            id = fe.getPreferenceName();
            Object[] option = this.getToolSettingsPreferenceStore().getOption(id);
            if (option != null) {
                changedOption = (IOption)option[1];
                changedHolder = (IHoldsOptions)option[0];
                try {
                    switch (changedOption.getValueType()) {
                        case 2: {
                            if (fe instanceof StringFieldEditor) {
                                String val = ((StringFieldEditor)fe).getStringValue();
                                if (this.isItResourceConfigPage) {
                                    this.clonedResConfig.setOption(changedHolder, changedOption, val);
                                    break;
                                }
                                this.clonedConfig.setOption(changedHolder, changedOption, val);
                            }
                            break;
                        }
                        case 0: {
                            if (fe instanceof BooleanFieldEditor) {
                                boolean val = ((BooleanFieldEditor)fe).getBooleanValue();
                                if (this.isItResourceConfigPage) {
                                    this.clonedResConfig.setOption(changedHolder, changedOption, val);
                                    break;
                                }
                                this.clonedConfig.setOption(changedHolder, changedOption, val);
                            }
                            break;
                        }
                        case 1: {
                            if (fe instanceof BuildOptionComboFieldEditor) {
                                String name = ((BuildOptionComboFieldEditor)fe).getSelection();
                                String enumId = changedOption.getEnumeratedId(name);
                                if (this.isItResourceConfigPage) {
                                    this.clonedResConfig.setOption(changedHolder, changedOption, enumId != null && enumId.length() > 0 ? enumId : name);
                                    break;
                                }
                                this.clonedConfig.setOption(changedHolder, changedOption, enumId != null && enumId.length() > 0 ? enumId : name);
                            }
                            break;
                        }
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: {
                            if (fe instanceof FileListControlFieldEditor) {
                                String[] val = ((FileListControlFieldEditor)fe).getStringListValue();
                                if (this.isItResourceConfigPage) {
                                    this.clonedResConfig.setOption(changedHolder, changedOption, val);
                                    break;
                                }
                                this.clonedConfig.setOption(changedHolder, changedOption, val);
                            }
                            break;
                        }
                    }
                }
                catch (BuildException buildException) {}
            }
        }
        Object[][] options = this.isItResourceConfigPage ? this.clonedCategory.getOptions(this.clonedResConfig) : this.clonedCategory.getOptions(this.clonedConfig);
        int index = 0;
        while (index < options.length) {
            IOptionApplicability applicabilityCalculator;
            IHoldsOptions holder = (IHoldsOptions)options[index][0];
            if (holder == null) break;
            IOption opt = (IOption)options[index][1];
            String prefName = this.getToolSettingsPreferenceStore().getOptionPrefName(opt);
            if (this.fieldsMap.containsKey(prefName) && (applicabilityCalculator = opt.getApplicabilityCalculator()) != null) {
                FieldEditor fieldEditor = (FieldEditor)this.fieldsMap.get(prefName);
                Composite parent = (Composite)this.fieldEditorsToParentMap.get(fieldEditor);
                this.setFieldEditorEnablement(holder, opt, applicabilityCalculator, fieldEditor, parent);
            }
            ++index;
        }
        Iterator iter = this.fieldsMap.values().iterator();
        while (iter.hasNext()) {
            FieldEditor editor = (FieldEditor)iter.next();
            if (id != null && id.equals(editor.getPreferenceName())) continue;
            editor.load();
        }
    }
}

