/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.propertypages;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.cdt.debug.core.model.ICModule;

public class ModuleProperties {
    public static final String TYPE = "type";
    public static final String CPU = "cpu";
    public static final String BASE_ADDRESS = "baseAddress";
    public static final String SIZE = "size";
    public static final String SYMBOLS_LOADED = "symbolsLoaded";
    public static final String SYMBOLS_FILE = "symbolsFile";
    private ArrayList fProperties = new ArrayList(10);
    private boolean fIsDirty = false;

    static ModuleProperties create(ICModule module) {
        return new ModuleProperties(module);
    }

    private ModuleProperties(ICModule module) {
        this.fProperties.add(new Property(TYPE, new Integer(module.getType())));
        this.fProperties.add(new Property(CPU, module.getCPU()));
        this.fProperties.add(new Property(BASE_ADDRESS, module.getBaseAddress()));
        this.fProperties.add(new Property(SIZE, new Long(module.getSize())));
        this.fProperties.add(new Property(SYMBOLS_LOADED, new Boolean(module.areSymbolsLoaded())));
        this.fProperties.add(new Property(SYMBOLS_FILE, module.getSymbolsFileName()));
    }

    public Property[] getProperties() {
        return this.fProperties.toArray(new Property[this.fProperties.size()]);
    }

    public Object getProperty(String key) {
        return this.find(key).getValue();
    }

    public void setProperty(String key, Object value) {
        Property p = this.find(key);
        if (!p.getValue().equals(value)) {
            this.fProperties.set(this.fProperties.indexOf(p), new Property(key, value));
            this.setDirty(true);
        }
    }

    public boolean isDirty() {
        return this.fIsDirty;
    }

    public void dispose() {
        this.fProperties.clear();
    }

    private void setDirty(boolean dirty) {
        this.fIsDirty = dirty;
    }

    private Property find(String key) {
        Iterator it = this.fProperties.iterator();
        while (it.hasNext()) {
            Property p = (Property)it.next();
            if (!p.getKey().equals(key)) continue;
            return p;
        }
        throw new IllegalArgumentException(key);
    }

    public class Property {
        private String fKey;
        private Object fValue;

        public Property(String key, Object value) {
            this.fKey = key;
            this.fValue = value;
        }

        public String getKey() {
            return this.fKey;
        }

        public Object getValue() {
            return this.fValue;
        }

        public String toString() {
            String result = "";
            if (this.getKey() != null) {
                result = String.valueOf(result) + this.getKey();
            }
            if (this.getValue() != null) {
                result = String.valueOf(result) + "=";
                result = String.valueOf(result) + this.getValue().toString();
            }
            return result;
        }
    }
}

