/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.TreeItem;

public abstract class AbstractViewerState {
    private List fExpandedElements = null;
    private IPath[] fSelection = null;

    public AbstractViewerState(TreeViewer viewer) {
        this.saveState(viewer);
    }

    public void saveState(TreeViewer viewer) {
        ArrayList expanded = new ArrayList();
        this.fExpandedElements = null;
        TreeItem[] items = viewer.getTree().getItems();
        try {
            int i = 0;
            while (i < items.length) {
                this.collectExandedItems(items[i], expanded);
                ++i;
            }
            if (expanded.size() > 0) {
                this.fExpandedElements = expanded;
            }
        }
        catch (DebugException debugException) {
            this.fExpandedElements = null;
        }
        TreeItem[] selection = viewer.getTree().getSelection();
        this.fSelection = new IPath[selection.length];
        try {
            int i = 0;
            while (i < selection.length) {
                this.fSelection[i] = this.encodeElement(selection[i]);
                ++i;
            }
        }
        catch (DebugException debugException) {
            this.fSelection = null;
        }
    }

    protected void collectExandedItems(TreeItem item, List expanded) throws DebugException {
        if (item.getExpanded()) {
            expanded.add(this.encodeElement(item));
            TreeItem[] items = item.getItems();
            int i = 0;
            while (i < items.length) {
                this.collectExandedItems(items[i], expanded);
                ++i;
            }
        }
    }

    protected abstract IPath encodeElement(TreeItem var1) throws DebugException;

    public void restoreState(TreeViewer viewer) {
        Object obj;
        IPath path;
        int i;
        if (this.fExpandedElements != null) {
            ArrayList<Object> expansion = new ArrayList<Object>(this.fExpandedElements.size());
            i = 0;
            while (i < this.fExpandedElements.size()) {
                path = (IPath)this.fExpandedElements.get(i);
                if (path != null) {
                    try {
                        obj = this.decodePath(path, viewer);
                        if (obj != null) {
                            expansion.add(obj);
                        }
                    }
                    catch (DebugException debugException) {}
                }
                ++i;
            }
            viewer.setExpandedElements(expansion.toArray());
        }
        if (this.fSelection != null) {
            ArrayList<Object> selection = new ArrayList<Object>(this.fSelection.length);
            i = 0;
            while (i < this.fSelection.length) {
                path = this.fSelection[i];
                try {
                    obj = this.decodePath(path, viewer);
                    if (obj != null) {
                        selection.add(obj);
                    }
                }
                catch (DebugException debugException) {}
                ++i;
            }
            viewer.setSelection((ISelection)new StructuredSelection(selection));
        }
    }

    protected abstract Object decodePath(IPath var1, TreeViewer var2) throws DebugException;
}

