/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.scannerconfig.gnu;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoCollector;
import org.eclipse.cdt.make.core.scannerconfig.ScannerInfoTypes;
import org.eclipse.cdt.make.internal.core.scannerconfig.gnu.AbstractGCCBOPConsoleParser;
import org.eclipse.cdt.make.internal.core.scannerconfig.gnu.AbstractGCCBOPConsoleParserUtility;
import org.eclipse.cdt.make.internal.core.scannerconfig.gnu.GCCPerFileBOPConsoleParserUtility;
import org.eclipse.cdt.make.internal.core.scannerconfig.util.CCommandDSC;
import org.eclipse.cdt.make.internal.core.scannerconfig.util.TraceUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;

public class GCCPerFileBOPConsoleParser
extends AbstractGCCBOPConsoleParser {
    private static final String[] FILE_EXTENSIONS = new String[]{".c", ".cc", ".cpp", ".cxx", ".C", ".CC", ".CPP", ".CXX"};
    private static final List FILE_EXTENSIONS_LIST = Arrays.asList(FILE_EXTENSIONS);
    private String[] compilerInvocation;
    private GCCPerFileBOPConsoleParserUtility fUtil;

    public void startup(IProject project, IPath workingDirectory, IScannerInfoCollector collector, IMarkerGenerator markerGenerator) {
        this.fUtil = project != null && workingDirectory != null && markerGenerator != null ? new GCCPerFileBOPConsoleParserUtility(project, workingDirectory, markerGenerator) : null;
        super.startup(project, collector);
        this.compilerInvocation = this.getCompilerCommands();
    }

    protected AbstractGCCBOPConsoleParserUtility getUtility() {
        return this.fUtil;
    }

    protected boolean processSingleLine(String line) {
        boolean rc = false;
        int compilerInvocationIndex = -1;
        int cii = 0;
        while (cii < this.compilerInvocation.length) {
            compilerInvocationIndex = line.indexOf(this.compilerInvocation[cii]);
            if (compilerInvocationIndex != -1) break;
            ++cii;
        }
        if (compilerInvocationIndex == -1) {
            return rc;
        }
        String[] split = line.split("\\s+");
        String command = split[0];
        int cii2 = -1;
        int cii3 = 0;
        while (cii3 < this.compilerInvocation.length) {
            cii2 = command.indexOf(this.compilerInvocation[cii3]);
            if (cii2 != -1) break;
            ++cii3;
        }
        if (cii2 == -1) {
            TraceUtil.outputTrace("Error identifying compiler command", line, TraceUtil.EOL);
            return rc;
        }
        int extensionsIndex = -1;
        boolean found = false;
        String filePath = null;
        int i = 1;
        while (i < split.length) {
            String fileExtension;
            int k = split[i].lastIndexOf(46);
            if (k != -1 && split[i].length() - k < 5 && (extensionsIndex = FILE_EXTENSIONS_LIST.indexOf(fileExtension = split[i].substring(k))) != -1) {
                filePath = split[i];
                found = true;
                break;
            }
            ++i;
        }
        if (!found) {
            TraceUtil.outputTrace("Error identifying file name :1", line, TraceUtil.EOL);
            return rc;
        }
        if (filePath.indexOf(FILE_EXTENSIONS[extensionsIndex]) == -1) {
            TraceUtil.outputTrace("Error identifying file name :2", line, TraceUtil.EOL);
            return rc;
        }
        if (this.fUtil != null) {
            IPath pFilePath = this.fUtil.getAbsolutePath(filePath);
            String shortFileName = pFilePath.removeFileExtension().lastSegment();
            StringBuffer genericLine = new StringBuffer();
            int i2 = 0;
            while (i2 < split.length) {
                String token = split[i2];
                if (token.equals("-include") || token.equals("-imacros")) {
                    ++i2;
                    genericLine.append(token);
                    genericLine.append(' ');
                } else if (token.equals(filePath)) {
                    split[i2] = "LONG_NAME";
                } else if (token.startsWith(shortFileName)) {
                    split[i2] = token.replaceFirst(shortFileName, "SHORT_NAME");
                }
                genericLine.append(split[i2]);
                genericLine.append(' ');
                ++i2;
            }
            CCommandDSC cmd = this.fUtil.getNewCCommandDSC(genericLine.toString(), extensionsIndex > 0);
            if (this.getProject().getLocation().isPrefixOf(pFilePath)) {
                ArrayList<CCommandDSC> cmdList = new ArrayList<CCommandDSC>();
                cmdList.add(cmd);
                HashMap<ScannerInfoTypes, ArrayList<CCommandDSC>> sc = new HashMap<ScannerInfoTypes, ArrayList<CCommandDSC>>(1);
                sc.put(ScannerInfoTypes.COMPILER_COMMAND, cmdList);
                IPath relPath = pFilePath.removeFirstSegments(this.getProject().getLocation().segmentCount());
                IFile file = this.getProject().getFile(relPath);
                this.getCollector().contributeToScannerConfig(file, sc);
            }
        }
        return rc;
    }
}

