/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.util.ArrayList;
import java.util.SortedMap;
import java.util.StringTokenizer;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedConfigElement;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.BuildObject;
import org.eclipse.cdt.managedbuilder.internal.core.DefaultManagedConfigElement;
import org.eclipse.cdt.managedbuilder.internal.core.ToolChain;
import org.eclipse.cdt.managedbuilder.internal.macros.FileContextBuildMacroValues;
import org.eclipse.cdt.managedbuilder.macros.IFileContextBuildMacroValues;
import org.eclipse.cdt.managedbuilder.macros.IReservedMacroNameSupplier;
import org.eclipse.cdt.managedbuilder.makegen.IManagedBuilderMakefileGenerator;
import org.eclipse.cdt.managedbuilder.makegen.gnu.GnuMakefileGenerator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Builder
extends BuildObject
implements IBuilder {
    private static final String EMPTY_STRING = new String();
    private IBuilder superClass;
    private String superClassId;
    private IToolChain parent;
    private String unusedChildren;
    private String errorParserIds;
    private Boolean isAbstract;
    private String command;
    private String args;
    private IConfigurationElement buildFileGeneratorElement;
    private String versionsSupported;
    private String convertToId;
    private FileContextBuildMacroValues fileContextBuildMacroValues;
    private String builderVariablePattern;
    private Boolean isVariableCaseSensitive;
    private String[] reservedMacroNames;
    private IReservedMacroNameSupplier reservedMacroNameSupplier;
    private IConfigurationElement reservedMacroNameSupplierElement;
    private boolean isExtensionBuilder = false;
    private boolean isDirty = false;
    private boolean resolved = true;
    private IConfigurationElement previousMbsVersionConversionElement = null;
    private IConfigurationElement currentMbsVersionConversionElement = null;

    public Builder(IToolChain parent, IManagedConfigElement element, String managedBuildRevision) {
        this.parent = parent;
        this.isExtensionBuilder = true;
        this.resolved = false;
        this.setManagedBuildRevision(managedBuildRevision);
        this.loadFromManifest(element);
        ManagedBuildManager.addExtensionBuilder(this);
    }

    public Builder(ToolChain parent, IBuilder superClass, String Id, String name, boolean isExtensionElement) {
        this.parent = parent;
        this.superClass = superClass;
        this.setManagedBuildRevision(parent.getManagedBuildRevision());
        if (this.superClass != null) {
            this.superClassId = this.superClass.getId();
        }
        this.setId(Id);
        this.setName(name);
        this.setVersion(this.getVersionFromId());
        this.isExtensionBuilder = isExtensionElement;
        if (isExtensionElement) {
            ManagedBuildManager.addExtensionBuilder(this);
        } else {
            this.setDirty(true);
        }
    }

    public Builder(IToolChain parent, Element element, String managedBuildRevision) {
        this.parent = parent;
        this.isExtensionBuilder = false;
        this.setManagedBuildRevision(managedBuildRevision);
        this.loadFromProject(element);
    }

    public Builder(IToolChain parent, String Id, String name, Builder builder) {
        this.parent = parent;
        this.superClass = builder.superClass;
        if (this.superClass != null && builder.superClassId != null) {
            this.superClassId = new String(builder.superClassId);
        }
        this.setId(Id);
        this.setName(name);
        this.setManagedBuildRevision(builder.getManagedBuildRevision());
        this.setVersion(this.getVersionFromId());
        this.isExtensionBuilder = false;
        if (builder.versionsSupported != null) {
            this.versionsSupported = new String(builder.versionsSupported);
        }
        if (builder.convertToId != null) {
            this.convertToId = new String(builder.convertToId);
        }
        if (builder.unusedChildren != null) {
            this.unusedChildren = new String(builder.unusedChildren);
        }
        if (builder.errorParserIds != null) {
            this.errorParserIds = new String(builder.errorParserIds);
        }
        if (builder.isAbstract != null) {
            this.isAbstract = new Boolean(builder.isAbstract);
        }
        if (builder.command != null) {
            this.command = new String(builder.command);
        }
        if (builder.args != null) {
            this.args = new String(builder.args);
        }
        this.buildFileGeneratorElement = builder.buildFileGeneratorElement;
        if (builder.fileContextBuildMacroValues != null) {
            this.fileContextBuildMacroValues = (FileContextBuildMacroValues)builder.fileContextBuildMacroValues.clone();
            this.fileContextBuildMacroValues.setBuilder(this);
        }
        this.builderVariablePattern = builder.builderVariablePattern;
        if (builder.isVariableCaseSensitive != null) {
            this.isVariableCaseSensitive = new Boolean(builder.isVariableCaseSensitive);
        }
        if (builder.reservedMacroNames != null) {
            this.reservedMacroNames = (String[])builder.reservedMacroNames.clone();
        }
        this.reservedMacroNameSupplierElement = builder.reservedMacroNameSupplierElement;
        this.reservedMacroNameSupplier = builder.reservedMacroNameSupplier;
        this.setDirty(true);
    }

    protected void loadFromManifest(IManagedConfigElement element) {
        String isAbs;
        String reservedMacroNameSupplier;
        String reservedNames;
        ManagedBuildManager.putConfigElement(this, element);
        this.setId(element.getAttribute("id"));
        this.setName(element.getAttribute("name"));
        this.setVersion(this.getVersionFromId());
        this.superClassId = element.getAttribute("superClass");
        this.unusedChildren = element.getAttribute("unusedChildren");
        this.versionsSupported = element.getAttribute("versionsSupported");
        this.convertToId = element.getAttribute("convertToId");
        this.builderVariablePattern = element.getAttribute("variableFormat");
        String isCS = element.getAttribute("isVariableCaseSensitive");
        if (isCS != null) {
            this.isVariableCaseSensitive = new Boolean("true".equals(isCS));
        }
        if ((reservedNames = element.getAttribute("reservedMacroNames")) != null) {
            this.reservedMacroNames = reservedNames.split(",");
        }
        if ((reservedMacroNameSupplier = element.getAttribute("reservedMacroNameSupplier")) != null && element instanceof DefaultManagedConfigElement) {
            this.reservedMacroNameSupplierElement = ((DefaultManagedConfigElement)element).getConfigurationElement();
        }
        if ((isAbs = element.getAttribute("isAbstract")) != null) {
            this.isAbstract = new Boolean("true".equals(isAbs));
        }
        this.command = element.getAttribute("command");
        this.args = element.getAttribute("arguments");
        this.errorParserIds = element.getAttribute("errorParsers");
        String buildfileGenerator = element.getAttribute("buildfileGenerator");
        if (buildfileGenerator != null && element instanceof DefaultManagedConfigElement) {
            this.buildFileGeneratorElement = ((DefaultManagedConfigElement)element).getConfigurationElement();
        }
        this.fileContextBuildMacroValues = new FileContextBuildMacroValues(this, element);
    }

    protected void loadFromProject(Element element) {
        String isAbs;
        this.setId(element.getAttribute("id"));
        if (element.hasAttribute("name")) {
            this.setName(element.getAttribute("name"));
        }
        this.setVersion(this.getVersionFromId());
        this.superClassId = element.getAttribute("superClass");
        if (this.superClassId != null && this.superClassId.length() > 0) {
            this.superClass = ManagedBuildManager.getExtensionBuilder(this.superClassId);
            this.checkForMigrationSupport();
        }
        if (element.hasAttribute("versionsSupported")) {
            this.versionsSupported = element.getAttribute("versionsSupported");
        }
        if (element.hasAttribute("convertToId")) {
            this.convertToId = element.getAttribute("convertToId");
        }
        if (element.hasAttribute("unusedChildren")) {
            this.unusedChildren = element.getAttribute("unusedChildren");
        }
        if (element.hasAttribute("isAbstract") && (isAbs = element.getAttribute("isAbstract")) != null) {
            this.isAbstract = new Boolean("true".equals(isAbs));
        }
        if (element.hasAttribute("command")) {
            this.command = element.getAttribute("command");
        }
        if (element.hasAttribute("arguments")) {
            this.args = element.getAttribute("arguments");
        }
        if (element.hasAttribute("errorParsers")) {
            this.errorParserIds = element.getAttribute("errorParsers");
        }
        element.hasAttribute("buildfileGenerator");
    }

    public void serialize(Document doc, Element element) {
        if (this.superClass != null) {
            element.setAttribute("superClass", this.superClass.getId());
        }
        element.setAttribute("id", this.id);
        if (this.name != null) {
            element.setAttribute("name", this.name);
        }
        if (this.unusedChildren != null) {
            element.setAttribute("unusedChildren", this.unusedChildren);
        }
        if (this.isAbstract != null) {
            element.setAttribute("isAbstract", this.isAbstract.toString());
        }
        if (this.versionsSupported != null) {
            element.setAttribute("versionsSupported", this.versionsSupported);
        }
        if (this.convertToId != null) {
            element.setAttribute("convertToId", this.convertToId);
        }
        if (this.errorParserIds != null) {
            element.setAttribute("errorParsers", this.errorParserIds);
        }
        if (this.command != null) {
            element.setAttribute("command", this.command);
        }
        if (this.args != null) {
            element.setAttribute("arguments", this.args);
        }
        this.isDirty = false;
    }

    public IToolChain getParent() {
        return this.parent;
    }

    public IBuilder getSuperClass() {
        return this.superClass;
    }

    public String getName() {
        return this.name == null && this.superClass != null ? this.superClass.getName() : this.name;
    }

    public boolean isAbstract() {
        if (this.isAbstract != null) {
            return this.isAbstract;
        }
        return false;
    }

    public String getUnusedChildren() {
        if (this.unusedChildren != null) {
            return this.unusedChildren;
        }
        return EMPTY_STRING;
    }

    public String getCommand() {
        if (this.command == null) {
            if (this.superClass != null) {
                return this.superClass.getCommand();
            }
            return new String("make");
        }
        return this.command;
    }

    public String getArguments() {
        if (this.args == null) {
            if (this.superClass != null) {
                return this.superClass.getArguments();
            }
            return new String("-k");
        }
        return this.args;
    }

    public String getErrorParserIds() {
        String ids = this.errorParserIds;
        if (ids == null && this.superClass != null) {
            ids = this.superClass.getErrorParserIds();
        }
        return ids;
    }

    public String[] getErrorParserList() {
        String parserIDs = this.getErrorParserIds();
        String[] errorParsers = null;
        if (parserIDs != null) {
            if (parserIDs.length() == 0) {
                errorParsers = new String[]{};
            } else {
                StringTokenizer tok = new StringTokenizer(parserIDs, ";");
                ArrayList<String> list = new ArrayList<String>(tok.countTokens());
                while (tok.hasMoreElements()) {
                    list.add(tok.nextToken());
                }
                String[] strArr = new String[]{""};
                errorParsers = list.toArray(strArr);
            }
        } else {
            errorParsers = new String[]{};
        }
        return errorParsers;
    }

    public void setCommand(String cmd) {
        if (cmd == null && this.command == null) {
            return;
        }
        if (this.command == null || cmd == null || !cmd.equals(this.command)) {
            this.command = cmd;
            this.setDirty(true);
        }
    }

    public void setArguments(String newArgs) {
        if (newArgs == null && this.args == null) {
            return;
        }
        if (this.args == null || newArgs == null || !newArgs.equals(this.args)) {
            this.args = newArgs;
            this.setDirty(true);
        }
    }

    public void setErrorParserIds(String ids) {
        String currentIds = this.getErrorParserIds();
        if (ids == null && currentIds == null) {
            return;
        }
        if (currentIds == null || ids == null || !currentIds.equals(ids)) {
            this.errorParserIds = ids;
            this.isDirty = true;
        }
    }

    public void setIsAbstract(boolean b) {
        this.isAbstract = new Boolean(b);
        this.setDirty(true);
    }

    public IConfigurationElement getBuildFileGeneratorElement() {
        if (this.buildFileGeneratorElement == null && this.superClass != null) {
            return ((Builder)this.superClass).getBuildFileGeneratorElement();
        }
        return this.buildFileGeneratorElement;
    }

    public IManagedBuilderMakefileGenerator getBuildFileGenerator() {
        IConfigurationElement element = this.getBuildFileGeneratorElement();
        if (element != null) {
            try {
                if (element.getName().equalsIgnoreCase("target")) {
                    if (element.getAttribute("makefileGenerator") != null) {
                        return (IManagedBuilderMakefileGenerator)element.createExecutableExtension("makefileGenerator");
                    }
                } else if (element.getAttribute("buildfileGenerator") != null) {
                    return (IManagedBuilderMakefileGenerator)element.createExecutableExtension("buildfileGenerator");
                }
            }
            catch (CoreException coreException) {
            }
            catch (ClassCastException classCastException) {}
        }
        return new GnuMakefileGenerator();
    }

    public void setBuildFileGeneratorElement(IConfigurationElement element) {
        this.buildFileGeneratorElement = element;
        this.setDirty(true);
    }

    public boolean isExtensionElement() {
        return this.isExtensionBuilder;
    }

    public boolean isDirty() {
        if (this.isExtensionBuilder) {
            return false;
        }
        return this.isDirty;
    }

    public void setDirty(boolean isDirty) {
        this.isDirty = isDirty;
    }

    public void resolveReferences() {
        if (!this.resolved) {
            this.resolved = true;
            if (this.superClassId != null && this.superClassId.length() > 0) {
                this.superClass = ManagedBuildManager.getExtensionBuilder(this.superClassId);
                if (this.superClass == null) {
                    ManagedBuildManager.OutputResolveError("superClass", this.superClassId, "builder", this.getId());
                }
            }
        }
    }

    public String getConvertToId() {
        if (this.convertToId == null) {
            if (this.superClass != null) {
                return this.superClass.getConvertToId();
            }
            return EMPTY_STRING;
        }
        return this.convertToId;
    }

    public void setConvertToId(String convertToId) {
        if (convertToId == null && this.convertToId == null) {
            return;
        }
        if (convertToId == null || this.convertToId == null || !convertToId.equals(this.convertToId)) {
            this.convertToId = convertToId;
            this.setDirty(true);
        }
    }

    public String getVersionsSupported() {
        if (this.versionsSupported == null) {
            if (this.superClass != null) {
                return this.superClass.getVersionsSupported();
            }
            return EMPTY_STRING;
        }
        return this.versionsSupported;
    }

    public void setVersionsSupported(String versionsSupported) {
        if (versionsSupported == null && this.versionsSupported == null) {
            return;
        }
        if (versionsSupported == null || this.versionsSupported == null || !versionsSupported.equals(this.versionsSupported)) {
            this.versionsSupported = versionsSupported;
            this.setDirty(true);
        }
    }

    public IFileContextBuildMacroValues getFileContextBuildMacroValues() {
        if (this.fileContextBuildMacroValues == null && this.superClass != null) {
            return this.superClass.getFileContextBuildMacroValues();
        }
        return this.fileContextBuildMacroValues;
    }

    public String getBuilderVariablePattern() {
        if (this.builderVariablePattern == null && this.superClass != null) {
            return this.superClass.getBuilderVariablePattern();
        }
        return this.builderVariablePattern;
    }

    public boolean isVariableCaseSensitive() {
        if (this.isVariableCaseSensitive == null) {
            if (this.superClass != null) {
                return this.superClass.isVariableCaseSensitive();
            }
            return true;
        }
        return this.isVariableCaseSensitive;
    }

    public String[] getReservedMacroNames() {
        if (this.reservedMacroNames == null && this.superClass != null) {
            return this.superClass.getReservedMacroNames();
        }
        return this.reservedMacroNames;
    }

    public IReservedMacroNameSupplier getReservedMacroNameSupplier() {
        if (this.reservedMacroNameSupplier == null && this.reservedMacroNameSupplierElement != null) {
            try {
                this.reservedMacroNameSupplier = (IReservedMacroNameSupplier)this.reservedMacroNameSupplierElement.createExecutableExtension("reservedMacroNameSupplier");
            }
            catch (CoreException coreException) {}
        }
        if (this.reservedMacroNameSupplier == null && this.superClass != null) {
            return this.superClass.getReservedMacroNameSupplier();
        }
        return this.reservedMacroNameSupplier;
    }

    public void checkForMigrationSupport() {
        boolean isExists = false;
        if (this.getSuperClass() == null) {
            String high = (String)ManagedBuildManager.getExtensionBuilderMap().lastKey();
            SortedMap subMap = null;
            if (this.superClassId.compareTo(high) > 0) {
                IToolChain parent = this.getParent();
                IConfiguration parentConfig = parent.getParent();
                IManagedProject managedProject = parentConfig.getManagedProject();
                if (managedProject != null) {
                    managedProject.setValid(false);
                }
                return;
            }
            subMap = ManagedBuildManager.getExtensionBuilderMap().subMap(this.superClassId, String.valueOf(high) + "\u0000");
            String baseId = ManagedBuildManager.getIdFromIdAndVersion(this.superClassId);
            String version = ManagedBuildManager.getVersionFromIdAndVersion(this.superClassId);
            IBuilder[] builderElements = (IBuilder[])subMap.values().toArray();
            int i = 0;
            while (i < builderElements.length) {
                String versionsSupported;
                IBuilder builderElement = builderElements[i];
                if (ManagedBuildManager.getIdFromIdAndVersion(builderElement.getId()).compareTo(baseId) > 0) break;
                if (ManagedBuildManager.getIdFromIdAndVersion(builderElement.getId()).equals(baseId) && (versionsSupported = builderElement.getVersionsSupported()) != null && !versionsSupported.equals("")) {
                    String[] tmpVersions = versionsSupported.split(",");
                    int j = 0;
                    while (j < tmpVersions.length) {
                        if (new PluginVersionIdentifier(version).equals((Object)new PluginVersionIdentifier(tmpVersions[j]))) {
                            String supportedVersion = ManagedBuildManager.getVersionFromIdAndVersion(builderElement.getId());
                            this.setId(String.valueOf(ManagedBuildManager.getIdFromIdAndVersion(this.getId())) + "_" + supportedVersion);
                            this.superClass = builderElement;
                            this.superClassId = this.superClass.getId();
                            isExists = true;
                            break;
                        }
                        ++j;
                    }
                    if (isExists) break;
                }
                ++i;
            }
        }
        if (this.getSuperClass() != null) {
            String convertToId = this.getSuperClass().getConvertToId();
            if (convertToId == null || convertToId.equals("")) {
                return;
            }
            this.getConverter(convertToId);
        } else {
            IToolChain parent = this.getParent();
            IConfiguration parentConfig = parent.getParent();
            IManagedProject managedProject = parentConfig.getManagedProject();
            if (managedProject != null) {
                managedProject.setValid(false);
            }
        }
    }

    private void getConverter(String convertToId) {
        IToolChain parent;
        IConfiguration parentConfig;
        IManagedProject managedProject;
        String fromId = null;
        String toId = null;
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.managedbuilder.core", "projectConverter");
        if (extensionPoint != null) {
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    IConfigurationElement element = configElements[j];
                    if (element.getName().equals("converter")) {
                        fromId = element.getAttribute("fromId");
                        toId = element.getAttribute("toId");
                        if (fromId.equals(this.getSuperClass().getId()) && toId.equals(convertToId)) {
                            String mbsVersion = element.getAttribute("mbsVersion");
                            PluginVersionIdentifier currentMbsVersion = ManagedBuildManager.getBuildInfoVersion();
                            if (currentMbsVersion.isGreaterThan(new PluginVersionIdentifier(mbsVersion))) {
                                this.previousMbsVersionConversionElement = element;
                            } else {
                                this.currentMbsVersionConversionElement = element;
                            }
                            return;
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        if ((managedProject = (parentConfig = (parent = this.getParent()).getParent()).getManagedProject()) != null) {
            managedProject.setValid(false);
        }
    }

    public IConfigurationElement getPreviousMbsVersionConversionElement() {
        return this.previousMbsVersionConversionElement;
    }

    public IConfigurationElement getCurrentMbsVersionConversionElement() {
        return this.currentMbsVersionConversionElement;
    }
}

