/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.scannerconfig;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.cdt.make.core.scannerconfig.ScannerInfoTypes;
import org.eclipse.cdt.make.internal.core.scannerconfig.util.TraceUtil;
import org.eclipse.cdt.managedbuilder.scannerconfig.IManagedScannerInfoCollector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

public class DefaultGCCScannerInfoCollector
implements IManagedScannerInfoCollector {
    protected Map definedSymbols;
    protected static final String EQUALS = "=";
    protected List includePaths;
    protected IProject project;

    public void contributeToScannerConfig(Object resource, Map scannerInfo) {
        if (resource != null && resource instanceof IResource && ((IResource)resource).getProject() == this.project) {
            List includes = (List)scannerInfo.get(ScannerInfoTypes.INCLUDE_PATHS);
            List symbols = (List)scannerInfo.get(ScannerInfoTypes.SYMBOL_DEFINITIONS);
            ListIterator pathIter = includes.listIterator();
            while (pathIter.hasNext()) {
                String path = (String)pathIter.next();
                this.getIncludePaths().add(path);
            }
            ListIterator symbolIter = symbols.listIterator();
            while (symbolIter.hasNext()) {
                String[] macroTokens = ((String)symbolIter.next()).split(EQUALS);
                String macro = macroTokens[0].trim();
                String value = macroTokens.length > 1 ? macroTokens[1].trim() : new String();
                this.getDefinedSymbols().put(macro, value);
            }
        }
    }

    public Map getDefinedSymbols() {
        if (this.definedSymbols == null) {
            this.definedSymbols = new HashMap();
        }
        return this.definedSymbols;
    }

    public List getIncludePaths() {
        if (this.includePaths == null) {
            this.includePaths = new ArrayList();
        }
        return this.includePaths;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public List getCollectedScannerInfo(Object resource, ScannerInfoTypes type) {
        ArrayList<String> rv = null;
        String errorMessage = null;
        if (resource == null) {
            errorMessage = "resource is null";
        } else if (!(resource instanceof IResource)) {
            errorMessage = "resource is not an IResource";
        } else if (((IResource)resource).getProject() == null) {
            errorMessage = "project is null";
        } else if (((IResource)resource).getProject() != this.project) {
            errorMessage = "wrong project";
        }
        if (errorMessage != null) {
            TraceUtil.outputError((String)"DefaultGCCScannerInfoCollector.getCollectedScannerInfo : ", (String)errorMessage);
        } else if (type.equals(ScannerInfoTypes.INCLUDE_PATHS)) {
            rv = this.getIncludePaths();
        } else if (type.equals(ScannerInfoTypes.SYMBOL_DEFINITIONS)) {
            rv = new ArrayList<String>();
            Map symbols = this.getDefinedSymbols();
            Iterator i = symbols.keySet().iterator();
            while (i.hasNext()) {
                String macro = (String)i.next();
                String value = (String)symbols.get(macro);
                if (value.length() > 0) {
                    rv.add(String.valueOf(macro) + EQUALS + value);
                    continue;
                }
                rv.add(macro);
            }
        } else {
            rv = new ArrayList();
        }
        return rv;
    }
}

