/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.makegen.gnu;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IAdditionalInput;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IInputType;
import org.eclipse.cdt.managedbuilder.core.IManagedOutputNameProvider;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOutputType;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedMakeMessages;
import org.eclipse.cdt.managedbuilder.internal.core.Tool;
import org.eclipse.cdt.managedbuilder.internal.macros.OptionContextData;
import org.eclipse.cdt.managedbuilder.macros.BuildMacroException;
import org.eclipse.cdt.managedbuilder.makegen.IManagedDependencyGenerator;
import org.eclipse.cdt.managedbuilder.makegen.gnu.GnuMakefileGenerator;
import org.eclipse.cdt.managedbuilder.makegen.gnu.IManagedBuildGnuToolInfo;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class ManagedBuildGnuToolInfo
implements IManagedBuildGnuToolInfo {
    private static final String DEPS_MACRO = "DEPS";
    private IProject project;
    private Tool tool;
    private boolean bIsTargetTool;
    private String targetName;
    private String targetExt;
    private boolean inputsCalculated = false;
    private boolean outputsCalculated = false;
    private boolean outputVariablesCalculated = false;
    private boolean dependenciesCalculated = false;
    private Vector commandInputs = new Vector();
    private Vector enumeratedInputs = new Vector();
    private Vector commandOutputs = new Vector();
    private Vector enumeratedPrimaryOutputs = new Vector();
    private Vector enumeratedSecondaryOutputs = new Vector();
    private Vector outputVariables = new Vector();
    private Vector commandDependencies = new Vector();

    public ManagedBuildGnuToolInfo(IProject project, ITool tool, boolean targetTool, String name, String ext) {
        this.project = project;
        this.tool = (Tool)tool;
        this.bIsTargetTool = targetTool;
        if (this.bIsTargetTool) {
            this.targetName = name;
            this.targetExt = ext;
        }
    }

    public boolean areInputsCalculated() {
        return this.inputsCalculated;
    }

    public Vector getCommandInputs() {
        return this.commandInputs;
    }

    public Vector getEnumeratedInputs() {
        return this.enumeratedInputs;
    }

    public boolean areOutputsCalculated() {
        return this.outputsCalculated;
    }

    public Vector getCommandOutputs() {
        return this.commandOutputs;
    }

    public Vector getEnumeratedPrimaryOutputs() {
        return this.enumeratedPrimaryOutputs;
    }

    public Vector getEnumeratedSecondaryOutputs() {
        return this.enumeratedSecondaryOutputs;
    }

    public Vector getOutputVariables() {
        return this.outputVariables;
    }

    public boolean areOutputVariablesCalculated() {
        return this.outputVariablesCalculated;
    }

    public boolean areDependenciesCalculated() {
        return this.dependenciesCalculated;
    }

    public Vector getCommandDependencies() {
        return this.commandDependencies;
    }

    public boolean isTargetTool() {
        return this.bIsTargetTool;
    }

    public boolean calculateInputs(GnuMakefileGenerator makeGen, IConfiguration config, IResource[] projResources, boolean lastChance) {
        boolean done = true;
        Vector myCommandInputs = new Vector();
        Vector myCommandDependencies = new Vector();
        Vector myEnumeratedInputs = new Vector();
        IInputType[] inTypes = this.tool.getInputTypes();
        if (inTypes != null && inTypes.length > 0) {
            int i = 0;
            while (i < inTypes.length) {
                IAdditionalInput[] addlInputs;
                int optType;
                IInputType type = inTypes[i];
                Vector<String> itCommandInputs = new Vector<String>();
                Vector<String> itCommandDependencies = new Vector<String>();
                Vector<String> itEnumeratedInputs = new Vector<String>();
                String variable = type.getBuildVariable();
                boolean primaryInput = type.getPrimaryInput();
                boolean useFileExts = false;
                IOption option = this.tool.getOptionBySuperClassId(type.getOptionId());
                IOption assignToOption = this.tool.getOptionBySuperClassId(type.getAssignToOptionId());
                if (option != null) {
                    try {
                        List inputs = new ArrayList<String>();
                        optType = option.getValueType();
                        if (optType == 2) {
                            inputs.add(option.getStringValue());
                        } else if (optType == 3 || optType == 6 || optType == 7) {
                            inputs = (List)option.getValue();
                        }
                        int j = 0;
                        while (j < inputs.size()) {
                            String inputName = (String)inputs.get(j);
                            try {
                                String resolved = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(inputName, "", " ", 2, new OptionContextData(option, config.getToolChain()));
                                resolved = resolved.trim();
                                if (resolved.length() > 0) {
                                    inputName = resolved;
                                }
                            }
                            catch (BuildMacroException buildMacroException) {}
                            if (primaryInput) {
                                itCommandDependencies.add(j, inputName);
                            } else {
                                itCommandDependencies.add(inputName);
                            }
                            ++j;
                        }
                    }
                    catch (BuildException buildException) {}
                } else {
                    if (variable.length() > 0) {
                        String cmdVariable = variable = "$(" + variable + ")";
                        itCommandInputs.add(cmdVariable);
                        if (primaryInput) {
                            itCommandDependencies.add(0, cmdVariable);
                        } else {
                            itCommandDependencies.add(cmdVariable);
                        }
                        List outMacroList = makeGen.getBuildVariableList(variable, 1, null, true);
                        if (outMacroList != null) {
                            itEnumeratedInputs.addAll(outMacroList);
                        } else {
                            if (!lastChance) {
                                done = false;
                                break;
                            }
                            useFileExts = true;
                        }
                    }
                    if (variable.length() == 0 || useFileExts) {
                        HashSet<String> handledInputExtensions = new HashSet<String>();
                        String[] exts = type.getSourceExtensions(this.tool);
                        if (projResources != null) {
                            int j = 0;
                            while (j < projResources.length) {
                                if (projResources[j].getType() == 1) {
                                    String fileExt = projResources[j].getFileExtension();
                                    if (fileExt == null) {
                                        fileExt = "";
                                    }
                                    int k = 0;
                                    while (k < exts.length) {
                                        if (fileExt.equals(exts[k])) {
                                            if (!useFileExts && !handledInputExtensions.contains(fileExt)) {
                                                handledInputExtensions.add(fileExt);
                                                String buildMacro = "$(" + makeGen.getSourceMacroName(fileExt).toString() + ")";
                                                itCommandInputs.add(buildMacro);
                                                if (primaryInput) {
                                                    itCommandDependencies.add(0, buildMacro);
                                                } else {
                                                    itCommandDependencies.add(buildMacro);
                                                }
                                            }
                                            if (!type.getMultipleOfType() && itEnumeratedInputs.size() != 0) break;
                                            itEnumeratedInputs.add(projResources[j].getProjectRelativePath().toString());
                                            break;
                                        }
                                        ++k;
                                    }
                                }
                                ++j;
                            }
                        }
                    }
                }
                if ((addlInputs = type.getAdditionalInputs()) != null) {
                    int j = 0;
                    while (j < addlInputs.length) {
                        String[] paths;
                        IAdditionalInput addlInput = addlInputs[j];
                        int kind = addlInput.getKind();
                        if ((kind == 2 || kind == 3) && (paths = addlInput.getPaths()) != null) {
                            int k = 0;
                            while (k < paths.length) {
                                IPath addlPath;
                                IFile addlResource;
                                String path = paths[k];
                                itEnumeratedInputs.add(path);
                                if (!path.startsWith("$(") && (addlResource = this.project.getFile(path)) != null && (addlPath = addlResource.getLocation()) != null) {
                                    path = ManagedBuildManager.calculateRelativePath(makeGen.getTopBuildDir(), addlPath).toString();
                                }
                                itCommandInputs.add(path);
                                ++k;
                            }
                        }
                        ++j;
                    }
                }
                if (assignToOption != null && option == null) {
                    try {
                        optType = assignToOption.getValueType();
                        if (optType == 2) {
                            String optVal = "";
                            int j = 0;
                            while (j < itCommandInputs.size()) {
                                if (j != 0) {
                                    optVal = String.valueOf(optVal) + " ";
                                }
                                optVal = String.valueOf(optVal) + itCommandInputs.get(j);
                                ++j;
                            }
                            ManagedBuildManager.setOption(config, (IHoldsOptions)this.tool, assignToOption, optVal);
                        } else if (optType == 3 || optType == 6 || optType == 7) {
                            String[] paths = new String[itEnumeratedInputs.size()];
                            int j = 0;
                            while (j < itEnumeratedInputs.size()) {
                                IPath enumPath;
                                paths[j] = (String)itEnumeratedInputs.get(j);
                                IFile enumResource = this.project.getFile(paths[j]);
                                if (enumResource != null && (enumPath = enumResource.getLocation()) != null) {
                                    paths[j] = ManagedBuildManager.calculateRelativePath(makeGen.getTopBuildDir(), enumPath).toString();
                                }
                                ++j;
                            }
                            ManagedBuildManager.setOption(config, (IHoldsOptions)this.tool, assignToOption, paths);
                        } else if (optType == 0) {
                            if (itEnumeratedInputs.size() > 0) {
                                ManagedBuildManager.setOption(config, (IHoldsOptions)this.tool, assignToOption, true);
                            } else {
                                ManagedBuildManager.setOption(config, (IHoldsOptions)this.tool, assignToOption, false);
                            }
                        } else if (optType == 1 && itCommandInputs.size() > 0) {
                            ManagedBuildManager.setOption(config, (IHoldsOptions)this.tool, assignToOption, (String)itCommandInputs.firstElement());
                        }
                        itCommandInputs.removeAllElements();
                    }
                    catch (BuildException buildException) {}
                }
                myCommandInputs.addAll(itCommandInputs);
                myCommandDependencies.addAll(itCommandDependencies);
                myEnumeratedInputs.addAll(itEnumeratedInputs);
                ++i;
            }
        } else if (this.bIsTargetTool) {
            myCommandInputs.add("$(OBJS)");
            myCommandInputs.add("$(USER_OBJS)");
            myCommandInputs.add("$(LIBS)");
        }
        if (done) {
            this.commandInputs.addAll(myCommandInputs);
            this.commandDependencies.addAll(0, myCommandDependencies);
            this.enumeratedInputs.addAll(myEnumeratedInputs);
            this.inputsCalculated = true;
            return true;
        }
        return false;
    }

    public boolean calculateOutputs(GnuMakefileGenerator makeGen, IConfiguration config, HashSet handledInputExtensions, boolean lastChance) {
        boolean done = true;
        Vector<Object> myCommandOutputs = new Vector<Object>();
        Vector myEnumeratedPrimaryOutputs = new Vector();
        Vector myEnumeratedSecondaryOutputs = new Vector();
        HashMap<String, List> myOutputMacros = new HashMap<String, List>();
        Vector<String> myBuildVars = new Vector<String>();
        Vector myBuildVarsValues = new Vector();
        IOutputType[] outTypes = this.tool.getOutputTypes();
        if (outTypes != null && outTypes.length > 0) {
            int i = 0;
            while (i < outTypes.length) {
                boolean primaryOutput;
                String variable;
                Vector<String> typeEnumeratedOutputs;
                block74: {
                    typeEnumeratedOutputs = new Vector<String>();
                    IOutputType type = outTypes[i];
                    String outputPrefix = type.getOutputPrefix();
                    if (config != null) {
                        try {
                            outputPrefix = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(outputPrefix, "", " ", 3, config);
                        }
                        catch (BuildMacroException buildMacroException) {}
                    }
                    variable = type.getBuildVariable();
                    boolean multOfType = type.getMultipleOfType();
                    primaryOutput = type == this.tool.getPrimaryOutputType();
                    IOption option = this.tool.getOptionBySuperClassId(type.getOptionId());
                    IManagedOutputNameProvider nameProvider = type.getNameProvider();
                    String[] outputNames = type.getOutputNames();
                    if (this.bIsTargetTool && primaryOutput) {
                        String outputName = String.valueOf(outputPrefix) + this.targetName;
                        if (this.targetExt.length() > 0) {
                            outputName = String.valueOf(outputName) + "." + this.targetExt;
                        }
                        myCommandOutputs.add(outputName);
                        typeEnumeratedOutputs.add(outputName);
                    } else if (option != null) {
                        try {
                            int j;
                            List<String> outputs = new ArrayList<String>();
                            int optType = option.getValueType();
                            if (optType == 2) {
                                outputs.add(String.valueOf(outputPrefix) + option.getStringValue());
                            } else if (optType == 3 || optType == 6 || optType == 7) {
                                outputs = (List)option.getValue();
                                if (outputPrefix.length() > 0) {
                                    j = 0;
                                    while (j < outputs.size()) {
                                        outputs.set(j, String.valueOf(outputPrefix) + outputs.get(j));
                                        ++j;
                                    }
                                }
                            }
                            j = 0;
                            while (j < outputs.size()) {
                                String outputName = (String)outputs.get(j);
                                try {
                                    String resolved = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(outputName, "", " ", 2, new OptionContextData(option, config.getToolChain()));
                                    resolved = resolved.trim();
                                    if (resolved.length() > 0) {
                                        outputs.set(j, resolved);
                                    }
                                }
                                catch (BuildMacroException buildMacroException) {}
                                ++j;
                            }
                            typeEnumeratedOutputs.addAll(outputs);
                            if (variable.length() <= 0) break block74;
                            ArrayList<IPath> outputPaths = new ArrayList<IPath>();
                            int j2 = 0;
                            while (j2 < outputs.size()) {
                                outputPaths.add(Path.fromOSString((String)((String)outputs.get(j2))));
                                ++j2;
                            }
                            if (myOutputMacros.containsKey(variable)) {
                                List currList = (List)myOutputMacros.get(variable);
                                currList.addAll(outputPaths);
                                myOutputMacros.put(variable, currList);
                                break block74;
                            }
                            myOutputMacros.put(variable, outputPaths);
                        }
                        catch (BuildException buildException) {}
                    } else if (nameProvider != null) {
                        IPath[] outNames = null;
                        if (!this.inputsCalculated) {
                            done = false;
                        } else {
                            Vector inputs = this.getEnumeratedInputs();
                            IPath[] inputPaths = new IPath[inputs.size()];
                            int j = 0;
                            while (j < inputPaths.length) {
                                inputPaths[j] = Path.fromOSString((String)((String)inputs.get(j)));
                                ++j;
                            }
                            outNames = nameProvider.getOutputNames(this.tool, inputPaths);
                            if (outNames != null) {
                                j = 0;
                                while (j < outNames.length) {
                                    String outputName = outNames[j].toString();
                                    try {
                                        String resolved = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(outputName, "", " ", 3, config);
                                        resolved = resolved.trim();
                                        if (resolved.length() > 0) {
                                            outputName = resolved;
                                            outNames[j] = Path.fromOSString((String)resolved);
                                        }
                                    }
                                    catch (BuildMacroException buildMacroException) {}
                                    if (primaryOutput) {
                                        myCommandOutputs.add(outputName);
                                    }
                                    typeEnumeratedOutputs.add(outputName);
                                    ++j;
                                }
                            }
                        }
                        if (variable.length() > 0 && outNames != null) {
                            if (myOutputMacros.containsKey(variable)) {
                                List currList = (List)myOutputMacros.get(variable);
                                currList.addAll(Arrays.asList(outNames));
                                myOutputMacros.put(variable, currList);
                            } else {
                                myOutputMacros.put(variable, Arrays.asList(outNames));
                            }
                        }
                    } else if (outputNames != null) {
                        if (outputNames.length > 0) {
                            int j = 0;
                            while (j < outputNames.length) {
                                String outputName = outputNames[j];
                                try {
                                    String resolved = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(outputName, "", " ", 2, new OptionContextData(option, config.getToolChain()));
                                    resolved = resolved.trim();
                                    if (resolved.length() > 0) {
                                        outputNames[j] = resolved;
                                    }
                                }
                                catch (BuildMacroException buildMacroException) {}
                                ++j;
                            }
                            List<String> namesList = Arrays.asList(outputNames);
                            if (primaryOutput) {
                                myCommandOutputs.addAll(namesList);
                            }
                            typeEnumeratedOutputs.addAll(namesList);
                            if (variable.length() > 0) {
                                ArrayList<IPath> outputPaths = new ArrayList<IPath>();
                                int j3 = 0;
                                while (j3 < namesList.size()) {
                                    outputPaths.add(Path.fromOSString((String)namesList.get(j3)));
                                    ++j3;
                                }
                                if (myOutputMacros.containsKey(variable)) {
                                    List currList = (List)myOutputMacros.get(variable);
                                    currList.addAll(outputPaths);
                                    myOutputMacros.put(variable, currList);
                                } else {
                                    myOutputMacros.put(variable, outputPaths);
                                }
                            }
                        }
                    } else if (multOfType) {
                        ArrayList<String> errList = new ArrayList<String>();
                        errList.add(ManagedMakeMessages.getResourceString("MakefileGenerator.error.no.nameprovider"));
                        myCommandOutputs.add(errList);
                    } else {
                        String namePattern = type.getNamePattern();
                        if (namePattern == null || namePattern.length() == 0) {
                            namePattern = String.valueOf(outputPrefix) + "%";
                            String outExt = type.getOutputExtensions(this.tool)[0];
                            if (outExt != null && outExt.length() > 0) {
                                namePattern = String.valueOf(namePattern) + "." + outExt;
                            }
                        } else if (outputPrefix.length() > 0) {
                            namePattern = String.valueOf(outputPrefix) + namePattern;
                        }
                        if (!this.inputsCalculated) {
                            done = false;
                        } else {
                            String fileName;
                            Vector inputs = this.getEnumeratedInputs();
                            if (inputs.size() > 0) {
                                fileName = Path.fromOSString((String)((String)inputs.get(0))).removeFileExtension().lastSegment();
                                if (fileName.startsWith("$(") && fileName.endsWith(")")) {
                                    fileName = fileName.substring(2, fileName.length() - 1);
                                }
                            } else {
                                fileName = "default";
                            }
                            if (primaryOutput) {
                                myCommandOutputs.add(namePattern.replaceAll("%", fileName));
                            }
                            typeEnumeratedOutputs.add(namePattern.replaceAll("%", fileName));
                            if (variable.length() > 0) {
                                ArrayList<IPath> outputs = new ArrayList<IPath>();
                                outputs.add(Path.fromOSString((String)fileName));
                                if (myOutputMacros.containsKey(variable)) {
                                    List currList = (List)myOutputMacros.get(variable);
                                    currList.addAll(outputs);
                                    myOutputMacros.put(variable, currList);
                                } else {
                                    myOutputMacros.put(variable, outputs);
                                }
                            }
                        }
                    }
                }
                if (variable.length() > 0) {
                    myBuildVars.add(variable);
                    myBuildVarsValues.add(typeEnumeratedOutputs);
                }
                if (primaryOutput) {
                    myEnumeratedPrimaryOutputs.addAll(typeEnumeratedOutputs);
                } else {
                    myEnumeratedSecondaryOutputs.addAll(typeEnumeratedOutputs);
                }
                ++i;
            }
        } else if (this.bIsTargetTool) {
            String outputPrefix = this.tool.getOutputPrefix();
            String outputName = String.valueOf(outputPrefix) + this.targetName;
            if (this.targetExt.length() > 0) {
                outputName = String.valueOf(outputName) + "." + this.targetExt;
            }
            myCommandOutputs.add(outputName);
            myEnumeratedPrimaryOutputs.add(outputName);
        }
        Iterator iterator = myOutputMacros.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String macroName = (String)entry.getKey();
            List newMacroValue = (List)entry.getValue();
            HashMap map = makeGen.getBuildOutputVars();
            if (map.containsKey(macroName)) {
                List macroValue = (List)map.get(macroName);
                macroValue.addAll(newMacroValue);
                map.put(macroName, macroValue);
                continue;
            }
            map.put(macroName, newMacroValue);
        }
        this.outputVariablesCalculated = true;
        if (done) {
            this.commandOutputs.addAll(myCommandOutputs);
            this.enumeratedPrimaryOutputs.addAll(myEnumeratedPrimaryOutputs);
            this.enumeratedSecondaryOutputs.addAll(myEnumeratedSecondaryOutputs);
            this.outputVariables.addAll(myOutputMacros.keySet());
            this.outputsCalculated = true;
            int i = 0;
            while (i < myBuildVars.size()) {
                makeGen.addMacroAdditionFiles(makeGen.getTopBuildOutputVars(), (String)myBuildVars.get(i), (Vector)myBuildVarsValues.get(i));
                ++i;
            }
            return true;
        }
        return false;
    }

    public boolean calculateDependencies(GnuMakefileGenerator makeGen, HashSet handledInputExtensions, boolean lastChance) {
        boolean done = true;
        Vector<String> myCommandDependencies = new Vector<String>();
        HashMap<String, List> myOutputMacros = new HashMap<String, List>();
        IInputType[] inTypes = this.tool.getInputTypes();
        if (inTypes != null && inTypes.length > 0) {
            int i = 0;
            while (i < inTypes.length) {
                IAdditionalInput[] addlInputs;
                IInputType type = inTypes[i];
                IManagedDependencyGenerator depGen = type.getDependencyGenerator();
                if (depGen != null) {
                    int calcType = depGen.getCalculatorType();
                    switch (calcType) {
                        case 1: {
                            String[] extensionsList = type.getSourceExtensions(this.tool);
                            int j = 0;
                            while (j < extensionsList.length) {
                                String extensionName = extensionsList[j];
                                if (!makeGen.getOutputExtensions().contains(extensionName) && !handledInputExtensions.contains(extensionName)) {
                                    handledInputExtensions.add(extensionName);
                                    String depsMacro = this.calculateSourceMacro(makeGen, extensionName, "d", "%");
                                    ArrayList<IPath> depsList = new ArrayList<IPath>();
                                    depsList.add(Path.fromOSString((String)depsMacro));
                                    if (myOutputMacros.containsKey(DEPS_MACRO)) {
                                        List currList = (List)myOutputMacros.get(DEPS_MACRO);
                                        currList.addAll(depsList);
                                        myOutputMacros.put(DEPS_MACRO, currList);
                                    } else {
                                        myOutputMacros.put(DEPS_MACRO, depsList);
                                    }
                                }
                                ++j;
                            }
                            break;
                        }
                        case 2: 
                        case 3: {
                            if (!this.inputsCalculated) {
                                done = false;
                                break;
                            }
                            Vector inputs = this.getEnumeratedInputs();
                            int j = 0;
                            while (j < inputs.size()) {
                                IResource[] outNames = depGen.findDependencies((IResource)this.project.getFile((String)inputs.get(j)), this.project);
                                if (outNames != null) {
                                    int k = 0;
                                    while (k < outNames.length) {
                                        myCommandDependencies.add(outNames[k].toString());
                                        ++k;
                                    }
                                }
                                ++j;
                            }
                            break;
                        }
                    }
                }
                if ((addlInputs = type.getAdditionalInputs()) != null && addlInputs.length > 0) {
                    int j = 0;
                    while (j < addlInputs.length) {
                        String[] paths;
                        IAdditionalInput addlInput = addlInputs[j];
                        int kind = addlInput.getKind();
                        if ((kind == 1 || kind == 3) && (paths = addlInput.getPaths()) != null) {
                            int k = 0;
                            while (k < paths.length) {
                                IPath addlPath;
                                IFile addlResource;
                                String path = paths[k];
                                if (!path.startsWith("$(") && (addlResource = this.project.getFile(path)) != null && (addlPath = addlResource.getLocation()) != null) {
                                    path = ManagedBuildManager.calculateRelativePath(makeGen.getTopBuildDir(), addlPath).toString();
                                }
                                myCommandDependencies.add(path);
                                ++k;
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
        } else if (this.bIsTargetTool) {
            myCommandDependencies.add("$(OBJS)");
            myCommandDependencies.add("$(USER_OBJS)");
        } else {
            String[] extensionsList = this.tool.getAllInputExtensions();
            IManagedDependencyGenerator depGen = this.tool.getDependencyGenerator();
            if (depGen != null) {
                int calcType = depGen.getCalculatorType();
                switch (calcType) {
                    case 1: {
                        int i = 0;
                        while (i < extensionsList.length) {
                            String extensionName = extensionsList[i];
                            if (!makeGen.getOutputExtensions().contains(extensionName) && !handledInputExtensions.contains(extensionName)) {
                                handledInputExtensions.add(extensionName);
                                String depsMacro = this.calculateSourceMacro(makeGen, extensionName, "d", "%");
                                ArrayList<IPath> depsList = new ArrayList<IPath>();
                                depsList.add(Path.fromOSString((String)depsMacro));
                                if (myOutputMacros.containsKey(DEPS_MACRO)) {
                                    List currList = (List)myOutputMacros.get(DEPS_MACRO);
                                    currList.addAll(depsList);
                                    myOutputMacros.put(DEPS_MACRO, currList);
                                } else {
                                    myOutputMacros.put(DEPS_MACRO, depsList);
                                }
                            }
                            ++i;
                        }
                        break;
                    }
                    case 2: 
                    case 3: {
                        if (!this.inputsCalculated) {
                            done = false;
                            break;
                        }
                        Vector inputs = this.getEnumeratedInputs();
                        int j = 0;
                        while (j < inputs.size()) {
                            IResource[] outNames = depGen.findDependencies((IResource)this.project.getFile((String)inputs.get(j)), this.project);
                            if (outNames != null) {
                                int k = 0;
                                while (k < outNames.length) {
                                    myCommandDependencies.add(outNames[k].toString());
                                    ++k;
                                }
                            }
                            ++j;
                        }
                        break;
                    }
                }
            }
        }
        Iterator iterator = myOutputMacros.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String macroName = (String)entry.getKey();
            List newMacroValue = (List)entry.getValue();
            HashMap map = makeGen.getBuildOutputVars();
            if (map.containsKey(macroName)) {
                List macroValue = (List)map.get(macroName);
                macroValue.addAll(newMacroValue);
                map.put(macroName, macroValue);
                continue;
            }
            map.put(macroName, newMacroValue);
        }
        if (done) {
            this.commandDependencies.addAll(myCommandDependencies);
            this.dependenciesCalculated = true;
            return true;
        }
        return false;
    }

    protected String calculateSourceMacro(GnuMakefileGenerator makeGen, String srcExtensionName, String outExtensionName, String wildcard) {
        StringBuffer macroName = makeGen.getSourceMacroName(srcExtensionName);
        String OptDotExt = "";
        if (outExtensionName != null) {
            OptDotExt = "." + outExtensionName;
        } else if (this.tool.getOutputExtension(srcExtensionName) != "") {
            OptDotExt = "." + this.tool.getOutputExtension(srcExtensionName);
        }
        StringBuffer objectsBuffer = new StringBuffer();
        objectsBuffer.append(" $(" + macroName + ":" + "$(ROOT)" + "/" + "%" + "." + srcExtensionName + "=" + wildcard + OptDotExt + ")");
        return objectsBuffer.toString();
    }
}

